import _extends from '@babel/runtime/helpers/extends';
import _objectWithoutProperties from '@babel/runtime/helpers/objectWithoutProperties';
import React__default from 'react';
import Popover from '../Popover/index.js';
import ButtonBase from '../ButtonBase/index.js';
import SvgInfo from '../../assets/svgs/info.svg.js';
import PropTypes from 'prop-types';
import './TooltipInfo.scss.js';

/** Tooltip info  */

var TooltipInfo = function TooltipInfo(_ref) {
  var popoverClass = _ref.popoverClass,
      children = _ref.children,
      trigger = _ref.trigger,
      className = _ref.className,
      label = _ref.label,
      rest = _objectWithoutProperties(_ref, ["popoverClass", "children", "trigger", "className", "label"]);

  return /*#__PURE__*/React__default.createElement("div", {
    className: "Suc-tooltip-info-container ".concat(className)
  }, label && /*#__PURE__*/React__default.createElement("label", null, label), /*#__PURE__*/React__default.createElement(Popover, _extends({
    popoverClass: "Suc-tooltip-info ".concat(popoverClass),
    trigger: trigger,
    containerClass: "Suc-info-button",
    container: /*#__PURE__*/React__default.createElement(ButtonBase, {
      type: "button"
    }, /*#__PURE__*/React__default.createElement(SvgInfo, null))
  }, rest), children));
};

TooltipInfo.propTypes = {
  /** popover trigger */
  trigger: PropTypes.oneOf(['hover', 'click']),

  /** popover custom classname */
  popoverClass: PropTypes.string,

  /** trigger element custom classname */
  className: PropTypes.string,

  /** label */
  label: PropTypes.node,

  /** preferred placement of the tooltip */
  placement: PropTypes.oneOf(['top', 'right', 'left', 'bottom'])
};
TooltipInfo.defaultProps = {
  className: '',
  popoverClass: '',
  trigger: 'hover'
};

export default TooltipInfo;
//# sourceMappingURL=index.js.map
