import { useEffect, useRef } from 'react'

export const OccmActions = {
  ready: 'SERVICE:READY',
  navigate: 'SERVICE:NAVIGATE'
}
export const postOccmMessage = ({ type, payload }) => {
  window.parent.postMessage({ type, payload }, '*')
  console.log(`fire OCCM event ${type} ${payload ? JSON.stringify(payload) : ''}`)
}

const useHandleOccmMessages = (eventHandlers) => {
  const eventsHandlersRef = useRef(eventHandlers)
  eventsHandlersRef.current = eventHandlers

  useEffect(() => {
    const messageHandler = (event) => {
      const { onConnectorChange, onWorkspaceChange, onTokenUpdate } = eventsHandlersRef.current
      const { type, payload } = event.data
      switch (type) {
        case 'CONNECTOR-CHANGE':
          onConnectorChange(payload?.connectorId)
          break
        case 'WORKSPACE-CHANGE':
          onWorkspaceChange(payload?.workspaceId)
          break
        case 'TOKEN-UPDATE':
          const { accessToken, userMetadata } = payload
          onTokenUpdate({ accessToken, userMetadata })
          break
        default:
      }
    }
    window.addEventListener('message', messageHandler, false)
    return () => window.removeEventListener('message', messageHandler, false)
  }, [])
}

export default useHandleOccmMessages
