# UI components library for NetApp services
According to the design system: https://app.zeplin.io/project/5ea7d441bdc2d3258748326f

## Install
install the library in your service by simply running the following command:
```bash
npm install git+http://stash.tlveng.netapp.com/scm/suc/shared-ui-components.git#[version]
```
> Check the latest version of the library from bitbucket and replace the '[version]' in the command for example 'v0.7.10'
>When updating the library to a newer version, simply update the version in package.json and run 'npm run update --legacy-peer-deps'
## Usage example
```jsx
import React, { Component } from 'react'

import {Button} from '@netapp/shared-components'
import ButtonBase from '@netapp/shared-components/components/ButtonBase'
import ByolIcon from 'shared-components/assets/svgs/byol.svg'

const Example = ()=>(
<>
<Byol />
<ByolIcon />
</>)
```
>You may find all available components at http://netapp-shared-ui.s3-website.eu-west-3.amazonaws.com

## Editing/Adding Components
```bash
git clone http://stash.tlveng.netapp.com/scm/suc/shared-ui-components.git
```
1. Open a relevant jira on SUC board (http://jira.tlveng.netapp.com/secure/RapidBoard.jspa)
2. Please develop in a side branch, [JIRA_NUMBER]_[task_description]
3. Each component should include:
    1. Default props
    2. PropTypes defined
    3. Comments describing what is the component and for the props(see other components as example)
    4. A stroy including all possible variations of the component, if user interaction is required to achieve several variations, you may use puppeteer test(https://pptr.dev/)
    5. Adding the component to index.js
    6. run script 'test' from package.json,if there are failures review them, fix if there are unintentional changes
    7. run script 'test-fix', it will create new baseline for all tests
    8. run script 'build', then commit with the jira name, and very detailed explanation of what changed
    9. push changes
4. Submit a PR to master branch
5. Once the PR has been reviewed and merged:
    1. From 'master' branch
    2. If there are breaking changes run script 'version-minor', otherwise 'version-patch'
    3. Push changes with tag (git push --tags)
>If you are missing permissions for bitbucket or jira talk with Dan Hilerowicz
 ### Tests
We are using 3 kinds of tests:
1. Visual testing - each story generate a screenshot and compare it with the baseline saved in '__image_snapshots__', it will fail if there are significant changes, failed tests screenshots will be saved in '__dif_output__' library - zero code zero maintenance :-)
2. Snapshot testing - each stOry generate a snapshot (html markup) and compare it with the baseline saved in '__snapshots__' any difference will fail the test, and will show the diff in the console - zero code zero maintenance :-)
3. Puppeteer testing/ Interaction testing - for components that need user interaction (click, hover) to see some variations of the components, use puppeteer to simulate the user action and then call for 'compareSnapshotAndScreenshot()' which will generate a screenshot and snapshot, Example:
```jsx
// At the story, see Select.stories.js for full working example
[story-name].parameters = {
  async puppeteerTest(page) {
    const element = await page.$('.Suc-Select-container')
    await element.click() // open select menu
    await compareSnapshotAndScreenshot(page)
  }
}
```
> You may find the documentation for puppeteer testing at https://pptr.dev/
## License

MIT © [](https://github.com/)
