import _extends from '@babel/runtime/helpers/extends';
import _objectWithoutProperties from '@babel/runtime/helpers/objectWithoutProperties';
import React__default from 'react';
import './buttonBase.scss.js';
import PropTypes from 'prop-types';

/** button base used for any clickable element which doesnt look like a button  */

var ButtonBase = function ButtonBase(_ref) {
  var children = _ref.children,
      className = _ref.className,
      rest = _objectWithoutProperties(_ref, ["children", "className"]);

  return /*#__PURE__*/React__default.createElement("button", _extends({
    className: "Suc-button-base ".concat(className)
  }, rest), children);
};

ButtonBase.propTypes = {
  /** custom classname */
  className: PropTypes.string
};
ButtonBase.defaultProps = {
  className: ''
};

export default ButtonBase;
//# sourceMappingURL=index.js.map
