import _extends from '@babel/runtime/helpers/extends';
import _objectWithoutProperties from '@babel/runtime/helpers/objectWithoutProperties';
import React__default from 'react';
import SvgSpinner from '../../assets/svgs/spinner.svg.js';
import PropTypes from 'prop-types';
import './buttonSpinnerLoader.scss.js';

/** Spinner Loader  */

var ButtonSpinnerLoader = function ButtonSpinnerLoader(_ref) {
  var className = _ref.className,
      variant = _ref.variant,
      props = _objectWithoutProperties(_ref, ["className", "variant"]);

  return /*#__PURE__*/React__default.createElement("div", _extends({
    className: "Suc-button-spinner-loader ".concat(className, " Suc-").concat(variant)
  }, props), /*#__PURE__*/React__default.createElement(SvgSpinner, null));
};

ButtonSpinnerLoader.propTypes = {
  /** variant of spinner */
  variant: PropTypes.oneOf(['stand-alone', 'button-loader']),

  /** custom classname */
  className: PropTypes.string
};
ButtonSpinnerLoader.defaultProps = {
  variant: 'stand-alone',
  className: ''
};

export default ButtonSpinnerLoader;
//# sourceMappingURL=index.js.map
