import _extends from '@babel/runtime/helpers/extends';
import _objectWithoutProperties from '@babel/runtime/helpers/objectWithoutProperties';
import React__default from 'react';
import PropTypes from 'prop-types';
import FieldExtra from '../FieldExtra/index.js';
import './checkBox.scss.js';

var CheckBox = function CheckBox(_ref) {
  var name = _ref.name,
      value = _ref.value,
      onChange = _ref.onChange,
      error = _ref.error,
      warning = _ref.warning,
      checked = _ref.checked,
      disabled = _ref.disabled,
      disabledTitle = _ref.disabledTitle,
      className = _ref.className,
      children = _ref.children,
      rest = _objectWithoutProperties(_ref, ["name", "value", "onChange", "error", "warning", "checked", "disabled", "disabledTitle", "className", "children"]);

  return /*#__PURE__*/React__default.createElement("div", {
    className: "Suc-checkbox-container"
  }, /*#__PURE__*/React__default.createElement("label", {
    className: "Suc-checkbox ".concat(className, " ").concat(disabled ? 'disabled' : '', " ").concat(checked ? 'active' : ''),
    title: disabled ? disabledTitle : ''
  }, /*#__PURE__*/React__default.createElement("input", _extends({
    checked: checked,
    onChange: onChange,
    readOnly: !onChange,
    type: "checkbox",
    name: name,
    value: value === undefined ? name : value,
    disabled: disabled
  }, rest)), /*#__PURE__*/React__default.createElement("svg", {
    width: "16",
    height: "16",
    viewBox: "0 0 16 16"
  }, /*#__PURE__*/React__default.createElement("path", {
    className: 'on-path',
    d: "M20.222-681H7.778A1.777 1.777 0 0 0 6-679.222v12.444A1.777 1.777 0 0 0 7.778-665h12.444A1.777 1.777 0 0 0 22-666.778v-12.444A1.777 1.777 0 0 0 20.222-681zm-8 12.444L7.778-673l1.253-1.253 3.191 3.182 6.747-6.747 1.253 1.262z",
    transform: "translate(-6 681)"
  }), /*#__PURE__*/React__default.createElement("path", {
    className: 'off-path',
    fill: "#c8c8c8",
    d: "M7.778-680c-.43 0-.778.349-.778.778v12.444c0 .43.349.778.778.778h12.444c.43 0 .778-.349.778-.778v-12.444c0-.43-.349-.778-.778-.778H7.778m0-1h12.444c.987 0 1.778.8 1.778 1.778v12.444c0 .978-.791 1.778-1.778 1.778H7.778C6.79-665 6-665.8 6-666.778v-12.444C6-680.2 6.791-681 7.778-681z",
    transform: "translate(-6 681)"
  })), children), /*#__PURE__*/React__default.createElement(FieldExtra, {
    error: error,
    warning: warning
  }));
};

CheckBox.propTypes = {
  /** checked or unchecked */
  checked: PropTypes.bool,

  /** disabled state */
  disabled: PropTypes.bool,

  /** custom classname */
  className: PropTypes.string,

  /** html5 input value */
  value: PropTypes.string,

  /** html5 input name */
  name: PropTypes.string,

  /** Checkbox label */
  children: PropTypes.node,

  /** callback run on change */
  onChange: PropTypes.func
};
CheckBox.defaultProps = {
  className: '',
  disabledTitle: ''
};

export default CheckBox;
//# sourceMappingURL=index.js.map
