import _toConsumableArray from '@babel/runtime/helpers/toConsumableArray';
import React__default from 'react';
import PropTypes from 'prop-types';
import CheckBox from '../CheckBox/index.js';
import FieldExtra from '../FieldExtra/index.js';
import './checkboxesArray.scss.js';

var CheckboxesArray = function CheckboxesArray(_ref) {
  var onChange = _ref.onChange,
      _onBlur = _ref.onBlur,
      error = _ref.error,
      warning = _ref.warning,
      valuesArray = _ref.valuesArray,
      options = _ref.options,
      className = _ref.className;
  var checkboxes = options.map(function (_ref2, index) {
    var label = _ref2.label,
        value = _ref2.value,
        disabled = _ref2.disabled,
        disabledTitle = _ref2.disabledTitle;

    var handleChange = function handleChange(event) {
      var arr = _toConsumableArray(valuesArray);

      if (event.target.checked) {
        arr.push(value);
      } else {
        arr.splice(arr.indexOf(value), 1);
      }

      return onChange(arr);
    };

    var checked = valuesArray.includes(value);
    return /*#__PURE__*/React__default.createElement(CheckBox, {
      key: "checkbox-".concat(index),
      onChange: handleChange,
      checked: checked,
      disabled: disabled,
      disabledTitle: disabledTitle,
      value: value,
      onBlur: function onBlur() {
        return _onBlur(valuesArray);
      }
    }, label);
  });
  return /*#__PURE__*/React__default.createElement("div", {
    className: "Suc-checkboxes-array-container"
  }, /*#__PURE__*/React__default.createElement("div", {
    className: "Suc-checkboxes-array ".concat(className)
  }, checkboxes), /*#__PURE__*/React__default.createElement(FieldExtra, {
    error: error,
    warning: warning,
    marginTop: "7px"
  }));
};

var optionShape = {
  label: PropTypes.string,
  value: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
  disabled: PropTypes.bool,
  disabledTitle: PropTypes.string
};
CheckboxesArray.propTypes = {
  /** callback run on change */
  onChange: PropTypes.func,

  /** callback run on blur */
  onBlur: PropTypes.func,

  /** array of string values */
  valuesArray: PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.string, PropTypes.number])),

  /** checked or unchecked */
  options: PropTypes.arrayOf(PropTypes.shape(optionShape)),

  /** custom classname */
  className: PropTypes.string
};
CheckboxesArray.defaultProps = {
  className: '',
  valuesArray: []
};

export default CheckboxesArray;
//# sourceMappingURL=index.js.map
