import _extends from '@babel/runtime/helpers/extends';
import _objectWithoutProperties from '@babel/runtime/helpers/objectWithoutProperties';
import React__default from 'react';
import SvgCloseCircled from '../../assets/svgs/close-circled.svg.js';
import Button from '../Button/index.js';
import PropTypes from 'prop-types';
import './defaultDialogLayout.scss.js';

/** Default layout of a modal  */

var DefaultDialogLayout = function DefaultDialogLayout(_ref) {
  var title = _ref.title,
      buttonsArr = _ref.buttonsArr,
      className = _ref.className,
      children = _ref.children,
      errorMessage = _ref.errorMessage;
  return /*#__PURE__*/React__default.createElement("div", {
    className: "Suc-default-dialog-layout ".concat(className)
  }, /*#__PURE__*/React__default.createElement("span", {
    className: "Suc-header"
  }, title), /*#__PURE__*/React__default.createElement("div", {
    className: "Suc-dialog-content"
  }, children), /*#__PURE__*/React__default.createElement("div", {
    className: "Suc-dialog-footer"
  }, errorMessage && /*#__PURE__*/React__default.createElement("div", {
    className: "Suc-error-message"
  }, /*#__PURE__*/React__default.createElement("div", {
    className: "Suc-error-icon"
  }, /*#__PURE__*/React__default.createElement(SvgCloseCircled, null)), /*#__PURE__*/React__default.createElement("div", {
    className: "Suc-error-text"
  }, errorMessage)), /*#__PURE__*/React__default.createElement("div", {
    className: "Suc-buttons-container"
  }, buttonsArr === null || buttonsArr === void 0 ? void 0 : buttonsArr.map(function (_ref2) {
    var text = _ref2.text,
        className = _ref2.className,
        rest = _objectWithoutProperties(_ref2, ["text", "className"]);

    return /*#__PURE__*/React__default.createElement(Button, _extends({
      key: text,
      className: "Suc-dialog-button ".concat(className)
    }, rest), text);
  }))));
};

DefaultDialogLayout.propTypes = {
  /** title of the dialog */
  title: PropTypes.node,

  /** Array of Buttons in the modal footer */
  buttonsArr: PropTypes.array,

  /** custom className */
  className: PropTypes.string,

  /** modal content */
  children: PropTypes.node,

  /** error message, null for no error message */
  errorMessage: PropTypes.string
};
DefaultDialogLayout.defaultProps = {
  errorMessage: null,
  className: ''
};

export default DefaultDialogLayout;
//# sourceMappingURL=DefaultDialogLayout.js.map
