import _defineProperty from '@babel/runtime/helpers/defineProperty';
import _slicedToArray from '@babel/runtime/helpers/slicedToArray';
import React__default, { useRef, useState, useCallback, useEffect, useContext } from 'react';
import './dialog.scss.js';

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }
var DialogContext = /*#__PURE__*/React__default.createContext(function () {});
var DialogContextProvider = function DialogContextProvider(_ref) {
  var children = _ref.children;
  var modalRef = useRef();

  var _useState = useState({
    dialog: null,
    parent: null,
    disableClose: false,
    modalStyle: null
  }),
      _useState2 = _slicedToArray(_useState, 2),
      shownDialog = _useState2[0],
      setShownDialog = _useState2[1];

  var promise = useRef();
  var closeDialogHandler = useCallback(function (e) {
    if (shownDialog.disableClose) {
      return;
    }

    if (e.keyCode === 8 && e.target.nodeName !== 'INPUT' && e.target.nodeName !== 'TEXTAREA') {
      e.preventDefault();
    }

    if (e.keyCode === 27) {
      closeDialog();
    }
  }, [shownDialog.disableClose]);
  useEffect(function () {
    if (!shownDialog.dialog) return;
    if (shownDialog.disableClose) return;
    document.addEventListener('keydown', closeDialogHandler);
    return function () {
      document.removeEventListener('keydown', closeDialogHandler);
    };
  }, [shownDialog]);

  var setDialog = function setDialog(dialog, triggerElement, disableClose) {
    if (shownDialog.dialog === dialog) {
      return;
    }

    setShownDialog({
      dialog: dialog,
      style: triggerElement ? {
        opacity: 0
      } : {},
      disableClose: disableClose
    });

    if (triggerElement) {
      var parentBr = triggerElement.getBoundingClientRect();
      setTimeout(function () {
        var modalBr = modalRef.current.getBoundingClientRect();
        var x = parentBr.left + parentBr.width / 2 - modalBr.left;
        var y = parentBr.top + parentBr.height / 2 - (modalBr.top + modalBr.height);
        setShownDialog(function (prevState) {
          return _objectSpread(_objectSpread({}, prevState), {}, {
            style: {
              opacity: 0,
              transform: "translate(".concat(x, "px, ").concat(y, "px) scale(0)")
            }
          });
        });
        setTimeout(function () {
          setShownDialog(function (prevState) {
            return _objectSpread(_objectSpread({}, prevState), {}, {
              style: {
                transition: 'transform 0.5s cubic-bezier(0.25, 0.8, 0.25, 1)',
                transformOrigin: '0 100%',
                opacity: 1,
                transform: 'translate(0, 0) scale(1)'
              }
            });
          });
        }, 100);
      });
    }

    return new Promise(function (res) {
      promise.current = res;
    });
  };

  var closeDialog = function closeDialog(props) {
    setShownDialog({
      dialog: null
    });
    promise.current(props);
    document.removeEventListener('keydown', closeDialogHandler);
  };

  var setDisableClose = useCallback(function (bool) {
    setShownDialog(function (prevState) {
      return _objectSpread(_objectSpread({}, prevState), {}, {
        disableClose: bool
      });
    });
  }, [setShownDialog]);
  var content = shownDialog.dialog;
  return /*#__PURE__*/React__default.createElement(DialogContext.Provider, {
    value: {
      setDialog: setDialog,
      setDisableClose: setDisableClose,
      closeDialog: closeDialog
    }
  }, children, content ? /*#__PURE__*/React__default.createElement("div", {
    className: "Suc-dialog"
  }, /*#__PURE__*/React__default.createElement("div", {
    className: "Suc-mask",
    onClick: shownDialog.disableClose ? function () {} : closeDialog
  }), /*#__PURE__*/React__default.createElement("div", {
    className: "Suc-modal",
    ref: modalRef,
    style: shownDialog.style
  }, content)) : null);
};
var useDialog = function useDialog() {
  return useContext(DialogContext);
};

export { DialogContextProvider, useDialog };
//# sourceMappingURL=Dialog.js.map
