import _extends from '@babel/runtime/helpers/extends';
import _objectWithoutProperties from '@babel/runtime/helpers/objectWithoutProperties';
import React__default, { useMemo } from 'react';
import get from 'lodash/get';
import './grid.scss.js';
import ButtonBase from '../ButtonBase/index.js';
import { FilterButton } from './FilterPanel.js';
import PaginationPanel from './PaginationPanel.js';
import PropTypes from 'prop-types';
import TooltipInfo from '../TooltipInfo/index.js';

var renderCellValue = function renderCellValue(column, data) {
  var value = get(data, column.accessor, '');

  if (column.renderCell) {
    return column.renderCell(value, data);
  } else {
    return /*#__PURE__*/React__default.createElement("span", {
      className: 'Suc-ellipsis',
      title: value
    }, value);
  }
};

var Row = function Row(_ref) {
  var columns = _ref.columns,
      data = _ref.data;

  var _ref2 = data.cellProps || {},
      _ref2$className = _ref2.className,
      className = _ref2$className === void 0 ? '' : _ref2$className,
      _ref2$skeleton = _ref2.skeleton,
      skeleton = _ref2$skeleton === void 0 ? false : _ref2$skeleton,
      cellProps = _objectWithoutProperties(_ref2, ["className", "skeleton"]);

  return /*#__PURE__*/React__default.createElement("div", {
    className: 'Suc-row'
  }, columns.map(function (column, index) {
    var cellValue = renderCellValue(column, data);
    var _column$className = column.className,
        columnClassName = _column$className === void 0 ? '' : _column$className;
    return /*#__PURE__*/React__default.createElement("span", _extends({
      className: "Suc-cell Suc-col-".concat(index, " ").concat(index === columns.length - 1 ? 'Suc-last-col' : '', " ").concat(className, " ").concat(columnClassName),
      key: column.id
    }, cellProps), skeleton ? /*#__PURE__*/React__default.createElement("div", {
      className: 'Suc-skeleton'
    }) : cellValue);
  }));
};

var HeaderCell = function HeaderCell(_ref3) {
  var column = _ref3.column;
  var sortable = column.sortable,
      Header = column.Header,
      toggleSort = column.toggleSort,
      sortState = column.sortState,
      filterOptions = column.filterOptions,
      info = column.info,
      _column$infoProps = column.infoProps,
      infoProps = _column$infoProps === void 0 ? {} : _column$infoProps,
      id = column.id,
      _column$className2 = column.className,
      className = _column$className2 === void 0 ? '' : _column$className2;
  return /*#__PURE__*/React__default.createElement("div", {
    className: "Suc-header-cell ".concat(className),
    key: id
  }, info && /*#__PURE__*/React__default.createElement(TooltipInfo, _extends({
    appendToBody: true,
    className: 'Suc-table-header-tooltip'
  }, infoProps), info), /*#__PURE__*/React__default.createElement("div", {
    className: 'Suc-header-name'
  }, Header), filterOptions && /*#__PURE__*/React__default.createElement(FilterButton, {
    column: column
  }), sortable && /*#__PURE__*/React__default.createElement(SortButton, {
    handleSort: toggleSort,
    sortState: sortState
  }), /*#__PURE__*/React__default.createElement("div", {
    className: 'Suc-right-border'
  }));
};
/** Data table - Should be used with useTable hook, all props go for useTable which return the gridProps (apart from className and disableAutoSizeColumns) */


var Grid = function Grid(_ref4) {
  var _pagination$pageRows;

  var organizedRows = _ref4.organizedRows,
      columns = _ref4.columns,
      pagination = _ref4.pagination,
      className = _ref4.className,
      pageSize = _ref4.pageSize,
      disableAutoSizeColumns = _ref4.disableAutoSizeColumns;
  var gridTemplateColumns = useMemo(function () {
    return columns.reduce(function (acc, _ref5) {
      var width = _ref5.width;
      return acc + (width ? "".concat(width, " ") : disableAutoSizeColumns ? '1fr ' : 'auto ');
    }, '');
  }, [columns, disableAutoSizeColumns]);
  return /*#__PURE__*/React__default.createElement("div", {
    className: "Suc-grid ".concat(className),
    style: {
      gridTemplateColumns: gridTemplateColumns
    },
    "data-columns-count": columns.length
  }, columns.map(function (column) {
    return /*#__PURE__*/React__default.createElement(HeaderCell, {
      key: column.id,
      column: column
    });
  }), /*#__PURE__*/React__default.createElement("div", {
    className: "Suc-body"
  }, pagination === null || pagination === void 0 ? void 0 : (_pagination$pageRows = pagination.pageRows) === null || _pagination$pageRows === void 0 ? void 0 : _pagination$pageRows.map(function (dataRow) {
    return /*#__PURE__*/React__default.createElement(Row, {
      key: dataRow.id,
      columns: columns,
      data: dataRow
    });
  })), (pagination === null || pagination === void 0 ? void 0 : pagination.pageCount) > 1 && /*#__PURE__*/React__default.createElement(PaginationPanel, {
    pagination: pagination,
    columnCount: columns.length + 1,
    pageSize: pageSize,
    totalRows: organizedRows.length
  }));
};

var filterOptionShape = {
  /** value the data should be filtered for */
  value: PropTypes.string,

  /** label of filter */
  label: PropTypes.string
};
var columnShape = {
  /** column header label text/ react node */
  Header: PropTypes.node.isRequired,

  /** key of relevant property from data */
  accessor: PropTypes.string.isRequired,

  /** Is column should be sortable */
  sortable: PropTypes.bool,

  /** Is filterable? filter options */
  filterOptions: PropTypes.arrayOf(PropTypes.shape(filterOptionShape)),

  /** informative tooltip on column header */
  info: PropTypes.node,

  /** column width - valid grid template column value */
  width: PropTypes.string,

  /** custom cell content (cellData,rowData)=>cellContent */
  renderCell: PropTypes.func,

  /** custom classname for the column. header and cells */
  className: PropTypes.string,

  /** InfoTooltip props */
  infoProps: PropTypes.object
};
var rowShape = {
  /** values here can be string, property names according to columns 'accessor' values */

  /** props for the rows cells in this row (can have className) or have skeleton:true  */
  cellProps: PropTypes.object,

  /** if row selection is active, you can disable selecting the row with this property  */
  disableSelection: PropTypes.bool
};
Grid.propTypes = {
  /** grid columns */
  columns: PropTypes.arrayOf(PropTypes.shape(columnShape)),

  /** table data -  */
  data: PropTypes.arrayOf(PropTypes.shape(rowShape)),

  /** Number of rows in page */
  pageSize: PropTypes.number,

  /** custom classname */
  className: PropTypes.string,

  /** Are rows selectable? */
  selectionType: PropTypes.oneOf(['NONE', 'SINGULAR', 'MULTIPLE']),

  /** regular sorting mechanism */
  isSorting: PropTypes.bool,

  /** disable columns automatic width setting according to data */
  disableAutoSizeColumns: PropTypes.bool,

  /** should be supplied if 'isSorting' is false - Not supported yet */
  externalSort: PropTypes.bool,

  /** Not supported yet */
  externalFilter: PropTypes.object,

  /** Not supported yet */
  defaultSortState: PropTypes.object,

  /** Array of row Ids, that should be selected by default. */
  defaultSelectedRows: PropTypes.arrayOf(PropTypes.string)
};
Grid.defaultProps = {
  pageSize: 50,
  disableAutoSizeColumns: false,
  className: ''
};

var SortButton = function SortButton(_ref6) {
  var handleSort = _ref6.handleSort,
      _ref6$sortState = _ref6.sortState,
      sortState = _ref6$sortState === void 0 ? null : _ref6$sortState;
  return /*#__PURE__*/React__default.createElement(ButtonBase, {
    type: "button",
    className: "Suc-sort-button ".concat(sortState === null ? 'Suc-none' : '', " ").concat(sortState === 'asc' ? 'Suc-asc' : '', " ").concat(sortState === 'desc' ? 'Suc-dsc' : ''),
    onClick: handleSort
  });
};

export default Grid;
//# sourceMappingURL=index.js.map
