import _extends from '@babel/runtime/helpers/extends';
import _slicedToArray from '@babel/runtime/helpers/slicedToArray';
import _objectWithoutProperties from '@babel/runtime/helpers/objectWithoutProperties';
import React__default, { useState } from 'react';
import Popover from '../Popover/index.js';
import ButtonBase from '../ButtonBase/index.js';
import SvgMenuCircle from '../../assets/svgs/menu-circle.svg.js';
import SvgMenuOval from '../../assets/svgs/menu-oval.svg.js';
import './MenuPopover.scss.js';
import PropTypes from 'prop-types';

/** context menu  */

var MenuPopover = function MenuPopover(_ref) {
  var triggerVariant = _ref.triggerVariant,
      menuItems = _ref.menuItems,
      className = _ref.className,
      popoverClass = _ref.popoverClass,
      rest = _objectWithoutProperties(_ref, ["triggerVariant", "menuItems", "className", "popoverClass"]);

  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      isOpen = _useState2[0],
      setIsOpen = _useState2[1];

  var close = function close() {
    return setIsOpen(false);
  };

  return /*#__PURE__*/React__default.createElement(Popover, _extends({
    trigger: 'click',
    popoverClass: "Suc-menu-popover ".concat(popoverClass),
    containerClass: "Suc-menu-trigger ".concat(isOpen ? 'Suc-active' : '', " ").concat(className),
    visible: isOpen,
    onVisibleChange: setIsOpen,
    closeOnTriggerHidden: true,
    container: /*#__PURE__*/React__default.createElement(ButtonBase, null, triggerVariant === 'table' && /*#__PURE__*/React__default.createElement(TableTrigger, {
      isActive: isOpen
    }), triggerVariant === 'card' && /*#__PURE__*/React__default.createElement(CardTrigger, {
      isActive: isOpen
    }))
  }, rest), /*#__PURE__*/React__default.createElement("ul", {
    className: "Suc-menu-no-bullet"
  }, menuItems.map(function (menuItem, index) {
    return /*#__PURE__*/React__default.createElement("li", {
      key: "Suc-menu-item-".concat(index),
      onClick: close
    }, menuItem);
  })));
};

MenuPopover.propTypes = {
  /** variant of trigger */
  triggerVariant: PropTypes.oneOf(['card', 'table']),

  /** custom classname */
  className: PropTypes.string,

  /** popover custom classname */
  popoverClass: PropTypes.string,

  /** menuItems */
  menuItems: PropTypes.arrayOf(PropTypes.node)
};
MenuPopover.defaultProps = {
  variant: 'card',
  className: '',
  popoverClass: ''
};

var CardTrigger = function CardTrigger(_ref2) {
  var isActive = _ref2.isActive;
  return /*#__PURE__*/React__default.createElement(SvgMenuCircle, {
    className: "Suc-circle-trigger ".concat(isActive ? 'Suc-circle-trigger-active' : '')
  });
};

var TableTrigger = function TableTrigger(_ref3) {
  var isActive = _ref3.isActive;
  return /*#__PURE__*/React__default.createElement(SvgMenuOval, {
    className: "Suc-oval-trigger ".concat(isActive ? 'Suc-oval-trigger-active' : '')
  });
};

export default MenuPopover;
//# sourceMappingURL=index.js.map
