import _extends from '@babel/runtime/helpers/extends';
import _defineProperty from '@babel/runtime/helpers/defineProperty';
import _objectWithoutProperties from '@babel/runtime/helpers/objectWithoutProperties';
import React__default from 'react';
import { usePopperTooltip } from 'react-popper-tooltip';
import './popover.scss.js';
import PropTypes from 'prop-types';
import ReactDOM from 'react-dom';

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }
var offset = [0, 15]; // For the arrow-tip not to be on top of the trigger button

/** basic popover  */

var Popover = function Popover(_ref) {
  var container = _ref.container,
      containerClass = _ref.containerClass,
      trigger = _ref.trigger,
      popoverClass = _ref.popoverClass,
      children = _ref.children,
      appendToBody = _ref.appendToBody,
      rest = _objectWithoutProperties(_ref, ["container", "containerClass", "trigger", "popoverClass", "children", "appendToBody"]);

  var _usePopperTooltip = usePopperTooltip(_objectSpread({
    trigger: trigger,
    offset: offset
  }, rest)),
      getArrowProps = _usePopperTooltip.getArrowProps,
      getTooltipProps = _usePopperTooltip.getTooltipProps,
      setTooltipRef = _usePopperTooltip.setTooltipRef,
      setTriggerRef = _usePopperTooltip.setTriggerRef,
      visible = _usePopperTooltip.visible;

  var tooltipWrapper = /*#__PURE__*/React__default.createElement("div", _extends({
    ref: setTooltipRef
  }, getTooltipProps({
    className: "Suc-tooltip-container ".concat(popoverClass)
  })), children, /*#__PURE__*/React__default.createElement("div", getArrowProps({
    className: 'Suc-tooltip-arrow'
  })));
  return /*#__PURE__*/React__default.createElement(React__default.Fragment, null, /*#__PURE__*/React__default.createElement("span", {
    className: "Suc-popover-trigger-container ".concat(containerClass, " ").concat(visible ? 'active' : ''),
    ref: setTriggerRef
  }, container), visible && (appendToBody ? /*#__PURE__*/ReactDOM.createPortal(tooltipWrapper, document.body) : tooltipWrapper));
};

Popover.propTypes = {
  /** variant of trigger */
  trigger: PropTypes.oneOf(['click', 'hover']),

  /** custom classname for the trigger element */
  containerClass: PropTypes.string,

  /** custom classname for the tooltip element */
  popoverClass: PropTypes.string,

  /** append tooltip to body */
  appendToBody: PropTypes.bool,

  /** placement direction of the element */
  placement: PropTypes.oneOf(['top', 'bottom', 'left', 'right']),

  /** Tooltip element */
  children: PropTypes.node
};
Popover.defaultProps = {
  trigger: 'click',
  containerClass: '',
  popoverClass: '',
  placement: 'bottom',
  appendToBody: false
};

export default Popover;
//# sourceMappingURL=index.js.map
