import React__default from 'react';
import './servicePage.scss.js';
import PropTypes from 'prop-types';

var ServicePage = function ServicePage(_ref) {
  var title = _ref.title,
      subtitle = _ref.subtitle,
      description = _ref.description,
      action = _ref.action,
      image = _ref.image,
      benefits = _ref.benefits,
      className = _ref.className;
  return /*#__PURE__*/React__default.createElement("div", {
    className: "Suc-service-page ".concat(className)
  }, /*#__PURE__*/React__default.createElement("div", {
    className: "Suc-top"
  }, /*#__PURE__*/React__default.createElement("div", {
    className: "Suc-main"
  }, /*#__PURE__*/React__default.createElement("div", {
    className: "Suc-title"
  }, title), /*#__PURE__*/React__default.createElement("div", {
    className: "Suc-sub-title"
  }, subtitle), /*#__PURE__*/React__default.createElement("div", {
    className: "Suc-description"
  }, description), /*#__PURE__*/React__default.createElement("div", {
    className: "Suc-action"
  }, action)), /*#__PURE__*/React__default.createElement("div", {
    className: "Suc-image"
  }, image)), /*#__PURE__*/React__default.createElement("div", {
    className: "Suc-bottom"
  }, benefits && benefits.map(function (_ref2) {
    var icon = _ref2.icon,
        title = _ref2.title,
        description = _ref2.description;
    return /*#__PURE__*/React__default.createElement("div", {
      className: "Suc-benefit",
      key: title
    }, /*#__PURE__*/React__default.createElement("div", {
      className: "Suc-icon"
    }, icon), /*#__PURE__*/React__default.createElement("div", {
      className: "Suc-title"
    }, title), /*#__PURE__*/React__default.createElement("div", {
      className: "Suc-description"
    }, description));
  })));
};

var benefitShape = {
  icon: PropTypes.node,
  title: PropTypes.node,
  description: PropTypes.node
};
ServicePage.propTypes = {
  /** page title */
  title: PropTypes.node,

  /** page sub title */
  subtitle: PropTypes.node,

  /** page description */
  description: PropTypes.node,

  /** action component */
  action: PropTypes.node,

  /** image element */
  image: PropTypes.node,

  /** image element */
  benefits: PropTypes.arrayOf(PropTypes.shape(benefitShape)),

  /** custom classname */
  className: PropTypes.string
};
ServicePage.defaultProps = {
  benefits: [],
  className: ''
};

export default ServicePage;
//# sourceMappingURL=index.js.map
