import _extends from '@babel/runtime/helpers/extends';
import _objectWithoutProperties from '@babel/runtime/helpers/objectWithoutProperties';
import React__default from 'react';
import TooltipInfo from '../TooltipInfo/index.js';
import PropTypes from 'prop-types';
import FieldExtra from '../FieldExtra/index.js';
import './textArea.scss.js';

var TextArea = function TextArea(_ref) {
  var className = _ref.className,
      error = _ref.error,
      warning = _ref.warning;
      _ref.type;
      var label = _ref.label,
      disabled = _ref.disabled,
      optional = _ref.optional,
      info = _ref.info,
      infoProps = _ref.infoProps,
      rest = _objectWithoutProperties(_ref, ["className", "error", "warning", "type", "label", "disabled", "optional", "info", "infoProps"]);

  return /*#__PURE__*/React__default.createElement("div", {
    className: "Suc-textarea ".concat(disabled ? 'Suc-disabled' : '', " ").concat(className)
  }, /*#__PURE__*/React__default.createElement("div", {
    className: 'Suc-textarea-top'
  }, label && /*#__PURE__*/React__default.createElement("label", {
    className: 'Suc-textarea-label'
  }, label), /*#__PURE__*/React__default.createElement("div", {
    className: 'Suc-right-section'
  }, optional && /*#__PURE__*/React__default.createElement("span", {
    className: 'Suc-optional'
  }, "Optional"), info && /*#__PURE__*/React__default.createElement(TooltipInfo, infoProps, info))), /*#__PURE__*/React__default.createElement("textarea", _extends({
    className: 'Suc-textarea-field',
    disabled: disabled
  }, rest)), /*#__PURE__*/React__default.createElement(FieldExtra, {
    error: error,
    warning: warning
  }));
};

TextArea.propTypes = {
  /** disabled state */
  disabled: PropTypes.bool,

  /** custom classname */
  className: PropTypes.string,

  /** input label */
  label: PropTypes.string,

  /** input placeholder */
  placeholder: PropTypes.string,

  /** Is the field optional */
  optional: PropTypes.bool,

  /** info tooltip */
  info: PropTypes.node,

  /** InfoTooltip props */
  infoProps: PropTypes.object
};
TextArea.defaultProps = {
  className: '',
  optional: false,
  infoProps: {}
};

export default TextArea;
//# sourceMappingURL=index.js.map
