import _extends from '@babel/runtime/helpers/extends';
import _objectWithoutProperties from '@babel/runtime/helpers/objectWithoutProperties';
import React__default from 'react';
import TooltipInfo from '../TooltipInfo/index.js';
import PropTypes from 'prop-types';
import FieldExtra from '../FieldExtra/index.js';
import './textInput.scss.js';

var TextInput = function TextInput(_ref) {
  var className = _ref.className,
      type = _ref.type,
      label = _ref.label,
      error = _ref.error,
      warning = _ref.warning,
      disabled = _ref.disabled,
      optional = _ref.optional,
      info = _ref.info,
      infoProps = _ref.infoProps,
      removeBottomMargin = _ref.removeBottomMargin,
      rest = _objectWithoutProperties(_ref, ["className", "type", "label", "error", "warning", "disabled", "optional", "info", "infoProps", "removeBottomMargin"]);

  return /*#__PURE__*/React__default.createElement("div", {
    className: "Suc-text-input ".concat(disabled ? 'Suc-disabled' : '', " ").concat(className, " ").concat(removeBottomMargin ? '' : 'Suc-bottom-margin')
  }, /*#__PURE__*/React__default.createElement("div", {
    className: 'Suc-input-top'
  }, label && /*#__PURE__*/React__default.createElement("label", {
    className: 'Suc-input-label'
  }, label), /*#__PURE__*/React__default.createElement("div", {
    className: 'Suc-right-section'
  }, optional && /*#__PURE__*/React__default.createElement("span", {
    className: 'Suc-optional'
  }, "Optional"), info && /*#__PURE__*/React__default.createElement(TooltipInfo, infoProps, info))), /*#__PURE__*/React__default.createElement("input", _extends({
    className: "Suc-input-field ".concat(error ? 'Suc-error' : ''),
    disabled: disabled,
    type: type
  }, rest)), /*#__PURE__*/React__default.createElement(FieldExtra, {
    error: error,
    warning: warning
  }));
};

TextInput.propTypes = {
  /** disabled state */
  disabled: PropTypes.bool,

  /** custom classname */
  className: PropTypes.string,

  /** valid html input type */
  type: PropTypes.string,

  /** input label */
  label: PropTypes.string,

  /** input placeholder */
  placeholder: PropTypes.string,

  /** input value */
  value: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),

  /** callback called on change */
  onchange: PropTypes.string,

  /** error text */
  error: PropTypes.string,

  /** warning text */
  warning: PropTypes.string,

  /** remove margin-bottom (to allow inline alignment) */
  removeBottomMargin: PropTypes.bool,

  /** Is the field optional */
  optional: PropTypes.bool,

  /** info tooltip */
  info: PropTypes.node,

  /** InfoTooltip props */
  infoProps: PropTypes.object
};
TextInput.defaultProps = {
  className: '',
  type: 'text',
  error: '',
  warning: '',
  optional: false,
  removeBottomMargin: false,
  infoProps: {}
};

export default TextInput;
//# sourceMappingURL=index.js.map
