import {useState, useEffect} from 'react';

const useRunOnce = (callback) => {
    const [isRun, setIsRun] = useState(false);
    useEffect(() => {
        if (!isRun) {
            callback();
            setIsRun(true);
        }
    }, [isRun, setIsRun, callback]);
};

export default useRunOnce;
