/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.vfs.dropbox;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.UserAuthenticator;
import org.apache.commons.vfs2.impl.DefaultFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.AbstractOriginatingFileProvider;
import org.apache.commons.vfs2.provider.local.LocalFileName;
import org.rzo.vfs.dropbox.DropboxClientWrapper;
import org.rzo.vfs.dropbox.DropboxFileSystem;
import org.rzo.vfs.dropbox.DropboxFileSystemConfigBuilder;
import org.rzo.vfs.dropbox.auth.DropboxAuthenticator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DropboxFileProvider
extends AbstractOriginatingFileProvider {
    public static final String ATTR_FILE_ENTRY_PARSER = "FEP";
    public static final UserAuthenticationData.Type[] AUTHENTICATOR_TYPES = new UserAuthenticationData.Type[]{UserAuthenticationData.USERNAME, UserAuthenticationData.PASSWORD};
    static final Collection<Capability> capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.CREATE, Capability.DELETE, Capability.RENAME, Capability.GET_TYPE, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.GET_LAST_MODIFIED, Capability.WRITE_CONTENT));
    public static final FileSystemOptions DEFAULT_OPTIONS = new FileSystemOptions();

    protected FileSystem doCreateFileSystem(FileName name, FileSystemOptions fileSystemOptions) throws FileSystemException {
        LocalFileName rootName = (LocalFileName)name;
        if (fileSystemOptions == null) {
            fileSystemOptions = DEFAULT_OPTIONS;
        }
        if (DefaultFileSystemConfigBuilder.getInstance().getUserAuthenticator(fileSystemOptions) == null) {
            DropboxAuthenticator auth = new DropboxAuthenticator();
            DefaultFileSystemConfigBuilder.getInstance().setUserAuthenticator(fileSystemOptions, (UserAuthenticator)auth);
        }
        DropboxClientWrapper dbxClient = new DropboxClientWrapper(rootName, fileSystemOptions);
        return new DropboxFileSystem(rootName, dbxClient, fileSystemOptions);
    }

    public FileSystemConfigBuilder getConfigBuilder() {
        return DropboxFileSystemConfigBuilder.getInstance();
    }

    public Collection<Capability> getCapabilities() {
        return capabilities;
    }
}

