function getStyleComputedProperty(element,property){if(element.nodeType!==1){return[]}var window=element.ownerDocument.defaultView;var css=window.getComputedStyle(element,null);return property?css[property]:css}function getParentNode(element){if(element.nodeName==="HTML"){return element}return element.parentNode||element.host}function getScrollParent(element){if(!element){return document.body}switch(element.nodeName){case"HTML":case"BODY":return element.ownerDocument.body;case"#document":return element.body}var ref=getStyleComputedProperty(element);var overflow=ref.overflow;var overflowX=ref.overflowX;var overflowY=ref.overflowY;if(/(auto|scroll|overlay)/.test(overflow+overflowY+overflowX)){return element}return getScrollParent(getParentNode(element))}function getReferenceNode(reference){return reference&&reference.referenceNode?reference.referenceNode:reference}var isBrowser=typeof window!=="undefined"&&typeof document!=="undefined"&&typeof navigator!=="undefined";var isIE11=isBrowser&&!!(window.MSInputMethodContext&&document.documentMode);var isIE10=isBrowser&&/MSIE 10/.test(navigator.userAgent);function isIE(version){if(version===11){return isIE11}if(version===10){return isIE10}return isIE11||isIE10}function getOffsetParent(element){if(!element){return document.documentElement}var noOffsetParent=isIE(10)?document.body:null;var offsetParent=element.offsetParent||null;while(offsetParent===noOffsetParent&&element.nextElementSibling){offsetParent=(element=element.nextElementSibling).offsetParent}var nodeName=offsetParent&&offsetParent.nodeName;if(!nodeName||nodeName==="BODY"||nodeName==="HTML"){return element?element.ownerDocument.documentElement:document.documentElement}if(["TH","TD","TABLE"].indexOf(offsetParent.nodeName)!==-1&&getStyleComputedProperty(offsetParent,"position")==="static"){return getOffsetParent(offsetParent)}return offsetParent}function isOffsetContainer(element){var nodeName=element.nodeName;if(nodeName==="BODY"){return false}return nodeName==="HTML"||getOffsetParent(element.firstElementChild)===element}function getRoot(node){if(node.parentNode!==null){return getRoot(node.parentNode)}return node}function findCommonOffsetParent(element1,element2){if(!element1||!element1.nodeType||!element2||!element2.nodeType){return document.documentElement}var order=element1.compareDocumentPosition(element2)&Node.DOCUMENT_POSITION_FOLLOWING;var start=order?element1:element2;var end=order?element2:element1;var range=document.createRange();range.setStart(start,0);range.setEnd(end,0);var commonAncestorContainer=range.commonAncestorContainer;if(element1!==commonAncestorContainer&&element2!==commonAncestorContainer||start.contains(end)){if(isOffsetContainer(commonAncestorContainer)){return commonAncestorContainer}return getOffsetParent(commonAncestorContainer)}var element1root=getRoot(element1);if(element1root.host){return findCommonOffsetParent(element1root.host,element2)}else{return findCommonOffsetParent(element1,getRoot(element2).host)}}function getScroll(element,side){if(side===void 0)side="top";var upperSide=side==="top"?"scrollTop":"scrollLeft";var nodeName=element.nodeName;if(nodeName==="BODY"||nodeName==="HTML"){var html=element.ownerDocument.documentElement;var scrollingElement=element.ownerDocument.scrollingElement||html;return scrollingElement[upperSide]}return element[upperSide]}function includeScroll(rect,element,subtract){if(subtract===void 0)subtract=false;var scrollTop=getScroll(element,"top");var scrollLeft=getScroll(element,"left");var modifier=subtract?-1:1;rect.top+=scrollTop*modifier;rect.bottom+=scrollTop*modifier;rect.left+=scrollLeft*modifier;rect.right+=scrollLeft*modifier;return rect}function getBordersSize(styles,axis){var sideA=axis==="x"?"Left":"Top";var sideB=sideA==="Left"?"Right":"Bottom";return parseFloat(styles["border"+sideA+"Width"])+parseFloat(styles["border"+sideB+"Width"])}function getSize(axis,body,html,computedStyle){return Math.max(body["offset"+axis],body["scroll"+axis],html["client"+axis],html["offset"+axis],html["scroll"+axis],isIE(10)?parseInt(html["offset"+axis])+parseInt(computedStyle["margin"+(axis==="Height"?"Top":"Left")])+parseInt(computedStyle["margin"+(axis==="Height"?"Bottom":"Right")]):0)}function getWindowSizes(document){var body=document.body;var html=document.documentElement;var computedStyle=isIE(10)&&getComputedStyle(html);return{height:getSize("Height",body,html,computedStyle),width:getSize("Width",body,html,computedStyle)}}function getClientRect(offsets){return Object.assign({},offsets,{right:offsets.left+offsets.width,bottom:offsets.top+offsets.height})}function getBoundingClientRect(element){var rect={};try{if(isIE(10)){rect=element.getBoundingClientRect();var scrollTop=getScroll(element,"top");var scrollLeft=getScroll(element,"left");rect.top+=scrollTop;rect.left+=scrollLeft;rect.bottom+=scrollTop;rect.right+=scrollLeft}else{rect=element.getBoundingClientRect()}}catch(e){}var result={left:rect.left,top:rect.top,width:rect.right-rect.left,height:rect.bottom-rect.top};var sizes=element.nodeName==="HTML"?getWindowSizes(element.ownerDocument):{};var width=sizes.width||element.clientWidth||result.width;var height=sizes.height||element.clientHeight||result.height;var horizScrollbar=element.offsetWidth-width;var vertScrollbar=element.offsetHeight-height;if(horizScrollbar||vertScrollbar){var styles=getStyleComputedProperty(element);horizScrollbar-=getBordersSize(styles,"x");vertScrollbar-=getBordersSize(styles,"y");result.width-=horizScrollbar;result.height-=vertScrollbar}return getClientRect(result)}function getOffsetRectRelativeToArbitraryNode(children,parent,fixedPosition){if(fixedPosition===void 0)fixedPosition=false;var isIE10=isIE(10);var isHTML=parent.nodeName==="HTML";var childrenRect=getBoundingClientRect(children);var parentRect=getBoundingClientRect(parent);var scrollParent=getScrollParent(children);var styles=getStyleComputedProperty(parent);var borderTopWidth=parseFloat(styles.borderTopWidth);var borderLeftWidth=parseFloat(styles.borderLeftWidth);if(fixedPosition&&isHTML){parentRect.top=Math.max(parentRect.top,0);parentRect.left=Math.max(parentRect.left,0)}var offsets=getClientRect({top:childrenRect.top-parentRect.top-borderTopWidth,left:childrenRect.left-parentRect.left-borderLeftWidth,width:childrenRect.width,height:childrenRect.height});offsets.marginTop=0;offsets.marginLeft=0;if(!isIE10&&isHTML){var marginTop=parseFloat(styles.marginTop);var marginLeft=parseFloat(styles.marginLeft);offsets.top-=borderTopWidth-marginTop;offsets.bottom-=borderTopWidth-marginTop;offsets.left-=borderLeftWidth-marginLeft;offsets.right-=borderLeftWidth-marginLeft;offsets.marginTop=marginTop;offsets.marginLeft=marginLeft}if(isIE10&&!fixedPosition?parent.contains(scrollParent):parent===scrollParent&&scrollParent.nodeName!=="BODY"){offsets=includeScroll(offsets,parent)}return offsets}function getViewportOffsetRectRelativeToArtbitraryNode(element,excludeScroll){if(excludeScroll===void 0)excludeScroll=false;var html=element.ownerDocument.documentElement;var relativeOffset=getOffsetRectRelativeToArbitraryNode(element,html);var width=Math.max(html.clientWidth,window.innerWidth||0);var height=Math.max(html.clientHeight,window.innerHeight||0);var scrollTop=!excludeScroll?getScroll(html):0;var scrollLeft=!excludeScroll?getScroll(html,"left"):0;var offset={top:scrollTop-relativeOffset.top+relativeOffset.marginTop,left:scrollLeft-relativeOffset.left+relativeOffset.marginLeft,width:width,height:height};return getClientRect(offset)}function isFixed(element){var nodeName=element.nodeName;if(nodeName==="BODY"||nodeName==="HTML"){return false}if(getStyleComputedProperty(element,"position")==="fixed"){return true}var parentNode=getParentNode(element);if(!parentNode){return false}return isFixed(parentNode)}function getFixedPositionOffsetParent(element){if(!element||!element.parentElement||isIE()){return document.documentElement}var el=element.parentElement;while(el&&getStyleComputedProperty(el,"transform")==="none"){el=el.parentElement}return el||document.documentElement}function getBoundaries(popper,reference,padding,boundariesElement,fixedPosition){if(fixedPosition===void 0)fixedPosition=false;var boundaries={top:0,left:0};var offsetParent=fixedPosition?getFixedPositionOffsetParent(popper):findCommonOffsetParent(popper,getReferenceNode(reference));if(boundariesElement==="viewport"){boundaries=getViewportOffsetRectRelativeToArtbitraryNode(offsetParent,fixedPosition)}else{var boundariesNode;if(boundariesElement==="scrollParent"){boundariesNode=getScrollParent(getParentNode(reference));if(boundariesNode.nodeName==="BODY"){boundariesNode=popper.ownerDocument.documentElement}}else if(boundariesElement==="window"){boundariesNode=popper.ownerDocument.documentElement}else{boundariesNode=boundariesElement}var offsets=getOffsetRectRelativeToArbitraryNode(boundariesNode,offsetParent,fixedPosition);if(boundariesNode.nodeName==="HTML"&&!isFixed(offsetParent)){var ref=getWindowSizes(popper.ownerDocument);var height=ref.height;var width=ref.width;boundaries.top+=offsets.top-offsets.marginTop;boundaries.bottom=height+offsets.top;boundaries.left+=offsets.left-offsets.marginLeft;boundaries.right=width+offsets.left}else{boundaries=offsets}}padding=padding||0;var isPaddingNumber=typeof padding==="number";boundaries.left+=isPaddingNumber?padding:padding.left||0;boundaries.top+=isPaddingNumber?padding:padding.top||0;boundaries.right-=isPaddingNumber?padding:padding.right||0;boundaries.bottom-=isPaddingNumber?padding:padding.bottom||0;return boundaries}function getArea(ref){var width=ref.width;var height=ref.height;return width*height}function computeAutoPlacement(placement,refRect,popper,reference,boundariesElement,padding){if(padding===void 0)padding=0;if(placement.indexOf("auto")===-1){return placement}var boundaries=getBoundaries(popper,reference,padding,boundariesElement);var rects={top:{width:boundaries.width,height:refRect.top-boundaries.top},right:{width:boundaries.right-refRect.right,height:boundaries.height},bottom:{width:boundaries.width,height:boundaries.bottom-refRect.bottom},left:{width:refRect.left-boundaries.left,height:boundaries.height}};var sortedAreas=Object.keys(rects).map((function(key){return Object.assign({},{key:key},rects[key],{area:getArea(rects[key])})})).sort((function(a,b){return b.area-a.area}));var filteredAreas=sortedAreas.filter((function(ref){var width=ref.width;var height=ref.height;return width>=popper.clientWidth&&height>=popper.clientHeight}));var computedPlacement=filteredAreas.length>0?filteredAreas[0].key:sortedAreas[0].key;var variation=placement.split("-")[1];return computedPlacement+(variation?"-"+variation:"")}var timeoutDuration=function(){var longerTimeoutBrowsers=["Edge","Trident","Firefox"];for(var i=0;i<longerTimeoutBrowsers.length;i+=1){if(isBrowser&&navigator.userAgent.indexOf(longerTimeoutBrowsers[i])>=0){return 1}}return 0}();function microtaskDebounce(fn){var called=false;return function(){if(called){return}called=true;window.Promise.resolve().then((function(){called=false;fn()}))}}function taskDebounce(fn){var scheduled=false;return function(){if(!scheduled){scheduled=true;setTimeout((function(){scheduled=false;fn()}),timeoutDuration)}}}var supportsMicroTasks=isBrowser&&window.Promise;var debounce=supportsMicroTasks?microtaskDebounce:taskDebounce;function find(arr,check){if(Array.prototype.find){return arr.find(check)}return arr.filter(check)[0]}function findIndex(arr,prop,value){if(Array.prototype.findIndex){return arr.findIndex((function(cur){return cur[prop]===value}))}var match=find(arr,(function(obj){return obj[prop]===value}));return arr.indexOf(match)}function getOffsetRect(element){var elementRect;if(element.nodeName==="HTML"){var ref=getWindowSizes(element.ownerDocument);var width=ref.width;var height=ref.height;elementRect={width:width,height:height,left:0,top:0}}else{elementRect={width:element.offsetWidth,height:element.offsetHeight,left:element.offsetLeft,top:element.offsetTop}}return getClientRect(elementRect)}function getOuterSizes(element){var window=element.ownerDocument.defaultView;var styles=window.getComputedStyle(element);var x=parseFloat(styles.marginTop||0)+parseFloat(styles.marginBottom||0);var y=parseFloat(styles.marginLeft||0)+parseFloat(styles.marginRight||0);var result={width:element.offsetWidth+y,height:element.offsetHeight+x};return result}function getOppositePlacement(placement){var hash={left:"right",right:"left",bottom:"top",top:"bottom"};return placement.replace(/left|right|bottom|top/g,(function(matched){return hash[matched]}))}function getPopperOffsets(popper,referenceOffsets,placement){placement=placement.split("-")[0];var popperRect=getOuterSizes(popper);var popperOffsets={width:popperRect.width,height:popperRect.height};var isHoriz=["right","left"].indexOf(placement)!==-1;var mainSide=isHoriz?"top":"left";var secondarySide=isHoriz?"left":"top";var measurement=isHoriz?"height":"width";var secondaryMeasurement=!isHoriz?"height":"width";popperOffsets[mainSide]=referenceOffsets[mainSide]+referenceOffsets[measurement]/2-popperRect[measurement]/2;if(placement===secondarySide){popperOffsets[secondarySide]=referenceOffsets[secondarySide]-popperRect[secondaryMeasurement]}else{popperOffsets[secondarySide]=referenceOffsets[getOppositePlacement(secondarySide)]}return popperOffsets}function getReferenceOffsets(state,popper,reference,fixedPosition){if(fixedPosition===void 0)fixedPosition=null;var commonOffsetParent=fixedPosition?getFixedPositionOffsetParent(popper):findCommonOffsetParent(popper,getReferenceNode(reference));return getOffsetRectRelativeToArbitraryNode(reference,commonOffsetParent,fixedPosition)}function getSupportedPropertyName(property){var prefixes=[false,"ms","Webkit","Moz","O"];var upperProp=property.charAt(0).toUpperCase()+property.slice(1);for(var i=0;i<prefixes.length;i++){var prefix=prefixes[i];var toCheck=prefix?""+prefix+upperProp:property;if(typeof document.body.style[toCheck]!=="undefined"){return toCheck}}return null}function isFunction(functionToCheck){var getType={};return functionToCheck&&getType.toString.call(functionToCheck)==="[object Function]"}function isModifierEnabled(modifiers,modifierName){return modifiers.some((function(ref){var name=ref.name;var enabled=ref.enabled;return enabled&&name===modifierName}))}function isModifierRequired(modifiers,requestingName,requestedName){var requesting=find(modifiers,(function(ref){var name=ref.name;return name===requestingName}));var isRequired=!!requesting&&modifiers.some((function(modifier){return modifier.name===requestedName&&modifier.enabled&&modifier.order<requesting.order}));if(!isRequired){var requesting$1="`"+requestingName+"`";var requested="`"+requestedName+"`";console.warn(requested+" modifier is required by "+requesting$1+" modifier in order to work, be sure to include it before "+requesting$1+"!")}return isRequired}function isNumeric(n){return n!==""&&!isNaN(parseFloat(n))&&isFinite(n)}function getWindow(element){var ownerDocument=element.ownerDocument;return ownerDocument?ownerDocument.defaultView:window}function removeEventListeners(reference,state){getWindow(reference).removeEventListener("resize",state.updateBound);state.scrollParents.forEach((function(target){target.removeEventListener("scroll",state.updateBound)}));state.updateBound=null;state.scrollParents=[];state.scrollElement=null;state.eventsEnabled=false;return state}function runModifiers(modifiers,data,ends){var modifiersToRun=ends===undefined?modifiers:modifiers.slice(0,findIndex(modifiers,"name",ends));modifiersToRun.forEach((function(modifier){if(modifier["function"]){console.warn("`modifier.function` is deprecated, use `modifier.fn`!")}var fn=modifier["function"]||modifier.fn;if(modifier.enabled&&isFunction(fn)){data.offsets.popper=getClientRect(data.offsets.popper);data.offsets.reference=getClientRect(data.offsets.reference);data=fn(data,modifier)}}));return data}function setAttributes(element,attributes){Object.keys(attributes).forEach((function(prop){var value=attributes[prop];if(value!==false){element.setAttribute(prop,attributes[prop])}else{element.removeAttribute(prop)}}))}function setStyles(element,styles){Object.keys(styles).forEach((function(prop){var unit="";if(["width","height","top","right","bottom","left"].indexOf(prop)!==-1&&isNumeric(styles[prop])){unit="px"}element.style[prop]=styles[prop]+unit}))}function attachToScrollParents(scrollParent,event,callback,scrollParents){var isBody=scrollParent.nodeName==="BODY";var target=isBody?scrollParent.ownerDocument.defaultView:scrollParent;target.addEventListener(event,callback,{passive:true});if(!isBody){attachToScrollParents(getScrollParent(target.parentNode),event,callback,scrollParents)}scrollParents.push(target)}function setupEventListeners(reference,options,state,updateBound){state.updateBound=updateBound;getWindow(reference).addEventListener("resize",state.updateBound,{passive:true});var scrollElement=getScrollParent(reference);attachToScrollParents(scrollElement,"scroll",state.updateBound,state.scrollParents);state.scrollElement=scrollElement;state.eventsEnabled=true;return state}var index={computeAutoPlacement:computeAutoPlacement,debounce:debounce,findIndex:findIndex,getBordersSize:getBordersSize,getBoundaries:getBoundaries,getBoundingClientRect:getBoundingClientRect,getClientRect:getClientRect,getOffsetParent:getOffsetParent,getOffsetRect:getOffsetRect,getOffsetRectRelativeToArbitraryNode:getOffsetRectRelativeToArbitraryNode,getOuterSizes:getOuterSizes,getParentNode:getParentNode,getPopperOffsets:getPopperOffsets,getReferenceOffsets:getReferenceOffsets,getScroll:getScroll,getScrollParent:getScrollParent,getStyleComputedProperty:getStyleComputedProperty,getSupportedPropertyName:getSupportedPropertyName,getWindowSizes:getWindowSizes,isFixed:isFixed,isFunction:isFunction,isModifierEnabled:isModifierEnabled,isModifierRequired:isModifierRequired,isNumeric:isNumeric,removeEventListeners:removeEventListeners,runModifiers:runModifiers,setAttributes:setAttributes,setStyles:setStyles,setupEventListeners:setupEventListeners};export{computeAutoPlacement,debounce,index as default,findIndex,getBordersSize,getBoundaries,getBoundingClientRect,getClientRect,getOffsetParent,getOffsetRect,getOffsetRectRelativeToArbitraryNode,getOuterSizes,getParentNode,getPopperOffsets,getReferenceOffsets,getScroll,getScrollParent,getStyleComputedProperty,getSupportedPropertyName,getWindowSizes,isFixed,isFunction,isModifierEnabled,isModifierRequired,isNumeric,removeEventListeners,runModifiers,setAttributes,setStyles,setupEventListeners};