/*
 * Decompiled with CFR 0.152.
 */
package ch.vorburger.exec;

import ch.vorburger.exec.ManagedProcess;
import ch.vorburger.exec.ManagedProcessException;
import ch.vorburger.exec.OutputStreamLogDispatcher;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.environment.EnvironmentUtils;
import org.apache.commons.exec.util.StringUtils;

public class ManagedProcessBuilder {
    protected final CommandLine commonsExecCommandLine;
    protected final Map<String, String> environment;
    protected File directory;
    protected InputStream inputStream;
    protected boolean destroyOnShutdown = true;
    protected int consoleBufferMaxLines = 100;
    protected OutputStreamLogDispatcher outputStreamLogDispatcher = new OutputStreamLogDispatcher();

    public ManagedProcessBuilder(String executable) throws ManagedProcessException {
        this.commonsExecCommandLine = new CommandLine(executable);
        this.environment = this.initialEnvironment();
    }

    public ManagedProcessBuilder(File executable) throws ManagedProcessException {
        this.commonsExecCommandLine = new CommandLine(executable);
        this.environment = this.initialEnvironment();
    }

    protected Map<String, String> initialEnvironment() throws ManagedProcessException {
        try {
            return EnvironmentUtils.getProcEnvironment();
        }
        catch (IOException e) {
            throw new ManagedProcessException("Retrieving default environment variables failed", e);
        }
    }

    public ManagedProcessBuilder addArgument(String arg, boolean handleQuoting) {
        this.commonsExecCommandLine.addArgument(arg, handleQuoting);
        return this;
    }

    public ManagedProcessBuilder addArgument(File arg) throws IOException {
        this.addArgument(arg.getCanonicalPath(), true);
        return this;
    }

    public ManagedProcessBuilder addArgument(String arg) {
        this.addArgument(arg, true);
        return this;
    }

    public ManagedProcessBuilder addArgument(String argPart1, String argPart2) {
        this.addArgument(argPart1, "", argPart2);
        return this;
    }

    protected ManagedProcessBuilder addArgument(String argPart1, String separator, String argPart2) {
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.quoteArgument((String)argPart1));
        sb.append(separator);
        sb.append(StringUtils.quoteArgument((String)argPart2));
        this.addArgument(sb.toString(), false);
        return this;
    }

    public ManagedProcessBuilder addFileArgument(String arg, File file) throws IOException {
        return this.addArgument(arg, "=", file.getCanonicalPath());
    }

    public String[] getArguments() {
        return this.commonsExecCommandLine.getArguments();
    }

    public ManagedProcessBuilder setWorkingDirectory(File directory) {
        this.directory = directory;
        return this;
    }

    public File getWorkingDirectory() {
        return this.directory;
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public String getExecutable() {
        return this.commonsExecCommandLine.getExecutable();
    }

    public boolean isDestroyOnShutdown() {
        return this.destroyOnShutdown;
    }

    public ManagedProcessBuilder setDestroyOnShutdown(boolean flag) {
        this.destroyOnShutdown = flag;
        return this;
    }

    public void setConsoleBufferMaxLines(int consoleBufferMaxLines) {
        this.consoleBufferMaxLines = consoleBufferMaxLines;
    }

    public int getConsoleBufferMaxLines() {
        return this.consoleBufferMaxLines;
    }

    public void setOutputStreamLogDispatcher(OutputStreamLogDispatcher outputStreamLogDispatcher) {
        this.outputStreamLogDispatcher = outputStreamLogDispatcher;
    }

    public OutputStreamLogDispatcher getOutputStreamLogDispatcher() {
        return this.outputStreamLogDispatcher;
    }

    public ManagedProcess build() {
        return new ManagedProcess(this.getCommandLine(), this.directory, this.environment, this.inputStream, this.destroyOnShutdown, this.consoleBufferMaxLines, this.outputStreamLogDispatcher);
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    CommandLine getCommandLine() {
        if (this.getWorkingDirectory() == null && this.commonsExecCommandLine.isFile()) {
            File exec = new File(this.commonsExecCommandLine.getExecutable());
            File dir = exec.getParentFile();
            if (dir == null) {
                throw new IllegalStateException("directory MUST be set (and could not be auto-determined from executable, although it was a File)");
            }
            this.setWorkingDirectory(dir);
        }
        return this.commonsExecCommandLine;
    }

    public String toString() {
        return this.commonsExecCommandLine.toString();
    }
}

