/*
 * Decompiled with CFR 0.152.
 */
package ch.vorburger.exec;

import ch.vorburger.exec.MultiCauseIOException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;

public class MultiOutputStream
extends OutputStream {
    protected final List<OutputStream> streams = new LinkedList<OutputStream>();

    public MultiOutputStream() {
    }

    public MultiOutputStream(OutputStream ... delegates) {
        for (OutputStream delegate : delegates) {
            this.addOutputStream(delegate);
        }
    }

    public synchronized MultiOutputStream addOutputStream(OutputStream delegate) {
        this.streams.add(delegate);
        return this;
    }

    public synchronized MultiOutputStream removeOutputStream(OutputStream delegate) {
        this.streams.remove(delegate);
        return this;
    }

    @Override
    public void write(int b) throws IOException {
        MultiCauseIOException mex = null;
        for (OutputStream stream : this.streams) {
            try {
                stream.write(b);
            }
            catch (IOException e) {
                if (mex == null) {
                    mex = new MultiCauseIOException();
                }
                mex.add("MultiOutputStream write(int b) delegation failed", e);
            }
        }
        if (mex != null) {
            throw mex;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        MultiCauseIOException mex = null;
        for (OutputStream stream : this.streams) {
            try {
                stream.write(b);
            }
            catch (IOException e) {
                if (mex == null) {
                    mex = new MultiCauseIOException();
                }
                mex.add("MultiOutputStream write(byte[] b) delegation failed", e);
            }
        }
        if (mex != null) {
            throw mex;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        MultiCauseIOException mex = null;
        for (OutputStream stream : this.streams) {
            try {
                stream.write(b, off, len);
            }
            catch (IOException e) {
                if (mex == null) {
                    mex = new MultiCauseIOException();
                }
                mex.add("MultiOutputStream write(byte[] b, int off, int len) delegation failed", e);
            }
        }
        if (mex != null) {
            throw mex;
        }
    }

    @Override
    public void flush() throws IOException {
        MultiCauseIOException mex = null;
        for (OutputStream stream : this.streams) {
            try {
                stream.flush();
            }
            catch (IOException e) {
                if (mex == null) {
                    mex = new MultiCauseIOException();
                }
                mex.add("MultiOutputStream flush() delegation failed", e);
            }
        }
        if (mex != null) {
            throw mex;
        }
    }

    @Override
    public void close() throws IOException {
        MultiCauseIOException mex = null;
        for (OutputStream stream : this.streams) {
            try {
                stream.close();
            }
            catch (IOException e) {
                if (mex == null) {
                    mex = new MultiCauseIOException();
                }
                mex.add("MultiOutputStream close() delegation failed", e);
            }
        }
        if (mex != null) {
            throw mex;
        }
    }
}

