/*
 * Decompiled with CFR 0.152.
 */
package ch.vorburger.mariadb4j;

import ch.vorburger.mariadb4j.DBConfiguration;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.SystemUtils;

public class DBConfigurationBuilder {
    protected static final String WIN32 = "win32";
    protected static final String LINUX = "linux";
    protected static final String OSX = "osx";
    private static final String DEFAULT_DATA_DIR = SystemUtils.JAVA_IO_TMPDIR + "/MariaDB4j/data";
    private String databaseVersion = null;
    protected String osDirectoryName = SystemUtils.IS_OS_WINDOWS ? "win32" : (SystemUtils.IS_OS_MAC ? "osx" : "linux");
    protected String baseDir = SystemUtils.JAVA_IO_TMPDIR + "/MariaDB4j/base";
    protected String libDir = null;
    protected String dataDir = DEFAULT_DATA_DIR;
    protected String socket = null;
    protected int port = 0;
    protected boolean isUnpackingFromClasspath = true;
    protected List<String> args = new ArrayList<String>();
    private boolean frozen = false;

    public static DBConfigurationBuilder newBuilder() {
        return new DBConfigurationBuilder();
    }

    protected DBConfigurationBuilder() {
    }

    protected void checkIfFrozen(String setterName) {
        if (this.frozen) {
            throw new IllegalStateException("cannot " + setterName + "() anymore after build()");
        }
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public DBConfigurationBuilder setBaseDir(String baseDir) {
        this.checkIfFrozen("setBaseDir");
        this.baseDir = baseDir;
        return this;
    }

    public String getLibDir() {
        if (this.libDir == null) {
            return this.baseDir + "/libs";
        }
        return this.libDir;
    }

    public DBConfigurationBuilder setLibDir(String libDir) {
        this.checkIfFrozen("setLibDir");
        this.libDir = libDir;
        return this;
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public DBConfigurationBuilder setDataDir(String dataDir) {
        this.checkIfFrozen("setDataDir");
        this.dataDir = dataDir;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public DBConfigurationBuilder setPort(int port) {
        this.checkIfFrozen("setPort");
        this.port = port;
        return this;
    }

    protected int detectFreePort() {
        try {
            ServerSocket ss = new ServerSocket(0);
            this.port = ss.getLocalPort();
            ss.setReuseAddress(true);
            ss.close();
            return this.port;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getSocket() {
        return this.socket;
    }

    public DBConfigurationBuilder setSocket(String socket) {
        this.checkIfFrozen("setSocket");
        this.socket = socket;
        return this;
    }

    public DBConfiguration build() {
        this.frozen = true;
        return new DBConfiguration.Impl(this._getPort(), this._getSocket(), this._getBinariesClassPathLocation(), this.getBaseDir(), this.getLibDir(), this._getDataDir(), WIN32.equals(this.getOS()), this._getArgs(), this._getOSLibraryEnvironmentVarName());
    }

    public DBConfigurationBuilder addArg(String arg) {
        this.checkIfFrozen("addArg");
        this.args.add(arg);
        return this;
    }

    protected String _getDataDir() {
        if (this.isNull(this.getDataDir()) || this.getDataDir().equals(DEFAULT_DATA_DIR)) {
            return DEFAULT_DATA_DIR + SystemUtils.FILE_SEPARATOR + this.getPort();
        }
        return this.getDataDir();
    }

    protected boolean isNull(String string) {
        if (string == null) {
            return true;
        }
        String trim = string.trim();
        if (trim.length() == 0) {
            return true;
        }
        return trim.equalsIgnoreCase("null");
    }

    protected int _getPort() {
        int port = this.getPort();
        if (port == 0) {
            port = this.detectFreePort();
        }
        return port;
    }

    protected String _getSocket() {
        String socket = this.getSocket();
        if (socket == null) {
            String portStr = String.valueOf(this.getPort());
            socket = SystemUtils.JAVA_IO_TMPDIR + "/MariaDB4j." + portStr + ".sock";
        }
        return socket;
    }

    public String getDatabaseVersion() {
        return this.databaseVersion;
    }

    public void setDatabaseVersion(String databaseVersion) {
        this.databaseVersion = databaseVersion;
    }

    protected String _getDatabaseVersion() {
        String databaseVersion = this.getDatabaseVersion();
        if (databaseVersion == null) {
            if (OSX.equals(this.getOS())) {
                databaseVersion = "mariadb-10.1.9";
            } else if (LINUX.equals(this.getOS())) {
                databaseVersion = "mariadb-10.1.13";
            } else if (WIN32.equals(this.getOS())) {
                databaseVersion = "mariadb-10.1.20";
            } else {
                throw new IllegalStateException("OS not directly supported, please use setDatabaseVersion() to set the name of the package that the binaries are in, for: " + SystemUtils.OS_VERSION);
            }
        }
        return databaseVersion;
    }

    protected String getBinariesClassPathLocation() {
        StringBuilder binariesClassPathLocation = new StringBuilder();
        binariesClassPathLocation.append(this.getClass().getPackage().getName().replace(".", "/"));
        binariesClassPathLocation.append("/").append(this._getDatabaseVersion()).append("/");
        binariesClassPathLocation.append(this.getOS());
        return binariesClassPathLocation.toString();
    }

    public void setOS(String osDirectoryName) {
        this.osDirectoryName = osDirectoryName;
    }

    public String getOS() {
        return this.osDirectoryName;
    }

    protected String _getOSLibraryEnvironmentVarName() {
        return SystemUtils.IS_OS_WINDOWS ? "PATH" : (SystemUtils.IS_OS_MAC ? "DYLD_FALLBACK_LIBRARY_PATH " : "LD_LIBRARY_PATH");
    }

    protected String _getBinariesClassPathLocation() {
        if (this.isUnpackingFromClasspath) {
            return this.getBinariesClassPathLocation();
        }
        return null;
    }

    public boolean isUnpackingFromClasspath() {
        return this.isUnpackingFromClasspath;
    }

    public DBConfigurationBuilder setUnpackingFromClasspath(boolean isUnpackingFromClasspath) {
        this.checkIfFrozen("setUnpackingFromClasspath");
        this.isUnpackingFromClasspath = isUnpackingFromClasspath;
        return this;
    }

    public String getURL(String databaseName) {
        return "jdbc:mysql://localhost:" + this.getPort() + "/" + databaseName;
    }

    public List<String> _getArgs() {
        return this.args;
    }
}

