/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.awaitility.pollinterval;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.testcontainers.shaded.org.awaitility.core.DurationFactory;
import org.testcontainers.shaded.org.awaitility.core.ForeverDuration;
import org.testcontainers.shaded.org.awaitility.pollinterval.PollInterval;

public class FixedPollInterval
implements PollInterval {
    private final Duration duration;

    public FixedPollInterval(Duration duration) {
        if (duration == null) {
            throw new IllegalArgumentException("Duration cannot be null");
        }
        if (ForeverDuration.isForever(duration)) {
            throw new IllegalArgumentException("Cannot use a fixed poll interval of length 'forever'");
        }
        this.duration = duration;
    }

    public FixedPollInterval(long pollInterval, TimeUnit unit) {
        this(DurationFactory.of(pollInterval, unit));
    }

    @Override
    public Duration next(int pollCount, Duration previousDuration) {
        return this.duration;
    }

    public static FixedPollInterval fixed(Duration duration) {
        return new FixedPollInterval(duration);
    }

    public static FixedPollInterval fixed(long pollInterval, TimeUnit unit) {
        return new FixedPollInterval(pollInterval, unit);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FixedPollInterval)) {
            return false;
        }
        FixedPollInterval that = (FixedPollInterval)o;
        return this.duration.equals(that.duration);
    }

    public int hashCode() {
        return this.duration.hashCode();
    }

    public String toString() {
        return "FixedPollInterval{duration=" + this.duration + '}';
    }
}

