/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.servicecontrol.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.servicecontrol.v1.ServiceControlRequest;
import com.google.api.services.servicecontrol.v1.ServiceControlRequestInitializer;
import com.google.api.services.servicecontrol.v1.model.AllocateQuotaRequest;
import com.google.api.services.servicecontrol.v1.model.AllocateQuotaResponse;
import com.google.api.services.servicecontrol.v1.model.CheckRequest;
import com.google.api.services.servicecontrol.v1.model.CheckResponse;
import com.google.api.services.servicecontrol.v1.model.ReportRequest;
import com.google.api.services.servicecontrol.v1.model.ReportResponse;
import java.io.IOException;

public class ServiceControl
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://servicecontrol.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://servicecontrol.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://servicecontrol.googleapis.com/";

    public ServiceControl(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    ServiceControl(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Services services() {
        return new Services();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 1.32.1 of the Service Control API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return ServiceControl.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://servicecontrol.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), ServiceControl.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(ServiceControl.DEFAULT_BATCH_PATH);
        }

        public ServiceControl build() {
            return new ServiceControl(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setServiceControlRequestInitializer(ServiceControlRequestInitializer servicecontrolRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)servicecontrolRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Services {
        public AllocateQuota allocateQuota(String serviceName, AllocateQuotaRequest content) throws IOException {
            AllocateQuota result = new AllocateQuota(serviceName, content);
            ServiceControl.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Check check(String serviceName, CheckRequest content) throws IOException {
            Check result = new Check(serviceName, content);
            ServiceControl.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Report report(String serviceName, ReportRequest content) throws IOException {
            Report result = new Report(serviceName, content);
            ServiceControl.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Report
        extends ServiceControlRequest<ReportResponse> {
            private static final String REST_PATH = "v1/services/{serviceName}:report";
            @Key
            private String serviceName;

            protected Report(String serviceName, ReportRequest content) {
                super(ServiceControl.this, "POST", REST_PATH, (Object)content, ReportResponse.class);
                this.serviceName = (String)Preconditions.checkNotNull((Object)serviceName, (Object)"Required parameter serviceName must be specified.");
            }

            public Report set$Xgafv(String $Xgafv) {
                return (Report)super.set$Xgafv($Xgafv);
            }

            public Report setAccessToken(String accessToken) {
                return (Report)super.setAccessToken(accessToken);
            }

            public Report setAlt(String alt) {
                return (Report)super.setAlt(alt);
            }

            public Report setCallback(String callback) {
                return (Report)super.setCallback(callback);
            }

            public Report setFields(String fields) {
                return (Report)super.setFields(fields);
            }

            public Report setKey(String key) {
                return (Report)super.setKey(key);
            }

            public Report setOauthToken(String oauthToken) {
                return (Report)super.setOauthToken(oauthToken);
            }

            public Report setPrettyPrint(Boolean prettyPrint) {
                return (Report)super.setPrettyPrint(prettyPrint);
            }

            public Report setQuotaUser(String quotaUser) {
                return (Report)super.setQuotaUser(quotaUser);
            }

            public Report setUploadType(String uploadType) {
                return (Report)super.setUploadType(uploadType);
            }

            public Report setUploadProtocol(String uploadProtocol) {
                return (Report)super.setUploadProtocol(uploadProtocol);
            }

            public String getServiceName() {
                return this.serviceName;
            }

            public Report setServiceName(String serviceName) {
                this.serviceName = serviceName;
                return this;
            }

            @Override
            public Report set(String parameterName, Object value) {
                return (Report)super.set(parameterName, value);
            }
        }

        public class Check
        extends ServiceControlRequest<CheckResponse> {
            private static final String REST_PATH = "v1/services/{serviceName}:check";
            @Key
            private String serviceName;

            protected Check(String serviceName, CheckRequest content) {
                super(ServiceControl.this, "POST", REST_PATH, (Object)content, CheckResponse.class);
                this.serviceName = (String)Preconditions.checkNotNull((Object)serviceName, (Object)"Required parameter serviceName must be specified.");
            }

            public Check set$Xgafv(String $Xgafv) {
                return (Check)super.set$Xgafv($Xgafv);
            }

            public Check setAccessToken(String accessToken) {
                return (Check)super.setAccessToken(accessToken);
            }

            public Check setAlt(String alt) {
                return (Check)super.setAlt(alt);
            }

            public Check setCallback(String callback) {
                return (Check)super.setCallback(callback);
            }

            public Check setFields(String fields) {
                return (Check)super.setFields(fields);
            }

            public Check setKey(String key) {
                return (Check)super.setKey(key);
            }

            public Check setOauthToken(String oauthToken) {
                return (Check)super.setOauthToken(oauthToken);
            }

            public Check setPrettyPrint(Boolean prettyPrint) {
                return (Check)super.setPrettyPrint(prettyPrint);
            }

            public Check setQuotaUser(String quotaUser) {
                return (Check)super.setQuotaUser(quotaUser);
            }

            public Check setUploadType(String uploadType) {
                return (Check)super.setUploadType(uploadType);
            }

            public Check setUploadProtocol(String uploadProtocol) {
                return (Check)super.setUploadProtocol(uploadProtocol);
            }

            public String getServiceName() {
                return this.serviceName;
            }

            public Check setServiceName(String serviceName) {
                this.serviceName = serviceName;
                return this;
            }

            @Override
            public Check set(String parameterName, Object value) {
                return (Check)super.set(parameterName, value);
            }
        }

        public class AllocateQuota
        extends ServiceControlRequest<AllocateQuotaResponse> {
            private static final String REST_PATH = "v1/services/{serviceName}:allocateQuota";
            @Key
            private String serviceName;

            protected AllocateQuota(String serviceName, AllocateQuotaRequest content) {
                super(ServiceControl.this, "POST", REST_PATH, (Object)content, AllocateQuotaResponse.class);
                this.serviceName = (String)Preconditions.checkNotNull((Object)serviceName, (Object)"Required parameter serviceName must be specified.");
            }

            public AllocateQuota set$Xgafv(String $Xgafv) {
                return (AllocateQuota)super.set$Xgafv($Xgafv);
            }

            public AllocateQuota setAccessToken(String accessToken) {
                return (AllocateQuota)super.setAccessToken(accessToken);
            }

            public AllocateQuota setAlt(String alt) {
                return (AllocateQuota)super.setAlt(alt);
            }

            public AllocateQuota setCallback(String callback) {
                return (AllocateQuota)super.setCallback(callback);
            }

            public AllocateQuota setFields(String fields) {
                return (AllocateQuota)super.setFields(fields);
            }

            public AllocateQuota setKey(String key) {
                return (AllocateQuota)super.setKey(key);
            }

            public AllocateQuota setOauthToken(String oauthToken) {
                return (AllocateQuota)super.setOauthToken(oauthToken);
            }

            public AllocateQuota setPrettyPrint(Boolean prettyPrint) {
                return (AllocateQuota)super.setPrettyPrint(prettyPrint);
            }

            public AllocateQuota setQuotaUser(String quotaUser) {
                return (AllocateQuota)super.setQuotaUser(quotaUser);
            }

            public AllocateQuota setUploadType(String uploadType) {
                return (AllocateQuota)super.setUploadType(uploadType);
            }

            public AllocateQuota setUploadProtocol(String uploadProtocol) {
                return (AllocateQuota)super.setUploadProtocol(uploadProtocol);
            }

            public String getServiceName() {
                return this.serviceName;
            }

            public AllocateQuota setServiceName(String serviceName) {
                this.serviceName = serviceName;
                return this;
            }

            @Override
            public AllocateQuota set(String parameterName, Object value) {
                return (AllocateQuota)super.set(parameterName, value);
            }
        }
    }
}

