//go:build go1.16
// +build go1.16

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package internal

import (
	"context"
	"errors"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
)

// KeyVaultClient contains the methods for the KeyVaultClient group.
// Don't use this type directly, use NewKeyVaultClient() instead.
type KeyVaultClient struct {
	Pl runtime.Pipeline
}

// NewKeyVaultClient creates a new instance of KeyVaultClient with the specified values.
// options - pass nil to accept the default values.
func NewKeyVaultClient(options *azcore.ClientOptions) *KeyVaultClient {
	if options == nil {
		options = &azcore.ClientOptions{}
	}
	client := &KeyVaultClient{
		Pl: runtime.NewPipeline(ModuleName, ModuleVersion, runtime.PipelineOptions{}, options),
	}
	return client
}

// BackupSecret - Requests that a backup of the specified secret be downloaded to the client. All versions of the secret will
// be downloaded. This operation requires the secrets/backup permission.
// If the operation fails it returns an *azcore.ResponseError type.
// vaultBaseURL - The vault name, for example https://myvault.vault.azure.net.
// secretName - The name of the secret.
// options - KeyVaultClientBackupSecretOptions contains the optional parameters for the KeyVaultClient.BackupSecret method.
func (client *KeyVaultClient) BackupSecret(ctx context.Context, vaultBaseURL string, secretName string, options *KeyVaultClientBackupSecretOptions) (KeyVaultClientBackupSecretResponse, error) {
	req, err := client.backupSecretCreateRequest(ctx, vaultBaseURL, secretName, options)
	if err != nil {
		return KeyVaultClientBackupSecretResponse{}, err
	}
	resp, err := client.Pl.Do(req)
	if err != nil {
		return KeyVaultClientBackupSecretResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return KeyVaultClientBackupSecretResponse{}, runtime.NewResponseError(resp)
	}
	return client.backupSecretHandleResponse(resp)
}

// backupSecretCreateRequest creates the BackupSecret request.
func (client *KeyVaultClient) backupSecretCreateRequest(ctx context.Context, vaultBaseURL string, secretName string, options *KeyVaultClientBackupSecretOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", vaultBaseURL)
	urlPath := "/secrets/{secret-name}/backup"
	if secretName == "" {
		return nil, errors.New("parameter secretName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{secret-name}", url.PathEscape(secretName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// backupSecretHandleResponse handles the BackupSecret response.
func (client *KeyVaultClient) backupSecretHandleResponse(resp *http.Response) (KeyVaultClientBackupSecretResponse, error) {
	result := KeyVaultClientBackupSecretResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BackupSecretResult); err != nil {
		return KeyVaultClientBackupSecretResponse{}, err
	}
	return result, nil
}

// DeleteSecret - The DELETE operation applies to any secret stored in Azure Key Vault. DELETE cannot be applied to an individual
// version of a secret. This operation requires the secrets/delete permission.
// If the operation fails it returns an *azcore.ResponseError type.
// vaultBaseURL - The vault name, for example https://myvault.vault.azure.net.
// secretName - The name of the secret.
// options - KeyVaultClientDeleteSecretOptions contains the optional parameters for the KeyVaultClient.DeleteSecret method.
func (client *KeyVaultClient) DeleteSecret(ctx context.Context, vaultBaseURL string, secretName string, options *KeyVaultClientDeleteSecretOptions) (KeyVaultClientDeleteSecretResponse, error) {
	req, err := client.deleteSecretCreateRequest(ctx, vaultBaseURL, secretName, options)
	if err != nil {
		return KeyVaultClientDeleteSecretResponse{}, err
	}
	resp, err := client.Pl.Do(req)
	if err != nil {
		return KeyVaultClientDeleteSecretResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return KeyVaultClientDeleteSecretResponse{}, runtime.NewResponseError(resp)
	}
	return client.deleteSecretHandleResponse(resp)
}

// deleteSecretCreateRequest creates the DeleteSecret request.
func (client *KeyVaultClient) deleteSecretCreateRequest(ctx context.Context, vaultBaseURL string, secretName string, options *KeyVaultClientDeleteSecretOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", vaultBaseURL)
	urlPath := "/secrets/{secret-name}"
	if secretName == "" {
		return nil, errors.New("parameter secretName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{secret-name}", url.PathEscape(secretName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// deleteSecretHandleResponse handles the DeleteSecret response.
func (client *KeyVaultClient) deleteSecretHandleResponse(resp *http.Response) (KeyVaultClientDeleteSecretResponse, error) {
	result := KeyVaultClientDeleteSecretResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DeletedSecretBundle); err != nil {
		return KeyVaultClientDeleteSecretResponse{}, err
	}
	return result, nil
}

// GetDeletedSecret - The Get Deleted Secret operation returns the specified deleted secret along with its attributes. This
// operation requires the secrets/get permission.
// If the operation fails it returns an *azcore.ResponseError type.
// vaultBaseURL - The vault name, for example https://myvault.vault.azure.net.
// secretName - The name of the secret.
// options - KeyVaultClientGetDeletedSecretOptions contains the optional parameters for the KeyVaultClient.GetDeletedSecret
// method.
func (client *KeyVaultClient) GetDeletedSecret(ctx context.Context, vaultBaseURL string, secretName string, options *KeyVaultClientGetDeletedSecretOptions) (KeyVaultClientGetDeletedSecretResponse, error) {
	req, err := client.getDeletedSecretCreateRequest(ctx, vaultBaseURL, secretName, options)
	if err != nil {
		return KeyVaultClientGetDeletedSecretResponse{}, err
	}
	resp, err := client.Pl.Do(req)
	if err != nil {
		return KeyVaultClientGetDeletedSecretResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return KeyVaultClientGetDeletedSecretResponse{}, runtime.NewResponseError(resp)
	}
	return client.getDeletedSecretHandleResponse(resp)
}

// getDeletedSecretCreateRequest creates the GetDeletedSecret request.
func (client *KeyVaultClient) getDeletedSecretCreateRequest(ctx context.Context, vaultBaseURL string, secretName string, options *KeyVaultClientGetDeletedSecretOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", vaultBaseURL)
	urlPath := "/deletedsecrets/{secret-name}"
	if secretName == "" {
		return nil, errors.New("parameter secretName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{secret-name}", url.PathEscape(secretName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// getDeletedSecretHandleResponse handles the GetDeletedSecret response.
func (client *KeyVaultClient) getDeletedSecretHandleResponse(resp *http.Response) (KeyVaultClientGetDeletedSecretResponse, error) {
	result := KeyVaultClientGetDeletedSecretResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DeletedSecretBundle); err != nil {
		return KeyVaultClientGetDeletedSecretResponse{}, err
	}
	return result, nil
}

// GetDeletedSecrets - The Get Deleted Secrets operation returns the secrets that have been deleted for a vault enabled for
// soft-delete. This operation requires the secrets/list permission.
// If the operation fails it returns an *azcore.ResponseError type.
// vaultBaseURL - The vault name, for example https://myvault.vault.azure.net.
// options - KeyVaultClientGetDeletedSecretsOptions contains the optional parameters for the KeyVaultClient.GetDeletedSecrets
// method.
func (client *KeyVaultClient) GetDeletedSecrets(vaultBaseURL string, options *KeyVaultClientGetDeletedSecretsOptions) *KeyVaultClientGetDeletedSecretsPager {
	return &KeyVaultClientGetDeletedSecretsPager{
		client: client,
		requester: func(ctx context.Context) (*policy.Request, error) {
			return client.GetDeletedSecretsCreateRequest(ctx, vaultBaseURL, options)
		},
		advancer: func(ctx context.Context, resp KeyVaultClientGetDeletedSecretsResponse) (*policy.Request, error) {
			return runtime.NewRequest(ctx, http.MethodGet, *resp.DeletedSecretListResult.NextLink)
		},
	}
}

// GetDeletedSecretsCreateRequest creates the GetDeletedSecrets request.
func (client *KeyVaultClient) GetDeletedSecretsCreateRequest(ctx context.Context, vaultBaseURL string, options *KeyVaultClientGetDeletedSecretsOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", vaultBaseURL)
	urlPath := "/deletedsecrets"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Maxresults != nil {
		reqQP.Set("maxresults", strconv.FormatInt(int64(*options.Maxresults), 10))
	}
	reqQP.Set("api-version", "7.3")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// GetDeletedSecretsHandleResponse handles the GetDeletedSecrets response.
func (client *KeyVaultClient) GetDeletedSecretsHandleResponse(resp *http.Response) (KeyVaultClientGetDeletedSecretsResponse, error) {
	result := KeyVaultClientGetDeletedSecretsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DeletedSecretListResult); err != nil {
		return KeyVaultClientGetDeletedSecretsResponse{}, err
	}
	return result, nil
}

// GetSecret - The GET operation is applicable to any secret stored in Azure Key Vault. This operation requires the secrets/get
// permission.
// If the operation fails it returns an *azcore.ResponseError type.
// vaultBaseURL - The vault name, for example https://myvault.vault.azure.net.
// secretName - The name of the secret.
// secretVersion - The version of the secret. This URI fragment is optional. If not specified, the latest version of the secret
// is returned.
// options - KeyVaultClientGetSecretOptions contains the optional parameters for the KeyVaultClient.GetSecret method.
func (client *KeyVaultClient) GetSecret(ctx context.Context, vaultBaseURL string, secretName string, secretVersion string, options *KeyVaultClientGetSecretOptions) (KeyVaultClientGetSecretResponse, error) {
	req, err := client.getSecretCreateRequest(ctx, vaultBaseURL, secretName, secretVersion, options)
	if err != nil {
		return KeyVaultClientGetSecretResponse{}, err
	}
	resp, err := client.Pl.Do(req)
	if err != nil {
		return KeyVaultClientGetSecretResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return KeyVaultClientGetSecretResponse{}, runtime.NewResponseError(resp)
	}
	return client.getSecretHandleResponse(resp)
}

// getSecretCreateRequest creates the GetSecret request.
func (client *KeyVaultClient) getSecretCreateRequest(ctx context.Context, vaultBaseURL string, secretName string, secretVersion string, options *KeyVaultClientGetSecretOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", vaultBaseURL)
	urlPath := "/secrets/{secret-name}/{secret-version}"
	if secretName == "" {
		return nil, errors.New("parameter secretName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{secret-name}", url.PathEscape(secretName))
	// if secretVersion == "" {
	// 	return nil, errors.New("parameter secretVersion cannot be empty")
	// }
	urlPath = strings.ReplaceAll(urlPath, "{secret-version}", url.PathEscape(secretVersion))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// getSecretHandleResponse handles the GetSecret response.
func (client *KeyVaultClient) getSecretHandleResponse(resp *http.Response) (KeyVaultClientGetSecretResponse, error) {
	result := KeyVaultClientGetSecretResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SecretBundle); err != nil {
		return KeyVaultClientGetSecretResponse{}, err
	}
	return result, nil
}

// GetSecretVersions - The full secret identifier and attributes are provided in the response. No values are returned for
// the secrets. This operations requires the secrets/list permission.
// If the operation fails it returns an *azcore.ResponseError type.
// vaultBaseURL - The vault name, for example https://myvault.vault.azure.net.
// secretName - The name of the secret.
// options - KeyVaultClientGetSecretVersionsOptions contains the optional parameters for the KeyVaultClient.GetSecretVersions
// method.
func (client *KeyVaultClient) GetSecretVersions(vaultBaseURL string, secretName string, options *KeyVaultClientGetSecretVersionsOptions) *KeyVaultClientGetSecretVersionsPager {
	return &KeyVaultClientGetSecretVersionsPager{
		client: client,
		requester: func(ctx context.Context) (*policy.Request, error) {
			return client.GetSecretVersionsCreateRequest(ctx, vaultBaseURL, secretName, options)
		},
		advancer: func(ctx context.Context, resp KeyVaultClientGetSecretVersionsResponse) (*policy.Request, error) {
			return runtime.NewRequest(ctx, http.MethodGet, *resp.SecretListResult.NextLink)
		},
	}
}

// GetSecretVersionsCreateRequest creates the GetSecretVersions request.
func (client *KeyVaultClient) GetSecretVersionsCreateRequest(ctx context.Context, vaultBaseURL string, secretName string, options *KeyVaultClientGetSecretVersionsOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", vaultBaseURL)
	urlPath := "/secrets/{secret-name}/versions"
	if secretName == "" {
		return nil, errors.New("parameter secretName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{secret-name}", url.PathEscape(secretName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Maxresults != nil {
		reqQP.Set("maxresults", strconv.FormatInt(int64(*options.Maxresults), 10))
	}
	reqQP.Set("api-version", "7.3")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// GetSecretVersionsHandleResponse handles the GetSecretVersions response.
func (client *KeyVaultClient) GetSecretVersionsHandleResponse(resp *http.Response) (KeyVaultClientGetSecretVersionsResponse, error) {
	result := KeyVaultClientGetSecretVersionsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SecretListResult); err != nil {
		return KeyVaultClientGetSecretVersionsResponse{}, err
	}
	return result, nil
}

// GetSecrets - The Get Secrets operation is applicable to the entire vault. However, only the base secret identifier and
// its attributes are provided in the response. Individual secret versions are not listed in the
// response. This operation requires the secrets/list permission.
// If the operation fails it returns an *azcore.ResponseError type.
// vaultBaseURL - The vault name, for example https://myvault.vault.azure.net.
// options - KeyVaultClientGetSecretsOptions contains the optional parameters for the KeyVaultClient.GetSecrets method.
func (client *KeyVaultClient) GetSecrets(vaultBaseURL string, options *KeyVaultClientGetSecretsOptions) *KeyVaultClientGetSecretsPager {
	return &KeyVaultClientGetSecretsPager{
		client: client,
		requester: func(ctx context.Context) (*policy.Request, error) {
			return client.GetSecretsCreateRequest(ctx, vaultBaseURL, options)
		},
		advancer: func(ctx context.Context, resp KeyVaultClientGetSecretsResponse) (*policy.Request, error) {
			return runtime.NewRequest(ctx, http.MethodGet, *resp.SecretListResult.NextLink)
		},
	}
}

// GetSecretsCreateRequest creates the GetSecrets request.
func (client *KeyVaultClient) GetSecretsCreateRequest(ctx context.Context, vaultBaseURL string, options *KeyVaultClientGetSecretsOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", vaultBaseURL)
	urlPath := "/secrets"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Maxresults != nil {
		reqQP.Set("maxresults", strconv.FormatInt(int64(*options.Maxresults), 10))
	}
	reqQP.Set("api-version", "7.3")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// GetSecretsHandleResponse handles the GetSecrets response.
func (client *KeyVaultClient) GetSecretsHandleResponse(resp *http.Response) (KeyVaultClientGetSecretsResponse, error) {
	result := KeyVaultClientGetSecretsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SecretListResult); err != nil {
		return KeyVaultClientGetSecretsResponse{}, err
	}
	return result, nil
}

// PurgeDeletedSecret - The purge deleted secret operation removes the secret permanently, without the possibility of recovery.
// This operation can only be enabled on a soft-delete enabled vault. This operation requires the
// secrets/purge permission.
// If the operation fails it returns an *azcore.ResponseError type.
// vaultBaseURL - The vault name, for example https://myvault.vault.azure.net.
// secretName - The name of the secret.
// options - KeyVaultClientPurgeDeletedSecretOptions contains the optional parameters for the KeyVaultClient.PurgeDeletedSecret
// method.
func (client *KeyVaultClient) PurgeDeletedSecret(ctx context.Context, vaultBaseURL string, secretName string, options *KeyVaultClientPurgeDeletedSecretOptions) (KeyVaultClientPurgeDeletedSecretResponse, error) {
	req, err := client.purgeDeletedSecretCreateRequest(ctx, vaultBaseURL, secretName, options)
	if err != nil {
		return KeyVaultClientPurgeDeletedSecretResponse{}, err
	}
	resp, err := client.Pl.Do(req)
	if err != nil {
		return KeyVaultClientPurgeDeletedSecretResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return KeyVaultClientPurgeDeletedSecretResponse{}, runtime.NewResponseError(resp)
	}
	return KeyVaultClientPurgeDeletedSecretResponse{}, nil
}

// purgeDeletedSecretCreateRequest creates the PurgeDeletedSecret request.
func (client *KeyVaultClient) purgeDeletedSecretCreateRequest(ctx context.Context, vaultBaseURL string, secretName string, options *KeyVaultClientPurgeDeletedSecretOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", vaultBaseURL)
	urlPath := "/deletedsecrets/{secret-name}"
	if secretName == "" {
		return nil, errors.New("parameter secretName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{secret-name}", url.PathEscape(secretName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// RecoverDeletedSecret - Recovers the deleted secret in the specified vault. This operation can only be performed on a soft-delete
// enabled vault. This operation requires the secrets/recover permission.
// If the operation fails it returns an *azcore.ResponseError type.
// vaultBaseURL - The vault name, for example https://myvault.vault.azure.net.
// secretName - The name of the deleted secret.
// options - KeyVaultClientRecoverDeletedSecretOptions contains the optional parameters for the KeyVaultClient.RecoverDeletedSecret
// method.
func (client *KeyVaultClient) RecoverDeletedSecret(ctx context.Context, vaultBaseURL string, secretName string, options *KeyVaultClientRecoverDeletedSecretOptions) (KeyVaultClientRecoverDeletedSecretResponse, error) {
	req, err := client.recoverDeletedSecretCreateRequest(ctx, vaultBaseURL, secretName, options)
	if err != nil {
		return KeyVaultClientRecoverDeletedSecretResponse{}, err
	}
	resp, err := client.Pl.Do(req)
	if err != nil {
		return KeyVaultClientRecoverDeletedSecretResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return KeyVaultClientRecoverDeletedSecretResponse{}, runtime.NewResponseError(resp)
	}
	return client.recoverDeletedSecretHandleResponse(resp)
}

// recoverDeletedSecretCreateRequest creates the RecoverDeletedSecret request.
func (client *KeyVaultClient) recoverDeletedSecretCreateRequest(ctx context.Context, vaultBaseURL string, secretName string, options *KeyVaultClientRecoverDeletedSecretOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", vaultBaseURL)
	urlPath := "/deletedsecrets/{secret-name}/recover"
	if secretName == "" {
		return nil, errors.New("parameter secretName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{secret-name}", url.PathEscape(secretName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// recoverDeletedSecretHandleResponse handles the RecoverDeletedSecret response.
func (client *KeyVaultClient) recoverDeletedSecretHandleResponse(resp *http.Response) (KeyVaultClientRecoverDeletedSecretResponse, error) {
	result := KeyVaultClientRecoverDeletedSecretResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SecretBundle); err != nil {
		return KeyVaultClientRecoverDeletedSecretResponse{}, err
	}
	return result, nil
}

// RestoreSecret - Restores a backed up secret, and all its versions, to a vault. This operation requires the secrets/restore
// permission.
// If the operation fails it returns an *azcore.ResponseError type.
// vaultBaseURL - The vault name, for example https://myvault.vault.azure.net.
// parameters - The parameters to restore the secret.
// options - KeyVaultClientRestoreSecretOptions contains the optional parameters for the KeyVaultClient.RestoreSecret method.
func (client *KeyVaultClient) RestoreSecret(ctx context.Context, vaultBaseURL string, parameters SecretRestoreParameters, options *KeyVaultClientRestoreSecretOptions) (KeyVaultClientRestoreSecretResponse, error) {
	req, err := client.restoreSecretCreateRequest(ctx, vaultBaseURL, parameters, options)
	if err != nil {
		return KeyVaultClientRestoreSecretResponse{}, err
	}
	resp, err := client.Pl.Do(req)
	if err != nil {
		return KeyVaultClientRestoreSecretResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return KeyVaultClientRestoreSecretResponse{}, runtime.NewResponseError(resp)
	}
	return client.restoreSecretHandleResponse(resp)
}

// restoreSecretCreateRequest creates the RestoreSecret request.
func (client *KeyVaultClient) restoreSecretCreateRequest(ctx context.Context, vaultBaseURL string, parameters SecretRestoreParameters, options *KeyVaultClientRestoreSecretOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", vaultBaseURL)
	urlPath := "/secrets/restore"
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, runtime.MarshalAsJSON(req, parameters)
}

// restoreSecretHandleResponse handles the RestoreSecret response.
func (client *KeyVaultClient) restoreSecretHandleResponse(resp *http.Response) (KeyVaultClientRestoreSecretResponse, error) {
	result := KeyVaultClientRestoreSecretResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SecretBundle); err != nil {
		return KeyVaultClientRestoreSecretResponse{}, err
	}
	return result, nil
}

// SetSecret - The SET operation adds a secret to the Azure Key Vault. If the named secret already exists, Azure Key Vault
// creates a new version of that secret. This operation requires the secrets/set permission.
// If the operation fails it returns an *azcore.ResponseError type.
// vaultBaseURL - The vault name, for example https://myvault.vault.azure.net.
// secretName - The name of the secret.
// parameters - The parameters for setting the secret.
// options - KeyVaultClientSetSecretOptions contains the optional parameters for the KeyVaultClient.SetSecret method.
func (client *KeyVaultClient) SetSecret(ctx context.Context, vaultBaseURL string, secretName string, parameters SecretSetParameters, options *KeyVaultClientSetSecretOptions) (KeyVaultClientSetSecretResponse, error) {
	req, err := client.setSecretCreateRequest(ctx, vaultBaseURL, secretName, parameters, options)
	if err != nil {
		return KeyVaultClientSetSecretResponse{}, err
	}
	resp, err := client.Pl.Do(req)
	if err != nil {
		return KeyVaultClientSetSecretResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return KeyVaultClientSetSecretResponse{}, runtime.NewResponseError(resp)
	}
	return client.setSecretHandleResponse(resp)
}

// setSecretCreateRequest creates the SetSecret request.
func (client *KeyVaultClient) setSecretCreateRequest(ctx context.Context, vaultBaseURL string, secretName string, parameters SecretSetParameters, options *KeyVaultClientSetSecretOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", vaultBaseURL)
	urlPath := "/secrets/{secret-name}"
	if secretName == "" {
		return nil, errors.New("parameter secretName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{secret-name}", url.PathEscape(secretName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, runtime.MarshalAsJSON(req, parameters)
}

// setSecretHandleResponse handles the SetSecret response.
func (client *KeyVaultClient) setSecretHandleResponse(resp *http.Response) (KeyVaultClientSetSecretResponse, error) {
	result := KeyVaultClientSetSecretResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SecretBundle); err != nil {
		return KeyVaultClientSetSecretResponse{}, err
	}
	return result, nil
}

// UpdateSecret - The UPDATE operation changes specified attributes of an existing stored secret. Attributes that are not
// specified in the request are left unchanged. The value of a secret itself cannot be changed.
// This operation requires the secrets/set permission.
// If the operation fails it returns an *azcore.ResponseError type.
// vaultBaseURL - The vault name, for example https://myvault.vault.azure.net.
// secretName - The name of the secret.
// secretVersion - The version of the secret.
// parameters - The parameters for update secret operation.
// options - KeyVaultClientUpdateSecretOptions contains the optional parameters for the KeyVaultClient.UpdateSecret method.
func (client *KeyVaultClient) UpdateSecret(ctx context.Context, vaultBaseURL string, secretName string, secretVersion string, parameters SecretUpdateParameters, options *KeyVaultClientUpdateSecretOptions) (KeyVaultClientUpdateSecretResponse, error) {
	req, err := client.updateSecretCreateRequest(ctx, vaultBaseURL, secretName, secretVersion, parameters, options)
	if err != nil {
		return KeyVaultClientUpdateSecretResponse{}, err
	}
	resp, err := client.Pl.Do(req)
	if err != nil {
		return KeyVaultClientUpdateSecretResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return KeyVaultClientUpdateSecretResponse{}, runtime.NewResponseError(resp)
	}
	return client.updateSecretHandleResponse(resp)
}

// updateSecretCreateRequest creates the UpdateSecret request.
func (client *KeyVaultClient) updateSecretCreateRequest(ctx context.Context, vaultBaseURL string, secretName string, secretVersion string, parameters SecretUpdateParameters, options *KeyVaultClientUpdateSecretOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", vaultBaseURL)
	urlPath := "/secrets/{secret-name}/{secret-version}"
	if secretName == "" {
		return nil, errors.New("parameter secretName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{secret-name}", url.PathEscape(secretName))
	// if secretVersion == "" {
	// 	return nil, errors.New("parameter secretVersion cannot be empty")
	// }
	urlPath = strings.ReplaceAll(urlPath, "{secret-version}", url.PathEscape(secretVersion))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, runtime.MarshalAsJSON(req, parameters)
}

// updateSecretHandleResponse handles the UpdateSecret response.
func (client *KeyVaultClient) updateSecretHandleResponse(resp *http.Response) (KeyVaultClientUpdateSecretResponse, error) {
	result := KeyVaultClientUpdateSecretResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SecretBundle); err != nil {
		return KeyVaultClientUpdateSecretResponse{}, err
	}
	return result, nil
}
