//go:build go1.16
// +build go1.16

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package internal

import "time"

// Attributes - The object attributes managed by the KeyVault service.
type Attributes struct {
	// Determines whether the object is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// Expiry date in UTC.
	Expires *time.Time `json:"exp,omitempty"`

	// Not before date in UTC.
	NotBefore *time.Time `json:"nbf,omitempty"`

	// READ-ONLY; Creation time in UTC.
	Created *time.Time `json:"created,omitempty" azure:"ro"`

	// READ-ONLY; Last updated time in UTC.
	Updated *time.Time `json:"updated,omitempty" azure:"ro"`
}

// BackupSecretResult - The backup secret result, containing the backup blob.
type BackupSecretResult struct {
	// READ-ONLY; The backup blob containing the backed up secret.
	Value []byte `json:"value,omitempty" azure:"ro"`
}

// DeletedSecretBundle - A Deleted Secret consisting of its previous id, attributes and its tags, as well as information on
// when it will be purged.
type DeletedSecretBundle struct {
	// The secret management attributes.
	Attributes *SecretAttributes `json:"attributes,omitempty"`

	// The content type of the secret.
	ContentType *string `json:"contentType,omitempty"`

	// The secret id.
	ID *string `json:"id,omitempty"`

	// The url of the recovery object, used to identify and recover the deleted secret.
	RecoveryID *string `json:"recoveryId,omitempty"`

	// Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags,omitempty"`

	// The secret value.
	Value *string `json:"value,omitempty"`

	// READ-ONLY; The time when the secret was deleted, in UTC
	DeletedDate *time.Time `json:"deletedDate,omitempty" azure:"ro"`

	// READ-ONLY; If this is a secret backing a KV certificate, then this field specifies the corresponding key backing the KV
	// certificate.
	Kid *string `json:"kid,omitempty" azure:"ro"`

	// READ-ONLY; True if the secret's lifetime is managed by key vault. If this is a secret backing a certificate, then managed
	// will be true.
	Managed *bool `json:"managed,omitempty" azure:"ro"`

	// READ-ONLY; The time when the secret is scheduled to be purged, in UTC
	ScheduledPurgeDate *time.Time `json:"scheduledPurgeDate,omitempty" azure:"ro"`
}

// DeletedSecretItem - The deleted secret item containing metadata about the deleted secret.
type DeletedSecretItem struct {
	// The secret management attributes.
	Attributes *SecretAttributes `json:"attributes,omitempty"`

	// Type of the secret value such as a password.
	ContentType *string `json:"contentType,omitempty"`

	// Secret identifier.
	ID *string `json:"id,omitempty"`

	// The url of the recovery object, used to identify and recover the deleted secret.
	RecoveryID *string `json:"recoveryId,omitempty"`

	// Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The time when the secret was deleted, in UTC
	DeletedDate *time.Time `json:"deletedDate,omitempty" azure:"ro"`

	// READ-ONLY; True if the secret's lifetime is managed by key vault. If this is a key backing a certificate, then managed
	// will be true.
	Managed *bool `json:"managed,omitempty" azure:"ro"`

	// READ-ONLY; The time when the secret is scheduled to be purged, in UTC
	ScheduledPurgeDate *time.Time `json:"scheduledPurgeDate,omitempty" azure:"ro"`
}

// DeletedSecretListResult - The deleted secret list result
type DeletedSecretListResult struct {
	// READ-ONLY; The URL to get the next set of deleted secrets.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; A response message containing a list of the deleted secrets in the vault along with a link to the next page
	// of deleted secrets
	Value []*DeletedSecretItem `json:"value,omitempty" azure:"ro"`
}

// Error - The key vault server error.
type Error struct {
	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The key vault server error.
	InnerError *Error `json:"innererror,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`
}

// KeyVaultClientBackupSecretOptions contains the optional parameters for the KeyVaultClient.BackupSecret method.
type KeyVaultClientBackupSecretOptions struct {
	// placeholder for future optional parameters
}

// KeyVaultClientDeleteSecretOptions contains the optional parameters for the KeyVaultClient.DeleteSecret method.
type KeyVaultClientDeleteSecretOptions struct {
	// placeholder for future optional parameters
}

// KeyVaultClientGetDeletedSecretOptions contains the optional parameters for the KeyVaultClient.GetDeletedSecret method.
type KeyVaultClientGetDeletedSecretOptions struct {
	// placeholder for future optional parameters
}

// KeyVaultClientGetDeletedSecretsOptions contains the optional parameters for the KeyVaultClient.GetDeletedSecrets method.
type KeyVaultClientGetDeletedSecretsOptions struct {
	// Maximum number of results to return in a page. If not specified the service will return up to 25 results.
	Maxresults *int32
}

// KeyVaultClientGetSecretOptions contains the optional parameters for the KeyVaultClient.GetSecret method.
type KeyVaultClientGetSecretOptions struct {
	// placeholder for future optional parameters
}

// KeyVaultClientGetSecretVersionsOptions contains the optional parameters for the KeyVaultClient.GetSecretVersions method.
type KeyVaultClientGetSecretVersionsOptions struct {
	// Maximum number of results to return in a page. If not specified, the service will return up to 25 results.
	Maxresults *int32
}

// KeyVaultClientGetSecretsOptions contains the optional parameters for the KeyVaultClient.GetSecrets method.
type KeyVaultClientGetSecretsOptions struct {
	// Maximum number of results to return in a page. If not specified, the service will return up to 25 results.
	Maxresults *int32
}

// KeyVaultClientPurgeDeletedSecretOptions contains the optional parameters for the KeyVaultClient.PurgeDeletedSecret method.
type KeyVaultClientPurgeDeletedSecretOptions struct {
	// placeholder for future optional parameters
}

// KeyVaultClientRecoverDeletedSecretOptions contains the optional parameters for the KeyVaultClient.RecoverDeletedSecret
// method.
type KeyVaultClientRecoverDeletedSecretOptions struct {
	// placeholder for future optional parameters
}

// KeyVaultClientRestoreSecretOptions contains the optional parameters for the KeyVaultClient.RestoreSecret method.
type KeyVaultClientRestoreSecretOptions struct {
	// placeholder for future optional parameters
}

// KeyVaultClientSetSecretOptions contains the optional parameters for the KeyVaultClient.SetSecret method.
type KeyVaultClientSetSecretOptions struct {
	// placeholder for future optional parameters
}

// KeyVaultClientUpdateSecretOptions contains the optional parameters for the KeyVaultClient.UpdateSecret method.
type KeyVaultClientUpdateSecretOptions struct {
	// placeholder for future optional parameters
}

// KeyVaultError - The key vault error exception.
type KeyVaultError struct {
	// READ-ONLY; The key vault server error.
	Error *Error `json:"error,omitempty" azure:"ro"`
}

// SecretAttributes - The secret management attributes.
type SecretAttributes struct {
	// Determines whether the object is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// Expiry date in UTC.
	Expires *time.Time `json:"exp,omitempty"`

	// Not before date in UTC.
	NotBefore *time.Time `json:"nbf,omitempty"`

	// READ-ONLY; Creation time in UTC.
	Created *time.Time `json:"created,omitempty" azure:"ro"`

	// READ-ONLY; softDelete data retention days. Value should be >=7 and <=90 when softDelete enabled, otherwise 0.
	RecoverableDays *int32 `json:"recoverableDays,omitempty" azure:"ro"`

	// READ-ONLY; Reflects the deletion recovery level currently in effect for secrets in the current vault. If it contains 'Purgeable',
	// the secret can be permanently deleted by a privileged user; otherwise, only the
	// system can purge the secret, at the end of the retention interval.
	RecoveryLevel *DeletionRecoveryLevel `json:"recoveryLevel,omitempty" azure:"ro"`

	// READ-ONLY; Last updated time in UTC.
	Updated *time.Time `json:"updated,omitempty" azure:"ro"`
}

// SecretBundle - A secret consisting of a value, id and its attributes.
type SecretBundle struct {
	// The secret management attributes.
	Attributes *SecretAttributes `json:"attributes,omitempty"`

	// The content type of the secret.
	ContentType *string `json:"contentType,omitempty"`

	// The secret id.
	ID *string `json:"id,omitempty"`

	// Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags,omitempty"`

	// The secret value.
	Value *string `json:"value,omitempty"`

	// READ-ONLY; If this is a secret backing a KV certificate, then this field specifies the corresponding key backing the KV
	// certificate.
	Kid *string `json:"kid,omitempty" azure:"ro"`

	// READ-ONLY; True if the secret's lifetime is managed by key vault. If this is a secret backing a certificate, then managed
	// will be true.
	Managed *bool `json:"managed,omitempty" azure:"ro"`
}

// SecretItem - The secret item containing secret metadata.
type SecretItem struct {
	// The secret management attributes.
	Attributes *SecretAttributes `json:"attributes,omitempty"`

	// Type of the secret value such as a password.
	ContentType *string `json:"contentType,omitempty"`

	// Secret identifier.
	ID *string `json:"id,omitempty"`

	// Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; True if the secret's lifetime is managed by key vault. If this is a key backing a certificate, then managed
	// will be true.
	Managed *bool `json:"managed,omitempty" azure:"ro"`
}

// SecretListResult - The secret list result.
type SecretListResult struct {
	// READ-ONLY; The URL to get the next set of secrets.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; A response message containing a list of secrets in the key vault along with a link to the next page of secrets.
	Value []*SecretItem `json:"value,omitempty" azure:"ro"`
}

// SecretProperties - Properties of the key backing a certificate.
type SecretProperties struct {
	// The media type (MIME type).
	ContentType *string `json:"contentType,omitempty"`
}

// SecretRestoreParameters - The secret restore parameters.
type SecretRestoreParameters struct {
	// REQUIRED; The backup blob associated with a secret bundle.
	SecretBundleBackup []byte `json:"value,omitempty"`
}

// SecretSetParameters - The secret set parameters.
type SecretSetParameters struct {
	// REQUIRED; The value of the secret.
	Value *string `json:"value,omitempty"`

	// Type of the secret value such as a password.
	ContentType *string `json:"contentType,omitempty"`

	// The secret management attributes.
	SecretAttributes *SecretAttributes `json:"attributes,omitempty"`

	// Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags,omitempty"`
}

// SecretUpdateParameters - The secret update parameters.
type SecretUpdateParameters struct {
	// Type of the secret value such as a password.
	ContentType *string `json:"contentType,omitempty"`

	// The secret management attributes.
	SecretAttributes *SecretAttributes `json:"attributes,omitempty"`

	// Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags,omitempty"`
}
