//go:build go1.16
// +build go1.16

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package internal

import (
	"encoding/json"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type Attributes.
func (a Attributes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeUnix(objectMap, "created", a.Created)
	populate(objectMap, "enabled", a.Enabled)
	populateTimeUnix(objectMap, "exp", a.Expires)
	populateTimeUnix(objectMap, "nbf", a.NotBefore)
	populateTimeUnix(objectMap, "updated", a.Updated)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Attributes.
func (a *Attributes) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "created":
			err = unpopulateTimeUnix(val, &a.Created)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, &a.Enabled)
			delete(rawMsg, key)
		case "exp":
			err = unpopulateTimeUnix(val, &a.Expires)
			delete(rawMsg, key)
		case "nbf":
			err = unpopulateTimeUnix(val, &a.NotBefore)
			delete(rawMsg, key)
		case "updated":
			err = unpopulateTimeUnix(val, &a.Updated)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupSecretResult.
func (b BackupSecretResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateByteArray(objectMap, "value", b.Value, runtime.Base64URLFormat)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupSecretResult.
func (b *BackupSecretResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = runtime.DecodeByteArray(string(val), &b.Value, runtime.Base64URLFormat)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeletedSecretBundle.
func (d DeletedSecretBundle) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "attributes", d.Attributes)
	populate(objectMap, "contentType", d.ContentType)
	populateTimeUnix(objectMap, "deletedDate", d.DeletedDate)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "kid", d.Kid)
	populate(objectMap, "managed", d.Managed)
	populate(objectMap, "recoveryId", d.RecoveryID)
	populateTimeUnix(objectMap, "scheduledPurgeDate", d.ScheduledPurgeDate)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeletedSecretBundle.
func (d *DeletedSecretBundle) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "attributes":
			err = unpopulate(val, &d.Attributes)
			delete(rawMsg, key)
		case "contentType":
			err = unpopulate(val, &d.ContentType)
			delete(rawMsg, key)
		case "deletedDate":
			err = unpopulateTimeUnix(val, &d.DeletedDate)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, &d.ID)
			delete(rawMsg, key)
		case "kid":
			err = unpopulate(val, &d.Kid)
			delete(rawMsg, key)
		case "managed":
			err = unpopulate(val, &d.Managed)
			delete(rawMsg, key)
		case "recoveryId":
			err = unpopulate(val, &d.RecoveryID)
			delete(rawMsg, key)
		case "scheduledPurgeDate":
			err = unpopulateTimeUnix(val, &d.ScheduledPurgeDate)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, &d.Tags)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeletedSecretItem.
func (d DeletedSecretItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "attributes", d.Attributes)
	populate(objectMap, "contentType", d.ContentType)
	populateTimeUnix(objectMap, "deletedDate", d.DeletedDate)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "managed", d.Managed)
	populate(objectMap, "recoveryId", d.RecoveryID)
	populateTimeUnix(objectMap, "scheduledPurgeDate", d.ScheduledPurgeDate)
	populate(objectMap, "tags", d.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeletedSecretItem.
func (d *DeletedSecretItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "attributes":
			err = unpopulate(val, &d.Attributes)
			delete(rawMsg, key)
		case "contentType":
			err = unpopulate(val, &d.ContentType)
			delete(rawMsg, key)
		case "deletedDate":
			err = unpopulateTimeUnix(val, &d.DeletedDate)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, &d.ID)
			delete(rawMsg, key)
		case "managed":
			err = unpopulate(val, &d.Managed)
			delete(rawMsg, key)
		case "recoveryId":
			err = unpopulate(val, &d.RecoveryID)
			delete(rawMsg, key)
		case "scheduledPurgeDate":
			err = unpopulateTimeUnix(val, &d.ScheduledPurgeDate)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, &d.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeletedSecretListResult.
func (d DeletedSecretListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SecretAttributes.
func (s SecretAttributes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeUnix(objectMap, "created", s.Created)
	populate(objectMap, "enabled", s.Enabled)
	populateTimeUnix(objectMap, "exp", s.Expires)
	populateTimeUnix(objectMap, "nbf", s.NotBefore)
	populate(objectMap, "recoverableDays", s.RecoverableDays)
	populate(objectMap, "recoveryLevel", s.RecoveryLevel)
	populateTimeUnix(objectMap, "updated", s.Updated)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecretAttributes.
func (s *SecretAttributes) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "created":
			err = unpopulateTimeUnix(val, &s.Created)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, &s.Enabled)
			delete(rawMsg, key)
		case "exp":
			err = unpopulateTimeUnix(val, &s.Expires)
			delete(rawMsg, key)
		case "nbf":
			err = unpopulateTimeUnix(val, &s.NotBefore)
			delete(rawMsg, key)
		case "recoverableDays":
			err = unpopulate(val, &s.RecoverableDays)
			delete(rawMsg, key)
		case "recoveryLevel":
			err = unpopulate(val, &s.RecoveryLevel)
			delete(rawMsg, key)
		case "updated":
			err = unpopulateTimeUnix(val, &s.Updated)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecretBundle.
func (s SecretBundle) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "attributes", s.Attributes)
	populate(objectMap, "contentType", s.ContentType)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kid", s.Kid)
	populate(objectMap, "managed", s.Managed)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SecretItem.
func (s SecretItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "attributes", s.Attributes)
	populate(objectMap, "contentType", s.ContentType)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "managed", s.Managed)
	populate(objectMap, "tags", s.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SecretListResult.
func (s SecretListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SecretRestoreParameters.
func (s SecretRestoreParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateByteArray(objectMap, "value", s.SecretBundleBackup, runtime.Base64URLFormat)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecretRestoreParameters.
func (s *SecretRestoreParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = runtime.DecodeByteArray(string(val), &s.SecretBundleBackup, runtime.Base64URLFormat)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecretSetParameters.
func (s SecretSetParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "contentType", s.ContentType)
	populate(objectMap, "attributes", s.SecretAttributes)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SecretUpdateParameters.
func (s SecretUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "contentType", s.ContentType)
	populate(objectMap, "attributes", s.SecretAttributes)
	populate(objectMap, "tags", s.Tags)
	return json.Marshal(objectMap)
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateByteArray(m map[string]interface{}, k string, b []byte, f runtime.Base64Encoding) {
	if azcore.IsNullValue(b) {
		m[k] = nil
	} else if len(b) == 0 {
		return
	} else {
		m[k] = runtime.EncodeByteArray(b, f)
	}
}

func unpopulate(data json.RawMessage, v interface{}) error {
	if data == nil {
		return nil
	}
	return json.Unmarshal(data, v)
}
