﻿// Copyright 2004-2021 Castle Project - http://www.castleproject.org/
// 
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// 
//     http://www.apache.org/licenses/LICENSE-2.0
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

namespace Castle.DynamicProxy.Tests
{
	using Castle.DynamicProxy.Tests.Interceptors;
	using Castle.DynamicProxy.Tests.Interfaces;

	using NUnit.Framework;

	[TestFixture]
	public class InterceptionRetryTestCase : BasePEVerifyTestCase
	{
		[Test]
		public void Interceptor_can_proceed_multiple_times()
		{
			var interceptor = new ProceedNTimesInterceptor(3);
			var target = new Simple();
			var proxy = generator.CreateInterfaceProxyWithTarget<ISimple>(target, interceptor);

			proxy.Method();

			Assert.AreEqual(3, target.Count);
		}

		[Test]
		public void Interceptor_can_proceed_multiple_times_after_exception_from_within()
		{
			var interceptor = new ProceedNTimesInterceptor(5);
			var throwing = new ThrowingInterceptor();
			var target = new Simple();
			var proxy = generator.CreateInterfaceProxyWithTarget<ISimple>(target, interceptor, throwing);

			proxy.Method();
		}
	}
}