// Copyright 2004-2021 Castle Project - http://www.castleproject.org/
// 
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// 
//     http://www.apache.org/licenses/LICENSE-2.0
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

namespace Castle.Components.DictionaryAdapter
{
	using System;
	using System.Collections;

	/// <summary>
	/// Defines the contract for building typed dictionary keys.
	/// </summary>
	public interface IDictionaryKeyBuilder : IDictionaryBehavior
	{
		/// <summary>
		/// Builds the specified key.
		/// </summary>
		/// <param name="dictionaryAdapter">The dictionary adapter.</param>
		/// <param name="key">The current key.</param>
		/// <param name="property">The property.</param>
		/// <returns>The updated key</returns>
		string GetKey(IDictionaryAdapter dictionaryAdapter, string key, PropertyDescriptor property);
	}
}