﻿// Copyright 2004-2021 Castle Project - http://www.castleproject.org/
// 
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// 
//     http://www.apache.org/licenses/LICENSE-2.0
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.f
// See the License for the specific language governing permissions and
// limitations under the License.

namespace Castle.Components.DictionaryAdapter.Xml
{
	using System;

	public interface IXmlAccessor
	{
		Type ClrType { get; }
		XmlTypeSerializer Serializer { get; }
		IXmlContext Context { get; }
		bool IsNillable { get; }
		bool IsReference { get; }

		object GetValue(IXmlNode   node,   IDictionaryAdapter parentObject, XmlReferenceManager references, bool nodeExists, bool orStub);
		void   SetValue(IXmlCursor cursor, IDictionaryAdapter parentObject, XmlReferenceManager references, bool hasCurrent, object oldValue, ref object newValue);

		IXmlCollectionAccessor GetCollectionAccessor(Type itemType);
	}
}
