﻿// ------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//     Runtime Version: 17.0.0.0
//  
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </auto-generated>
// ------------------------------------------------------------------------------
namespace MessagePack.SourceGenerator.Transforms
{
    using System;
    using System.Linq;
    using System.Collections.Generic;
    using MessagePack.SourceGenerator.CodeAnalysis;
    
    /// <summary>
    /// Class to produce the template output
    /// </summary>
    [global::System.CodeDom.Compiler.GeneratedCodeAttribute("Microsoft.VisualStudio.TextTemplating", "17.0.0.0")]
    public partial class StringKeyFormatterTemplate : StringKeyFormatterTemplateBase
    {
        /// <summary>
        /// Create the template output
        /// </summary>
        public virtual string TransformText()
        {
            this.Write("\r\nusing MsgPack = global::MessagePack;\r\n\r\n");
 var list = new List<ValueTuple<MemberSerializationInfo, byte[]>>();
	foreach (var member in Info.Members) {
		var binary = EmbedStringHelper.Utf8.GetBytes(member.StringKey);
		list.Add(new ValueTuple<MemberSerializationInfo, byte[]>(member, binary));
	}

	bool isFormatterResolverNecessary = GeneratorUtilities.ShouldUseFormatterResolver(Info.Members); 
 using (this.EmitNestingTypesAndNamespaces(this.Write)) { 
            this.Write("\tinternal sealed class ");
            this.Write(this.ToStringHelper.ToStringWithCulture(Info.Formatter.GetQualifiedName(Qualifiers.None)));
            this.Write(" : global::MessagePack.Formatters.IMessagePackFormatter<");
            this.Write(this.ToStringHelper.ToStringWithCulture(Info.DataType.GetQualifiedName()));
            this.Write(">\r\n");
 TransformUtilities.EmitTypeConstraints(Info.Formatter, this.Write); 
            this.Write("\t{\r\n");
 foreach (var item in Info.Members) { 
 if (item.CustomFormatter != null) { 
            this.Write("\t\tprivate readonly ");
            this.Write(this.ToStringHelper.ToStringWithCulture(item.CustomFormatter.Name.GetQualifiedName()));
            this.Write(" __");
            this.Write(this.ToStringHelper.ToStringWithCulture(item.Name));
            this.Write("CustomFormatter__ = ");
            this.Write(this.ToStringHelper.ToStringWithCulture(item.CustomFormatter.InstanceExpression));
            this.Write(";\r\n");
 } 
 } 
 for (var i = 0; i < list.Count; i++) {
		var member = list[i].Item1;
		var binary = list[i].Item2; 
            this.Write("\t\t// ");
            this.Write(this.ToStringHelper.ToStringWithCulture(member.StringKey));
            this.Write("\r\n\t\tprivate static global::System.ReadOnlySpan<byte> GetSpan_");
            this.Write(this.ToStringHelper.ToStringWithCulture(member.UniqueIdentifier));
            this.Write("() => ");
            this.Write(this.ToStringHelper.ToStringWithCulture(EmbedStringHelper.ToByteArrayString(binary)));
            this.Write(";\r\n");
 } 
 if (list.Count != 0) { 
            this.Write("\r\n");
 } 
            this.Write("\t\tpublic void Serialize(ref global::MessagePack.MessagePackWriter writer, ");
            this.Write(this.ToStringHelper.ToStringWithCulture(Info.DataType.GetQualifiedName()));
            this.Write(" value, global::MessagePack.MessagePackSerializerOptions options)\r\n\t\t{\r\n");
 if (Info.IsClass) { 
            this.Write("\t\t\tif (value is null)\r\n\t\t\t{\r\n\t\t\t\twriter.WriteNil();\r\n\t\t\t\treturn;\r\n\t\t\t}\r\n\r\n");
 }

	if (isFormatterResolverNecessary) { 
            this.Write("\t\t\tvar formatterResolver = options.Resolver;\r\n");
 }

	if (Info.HasIMessagePackSerializationCallbackReceiver) {
		if (Info.NeedsCastOnBefore) { 
            this.Write("\t\t\t((global::MessagePack.IMessagePackSerializationCallbackReceiver)value).OnBefor" +
                    "eSerialize();\r\n");
 } else { 
            this.Write("\t\t\tvalue.OnBeforeSerialize();\r\n");
 } 
 } 
            this.Write("\t\t\twriter.WriteMapHeader(");
            this.Write(this.ToStringHelper.ToStringWithCulture(list.Count));
            this.Write(");\r\n");
 foreach (var memberAndBinary in list) {
		var member = memberAndBinary.Item1; 
            this.Write("\t\t\twriter.WriteRaw(GetSpan_");
            this.Write(this.ToStringHelper.ToStringWithCulture(member.UniqueIdentifier));
            this.Write("());\r\n\t\t\t");
            this.Write(this.ToStringHelper.ToStringWithCulture(member.GetSerializeMethodString()));
            this.Write(";\r\n");
 } 
            this.Write("\t\t}\r\n\r\n\t\tpublic ");
            this.Write(this.ToStringHelper.ToStringWithCulture(Info.DataType.GetQualifiedName()));
            this.Write(" Deserialize(ref global::MessagePack.MessagePackReader reader, global::MessagePac" +
                    "k.MessagePackSerializerOptions options)\r\n\t\t{\r\n\t\t\tif (reader.TryReadNil())\r\n\t\t\t{\r" +
                    "\n");
 if (Info.IsClass) { 
            this.Write("\t\t\t\treturn null;\r\n");
 } else { 
            this.Write("\t\t\t\tthrow new global::System.InvalidOperationException(\"typecode is null, struct " +
                    "not supported\");\r\n");
 } 
            this.Write("\t\t\t}\r\n\r\n");
 if (Info.Members.Length == 0) { 
            this.Write("\t\t\treader.Skip();\r\n\t\t\tvar ____result = new ");
            this.Write(this.ToStringHelper.ToStringWithCulture(Info.GetConstructorString()));
            this.Write(";\r\n");
 } else { 
            this.Write("\t\t\toptions.Security.DepthStep(ref reader);\r\n");
 if (isFormatterResolverNecessary) { 
            this.Write("\t\t\tvar formatterResolver = options.Resolver;\r\n");
 } 
            this.Write("\t\t\tvar length = reader.ReadMapHeader();\r\n");
 if (Info.MustDeserializeFieldsFirst) {
	foreach (var member in Info.Members.Where(x => x.IsWritable || Info.ConstructorParameters.Any(p => p.Equals(x)))) {
		// Until C# allows for optionally setting init-only properties (https://github.com/dotnet/csharplang/issues/6117)
		// we will unconditionally set them, and thus have no reason to track whether the local variable has been initialized.
		if (!member.IsInitOnly && !member.IsRequired && !Info.ConstructorParameters.Any(p => p.Equals(member))) { 
            this.Write("\t\t\tvar ");
            this.Write(this.ToStringHelper.ToStringWithCulture(member.LocalVariableName));
            this.Write("IsInitialized = false;\r\n");
		} 
            this.Write("\t\t\tvar ");
            this.Write(this.ToStringHelper.ToStringWithCulture(member.LocalVariableName));
            this.Write(" = default(");
            this.Write(this.ToStringHelper.ToStringWithCulture(member.Type));
            this.Write(");\r\n");
	} 
 } else { 
            this.Write("\t\t\tvar ____result = new ");
            this.Write(this.ToStringHelper.ToStringWithCulture(Info.GetConstructorString()));
            this.Write(";\r\n");
 } 
            this.Write("\r\n\t\t\tfor (int i = 0; i < length; i++)\r\n\t\t\t{\r\n\t\t\t\tvar stringKey = global::MessageP" +
                    "ack.Internal.CodeGenHelpers.ReadStringSpan(ref reader);\r\n\t\t\t\tswitch (stringKey.L" +
                    "ength)\r\n\t\t\t\t{\r\n\t\t\t\t\tdefault:\r\n\t\t\t\t\tFAIL:\r\n\t\t\t\t\t  reader.Skip();\r\n\t\t\t\t\t  continue" +
                    ";\r\n");
            this.Write(this.ToStringHelper.ToStringWithCulture(StringKeyFormatterDeserializeHelper.Classify(Info, "					", !Info.MustDeserializeFieldsFirst)));
            this.Write("\r\n\t\t\t\t}\r\n\t\t\t}\r\n\r\n");
 if (Info.MustDeserializeFieldsFirst) { 
            this.Write("\t\t\tvar ____result = new ");
            this.Write(this.ToStringHelper.ToStringWithCulture(Info.GetConstructorString()));
            this.Write(";\r\n");
 foreach (var member in Info.Members.Where(x => x.IsWritable && !x.IsInitOnly && !x.IsRequired && !Info.ConstructorParameters.Any(p => p.Equals(x)))) { 
            this.Write("\t\t\tif (");
            this.Write(this.ToStringHelper.ToStringWithCulture(member.LocalVariableName));
            this.Write("IsInitialized)\r\n\t\t\t{\r\n\t\t\t\t");
            this.Write(this.ToStringHelper.ToStringWithCulture(member.GetMemberAccess("____result")));
            this.Write(" = ");
            this.Write(this.ToStringHelper.ToStringWithCulture(member.LocalVariableName));
            this.Write(";\r\n\t\t\t}\r\n\r\n");
 } 
 } 
 } 
 if (Info.HasIMessagePackSerializationCallbackReceiver) {
		if (Info.NeedsCastOnAfter) { 
            this.Write("\t\t\t((global::MessagePack.IMessagePackSerializationCallbackReceiver)____result).On" +
                    "AfterDeserialize();\r\n");
 } else { 
            this.Write("\t\t\t____result.OnAfterDeserialize();\r\n");
 } 
 } 
 if (Info.Members.Length != 0) { 
            this.Write("\t\t\treader.Depth--;\r\n");
 } 
            this.Write("\t\t\treturn ____result;\r\n\t\t}\r\n\t}\r\n\r\n");
 } 
            return this.GenerationEnvironment.ToString();
        }
    }
    #region Base class
    /// <summary>
    /// Base class for this transformation
    /// </summary>
    [global::System.CodeDom.Compiler.GeneratedCodeAttribute("Microsoft.VisualStudio.TextTemplating", "17.0.0.0")]
    public class StringKeyFormatterTemplateBase
    {
        #region Fields
        private global::System.Text.StringBuilder generationEnvironmentField;
        private global::System.CodeDom.Compiler.CompilerErrorCollection errorsField;
        private global::System.Collections.Generic.List<int> indentLengthsField;
        private string currentIndentField = "";
        private bool endsWithNewline;
        private global::System.Collections.Generic.IDictionary<string, object> sessionField;
        #endregion
        #region Properties
        /// <summary>
        /// The string builder that generation-time code is using to assemble generated output
        /// </summary>
        public System.Text.StringBuilder GenerationEnvironment
        {
            get
            {
                if ((this.generationEnvironmentField == null))
                {
                    this.generationEnvironmentField = new global::System.Text.StringBuilder();
                }
                return this.generationEnvironmentField;
            }
            set
            {
                this.generationEnvironmentField = value;
            }
        }
        /// <summary>
        /// The error collection for the generation process
        /// </summary>
        public System.CodeDom.Compiler.CompilerErrorCollection Errors
        {
            get
            {
                if ((this.errorsField == null))
                {
                    this.errorsField = new global::System.CodeDom.Compiler.CompilerErrorCollection();
                }
                return this.errorsField;
            }
        }
        /// <summary>
        /// A list of the lengths of each indent that was added with PushIndent
        /// </summary>
        private System.Collections.Generic.List<int> indentLengths
        {
            get
            {
                if ((this.indentLengthsField == null))
                {
                    this.indentLengthsField = new global::System.Collections.Generic.List<int>();
                }
                return this.indentLengthsField;
            }
        }
        /// <summary>
        /// Gets the current indent we use when adding lines to the output
        /// </summary>
        public string CurrentIndent
        {
            get
            {
                return this.currentIndentField;
            }
        }
        /// <summary>
        /// Current transformation session
        /// </summary>
        public virtual global::System.Collections.Generic.IDictionary<string, object> Session
        {
            get
            {
                return this.sessionField;
            }
            set
            {
                this.sessionField = value;
            }
        }
        #endregion
        #region Transform-time helpers
        /// <summary>
        /// Write text directly into the generated output
        /// </summary>
        public void Write(string textToAppend)
        {
            if (string.IsNullOrEmpty(textToAppend))
            {
                return;
            }
            // If we're starting off, or if the previous text ended with a newline,
            // we have to append the current indent first.
            if (((this.GenerationEnvironment.Length == 0) 
                        || this.endsWithNewline))
            {
                this.GenerationEnvironment.Append(this.currentIndentField);
                this.endsWithNewline = false;
            }
            // Check if the current text ends with a newline
            if (textToAppend.EndsWith(global::System.Environment.NewLine, global::System.StringComparison.CurrentCulture))
            {
                this.endsWithNewline = true;
            }
            // This is an optimization. If the current indent is "", then we don't have to do any
            // of the more complex stuff further down.
            if ((this.currentIndentField.Length == 0))
            {
                this.GenerationEnvironment.Append(textToAppend);
                return;
            }
            // Everywhere there is a newline in the text, add an indent after it
            textToAppend = textToAppend.Replace(global::System.Environment.NewLine, (global::System.Environment.NewLine + this.currentIndentField));
            // If the text ends with a newline, then we should strip off the indent added at the very end
            // because the appropriate indent will be added when the next time Write() is called
            if (this.endsWithNewline)
            {
                this.GenerationEnvironment.Append(textToAppend, 0, (textToAppend.Length - this.currentIndentField.Length));
            }
            else
            {
                this.GenerationEnvironment.Append(textToAppend);
            }
        }
        /// <summary>
        /// Write text directly into the generated output
        /// </summary>
        public void WriteLine(string textToAppend)
        {
            this.Write(textToAppend);
            this.GenerationEnvironment.AppendLine();
            this.endsWithNewline = true;
        }
        /// <summary>
        /// Write formatted text directly into the generated output
        /// </summary>
        public void Write(string format, params object[] args)
        {
            this.Write(string.Format(global::System.Globalization.CultureInfo.CurrentCulture, format, args));
        }
        /// <summary>
        /// Write formatted text directly into the generated output
        /// </summary>
        public void WriteLine(string format, params object[] args)
        {
            this.WriteLine(string.Format(global::System.Globalization.CultureInfo.CurrentCulture, format, args));
        }
        /// <summary>
        /// Raise an error
        /// </summary>
        public void Error(string message)
        {
            System.CodeDom.Compiler.CompilerError error = new global::System.CodeDom.Compiler.CompilerError();
            error.ErrorText = message;
            this.Errors.Add(error);
        }
        /// <summary>
        /// Raise a warning
        /// </summary>
        public void Warning(string message)
        {
            System.CodeDom.Compiler.CompilerError error = new global::System.CodeDom.Compiler.CompilerError();
            error.ErrorText = message;
            error.IsWarning = true;
            this.Errors.Add(error);
        }
        /// <summary>
        /// Increase the indent
        /// </summary>
        public void PushIndent(string indent)
        {
            if ((indent == null))
            {
                throw new global::System.ArgumentNullException("indent");
            }
            this.currentIndentField = (this.currentIndentField + indent);
            this.indentLengths.Add(indent.Length);
        }
        /// <summary>
        /// Remove the last indent that was added with PushIndent
        /// </summary>
        public string PopIndent()
        {
            string returnValue = "";
            if ((this.indentLengths.Count > 0))
            {
                int indentLength = this.indentLengths[(this.indentLengths.Count - 1)];
                this.indentLengths.RemoveAt((this.indentLengths.Count - 1));
                if ((indentLength > 0))
                {
                    returnValue = this.currentIndentField.Substring((this.currentIndentField.Length - indentLength));
                    this.currentIndentField = this.currentIndentField.Remove((this.currentIndentField.Length - indentLength));
                }
            }
            return returnValue;
        }
        /// <summary>
        /// Remove any indentation
        /// </summary>
        public void ClearIndent()
        {
            this.indentLengths.Clear();
            this.currentIndentField = "";
        }
        #endregion
        #region ToString Helpers
        /// <summary>
        /// Utility class to produce culture-oriented representation of an object as a string.
        /// </summary>
        public class ToStringInstanceHelper
        {
            private System.IFormatProvider formatProviderField  = global::System.Globalization.CultureInfo.InvariantCulture;
            /// <summary>
            /// Gets or sets format provider to be used by ToStringWithCulture method.
            /// </summary>
            public System.IFormatProvider FormatProvider
            {
                get
                {
                    return this.formatProviderField ;
                }
                set
                {
                    if ((value != null))
                    {
                        this.formatProviderField  = value;
                    }
                }
            }
            /// <summary>
            /// This is called from the compile/run appdomain to convert objects within an expression block to a string
            /// </summary>
            public string ToStringWithCulture(object objectToConvert)
            {
                if ((objectToConvert == null))
                {
                    throw new global::System.ArgumentNullException("objectToConvert");
                }
                System.Type t = objectToConvert.GetType();
                System.Reflection.MethodInfo method = t.GetMethod("ToString", new System.Type[] {
                            typeof(System.IFormatProvider)});
                if ((method == null))
                {
                    return objectToConvert.ToString();
                }
                else
                {
                    return ((string)(method.Invoke(objectToConvert, new object[] {
                                this.formatProviderField })));
                }
            }
        }
        private ToStringInstanceHelper toStringHelperField = new ToStringInstanceHelper();
        /// <summary>
        /// Helper to produce culture-oriented representation of an object as a string
        /// </summary>
        public ToStringInstanceHelper ToStringHelper
        {
            get
            {
                return this.toStringHelperField;
            }
        }
        #endregion
    }
    #endregion
}
