#Requires -Version 7.0
param (
  [string]$inputJsonFile,
  [string]$outputJsonFile
)

. (Join-Path $PSScriptRoot ".." ".." "common" "scripts" "Helpers" PSModule-Helpers.ps1)
. (Join-Path $PSScriptRoot GenerateAndBuildLib.ps1)

$inputJson = Get-Content $inputJsonFile | Out-String | ConvertFrom-Json
$swaggerDir = $inputJson.specFolder
if($swaggerDir) {
  $swaggerDir = Resolve-Path $swaggerDir
}
$swaggerDir = $swaggerDir -replace "\\", "/"
$readmeFile = $inputJson.relatedReadmeMdFile
$readmeFile = $readmeFile -replace "\\", "/"
$commitid = $inputJson.headSha
$repoHttpsUrl = $inputJson.repoHttpsUrl
$downloadUrlPrefix = $inputJson.installInstructionInput.downloadUrlPrefix
$autorestConfig = $inputJson.autorestConfig

$autorestConfig = $inputJson.autorestConfig
$relatedTypeSpecProjectFolder = $inputJson.relatedTypeSpecProjectFolder

$autorestConfigYaml = ""
if ($autorestConfig) {
    $autorestConfig | Set-Content "config.md"
    $autorestConfigYaml = Get-Content -Path .\config.md
    $range = ($autorestConfigYaml | Select-String -Pattern '```').LineNumber
    if ( $range.count -gt 1) {
        $startNum = $range[0];
        $lines = $range[1] - $range[0] - 1
        $autorestConfigYaml = ($autorestConfigYaml | Select -Skip $startNum | Select -First $lines) |Out-String
    }
    Install-ModuleIfNotInstalled "powershell-yaml" "0.4.1" | Import-Module
    $yml = ConvertFrom-YAML $autorestConfigYaml
    $requires = $yml["require"]
    if ($requires.Count -gt 0) {
        $readmeFile = $requires[0]
    }
}

$generatedSDKPackages = New-Object 'Collections.Generic.List[System.Object]'

# $service, $serviceType = Get-ResourceProviderFromReadme $readmeFile
$sdkPath =  (Join-Path $PSScriptRoot .. .. ..)
$sdkPath = Resolve-Path $sdkPath
$sdkPath = $sdkPath -replace "\\", "/"

if ($readmeFile) {
  Write-Host "swaggerDir:$swaggerDir, readmeFile:$readmeFile"

  $readme = ""
  if ($commitid -ne "") {
    if ((-Not $readmeFile.Contains("specification")) -And $swaggerDir.Contains("specification"))
    {
      $readmeFile = "specification/$readmeFile"
    }
    if ($repoHttpsUrl -ne "") {
      $readme = "$repoHttpsUrl/blob/$commitid/$readmeFile"
    } else {
      $readme = "https://github.com/$org/azure-rest-api-specs/blob/$commitid/$readmeFile"
    }
  } else {
    $readme = (Join-Path $swaggerDir $readmeFile)
  }
  Invoke-GenerateAndBuildSDK -readmeAbsolutePath $readme -sdkRootPath $sdkPath -autorestConfigYaml "$autorestConfigYaml" -downloadUrlPrefix "$downloadUrlPrefix" -generatedSDKPackages $generatedSDKPackages
}

# generate sdk from typespec file
if ($relatedTypeSpecProjectFolder) {
  foreach ($typespecRelativeFolder in $relatedTypeSpecProjectFolder) {
      $typespecFolder = Resolve-Path (Join-Path $swaggerDir $typespecRelativeFolder)
      $processScript = Resolve-Path (Join-Path $sdkPath "eng/common/scripts" "TypeSpec-Project-Process.ps1")
      $sdkProjectFolders = Get-ChildItem -Path (Join-Path $sdkPath "sdk") -Depth 1 -Directory | Select-Object -ExpandProperty FullName

      # Invoke Process script. SkipSyncAndGenerate only when it's not a new SDK project
      $sdkProjectFolder = & $processScript $typespecFolder $commitid $repoHttpsUrl -SkipSyncAndGenerate
      if ($LASTEXITCODE) {
        # If Process script call fails, then return with failure to CI and don't need to call GeneratePackage
        $generatedSDKPackages.Add(@{
          result = "failed";
          path=@("");
        })
      } else {
          $relativeSdkPath = Resolve-Path $sdkProjectFolder -Relative
          $specRepoRoot = $swaggerDir -replace "/specification", ""
          if ($sdkProjectFolders -contains $sdkProjectFolder) {
            # Existed SDK project case, needs to generate code
            GeneratePackage `
            -projectFolder $sdkProjectFolder `
            -sdkRootPath $sdkPath `
            -path $relativeSdkPath `
            -downloadUrlPrefix $downloadUrlPrefix `
            -serviceType "data-plane" `
            -generatedSDKPackages $generatedSDKPackages `
            -specRepoRoot $specRepoRoot
          } else {
            # New SDK project case, code is already generated by emitter. So, skip code generation
            GeneratePackage `
            -projectFolder $sdkProjectFolder `
            -sdkRootPath $sdkPath `
            -path $relativeSdkPath `
            -downloadUrlPrefix $downloadUrlPrefix `
            -serviceType "data-plane" `
            -skipGenerate `
            -generatedSDKPackages $generatedSDKPackages `
            -specRepoRoot $specRepoRoot
          }
      }
  }
}
$outputJson = [PSCustomObject]@{
  packages = $generatedSDKPackages
}
$outputJson | ConvertTo-Json -depth 100 | Out-File $outputJsonFile