// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Maps.Rendering
{
    /// <summary> Client options for MapsRenderClient. </summary>
    public partial class MapsRenderingClientOptions : Azure.Core.ClientOptions
    {
        internal const ServiceVersion LatestVersion = ServiceVersion.V2022_08_01;

        /// <summary> The version of the service to use. </summary>
        public enum ServiceVersion
        {
            /// <summary> Service version "2022-08-01". </summary>
            V2022_08_01 = 1,
        }

        internal string Version { get; }

        internal Uri Endpoint { get; }

        /// <summary> Initializes new instance of MapsRenderClientOptions. </summary>
        /// <param name="version"> Azure Maps Render API version. </param>
        /// <param name="endpoint"> The endpoint for Azure Maps. </param>
        public MapsRenderingClientOptions(ServiceVersion version = LatestVersion, Uri endpoint = null)
        {
            Version = version switch
            {
                ServiceVersion.V2022_08_01 => "2022-08-01",
                _ => throw new NotSupportedException()
            };
            Endpoint = endpoint;
        }
    }
}
