namespace Org.BouncyCastle.Pqc.Crypto.Picnic
{
    internal class LowmcConstantsL1
        : LowmcConstants
    {
        public LowmcConstantsL1()
        {
            // Parameters for security level L1
            // Block/key size: 128
            // Rounds: 20
            _LMatrix = new KMatrices(20, 128, 4, s_linearMatrices);
            _KMatrix = new KMatrices(21, 128, 4, s_keyMatrices);
            RConstants = new KMatrices(0, 1, 4, s_roundConstants);

            // Parameters for security level L1, full s-box layer
            // Block/key size: 129
            // Rounds: 4
            // Note that each 129-bit row of the matrix is zero padded to 160 bits (the next multiple of 32)
            LMatrix_full = new KMatrices(4, 129, 5, s_linearMatrices_full);
            LMatrix_inv = new KMatrices(4, 129, 5, s_linearMatrices_inv);
            KMatrix_full = new KMatrices(5, 129, 5, s_keyMatrices_full);
            KMatrix_inv = new KMatrices(1, 129, 5, s_keyMatrices_inv);
            RConstants_full = new KMatrices(4, 1, 5, s_roundConstants_full);
        }

        /// <summary>Length: 10240</summary>
        private static readonly uint[] s_linearMatrices = new uint[]
        {
            0x2C801957, 0x3E05C3F5, 0x2FD32A78, 0x3CEF3ADD, 0x4FE336B0, 0x2EC41D9F, 0x223E7C67, 0xE7961DB9,
            0x3E0BAADB, 0xD0C3497B, 0x233C08C8, 0x9FB1C3F4, 0x06DE88D9, 0x1593C8B2, 0xD8272287, 0x0B528475,
            0xA651E7C9, 0x87F326CA, 0x42A02465, 0xDB0FE03D, 0x4CA0EFC3, 0x40D17DBA, 0xFBFAE7C1, 0x8E8B1EDC,
            0x31C39B36, 0xCCA5BDCE, 0x6858A416, 0x13E17D49, 0x08A42D27, 0x4A956FDB, 0x5EDE4AF9, 0xE99317E4,
            0xA6E109E4, 0xEF9235F8, 0xBDE9A0E0, 0xA424A4E7, 0x1BFE02AF, 0x175ED6BF, 0xF1AE9584, 0xAB2CDFAC,
            0x55535212, 0x4B044552, 0x6B3338DA, 0x35218B47, 0x5B1807A0, 0xA2CC52C4, 0x15B2DB27, 0xBA22BCF4,
            0x3B5A5E97, 0xB6E84A18, 0x5FDF43C2, 0xC5093287, 0x1B0C0640, 0x4113984A, 0x17DD43D7, 0x99078469,
            0x5F053BD4, 0x22EB2B15, 0xCA1BEA80, 0x8F269015, 0x48E91150, 0x3759B950, 0xE713B7AD, 0xB04E484E,
            0x822F2B84, 0xAEFABFE9, 0xFEF1A519, 0x174FB050, 0xEF017984, 0xE64D051B, 0x6AED3E55, 0x694F797C,
            0x3C94A15C, 0x17A887D2, 0xFCAC384D, 0x16C3E84B, 0xDD29295D, 0x48CFEEDE, 0xAA0613E8, 0x525DC6DE,
            0x72DBADCB, 0x6634C9AB, 0xF85D19E8, 0x465DBEE2, 0x58EF0215, 0x3F1DA210, 0xB10CF529, 0x6513879A,
            0x9A83D0C3, 0xA0EB3B42, 0x24AE68C8, 0x6400A045, 0xF2686FE5, 0x773D4B2B, 0x3C2F0755, 0x41E83476,
            0x4F3E27EF, 0xF1CCAFF9, 0xC7335D3C, 0xC1E770B8, 0xC07856C5, 0xD7190477, 0xB44D5A08, 0x82822E7C,
            0x99017083, 0x261DA847, 0xD8DCF87C, 0x9804E4DB, 0x18BCCC28, 0xD6FC0218, 0x0BEE4BA0, 0x92101DF1,
            0x5780DB34, 0x2BF89CAB, 0x4D1F20D4, 0x88C7DF77, 0xA5DF3719, 0x40994C4E, 0x543C1F92, 0x92667921,
            0x4EBC2477, 0xE5D789A7, 0x87F8BAE5, 0x6BA83A2B, 0xC492802E, 0x84B265FE, 0x14B5B36F, 0x8C62D6C6,
            0x1C4DFD1B, 0x9CFC48D1, 0x14154B99, 0x5844F9B7, 0x0C367CB4, 0xD4358FF7, 0xE0775161, 0xD5AEBC75,
            0xCAFE9AE8, 0x4E4DB3BB, 0x2DE37B57, 0x2CCD10BB, 0x14AC4E47, 0xBA40B6C6, 0xE027035F, 0xE1214F3B,
            0xEE692572, 0x875C1881, 0xD0ACF6BA, 0xEBAB7C72, 0x2449D1D7, 0xB55D87C8, 0x81056648, 0xF14D5932,
            0xB763B2BA, 0xC66D5FB8, 0x42E4D211, 0xD9B0BB60, 0xB2D80FB7, 0x96279DEF, 0x9BD0A102, 0x034AABC2,
            0xDC5895B3, 0x4BB21487, 0x6E797BA0, 0x7CF7858C, 0x7988BCD7, 0x50742F85, 0x29A48428, 0xA0FEBC94,
            0x24C98CE5, 0x7FD0E894, 0x50AFC722, 0x6DAA547B, 0x10CC243F, 0x45AE5DAE, 0xA5A9AF45, 0xEFD88880,
            0xE5029E22, 0x8FEF7C4F, 0x5ACA9321, 0xA8DC3F6C, 0x1573A550, 0xAE76BF3E, 0xE6156F57, 0xFA0E5148,
            0x2F5FA9EF, 0xFEB45BDD, 0xAEBF0CF0, 0xD7005997, 0xEC4ADE38, 0x09A5192A, 0xD2B9BC12, 0xE80FE4A2,
            0x8603E18F, 0x83510598, 0x4399990F, 0x86F2C344, 0x22CFD632, 0x53CCA172, 0xAAB507AA, 0x631AE7D4,
            0x8A4A7175, 0x16EF14FE, 0xDBE11766, 0x65742CFB, 0x9616499A, 0x4BF9FB75, 0xE0692FBC, 0x9716783B,
            0xE2A0631B, 0xC825A93A, 0xCED028EE, 0xD1CE07DE, 0x0AF2C5FF, 0x97FF4438, 0xDB3AFBCB, 0x94B45B93,
            0xEEB48395, 0x80488DAD, 0x41D784D8, 0x5A6E3A09, 0x53EE4E74, 0x78C0161A, 0x6AFF82DB, 0xCC93EAAA,
            0xB9B2D899, 0x1847FC82, 0x93E52FDB, 0x7491BC4F, 0x98CD93B1, 0x38E4167A, 0x5E962A5E, 0xED91458C,
            0x76733B05, 0x5077B12E, 0x3A45D1FB, 0xC7571613, 0xDADC35AB, 0x3767DAF2, 0x00E84224, 0xAA5E3FFB,
            0x645962E2, 0xB7CB6EF1, 0xB016B9D0, 0x0BD4A150, 0x86B95A3B, 0xD520BE96, 0xF3F7B509, 0x59CA379F,
            0xD9CC8599, 0x66B130AF, 0x85D4CAFB, 0x3219C497, 0x5DE4535F, 0x75864331, 0x6A73CFEE, 0x494EC8FF,
            0xDFE4A7B3, 0xB69A23E2, 0xB4C06B92, 0x5FA47414, 0xDF95EBE6, 0x2D6D3350, 0x7911B9D7, 0x9544C0E8,
            0x397B35FA, 0xB1D4B7BB, 0x8D2499ED, 0x4E1AEFBF, 0xA41C38E4, 0x6F29BD2F, 0xE6F8863A, 0x7DCE76CF,
            0xE98A880A, 0xAAE25554, 0x5FB9AAD5, 0xD90DEEA2, 0x28512CCA, 0xD5FD3437, 0x866C6301, 0x8D104F31,
            0x491FF14B, 0x5DA5636D, 0x6412336B, 0x25F57654, 0x13D46F31, 0xE5C7E710, 0x69DE9AC0, 0xFE2EDCD7,
            0xA67E8F04, 0xAE0A2AFE, 0x04DA36F1, 0x82E25471, 0xD832A04A, 0xCE495D00, 0x732C8998, 0x981BD2D9,
            0xED44A7E1, 0x7E2AF1DF, 0x227580C3, 0x4F614238, 0xCB58E5E1, 0x02CF746D, 0x788A6736, 0x43F912A2,
            0xB5D7A28A, 0xB4B0B276, 0xFB6AB9E0, 0x36E944A3, 0xA0284672, 0x9B0F9223, 0xD9DDA2FA, 0x57A52FED,
            0xC46C87FB, 0x2A75E425, 0x65B19066, 0x7620EFBF, 0x4980CE6C, 0x5F060251, 0xC13785F3, 0xFBC2AA0B,
            0x00B9A974, 0x67010AD2, 0xC22EAE51, 0xB05E9966, 0xC22E9DDE, 0x82FA2CBC, 0x47604521, 0x514362B8,
            0x187C8C70, 0x4D99175A, 0xBB77083F, 0xB6429B41, 0x2C782826, 0x863DA98A, 0x53C3E7D0, 0xAC0AEE42,
            0xFC062833, 0x94F077B5, 0xCEDE172B, 0xDC15AE1C, 0x5FD1441B, 0xAC18DC0C, 0x0989E841, 0x976B9434,
            0x05EF83E9, 0x684F5AC5, 0xD0BAB870, 0xA920ACE3, 0x977A534D, 0x5115AAF4, 0x71D9675E, 0xDB7F2F1F,
            0x83CB8869, 0xEC7387CC, 0xB630AC2B, 0xDF8A46F1, 0xAE5C84E5, 0x20EB8B9B, 0x9CDD562A, 0xAD3C7AF8,
            0xFD45C548, 0x02A607D9, 0xC7B99BA9, 0xF065127B, 0x77C008C2, 0xAE3ED276, 0x616D7608, 0xCB3741A8,
            0x53357568, 0x2BB77B0A, 0xA4D0165B, 0x1C46FC18, 0x0FB7062E, 0xC6A9191E, 0x6505ABEC, 0x725C5570,
            0x2F1F1CAD, 0x3FC47630, 0xFD38BCD4, 0x1384FD22, 0x45AB1CFB, 0xDEA86FB9, 0xBE246E96, 0xDF33E7C4,
            0x6724B5FC, 0xA21B4A1F, 0x06463D31, 0x36966C5D, 0x6C2F3EB7, 0xBA2E659A, 0xDB17030F, 0xE3915885,
            0x77FB4E93, 0x11C366D6, 0xA93EBA2E, 0xFCF117AA, 0x39AE51CD, 0x073F835E, 0xBC34F940, 0xA74206D1,
            0xCE531868, 0x79A8C204, 0x83032DF0, 0x3743C6AF, 0x0AD44F2A, 0x39DB60CE, 0xE557FC0F, 0xAD443498,
            0x9EEF8FDD, 0xE169B219, 0x100E8DA2, 0x9013CE13, 0x3CA3FAD9, 0x836C335C, 0xB26544CA, 0xE54E5144,
            0x24ABB8DD, 0xD671447F, 0xE3D4E19A, 0x94DB8C46, 0x49CFDFCD, 0xAC5790E2, 0x263D2A2D, 0x43471A38,
            0x41F39135, 0x5B4A9456, 0x08670ED1, 0x1717FD1C, 0x19ECEE57, 0x6E40F172, 0x844613E6, 0xA7D9D053,
            0xE3DB617A, 0xDD880DCD, 0x08C34D66, 0x1CDC7801, 0x5F0DB31B, 0xF4E95866, 0xE260D621, 0x31CFA952,
            0x549880A7, 0x280F64D1, 0x27A1BD59, 0x13E45015, 0xC962A596, 0x30A8C2CD, 0x5CD5DE4B, 0xC303DABA,
            0xEA6B31E8, 0x444AB3EC, 0x71BE0BBE, 0xCC8338D9, 0xC065C49C, 0x88841946, 0x3FFE8284, 0xD9AE450C,
            0xCEA3A0C5, 0xC1E9FCB5, 0x4AA6CE65, 0x2FF6253E, 0xF75C1AC7, 0x8C254306, 0x72722DB1, 0x1092C21D,
            0x27C4FE81, 0x8383F238, 0xDC0AC540, 0x027F8ABF, 0x67D7EDFB, 0xDFDB2136, 0x3774E035, 0x2E977B43,
            0x1450304C, 0xDDE9AE59, 0x14D5584F, 0x131A44F8, 0xBC6A62F7, 0x37A11FBC, 0x0DC2F44C, 0x9F8B6588,
            0xEBABA961, 0x981C6B8F, 0x17D9958F, 0x8CC267CB, 0xFAA449CD, 0x3923A4B4, 0xA6D851F4, 0xB563E5F6,
            0x33994854, 0xBCDEEACC, 0x9AD3905C, 0xE33A4C75, 0x7D7437A9, 0x3ED64017, 0x0647CD21, 0xA3135596,
            0x989B2FE5, 0x7299A0E0, 0x22849C5D, 0xC86D5BA0, 0x4995DD08, 0x55997F1A, 0x543792B7, 0x12B3A340,
            0xD4B22E51, 0x50D84D94, 0x1A7C81AC, 0xCB39DCF5, 0xA35140A3, 0x368B06A9, 0xE0353A4E, 0x417830DD,
            0x6A7AD452, 0x5C91CDDB, 0x09EF8CB1, 0x72B3FACD, 0x09AF7A38, 0x8BFB3FD6, 0x9EF12780, 0xCCA3155F,
            0x6519622D, 0x55FBB2CD, 0x87E61704, 0xE80CA65D, 0xFC835FEA, 0x96D2B72E, 0xD2C2CC9C, 0x4AFFA000,
            0xB908A10A, 0xA3EA81E9, 0x418817C2, 0x76FC5FB6, 0x1F38C546, 0x67895B44, 0xAAABC13C, 0x9884F74D,
            0x6699A235, 0xF65DBF93, 0x780DD0BB, 0xEE56DC9B, 0xFD40C8CC, 0x71D707D0, 0x33C71EB6, 0x7D810C93,
            0xCD48B390, 0x13EE94D1, 0x1388A608, 0xD3EA58AF, 0x1C1A9687, 0xC51F0050, 0x2EAE1907, 0x4D1B1961,
            0x02F53221, 0x7EC1B05F, 0xB6F6FD5F, 0x0AC4B518, 0x969FC253, 0x13D11D98, 0xCB99FCB1, 0x98E379C7,
            0x4AFE094A, 0x26A2B4FC, 0x2AAD0A6C, 0x5E2CDFCF, 0xFEA1543B, 0x690E0E2A, 0x7A1B511F, 0xECA0E3CA,
            0x07B3F912, 0xF3427B21, 0x0F22E2CB, 0x9D22D3D2, 0xDA24E2AC, 0xB4CD58FE, 0x24CF15FA, 0x6FBFF78D,
            0x0F5D03F4, 0x5BBE658F, 0x7A0C42A7, 0xC6D9EF07, 0x9EFF2775, 0xD140BA15, 0xC898DDBB, 0x0235B18F,
            0xE9B47C19, 0x2F2DFAE6, 0x1D10EF47, 0x6A7D088A, 0x9A9E8D38, 0x241E7366, 0xEAB2AFCE, 0xD3D9386D,
            0xFC74F8E2, 0x4391620B, 0x0620356E, 0x0E9F3EC3, 0x81DD1293, 0x50C864CB, 0xDE43FAAA, 0x5DECA169,
            0x88AD1DA2, 0x441BD5AE, 0xD67F24A2, 0x0701D64E, 0x58AD4CA2, 0x37FBE552, 0x6FD65AAE, 0x8A8F0190,
            0x75BE9DC8, 0xB3D298C6, 0xE373AAE8, 0x64320B83, 0xCFB0DC84, 0x48912B98, 0xFF732D81, 0x15713743,
            0x95015084, 0x8F21B7F5, 0x7A673A4D, 0xF12EAE3B, 0xC80C26C9, 0x73641948, 0x066D7F79, 0x4B2E4C28,
            0xDE993DA6, 0xAA40A5DA, 0x872B4CBC, 0xB1FEDF43, 0x6D8661F1, 0x432352C5, 0xA6DED11F, 0x24DBD6F8,
            0x7DA0901B, 0x3518AD68, 0x38E52A4D, 0xBE916F99, 0x2674DF23, 0x4A761407, 0xBB7C8BC2, 0x13870EAA,
            0x2C3CF647, 0xAAFB2CA1, 0x0ABFFFC9, 0x52F5265E, 0xA7586E13, 0xABDBB64A, 0xD2DEC045, 0xFCB9A153,
            0x88391B76, 0x17AD0AF7, 0xF445935D, 0x9FACE3C6, 0xC3E8D219, 0x016DD7A2, 0xF4724E61, 0x7BC94FBA,
            0x5DF0AF3C, 0x9B999E8E, 0x7FC4065E, 0x33BD1D2D, 0xB24F35AE, 0x4EFB0E1F, 0x7463A3D6, 0xE436C8C2,
            0xA2B3637A, 0x30A0271D, 0xBDA5530A, 0x4FC9527C, 0x3DF4DCE1, 0xE9203E30, 0xAA364173, 0x377895A5,
            0x65A34AB2, 0xB0EEC0C6, 0xC4A6DF67, 0x5E06ED2D, 0xB01487D6, 0x63587AB4, 0x0DDAD761, 0x8ACAA212,
            0x945C3B1A, 0x59D62B3A, 0x2AB5105B, 0x251CBA24, 0xEED31A03, 0x10FAD419, 0x9AEF527B, 0xACB1F621,
            0x9FF56044, 0x7ECBC07C, 0xC2C45364, 0xCBD000D2, 0x56D052A5, 0x19198A36, 0x6C197F92, 0xCE2B323E,
            0x5CF06A3B, 0xA03C67E1, 0xE314CAF6, 0x0B7C1AC4, 0xEEFA00B5, 0xA1FB2978, 0xD580AC47, 0x937C5980,
            0xFD0F314C, 0x05E836E8, 0x37B992B0, 0x00AB6F29, 0xA3E5EA87, 0x32491DBA, 0x77642F6C, 0x29E54E79,
            0x09C9869F, 0x5AF30F4F, 0xDB6DF160, 0x6914944D, 0x1BC11435, 0xE6C9BCC6, 0x80DD4C13, 0x1F84BD1B,
            0x153B86B5, 0x85F9F8AC, 0xC3C42667, 0x95FB3F15, 0x369C8768, 0x856B79DB, 0xD4D859E1, 0x292B7620,
            0x7FA58D1A, 0xCAF5A727, 0xA8943382, 0x90F13B5A, 0xA8F46958, 0x80DFA947, 0x3DE78382, 0xB5C6F03A,
            0x0BA1993B, 0xC43AC5D8, 0x2CF337D2, 0x4C782FFB, 0x8CA4D7E2, 0x6174675B, 0x09109115, 0xCB06F7AF,
            0xDB43D6C7, 0xB3F1DD04, 0xF08B612D, 0x69216CAB, 0x970B85D6, 0x92D40E9B, 0x89673537, 0x001CED21,
            0xE19AF89A, 0x45AF95AD, 0x8482CB0A, 0xB6E53D95, 0xFD9EF5AA, 0x29FDBA51, 0x55FD04E0, 0x03D02990,
            0xE740EFD6, 0xF21EF955, 0x1056C307, 0xCDC01B7B, 0x9906F740, 0x3F45A683, 0x175E0E62, 0xA32E6A21,
            0xF1F76F63, 0xC2C94BDD, 0x845E0C62, 0x9010570A, 0x604E4693, 0x6C2C0A1F, 0x66247D3D, 0x66986423,
            0x74A8385B, 0xE2500DA9, 0x0A8606DC, 0x6B0F8398, 0xC668CF05, 0x4651D2D6, 0xEAD0E52A, 0x4E5E5888,
            0xAF592EDF, 0xDAB1A92C, 0x167501B8, 0x065E0A3C, 0xB9667388, 0x916FE1AB, 0x770ABC28, 0xE8404177,
            0xD04CB56E, 0x9C2E8BFE, 0x21BD9BEE, 0xE2CC49BF, 0x3963E1E4, 0x64747408, 0x0F12A6B8, 0x0D3A7908,
            0xB761618A, 0xC1326C5C, 0x33078917, 0xF197403C, 0x9D04F913, 0x75EEA521, 0xFF31CF3A, 0x8862B81D,
            0x3E862E25, 0x5D19F3CD, 0x4A6D4315, 0x538357FD, 0x7AB4BBB7, 0x6DF6038D, 0x59F84289, 0xAB964C55,
            0x808DF246, 0xDEFB282B, 0x72B99C6C, 0x3A35B2E5, 0x9653C6E8, 0x0ED68E73, 0xFEC82BCA, 0xCC79E8D8,
            0x634F7633, 0xC807FCE7, 0x8EB61B7B, 0x3FB6211F, 0x565544BE, 0x21DA1678, 0x1D9C73B8, 0x33F02F1C,
            0x66E6AAC8, 0xF1F832C9, 0xC4D0312E, 0x7DE888B0, 0x1CDE3E69, 0xB5567710, 0x2F20C0FE, 0x52C0253A,
            0xF982E3EE, 0x7B8D24BD, 0x0A8BDCAD, 0x3B8ED335, 0xEA6EA158, 0x7593AB0E, 0xEBB5DAC1, 0xECC66D82,
            0xC513E352, 0xA9330D24, 0x5025985A, 0xACD7675F, 0x2DDBBCD4, 0xEEE7E9D9, 0xD2859808, 0xE0045151,
            0x5673B6D4, 0xAA68E268, 0xEEDE31A1, 0x34B45857, 0x27372C15, 0xB488D728, 0x0F6D0D40, 0x0FABB8C1,
            0x9DF43DD8, 0xFC375306, 0x2AFD4F14, 0x57C1A991, 0x7A801304, 0x6265982E, 0xCF60321C, 0x3D201C53,
            0x65F4D5E3, 0x919722CE, 0x2D1D6F10, 0xEA06DB45, 0x93772333, 0x7DA08CE3, 0x164E7486, 0x1EF9E678,
            0x187E7AB2, 0xDD0AE6B8, 0x2A3AEF0C, 0xA0979928, 0x1114B00F, 0xCFE316A3, 0xADCF9206, 0xF119E4E6,
            0x09942C36, 0x8A4EC937, 0xC1099D15, 0x2C82D08D, 0xFD768B7A, 0xDE50C44D, 0x3198B254, 0x2699324D,
            0xAEC921DE, 0x717B9C66, 0x45A2C867, 0x0C969D2B, 0xAD270C5E, 0x7864C81B, 0xB7531866, 0x6937FA63,
            0x1709CA8C, 0xD14B927C, 0x714B6B00, 0x61C0E442, 0x08A8AD18, 0x920EB529, 0x9FF2C3BA, 0xB4E38FBF,
            0x00CBCD43, 0x931EB9E0, 0x2E211061, 0xB7E4AFEE, 0xA6AB9C23, 0x5393024C, 0x23716C59, 0xE51A0F13,
            0xDF0D0E15, 0x5F4BA7EC, 0x7C309D97, 0xE7213556, 0xBCD442AF, 0x57537171, 0x52B49469, 0x3A61EBF3,
            0x00CFF711, 0x16E6E085, 0x8D1D0BD5, 0x9A13A170, 0x8891FCF6, 0x578889F0, 0x03DB4F56, 0x39D5E6D3,
            0x2B88EEC9, 0xCC09BF04, 0xD9E139E0, 0xF0F2EC7D, 0x2479735C, 0xDDF12644, 0xAD597C6E, 0x9646F7C5,
            0x97DE9626, 0x2309A6D9, 0x27A8E61F, 0x69C42F27, 0x1D4A784A, 0x0CA30B40, 0xA183DF3A, 0x78BDA9BD,
            0x77E2B522, 0x2712C12A, 0x80FDE13D, 0x845209B3, 0xB9B2D54C, 0xA453C005, 0x4F4DADB2, 0x12915C94,
            0x161A7A83, 0x8BB56DB1, 0x56138541, 0x2BF9567E, 0xE4AAE868, 0x88ABD1E0, 0x5C6B25E4, 0x7E0119A0,
            0x16722546, 0x41E2CD33, 0x454FF39F, 0xFFA3B845, 0x14077987, 0x2C47CC35, 0x05755366, 0x92BF6B25,
            0xCD6C3480, 0x44F5E89C, 0xCC28A965, 0xBAFE00C8, 0x8EA0C5F5, 0xCCE39071, 0xF0F8423C, 0x7EF39A83,
            0x23C246C4, 0x18971B75, 0x66789704, 0xD5B2FDCC, 0xE991EF9A, 0x1836BCD0, 0x6D2E60A2, 0x2387DD14,
            0x3162E44B, 0xF95D0EA8, 0x1BFECD42, 0x88943AC3, 0x5B0FF83C, 0xDB69E8DD, 0x10951F68, 0xACE88F31,
            0x5909EFE1, 0x17A14FFE, 0x7370F7E5, 0x010B568D, 0xC8289992, 0x66D15DBF, 0x0E0ED962, 0x6628B2C9,
            0x31B49ABD, 0xC4020A28, 0xAB15EAEB, 0x01D835F3, 0xA9F2258D, 0x92F18580, 0x9E0910A4, 0xF846126F,
            0x0EF53400, 0xF23278F8, 0xF1FCC65C, 0xA0AEF0DF, 0x6BB2AFCF, 0xE0D189A7, 0xBD1C3682, 0xDA52084D,
            0x51369A8F, 0x9BDC1972, 0x53274539, 0xC53F3F97, 0x87B95519, 0x844C2585, 0xE89C5B35, 0x93F0C417,
            0xD2CA2CE5, 0x6E3C6214, 0x782C682D, 0x40CDF1F2, 0x6A48FDB6, 0xD1881AC7, 0xC9B762DA, 0x4DB2DEAC,
            0x8619730D, 0x6A66257B, 0xB69315F4, 0x99B69F81, 0x129AA6E3, 0x6D61F8D3, 0xF3665111, 0x97A038A0,
            0x02C754DB, 0x2C6169C4, 0x9E01EDE5, 0xF6020F78, 0x7B18C511, 0x9BFAD2B9, 0xB10E9E80, 0x27B00BD9,
            0x66E759CD, 0x898D4848, 0xA2D80175, 0xF255DD81, 0x55909B65, 0xBE27FBE6, 0x5B991AA4, 0xC46457A7,
            0x961A6475, 0x8F6D62D0, 0x8C920DE3, 0x0DB0C29A, 0x2D082CEE, 0x78B91EC9, 0x73825E16, 0x40538E7C,
            0xF62D5101, 0x1847D5EC, 0x8CB3A821, 0xB7418928, 0x92AE690F, 0xF00299B8, 0x2D2AE2DE, 0xE1DEEBD5,
            0xE0C5E034, 0x6C2FB576, 0xDE155A26, 0x21D6A32F, 0x20CE9EB1, 0xA6107249, 0xB6C2A466, 0x1B03F7EE,
            0xE7B05E30, 0x1E2561AA, 0x0CA0A463, 0x5D9FAE93, 0x7F6AE16A, 0xB6581C51, 0x68F84FCB, 0x74C5E43A,
            0x012D5CCC, 0xF690CAA8, 0x290FEA99, 0xC6096756, 0x042D569B, 0xE33F2CE7, 0xC5728E23, 0x9610583D,
            0x4CCC78D1, 0x490F96BE, 0x2F79C31E, 0x3993AB42, 0xD842EF59, 0x24DE78F9, 0xDA0838DC, 0x7BC0EFCB,
            0x351420DC, 0xBCF6382C, 0x6127E696, 0x30C05954, 0x62CE5AB8, 0x6B6CA8D0, 0x936BB78E, 0x1E31945C,
            0xEE696B29, 0x4A1776E8, 0x1C43413E, 0x301F790E, 0xFB5E26D9, 0x1C260C41, 0x1999365A, 0x97916568,
            0x897E835E, 0xD6CCE0D3, 0xEECB48FE, 0xCAD513A8, 0xF7A62071, 0x8299E20D, 0x73BC023B, 0x08861F65,
            0x7A328D1E, 0x78545573, 0x2E8E7465, 0xB0C5F3EF, 0xF5D4134A, 0x9AB8DA30, 0xE3F3EC80, 0x1663B7D5,
            0x658D55B5, 0x9AD8D810, 0x4BC9AA8B, 0x19092C61, 0x6FDE8203, 0x08B0BF07, 0xA4E2E022, 0xD1E96D7C,
            0x3A5E450C, 0xCC9F44E4, 0xB5E890AF, 0x485278AF, 0x966A7613, 0xBFE91FB0, 0x8124298B, 0x2DD1AB53,
            0xB399FCF3, 0x2C30699C, 0xF9C28839, 0x9E92AD64, 0x108F8FE9, 0x672CB283, 0x62C64371, 0x4973A463,
            0xD279F4DC, 0xC836F8A4, 0x9C75F019, 0x81EDE233, 0xAD36A304, 0x8FB9A9D1, 0xFB182DDF, 0xEFBB07EA,
            0x72371E59, 0x4E723EC4, 0x2BD7B942, 0xC705FAA4, 0x79C9937D, 0x867E21D3, 0x09CD7D8E, 0x7DA35169,
            0x216FDB66, 0x5DE50942, 0xF566E846, 0xD3A45D77, 0x5036515D, 0x29B78B40, 0xBC233D47, 0x1B875616,
            0xB49FBBA1, 0x616E2424, 0x713C9C0E, 0x99736B14, 0x3AB40C76, 0xEE474673, 0xC740F552, 0x765E7170,
            0x60796E07, 0xAFA4D433, 0x2A8C2462, 0xC33CA3AA, 0x468BCBDB, 0x78ACB4C9, 0xF303D9E1, 0xE6556696,
            0x258F6DEB, 0x73CDE690, 0x4417D59D, 0xDD580D36, 0x9B7E2141, 0xDFA60524, 0x84EAB1D4, 0xDB1D0711,
            0x6F3B0765, 0x0A2E87F7, 0xD74A6FEB, 0x41C55CCA, 0xD29CBE3B, 0xA818B99A, 0xF854E773, 0x36813B48,
            0x2F5C2DD0, 0xA5003CAA, 0xD8B7D8F6, 0x00BFDD47, 0x66A0CDCF, 0x516C6355, 0x73641350, 0xE8A8E672,
            0x93FF6F7F, 0x255EB543, 0xC2CDF93B, 0xE40CEA32, 0xB8F18E92, 0x370F7427, 0x08CE5B59, 0x40D50E97,
            0xB9879A74, 0x804BCFFC, 0xEED6EEBB, 0x0348671C, 0x2D397FC1, 0xBE2E090F, 0xF0569599, 0xB8A37389,
            0xF458BFB6, 0xCFE14E87, 0x5C47F1AF, 0xFCD6EF63, 0xF1025794, 0x4450695A, 0xB1F7C412, 0xE8E46B0D,
            0x1184DDBF, 0x9F9D3B28, 0x8C63C38D, 0xF92A433A, 0xF113ABA5, 0x3BBEDF75, 0x15ADAC82, 0xB0E4BC75,
            0x60298A62, 0x3DC3281D, 0x75DF9631, 0x9B442C3B, 0x3D799A5B, 0x92952EA1, 0x78F5D9EB, 0x18BC58D1,
            0x1462D1C4, 0x785036C3, 0xAEFDBB11, 0x591F7784, 0x382752B8, 0x4A3D63A2, 0xFBBC86C4, 0xA672E214,
            0x805F029B, 0xDE8415D0, 0xA63929CA, 0x374DF2EE, 0xF301A12D, 0x98837B03, 0xB0A3D193, 0x75554FC3,
            0xD8CA2ACB, 0xA91B324D, 0xB198CED5, 0xEC2E72DE, 0xB1633A49, 0xEC8919A5, 0x32E058E5, 0xD718CCE4,
            0x5575EC19, 0x2EFFDBEC, 0x508CECE8, 0x9827FA2D, 0x721EEFEE, 0x6C5AA028, 0x88E4F478, 0xB5B2A137,
            0xDD54234E, 0xB797EA73, 0x9F0EF9B0, 0x3655E965, 0x21BDA8FB, 0x154BE6F9, 0x70F81550, 0xCF6F6F7F,
            0xA09A94C1, 0x0B87899E, 0x648B5A41, 0x1753C489, 0xE869F36A, 0xF16DB5D0, 0x37F5D418, 0x4B63CF8A,
            0xB3D9D001, 0xA4894EF7, 0xDE1BFF0C, 0xE4F3A620, 0x07A1F064, 0x0C3DFAC4, 0x342CB65D, 0x73E2DC7A,
            0x71627A15, 0x87A027EB, 0x232570B3, 0x4CA2AE00, 0x350BF76D, 0x2B51D311, 0xFF1A799A, 0x28C245EC,
            0x9E44BDFB, 0xF9E0C24E, 0x969297E8, 0x5208A5F4, 0x8FCDEA2B, 0x8CA7496B, 0x21585BF7, 0x91E71B1B,
            0x2FD069A9, 0x9E6FEA2B, 0x4B41FD03, 0x5D9B51C9, 0xC948E0F8, 0x59ED81DA, 0x9427B958, 0x32386B95,
            0x4E612055, 0xF9C6B12A, 0xCF8DA243, 0xC3C2CAA2, 0xB2FF553E, 0x579B88DF, 0x94FA7E10, 0xF729C2A6,
            0x841B7792, 0xBAADB3C3, 0x0C4EB8FA, 0x1DF810A0, 0x47C54FDD, 0x8EB7D5B6, 0xA571F8F6, 0x9FFBC37B,
            0xBB140301, 0x4247864F, 0x7E0D6112, 0x7C551FE3, 0xD93F88CA, 0x752B1384, 0xF63D756D, 0x37623143,
            0x35629A98, 0x286B90B7, 0xF8DFCA9E, 0xDE39737D, 0xBA568FE9, 0x579EDBC7, 0x0A47DE6F, 0xFA9F24CE,
            0x0402974F, 0x7851BBB7, 0x575A3EF7, 0x50F9BF65, 0xD1C66000, 0xCC9E2EA4, 0x3F5AD735, 0x85D6C99B,
            0x10934941, 0xA1143CFF, 0xE083C117, 0xA1064B4D, 0xB51EB016, 0xA43D12D7, 0xB14719CD, 0x588F5109,
            0x3A47C698, 0xC20633D5, 0x699D251E, 0xBFB8AD5B, 0x9FC82A3D, 0xA6068907, 0x8836A785, 0x0688FE61,
            0xE026CD46, 0x16B032D0, 0x1FB45AF1, 0x260A1F81, 0x1AA7510E, 0xCA766033, 0xCF616E4A, 0x30FB35CA,
            0x79848F0E, 0x8AAF5E45, 0x369ECE12, 0xE2632F94, 0x994482C0, 0x257F52D2, 0xF2809FD5, 0x43A1C5D4,
            0xF08E4AD7, 0x07AE1EBD, 0x1D1C013C, 0x306D6453, 0x296A9B9D, 0x449D3249, 0x754D91A1, 0xC11CFF16,
            0x9C2E5534, 0x6B1F09FC, 0x0EDC10EC, 0xB4F564D5, 0x4262A6A4, 0x345363D4, 0x4054B031, 0xBDF26412,
            0x8EA54145, 0x00978295, 0x8BC709F3, 0xDA1CAC75, 0x5BFA9507, 0x57742918, 0x7FC2F143, 0x166523A7,
            0x260634C2, 0x515E0DD4, 0x67C178B9, 0x2A52EB92, 0xD569A4FD, 0x6D9865F7, 0xC3392AEC, 0x5A43A05E,
            0x86E013B7, 0xB6FA606C, 0x9A54853A, 0x08E50CBD, 0xA46841A5, 0x3CFAD3D3, 0xDB1B38F0, 0xF05AE12B,
            0x0CFD5DC4, 0xF02C8E24, 0x8330D9E1, 0x664FB54F, 0x71972933, 0x126671A1, 0xFAB57958, 0x4359792C,
            0x91F4E7F8, 0x490B3F8C, 0xFC1A88EC, 0x143F73CB, 0xD6A67F26, 0xB73269D9, 0x5AE27919, 0xE7332BEF,
            0x3DFD57FD, 0xF446BA73, 0x44D3D43F, 0x622A9266, 0x2D7F4E71, 0x7B077D34, 0x1D24842E, 0xA539DE01,
            0xB403E963, 0x9FED84F2, 0x316AD7D7, 0x36B4AFC4, 0x94C8BB94, 0xC7715583, 0x8DBF983D, 0xAA65BBBD,
            0x888B0792, 0x30A7F3E7, 0x427F48EF, 0xD9E57B73, 0xC24A799B, 0xFE708E68, 0x2425DC88, 0xCE587D16,
            0xEE15E606, 0x12AB7D7E, 0x94EAB0CE, 0x4A2B9A8A, 0x80E7B2D4, 0x6CD38AB8, 0x997A0AC8, 0x1BD0FE77,
            0x9FD272CF, 0x0A5E28A3, 0x5D764F96, 0xCA8022BA, 0x0CA31526, 0xF20E7BCB, 0xD5E2565E, 0x78E7F861,
            0x77F9C61F, 0x0BFF135F, 0xFD09F9BD, 0x24E431BB, 0xDDD271E2, 0xE9C0739A, 0xBE7B60E2, 0x1C48645C,
            0xC1FE2050, 0xE8F53968, 0x921BC0E2, 0x89257091, 0x3DCD2618, 0x9D418C06, 0x36DC6950, 0xA0317830,
            0x951C252F, 0xF384E563, 0xAC2C78B0, 0x00906C16, 0xB59523F7, 0x0349C71E, 0x8F7FED08, 0xF5729960,
            0xD4CC6BB8, 0xC749676E, 0xE34743C0, 0xD005FCDC, 0xE83D835C, 0x1D18ED47, 0xD426E866, 0xF2C43279,
            0x15FF9F45, 0x3A1F04BE, 0xA02ACF93, 0x06453CD6, 0x9A59D13F, 0x7B5A3EF6, 0x9229EBB1, 0x9BD42888,
            0x1ADD099B, 0x0CBFD2F9, 0x4FACDD7A, 0x55AEF8E5, 0xF380130A, 0xB3A9BDE1, 0x2A8D8987, 0xBC8C7CFC,
            0x41D62741, 0x54341330, 0x6704CAF1, 0xE5714176, 0xB6C41B85, 0xFB40662D, 0xEE555014, 0x99BAECAE,
            0x442EDF99, 0x1FCC1C41, 0x4A847D57, 0xF0F0E7F3, 0x9B0FA25D, 0x69B62EF9, 0x293C924A, 0x913FD134,
            0x79C5BDEB, 0x5DEBA54D, 0x249F483B, 0x4D545D97, 0xBD8B17DA, 0x5C4E68B9, 0x496B2FA8, 0x3B4DE188,
            0x9E21E8B8, 0xFA350E87, 0x53E9D013, 0x6A0B6942, 0x8FCB9D48, 0x0421727E, 0x9EC5805B, 0xD4367722,
            0xD880C620, 0xD26EC0BA, 0x2025136A, 0xAF298F0F, 0x91487D9C, 0xA87562B3, 0xFE21F06C, 0xCDEF7F1D,
            0xCF40A73F, 0x3112C96F, 0x502E9928, 0x8F5A44B0, 0x18192C03, 0xB8C4166B, 0x6F102140, 0x643AC2F1,
            0x9E9139E3, 0xC1406BDF, 0xE8EBFE77, 0x701EDA03, 0xA1C47BF3, 0x9D53E1FC, 0xFE80D618, 0xEC8B2B50,
            0x31D12B71, 0x6A6BD317, 0x5EF1770E, 0x0C32C3FB, 0x1B84C93C, 0x9952BDD0, 0x35F0B6B9, 0x0F295A03,
            0xEFF358BD, 0xB668C411, 0x13CE62A7, 0x7EFB6015, 0x0FF993BA, 0x28F4E362, 0x27FCF9FF, 0xCEA72B9D,
            0xF4FCE4C4, 0xE44E1E39, 0xF91924E0, 0x87B0A390, 0x405B4C7E, 0x27610CA6, 0x9EE96AEE, 0xE73A9BB6,
            0x56C2429E, 0x1791578F, 0x6C98B25D, 0x56E70B96, 0xCB57973D, 0x39023D9D, 0x7958628F, 0x139B91BF,
            0x4F3A93F2, 0x861A6085, 0x6B4DD1E0, 0x6A2A4A16, 0xFADA2647, 0x34546B7E, 0x94F94EA9, 0x99AAA121,
            0x4836E88F, 0xC5EFE900, 0xABD3A7D8, 0xAF96C95C, 0x14BDD64A, 0xC3BE436B, 0x32B260A9, 0xC5E0F284,
            0x1C1AC949, 0xE2DD8FA5, 0xAC1AC196, 0x64D2BF4A, 0x6147B64F, 0x04D9A71C, 0x68569931, 0x30778A5F,
            0x2097853F, 0x0ABF8B41, 0x0E446130, 0xD8AFEF44, 0xCECB6C4C, 0x4E86154D, 0x57460203, 0xDA9AF871,
            0x4110283C, 0x873ED485, 0xCB00A946, 0xF9616E7B, 0xB92740DD, 0x396F48FB, 0x352BCAD4, 0xAC0A41AD,
            0x1B311B96, 0xDC1A8C96, 0x956778A3, 0xBC731E84, 0xBDD85DA1, 0x1E2EBA08, 0xC5473B06, 0xCB7B8BB1,
            0x5EC75577, 0x3BFDF8B3, 0xBFAA64C4, 0x38C469D8, 0x71790C87, 0xCF35C50C, 0x930FE80F, 0x59E41EB6,
            0x8F1AC65F, 0x8E8944C8, 0x4A455EAD, 0x4EC31996, 0x3CB140A0, 0xE7A8E500, 0x7B6416A1, 0x08351487,
            0x3BDA10F9, 0xC4AF20E7, 0x7F5CDA9D, 0x9CB24BFA, 0xBE15E322, 0x14E44E83, 0x8DFA3451, 0x48B4E6A6,
            0xF46754C7, 0x0C07680A, 0x74CC13B4, 0xB33576D4, 0x46429FE7, 0x367AAF9C, 0x5C944C97, 0x7BD5F564,
            0xE00E5739, 0xED0B78B3, 0x0AA9B58A, 0x27FDBC9B, 0x40962AA5, 0x6281CCCC, 0x5C612D38, 0x1CDC0C2B,
            0xAC4B11AE, 0x9ACE1A87, 0x846D83EF, 0xC0B7903D, 0x6C1FC024, 0x44EC2ACE, 0xE3FF721A, 0x5C49D805,
            0x253D0EC7, 0xDA5D8AE8, 0x92476E89, 0x3AC3C6E2, 0xE06874AD, 0x575E8C1E, 0xB98B7D6A, 0xB95507E6,
            0x71100146, 0xC44AA724, 0xD42E1319, 0xC959DE41, 0x5E27A5A4, 0x2783DE0C, 0x92BC2C32, 0x425C3906,
            0x5D2AB69D, 0xC5B6D3CC, 0xBA4621C6, 0xD583AB9D, 0xC4AE15A4, 0xB0B0530F, 0x6A8F0FA5, 0x58994A58,
            0x4CAFE72C, 0x2DC44076, 0x6EF8C38A, 0xACD0EB8D, 0x4852A1E7, 0xD59ED006, 0x7057B704, 0xFCDC2FB0,
            0x8014B00D, 0x50D49F94, 0x999A3C38, 0xF369CB88, 0xAF165A3D, 0x37271992, 0x9ABA4E14, 0x2EC4D3F3,
            0x52CA2E59, 0xF120E187, 0x67F5CA3B, 0xA4D4C76A, 0x15BF4B9B, 0x7696D057, 0xBDA8BBA0, 0x3D0B4113,
            0xDB3F3C58, 0x6095CADE, 0x13C2D25F, 0x21E2E145, 0xF61429B6, 0x65F8457C, 0xCAA4FBCA, 0x6027A65A,
            0x5F21339E, 0x0D975D54, 0x1087C05E, 0x2CD5EC27, 0x5DBC8C71, 0xE0F20AA2, 0x7411BFC0, 0x2F437D0C,
            0x853ECD81, 0xDA7DB1D3, 0x02C45B40, 0xA95E3CAB, 0xB760A120, 0xE4836865, 0x66D8B202, 0xEE1FF77B,
            0xBEC1F42E, 0x1D57F99F, 0xB15A4B78, 0x132BE3DF, 0x9BED0A4A, 0x5DDDB80B, 0xBA371F52, 0x7F607A39,
            0xDF02DB52, 0x36A54395, 0xBAB5F23D, 0x24E772DA, 0x4B344A3D, 0x5C3CA5E9, 0x244D355B, 0x0D450A80,
            0xEBD56FBC, 0x2D6B672E, 0x0E5D673E, 0x51A42600, 0xC193C41A, 0xB314BCB8, 0x4525CBDB, 0xD84BEA37,
            0x4BAFE2B8, 0xF795A200, 0xC300B755, 0xAA40D86F, 0x5922399A, 0x615C5E58, 0xD47F5BDC, 0x889418BA,
            0xA7A6B9AB, 0x48570962, 0x872B746D, 0x11D6150D, 0xD03B72EB, 0x02125EC8, 0x27E9A460, 0x1DC90A83,
            0xE3D436E3, 0x91D65774, 0x4A79EEFA, 0x87430AEC, 0x418F2D37, 0x86E894FD, 0x7742E52C, 0x0845BA22,
            0x8ADAA525, 0xBAE3BDBE, 0xBE762E76, 0x2B9333A6, 0x30A27F50, 0x41935D42, 0xCD4B1F87, 0x9FC406CA,
            0x16FC8627, 0xEEE26BA8, 0x8B2D6D99, 0x9561710B, 0xDA02FA9B, 0x400D1C91, 0x756E949A, 0xF53C70FD,
            0x530EA9A4, 0x9257ED53, 0x13BF21A8, 0x8F3CB001, 0xA2E75ABA, 0x5CD529B6, 0xFF15F297, 0x4F09114F,
            0x4D56CFAB, 0xE23F60C7, 0x0E6DF105, 0x4D9F0A90, 0xFABF0D39, 0xE531307D, 0x36560E51, 0xE5977B55,
            0xB203B952, 0x087E4BFC, 0xAFA648B1, 0xEE51E6B7, 0x70557926, 0x22EE9386, 0x7A992550, 0xA23EF7EE,
            0x9FCAA8C3, 0x6787D6FC, 0x7F0CA160, 0x386A5AD3, 0x6111BCEE, 0xBEDF0746, 0xCE4C60F5, 0x24660478,
            0x09873396, 0x25D3A0B3, 0xAFE325BD, 0xC50CAAEA, 0x0BDEEEAF, 0x0627457E, 0x92C35066, 0x5767A4D4,
            0xE44B0572, 0x8952615E, 0xB6193955, 0xA22E54E9, 0x5A3DC9C2, 0x20F6F5D3, 0xA8C40724, 0x76F058A2,
            0x1653357F, 0xD990ED17, 0xD2B3E8C0, 0x7573A028, 0xEC1E332E, 0x4F3D5531, 0xE2DD6C3B, 0x9BBC7AEE,
            0x00FD29E6, 0x7CC3A85A, 0x6357F59F, 0xC5759228, 0xE9DAE28E, 0x6804B504, 0xF0BE7D22, 0x6D60787B,
            0x17A25970, 0x4C2842F6, 0x5200770B, 0xC4FB6310, 0xC8626B1A, 0xE5C981AD, 0x5E0A79F5, 0x66F74A73,
            0x9CFF4366, 0xF735A0D6, 0x6AF8E2E7, 0x9E1D65F0, 0x1B3FFA95, 0x60FF248B, 0xE01D0378, 0x252758CC,
            0xDDACA8BE, 0x1BAD5FE0, 0x14CC6512, 0x811DC79C, 0x88A9BDE1, 0x645CB350, 0xAE1526FE, 0x8955FE46,
            0x9CFE0BC4, 0x19A8B8A9, 0xF2A37FBF, 0x1266F31D, 0x89E9155E, 0x126A5691, 0xBB618E60, 0x477DA546,
            0x4561B971, 0xD79B8853, 0x24D6F892, 0xA59BB0BB, 0x3EE96BCE, 0x3FE516C5, 0xFCA74542, 0x7F638337,
            0x88DBCFCF, 0xE613901C, 0xB54D0DCB, 0x9FB87191, 0x45686EAD, 0x4B5E9ECE, 0xD6E89D35, 0x391F8F32,
            0x7847AC70, 0x3BE01BC7, 0xF72AF77A, 0x573BB2AB, 0xDFA7144B, 0x1EB93BA2, 0xBAB54253, 0x16374A83,
            0xE0F9C75D, 0x60E5F137, 0xD2AFB202, 0x1C821082, 0x35748901, 0xE3F39284, 0xB3D62605, 0x074486F1,
            0xFD5BB804, 0xCBEDC0A5, 0xE59C471E, 0x6805A270, 0x85C5546E, 0x14EFA52C, 0x195CF9A2, 0xB697F5CA,
            0x0C81F1C2, 0x2B2A9BDC, 0xA4442F43, 0xF5E63944, 0xC012B91B, 0xA0590701, 0xC104C593, 0x5CCEDD99,
            0x4B721F2B, 0x8B16C110, 0xA98CA0F6, 0xB06D22A6, 0xDD059822, 0x71B09440, 0xF4EE1C44, 0x734CC3BA,
            0x1FC2D73B, 0x583B739A, 0x06472060, 0xE2950718, 0x62429AFB, 0x14B533ED, 0xC586409E, 0x00857776,
            0x79526DC5, 0xFBFC5839, 0xF6635DE2, 0x3C4702F1, 0xDD96C0FB, 0xF382CD54, 0xF0E9CF10, 0x937440F2,
            0xA8497A6F, 0x8777082B, 0x73502526, 0xF302C567, 0x6F102803, 0x72B3EB22, 0x66979AF8, 0xCDAB049F,
            0x1ED699F9, 0x7B2A40C2, 0xB9F7F1EB, 0xDF73AA6A, 0x13CFA897, 0x4DF64F7A, 0xEF598125, 0xEAEAD2AD,
            0xE2F6EEE2, 0x08B3F6E7, 0xC6874930, 0xA8348647, 0x2DAA9567, 0x894DFBFC, 0xCE85329F, 0xBBDA27CA,
            0x67B2761D, 0xF8AE8482, 0x59DF703A, 0xCC0281BC, 0x2084FDD1, 0x05EF4284, 0xAB99847C, 0x9A8F4C98,
            0x4BACFD32, 0x88F3DB2D, 0x56838E8E, 0x5C147EBD, 0xC8B39546, 0xDB70880F, 0x36F55388, 0x5AC2E65D,
            0x067AB363, 0xE141869A, 0xA8E5F5EE, 0x24C44ACB, 0x90CC95A0, 0x0FE37D7E, 0x3DC35303, 0x591D47A5,
            0x33D20FCA, 0x1DB04F13, 0xC5D8667F, 0xBFAEB848, 0x3392B85C, 0x969A350C, 0x22BE04C5, 0xE5657EB3,
            0xC9FAF912, 0xB8B8F295, 0x9B423D11, 0x381229B2, 0x5A0DB840, 0xF00311B2, 0x2DB9D196, 0x51FE380A,
            0xAE534D72, 0xAAC030C9, 0x75FB8E23, 0x93A3AFCB, 0x4B14E5F2, 0x174FF08B, 0x48059B1E, 0xADDFF8A5,
            0x8A8DC43D, 0x31475246, 0x5BE6F0D8, 0xC1B62A4B, 0xBD5F3635, 0xCD9A0C93, 0xB5E5F7B4, 0x8399328C,
            0xFAD0EEB8, 0xAD0FAE6A, 0x847975AB, 0xB7C4D2ED, 0xE4142E3D, 0x8F0231F2, 0xDDBC7E46, 0x10AF0180,
            0xD4CD6ED4, 0xA8CA401E, 0x41825EF4, 0x685879CD, 0x059148BD, 0x181B52E6, 0x25E3DADA, 0xAA5C658E,
            0x78F35089, 0xC6F8B855, 0xBAC20D18, 0xB5FDB3C9, 0xDBF3D1C9, 0xDED3D1D6, 0x75ABA2CB, 0x6A5E893D,
            0xBBFD6399, 0xA1EDE789, 0x87CA6FE9, 0x9F0D2E1A, 0x327611B5, 0xAC9103D3, 0x1EA41AEC, 0x91CDE52A,
            0xC52DA4E0, 0xA7CC6AF8, 0x471A598D, 0xA4317CA9, 0xC00FCCD8, 0x9E117502, 0xE75827B0, 0x6427007F,
            0x7E3041B2, 0x99DACE7E, 0x5A99338A, 0x7B04E86D, 0x504B717D, 0xEF8B403D, 0x20C18A3F, 0xB5556E88,
            0xB2D53CEA, 0x18DCB714, 0x41562446, 0x70C2BA99, 0xF81DEC2A, 0x336E16FA, 0x964E5BD6, 0x9239DAF4,
            0x0921A651, 0x88DBC996, 0x529A821F, 0xBBFEA73D, 0x467B720F, 0xB228521F, 0x420E560F, 0xA33E1E63,
            0x93FC211E, 0xF1A946CE, 0x4D52A7B9, 0xEE6852D7, 0x4F2E676A, 0x5A0B6424, 0x8B58F28F, 0xAA4375CC,
            0x8C5E0B0A, 0xA0EA29CE, 0xB8C7BAB6, 0xC81A22D9, 0xA631C256, 0x396CF2D4, 0x04740718, 0xF125534A,
            0x7D5AEAFE, 0xB409FECA, 0x5E509473, 0xA4208CBA, 0x48BA4427, 0x7D00F236, 0x536506B7, 0xCBDD3064,
            0x20531B5D, 0xF213BF17, 0x8547B3E0, 0x4EE5412F, 0xA07A8BFE, 0x9BDEFCD6, 0x50B0E294, 0xDD7B71CC,
            0xC6BB1AD0, 0x1663A105, 0x57CEC4D9, 0x7B267D2A, 0xFAD16AAA, 0xDB15C354, 0xE76CB9F5, 0x13D7AE85,
            0x25807794, 0x2AB2A062, 0xDE1F9A30, 0xD64784F0, 0x8B67C09C, 0x57D1FAA1, 0x3D9AF5D8, 0x43961BED,
            0x343AC3C8, 0x24752FD1, 0x8758FA98, 0x34143908, 0x7ECCFD45, 0xCFEA3C88, 0xD47C8269, 0x7116D0CA,
            0x5598D5A9, 0xE7172E34, 0x2B0B6480, 0x8C12B36C, 0xDE3D98A3, 0x2715097E, 0x263A67F2, 0x7AC35EB5,
            0x03C9B194, 0x8487E88B, 0xB38D18E6, 0x7E977698, 0xBC9DBB7E, 0x79B0D2A8, 0xE6828FC7, 0x1A7E6871,
            0x71F06903, 0x77C5699D, 0xD67F31B1, 0x73086889, 0x773953BC, 0xFD384FA4, 0xFCA43ACB, 0xA0752D7A,
            0x802241FD, 0x7E89596C, 0x7A8AF7F4, 0x60847B87, 0x829C5DB2, 0x54CB7A17, 0x68107DBA, 0xAC981AF3,
            0x3B7A3D40, 0x00044727, 0x54CCC16E, 0x01586606, 0x41C0ECC1, 0xC2FC4B60, 0x66F35404, 0x112C3DE3,
            0x57DCC368, 0xDF5F650E, 0x00C5AE1A, 0x383AB520, 0xD16E21DC, 0x7CE0C25F, 0x5A042C1B, 0x9826A86F,
            0x733FE14C, 0xD9B103C6, 0xDCEF984B, 0x695D4CD2, 0x2030AA64, 0xEEE8AE9C, 0xF68B2A64, 0x0956AE2C,
            0x074EE8B2, 0x023A8829, 0x5E2F8A07, 0x39E5F2AF, 0xE443D6E8, 0xE4023980, 0x56840031, 0xD93FADDB,
            0x0425C226, 0x0C02EDD4, 0x4376F707, 0x5896FBB7, 0x3A4934B1, 0x9DB63A8F, 0xD273ECCC, 0x3CD5CAB8,
            0xCE0409BF, 0xF42A1E08, 0xC8088044, 0x4B85A388, 0xB662624A, 0x6F2E1C9E, 0x453D0719, 0x2D6D5862,
            0xE53D3B30, 0x23FE9C5C, 0x4CABBB91, 0x986AAE3A, 0x24DECEF2, 0x4460BFFC, 0x9B06DCA7, 0xC026DB3C,
            0xEEFBF8B4, 0x9CB6E23A, 0xC7A3F13B, 0x00E732F9, 0xFF9FD05F, 0x536AD7C3, 0x46DD59C0, 0x9CC1F6BD,
            0xADEDB826, 0xFFABDFE2, 0xA1EADCD9, 0x43F180E6, 0xB7A8C6AB, 0x0452F2E0, 0x951EBA97, 0x933E828C,
            0x45F800DB, 0x22528564, 0xDFA87F3C, 0x9FA591E2, 0x8E39F682, 0xE80D36D3, 0xD302A8A4, 0x36416201,
            0x382EE408, 0x8EB2D90F, 0xCC83F4A3, 0xD4AAA5E1, 0xBD1304BF, 0x85306919, 0x6E3ED76A, 0x3DA4D14F,
            0x6C05ED3C, 0x951BB0AA, 0x41BCB0F2, 0xB186EF09, 0xCF49AC25, 0x3FEF4640, 0x11DCD9A1, 0xC78F3A08,
            0x8C93904B, 0x98E1043C, 0x28B7A068, 0x87177CFB, 0x28E2A19E, 0x2A3964C6, 0x9C4177E9, 0xC1E9CB26,
            0x260962AF, 0x07AC1F34, 0x8061C6F4, 0x44194797, 0x1E2BC045, 0x8D73D60B, 0x56C43C28, 0x231D0F3D,
            0xBB4A2CFF, 0x105D522A, 0x07AAEC45, 0x84D4476F, 0x31E6EF2D, 0x028FBDBD, 0x316151C3, 0x94921D8E,
            0x0DD4A424, 0x0D93FA06, 0x3EC2E2CC, 0x2C5563D5, 0x87C6E765, 0xD0B01B9D, 0xFA9BC4B9, 0x290E2032,
            0xF895089C, 0x59857704, 0x1800E607, 0xA1232BEE, 0x84D06CC6, 0xB4405AB1, 0x11B9C2B0, 0xD3C9C1F1,
            0x26A422D8, 0x51173785, 0x14E7BC7B, 0x900A8FC3, 0x8ECDAC2A, 0x8F0F7C58, 0x1A8F9289, 0xBA3D7342,
            0x6E5940DA, 0x1385EDA7, 0x47593344, 0xA589D065, 0x323895D7, 0x7E685981, 0x88D5BA9D, 0x90AB1F2C,
            0x5255CF21, 0xD7581E43, 0xBF8991B6, 0xB0A069EA, 0xB5C0EAC0, 0x5D2F3C1F, 0x6059F696, 0xDAEDC105,
            0xDA344A96, 0xF363C907, 0xF338060A, 0x2E86C0F7, 0x2E50A05B, 0xF7B6CAAE, 0xE8DFBC78, 0x8ADD2A5B,
            0x7856323E, 0x6425FA72, 0x2E73B2EB, 0xA7126E6E, 0xF2E8408E, 0xAB8E7D1B, 0x25EABAA7, 0xD47B656A,
            0xB2A3F9A9, 0x941117A5, 0x87D6BD32, 0x85758B7C, 0x89F89E5C, 0xB98601E0, 0x3C3D41C6, 0xFD4C3D3F,
            0x61C69C23, 0xC7DADF1C, 0x602B1D47, 0x463C8DA2, 0xA985699F, 0x4A8F805D, 0x383C2C65, 0x6D9361F8,
            0xEFB3E55B, 0x0851C044, 0x28DDF38C, 0x1BB1853C, 0xFA479FBD, 0x43A506F5, 0x6CA46ABF, 0xAA209215,
            0xE8AF1986, 0x6E4CC030, 0x7922EE4B, 0x0AEB65BE, 0x94E2A616, 0xA1E5D85D, 0x65249684, 0x33C3BFD0,
            0x89265186, 0xECE567E2, 0x5BE3F1D7, 0x00543969, 0x517043EB, 0x01C5E35F, 0xEA5BD033, 0x6F399A8B,
            0x1BAB5A70, 0x6C432158, 0xD4D9BEAA, 0x78057D58, 0xCA134C2B, 0xFF6BAE57, 0x52270A56, 0xD2E6FC00,
            0xC00F723B, 0x6D3139B2, 0x3A6FD784, 0x5B6C1DD0, 0x05A38CC7, 0xE6384A26, 0x503E8B94, 0x3849F597,
            0xCC33262C, 0xC905B22B, 0x3243F03F, 0x69E3E6B6, 0xE259AC27, 0xF0F034E9, 0x9F28F256, 0x50CE203B,
            0xB919D10C, 0x96266B17, 0x93FEDEA0, 0x45B0DCE5, 0x23934FF3, 0xF523D8EE, 0x3DE7E0E3, 0x2E90E79A,
            0x64065354, 0xE6EF22FC, 0x37D5E320, 0x021C6592, 0x250B315B, 0x6516ED3A, 0xC081FFC3, 0x050CBE48,
            0x5330773D, 0xC75B39C1, 0xF9B9D6F3, 0xDBAA3641, 0x4FC42D62, 0xBA73F979, 0x75564DEA, 0x523E47ED,
            0x06858B39, 0xBEEDD2A8, 0x005DC1EC, 0xE829F8C5, 0x8FE0EFB6, 0x1D2183FE, 0xADF55DA1, 0x5295EE7B,
            0x4F32EC4E, 0x4A46C05C, 0xCE0637E8, 0x22A31B8F, 0x5AD5F180, 0x1277C2B4, 0xB8178AE6, 0xC492DA38,
            0xAB181D99, 0xB17789F5, 0x457FD233, 0xCA83368D, 0xBC41B07A, 0x118A6ABC, 0x0ED9FCA5, 0x365D8468,
            0xE49D0F50, 0x6D445390, 0x1C019438, 0x7F0442C6, 0xFDF1F1E6, 0xAF366B7B, 0x33521C01, 0x19527445,
            0xADBB3AF8, 0xE074C06A, 0xE7266AF8, 0x3850DE1F, 0x0FA0B2CE, 0x4A8B53E3, 0x0E68D3F4, 0xD65E7C3C,
            0x1930CA07, 0xA41446A8, 0x99EA2755, 0x2E81BBE1, 0x74714F95, 0xCA1F9CEE, 0x0833664E, 0xBDE63550,
            0xDA9F31A5, 0xA0440DE6, 0xECDF3B87, 0x4FF01126, 0x4B893109, 0x4B2679D3, 0x0FD09B2D, 0x012BDF8A,
            0x8FD67B2A, 0x51A52E36, 0xF7FBAD36, 0xB1BC9CE7, 0x0D9FF8AC, 0x93E3A001, 0xFD7857D2, 0x445DF59F,
            0xDB2B7BD3, 0x018C5C60, 0xB6B29486, 0x6E0ED3F5, 0xF54F3F9C, 0xA0ADC759, 0x91D47B42, 0x1DF5DF45,
            0x1B7FA26E, 0xECEB0AA3, 0xD1C0AD07, 0x798DAAFC, 0x12D4D674, 0x7A7B7D7C, 0x5C6F8694, 0x7B16B79F,
            0x837E3BD6, 0xB47CB25D, 0x94DADDF1, 0xEA6141F9, 0x74FC0004, 0xE9A526E3, 0xA5D43770, 0x6FA3679F,
            0xDD42884B, 0x669B30ED, 0x08B2C910, 0xE5356F5C, 0x8BA5775E, 0xEED41704, 0xAB914599, 0x6DF57FD8,
            0xD78AC7C9, 0xDC31B818, 0x6A50BA80, 0x0A1AED00, 0xF4948145, 0xF9334FBE, 0x3289782C, 0x340910FC,
            0xB3C04BE2, 0x11073974, 0xE897745B, 0x084E815E, 0xE2A8994D, 0x2919C3DE, 0x3C6F6C3E, 0xB26554F9,
            0x93714EC5, 0x3A5F4618, 0x7DC2524B, 0xC5CC747A, 0x8AFB85A7, 0xF53F4467, 0x5FC8025E, 0x0E63EAEC,
            0x1CE09BD5, 0xB2901C44, 0xD2FB1508, 0x58C0F15F, 0x1582B012, 0xF7DCFB4F, 0xF2F2C9EA, 0x747185FE,
            0xF75EB49A, 0x5635BFD9, 0xF7F7AB66, 0x6E2212A6, 0x1C5B0AE6, 0x53E78190, 0xA3F83332, 0x23BAA14F,
            0xAE120E43, 0x734AD683, 0x8DF47ECC, 0x35B2A127, 0x2AD9B77D, 0xE4B8019A, 0x87216253, 0x6229CD4A,
            0x62DE32F6, 0x421EFDC5, 0xDCD76EAD, 0xA697EB06, 0x0813A9D5, 0xA2F91273, 0x22415AFE, 0xD30FAF82,
            0x659D70DF, 0xCFFA3DA4, 0xA2200A60, 0x49672A14, 0x314773DC, 0x69F8C39E, 0x212C7927, 0xD3747D67,
            0x3BC2C780, 0x55955326, 0x622F8709, 0x423CBA82, 0x8DC4FCA7, 0x984C48A6, 0xE229C845, 0x81859952,
            0x0E6902F1, 0xB903DBB5, 0x759B2B3E, 0xD2CF81AD, 0xAB61C511, 0x14B1DDC1, 0x56EA4BD7, 0xF1C89C19,
            0xE199A394, 0xB2843784, 0x77ADFD9E, 0xFA9AD23E, 0x00B2F44F, 0x99B82B01, 0xF16D50F6, 0xD3BC9EB3,
            0x5FD9F4F1, 0x7C5795C5, 0x26AE05AA, 0x982EDC87, 0xCBF45C43, 0x557F1499, 0x467BEA23, 0xE4D3BC6D,
            0x0A4113ED, 0xE61C04B5, 0x49A265BC, 0x8E282D67, 0x353B47AC, 0xD8558DDF, 0x0608DE9E, 0xFB485AC7,
            0x68AF5D4E, 0x974F410E, 0xDA17505C, 0x63A027D2, 0x8384D2E9, 0x924523B6, 0x3CD9EB2D, 0x879098A0,
            0x2D607CA4, 0xEA9D8725, 0x992BC8B1, 0xE506A56D, 0x84D90331, 0x6B160265, 0x736A57E3, 0x6946DF0B,
            0x768ADF98, 0xE9A40AA6, 0xC4FB40C3, 0x48B1728F, 0x44ED3080, 0x8B6A5D47, 0xE6F245C7, 0x8085EAF2,
            0xACFFF10A, 0xF3C7EF1F, 0x83A29C91, 0xFB09DDA8, 0x677A6119, 0x9427DDDD, 0x758CCA18, 0x84DEE828,
            0x036EBF1A, 0x9A8499E2, 0x8DA3D209, 0x9B3F1A58, 0x92D2A15A, 0x16B44B4E, 0xF3463199, 0x8ED95B31,
            0x6F7732CF, 0xC0E34BCE, 0xA6AB51F7, 0xF4A3379B, 0xF2E21D08, 0x02FEDB6B, 0xD2B64D9B, 0xBB2F55FB,
            0xB0A2E5DF, 0xAE3FDD91, 0x82C166B2, 0x9D99CBBB, 0x306C897D, 0x4EEDA667, 0x92389553, 0x7F3CEE56,
            0x9B3FBB5F, 0x53FE7BF2, 0x795FB9FF, 0x77772C45, 0x42079E03, 0xB950058D, 0xB663C661, 0x1632566E,
            0x38E51D9A, 0xBA561B29, 0x541789E4, 0xB383A64F, 0x930B8CEE, 0x0EBC82A9, 0x2238D266, 0x36D12716,
            0xA1FB0FC9, 0x797C136F, 0xECBF3E89, 0xECFFFE06, 0xCEBE993D, 0x3B7E0F44, 0x77045A06, 0x8A2C4D79,
            0xDD47181F, 0xD0E1EEC0, 0x861DD0BB, 0xA08ED739, 0x33D6DB02, 0x3A63EA06, 0xB6F43F74, 0xD846F9B5,
            0x84F90DA4, 0xD566E965, 0xF0007825, 0x8649F41A, 0x860902D4, 0x952D7F39, 0xED147CE1, 0x76C51301,
            0xACF76EB8, 0x2E6A1EBF, 0x998C71C7, 0x93680302, 0x21AA560C, 0x68D69BF4, 0x27B57EA8, 0x933B5E70,
            0xB7F2B06F, 0xA37640C0, 0x8C449801, 0xD1A5D64C, 0x20EF828C, 0x790C2C3D, 0x3E2FC99F, 0x5F7331D8,
            0x938647B6, 0xC789522A, 0x34D1B2B4, 0xBBD49AF4, 0x1900ECD2, 0xFEE58AD6, 0xAE0E7D03, 0xD89C77F3,
            0x0AC0E427, 0xB9519B1E, 0xACE22DE4, 0x062B6AC1, 0x37BC159F, 0xEE2D1512, 0x95B75895, 0x2D58B05A,
            0x3B9D02B8, 0xF3BE8739, 0xD94B1F0A, 0x6D1BC26D, 0xFB6A9FFD, 0xE564F27F, 0x710BC569, 0xF5B10D71,
            0x57F7432F, 0x79E56E81, 0x8713825B, 0xD1CA0FCA, 0x5C79C592, 0x985BB6BE, 0x47185BD4, 0x1F634BB6,
            0x18943840, 0xF0B18D3D, 0xD63B470B, 0x867F717F, 0x2CE04165, 0xCC5B8D06, 0x0743C939, 0xAB3151E9,
            0xDE92221F, 0x006673C3, 0x76CF63D2, 0x22BBC2D1, 0x0F704B4E, 0x55B4AC90, 0x5FAB2E87, 0x1B9AAC2F,
            0x9BE10383, 0x657E6DCD, 0xAE0B019D, 0x0DB152DD, 0xC5ADEA44, 0x13127CBA, 0x3958A3E7, 0x43725F1C,
            0x3CFFBBCB, 0x6DB011DF, 0xB27D8178, 0x5606627C, 0x45E4BDC1, 0x944E1902, 0x35917315, 0x8834D953,
            0x0F1EE74B, 0x19656BE9, 0x3BEF5D78, 0xCD63AFF4, 0x0058B743, 0x04E6A8ED, 0x9D69DFCA, 0xEC116E35,
            0xE1AC724E, 0x7A948028, 0x74ED27E1, 0xE5F3AD03, 0x6C0E5914, 0xC0D42270, 0x590AEF66, 0xD71EE063,
            0xEEF75DA2, 0xEBC49B53, 0xA78BAB3C, 0x88D41C1F, 0xB7FA273B, 0x3DC27B6F, 0x2F8AFB7F, 0x08334BFB,
            0x51547847, 0x94BF2007, 0xFADF4918, 0xC529F02B, 0x78DB334C, 0x01A1C5EA, 0xCF98EFF6, 0x7D4AA5B6,
            0x1D5C2F1B, 0x8755CF0C, 0x02C6242C, 0x7D07350C, 0xFB2F7297, 0x7554225E, 0x49FF6E35, 0xA8F4E5FA,
            0x964B071E, 0x0276A8D7, 0x62F19F67, 0x433CF9ED, 0x77BE96EA, 0x1C620BDD, 0x28F1C5A0, 0xAB91BA2B,
            0xAE85C118, 0x78FE3DB8, 0xDEE3F1C4, 0x29DEBBF5, 0xAA7AE0DA, 0xB5C583C7, 0x660544A6, 0x415E43F2,
            0xA5B92BF5, 0xC54F8A27, 0x6C907048, 0x9E02DE66, 0xB041CC20, 0x36F65AE9, 0xE624E348, 0x876B5970,
            0x62825093, 0xBF76F84B, 0x39DFD461, 0x24BC166C, 0xA7C89548, 0xFE9E0B1B, 0x831A0563, 0x68B101DA,
            0x380A7CA4, 0xA62A52A1, 0xBACC9494, 0xDF5D4273, 0x253E9FA9, 0x62A62B19, 0xE1DB5893, 0x98E4AC87,
            0xFFB1742A, 0xC19BEF10, 0xECD7C258, 0x53CA64A8, 0xD9B62DF8, 0x62341674, 0x715F913F, 0x5C01531C,
            0x0F7FE324, 0xC77D0E15, 0x1A99B071, 0x31BF3683, 0x682C9BD1, 0xE3E7401E, 0xADB28FF3, 0xB5FBCE04,
            0x364381F2, 0x2D92F9A3, 0xB78B4B7C, 0x8C58BF64, 0xD7CBDEB1, 0xD70CE361, 0xBC47E896, 0x87DF2D06,
            0x7C6A54E4, 0xCCE21DF9, 0xC6898B8D, 0xCD43646B, 0x38B8C11B, 0x7E7FF7DB, 0xCB4C2BF9, 0x840B44E8,
            0x4261A9E4, 0x356A81F0, 0xCE0406BC, 0x2959CCEC, 0xE87C9951, 0xD458A226, 0x42B4009C, 0x59302CA4,
            0x9D2B54C6, 0xB178947D, 0xBD17CCE1, 0x3BD85FF9, 0x8EB2A98A, 0x93C46818, 0xDFF0EF67, 0x112865D2,
            0x6599579B, 0x6826FBA4, 0x2EA89015, 0x3F562B06, 0xDBF84A73, 0x11CFC219, 0xC076E3AB, 0x21CC7426,
            0x1398C0BD, 0x4003C97D, 0x06DD74A0, 0x4BDD159D, 0xA8641938, 0x164CC783, 0xBD2A845A, 0xBB08421B,
            0x0B97B4A8, 0xB273EAFD, 0x97E6D141, 0x156D5D9E, 0xB33444D8, 0x2CB38E53, 0x5E2B68D2, 0xC1E69BF2,
            0x26EF9E0D, 0xD8049ABC, 0x4933AF97, 0x0342ECFD, 0xD4F938E2, 0xA558E45A, 0x83D8F1A4, 0xA1D8AF2C,
            0xFE01FA66, 0x3D30B7B7, 0x0C5F27F6, 0xD4643C63, 0x262E0625, 0x563D2635, 0xFCCC6075, 0xD277C282,
            0xEF6E2E5F, 0xE9A6E93E, 0x66B69DC0, 0xD9899E20, 0x31CBE8A3, 0x65FDD614, 0xC4998302, 0x951435E2,
            0xC7BF2B5C, 0xC1A511FD, 0x4A71E6AF, 0x18666B54, 0xE87FF801, 0x19F369AE, 0xBCBE364D, 0xC9D6C116,
            0xE4B6392E, 0xAE1CF90F, 0xC7C5C62B, 0xC6569D53, 0x77AB5799, 0xD1137C38, 0x5785E8CB, 0x0D58C4AE,
            0x42C2C25D, 0xF0BC1BF4, 0xF3249667, 0xC1452A29, 0xA9B5BFC6, 0x99672E07, 0x50BA79AD, 0x67C372B5,
            0x0F68F48B, 0xED82576E, 0x5B24ED11, 0x10022570, 0x967E9525, 0x2E9817D1, 0x2BE46326, 0x1FA423BE,
            0x7C5EED09, 0xF36213F2, 0x01E2A9B3, 0x5A78D9B2, 0xE72C0E28, 0xBD2C163E, 0x273EE252, 0x65EA4C15,
            0x82F0C077, 0x5A5C5F58, 0x945F56C3, 0x172016D0, 0x44DBE669, 0x5302BB91, 0x2E90068A, 0x2E1B1FC8,
            0xBC04DAE2, 0xA5A89539, 0x2089BA0A, 0x48E19265, 0x4115104C, 0xF3E4C8CC, 0xFC97CA07, 0x973E9040,
            0x6060597E, 0x0CF3072E, 0x0CE3823B, 0x8D5AA1BC, 0x932F6A8C, 0x704C84A9, 0x0FA033FE, 0x837E2DB7,
            0x4769F5C7, 0x3DF268FE, 0xAC83D2B4, 0xD4C00921, 0x5130E55D, 0xB9C717A9, 0xE39E41AE, 0x507ADDE3,
            0x825AEC85, 0xC9D063D3, 0x7EA46647, 0x6EBD1243, 0x49538811, 0x29C6CE8A, 0xA7B87A62, 0x34D6F2B0,
            0x5CD3944E, 0x68F99645, 0x7C2D0899, 0xD1AA7CA9, 0xFACB471B, 0xA2F8D9ED, 0x87951D27, 0xAD648102,
            0xFF5F795F, 0x68E7C4F2, 0x5E27B4AF, 0x767FFE53, 0x5D66EAF9, 0x66516BAC, 0x14F9B067, 0x1FE4F426,
            0xCD89627D, 0x9FF468F7, 0xAD9BB96B, 0x0F5734FC, 0xC9FC81E4, 0x6E54CBCA, 0x28B37EC8, 0xE5012553,
            0xB3FFDB00, 0xA03C02B4, 0xE88D8F5F, 0xE7D62F56, 0xB28D2D4A, 0x7673C6A0, 0x05A37B43, 0x0DFD4906,
            0x65866852, 0x20ECD696, 0x6B324FBC, 0x8035AE9A, 0xB5B009E5, 0x59BF7BF5, 0xE66D91DD, 0x10CC44CB,
            0x6EBFC0E1, 0x683AACE6, 0x268A02CA, 0xFB54A934, 0x330514CA, 0xB70888E8, 0x23778B0B, 0x1F6389FA,
            0xD16354B7, 0xD6E3DFAD, 0xC5DBD2AA, 0xB02CA65C, 0x572EE00F, 0x457220B7, 0xA4A1442B, 0x87C13020,
            0x690ABF27, 0xE26D8104, 0x49BF817B, 0xCEBD0057, 0x87369FEE, 0xA54C2E3B, 0xC76E1948, 0xD5257EEE,
            0x335FC545, 0x8FB404A6, 0x4B50C43F, 0x5A8CF8C6, 0x40A3AC83, 0xEB8FB0A0, 0xD89DF8FE, 0x3D016D1A,
            0x5F9CE9C9, 0x8421B2F2, 0xDEEADD4C, 0xFF8EE572, 0x68E6F0F7, 0x0FF90F43, 0xD8BB9AD9, 0x82D132A0,
            0xEBDC6ABC, 0xC3E7CDA4, 0xE092B60B, 0x1958D3FC, 0x351E045C, 0x794C0393, 0x24D45253, 0xDEBD4F9F,
            0x724E704B, 0x52FA6863, 0xD20DE03F, 0xBBFABBEB, 0x74741EDD, 0xAAB8FE75, 0x184E2A34, 0xD108BA34,
            0x8B6D2023, 0xF4D2FA97, 0x0D06AF82, 0x051BEE63, 0x84450A19, 0x9F8C9A9C, 0x1EA67044, 0xD00161BB,
            0x8A839599, 0xAFF57105, 0xB5B72816, 0xAA3B3500, 0xB8467297, 0x5BE7C216, 0xE45021DC, 0x1712EA01,
            0xA0DD3C58, 0x9F372167, 0xF07F2455, 0x6E4E287B, 0x94BC3FFF, 0xC2906E3F, 0x3012B705, 0x717369B3,
            0xC6CEE6D8, 0x911D4F95, 0xF51A970C, 0x3731A2FE, 0xB4387386, 0x79251946, 0xC7098B1A, 0xB3AEAB90,
            0xE74FE5E8, 0x428D5A07, 0x95B41A3B, 0xCA6BE9BB, 0x8B5FDA39, 0x69544F52, 0xEDFAB795, 0xABB64C29,
            0xBE142A0B, 0x52F81BC0, 0x893DEACB, 0x9794810B, 0x1284DB17, 0x02A9B0B2, 0xE76BD97F, 0xAA0CB52F,
            0x678A9804, 0x3F949161, 0xAAE6294F, 0xEE44D73D, 0x47BA71C4, 0xF4579F88, 0x5443C383, 0x65FDE0C7,
            0x104E2F48, 0x8609F171, 0xB492B694, 0xBD5836CF, 0xF126F8C9, 0xFB8E101D, 0x93E3A17C, 0x4A69EE9B,
            0x2FD23785, 0x5CF29D9B, 0x17BA2691, 0x144867C4, 0x85FDC47D, 0x317678BF, 0xEFE6E0B5, 0xDD7440FF,
            0xD23BCF32, 0x63F4D391, 0x52BEB146, 0x83F658C0, 0x20B3B303, 0x1EC4A3B9, 0x5062D2A4, 0x146D9364,
            0xFB7C1C9F, 0x9663E013, 0x965EFE67, 0x3105E3DF, 0x0387E62B, 0x187A2478, 0x33AF10D5, 0x9BD65D85,
            0x6FB3253F, 0x15A534AF, 0x1A2EDE0C, 0x33CD3196, 0x67666564, 0x7D6E5224, 0xB9F1F609, 0x5B95ED1B,
            0x9752525A, 0x0A50FDEF, 0x86472A3B, 0xCFED08FB, 0xF2E66E56, 0xC1B20353, 0x82E2CC20, 0x14136596,
            0xECACD76E, 0x936D39BB, 0x49039A54, 0xBB2705EC, 0x9B50AEF7, 0x57FE552B, 0x50BB66BF, 0xE4348C4A,
            0xC2595F15, 0x780541C4, 0x544C210B, 0x12F5FCBF, 0xD252D82E, 0x52D63135, 0x9E593352, 0x87F2DD3C,
            0x2DC54B69, 0x5F0EC1BE, 0x91741001, 0x89BF1366, 0x0E6C6153, 0x5BD5A1D8, 0x4BE8C9BE, 0x731FFA75,
            0xAFF4CF8E, 0xE9A99FBC, 0x6E934464, 0x0D19EA9A, 0x6316078E, 0x8566BDFD, 0xD17B20F6, 0x54F0D0DA,
            0xB8C072E8, 0x26529292, 0x82F6C12E, 0x12154925, 0xCC0ADB35, 0x7BD75503, 0xFB520C9E, 0xC8B06479,
            0x3B00ED79, 0x6E00E8AD, 0xDD17A77E, 0xFBEBBFE8, 0xBA50B329, 0x78E5759E, 0x03DC18B5, 0x3F46FF59,
            0x79DE4B0B, 0x66C9CA01, 0xA83BF0F5, 0xA892493A, 0x06CA65F8, 0x45CC4688, 0xA6936CDF, 0x7190CF12,
            0xC1C0038E, 0x04C3A292, 0x6905EBA1, 0x2B1EB359, 0x8C4A33DA, 0xF2F56CC5, 0xC1585A3D, 0x8B235094,
            0x27EE277B, 0xA1D4882A, 0xD4EAB50B, 0xAF128D1C, 0x087CE847, 0xB7487C79, 0x8F3AF9E2, 0xA264C06D,
            0xA4565403, 0x8624DF29, 0x995F27A4, 0x00316F5E, 0x943ED93F, 0x73BA905D, 0xBBF31974, 0x4ADE6FD8,
            0x651AAA92, 0xAB7E81AA, 0xB335001B, 0x4B59A11C, 0x3FFE6F9B, 0x5FF57F6C, 0xC557F14E, 0x3E1B9481,
            0x036CB652, 0x36009F0D, 0xA39E29F2, 0x8434C39B, 0x30F40E7D, 0x47478790, 0x5A151FFF, 0x1A854C43,
            0xF0E0C875, 0x1AB610AF, 0xCDDCB024, 0xCCB931C6, 0x218E6EC1, 0x1F43A719, 0x060838D4, 0x7FF32406,
            0xD083E459, 0x8CC59836, 0x1A167EDF, 0x23BDF38B, 0x99B4F269, 0x64FCC6EB, 0x2FE7407E, 0x6D85D0DC,
            0x005805A7, 0x2070B488, 0x5D482492, 0x53EB89C5, 0x1B7EA227, 0x827979A9, 0x64E3954C, 0x61F771AC,
            0x125F840C, 0x75FAB485, 0x4B10A2A8, 0x53EECF4C, 0x6A5AD34C, 0x2C162F5C, 0x5084B7EF, 0x17C56110,
            0x1A429EDA, 0x93193087, 0x664EDF6B, 0xFA6A1CCD, 0x6F862898, 0xE4C4F80F, 0x8C2A180E, 0x2BE1811E,
            0xAD455B67, 0x91F26475, 0x4B6541B7, 0x573483F0, 0x8CC51894, 0x45DB153B, 0x0E498E2A, 0x1A8330D5,
            0x4D7D17DE, 0x22E95393, 0x8BEF88B8, 0x8D37B209, 0x6FB31E86, 0xE2251F1C, 0x16E270D2, 0xA7759010,
            0x8EDC91BF, 0x979AB499, 0xEB1F21FC, 0x6556D4C2, 0xBE6A87C6, 0xC09ACAF3, 0x5435C7FE, 0x06680FFA,
            0x206CA201, 0xF65152F9, 0xD1FCBC8C, 0x7508D2BC, 0x1504A05A, 0xD957BA7F, 0x254EE66E, 0x93112C99,
            0x5903F932, 0xB479774C, 0x2BDA0B27, 0xC2DD2BCA, 0x20017C4F, 0x9F6D8CFE, 0xF2921899, 0x01780739,
            0x777EE0D7, 0x875AB060, 0xBBD9C8DB, 0xE543F219, 0x83B62DB4, 0x495C761A, 0xFD116884, 0xCC83DA53,
            0x81C68E33, 0x58DEF033, 0x4BF03CEC, 0x67B2AAEF, 0x418AA8B3, 0x3EB2C700, 0x890BCC95, 0x0D044068,
            0x3A2FD0B7, 0xEA658E7E, 0xFA5DABF6, 0x496B96FF, 0x5A1BB8B5, 0xF036BF4D, 0xC01786DC, 0x95D3E030,
            0xD382247C, 0x309FC2A0, 0x6E4519D9, 0xE43E46BD, 0x10849C84, 0xD83BAF7B, 0xC4C89BD0, 0x30FAC6B6,
            0xCE381DF0, 0x5DC1564B, 0x643FD987, 0x5AEADE4B, 0x3568B94E, 0xA7C06C42, 0xBCE2168E, 0x50485DFE,
            0xD08D9CD2, 0x37E20B09, 0xD78FD153, 0xA002A468, 0x9324857D, 0x2E9055FC, 0xC23E7A2D, 0xF3E2FBFC,
            0x2ED6000E, 0x2119AD10, 0x21807CD6, 0xBC1CDEF4, 0x323E1DA9, 0xAC2DD3D0, 0x4409CB8E, 0xEF3B3C88,
            0xCB181E86, 0xCC6F697C, 0xAA9C8510, 0xE6B86D56, 0x257B5062, 0xA09427B8, 0x16421B26, 0xE6582077,
            0xF0D41DAC, 0x70EC907C, 0xFCDA0BEB, 0xAC75CE65, 0x395FE113, 0x58F419F3, 0xE2068A8A, 0xCB173543,
            0x6BA7D361, 0x4C0CB378, 0xF8C2B18C, 0x6D19698A, 0xC6009E09, 0xD1614C13, 0x84773073, 0x15AD96FA,
            0x6507634F, 0x68FEE27C, 0xEB1C4F3C, 0x8A9BE96E, 0x397AA97C, 0xAF8E5FDC, 0xC6818F0C, 0x947C6997,
            0x86579911, 0x1B984941, 0x575D0D33, 0xAF4D9783, 0x48A25C27, 0x2A7ABA87, 0x772DCCC2, 0xD05033F3,
            0x10385B36, 0xF64EED00, 0x36C87355, 0x04BC92F1, 0xB878F31F, 0x0B5363A2, 0xBB5E3223, 0x63EF775E,
            0xE5DDBEC2, 0x4F61BFD9, 0x2A4BE8DB, 0xA4744E9F, 0x20C524CB, 0x1AD2CA34, 0x33EC5AFD, 0x091F8535,
            0x95100400, 0x614B21F9, 0x71BABD44, 0x9861B471, 0x88CCA74A, 0xDE1A032C, 0xEBF0898E, 0xC82AC524,
            0xF6E77AAF, 0x92C3BC9D, 0xC1081EE3, 0xE3EDC805, 0x6673D1C0, 0x1B31D23D, 0x9379E75E, 0x831AA4E3,
            0xBBAA0123, 0x7FE854B4, 0xA4F8ACB3, 0x0032546A, 0x03334A76, 0x5B6DE5A5, 0x62346492, 0x36BE2C4E,
            0xD6194334, 0x0E904634, 0x829E03B6, 0x14134B36, 0x0B1FA494, 0x364E39CD, 0xE9F5CB67, 0x887D00E3,
            0x820654FF, 0x3668389F, 0x9F08384F, 0x89779048, 0x31BA3AC4, 0x48B837DE, 0xA7B6FC8E, 0x12866C87,
            0x65D6DAD8, 0xCEC91AC7, 0xE7182165, 0x4540A1F8, 0xFEFF278E, 0x73A7A4C7, 0xC94F0BD7, 0xADDAAB52,
            0x13A0B9CB, 0x577DB86F, 0x51D5E986, 0x1C362501, 0x82D74049, 0xA30C9A8C, 0xB52B1F52, 0xD3DBEF21,
            0xC870D700, 0x974D74A1, 0xCCF9C892, 0xE31C823A, 0x0CE82C74, 0x9E89F1B9, 0xCEA07ED4, 0x7ED5BC6A,
            0x0DB6E280, 0xDA129111, 0x26C1EF5A, 0x808211F9, 0x3F3B09A2, 0x825AA5FD, 0x945A49ED, 0x2BE2845C,
            0x7D236B91, 0x07CC1B86, 0xD0EA76CA, 0xCB4EA842, 0x3B66DBC7, 0xAE22AFD0, 0xD2569E63, 0xB09953FF,
            0x99CA1432, 0xF9895754, 0xCC694B8D, 0x52C6FE95, 0xFD9DB058, 0x4E8F7244, 0x3E43C124, 0x8B103FCE,
            0xB032ABA0, 0x9BDB8AD2, 0x726BA838, 0x9C75DADC, 0xCD1D25F5, 0x40C66262, 0xA7AD4B12, 0x9AD04AA7,
            0x7B6E6B0C, 0x18F3CCE5, 0xC14234C0, 0xA79B7C57, 0x8861D179, 0xD76FC9E7, 0xC4F00F2D, 0x5DBC0DFF,
            0x64433531, 0x98907656, 0xC0985244, 0xC6592301, 0x2F3A6041, 0xB60E6BB1, 0x69D8381C, 0xD09504FD,
            0x6948E56E, 0xC1BB7617, 0x5E62E614, 0x73A67F08, 0x43050833, 0xAA3BBE26, 0x53DF823B, 0x21118EF4,
            0x54C018FD, 0x6365641E, 0x83019C4A, 0xBC5610CC, 0x02B743A3, 0xD42033D6, 0xB163793D, 0x76AFBB43,
            0x71D49CC2, 0x074DC420, 0x7ED3A25F, 0x90E9CCFF, 0x9F12EFEB, 0x109513C3, 0xC6F323BD, 0x08FEDD28,
            0x68EC968D, 0x3AC4A19B, 0xED5756AA, 0x24D04CC9, 0x5C79327F, 0x8923F8BC, 0x16C122A1, 0x8D1AB90B,
            0x8A673FB4, 0xF6B3CCD6, 0x74BCDC94, 0xEBC3ECFD, 0xB5E3D8B7, 0xCA44D155, 0xE3319A5B, 0x403B07E4,
            0xB75D0021, 0x135B4F65, 0x57A3A26B, 0x2F6A7DB6, 0xA6DD6580, 0xB852C828, 0x561C8CAD, 0x95C9C27F,
            0x5C3B44A6, 0x45B4F106, 0x5F301E2F, 0x9E3BA214, 0xA76C73AD, 0x13BEF086, 0xD7824942, 0x8AC38FAE,
            0xC439B0AD, 0x8BC652CF, 0x17591E3D, 0x63EDF376, 0x592BA096, 0x4CF5737E, 0x4B867B84, 0xE9077737,
            0xB34BC0CF, 0xD317FF98, 0x22BA7F4B, 0x8AB0F34F, 0x991B4C09, 0x0B51D1E0, 0xE7E1E33B, 0x3B585440,
            0x80C00756, 0xC52B61A4, 0xA01AF789, 0xDFCD7854, 0x93938416, 0xFB84F67D, 0x1054A4B8, 0x8893BA82,
            0xDAEA2B0E, 0x1CE82343, 0xD390D6BF, 0xC8701934, 0xD5F1938B, 0x9BF9B425, 0x902CFCDC, 0x92C36594,
            0x5F830AF3, 0x66360158, 0x50F92023, 0xC39CECBF, 0x155E5022, 0x2F25ED87, 0xA0E47FE8, 0x410825FE,
            0xDEF95CBD, 0x24F37AEB, 0x38D60608, 0x0504F775, 0xA0F1FF13, 0x2934D93E, 0x8D3843FB, 0x4CAB2E96,
            0xAEA8C18F, 0xA786BE64, 0x654E283C, 0xB5134201, 0x8B073D63, 0x76482429, 0x692D70AB, 0x4D1819E7,
            0xA2239A1C, 0x56FF16E1, 0xE6E54C81, 0x938A0F12, 0x773E1D48, 0x6F96CEAD, 0x35C346EB, 0x172147BD,
            0x9BE009AB, 0x07256FB5, 0x75314ABA, 0xC7F0520E, 0x9ED3304F, 0x120A5261, 0x089DDF4A, 0xA75737E7,
            0x4C8489A5, 0x6BFA91ED, 0x7E528845, 0xA6E9DDB9, 0x2D42B0C6, 0x2396C420, 0x4143124B, 0x424D1482,
            0x5CF2916C, 0xD86A1940, 0x1CD93C4C, 0x6C4559FD, 0x1EC680D9, 0xA56EA066, 0x6ECE0C59, 0x6AA15E3D,
            0x16C637B2, 0xD067B7B3, 0xD8D48566, 0xA4BDE025, 0xE43F9949, 0x85BD280B, 0xCAB3122A, 0x99A89722,
            0x394737F0, 0x77681526, 0x541FBE33, 0x63372925, 0xABDEAF97, 0xBC821CD8, 0x2FABE00C, 0xE31B6BB6,
            0x5DDA8D88, 0xDC015B99, 0x4DB13D72, 0xA30D686A, 0x754ADD70, 0x88D3A364, 0x12734F8C, 0x770D160B,
            0x678C17EE, 0x4BECC191, 0x8709BBB7, 0x901D7748, 0x91C5AFBB, 0xF4AF6C4F, 0xFD438C4B, 0x7F768E48,
            0x6ADF5B51, 0xE74F1B43, 0x7179057B, 0x5DDD3D9C, 0x6EC9B76F, 0x5368207B, 0x868306C9, 0x0C640743,
            0x3150AF6E, 0xD22542D5, 0xFC74E1C8, 0x75C33FFE, 0x590710CF, 0xE0CD7E1A, 0xDD57C543, 0x7DE3EBAF,
            0xF339BF25, 0x77DCD77A, 0x428D5D66, 0x7EB3AA4C, 0xBBD5F13E, 0x17D662A1, 0xBC9AE6CE, 0x0E2DE55C,
            0x367D2DB4, 0xD3804505, 0xEC173595, 0xF58ABE6E, 0x27F1645A, 0x3F77D9B4, 0x5E2EC340, 0x86A3494D,
            0x20C66A5D, 0x629E4AB0, 0x1E53B363, 0x670C7EA2, 0x1AB11C19, 0xEBAC923B, 0x1D7D1E03, 0xDA22EDC1,
            0xC0A76A22, 0x02909804, 0xF3F15915, 0x9A8AD499, 0x3922DCD9, 0xE6154A4D, 0x07D0FCE2, 0xC60AF318,
            0xED108E4F, 0x930D55CB, 0xA37ED862, 0xD02A26EC, 0x2BD4EFE6, 0xC5348572, 0xE3811021, 0xC759B48E,
            0x0E75F0D9, 0x5D07CF13, 0xEE2B742F, 0xCF54A458, 0xAFDF542B, 0xF0F25BC8, 0x629FE1B3, 0x3B1168FF,
            0xB1CA9A56, 0xF79C079D, 0xDF13E381, 0x7DA76287, 0x41D9809A, 0x5F031372, 0xAD637EE7, 0xB29C548B,
            0x709073A3, 0x8551AF3B, 0x889250A3, 0xFC625FC1, 0xA3E7BFA6, 0xB6C06956, 0xB0488C9A, 0x3540A2BB,
            0x367B1375, 0x8FDC3157, 0xC9F29CA7, 0xCE8562D3, 0xC4B46414, 0x63C8ECDC, 0x875A3F5D, 0xA7026C21,
            0xD307E0C2, 0x69E480FE, 0xFC250008, 0x828A75A4, 0x496496B6, 0xCCD3517F, 0x7F50EA27, 0xC69D1C03,
            0xD96AED66, 0x1E3EB3D8, 0x39A8E377, 0x693449C1, 0x2823596B, 0xE8C9A8BC, 0x90DCFCCF, 0xA45BBBB2,
            0xEE9D01F4, 0xF8C5A5D1, 0xC9CC4BEB, 0xE3745647, 0xC2582FA6, 0x813CA307, 0xA325807C, 0x765C74B6,
            0x38F7DE18, 0x3B829877, 0xFE9707A3, 0x3EFB1B5C, 0x931CFE9C, 0x586167F0, 0x42518A68, 0xAD24C03B,
            0x4158E052, 0xDEADBBD4, 0xC5E2231F, 0xB49E5627, 0x721DE491, 0xFFC08EDC, 0x74818F53, 0x27847BBB,
            0xED64D97F, 0xDE749A65, 0x04448310, 0xA359E0A6, 0xCDE12937, 0x33FDF03B, 0xBF0E4F68, 0x62141648,
            0x8E7CBC25, 0xA3315419, 0x2E104E47, 0x6ADC8804, 0xE9DA594B, 0x385F861A, 0x48E38F80, 0xA5B00C02,
            0x8D4A36B8, 0xBDEE68D8, 0x46C4FC34, 0x1D220F2B, 0xFF493D1C, 0x2FB00E3E, 0x106C30FB, 0xF7742ED7,
            0x2351DCB3, 0x87E76983, 0xCAF17B60, 0xD04762B7, 0xBAF19F6A, 0xE28CA57D, 0xCC9CBBCB, 0x4F211099,
            0x8458C35C, 0xF3124C81, 0x738A76B2, 0x2F2B8884, 0x5DAFA2B8, 0xAA38B759, 0xC58DB088, 0xA81A91D8,
            0x0D98DCB0, 0x37AB3422, 0x644C3420, 0xE92B151A, 0xC15BF39B, 0x52C532FC, 0x4E62BEC2, 0x7B01EA96,
            0xCA36A5B6, 0x18BA43F2, 0x7CC21336, 0x1DCBFB94, 0x96E5D506, 0x4F04369F, 0xEAAA04F4, 0xEFC2EDEA,
            0x300124FC, 0x9F28D681, 0x51D1DDD2, 0xDC8C458E, 0xA14BE3D8, 0x4A8FFE2C, 0x17A2B0AE, 0xE9F97F26,
            0xCC994B3F, 0x40AA2818, 0x2C095A5A, 0xD52FC0DC, 0x9FDC4830, 0x2E19173B, 0x34236B02, 0x0DEEA3D6,
            0xA3D80FBD, 0xE80E6942, 0x0A16F228, 0xF964294A, 0x1B087816, 0x3C12CE96, 0x7F865070, 0xEB46F796,
            0x007BE332, 0x091E5F4D, 0xA7FF49C3, 0x644C8DC9, 0xEF2E99D0, 0x6461CA05, 0xF9BCBBEE, 0xC79F7DD1,
            0x1CF1AC3C, 0x92018486, 0x47EE924A, 0x203AD22C, 0xB596B2F8, 0x7112BD94, 0xD98CEA43, 0x5996ABF7,
            0x14B9EBF6, 0x0AA54BF3, 0xA1324EEF, 0x36D91FAB, 0x901C736D, 0x2B70DC00, 0x456C028C, 0xA3332323,
            0x6BA7CE45, 0x6FF2C70D, 0x7B9802A6, 0xEFEBFB24, 0x2C245422, 0x711B23FB, 0xB7719196, 0xED4FAD08,
            0x3314C99C, 0xB35EF4E0, 0x473FF416, 0x0353525D, 0xD40D9311, 0x6F232765, 0xF4F68C29, 0xDD8F9691,
            0xDAA7E592, 0xEE3613B0, 0x18F0D8AA, 0xE17D72B7, 0x63BD5FC4, 0xF4FE3440, 0x8B683239, 0x4118289D,
            0x817B4C3A, 0x9D503365, 0xC21CBE33, 0x83DF7089, 0xCAC2860B, 0x419F542D, 0xC91A4127, 0xE542DCAD,
            0xBE43C5E6, 0x9359DD04, 0x590C8459, 0x6E1D143B, 0x6A8B147F, 0x9EC51B91, 0x43FF61AE, 0x84D5F832,
            0x22CC6FC1, 0xCE379CB1, 0x72529EEA, 0xC32EB93F, 0x97E6CDBE, 0xB9AF626F, 0xCA28720E, 0x9470634A,
            0x2A10BD3B, 0xC773818C, 0x35416F3A, 0x8058147C, 0xFCBF6AD9, 0x20A9A965, 0xF3AA9934, 0xAC5B1FE3,
            0xA74CDC0F, 0xD970C65C, 0x17D31D06, 0x076E36B8, 0x0F247F97, 0xD7D53337, 0xB5DA0584, 0x8A90B200,
            0x5C475007, 0xFC3B1CA8, 0x2BEE00CF, 0x01CFDAB2, 0xC187564E, 0xE169140B, 0x17959DAA, 0x87131D17,
            0x81B060CE, 0x8C929AA7, 0x78983CEF, 0xA5BF9260, 0x7C3B0C5A, 0x2695C62A, 0xDD0381AF, 0xEF019E42,
            0xC18CE383, 0xAE310017, 0x18E3DA5B, 0x96AF244B, 0xC51F6CAC, 0x25F2868E, 0x3A3684AF, 0xD245C09E,
            0xE704DD0D, 0xA2694A58, 0x93B5129A, 0x7FBB65F5, 0xD10C4F98, 0x4A06FE21, 0x31ECF84C, 0xA6C55D3B,
            0x3EF2CF2C, 0x71127311, 0x23057CDA, 0x63DEA54D, 0xA4E91F03, 0x4976DFF3, 0xFCB07429, 0x822AC7F4,
            0x97A3953D, 0xAB204E7B, 0x2D409A7F, 0x4AE61C44, 0x226BB594, 0x02128869, 0x84601981, 0xEFE0907C,
            0x1BA578D0, 0x46D15992, 0x52B2647E, 0xFFDE1366, 0xD085D1ED, 0x078B7A7B, 0x0027CEC2, 0x6CC58107,
            0x4A759A66, 0x1026428D, 0xBD4A7DA5, 0x4383D929, 0x80F6557E, 0xA3C4725E, 0xE5C729E2, 0x6E27F0AA,
            0x5DF24D3C, 0x7745AF01, 0xDB1B1620, 0x1562E8E5, 0xECDADDBC, 0xF67481C3, 0xC788E1F8, 0xDDDED3E5,
            0x1DC89A94, 0xE19023E8, 0xF540D07C, 0x2CD3FB5E, 0xDFD46BE3, 0xD27E185F, 0x12B15D65, 0x6F8F277F,
            0xCA792E6B, 0xB110C4E6, 0x5780DC5A, 0xD184BAA7, 0x71B46E57, 0xBFF581AB, 0xA6A33F46, 0x1A2285FF,
            0x2EF85BD8, 0x5F63C228, 0x2CA32E81, 0x7FD97F89, 0x82B42419, 0x0DB8D8CF, 0xD8313D12, 0xC52D901B,
            0xFEF4D388, 0x0689BE7B, 0xC8231CC6, 0xCAB596EF, 0x1DF9DBF3, 0x6B88A043, 0x3193C1B1, 0x4C40DACE,
            0x9946D092, 0xED74CF37, 0x7F9372CE, 0x6CD8F7E0, 0x2021E646, 0xD765397D, 0x9815E482, 0x6ED6B707,
            0x7AA8A9D5, 0x23C92B04, 0x5F0C65D4, 0x05869D70, 0x18E3160F, 0x7EE6A546, 0x07408138, 0x7946A5A8,
            0xABBE492C, 0x11A2C035, 0x026B9907, 0xF240B34E, 0x67F5965D, 0x20E510ED, 0x04CAD23A, 0xFBCD4420,
            0xB03707AA, 0xF3866188, 0x4BC132AA, 0x68C8E26B, 0x5160791E, 0x93094BBB, 0x3D273F35, 0x4CE13F9E,
            0xFADE4031, 0x25E6835E, 0x0632B4AD, 0x1CBF9041, 0xB47E8C7B, 0xE59938E3, 0x3A02E121, 0x0278CFBB,
            0x6EB36217, 0xDC73B865, 0x9834D37C, 0x98346151, 0xC98BA0BE, 0x04EA9955, 0x9ECB61A5, 0x6FA388D7,
            0x62774AA8, 0xF66E5560, 0x756C172E, 0x83032428, 0x74CC0717, 0xB0404779, 0xC06C6439, 0xD999872F,
            0x4F6AA7CC, 0xEF5BF323, 0x73B611A6, 0x8D15ACD9, 0xEE63093C, 0x65139515, 0x62E064E2, 0x6585CCB0,
            0x00374E2C, 0x4C051BD1, 0x1BB3395C, 0x4FD47C92, 0xD6355A6F, 0x2E9C71AA, 0xC81B2690, 0x70A9D731,
            0xC59CA098, 0x1C846693, 0xD9C3CB51, 0x3B13181F, 0xB507EF7D, 0xA8B56EB0, 0xF21363E5, 0xBF08D31B,
            0x4CAC32BE, 0x21154D0A, 0x9D665B63, 0xBA99B097, 0x5341BAFD, 0x4EE8E723, 0xA787D5F7, 0xDBF5C0EA,
            0x0EBF46F4, 0x09B25D28, 0xE4131D44, 0x4B90071B, 0xF745AED9, 0xA52A761D, 0x68D86708, 0xFA384AAB,
            0xBDED7EB6, 0x383087B4, 0xCCCACAAF, 0xB94B63F3, 0x68306126, 0x99B6BE4C, 0x445D4BE9, 0x9515D49F,
            0xF6885F74, 0x748C6ADD, 0x9329CE2C, 0xD2B5F996, 0xEE56DBBA, 0xD22FCFD6, 0x901B1E63, 0xEBD67363,
            0xB8D37C1A, 0x398C99DB, 0xA8B53880, 0xCECD0B4E, 0xBB3E88FD, 0x01F7ACEB, 0x210DD8D8, 0x33D5972B,
            0xE65CBFEF, 0x7142C1F8, 0xC43CD3F8, 0xAB4BCA6E, 0xEA7ACB43, 0x57814F84, 0xC0D2AF2E, 0x66D5F782,
            0x5B67A00D, 0x2D62ADEB, 0x7532FFF0, 0x2A6460C9, 0x24DD2DBB, 0x93521D61, 0xE541390C, 0x14D68616,
            0xB33F397E, 0xF5426903, 0xDE28870D, 0x7531C32C, 0x2484017C, 0x1CD73B2F, 0x64DF0EE8, 0xED364533,
            0xE75BE5BE, 0x75E3AEF6, 0x48D4167A, 0x27DF1F2B, 0x10B47961, 0xE27AD07C, 0x64B972F4, 0xC56FF7C0,
            0xC85E1599, 0x46C7746F, 0xE97796D4, 0x856A8F91, 0x5E73BCDD, 0x8073B658, 0xF482F1A5, 0xCBB3D252,
            0x91631BB3, 0x451001B3, 0x12444B71, 0x46CA706A, 0x31C8CC65, 0x9C0D4236, 0xA4633D8E, 0x14D3A39C,
            0xCFAA9BF1, 0x0A8976C7, 0x3CBCFDBC, 0x08DB2831, 0x19A86D72, 0xB4DF84D2, 0x6D886705, 0x2CD59B36,
            0x9D2BCCC9, 0xD070F0AC, 0x08C325E7, 0x7D1C2081, 0x3BBEDB66, 0x9003415B, 0x87B4047F, 0xF1B77DA4,
            0x56429E8B, 0xB408EE53, 0x85C39E4B, 0x0AB71974, 0xF53EB4AE, 0xA0BFF1E4, 0x89556719, 0xDF52FCB4,
            0x1D5C6ECD, 0xD7BFE757, 0x60C23EF6, 0xE8B5FFAE, 0x49F13C53, 0x9CCCE8C7, 0x2A479485, 0x2F81B982,
            0x81889BA8, 0xB4457901, 0x124E4DB4, 0xDEBA5405, 0xAD84108B, 0x901F137A, 0xB3833472, 0x494FB19D,
            0x4C42A18E, 0x0312C45F, 0x0B605247, 0xAAFE50A7, 0xDC80C5D7, 0xD2A1E703, 0x7BE4A0D9, 0x9D7E4FC6,
            0x75B69FC7, 0x96A57059, 0x17CA2E17, 0xF003340B, 0x62AC5948, 0xA32A87C1, 0xB4B6DCA0, 0x839DBF81,
            0x62F33479, 0xDC3291F1, 0x98D3D480, 0x9FA55F64, 0x2DBB6AAD, 0x3F829517, 0x31EBE547, 0x324C4269,
            0xC6588D31, 0x0C3841DC, 0x8E68FD06, 0x5FEDB702, 0x567D7ECA, 0x9F57413D, 0x9AC0249F, 0x946FA9CD,
            0xE0C65989, 0xDE180B85, 0x7831A9DF, 0x124F2E41, 0x4DEF5391, 0xBEE697E2, 0x45B39F91, 0xC32948DE,
            0xB399E876, 0x118F362C, 0x72D2DFEB, 0xDD3F5F7A, 0x81D3F49F, 0x6FF612A8, 0xCFC93B3D, 0x611DE543,
            0xFAFE1C81, 0xDBB3CF10, 0x10A6EEA2, 0x65085099, 0x18A940A2, 0x7A45A99D, 0x1F3AC4B4, 0x4C8F7595,
            0x18D84DF7, 0x8B63CCFE, 0x274B22BF, 0x1931D2B0, 0x5B71E5F1, 0xE1589364, 0x8488F4D7, 0x8815A481,
            0x76C8E1A7, 0x503F7CBF, 0xB7B8E153, 0x899984E3, 0x552EC811, 0xFF76E5B3, 0x0C7EC59A, 0x797388B4,
            0xDF26C2EB, 0x0F6C7D5C, 0x5CBBEB9A, 0x1C34ABAF, 0x889CAC67, 0xB5859441, 0x5BF6FD78, 0x621CAC5C,
            0x5FC9A7C0, 0x9E83809C, 0x85AB3618, 0x2F0E4A65, 0xDBE0AF4F, 0x7E3366EA, 0xAC7E26EB, 0x2C37853A,
            0x222D0392, 0x2196DD19, 0x09E6DC66, 0x601F1810, 0x9B32B141, 0xF17FE779, 0xD6CB0673, 0xF48A0BD2,
            0xDEF2DABE, 0x3C4146B8, 0xD29BAFE3, 0x1C965DBA, 0x7F869DDA, 0xA8C5197D, 0x68C9CD4D, 0xDC6B414F,
            0x2081019C, 0xD452E285, 0x547A7C2C, 0x876CEB01, 0xF857F9F5, 0x34097CAD, 0x3A10232C, 0x0E53E96E,
            0x6400C0FF, 0x5D2D2492, 0xD69BBB29, 0x923FE3AA, 0xBEA7CD59, 0xD1A7DFBB, 0xD92BE1BC, 0x40585B86,
            0x3E7C584B, 0x426405F9, 0xDFFB17EB, 0xD7CD9A0B, 0x778935A6, 0x99CF0DFB, 0xBBD2B9D8, 0x7F986108,
            0xEA4D1FB9, 0x64FFACB2, 0x86055F58, 0x2CB19854, 0xBC14F29E, 0x950A5638, 0x388AEB89, 0xBB30756F,
            0x08580A28, 0xAFFFE88B, 0xD8A60DF9, 0x98A13E4B, 0x6B891302, 0xBA1C09CD, 0x5EB353E7, 0xB1A27F13,
            0xBC934A6A, 0x510DDAF0, 0x1C0DC403, 0x5E3E9BCF, 0xFF248B69, 0x1E124CA4, 0xF108CCE0, 0x2D72F8FA,
            0xC0AE37D3, 0xA678E1A2, 0xD9CA77BE, 0x35604AF6, 0x0501D12D, 0x8D5462AC, 0x62743657, 0xC54BD3BC,
            0x90B085F4, 0x0B6C6412, 0xBF93913D, 0x0CE15685, 0x83A1295A, 0xACA08B5E, 0x09372AE9, 0xDB0EC7AC,
            0x1F4B7D90, 0x92DA6A46, 0x27C493A8, 0x4C10ED5F, 0xEB7853DB, 0x16D9AC26, 0x52DDADC9, 0x1BD8F638,
            0x7C655115, 0x5D4951EF, 0xE6285F60, 0xDDB3970F, 0x2F890DA5, 0x3A7C941F, 0xB8558233, 0x1C25F892,
            0x43862619, 0x935CB5F3, 0xE693C4A4, 0xADE78282, 0x785FF0DA, 0x00273182, 0xC3CF695C, 0x2E74396D,
            0x76CB2C26, 0xD3BD13E7, 0x5EE03FD9, 0x93E1DD62, 0x89C50576, 0xB5BE3DDE, 0x59E1BAE0, 0xA0B6F1A6,
            0x34F5139A, 0x35980990, 0x56041F5B, 0x777ED028, 0xCC73101C, 0xB39382C7, 0x4D9FD6CA, 0x435F67D4,
            0xE2D5F574, 0x5190EE41, 0x2746C985, 0x3CE37B9D, 0xFA3B3E83, 0x9FB1D5F3, 0x2F5A4DF6, 0x8D2582BD,
            0x218C0D9B, 0x59798556, 0x756F5314, 0xAB9119D5, 0x78E66F9C, 0x154781C9, 0x7FA7C351, 0x788C79F5,
            0x8803AB98, 0x117F18D8, 0xE2F98542, 0x1B479942, 0x4A312819, 0x10E5740C, 0x0FC8EC6A, 0xA5756250,
            0x83BE15BA, 0xC6C5C43C, 0x66411B2C, 0xF5329EAF, 0x1FE4E8BD, 0x48615DDA, 0x0F7A3EDA, 0xD424A80E,
            0x3A7B5B55, 0x390B9045, 0xFE12FA7B, 0x2B078989, 0x62FA91B8, 0x92E87DF6, 0xDD1505EB, 0xDEB37330,
            0x7325F023, 0x90D0AA4A, 0x9B9CA968, 0x7C6CC750, 0x58D4C3A4, 0x405DBF97, 0x2B51FBB9, 0xD6B02CDE,
            0xDF4DFBD1, 0x4F3A0E73, 0xD4825D66, 0x26A4FC75, 0xAD131335, 0xE3CA0363, 0x3A6E0088, 0x966E7739,
            0x986E0E30, 0x941D2FC7, 0x0A35A133, 0x3C76306E, 0xE10F1766, 0x8FCBE819, 0xE5E16F33, 0xE35BAC0F,
            0xD04DD486, 0x8380973B, 0x03F31EAC, 0x3CFFDA33, 0xF408AE93, 0xE244F734, 0xDE0FDF34, 0xD2E34B7A,
            0x312EB95F, 0x61B1E396, 0x42B2A07E, 0x497F4C3A, 0xDBC93F68, 0x1F44FBD8, 0x0A6E0676, 0x1366D0C6,
            0x767BE9EE, 0xA2AFC3A9, 0x0836A903, 0x53E089B6, 0x458B00D5, 0x08513F75, 0x52BAC24C, 0x50FBF7AC,
            0xCC4B5655, 0x2AC0C9D4, 0x069D69FC, 0x906A28E8, 0x4DF24DFE, 0x714AE384, 0xC95AE521, 0x2E7F26B7,
            0x670699F8, 0xAEBECE1D, 0x48FC62EB, 0x44B6D116, 0xBF182D18, 0x90BF18D8, 0xCBFFF656, 0x5226D7DA,
            0x9EB506CD, 0x945D34FF, 0x78D1DF2E, 0xAA9DAE5C, 0xDD3C59EE, 0x4025DAFE, 0xA083F536, 0xDEE1A1F1,
            0x9A127871, 0x64F680BC, 0x061A7F34, 0x8D6591BC, 0xB76EFAE6, 0xA23EA861, 0x1F8DC864, 0xC68C8398,
            0x3B894071, 0xDD5F9D0F, 0x4742BF3A, 0x86732378, 0x289950BB, 0xBCCD5631, 0xDB3E3E36, 0x8435DF4C,
            0xE53692A9, 0x398CD11E, 0x3B10FA11, 0x1601516A, 0x89F18536, 0x79249640, 0x0A400AA5, 0x59DA1AE5,
            0x95D46F44, 0x66477A96, 0x450B165B, 0x4DC6886D, 0xD031A972, 0x0523ED78, 0xD534C026, 0xD03E1B02,
            0x2D0A6F82, 0xB00913D4, 0xC6742D0E, 0xF9D763FE, 0xB5ED5936, 0x20E03CAC, 0x92254BA4, 0x8F809988,
            0xD3F8FC69, 0xA9B74DA1, 0x218DFD63, 0x7D606891, 0x316562EF, 0x129079E4, 0x7B12DBFD, 0x5EFC0392,
            0xC925B822, 0x64DC2AE1, 0xFD8556CD, 0x8D824480, 0xE2E44714, 0x48D200E7, 0x563BF22B, 0x54A63AA4,
            0x5F7BB881, 0x898C245D, 0xE6BF47FF, 0x9C032480, 0x599ED114, 0xC9C8DA50, 0x1F0044F3, 0x5EC6BD98,
            0x2D037B92, 0xB2256902, 0x38A6D809, 0xA01A0AAD, 0x89EE9796, 0x483E3E22, 0x6E6E6537, 0x4CF02407,
            0x1AAF5E31, 0x8344053E, 0xCEFCBFED, 0x74B0450A, 0x0FE858B0, 0xEF416D8D, 0xA95AEC43, 0xDC4808BC,
            0xB3666B1D, 0x461D61EA, 0x5E391528, 0x9CB4F214, 0x47FE2E57, 0x31493682, 0x4A539E98, 0xEDB89B21,
            0xEF44A9FF, 0x9DABB1C0, 0x0ED1C5A4, 0xDD987BFB, 0x1A9417DE, 0x2A02573F, 0x24E840DF, 0xB5FAECAE,
            0xFFD8CB39, 0x390C71C5, 0xE7EA7AC9, 0x583DC820, 0x11A13AD4, 0xA9B7FB69, 0x072959DF, 0x868CB6C2,
            0x4499FDDE, 0x126C49EC, 0x6D73460C, 0xF3616D73, 0xC92F7C76, 0x4E658440, 0xFD2E1B15, 0x5CBA5934,
            0x72593168, 0x571A1174, 0x234FF70E, 0xAEF2FB52, 0x0BECB06A, 0xC04D5803, 0xD279683A, 0x32D5ABB3,
            0xE59BA9A0, 0xED79F6C8, 0x127A070A, 0x0022A2D5, 0xC1DA6C81, 0xAABF0F8C, 0x7E92B4EB, 0x7D7B2965,
            0xBBBA8AFD, 0xAA78375F, 0x86374983, 0x3367BD40, 0x5AA9F842, 0xD75C7102, 0x80930385, 0xCF36EE76,
            0xF25F5799, 0xA628823C, 0xCA77CF49, 0xBF3CDE46, 0x8E2309DC, 0x5D7C1D2F, 0x0B9C773B, 0xCC12193D,
            0xBE325326, 0xD97E8633, 0x410D4E0F, 0x3337CDC8, 0x2D373073, 0x8B759BD2, 0xC4302D47, 0x9C5D9CF8,
            0x120DF640, 0x4F4F469B, 0x01AFE948, 0x808D34F7, 0x460A7C91, 0x06FA84F0, 0x603CF1D4, 0x023CC3B7,
            0x3111E1C2, 0x078139C3, 0x8E8FF124, 0xC7D99F4C, 0x61D6D9C7, 0xD66DE19B, 0x585038A4, 0x81E217F8,
            0x6633C59C, 0x65F2B120, 0xB3803A06, 0xD9937E72, 0x5E7D34C4, 0xC00EC37F, 0x9B7CEDCC, 0x76F4707D,
            0xDBCC0763, 0x9D727200, 0x489E9E0C, 0x79DE2051, 0xCC015C25, 0x24BF2EF1, 0x027C0F80, 0x721974DD,
            0xCDBDFC39, 0xB1F2CC78, 0xFD4A4636, 0xE2A48265, 0x5A442AB0, 0xA55FDAED, 0xAE03A420, 0x2AF07CA7,
            0x8672F426, 0x614F110D, 0x33A3FBB5, 0xD08045D9, 0xE0CEA59F, 0x9A6A2844, 0xBC7C9EA0, 0x6DAA7C56,
            0xC45C2A37, 0x69F885E6, 0xFE1EE80D, 0x106DBCD5, 0xEB76E3A3, 0xA4DFADBD, 0xF51B7599, 0x8C3FFA98,
            0xC5FBCE0E, 0xF1815889, 0x67A6E9CF, 0xB4D1A870, 0xD1A80924, 0x71CD4C0F, 0x26C8B6E2, 0x490B4E10,
            0xD20450E9, 0x3D035F95, 0x089AB68E, 0xBD564B11, 0x7923200A, 0x8520960A, 0xA0AA5481, 0x20033B67,
            0xB3226D17, 0x6DE6B361, 0x2C6112AD, 0x8E670EA5, 0x0FED844B, 0xB4B7F4A4, 0x883ECC91, 0x1549996C,
            0xAC36C1ED, 0x3F71915D, 0x73408CF3, 0x717AA85E, 0x7B354BEC, 0x267F10A6, 0x64E824E2, 0xA9EA4206,
            0xB54EB363, 0x39CF0FAD, 0xEF565DD7, 0x0D0CF0B4, 0x8D813495, 0x209895D7, 0x62E7C447, 0x8C82C72E,
            0xAF1E2164, 0xC1F9F59B, 0x1C0DF09A, 0x6007BD3B, 0x68A56C98, 0x378464E6, 0x595BFF98, 0x390CF854,
            0xA2540E0B, 0x2CFD4CE0, 0x9EC2B3BE, 0x2800ABD1, 0xB6251BD6, 0x71E6C11E, 0xD4E6348D, 0xE3BA7600,
            0x24D0DDA7, 0x0152FEF8, 0xBFF9883F, 0x62FB2260, 0xE0B67E47, 0xC3A66B62, 0xBBE1E5EB, 0x93D8012B,
            0x57B42275, 0x9FB1BBA6, 0xCA69FEA2, 0x4EC8D379, 0x24F686EA, 0x2EEFE2BE, 0x978C1BB3, 0xDB6992DD,
            0xADD292FB, 0x6810B1C9, 0x9EEA4BD3, 0x2D8AD033, 0x0A08047C, 0x89715BC9, 0x3AE4B3EE, 0x991EF3F3,
            0x07FB0932, 0x4057341E, 0x5AC0E3C5, 0x09B8F1B8, 0x38C9FA5D, 0xD6A9BFF8, 0xCA113F71, 0xB295B907,
            0x0B5A45CC, 0x9B5809CA, 0x0FC6E0E7, 0x55125573, 0x4E8104F1, 0x949B9520, 0x76F7D375, 0x6F7D3D42,
            0x689087CA, 0x785E115F, 0xF8CCFEC1, 0xFF6AE094, 0xF39395F7, 0xEBFBB8EF, 0x88183A57, 0x07E51BE0,
            0x1D7D1C79, 0x2D76E072, 0xDB356AC9, 0x14ADCC25, 0xD5A63705, 0x71204CC1, 0x7C39B0A4, 0x9F8D369C,
            0xE33253ED, 0xD19B954B, 0xA88DE9C1, 0x3CAA6F57, 0x00A38CA0, 0x22E21A1D, 0x87ABA2CC, 0x9169508A,
            0xC682E56C, 0x713E78EA, 0x650BB4C4, 0x6B828C04, 0x19EFDCB1, 0x7F920366, 0x151304D8, 0x3178D4DB,
            0xCAD0130E, 0xAEB423C9, 0xF3E837C9, 0x64DF48A9, 0x49A7A79D, 0xE69D33F1, 0x18D92CB3, 0x17E58F80,
            0x8DDE09A5, 0x007EAAE6, 0x1E9B3F0D, 0x32E2E4E2, 0x1394997B, 0x7F569E4B, 0xD0961C3E, 0x5E644C0B,
            0xBEB93008, 0xB202F8D4, 0xC7C61966, 0x54D32B84, 0x2BC6DD44, 0xF0B2702F, 0x43D03B35, 0x71BC92FA,
            0xEC8AF22E, 0x4E0AC223, 0x12D1F40B, 0x3C624C9B, 0x9B4F011A, 0x2D54BC14, 0x71DA554C, 0xB2165A05,
            0xA35CAA04, 0x4EC1944F, 0xD504F094, 0x836733CB, 0xD352CB59, 0xAF2D4E82, 0x35214B04, 0x89DF0E65,
            0xCDAF3FA9, 0x9F12865C, 0xC3330FD7, 0x745992E1, 0x07E5FDE1, 0x8B59B02B, 0xD64C8EDC, 0x1A219C23,
            0x080A1053, 0xC5CBF560, 0x5DF25A5D, 0x40C44B7B, 0x57F248EF, 0x52E23CA8, 0xD9028383, 0xA4E90C50,
            0xB1BC4CC8, 0x3FF99549, 0xC3748479, 0x833FDCEE, 0x893B5B10, 0xF533DC96, 0x85811FD3, 0x33B113AC,
            0xEFA8541D, 0xFFF150DA, 0xEF1B9375, 0xC022B21A, 0xB2CE4F31, 0x10DFC831, 0xFD44332F, 0x4C3D07B8,
            0x79ADCCA0, 0x7D223CC4, 0xE2844C29, 0xD815BB66, 0x2888C5B7, 0x9491AB72, 0xE64FEF12, 0xAA83EE9C,
            0x32CA75BD, 0xE29E836C, 0x0811F5A9, 0x4C2BBE3A, 0x6160AE65, 0x27BC4DE9, 0x092D560B, 0x8F1BACB0,
            0x731964A7, 0xA02A575A, 0x1B3EDCE7, 0x9042528C, 0x1C0B6059, 0xC9C0455F, 0xD351680D, 0x13D6A100,
            0xC9E2A506, 0xA14DA6DD, 0xDFA49373, 0xD2CE3FD5, 0xD09F8708, 0xA8725A33, 0x4D6DF6C8, 0xDF4ED16C,
            0xBB1DB9AA, 0xE221FFE7, 0x9F53999F, 0x0B8FEF0B, 0x79AA13A2, 0x66F4B7C0, 0xE4D9C7E9, 0x11C8B6C1,
            0x97F68AE3, 0xB3D888CD, 0x70985245, 0x289FF6DA, 0x15E47355, 0xB4780E56, 0x7AF775BA, 0x89AA0DF3,
            0xCC2114F3, 0x1A22A77E, 0x3C2E84F2, 0x79B96C48, 0xE7C5A504, 0x11680C50, 0x5267B4D8, 0x9A14D355,
            0xDD493CF8, 0x22D093B5, 0xADA0D5A1, 0x6E5D8E89, 0xCF3369C2, 0xFEE5639F, 0xC1594C1B, 0xA8A0C3C6,
            0xA143488F, 0xF710FFF0, 0x0D5CCED5, 0x44C5D518, 0xED644AD7, 0xD6A13BDC, 0x4E85D04C, 0x42A12200,
            0x2ECACC0E, 0xC1DE42CA, 0x107541CD, 0xE3B00173, 0x5AA7219C, 0x9D5BF6C3, 0x315B4093, 0x75513FA4,
            0x4CBA5976, 0xF77A744D, 0xDE20977B, 0xFEAB2F7B, 0x07DB2E5E, 0xAEC67092, 0xAB6178F1, 0x57688D20,
            0x16A19B05, 0xA58FF8B1, 0x28841A44, 0xC4EC43E5, 0xE6B21D1C, 0xC5E77240, 0x581255F3, 0xD4F84BF7,
            0xBE4AAB2A, 0x4919AFB8, 0x79FEA015, 0xA96FDE57, 0xB3B8D990, 0x88D963EE, 0x40827DE1, 0xB2E15D3C,
            0x73325958, 0x6CAEC6E3, 0xE1022582, 0x32158525, 0xAC9475A1, 0x090D2BC9, 0x27829947, 0x08F338B8,
            0x0D396ED6, 0xDA2A82EE, 0x1B28AC0C, 0x5F370A8E, 0x0BB174E4, 0x61BE912F, 0xB87C6489, 0x4C43CADF,
            0xAFB6B6A2, 0x753161A6, 0x6CD55998, 0x7B1AE9A1, 0xDDDC79CA, 0xD87E4DFF, 0x2D635216, 0xA2B359C9,
            0x37A8B49D, 0xCA062BD0, 0x0DB8A59F, 0x3663715F, 0x30B91F29, 0x444EC3B5, 0x4082E8AB, 0xF6CED0BE,
            0x027E4136, 0x63D09570, 0x36B1A5D9, 0x6EB66BAA, 0x5624A308, 0x41FDE1E8, 0x6FCBC17D, 0xE9E07FEC,
            0x15D2818E, 0xF4BC8690, 0x351250E9, 0xEBACC8C6, 0x56A36221, 0xFE624AFB, 0xE1AC4614, 0x61BB95C5,
            0xBC79AA10, 0xFD187F81, 0xAB8B8BE8, 0x417E718E, 0x7F22CCAB, 0xF3A75F59, 0x057B19C3, 0x6D0EA22C,
            0x83E35461, 0xE340FB4D, 0xFC1C590B, 0xE9A8768F, 0x12122FA8, 0x6E490583, 0x68150C60, 0x3D69941E,
            0x7456BA22, 0x70C04723, 0x804C353C, 0x1C531ED1, 0xA0849806, 0xD0AE5E9E, 0xD614EF23, 0xCD9752D0,
            0xEF0B664D, 0x94A8AAFE, 0xDD551CF4, 0xF44161E5, 0x379DAA1F, 0x6C0C614D, 0x428B0F3B, 0x8EC91AC2,
            0x94EF2EE8, 0xDA300CC6, 0x980E6A8D, 0x4F941078, 0xF65EE0B5, 0x1F16E545, 0x1ACEA75A, 0x36057D8D,
            0x41079B07, 0xB17A09D6, 0xA3901FF3, 0x3B0762BB, 0x5D7C8E2D, 0x77D6536D, 0x7310A79E, 0x01AB3194,
            0xC59B69DC, 0xD664047A, 0xF9649029, 0x0271A041, 0x372B496E, 0x8985831A, 0x013AB7B1, 0x9D43198A,
            0x15227966, 0x0FD18C51, 0x90FBADE3, 0x136672AD, 0x70FA9B59, 0x0E115426, 0xFA176219, 0x7BA330F2,
            0xADA602EB, 0xD74F0400, 0x61BA6702, 0x3EEE1D13, 0xBD0FB20A, 0xB8F3ADB0, 0xC1F8342E, 0x50189C57,
            0x7DB0E838, 0x52BE4494, 0xDE20F44C, 0xEAF5F703, 0xC2ACB890, 0x1F4222D7, 0x5BCA693F, 0x263EA4FE,
            0x644DD072, 0x23BE4DD6, 0xAE3306EC, 0x7357274E, 0x24772EF2, 0x248B8614, 0x60C8FDBE, 0x0F718103,
            0xCB56806C, 0x6F1BF3A4, 0x226791A8, 0x0278C6C6, 0x12AA3624, 0x0A7E085D, 0x0C50294D, 0x7B1E53E7,
            0x625A080D, 0x11FE10E1, 0xF0F82B7A, 0xE3839235, 0xDA3B277D, 0x2154E27B, 0x1CAED9EA, 0x4867C8C6,
            0xA2687810, 0xC375996E, 0xFAA260FA, 0xAC41BC4A, 0xDBF779EA, 0x3B136399, 0xCE2FFADA, 0x77F741F5,
            0x76D53EF2, 0x15CFE0A3, 0x6E6CDA88, 0x9DA58BBB, 0xA837E6A9, 0xC88A8808, 0xBC2CC999, 0xB32853D7,
            0x77690B21, 0x1B08AD23, 0x7E28DCAF, 0xF5B4BBAC, 0x31110461, 0x2D367E33, 0x8C9427CE, 0x7C9DDB01,
            0x0D5958AE, 0x2F799681, 0x3721BA03, 0x4E175FB0, 0xDFFA8F92, 0xFDAAD29D, 0x9F4A9496, 0x8111D253,
            0x95DF31C0, 0x4F254E23, 0x83262F3B, 0x0FFC1EB8, 0x1D127029, 0xC56A9B4B, 0xA3B2946C, 0x60326556,
            0x7D2EDFDE, 0xD4C3D67B, 0x4E7A3419, 0x8029D87D, 0xB2D9414A, 0x48A8967B, 0x501122B8, 0x85482C4C,
            0x00C4D931, 0xCD666FBF, 0xDD9CC38B, 0x597885AB, 0x6CD1AD5E, 0x4949413F, 0x5CC16A3A, 0x0FEDD792,
            0x195DCEB3, 0x9749075B, 0xBF5151E5, 0x27C92D57, 0x73DB3B55, 0xB7D40524, 0xD855C821, 0x81F13277,
            0xD6B65701, 0x6F7FE0E1, 0xD50E486D, 0x29C75970, 0x36E37FE8, 0xDAB1717B, 0x6E787A0F, 0x6A5AFCFC,
            0x19BC1667, 0x66537836, 0xB33AA4DE, 0xA088D1C0, 0x4DB9404D, 0x4F781074, 0x96B969AD, 0x05CC3272,
            0x46327850, 0x8F08858A, 0xCEEA90A2, 0x018DCF43, 0xC178A86D, 0x3A9E4254, 0x363EA306, 0xE1B6E0D2,
            0x8BD09B71, 0xA34570D1, 0xB571E063, 0xB113D84F, 0x4736D861, 0xEF97DA89, 0xB3F48FA7, 0x03549C43,
            0xEBC43DF8, 0x2721CEDC, 0xEC79B8F5, 0x54832EF7, 0xE115AE41, 0xB97B2314, 0x60EAFA99, 0xC30F59C6,
            0x432B3125, 0xA294E6E2, 0x979FB1BF, 0xD721BB93, 0xA3F7C8E1, 0x8BF3CF26, 0xB060269D, 0x1C026024,
            0x2FB2865C, 0xF2AAA6B6, 0xBDD58F92, 0x632AC4CA, 0x566578BE, 0xE9F6F091, 0x9D22536B, 0xCABFF1C2,
            0x4EACA869, 0xD4B029C7, 0x5B3352D5, 0xBCF1A4FE, 0xF4CB130B, 0x215B768A, 0x37801588, 0xEB6EBF0E,
            0x702272E0, 0xEA47BDD6, 0xF01F8F55, 0x5F7BDEBD, 0x7E37FA6C, 0x2F44161D, 0xBBA3BA6F, 0xF3CDCF39,
            0xE6CF7F21, 0x24BCBC73, 0x60D038D2, 0x6FB14C4A, 0x580D2FFB, 0x473B040A, 0x3964F4ED, 0xBFF491BE,
            0xCF50FBDA, 0x59F49582, 0xF96822D1, 0xAC075449, 0xD4D976ED, 0xF0C5651B, 0xE78C1733, 0xFFB41895,
            0x4B5CC2ED, 0xBC0C29F3, 0x5FA189A2, 0xB64DB045, 0xC7DAA483, 0x80E6CDDF, 0x41055D5A, 0xCCB2E822,
            0xBD5A1310, 0x48C63D92, 0x17CF7678, 0xC4098B95, 0xBF3125E8, 0xE9B6EF63, 0x1E1C40EB, 0xD254D63D,
            0x45BCB707, 0x6BF5AACE, 0xE8B951F1, 0xD1437D18, 0x9EDB52B9, 0x26C69B4E, 0x61E567DF, 0x3FBDF5F6,
            0x83375D52, 0x248967E1, 0xBE702285, 0x9DCFA0B8, 0x7016142A, 0x732F68E8, 0x07475720, 0xBE66E7A3,
            0x78432387, 0x6144FE35, 0x00064F33, 0x6B5AE611, 0x6F56DF2D, 0x4C4ECAC3, 0x40906B70, 0xA0B9114E,
            0xEEE5AFAE, 0xA3DD9E21, 0x9985EC47, 0xAD2517C2, 0x9BD58B5E, 0x85E669F6, 0x2FB1EDBF, 0xD88262BD,
            0xC96E045A, 0x39A69CB1, 0xE3E74EB9, 0x1500CDE7, 0x1063EBAC, 0x44F46205, 0xAEBAD9AF, 0x0CF2181F,
            0x98E9DC59, 0xBBC7F580, 0xF6C59C55, 0x3934962E, 0x77BFC29B, 0x35996827, 0xFA571AA6, 0x8F1FAA7E,
            0xB974B1DD, 0x46DF2A6F, 0xF989344A, 0xCA0D8F72, 0xC89C78F9, 0xF6CC9244, 0xA0510EB9, 0x4A861E2F,
            0x420E6EAB, 0xB8431A37, 0x44477C88, 0x82F09A15, 0x59568E50, 0x7AAE9A0E, 0xFBC9E271, 0xFB513FB7,
            0x71B5C865, 0x2C8B32BF, 0xBA6C679A, 0x3740EA3A, 0x4A39B492, 0x526D06AA, 0x06A5C421, 0x60B40FBE,
            0xD961225B, 0xEB5E3F1A, 0x2BF2445B, 0x4B77DB88, 0x4DFEFEEE, 0xA8779E63, 0x07B762AD, 0x0097A561,
            0xA11BFE69, 0x5FDF87A8, 0xD5D8808D, 0x4E289D67, 0xA30B4AFC, 0xCABA04C8, 0x3AC5AFDA, 0x16106796,
            0x80D2EAA5, 0x20E99781, 0xEDF10CB5, 0x5175FF1C, 0x5FEEADFC, 0x702590CB, 0xBF96EE3C, 0x522C2B14,
            0x2944D201, 0x1957ED80, 0xF242D172, 0xEF3C0D0E, 0x92A77AB8, 0x61FB923F, 0xD4237807, 0x16BF3FA7,
            0x5CDA30EA, 0x4D4B10D3, 0xFCA15E1F, 0xE07DE4B6, 0x6315AD48, 0xFA895F60, 0xE6DBCAAE, 0xA36318B4,
            0xE7A475E9, 0x280A103D, 0xE32A4D3D, 0x363C6D77, 0xE587C322, 0x31931A2B, 0x98CD6193, 0xE0BEEE3A,
            0xC1794F2A, 0x1981E67F, 0x9934B07F, 0xB433E68D, 0xB4D2F904, 0x80CF0141, 0xE576BA99, 0x5A67F855,
            0x2B7640F9, 0x21A05C5E, 0xECCAC2B7, 0x9325432C, 0xB7FEE13F, 0x02E5CC66, 0x57B2402F, 0x86D77AC5,
            0x75E95245, 0xDD3E005F, 0xCDB28F36, 0x7D2709DC, 0x46F92091, 0xB30845E5, 0xB9BDC144, 0xDBACECD5,
            0x42C46489, 0x540F82E6, 0xF80C2D5D, 0xFCCDB9F0, 0x3D911223, 0xFB86D570, 0x4C13157B, 0xB5F7CA20,
            0x32202A42, 0x7DB6B7D3, 0x15DC111C, 0xA8D32956, 0x46A26DD6, 0xFE041102, 0x66FF973B, 0x4CEE68CF,
            0x61BDC885, 0x9E0E3278, 0x68430067, 0xC168DAB8, 0x627291EB, 0x0E5733AD, 0x23F56020, 0x946726D3,
            0xD3526623, 0x20BBAEDD, 0xDFD1512B, 0xBF8458DA, 0xFC5132B5, 0x2E6D20EB, 0x788B72C8, 0x699335E5,
            0x09F5ADB6, 0xCB15094E, 0xD04ED1A6, 0x15926F4A, 0x61E71D34, 0xBDF60932, 0xDDC29472, 0x1AA5A4DA,
            0x25A4162B, 0x5CB4EAC3, 0x0B8ACC04, 0x175B28B2, 0x2E799BB6, 0xBD5F20AC, 0x234ED5BA, 0xA0267DB0,
            0x7FF397E5, 0x77A26A50, 0x2D2ED213, 0xC83ABD5B, 0xD73DA06C, 0x225555C4, 0x99FF5872, 0x7B1B6929,
            0x58BDEC21, 0xB45C0AEB, 0x7CF09841, 0xFD3C6EAD, 0xF28F7ECE, 0xA4FC4E84, 0xD0BBDC32, 0x9F6597A6,
            0xAC292D36, 0x701A1DDB, 0x92A1C32D, 0x7C4F2872, 0xC4394840, 0xA63F3B59, 0x60056E4E, 0xF8F9552F,
            0x282E3998, 0x4C84BCC0, 0xA9B61896, 0xA865E6C4, 0x79829072, 0x1DBCDE6D, 0x6913D893, 0xBFE9FE46,
            0x66AB81DB, 0x4A13FED7, 0x5EA8F721, 0x3DAA0EF4, 0x338AB2EE, 0x3DCDC572, 0x6A134C07, 0xB62822DC,
            0xF4BBF6DD, 0xE1F1F912, 0x81DA1E27, 0x6E79D1CF, 0x7B6E2608, 0x59CB8B8E, 0x1D34A4FF, 0x52BF1852,
            0x1B71AF4F, 0x9E213C9C, 0xCA48F5F1, 0x36526D42, 0xE4DDB964, 0x7155731A, 0x8FABB79C, 0xDD2710CD,
            0x1650B796, 0x4F5FEA92, 0xC705194A, 0xB193CB7D, 0xA7EE256B, 0x7EECE77A, 0xF6EAE489, 0xCE7FA7C8,
            0xEB96E77E, 0xE79C0C50, 0xA97A9965, 0x7273EBCE, 0xCE103F30, 0x8798452E, 0x2320527C, 0x7C646D54,
            0x58CBF3A0, 0x515DCFC3, 0xC94B2F47, 0xC74546E0, 0x572C8543, 0xC3D15720, 0xF5E51982, 0x02B962B5,
            0xD4E45722, 0xB77DB812, 0xAF126AE7, 0x73E1F39D, 0xE1A93C81, 0x0732A8A0, 0x8485C491, 0x38ECDEEF,
            0x54A41EB1, 0x4E4FFD36, 0xEEC1B70C, 0x17880B27, 0xE43C62D7, 0x72E53C51, 0x1D424DE9, 0xDF991131,
            0xD4C434FF, 0x94995F54, 0x953C0726, 0x78F911E3, 0xD48011F3, 0x41055FC6, 0xF688C4A9, 0x69E04A30,
            0xE6CF32D4, 0x5672FE97, 0x8588C924, 0x21A62188, 0x592CFDEB, 0x1BDCB029, 0x35E9F402, 0xE20AA48F,
            0xFECAC7BD, 0x01C21B10, 0xDEE31287, 0x06612DB7, 0xA30153B9, 0xFA6E4E4F, 0xB8D07E8E, 0x2854365F,
            0xEAB8C885, 0xAF848764, 0x63E85825, 0x7AA388D2, 0x00FDEB76, 0xF6EBBBC3, 0x77092A33, 0xA65E1E21,
            0xD062121A, 0xDF3530D0, 0x0EA8553D, 0x56C6BA3E, 0x56C7D8DC, 0xE266FAD2, 0x0AA81D6E, 0x5D48C95F,
            0x2306E605, 0xED43CC4C, 0xC826C32A, 0x15E70E87, 0xF7683F82, 0x47979AC9, 0x89B5F217, 0x47D30F88,
            0x03B00E17, 0x155650AC, 0x502C45A1, 0x4C4E0FCA, 0x7C3D7AD0, 0x8AF74649, 0x7992F42B, 0xAE16CE71,
            0x7440EDC6, 0x453E5B07, 0x1E5EB8B6, 0x5314BC5D, 0x04EA2443, 0x218610D2, 0x66E79722, 0xD56D7574,
            0xF92D8526, 0x6D0AD096, 0x3F3812A7, 0xCFDFB9FB, 0x528DD004, 0x60561CB5, 0xCB510C3F, 0x6E1CA667,
            0x09A15833, 0x05343E94, 0x9872CE6A, 0x9FF1408D, 0xEEA41E6C, 0xC091CDAA, 0x83377665, 0xC9C3E8AA,
            0xE066B5A5, 0x537C5569, 0x47E6893C, 0x668A852D, 0x03A2FD64, 0xF640F5DD, 0x82129914, 0x7495608B,
            0x2894FAC5, 0x284AFF71, 0x092C1A64, 0xCC6959D4, 0xB1030C50, 0xCFA808D1, 0x8488E04A, 0xB6E58A77,
            0x15EAFCEF, 0xF95EF330, 0x3F3F9873, 0x2C4689E5, 0xA9FFC41D, 0x781ECA5B, 0x8C69F081, 0x880C1865,
            0x91A700CB, 0x6D456DCC, 0xC9D98F05, 0x0F2B5E23, 0x5CDABCBE, 0x7C593A99, 0xC237092C, 0x7740E01D,
            0x42A129FB, 0xE6B00AED, 0x38821C21, 0x79B4EF81, 0x596565FB, 0x8D3A9E6A, 0xD82CB0EE, 0x49F5082E,
            0xF92AB791, 0x33FEAA20, 0x4272AB19, 0x9BC02B5D, 0xCCA0531D, 0x463012FB, 0xC911B177, 0xF9506E6E,
            0x3E09D5AE, 0xCDE4A761, 0x24C1001C, 0x8339CAAB, 0x89571BA0, 0x3BBB84EB, 0x94F5F454, 0x887B0ED0,
            0xF8CDF2B1, 0x379E23A7, 0xC18A7F9C, 0x66C7BF7B, 0xF0810061, 0x918CC4C4, 0xC74AFC90, 0x5E54AC27,
            0xB71168C5, 0x94F37684, 0x63A8A63F, 0x28E8F7DC, 0x0DA10124, 0x36D74B52, 0xEDB286D3, 0xD86BE32A,
            0x2C799943, 0x02FF06E0, 0xF25DAE50, 0x8FE679DB, 0xFFF92CC5, 0x2CD7A709, 0x2BC8CF71, 0xA56E7998,
            0xCF01F1EC, 0x8A3C9988, 0xBF5562AA, 0xE99B5FD8, 0x0659B8CA, 0xB1302B79, 0x1EF64631, 0xCAEFEE99,
            0xC5D00ED7, 0x980E6FDF, 0x2DC5A47E, 0x0FAE38D7, 0x43CA3B13, 0xDDD8A4BD, 0xE86A3CE6, 0x25C21668,
            0xCC7B6218, 0xBC015914, 0x10882AEF, 0x7F339DF1, 0xE7BA9E64, 0xBBA92F52, 0xFCE4BD8F, 0xCE4242B8,
            0x071B02F5, 0xE674E11F, 0xB20B9EE0, 0xF8167811, 0x9C61FE5E, 0x2C10823D, 0xAA4FCEB0, 0x61187EBB,
            0x6F082C27, 0xA3034EA4, 0x6B203EB5, 0x525DC47E, 0x02633F24, 0x421BCBA1, 0x0CEF9694, 0x82AF2227,
            0x411BB743, 0xF6EBFF18, 0x667473A5, 0xD8906083, 0x80CB67F6, 0xA628B885, 0xE5D9531C, 0x14AC2E6F,
            0x4A11F599, 0xB7E3E747, 0x5C25DC69, 0xD3ACE649, 0x82E52D07, 0x4E7C5F7E, 0x75F6DAC3, 0x69BA9D0D,
            0x94D6CD0C, 0x82C9308B, 0x4B7279AB, 0xC998C0D1, 0xFC0FF66E, 0xA5FB6A77, 0xCEF5E013, 0x194FA60C,
            0xB3BA2E09, 0xA1F778B6, 0x33A2B2E4, 0xAE505578, 0xBF7C98B0, 0xC9315F20, 0x1D68CA7C, 0x3B4B9B65,
            0x5C8753C0, 0x07C75CB4, 0xD55D7394, 0x55161C50, 0xA515244C, 0xC4701AD2, 0xA2527E49, 0x569A3E0A,
            0x71F97C4C, 0xE73507FD, 0x060C5B4F, 0x675AAA65, 0x3E5AAC11, 0xA2398A81, 0x4BF498F4, 0xCE13058F,
            0x7A185350, 0xD5537C80, 0x19B3B595, 0x3F8FBE12, 0xB502C643, 0x20892CEE, 0x7571B743, 0xAEF1D9F5,
            0x8D6C2A76, 0xAC501173, 0x7C42D485, 0x130422F4, 0x87643CEC, 0xA2F65A6E, 0xCA9E083E, 0x91214423,
            0xAD68C20A, 0x10AF29E3, 0x3EA6B6C3, 0xD84E8A56, 0x9E32C776, 0x933E78C7, 0x94ABFB74, 0x6BBD17B1,
            0x13EBC0DA, 0xD4052199, 0xB954A030, 0x0DBA0241, 0x0DF41329, 0x15FDBFCF, 0x838A8732, 0x227C0071,
            0x74344B20, 0x60094E8E, 0xACEB95C2, 0xA787CDAC, 0x4C58981A, 0x772ED973, 0x4DA6DF5D, 0x364BA863,
            0x0DACBDEB, 0x5DAB6630, 0x6EBFE00F, 0x92FC8758, 0x43CA43C0, 0x703F6B69, 0x8DDC1637, 0xC24EFACD,
            0x511A4D33, 0x1C9E2BFF, 0x45540F9B, 0x04945E3F, 0x8ABC5693, 0x752B09E5, 0x8426626B, 0xA2F9321A,
            0xB8E90FE7, 0xB8D28B96, 0xEB6F514B, 0x41AC3DD9, 0x1DCB0571, 0x9F447E19, 0x871504D0, 0x648998E5,
            0xCA14821B, 0x6C2171D0, 0x1DAA92F7, 0x442762D4, 0xD9BE0016, 0x857C0549, 0x7676DCE3, 0x8D9BDCEF,
            0x55885511, 0x9D1EAFCB, 0xB2C63779, 0x8B233CD1, 0xD806F90C, 0xB98AF251, 0x9419E509, 0xFFA699A2,
            0x374D549D, 0x94337D3E, 0x922B7C83, 0x4D2B35D0, 0xD0672FC2, 0x2FC04AE8, 0x956F618B, 0xB29F86A3,
            0xF14DF244, 0x64A3EADC, 0x769E0145, 0x3DB70591, 0x8BF5E77E, 0xC9A00FFC, 0xA49E7E78, 0x1365331E,
            0x287876C8, 0x04CD6648, 0xFE5D5FDA, 0xFE8F8CFC, 0xA1A5EC7B, 0xFF8E685A, 0x27ADA51C, 0x5D69424F,
            0x3C12583F, 0x43D71230, 0x038EB9C5, 0xBFAD7937, 0x61D24535, 0x44722811, 0xA7CA7B9D, 0xD3A773B5,
            0xEDB0B6DF, 0x70119589, 0xA11BD150, 0x88C3AF01, 0xDC3FECDF, 0xD8EC4B0D, 0xC01389C9, 0xCF411858,
            0xB0CFD049, 0x3F0E9DBD, 0x60200C10, 0x57650D66, 0x06C33491, 0x47B6B1CA, 0xD58760E0, 0x77A5FEF0,
            0xF7E7739F, 0xD994AD2C, 0xAD5F182C, 0x0D5EE3E2, 0xE0C5A059, 0x69F24EF8, 0xE84046E9, 0x602460C9,
            0x1A976B13, 0x5594EBCF, 0xBBCB6B2A, 0x3B451285, 0x72C2242E, 0x52231BE0, 0x4FCAEAC9, 0xBE22EEC6,
            0x408AAE83, 0xFDBE49ED, 0xB9B14B95, 0xB6994B52, 0x9719DF39, 0x23671400, 0x9DB9AEC1, 0xF16F0D8B,
            0x842B000E, 0x1E7EEA91, 0x0E585CD6, 0xB7FAD631, 0x3F69F536, 0x1D3F22AC, 0x7D66FB0E, 0xDD9A4287,
            0xEA0B9C18, 0xAC4D05CF, 0x979FF168, 0x924C2CBA, 0x0D969A41, 0xAFA5D571, 0x1F2182C2, 0x8E727028,
            0x7D252101, 0xEA351CB3, 0x6326DAF4, 0x5F4E4D7C, 0x8934B226, 0xDF3E5972, 0x31F58507, 0xBA7DD5AA,
            0xB7D47339, 0xFA0A47FC, 0xBA9634C6, 0xE323A29B, 0xA874E6C8, 0x900E5FE4, 0x87F5EF42, 0xC812FC02,
            0xFD81475F, 0x860CD9BD, 0xA7197289, 0x5A85D340, 0xFD83FB54, 0xC75A7E86, 0xD7265541, 0x2B32E023,
            0x12873811, 0x4DC19960, 0x2F8250A3, 0x07E306E4, 0x78212A4C, 0x905C9242, 0xB8E819BF, 0x987332DC,
            0xD1BDDED3, 0x90D1BCBC, 0x75605C6E, 0x265E4497, 0xFBCD8F29, 0xDE2F27B9, 0x8D9D7AD3, 0x27CB1A4C,
            0x0731B674, 0x54EEB2AE, 0xE11FF4B5, 0x92DB737F, 0x20E8D3E6, 0x705D23BA, 0xA2066747, 0xCEEB0CA8,
            0x907DA206, 0xDD6A488B, 0x8F0123A2, 0xC9BCC26C, 0x269E84E4, 0x18CA961C, 0x6908FC95, 0x75DBAC81,
            0xF0933EE7, 0x49278173, 0xFDF9328A, 0xF4DAEAF6, 0xC308492B, 0x1D386ACD, 0xF00F1D35, 0x8D4C676B,
            0xF9C169BF, 0x807B3D3D, 0xF28AAEDE, 0x4842E828, 0x513696F8, 0x2075489C, 0x4B2FB746, 0x6124687E,
            0x8435480E, 0x2BF9F643, 0x70288EF8, 0x5D08E11E, 0xA1F3AEE4, 0xBB54F1EA, 0x9FA73B71, 0x67E4B534,
            0xCCD9A163, 0x3EB29861, 0x4C1183A5, 0x0B367DEB, 0xBFE6DDC1, 0xB1F1C1A9, 0x98695A26, 0x75FBF748,
            0x8439ACAD, 0xCD1633D3, 0xEFDB40D0, 0x68051666, 0xC66FFDDD, 0x60A79206, 0x23EF2BFA, 0x9CBDBB04,
            0xE592A427, 0x3B1E3BEC, 0xD6B7B60F, 0xABFA876D, 0x8540826D, 0xE991127C, 0x96C1319D, 0xD6B4736A,
            0x734E0D26, 0x03C22EF4, 0x80C60A2A, 0x3D59A50F, 0x1A8006AB, 0x909427E1, 0x5D124264, 0x4A29F049,
            0x79E9D481, 0x3B08EE24, 0xEC795FCE, 0xB331FB07, 0x2BC23273, 0xBFCC9207, 0x09C66E0A, 0x35873F9B,
            0x9E03E834, 0xFEA83DA8, 0xE6971D48, 0xE55EFE6C, 0x59A2386B, 0x0D028375, 0x205965F6, 0x9DB54129,
            0xA413C6A4, 0xE172CD43, 0xA9D60418, 0x21F9FA38, 0x0F9E6CE6, 0x81B61D58, 0x722706A1, 0x9DCAC8E8,
            0xEB5D03B7, 0x3CFFCC10, 0xBE60F0B8, 0xFD20723E, 0xED05B541, 0x2B7F8EA9, 0x907E7769, 0x7758C2C1,
            0x7434581F, 0x430CB9AE, 0x9AB26F14, 0xB768DD11, 0x0A57466C, 0x88CD5983, 0x99994FD5, 0xF7276C73,
            0x2C2620B2, 0xE495B2A5, 0x793F35E4, 0x306018C0, 0x2F5F45CA, 0x09E4C10D, 0x9E562669, 0x02D2F523,
            0x4082C6F4, 0x8735E258, 0x78A90B21, 0x4ED3E693, 0x3CFA814B, 0x5D32C146, 0x4BBEFB39, 0x1894CD0A,
            0x687828F8, 0x5642A40E, 0x072280C6, 0x45554FF4, 0xAEF6A73F, 0x8E232428, 0xB128E475, 0xF6DB2745,
            0x7FA8D693, 0x172D710D, 0x7FC9B027, 0x48C2BF3B, 0x46DF32CD, 0x0662651A, 0x1ED7EFA9, 0x173D5E78,
            0x6F0FD6C7, 0x2D38CB59, 0x272E4A30, 0x86B4EF31, 0x968FEE1F, 0x3BC1A20E, 0x8D184725, 0x01C9167B,
            0x7B6F37A6, 0xF65DF455, 0xEB9F80A3, 0x33062A55, 0x8FB17C70, 0x56DD58A3, 0xAFA719B5, 0x4A4BDD56,
            0x409F1BFD, 0xA4409190, 0xC944AC14, 0x6A14E9DE, 0x5890F6BA, 0x07E7B9BA, 0xE125997B, 0xC1E154A1,
            0xACBADA1C, 0x98A563E5, 0x7FD11CDB, 0x8641D7DE, 0x00B1D39D, 0x58A858EB, 0x775E7711, 0x1463018F,
            0x7EBF8020, 0x1BA996E4, 0x05238422, 0x71FE6A1F, 0xA63E9003, 0xFC02F0A5, 0xBFD36640, 0x40DDFEA2,
            0x3E8191D8, 0x54453825, 0xE4E95482, 0xDE7B2A89, 0x80912732, 0x5395FD5F, 0x58918541, 0x0C869CA9,
            0xF316A0E5, 0x691A97D8, 0x5C8EB66F, 0x77076E78, 0x3E86AF05, 0x87D20BB9, 0xA9EACCDA, 0xAD47CAA5,
            0x551B1EAD, 0x83C48FA0, 0x543D5631, 0xA436CEA9, 0x1E4173D1, 0x297BACC1, 0x2C37A7C8, 0xA6E2B952,
            0xB9C01959, 0x57277560, 0x5D7237C8, 0x3B3E98B4, 0x75E27D49, 0x25C2C3B6, 0xD9ACB950, 0x0623D54C,
            0x31B3BCB7, 0x5FF37C90, 0xDC9CD7EF, 0x49766556, 0x8C221710, 0x3C0556DB, 0x773C2502, 0xF6F451C5,
            0x81E6CA63, 0x7DACEEF6, 0x3176024A, 0xB2E5F842, 0x72A9055C, 0x3D253112, 0xF4F0670A, 0x24206DF9,
            0x8BEA0254, 0xD12A2C70, 0x28FF745C, 0xEBD35A6F, 0xAF426F9C, 0x5026A616, 0x6D008D05, 0x0EC8310F,
            0x3E4E39AE, 0x43A33886, 0xC6B0A1AE, 0xB9AFD46A, 0xFBD6267A, 0x56B68F27, 0x2760EEB3, 0x9B39803D,
            0xDFB3E409, 0xB2A2374F, 0xA3C37BE2, 0x311307C8, 0x8694F8BE, 0x3FB260B3, 0x6DFCB60C, 0x009E1285,
            0xB953D42A, 0x3A01557C, 0x24895BF8, 0x26FC66B3, 0x42152E4B, 0xA0904F32, 0x36652D99, 0x49C15AF1,
            0x81BFBB25, 0x8F95C0AA, 0x6014FE51, 0x088718F8, 0x6EDC7598, 0xB457E190, 0x47629329, 0x5DBB8EA6,
            0x2CAE3566, 0xD65D840E, 0x5CC47BC6, 0x5501A73A, 0xB344AAF5, 0x49B797C8, 0x73600E4A, 0xF1444A4D,
            0x9FC07890, 0x316DF721, 0xA7544CB2, 0xFEE53E04, 0xB6186DF8, 0x92000D4D, 0x13BA7901, 0x242B0F51,
            0x4AB962A4, 0xCD214BB1, 0x398012EE, 0x40EFEE6B, 0x5F961431, 0xCE9073FE, 0x737C73ED, 0xD6AF518B,
            0x60BA7FC7, 0x8063D49E, 0xA2B0D924, 0xF7ABF450, 0xCD77AB5B, 0x890D13B0, 0x1C72B95A, 0xC4B9C1B3,
            0xD5A7AA70, 0xAF7FE127, 0x4867A8A9, 0x5944D848, 0xDBA892A1, 0x69E21419, 0xD0B099BC, 0x9E7EA1A8,
            0x816C1734, 0x0A1FC6C7, 0x6CD1A9B4, 0xB718B6A8, 0x2DC40AF3, 0xEFA6421E, 0xAB622418, 0x47A10BF7,
            0xCD1A4E25, 0xBE3EDDEC, 0xAB8A0DA7, 0xE77E2641, 0x0FE13008, 0x4D665F94, 0xEF687C36, 0xF61BAD91,
            0xC71A13B7, 0x7CAADA95, 0xA6A6024A, 0xE4C7F5C8, 0xD41BA8F3, 0x96C381D7, 0x785A62E3, 0x37245858,
            0xB716CB3C, 0x47828E8F, 0xCA8B44A5, 0x104D0EE0, 0xCD89905A, 0xDDC1C01C, 0xD8DFA335, 0xD60BCC8F,
            0x99A1F5E1, 0x1887801A, 0x5F76CF52, 0xA50C1D77, 0x0F80ED4D, 0x2647D050, 0x85E84382, 0x03EA6753,
            0x4E9EA454, 0x1F74EE1C, 0xAA415393, 0xDCC72899, 0xC88A3D4B, 0x4273C9EC, 0x19DD02C0, 0x4F75A6A4,
            0xE483E629, 0xA3EC95EE, 0x68FDBAB6, 0x916D7E2D, 0xEBCEE216, 0x134F308C, 0x56D05731, 0xE26FD39A,
            0x8DE3C9F9, 0x533CFEBB, 0x1FDE3CDF, 0x5FCEA4B7, 0xEBEE59AA, 0x45C358EA, 0xD4351DF1, 0x5B8D87DA,
            0x101F2801, 0x5D4A4117, 0x130CFB24, 0x3D11DF53, 0x737FC883, 0xA028FA62, 0x72E23E3E, 0xB90E4032,
            0xDF47FB88, 0x7B8DD017, 0x510DB2A7, 0x49614146, 0x461AAE23, 0xFF63A7CD, 0x387EF6B5, 0x1FC99DEC,
            0xF983DE7A, 0x8CB5B290, 0x5311CB9F, 0x6477BB22, 0x73962A67, 0x010D1D2C, 0xACEF7BAF, 0x801E9D43,
            0x050FE3BA, 0x6B2E4689, 0xB687915B, 0x947412C1, 0x6D834DDC, 0x241F742F, 0x3AE2340B, 0x6DC1B5B4,
            0xC189B1A7, 0x0E419E77, 0x52EE37B5, 0xC4396552, 0x13648CD3, 0x40AF31FD, 0x83110C9D, 0x276D4100,
            0x15D2F9E0, 0x6D8AB22D, 0xB527E9C8, 0x1EBB0F68, 0xCE6ED97C, 0x6BCDA413, 0x64EFCCAE, 0xDCD12C47,
            0x5E830545, 0xAA1574A2, 0x3B564085, 0x38567A70, 0xD3A7D8DC, 0xA903EFEC, 0xE65AD211, 0xDAF2F0D4,
            0x134D040C, 0x9A3AC22B, 0x28E8BCDD, 0x6ED72785, 0x37B3F9FA, 0x62CD03AA, 0x0C9C7D74, 0xD9049359,
            0x450CA0F6, 0x4A9F1992, 0xBAF4BDDE, 0x74935055, 0x8CC09A67, 0xB5A78481, 0x6A17CBEA, 0xA03DBC55,
            0x2586F7CB, 0x80F4899F, 0x4CC54274, 0x80ABBFD5, 0xC72154FD, 0x4FF30EE0, 0x1CAFFFA1, 0x0BE51B39,
            0x8FE3F787, 0x5905BDD0, 0x65BC6F5D, 0x7AAB48D4, 0x54DF2E24, 0x4C95EEB8, 0x777FDC9C, 0x5ED7128E,
            0x15863861, 0xBF1E2472, 0xA019D265, 0x67329BE3, 0x76E7D968, 0x78971855, 0x3242BEB6, 0xCD3C25F3,
            0x66C573B5, 0x3F50CAD6, 0x93A0576F, 0xB3E930D2, 0xBFA54A57, 0xB1C80B2A, 0x6EC5691F, 0xE02E040E,
            0x357AA7AE, 0x304A6490, 0xE6FA9978, 0x6752B6F2, 0x6D6C79EE, 0xD0F38685, 0x70B78816, 0x6F4BFDC5,
            0x73108071, 0x95080D4D, 0xCFA51169, 0x15E15347, 0xA6E20B0C, 0xB5A74116, 0x3877F202, 0x6C9522A7,
            0x7B409466, 0x08DBED22, 0xE5E38A5D, 0x92528059, 0xA7090F89, 0x55CF8EAE, 0x9F252F9D, 0x9EAF31F1,
            0xF7FDF1D2, 0x58FE62C1, 0x3D0E0DE4, 0xEF034408, 0x05E2AE54, 0x15E562DA, 0x2153933E, 0x4A1A7123,
            0x2519DB56, 0x847D67EC, 0xCBCEEF2F, 0xADF5EA0E, 0xAABA4434, 0x30DA3545, 0xCADECA0D, 0x06A08A26,
            0x59B16000, 0x8B7DF3C7, 0x0CECEAE9, 0x7A8BF314, 0xAC45EB62, 0xFB8B9B87, 0x2CF7491D, 0xA0FF3636,
            0x36708E43, 0xFD94A805, 0x45DE2845, 0x7A5BD82E, 0xE0297C90, 0x517B4714, 0x83715CEF, 0x015405CE,
            0xCE9B6B5C, 0x34EA3FD1, 0xBD775517, 0xFB6C7C3A, 0x60CB4FC5, 0x516F3140, 0xFC818805, 0x46755A0E,
            0xAA6D4ECA, 0x64733B45, 0x77BF7B0B, 0xF269A091, 0x4D4A37D6, 0x56E27218, 0x9D3AD8EF, 0x751597C7,
            0x67429104, 0x8FF8E55A, 0x63403593, 0x33649681, 0x2E9594C0, 0x5537B42F, 0x8E0B6CD0, 0x1B6C430A,
            0xB3BB4B97, 0x69B02ABA, 0xF6360B1D, 0x64F82EC1, 0x55416DC2, 0xAD183D08, 0x348F02D1, 0xDCE3CEDB,
            0x7AF0AB0B, 0x5E3E8E68, 0xF34D0605, 0x659773DA, 0xB2011EBC, 0x9BA8088D, 0x02524E91, 0x76FCFCB3,
            0x43DB3EEB, 0xCBA9A83B, 0x5DF034EF, 0xE2F3BDA8, 0xF3FB95E8, 0x21A8B488, 0xE0E6F08A, 0x7C4F34BE,
            0x3297503A, 0x902768E0, 0x64A62300, 0x650FFDD5, 0xCA7D0467, 0x46D594F0, 0x9211E7D0, 0x0C28CB7E,
            0x7CD1DEF3, 0xF8D858A9, 0xB0F1FDB5, 0xBFA2B4E9, 0xF3CF9981, 0x4B5716A7, 0xEC05AD2E, 0xB494DB06,
            0x6F24550F, 0x8BFE37B0, 0xB0CE8E12, 0xCBC5A5FD, 0xFAF33D35, 0x21E2D9E9, 0x165BFAE5, 0x380A0126,
            0x4BAC6E5B, 0x4C01685B, 0xE8680CE0, 0xB4D868A4, 0x91E14D7B, 0x0EE22B0A, 0x6279BCBE, 0xFD157EE2,
            0x300E006C, 0x859BB973, 0x5E4DFF34, 0x51EEAFC2, 0xF0A74D0B, 0x082F2641, 0x7E1299F1, 0x0AA5FE93,
            0x1349C0A2, 0x1AA39D1E, 0x9C209041, 0x54AC5E57, 0x77ED88A0, 0x3931EFD9, 0xAF3712EF, 0xB60FCDDA,
            0x76EF51B9, 0x2FD4C631, 0x2395F7ED, 0xDBDE6A26, 0x8B4C0CD5, 0xA4C75FC7, 0x4A991318, 0x75511B1A,
            0x5F7EF144, 0xFE1D77B9, 0x1AE1527D, 0x97EABCC0, 0xE1B74290, 0xA37FFB74, 0x3DAA2C94, 0xA9F9C37F,
            0x5DD2F53F, 0x1CC763B7, 0x4661D125, 0x76A6FF23, 0x572B8C3E, 0xCA05B230, 0xB0BC8790, 0xFF7B2DCE,
            0xDED276AB, 0x4719FA5B, 0x711ADEBE, 0x992C0A84, 0x494ADB66, 0xE66575BA, 0x700C2968, 0x695ED676,
            0x1E87DC63, 0x99DF1246, 0x0DA44D63, 0x8C016E7C, 0xAB0FAA47, 0xC2C9ED57, 0xCDD5CEC3, 0xBFDD146A,
            0x1F66A643, 0xCAF089C7, 0x794FEC37, 0xEEA5C3CA, 0x6D87D545, 0xF34090EA, 0xBBD54FCC, 0x4F79BD6E,
            0xFA276618, 0x647F9B6A, 0x17B96991, 0x11B46528, 0x6CBADDF6, 0x1EED5FDB, 0xA00C4986, 0x4B4F38F6,
            0x9A71777D, 0x42CBF932, 0x62EEFEBB, 0xBD029A7C, 0x132E4B52, 0x78FE3FCA, 0x6A9AE9E5, 0xEFCE20CF,
            0xCAB87B02, 0x61EFB610, 0x96BAC74D, 0x9A92F31D, 0xB95F1DCE, 0x25C99B54, 0xF4CE96A1, 0x4ACB0E29,
            0x5CAFEE7F, 0x5C236D33, 0x17AE4AA6, 0x88A3FA6E, 0x1ADC267E, 0xCDFDB3DB, 0x76FFF47F, 0xDFDFB972,
            0xCAFB02C3, 0x68588796, 0x0BC70EC7, 0x8201387E, 0xE2E1E17A, 0xEF0F599F, 0x4D1BE53A, 0xEF405240,
            0x935EC276, 0x8C548FD8, 0x0ECF9D4D, 0xD103305E, 0x7170C71A, 0xBDB1921F, 0x39E99855, 0x75231331,
            0xAEA4246C, 0xE8066E86, 0xB15DE5B0, 0xFBB5CD30, 0x909B91C6, 0x1C277BEC, 0x4FDE418D, 0xD8EF9A83,
            0xF77B53B1, 0xFDA5B2E7, 0x3CDACBC1, 0xBF48F004, 0x1A2D60CD, 0x42EE6CF3, 0x3B60B8F5, 0x6BE51DC6,
            0xC7C33AB8, 0xDA388C84, 0x770B9108, 0x881607DD, 0x3B1B1765, 0x031824E6, 0x857F53C9, 0xCB630501,
            0x93042F7A, 0x9B24E4EC, 0x9A09129A, 0x4D8568A5, 0xCC4B176A, 0xF8B0E80F, 0x6AD16AA7, 0xC09C1D85,
            0x5B4EACA0, 0x7A56E689, 0x8F2A91FC, 0x098D156F, 0x61D6B9B8, 0x1A9BE619, 0x347C3D06, 0x1410F48D,
            0x3618BAB1, 0xCFC0EF6E, 0xF8FD6B2D, 0xBAD0C090, 0xCEA8322F, 0xBC5D64CC, 0x0CAE7B0E, 0x53B0AC43,
            0x37D3FD00, 0xB19AB887, 0xD129A6B4, 0x939F5835, 0x712EE4C2, 0x0A8607D9, 0x23D4A80F, 0x8D9C00CA,
            0xB695A91F, 0x1CDC73D1, 0xED824510, 0xE197E653, 0x7326B425, 0x95F14E1D, 0x7046C32F, 0x067FBB4A,
            0xA2CB46C0, 0x9F191871, 0xE24B9694, 0xB1B93792, 0x4F5FC504, 0x8B3BA6D5, 0x48FFC644, 0xCC28559E,
            0x2142C3BA, 0x4B0CF0C9, 0x8C8826C3, 0x0A3151E2, 0x3EE6F5A8, 0xA66FFD33, 0xE655908B, 0x77D70408,
            0x4818EE3E, 0xC0631BCA, 0x3F5E9B77, 0x81779986, 0xD72DAAE4, 0x6D1ABDED, 0xC906F5ED, 0xA82DD27D,
            0x6271113B, 0x53415610, 0xD18ACFF5, 0xD774AD15, 0x701C2E5E, 0x808231C9, 0x450363CC, 0x74F6AC8A,
            0x689EF88F, 0xAFBD3F32, 0xEE61AC01, 0xC09B6C18, 0xD5EEE4D9, 0xAECB186E, 0xD1499642, 0xC04519FC,
            0x0ACADE08, 0x01D8AFFE, 0x6BF7C4EB, 0x80BACC00, 0x9D2E165D, 0xA6DD0417, 0xCDA5ED89, 0x03BF34CD,
            0xD35125BF, 0xB2EE2A2A, 0xC2E42F2A, 0x3E0A02D1, 0x13601BA4, 0x0707822D, 0x79F82534, 0x5666B569,
            0x33F9DB5D, 0x49674B0A, 0xA49C3926, 0xD0EA1648, 0x2D7F09C6, 0x0EAC426C, 0x719E8FB7, 0x8DB9F07B,
            0x05FA0435, 0x1D3F046A, 0xC1EE0A77, 0x586D5784, 0x18028F79, 0x936BC3FF, 0xD2072A23, 0x2B7A4A7D,
            0x0EBB0562, 0x2ECF0BD9, 0xFE3C7620, 0xF43A6EC2, 0xAFD5C7EA, 0x229A0AE2, 0xA1DC26EE, 0x1DA056A4,
            0x7DFDEAA8, 0x59ECE000, 0xBA30972B, 0x7C3862A1, 0x7606E6BA, 0x0098CA7C, 0x847F2361, 0x8ABA1D74,
            0x1709F2E4, 0xACE62BE9, 0x6C92BA6E, 0x91F54EEE, 0x7DF859BA, 0x28380922, 0xCD7493B5, 0xA2BE7EDC,
            0x248F52E0, 0x30EB99DC, 0x904D01EB, 0xD3AAD064, 0x34924AD4, 0xC3C74600, 0xBD12469C, 0x85752753,
            0x3E635C54, 0xC80582BE, 0xA6E0C5C5, 0x70F31A02, 0x92EEA6B0, 0x188E0093, 0x70C8F854, 0x7B9E0780,
            0x28AE3355, 0xCA32D734, 0x852A5E48, 0xA24B4BF9, 0xF144D8C8, 0xF452C1A1, 0xF79FF573, 0x0CAD7E45,
            0xE5EB082F, 0xA36F6835, 0xC3F0F9FA, 0x0EDF7087, 0xA74A993B, 0xA34387E1, 0xA28AC65B, 0x21725C85,
            0xDC718550, 0x7A8F5667, 0xD474A4FB, 0x5F7A2CDF, 0x4DE50363, 0xF1C3ACFE, 0xAAE0AEC1, 0x2434ECB0,
            0xFD7A954D, 0x1B00578F, 0x429406F2, 0x5D016291, 0x83725575, 0xD79BD9B1, 0xA2E6ECA9, 0xF9CC01B2,
            0xCE3BFC41, 0xC9A43ED3, 0x742DA697, 0xD3D20ECF, 0x7026ADCF, 0xC86E3235, 0x66F4C7A5, 0x4EB163EE,
            0x4CA5C912, 0xACB0B7BA, 0xA5DEA8F2, 0x60336718, 0x171D16B9, 0x9B9D1967, 0x06534C3C, 0x14B2F0A0,
            0x289FC38F, 0x15E553A1, 0x1BEA77B6, 0x2232403E, 0x9624FF42, 0x2439C70B, 0xFADD11A0, 0x90B185A2,
            0x83474304, 0xB8AF2B6C, 0xB777230E, 0xAF55E47F, 0xC074D6E1, 0x5802B04F, 0xC4E582C9, 0x17CA1B56,
            0x75A6C26C, 0x3B7C19FA, 0x770E1EC5, 0xD5463125, 0x27AA427D, 0xE3726A8E, 0x10970D7A, 0xD66AC927,
            0xFA04C19E, 0x9BAF8D0C, 0x63E76574, 0x27A44EA4, 0x685D560E, 0xADC21029, 0x7D4DC948, 0xD5B062F2,
            0x26648288, 0x2981066B, 0x1274AF7A, 0x0F2A4752, 0x67CE4EED, 0xF2744728, 0xBB7567AC, 0xEB50F066,
            0x7C75DA1E, 0xE4184E85, 0x8BCF14D7, 0x7A166CD2, 0xE8299AD2, 0x03A8AD00, 0x21346071, 0x357767EC,
            0x78647586, 0x66D234E0, 0x0B193FCE, 0x1652F900, 0x2A7F0ABC, 0x1CFC6418, 0x45193DC0, 0xB8446D7C,
            0x4A956A7D, 0x21ACC549, 0xD3121F49, 0x431C0517, 0x30B3C61F, 0x29C83B64, 0xF3E368ED, 0xC04FD25A,
            0xC47F520E, 0x501CFBF5, 0xCBD4F0FF, 0x6408E17A, 0xBE1DED75, 0xBC64C5C6, 0x09EFA21A, 0xD520D833,
            0xCB59E981, 0xD590CD47, 0xC5719395, 0xAB3AB789, 0x4F73484F, 0x2999E32D, 0x23A97DC1, 0xF7225471,
            0xEA138C44, 0x098BCB28, 0x3DFABC9E, 0x655166F2, 0x9756D22F, 0x5AF04B1B, 0x867CAA73, 0xF819146F,
            0xAC7CCFCD, 0x8A2DD657, 0x904C08B8, 0xFB347F0B, 0x362D4F2D, 0xFB286012, 0x6FB3DB7C, 0x648BF3C6,
            0xFFC4A322, 0x7DAC0A52, 0x8ED421A9, 0x8063FC61, 0xA29283B1, 0x8BE3DE6D, 0x589FE2FA, 0x4A125576,
            0xA71E7059, 0xF27B05BE, 0xAAE8C57C, 0x33A72810, 0xDC9CFC48, 0xF8754364, 0x92972902, 0x34471360,
            0x163FB3DC, 0xC52A5CC6, 0x6C949BF4, 0x1CBF4D2F, 0xEF541583, 0xBFE0368E, 0x92575EE8, 0xBF19EA17,
            0xED6A3161, 0xD6721E53, 0x6AF454E1, 0x697387B3, 0x14DFE0C3, 0xA02216A0, 0xA1857099, 0x629522F9,
            0x72801AC1, 0x8A809DE9, 0xF4B1EED2, 0x424B8912, 0x4AB87902, 0x95DCB495, 0xCCD9CF54, 0x09BB5668,
            0x53601072, 0xDD56B9D8, 0xE172EE15, 0x3CF187F3, 0xCE176868, 0xF3CE28DF, 0x751ADD57, 0xC5FFFD94,
            0x8475FA06, 0x0A11B7F7, 0x9536905C, 0x2E0A7B6D, 0x7204C042, 0xB7C0767C, 0x8BFC382B, 0xECFE642F,
            0x21EC8FC7, 0x8FFF0BA0, 0x52851905, 0x77DF00D4, 0x6BD2E58A, 0xAF211594, 0x0E51BDF2, 0xF70FAEC9,
            0xB6E4F373, 0x762DBD12, 0x751388B0, 0x13A1791B, 0xC9FE1A86, 0x7EAA73A7, 0xAC52514C, 0x160ED2E3,
            0xF99E579B, 0xAD777A20, 0xC420B25F, 0x8AE19D66, 0xF5E77FC6, 0x979C224F, 0xF3DFBE37, 0x47413223,
            0xB4A7D680, 0xD042DF05, 0x04AB309D, 0x5B54BF9C, 0xAE320124, 0x5581E25A, 0x3768CDF1, 0xAE76C114,
            0xDB7E02D7, 0x09A6C024, 0xBED71A36, 0x83D688B1, 0xC6C8BB38, 0xB7FD60A9, 0x9E8ED208, 0xAECCDFE8,
            0x4ACD9A9A, 0x7534A3A7, 0xA1E0270C, 0xAB991480, 0x6CAF689C, 0x174E6F5F, 0x145DFD69, 0x41A9FC99,
            0xAB45E2C0, 0x61BA2276, 0xC139CB6E, 0x012370D6, 0x9AC15926, 0xCFE4FD0B, 0xA49BFC5B, 0x73C40876,
            0xEC66AD80, 0x6947C7E2, 0x4F403602, 0xF6A7FE45, 0xE8F2A224, 0x378175F9, 0x9218B015, 0xB6523303,
            0x8164628B, 0xBD80ABB5, 0x5FCAD784, 0x37941BED, 0x51D97DB5, 0x00A954B7, 0xF43FB77F, 0x65EC2599,
            0x61B85A5F, 0xAFA854D2, 0x767F9C78, 0xB3FCAFEF, 0x7A30F89F, 0x053E8676, 0x974376DF, 0x2292A172,
            0x61045719, 0xA6C1D8E0, 0x95BCAEB2, 0x72857817, 0xC4B357E3, 0x60B8D05F, 0x0F5800ED, 0x50BAEB85,
            0x3C7B8BC3, 0xE6977AC6, 0xF1482C6B, 0x9FAF7BF9, 0x2B5ED787, 0xEFF07328, 0xFB252369, 0xEE867349,
            0xE8785467, 0xF8A53CB7, 0xF18B14F6, 0xE8947281, 0x284D76F8, 0x48F7B322, 0x6D472D80, 0x90D9DD07,
            0xC332C1A5, 0x5C38F59E, 0x34BAE42E, 0xF7141393, 0x635CA4F1, 0x3A322547, 0x0288378C, 0x4954A154,
            0x9513ECCA, 0xA0F03CBD, 0x0828014E, 0xDF07579D, 0x2AF9A300, 0xFD7B3174, 0x814C2C5C, 0x6336CED8,
            0xF9E8B7A8, 0x75DD7AD3, 0x14A7A386, 0xC5F43433, 0xE22D758A, 0xB7BF6B33, 0xCD112CFB, 0x00D665A3,
            0xA0023736, 0x548EB66E, 0x50127015, 0x1E1ED251, 0x2F18DF31, 0x421E1476, 0xF8526B66, 0xDE039E60,
            0x38953830, 0x0E0EB645, 0x2236F3BA, 0xF3D73466, 0x5F2E9A75, 0xCF1FA555, 0xC15CB06B, 0xD37C1322,
            0x53453DA6, 0x33838A4F, 0xD4F30B2B, 0x3CDAD56B, 0xBE829331, 0x8634D722, 0x031B5F22, 0x16C553CB,
            0x6F3BAFCF, 0x27FA9A3D, 0x1202F6CC, 0xC648F6A4, 0x36002148, 0x3DC689B8, 0xF58D660B, 0x4291AE0A,
            0x3A4817BC, 0x80A5886F, 0x098010AD, 0x9A568AAD, 0x9479ADA5, 0xA8E278CB, 0xE166B2C2, 0x82C9F6BD,
            0xEA844F63, 0xA2B34AA3, 0x8CCDE0CB, 0x673E9DD5, 0x1ED99881, 0xDEE3F336, 0x94F5DB9C, 0x2D1D5CF4,
            0xF7BF3FFA, 0xB91CFA21, 0x8A369FC0, 0xF321D6E7, 0x20B8493F, 0x3F65997D, 0x7F0A24A3, 0x8CFF5A92,
            0xD19E4B38, 0x5051156A, 0xC3B34706, 0xBFB49076, 0x20353F86, 0xC3E619AD, 0x18D9B2DC, 0xFB9F3866,
            0xB73478F2, 0xABEDCF7F, 0xCCFF1666, 0x4603D9D0, 0xE23CC92B, 0xCE179528, 0x8E9DE9DC, 0xD64EAEE4,
            0xED38150D, 0xD9978FB5, 0xA52FF183, 0xF5334CF8, 0x41010DF1, 0x55CDD7E2, 0xC3DDEF6C, 0x4949ED80,
            0xAD12BF5D, 0x6CE16A91, 0x34654FBB, 0xCB853038, 0xBC830456, 0xF781F0FF, 0x76077C37, 0x71B797C3,
            0x55264A1A, 0xDA68CE0B, 0x10746368, 0xE85500F1, 0x9B8BB623, 0x7ACE3F43, 0x1703FDBB, 0x0A9129C2,
            0x9D7946C8, 0x04EE8009, 0x7AB5F439, 0x8D451861, 0x1B50A033, 0x64404B4C, 0x0DB9E8DA, 0x75BCA4E8,
            0xFF419F44, 0x6205D29E, 0xCF75E0E8, 0xCACEAC8A, 0x5E41F1B2, 0xF0A8ED8C, 0x2C318763, 0x6939D21F,
            0x3DE644C0, 0xAEE20842, 0x88B28653, 0x30C0E5F8, 0x4D5F2137, 0xFD29D88D, 0x0304A4B3, 0x41AEC540,
            0xE4D8075F, 0x0DD2B76E, 0x338C1CAF, 0x7FDF260D, 0x79ED1A3C, 0xD67B6939, 0x4D6B9A62, 0x9BE38955,
            0xFD08EFD5, 0x448DD03B, 0xEA5B5D22, 0x2FB4B966, 0xCE8AFC8B, 0xE3E7B751, 0x3745D191, 0xD89FD042,
            0xAF7C568B, 0xDD5FE7B1, 0x7715F1D2, 0x3FB9124C, 0xF9F200DD, 0x96D32C0D, 0xFAA7137F, 0xF40F3F94,
            0x6A111779, 0x637E2897, 0x2C0B3F5C, 0x2664728C, 0x0E4AB9E0, 0x346A3F6C, 0xCB7BEF6D, 0x25B97F22,
            0x01AB4AE2, 0x3A41AE75, 0x7A3FD29E, 0x5DFB4D5F, 0xCB1583BA, 0x4FA211E9, 0x789FD3A7, 0xFE234549,
            0x3409E2AA, 0x42B3B888, 0x5E74E531, 0xB6705597, 0xD1F3B78A, 0xAD82615B, 0xA3A78AFF, 0x2950F8A5,
            0x731E01B5, 0x656553FC, 0xCDDF12DF, 0x2A184051, 0x4149408B, 0x3CF22BBE, 0x9533CFB8, 0x7B04C32C,
            0x45517654, 0xA72FD57C, 0xD2F93E8C, 0x094982F6, 0x7C2E8444, 0x4CD60C22, 0xECAC11C1, 0x6A985B7B,
            0x05F80D9E, 0xA8201D18, 0x36D36976, 0xBEB45464, 0x3B93A847, 0xC06E4A66, 0xB711C898, 0x5FEAEBF7,
            0xB53BF905, 0xFF287E7A, 0x98502D9A, 0xBCD7D6A8, 0xF28DA657, 0xF43AE2D1, 0xE9AD3DE4, 0x5C65CA7C,
            0xCBA3A8D8, 0xD916C56B, 0xEC4F60D8, 0x49BE5E2A, 0xE8F71D72, 0x2175CF1B, 0x2864A153, 0x42698D5B,
            0x04035E1A, 0xBE83F4B8, 0x79CFCA84, 0xB8000CD9, 0xD35C9092, 0x56E2DDBA, 0x6962017D, 0x0C8B8077,
            0x85F03FB6, 0x8A594235, 0xBD1A2CCB, 0xDBA9573C, 0x0EB500EE, 0x800AB1DB, 0x4D55106C, 0x13E343AE,
            0x0E300F65, 0x4C6E5B7A, 0x2AFCF64B, 0x71162F66, 0x53FB563C, 0xEF838487, 0xFC362ECF, 0x749FCAB4,
            0xFACD0646, 0xB839E844, 0x5C53A1DA, 0x5D0C6051, 0xFFF43B21, 0x185EDBB9, 0xF0B427A4, 0x53175921,
            0xF7D14B1B, 0x6D336164, 0x2AEFB301, 0x59FE280B, 0xC8777837, 0x6B68F07E, 0xC1FB34F3, 0x46F7A3D1,
            0x07987FA7, 0x34784182, 0xEE0E50B8, 0xD82ED628, 0x24E27F36, 0xD6A97A8D, 0x80A11BA2, 0x3768E948,
            0x2F70DD39, 0x7D0CE733, 0x46DAF9C1, 0x03558CA7, 0xFDA358DE, 0xC7A0D9AA, 0x90236E5E, 0x24880D9D,
            0xB0881185, 0xFA43E4EF, 0xF81FEC14, 0x9CFA66BF, 0xD7AB75A2, 0x58F4CF31, 0x7001552A, 0x08BB21B8,
            0xFB459534, 0x2B0E86B9, 0xDB84F226, 0x59CD0D17, 0x4A93198B, 0x1EAC9340, 0xF31CB116, 0x7B62D94B,
            0xCB4D5895, 0xEA7B5262, 0xCFF8727F, 0x6B31C5AD, 0xE1C72B28, 0xCD7250F0, 0x548169F2, 0xE136BDE3,
            0xDE77FCCA, 0xF9E17C54, 0xFFAEB0D9, 0x176D2F85, 0x4AE984C9, 0x94A7EBAD, 0xFB9B59D1, 0xFD3F0CE6,
            0xD23351BB, 0x359F5965, 0x205B8EF2, 0xA2991786, 0xBD506A31, 0x9F14DDEC, 0x2225B412, 0x93C2B19F,
            0x438A4089, 0x8F956111, 0x746932C0, 0x877C87CE, 0x77DDDF38, 0x12C4762F, 0x8BC8384B, 0xE1BBE8CE,
            0x6382667E, 0xB2B8D480, 0xCBF93D72, 0x0A45030D, 0x249B4680, 0xABA7CE08, 0x86461C1E, 0x93C721FA,
            0x34C25FB5, 0x9EB867C8, 0x93560960, 0x296C0C9C, 0x052C9470, 0xF5C0CFC1, 0x3A0BC83F, 0x5612105B,
            0x071680E5, 0x7FF35046, 0xA19B7233, 0x9DC91286, 0xB5610941, 0x83A620D2, 0xE55241CB, 0x1DEB4D9D,
            0x2D6C69D9, 0xFD46BA30, 0xBDFBB4B4, 0x18DD61C2, 0xE6B25B0D, 0x8D3903A6, 0x8BF81F12, 0xCC7B1F22,
            0x4264129C, 0x79CA4318, 0x5F941C05, 0x9BEC7403, 0xC5D67E55, 0xB5FF1947, 0x1FCD2FF2, 0x69572FDF,
            0xD657E364, 0x2743CA75, 0x1FF5CCB8, 0x302063AE, 0x078DF17B, 0x370C6458, 0x1A4A86EE, 0x90ACB29E,
            0x5C55B386, 0x0153332A, 0x65E01C12, 0x827A459D, 0xFBA500C0, 0xDBC60B1E, 0x5ABC5A71, 0x26F0C521,
            0x4B37DBF7, 0x553E57A2, 0x3DB6C899, 0xE526C55B, 0x85765734, 0xF79404B2, 0xDE59591C, 0xC59422FE,
            0x95679CAE, 0x5DEA01C6, 0x7F145D58, 0xAD1111A9, 0xA1C58626, 0xE1848CB9, 0xDE1566E5, 0xCE5D670D,
            0x8A8E9AC0, 0x61B0D7D3, 0x52B1B441, 0xEAC1D55B, 0xF29B65BF, 0x62C76821, 0xD23588A0, 0xBF149977,
            0x4124F759, 0xB7AAC18F, 0xAEC82E33, 0x3CEF3D2A, 0x141F849E, 0x318B9C4E, 0x86449ADB, 0x71172EC8,
            0xE0B7905E, 0x43E53BFD, 0x463D0E9B, 0x3DB1F1FE, 0xDCC64706, 0xEF4202A9, 0x9916154B, 0xD791CEFD,
            0xA2A85ED7, 0xB152A9FD, 0x11787FE2, 0xA4ABAB3A, 0x7AA69353, 0x838EEBA1, 0xFE907635, 0xC4F63345,
            0xC6E0D6E9, 0x120AC180, 0xD6E808BF, 0xDD3CC4FD, 0xA602A83E, 0x8EC56FDD, 0x251953B4, 0x4C09CF72,
            0x7C5E4453, 0xD48DC6C7, 0xD489D424, 0x91535073, 0x3B78F4C1, 0xA10086E2, 0x1D935849, 0x6DA4EF7E,
            0xBB31D5CE, 0x14A5E831, 0xBDE9225E, 0xA568EDEF, 0xECDDB6E0, 0x75BCEE7F, 0x0B33AE54, 0xFE7776F7,
            0x29033981, 0xC0BB024E, 0xB1472457, 0x66C25DFE, 0x507818C4, 0xF92C87CF, 0xB92B3B6E, 0xADF2C67B,
            0xA6FF5386, 0xB492D5DC, 0x6EB69154, 0x60B4A3FB, 0x2C56DF83, 0x571F17E6, 0x9F96E658, 0x62278A94,
            0x69EAF54F, 0x2D7E69E0, 0xCE95D712, 0x128E62E0, 0xCBA3DFA7, 0x4A7D937E, 0xE0CF7093, 0x7A104AE2,
            0x64F99F72, 0x3D68D93D, 0xAF2DDB1D, 0xC8DFE428, 0xF1B48970, 0x64A54E94, 0xDB027FED, 0x04D21009,
            0x3B71BDAF, 0xC448E3BC, 0xBF375A24, 0x43AEB3B9, 0x52B7C32C, 0x89EDAE51, 0xEE1351E3, 0x1FA9C8ED,
            0x9F48D8FA, 0x51BE1C90, 0x31DEB89B, 0x73DD2419, 0xC4AC3B09, 0x89302DD7, 0x0B6FA2B5, 0xDE16FA60,
            0x621D998D, 0x2A0393A9, 0xEC5FA556, 0x9045B19B, 0x17F748EB, 0x137F97E8, 0x77EB0116, 0xA2E1FFB6,
            0xDFF9F31B, 0x99A2E5E6, 0x49C0B3B0, 0xC232BA16, 0x3E18C3AD, 0xCF84AC4A, 0x0258CEDD, 0xBE692E10,
            0x6313114A, 0x5D67A61B, 0x047DE3F8, 0x1F3A7FB3, 0xE59B31CB, 0x7FACEC34, 0xFFCF652F, 0x3568CC10,
            0x72DB7235, 0x516CCFAA, 0x613213F0, 0x9B4DC84E, 0xCE25B392, 0xECC1A930, 0x426B8457, 0x98631FDA,
            0xE4300306, 0xD10A1F3A, 0x5FFC2CD7, 0x5B0DE351, 0xB539A11A, 0xF9CA9E55, 0xF05B11FC, 0xA4480806,
            0x98918A71, 0xCCB24A4A, 0xC4A61ABD, 0xDBD26E60, 0xBE5F0D99, 0x9F64EE05, 0x513A5DE7, 0x6DD14CCF,
            0x8BF7A76F, 0xEB33665B, 0x1F7657F8, 0xE086D8A2, 0x55121153, 0x041841CC, 0x9792CCB3, 0x4679E420,
            0x796EECD1, 0xBCC093B9, 0x222BFCE6, 0x5CFFA31D, 0x0131EF78, 0x8382F8E9, 0x4E814D98, 0x9EDDCA43,
            0x55BBB4A6, 0x88CB995F, 0xC1C272B8, 0x20D4A0C8, 0x893C20DC, 0x2C65FB4D, 0x9283F389, 0xA64DD8E2,
            0x61033F21, 0x8B3E2D33, 0xBDDC7A6F, 0xE9C117D9, 0xFF35BE8C, 0x2D4FB69F, 0x5FF6A326, 0x6930DAB6,
            0xC585FC15, 0x69E7D23F, 0x8CF15678, 0x284DA0D0, 0xF8A90E69, 0x66C8DF04, 0xD8C13B32, 0x1BC22203,
            0x64D34891, 0xEA73E050, 0xCD657FC5, 0x22481AB7, 0x73B001CA, 0x624C8F0C, 0xEC3975A8, 0x6D87B521,
            0xBEB7C1BD, 0x9AB5093D, 0x8145299D, 0x10D2DD76, 0xE289B7FE, 0xBD000BAA, 0x21B30225, 0xC10D2224,
            0x092D54CC, 0x5A72CCE0, 0xB45EFBD7, 0xE24C20A7, 0x1A812334, 0xA005CAE4, 0x9B14BAC4, 0xEE0A6333,
            0x2C8BC3BC, 0xE5B8CDE0, 0x1F210B43, 0x34227E63, 0x2A429D8B, 0xB0106923, 0x27FC10C3, 0x4AB37D40,
            0xAF54FA79, 0x5F57444E, 0x185D6EFF, 0xFF268398, 0x52E3162C, 0xF2C03FF8, 0x413761D4, 0x5077EC67,
            0xEF6152E8, 0xBE705BCB, 0xB51CD68F, 0xC618C7AC, 0x38589C00, 0x08270340, 0x4F2F1CBF, 0xF70D1B1F,
            0x3973ACD4, 0xB1850089, 0x70F591CB, 0xE9493546, 0x6040BBC1, 0xB9A0B5A5, 0x09DA6B15, 0x43D68D2A,
            0x9E08F78D, 0x84084411, 0x975F40FD, 0x56E57D8F, 0xEC93FF4A, 0x65EC8B98, 0xE703F43F, 0xD174035D,
            0x8577D789, 0x3069A741, 0xE9B85AED, 0x4B27EE97, 0x63030C0E, 0xED9E59AD, 0x3BADEC17, 0x2D532516,
            0x14D5D7AD, 0xEC22B839, 0xA931BFBE, 0x0AE061B2, 0xA1688F3E, 0xAFCAA9D1, 0x65EEB7E5, 0xD99C5B78,
            0x9543F455, 0x21BB85C4, 0x4D5A1D8D, 0xDD3775CF, 0xA5042272, 0x61B70B92, 0x8D3D36D6, 0xF4881A4F,
            0xE83415BB, 0xBEC90CFC, 0x1E9C2E27, 0x71D4F4BC, 0x0C277121, 0x7DBC6BD2, 0xB2A31933, 0x3174AFD2,
            0x2DDA074F, 0x82CD7F49, 0xCA5AD6CE, 0xB82E9D0B, 0x30413ABE, 0xF7B94BF1, 0xC583E8FD, 0xD0CC27D0,
            0xF249E081, 0x9B67143A, 0x5A246236, 0xADAE40BA, 0xF5DE6C6E, 0x7D590376, 0x2477E40A, 0x64D45C69,
            0x1636330A, 0xF34BDECE, 0xB7B4743F, 0xC5A888E9, 0x23AE067D, 0x29C81930, 0xF2FBF5D8, 0x85F3D0B2,
            0x1DAA704F, 0xD978997D, 0xB160F052, 0x9339D7BD, 0x0DA2F085, 0x7B965E5E, 0xC18D389A, 0x9AE62B3A,
            0x7FF37796, 0xE969E523, 0x086300CC, 0x590C49FE, 0x51794BAC, 0x5AA5A4BD, 0xFF71E427, 0x7126D54D,
            0x8126F5AE, 0x0D959F44, 0xB2F72987, 0x0738061C, 0x55E0CAED, 0xFF68DE8E, 0x638F7537, 0x6FD660AB,
            0xC91959F6, 0xDE2C3F67, 0x84C4BECD, 0xE5215B63, 0x085B08D2, 0x598F8ADF, 0x5961870E, 0x54795AB4,
            0x2524C766, 0x5029C901, 0xDE64DCC4, 0xBF0EEAEB, 0x10057647, 0x33F51863, 0x9A9B30D8, 0x2DB6BEAC,
            0x90ECBC29, 0xECBF9266, 0x00F63EE9, 0x1445E654, 0x5B99C7C0, 0x49E38675, 0x8571923E, 0x9BC4F713,
            0xEDCB15A5, 0xF0458606, 0x18F5916C, 0xAC27C719, 0xAE1C42AC, 0x0A30ED8D, 0xDD7B3D3B, 0x36BA80D8,
            0xD63BC6C9, 0x92B53963, 0xD6C6B857, 0xEA4BF97F, 0xD89D3900, 0x6118E9A2, 0x9393FD45, 0x0E8A9C2A,
            0xA5BE6088, 0xAFC3CE50, 0xFE18C695, 0x9D7AF7B3, 0x0B1EFF00, 0xB100DFD1, 0xA849FBBF, 0x0FAC5ED8,
            0x948C4220, 0x35400846, 0xEAC182AC, 0xD068641A, 0xF2F13670, 0x69E7F008, 0x0C4261F8, 0x78C1CEF3,
            0x08788C19, 0xAAB58E6A, 0xF60FFB5A, 0xA5700CF1, 0xD3C5D24E, 0xA45671C3, 0x2B33EE90, 0x6FC85379,
            0x7A00C413, 0x7B452D40, 0x88009B16, 0xA5B34424, 0x8E611BD0, 0x2DB707AF, 0xD2EE0631, 0x0BF3B337,
            0x94CED8E7, 0x8467DC9D, 0xB9E38D7E, 0x0E33EB9D, 0x19A8C808, 0xB0A0BDE4, 0xD3684C09, 0x860292B7,
            0x2FFFDA66, 0x59DAD5BF, 0x6C36CE0B, 0x46A22858, 0xC85506FA, 0x9EFDBBBA, 0x2F6A5E9A, 0xB9F09A6F,
            0x75126552, 0x1DA8B83C, 0xB8CBF456, 0x61BF80D2, 0x975AB502, 0xED74B3B7, 0x298AA092, 0xFDF7E5F5,
            0x275511FE, 0x37C82132, 0xE1EE4FC3, 0x29F238C2, 0x9EF0A820, 0xA2313534, 0x5816F2B6, 0x9FD4AE1E,
            0xD20093C5, 0x27ADE9B4, 0x441AFB32, 0x0361B298, 0x0300D672, 0x200200FA, 0xC23F8565, 0xFCA18E77,
            0x606B81D7, 0x7F5BEDF4, 0xF0AB4305, 0xEB15DD42, 0x0A9BC620, 0x3ECDFFF8, 0xF3CEE6AB, 0xF3F45790,
            0xC857EDC6, 0x31E36B1D, 0xCB475B74, 0x62B6725F, 0x4A6FFBF9, 0x00A7C7AA, 0x5EA177A0, 0xA5DD709E,
            0x86417020, 0xE9BCCD5B, 0x74D6EF67, 0xBBC3C8D0, 0x01F8AEE2, 0xB2C37111, 0x3E8A2298, 0x51A64F11,
            0x7DE26211, 0x6B140E81, 0x482CD7B6, 0xB7A3E3D0, 0x1D880D8F, 0x90853D02, 0x319D6BC6, 0x795FE16D,
            0x17100FB6, 0x0D9DA099, 0x00A4856F, 0x78607897, 0xDD6EDA2A, 0x54D2E3EF, 0x890B3134, 0x8FE2AC41,
            0x75D24BBE, 0x41336E77, 0x859FA6CC, 0xBD09D89A, 0xFE023418, 0x96F17786, 0x30D34AAF, 0x52051E0B,
            0xAC9CF3B0, 0xB02A2605, 0x299BB609, 0xF1C2D522, 0xEBCE4087, 0x5F9F6E77, 0x6AC62C8F, 0x0D71B8D1,
            0x352BBE0F, 0x2EB7C4AF, 0x91BF87F3, 0xB9FFF6A6, 0x1BADB0C6, 0xE7CC731F, 0x4978914E, 0x37E11D51,
            0x3EA9924D, 0x196B9BC0, 0x2A73F156, 0x0ABE8492, 0x10CCB8DA, 0x486E2C54, 0x1E2DB280, 0x08F40C22,
            0x4F9C0B43, 0x9BFFD828, 0x9E3C3AAE, 0x843888F2, 0xECA63110, 0xF5250BCB, 0x097DBF36, 0x3F66D03E,
            0xF7589161, 0x400E9262, 0x17214EEE, 0x234518E1, 0xAA12EB94, 0xB7E2DF40, 0x72177861, 0x8A65237C,
            0x6E36DD7C, 0xB3E7F4B7, 0x4985B1BC, 0x41783AF1, 0x84CEA86B, 0xF3471E5C, 0x01BBDF02, 0x5FFA341E,
            0x2E51C4B2, 0xDCFA4508, 0x5336A1A9, 0x22DD354E, 0xFD49A4C6, 0xD7DEEAC4, 0x75F037E3, 0xDF3E5E45,
            0xBDDA0EAD, 0x016091FC, 0xA2C4B817, 0xC6B5AB91, 0xBA8FB018, 0xB4A0DC05, 0x51815486, 0x904F9360,
            0x2100106D, 0x782F4286, 0x0DA75965, 0xD435A40C, 0x8514F1F6, 0x38989BDC, 0xD8E5F1F3, 0xF5E20CEC,
            0xE1530C7D, 0x3594F378, 0xD58336A3, 0x8C9B6CF0, 0xBEA743D7, 0x5CAF8FCF, 0x224DE4EF, 0x46693B20,
            0x99E5D44C, 0xAD8F2EE9, 0x898C82E8, 0x545DCBAF, 0x791CD917, 0xAE87A774, 0x74589A36, 0x8184A8C2,
            0x4886BA53, 0xC2E960AA, 0x0B20807F, 0xB4BB9435, 0x41D29611, 0x01ADC965, 0xCD92E405, 0x848BD1BB,
            0x90FFF57C, 0x175AD504, 0xFEED8ED5, 0xC2E276F4, 0xB0206296, 0x8E6AB609, 0xAF637B78, 0x0156C760,
            0x19DB429E, 0x4877A3A0, 0x2627C6EE, 0x9F46A543, 0xB308EAC9, 0x75A29309, 0x2B2A3425, 0x9E047BFC,
            0xACC080B7, 0x6C4A4B43, 0x0FC4C3DB, 0x69655E29, 0x57D1EEFA, 0xA4595F4F, 0x78A9A63A, 0x6FE2844C,
            0xC9551DE5, 0xF23867C9, 0xD1E8FB54, 0x52F46E93, 0x8AB32FDC, 0x1C4D3174, 0x55F583F6, 0x74BEA6E3,
            0x9BE00151, 0xF4A0A9AD, 0xA39BE71A, 0x58340796, 0xBDD5C985, 0xF6B5F6BD, 0xB210C908, 0x0060F944,
            0xBC1F0EE4, 0x1751E7A8, 0xB301A956, 0xBCC1313F, 0xEB88B152, 0x0EAD514F, 0x23FEB630, 0x11860585,
            0x9A6CD868, 0xB79EAF09, 0xF0077BD4, 0xA9511235, 0x7CF3B165, 0xC8D4D937, 0x34E73DC1, 0x53222BDE,
            0x2EC2450F, 0xF6D43EB6, 0x26A105C7, 0x55593866, 0x31653CC0, 0x30AF347A, 0x22DC6457, 0x9D12EE61,
            0x72AD4A0D, 0xFDB8DC86, 0x95AA43D7, 0x7B52C816, 0xDC7CD770, 0x090CEC01, 0xBD7EA5B4, 0x98A1D22A,
            0xA256D1B5, 0x83AFCD8E, 0x95FA4B0A, 0x0857D66D, 0x45F560CC, 0xD35BD23B, 0x1A1AC332, 0xD2EBA33D,
            0xF17CDE19, 0x4062D941, 0x8F2E54AB, 0xDD453B20, 0x6024D45E, 0xEB2A3AA4, 0x67FE066E, 0xEBD7C200,
            0xCA800629, 0xD764DD25, 0x0F68E94B, 0x4266029B, 0xCA5E2C5C, 0x94CA84D2, 0xD590B2CB, 0x31FC02A9,
            0x4F7975A8, 0xD4040BF7, 0x86555001, 0xB17B1D22, 0xD79BA15A, 0xB5B2B67C, 0x721C19DE, 0x375262B3,
            0x0C42BCB2, 0xF87D3521, 0xA3D9DEE3, 0xA0A8664C, 0x2F14E330, 0xCC529CD4, 0x83B6ED69, 0x502756B9,
            0xF6FA3546, 0x74487314, 0xB9F0849B, 0x93F95B56, 0xACD7C513, 0x4D66DFB0, 0x8B76D0EF, 0x36A11D8C,
            0xC0B6C40B, 0xAE74BC8F, 0xE0CF821E, 0xAF0E1022, 0x4F8005B9, 0x4E09920C, 0x22807DFC, 0x0867C39E,
            0xA5507BA3, 0xE9CABA0E, 0xB792C3FC, 0x0EB480B1, 0xE100A3E4, 0xFC25A592, 0xF9799104, 0xB70AA82E,
            0x5BC7ED08, 0x0D7B3B51, 0x50442AA6, 0xEE1C5DF1, 0xF97EEF82, 0xF54C07C8, 0x7E6BEA65, 0x14716A31,
            0x5117A4D7, 0x3E7E1F86, 0xE0C8C156, 0x2885A5A1, 0x0731FC58, 0x60F04FF6, 0x0212BE76, 0xF8285A89,
            0xECBFFB2E, 0x3295A2D3, 0xD996B844, 0x38E0A1B1, 0x9223EC7F, 0x3554ACCC, 0x8CB2C082, 0x81352A56,
            0x3CD23AAE, 0xC3A8436F, 0x41D48A54, 0x021547FC, 0x39A6830E, 0x28665CBE, 0x495760F6, 0x8B6262B7,
            0x0DF5F3A7, 0xDDE9D533, 0x5CC23343, 0x19F38911, 0x971A62AF, 0x82660D49, 0xB0C59E27, 0x5111D28B,
            0x658FE11D, 0xA448E98D, 0xA2E92ED2, 0x48C8769A, 0x23C7F33F, 0x5EAA4D06, 0xA8A3505C, 0x3F176525,
            0x4EF7F442, 0xDEA81DDA, 0x8E80986E, 0xF58BC79A, 0x2EB154CB, 0x628A51F2, 0xBD5CA9F8, 0x604E7311,
            0xB74B65B3, 0x1BD184A9, 0xFDE3710B, 0x254B1BD7, 0xD55BB251, 0x5FB6EE7F, 0xEAE7CABE, 0xD38F62A8,
            0x17CE55A7, 0x2E0324DA, 0x5A0EC672, 0xC725BF69, 0x9419DD9E, 0xFBC1769E, 0xE61FFA1D, 0x4B56FD36,
            0xDA9829B6, 0xE3BCF1EF, 0xEA9EAF8F, 0x8F3C88E0, 0x67A93AAC, 0x69DF0853, 0xDA7F02E1, 0xE8AA6E31,
            0x781F1A5B, 0x4A51E22D, 0x5E160982, 0xCF5F1255, 0xAC3D6AEC, 0x0DBDE971, 0xACCBFE7B, 0xFB3CC4EA,
            0xD7C5F5A5, 0x01E327E8, 0xFAA74E7A, 0x9A58928C, 0xC3446B7F, 0xF23A45E6, 0x03B77B48, 0xC10C7A3A,
            0x1316A4AA, 0x644A7128, 0xE6CA39D5, 0x8104696D, 0x1AEBC2ED, 0x7F647CF1, 0xB740E1BC, 0x9F16AA0B,
            0x7E6847DE, 0x2511C4BA, 0x5458D030, 0x660D73DC, 0xF5BC3D0E, 0x4E1BD292, 0xF82C49D8, 0xC807C32F,
            0xF78506ED, 0x04F4B17F, 0x92372605, 0x8DF48B3F, 0x394B9581, 0x7FD23404, 0x3DEBE13F, 0x31E6DB74,
            0x07709235, 0x81C94210, 0xF6F5F78C, 0xDFB8A29A, 0xF06E6970, 0xB4EFE4D2, 0x5DFFBFB5, 0x817ECE79,
            0x8CAF8670, 0x3C027915, 0x7B599792, 0xDB5457D1, 0x3B5E43BA, 0xFCDF169E, 0xB749F494, 0x54AE6E15,
            0x22D8AAC2, 0x3AF45B5F, 0xCF54EEE0, 0x9B75E493, 0xDDD5A636, 0x99B7B320, 0x19EA1C51, 0x28DCBA98,
            0x90A5F2FA, 0x6FD3501B, 0xC8A0B8D4, 0xA384D559, 0xD5F163EE, 0xAD973562, 0xA5024E33, 0xE84C7EC9,
            0x788141C4, 0x8778D69F, 0x8EFFB337, 0xE9C656F2, 0x8C16DAC4, 0x8FF5E8FD, 0xA62CE305, 0x8804D4C4,
            0x6E284933, 0xD3DA9F24, 0xA15A9437, 0xF9F6A93F, 0x253CEAFE, 0xEF6E6117, 0x8FEFC8DF, 0x21853BD2,
            0xEE8A8778, 0xFF9C8175, 0xECAFCC41, 0x81430456, 0x65137E77, 0xF12F20DC, 0x49D1C352, 0x216728B1,
            0x2661CA94, 0x05731602, 0x0AB91AD8, 0x67392511, 0x8AB17259, 0x0C9C38BE, 0xEB49E60F, 0x81FECD5E,
            0xDBE64435, 0x4CA8F055, 0xCF9DC98C, 0x9733BACC, 0xDF015D69, 0xA0B63ED2, 0x8469739D, 0x315A059A,
            0x0C95FF2B, 0xF22F5AB8, 0x220DF863, 0x46E6588E, 0x68B00B7F, 0x0FDEEAB8, 0xBBA2C801, 0x58476F32,
            0x077470C6, 0xFC928398, 0xD9F83196, 0xAE4B321D, 0xBD1F695A, 0x9F99E1E8, 0x5EC2CE67, 0x6464A227,
            0xB3EB46B8, 0x09A3731E, 0x0B23C5CC, 0x7B3DE7C5, 0xF105B458, 0xD42C8742, 0xA7EDBD26, 0x205AAAE1,
            0x701F839D, 0x6043019D, 0x6872A0E4, 0x7044B677, 0x6441228C, 0xA2D989AC, 0x353ACD3B, 0x3625FF06,
            0xDCE9998E, 0xCE3541CB, 0x5A5DBB95, 0x5795EF42, 0x56930A57, 0xD24F1CD4, 0x706D35BA, 0xA0DE802F,
            0xB1CBE0D1, 0xA3BDE376, 0x48257D9F, 0x4E83FBA5, 0x11903726, 0xF5FBB37E, 0x871310F2, 0xD8A8377E,
            0x324ACC26, 0xB81A59ED, 0x36C37486, 0x98A3AB54, 0xA70A0D88, 0x9DD7FBFA, 0x1740D20A, 0xBB4EADCB,
            0x896B1635, 0xB8A403D3, 0x82A5ECEA, 0xFF60032A, 0x7A25FDF8, 0x03667E39, 0xE663472B, 0xC1A6D94A,
            0x8C9111D5, 0x7C8196A8, 0x25D0A7AC, 0xBD983304, 0x41A689F0, 0x5A47F2F8, 0x4D5E2540, 0x3D27BAE7,
            0x90D885FA, 0x102E748E, 0x9F98548F, 0x367BB6FD, 0x91852A8F, 0xD1AA0299, 0xE8964273, 0x38871252,
            0xD6F0BDF2, 0x2DE14B8D, 0x09FCF84B, 0xCC43C491, 0x4B69F356, 0xC5E4F4F0, 0x8462B20E, 0xCC2D2A2E,
            0xE0C20246, 0xB82D9626, 0xE3C03BE5, 0x532E5C6E, 0x6F0C3AA2, 0xC937A233, 0xCB807232, 0xF342FB8A,
            0x761CFAE4, 0x55EBAA86, 0x45015743, 0x6E8CF053, 0x1DBF5A66, 0x32A28368, 0x47C12E50, 0x31DF83FD,
            0x96F77BB5, 0x5AA793AA, 0x70449A1B, 0x91B9049C, 0xBB0BD8F6, 0x90BBA2C4, 0x381C136F, 0x137EE968,
            0xD344877C, 0xE4955C8D, 0x4308BE77, 0xCE6C366A, 0xCCCF07C2, 0x2D03F17D, 0x5611A671, 0x5D79339F,
            0x4C8912D9, 0xE2B2D956, 0x32890ED3, 0x20B8BFBE, 0xADBEFB3C, 0x1FBE6CD2, 0x9282307A, 0xB36FA32E,
            0x30C9C43C, 0x2F1496EB, 0x618C8D91, 0x2A2E6F8B, 0xBE082E62, 0xA7860797, 0xD1B8CC82, 0x2DAE1E7C,
            0xEFC618FF, 0xE36BF6C3, 0x7837923C, 0xFE22F0DD, 0x740AFC0A, 0xAC0A2599, 0x91B923E3, 0x5160E22F,
            0xD444BFEA, 0x23C06CFC, 0xE95EF942, 0xDDC1B721, 0x71002481, 0x1C94C610, 0x43DF0A05, 0x4BEBE067,
            0x266433F2, 0xF67CE2E2, 0x9C3D2B7C, 0x42FEC7CB, 0x6D014E34, 0x7DC586D5, 0x318245B7, 0xD41AF056,
            0x6FF3E96D, 0x770422C0, 0x98766916, 0xCDE57D3B, 0xB6C1BE66, 0xF2364985, 0x62372E63, 0x872D60E2,
            0x6EF3EA92, 0x2694BFF2, 0x845167FD, 0xC921EA69, 0x125A65FD, 0x35698BCD, 0xFC577CC0, 0xEA87FC56,
            0xAE9139E5, 0xC769B16B, 0xFE04F6DF, 0x88FC055D, 0xEE0E67E4, 0x79AF3758, 0xE3F42840, 0x724C726B,
            0x42C3D002, 0x689B199B, 0xD85F157C, 0x00ED61C8, 0xB825346E, 0x0260BFBE, 0xEB251A41, 0xE435A104,
            0x7BAFAA63, 0xACD27E9D, 0x75B01710, 0x76FD831A, 0x771722F8, 0xAAFBFF0D, 0x0B6EEAA9, 0x7275F5ED,
            0x2B1CF7DE, 0x6463D9A0, 0xAD17C0A8, 0x626B7EBB, 0x8D8FED16, 0xF2DDA675, 0xCD5F7105, 0xF5B448E0,
            0xE84C7891, 0xB12E11DA, 0x90A37D9D, 0x2EC52E11, 0x5662D69C, 0x61F1ED4D, 0xCC18A028, 0x979BE3CD,
            0x0D906DCD, 0xC6BCEB4D, 0xCE2845EF, 0xFFE1874C, 0x0CECE9B7, 0x21482DDB, 0x1D811179, 0xC22AE7E9,
            0x9217365F, 0x9B21F07E, 0x3D354BD7, 0x8F6CF900, 0x991429E0, 0xC7D17E10, 0x24617EE6, 0x650A1948,
            0xA0E4EB91, 0x3FEA642F, 0xB688354A, 0x7F6E83B7, 0xB570665D, 0x8564161A, 0x1CD55B68, 0xA289AC1B,
            0x37E02D35, 0x123C5AD2, 0x24009414, 0x78B86A73, 0xF9229FE6, 0x1520FDEB, 0xEF3BA9F5, 0x1FFF9560,
            0xFF787FD2, 0x9DABB4D8, 0xCA0EB7A2, 0xAFCCB4E4, 0x1662E6DF, 0x22BCEA71, 0x3863E565, 0x20ADC837,
            0xF27BB061, 0xCDE7CDB0, 0x86AF9A16, 0x0695509B, 0x2C3C0880, 0xA954A375, 0x9D08292A, 0x6A609471,
            0x23AF5DF5, 0xE7BDB495, 0xF7F8B1B5, 0x41D17E94, 0x340BB650, 0x7DDAD380, 0x75582CA0, 0x74A63B68,
            0x0F6BEB6B, 0xF62C92B2, 0x7397138E, 0x69EB31CE, 0x6902D6F1, 0xACA3DAD1, 0xCCF83684, 0xBC583682,
            0xD51D52EB, 0x2DBBE3EB, 0xD29A1469, 0xD32647E4, 0xD46A5677, 0x3EA48CA2, 0xC72F5E79, 0xBE20C413,
            0x8290E102, 0xA658C437, 0xAB37AE92, 0x0B5CE2F5, 0xB9A585E8, 0xBD13285F, 0x0D30B8BB, 0x5D2B5C99,
            0xB1587A95, 0x58B4EE34, 0x70678B38, 0xF24CCFBA, 0x0E8A878A, 0x4D558335, 0x5DBE34A4, 0x3EE25C08,
            0xCCD8A0C0, 0x98D56FAF, 0xF9FA2C29, 0xE2B00A2B, 0xF76D8F30, 0x788195D3, 0x291EE124, 0x1142BD0F,
            0xB69C79C7, 0xE486ABD6, 0x175E8E1D, 0x16382E1F, 0x420D2984, 0xAB2FDA6D, 0x8F700473, 0x054B17C5,
            0x00778C26, 0xBC1C7C55, 0x2CEC569F, 0x7BB27C69, 0xF78E46A0, 0xFEA71F3D, 0x94A92DFB, 0x394D2872,
            0x76B486D9, 0xD8CB0F5B, 0xF42BB409, 0xB3F62D13, 0x902B87A3, 0x09A2C0D6, 0x8261DB14, 0xDC0D22F1,
            0xFEFEFCF4, 0x0508369A, 0x0BC6EEA6, 0x92B93470, 0x9B6EBB22, 0x03DB9872, 0xC122E5E7, 0xDD590596,
            0x24B42E1D, 0xB1933B3D, 0xB45DF46B, 0xAF4CA100, 0x0712D945, 0x9E680122, 0x648F9884, 0x8F31A833,
            0xB8037496, 0xB8E9C1BA, 0x8C2AB9CA, 0x12147357, 0xE756DE35, 0x499827F1, 0x0F91953C, 0xBCF78B52,
            0xB01C1165, 0xA6D088C9, 0xE1E17B72, 0x03F5857F, 0x6677864A, 0xB3EBD8FC, 0x97372B01, 0x34A6164F,
            0x47A5DDB9, 0x37D0DE7B, 0x4C520AB9, 0xF2302FE9, 0xE6E778FE, 0xFB575E27, 0x47901AF3, 0xE7FDB120,
            0x0B3419B2, 0xE3F387B6, 0x3F6B2C45, 0x9759E626, 0xD00F5014, 0x0AE0A22F, 0xE5D64885, 0x35C33B27,
            0x07A018A7, 0xD7C02265, 0xF314154C, 0xB1C1EEB2, 0x05DE2D7D, 0x05943245, 0xD1FA6C88, 0x07D460F9,
            0xFA5C643B, 0xA75EAC62, 0xC1FB4AE0, 0x3FF805D6, 0xF2C4D92F, 0x185309E9, 0x5319ABBC, 0x912485A7,
            0x69089193, 0xE39CFFCE, 0xCD9BCF55, 0x30004DB8, 0x8C3CDDB1, 0x82969B5A, 0x86A49FD4, 0x9FFF6AE5,
            0x1F5BF0C0, 0xAC8B630D, 0x1E6548E2, 0x197843FD, 0xAB0E3B6D, 0xFF785AA7, 0x5F9F0163, 0x54D56B12,
            0x8792A30F, 0x1F599824, 0xC7208248, 0x5F795CA3, 0x35AAE6B4, 0xE35B6871, 0xE4FCDF9D, 0xB30FCD8D,
            0xDA69F290, 0xDD13F140, 0x305EDA75, 0x0FBF56A9, 0x5DB69376, 0x9E474B88, 0xB6AF09E8, 0x8738D541,
            0x0BCB723D, 0x4FA113B1, 0x3A2CE322, 0x514C96C2, 0x77014988, 0x5D5B5CF7, 0x5FAF184E, 0x1AB9373E,
            0x36FAF388, 0x801177FE, 0xE64C33A6, 0xA516D0D7, 0xBC5F5990, 0xE6F13821, 0x182F54C5, 0x9A26E288,
            0xC062C31B, 0x7946B7B5, 0x4A2D4C5F, 0x134220C7, 0x85F3794D, 0xD318B8C2, 0xB2ED6369, 0x6D43AF1E,
            0x30CA8DCD, 0xC6D113DD, 0x0A25D0C8, 0x4501F5BE, 0x605C975B, 0xC0FCF948, 0x88BAA059, 0x26B4A1D3,
            0xCF2400C3, 0xBE8B1E7D, 0xE07D25D4, 0x853E53B9, 0xF3298B4B, 0x66CD9C28, 0x7E301679, 0x551C916E,
            0x09EE1177, 0x5E843C7F, 0xC9051D1D, 0x5A67A978, 0x4BA57AB0, 0xBFA3DD75, 0xBFF5BE8E, 0xFC41CE87,
            0x8C7CEB48, 0x39D04670, 0x807C0FE7, 0x94025976, 0x995EA2E1, 0xB393909B, 0x7BB083C1, 0xAEDD68C6,
            0xE3D945FB, 0x5019E429, 0x195AF432, 0xE25174E2, 0xA95A918C, 0xC9682F01, 0x261FF32E, 0xA6F97546,
            0x3658CEF2, 0x8FA02E3B, 0x85144015, 0x26B24367, 0x39536001, 0xE090BBDC, 0xF9861ECB, 0xEAAEE313,
            0x8745F730, 0x1C8563DE, 0x0BFEEAB6, 0x6910ECE0, 0x42C16D25, 0xD5EC7C92, 0x7FD09E62, 0xADEA1253,
            0xE95039AE, 0xC07EFEE6, 0x767462B8, 0xD626BFEC, 0xB0013915, 0xEA88AC61, 0xFCE29355, 0x61DF9677,
            0x2FE62990, 0x35F4ADEF, 0xB78B941F, 0x8BC78959, 0x47DF7C1D, 0x44275F6F, 0x0ECC1A6E, 0x6ED9090E,
            0x86948C95, 0xE4BF5852, 0x746165E2, 0xCAE6823F, 0xEFA7F479, 0xC88FB067, 0xC77108EE, 0xD7960AD3,
            0x681A05A9, 0xCFE00C8C, 0x313F9BD9, 0x63FD3170, 0x9FAC6AD7, 0x8C1BCF1B, 0xCFA1152D, 0xDB5FC444,
            0xFD0985EC, 0x8CBFD63B, 0x3C3A1E77, 0xBD8B328E, 0x7C1502FE, 0x6A9F93FA, 0xA7A469A8, 0x00D058C6,
            0x5C86E51B, 0x5AFEFF95, 0x27C45CAB, 0xCAFC4DD2, 0x31A88773, 0xD9F3F90F, 0xA2213DE8, 0x3103E96C,
            0xABE93D84, 0xCD31747C, 0x273DE59E, 0xAA93D595, 0x696BE22D, 0x7F18E002, 0x515364E6, 0x6CFD1109,
            0x003D0816, 0xF3655AEA, 0xE694A617, 0xF2B3FECC, 0xA8B6B5F1, 0xEC157672, 0x11B816F0, 0x37C90983,
            0xD9F2B5B5, 0xE742EA0E, 0xB2C42499, 0x6E98D437, 0xD7AF7E54, 0x6DCB146F, 0xD9B523E2, 0x6C403F03,
            0x4045B51B, 0xC33A56BC, 0x72C1F1DD, 0x477D3E2F, 0xD02798CE, 0x2B9500BA, 0x7D489549, 0xA98CB978,
            0xC81BA396, 0xC3C6C881, 0xDFE1A715, 0x7E579CD7, 0x5E6C425C, 0x2096CFF2, 0x2931599D, 0x72AE601F,
            0x3C5FC3D7, 0xF8D08666, 0x60E99822, 0xA6C88C7E, 0x7F444BBF, 0x04B60BDD, 0x2F13171C, 0x2BF2BDB4,
            0x4B536A38, 0x5743DFE1, 0xB08D938B, 0xFFE9BAE9, 0x9D2C37C0, 0xA5E7CD7E, 0x09836341, 0xE3AFE1FF,
            0x9CF8502E, 0x4339910F, 0xF1A7605B, 0x38718DCD, 0xC45DE3F5, 0x6D405A0D, 0x25826356, 0xEEC951B1,
            0xAE32FCC0, 0x626ED1E6, 0x5545E0D5, 0xD2A4D546, 0xF4BC8939, 0xE90617A0, 0x51965D41, 0xD8BC167E,
            0xE6C58145, 0x0EFBADC2, 0x610FB863, 0xC6B9932A, 0x5BDD5646, 0xA421C2D6, 0xD33F6C3D, 0xF11632EC,
            0x14DAC87F, 0x89A67E80, 0x80D95BED, 0x0AB2DEFA, 0xDDD3E107, 0x4FD168E8, 0x7051A6D7, 0xE1E2A6AC,
            0xC18039B5, 0xCC73E862, 0xD2A32315, 0xAA7118F9, 0x58113F97, 0x347B7064, 0xE9824DCD, 0x0ED781BE,
            0x2A62368C, 0xA8346901, 0xB780F9EC, 0xF110D917, 0x219ED54A, 0x36C6A426, 0x9BACCDD7, 0xA95B2D54,
            0xF3022A7A, 0x80F01759, 0x7BF00239, 0x77F38031, 0x048218D6, 0x51FF68EA, 0xEDC12E68, 0xDFD438E9,
            0x437DF6CD, 0xD5DCAA76, 0x2B7DE1EC, 0x037BF58F, 0x02316E55, 0xFBE44996, 0xF293559A, 0x1D015C96,
            0x00A035B3, 0x773E2FFF, 0xA2467395, 0xBD81930F, 0x6CC76894, 0x23A22F63, 0xCE843C5C, 0x02E35E68,
            0x48402D62, 0xC47EB887, 0x89182A19, 0xC422FA9E, 0x41AA7099, 0xB8A4A6AA, 0xAA2A0340, 0xE845474F,
            0xCF63D721, 0x3A80D386, 0x15506517, 0x1CEEF037, 0x584114F2, 0x5B833877, 0xF6987E86, 0x5910D9D3,
            0xEC338357, 0x49648970, 0x9EBE42EC, 0xB126011F, 0x235FA379, 0x0B0B0914, 0x8BD96423, 0xA97CCC2F,
            0xD16C68B0, 0x5BB9C11C, 0xF2C5B6F6, 0x0BD68EC9, 0xBFEEC5E7, 0xABF16DF9, 0x6F740CCF, 0x75A356CC,
            0x93CBB627, 0xA460F8B6, 0x01314EA7, 0xF2150F48, 0x28B1EC6F, 0x0BD0A779, 0x53D50F97, 0x901E5BAD,
            0x4BC7596C, 0x06D5BD20, 0x34B74941, 0x652BADB2, 0x7AA0D780, 0xABA79F3B, 0x69A0B1A1, 0x3D2661E9,
            0x1AF783E9, 0x00EE6CB4, 0x439C0F15, 0xAB24FA28, 0xBFE3EE27, 0xFEF7FEA2, 0xB7AC880D, 0x7CBEF749,
            0xF5CA8CF3, 0xE2D05868, 0x8D6A822E, 0xD28DC59D, 0xD8C35D9A, 0x5DCCFD1A, 0xBB36B20E, 0xEC49EC4F,
            0x738866DE, 0x1C7D6547, 0x8F4D310F, 0x75A5DA34, 0x976E37BD, 0xFB742DAF, 0x816E348D, 0x0DF88809,
            0x17C5D267, 0xCBF362B8, 0xFCFACF28, 0x635196AF, 0xE8F75AD5, 0x96ECC828, 0x39A6093D, 0xFA4A9FC4,
            0x1517BE4A, 0x5F145C5C, 0x9910045F, 0x494B46B4, 0xD7DB5A2C, 0x984BC2CB, 0xAA208426, 0x03EE65B8,
            0xD2496F55, 0x727AB14C, 0xE660F010, 0xAFD1BF1C, 0xB8036FC5, 0x5FF4D4DE, 0xCF150C51, 0xD8EDD1C9,
            0xEBC76B69, 0x8D6BF4BE, 0x8203F74D, 0x01BFB443, 0x2E905D83, 0x1D59B5E1, 0x26233850, 0x1B7EFE6F,
            0xE7BFC9A7, 0xDE49E6AF, 0xF8CBDE86, 0x6243AE22, 0x261FBDC0, 0x49C40A64, 0x606A48E8, 0xE63AA47B,
            0x9FDB4B23, 0xF43854E0, 0x9B137076, 0x5F0993AC, 0x18D345F0, 0x8404B261, 0x7C712EA8, 0x263F7EE8,
            0xEFA6C5C3, 0xC3202142, 0x4E412AAE, 0xEEA746D3, 0xD953BDAF, 0x11C8DBEB, 0x0C26172D, 0xEFF15DB5,
            0x2981E52D, 0xC8C56C3D, 0x1EED0D26, 0x9AB8E984, 0x9AEA710F, 0x639F25DF, 0x36DCF73E, 0x8EF84C26,
            0xB83AFA68, 0x60710ADA, 0xE5E27AEF, 0x860A996C, 0x6C1E745F, 0xEBEC5938, 0x200F1F08, 0xC48238A0,
            0xDEDA97F8, 0x2DDE6F57, 0x363F7593, 0x51799A72, 0xB01AAE2B, 0x79AD7FD1, 0xC2A70853, 0x56FEC56D,
            0xF617FA9E, 0x6D0D7144, 0x34BFFEA8, 0xDDC30B1C, 0xC39D8B6C, 0xD43E45FD, 0x4AF3B62B, 0x13E26ED5,
            0x8A49EE1F, 0xEEEDE292, 0x71C5ED43, 0xB7067560, 0x67515A8E, 0x58E89AFE, 0x3BB6949A, 0x7A4A2D53,
            0xF8B8F1B7, 0x990532C5, 0x7E88C4C9, 0x2DE31B79, 0xFD2C7923, 0x6EF43694, 0x1658E0F2, 0x8FD211F5,
            0x182E5E9F, 0xBEDFFCC7, 0x029A6787, 0x70F93EBE, 0x9740A4F0, 0xACCDFE4E, 0x278AB076, 0x29A8B432,
            0xDF8D8499, 0xAF3A1136, 0x53729922, 0xF1D0B62A, 0x37A794E0, 0x3D54A89E, 0x8D27BD85, 0x65748529,
            0x24BC5AE3, 0xAEB57CB0, 0xD2A1B00D, 0x74BF73F3, 0x767E2861, 0x9660127A, 0x2C5F5A75, 0x7B42F3F1,
            0x28BB2829, 0x8C851F0A, 0x209DE9D5, 0xCC82E032, 0x1690F1A4, 0x9A7D8F49, 0xC237478B, 0x4BF01F36,
            0x4F8B47FB, 0x8278EFDA, 0x849DB61F, 0x6DB7ED92, 0xA586DBD5, 0xBDF9085F, 0x2EAF7E0B, 0x3C371CF6,
            0x257CAE5A, 0xB5DB1DA2, 0x78074639, 0xC2332466, 0xDDEE6E98, 0x4AA5E4CC, 0x51348D44, 0x8741B6FE,
            0xD4B1BDCA, 0x40A7C064, 0xA72603AD, 0x21956226, 0x8FE06D07, 0x32F6E907, 0xAC5B9F32, 0xA6C53F77,
            0x9D2FD3D9, 0xB49FAE59, 0xDC8453FB, 0x65244CBE, 0xF8008564, 0xD083761D, 0xE0E61B3A, 0x64F8223D,
            0x79BE31FD, 0xBF7655C7, 0xFB1B44CE, 0x13AA59EC, 0xDEB36362, 0x3F32D0E3, 0xFBB82A22, 0xEEF1A515,
            0x79D79AB5, 0xF94DC297, 0x596CAE83, 0x19D1A07A, 0x807D90FB, 0xFB92F34F, 0x99261F92, 0xA1B82C25,
            0xF5EB2D5B, 0x9C65D9BD, 0xB310C980, 0x60A69C0F, 0xB31F1E77, 0x662E2D10, 0x274570EC, 0x1D92A9AE,
            0x7278A698, 0xF9B48C93, 0xAF763971, 0x774057C0, 0x95885CA3, 0xA02371BB, 0xB1CE24F9, 0x588E6CC8,
            0x9F647530, 0x3115BF8F, 0x2D6CC5EC, 0xDEB4F019, 0xE53E5092, 0xCE32F05A, 0x1AF457F5, 0xE20BDC3B,
            0x3771FA4A, 0xD0E12FF3, 0x77FACE7C, 0x232E22A9, 0x2DE6080B, 0xB5BDDC4A, 0x142C8ADD, 0x5B7BF249,
            0xF1EFB644, 0xD43DD0AD, 0x3C176820, 0xD3AF9112, 0x29FC359A, 0x318B62D5, 0xB579EEE2, 0xC0CD6D5A,
            0x97FF3F08, 0x06DBF1C0, 0xD12BDB00, 0xDD4A0D42, 0x68380675, 0x130BFC4A, 0x315C4424, 0x14DB5170,
            0xFE04DFA0, 0x52E5CDDA, 0x6FB11163, 0x17EB6752, 0xAF24D0D7, 0x5868B33C, 0x6F2ABA59, 0xA9189F14,
            0x6DE42FAE, 0x7CBC3407, 0x07003E6C, 0x4A4CB63B, 0x5B971417, 0x74152DB1, 0xDE6D64BD, 0xC60175D4,
            0x66E9ED4F, 0xFCAB6305, 0x90510DFD, 0x4190AB0F, 0xFF059799, 0xDF65EDBC, 0x6E9E4112, 0xC90BBB21,
            0xC41CFB4B, 0xDFCF416C, 0xF013AAA9, 0x195675FD, 0x35AF9BFF, 0xE3EF0202, 0x59220BB8, 0xB960E510,
            0xC663B361, 0xC79CFF3F, 0x8BB0CC43, 0xAB38C4AF, 0xEDC4417E, 0xFD52BF31, 0xCEFAF320, 0x3C4AFF77,
            0xB4518A4D, 0xE254DA5F, 0xD102D2A4, 0xAE8885D5, 0x8200E0CB, 0x2F733196, 0x1F1CE8E6, 0xBCDB9940,
            0xABE553D0, 0x60FBEA52, 0x6FCDB10F, 0x01AB0356, 0xBA6EA2FB, 0x7BF96E72, 0xCC351281, 0x7D2EEA89,
            0x0625E94B, 0x33307D4D, 0x29E0AF6A, 0x65824D61, 0x6B8CDB81, 0x4B3CAE67, 0xED241C8F, 0x81A88DE0,
            0xF896961E, 0xCA651482, 0xE9295DCD, 0x8FC33F0C, 0x06C59742, 0x3D95D677, 0x7839BF04, 0x448A10A7,
            0x92EC2AB8, 0x7C3D3157, 0x26F255CB, 0x2AF724B6, 0xBF94B0B9, 0x73903837, 0x7474DCA1, 0x343AD2B4,
            0xEDA3E13E, 0x96BC66E3, 0x2800DFC8, 0xD6760786, 0x1CF52EE6, 0x050917BF, 0x3E75E13D, 0x6C732E71,
            0x17C599C0, 0xCB434D25, 0x6E471087, 0x098975D4, 0xBED9A5AF, 0x5389491B, 0x15756C81, 0xA9894A8D,
            0xCE0C095E, 0xDBDE810F, 0x5A3781A9, 0xA0D83690, 0x290184F3, 0x0FA1EA94, 0x230B908A, 0x0591E298,
            0x6F9EEC55, 0xD323A558, 0xD7072D58, 0x08991221, 0xED443EDE, 0xF4B0DDFB, 0xAC7A9C92, 0x1BD5C6B5,
            0x26F2DCD5, 0x4D33957D, 0x32ADE6E5, 0xE57CB76C, 0x76EC8C32, 0xF3BAFD25, 0x04200A5D, 0x9ADA5138,
            0x518A361F, 0x0F40D947, 0x63A80ECE, 0xA0EC76DC, 0x88DB94EC, 0xF77010FB, 0x6A394768, 0xC230192C,
            0xF38AB4A7, 0x57C2CE8B, 0x90DD7FFB, 0x642665BF, 0xFD6006D3, 0x239299D4, 0xC85D011D, 0xA4624271,
            0x8D4E7E22, 0x43A19F80, 0x8D4E3819, 0xCA5210AF, 0xE4A3A122, 0x73D03CAD, 0xF56F2E3D, 0xADE5CB38,
            0x89CE7820, 0x631505F4, 0x72CC576D, 0xF3A27A97, 0xB155DC8F, 0x2BAAA931, 0x83342C48, 0xEAFC4162,
            0x81A127B5, 0xDAC41AA9, 0x9850615C, 0xC588B1E4, 0x3196B2A6, 0x485B5A07, 0x7B2A545A, 0x89E54D02,
            0x0596957F, 0x81EE7BDA, 0x32E5CB41, 0x383FCD69, 0xE71E97F6, 0x2D811547, 0xC2FC9195, 0xAB1DEC32,
            0x6558B1D1, 0xB0A89D7A, 0x2538192F, 0xB3F4E64D, 0xF05EEE5A, 0x27534651, 0xA2ACE050, 0xB033DCFE,
            0x1449F39F, 0x419F4E08, 0xD660295E, 0x3CB0062F, 0x96E4F946, 0x5FD30D71, 0xEA8428AD, 0xE3EE44B1,
            0x85D5176F, 0xB3DE7A14, 0xF0560CDC, 0x5E5D3C34, 0x26593041, 0x9D513BAD, 0xEFAC9E5A, 0x06C26703,
            0x77420F33, 0xA26E6885, 0x90485413, 0xCBADCB9E, 0xDC62EC1D, 0xD1B41B18, 0xC4064A7F, 0x68A9C3F9,
            0x6A9E1FEC, 0xB05117D6, 0xB1113C0F, 0xAF7DAFE9, 0x0F5E694F, 0x93C1F7F2, 0x49C753C3, 0xDA67B769,
            0xC87EC5A0, 0x0E0A01AE, 0x43223EAD, 0xDF37EFF5, 0x88FC9805, 0x25A64953, 0xB64839A0, 0x78463E2E,
            0xA9479F82, 0x08B73433, 0xD5E5FA9B, 0x69BB8286, 0x51B8CE8A, 0xFE670636, 0xF75F583A, 0x093A0E69,
            0x26999F7D, 0x6534F670, 0x5812B9E0, 0x86590776, 0x9414D6AD, 0xBA2FD90D, 0x021030E4, 0x895F779E,
            0xD0283659, 0xD601F163, 0xE8982110, 0xF3AA47E5, 0x74212047, 0x5DE99235, 0x46BB58DA, 0x18E66C16,
            0x0F61AB10, 0xBF15AA48, 0xF6291836, 0xF79B877D, 0x2ABC78A5, 0xE940DC13, 0x9A1A6E48, 0x98742EA9,
        };

        /// <summary>Length: 80</summary>
        private static readonly uint[] s_roundConstants = new uint[]
        {
            0x950F0459, 0x07EF62A8, 0x3B877040, 0x3B7323AB, 0x5BE3012D, 0x0B8B79A7, 0xEE649EFC, 0x60B8D0D6,
            0x817D1D9E, 0xC1712166, 0x26DE9A46, 0xC909ED65, 0x0C292BE5, 0xD17F77D4, 0xD76773D5, 0x6E77657F,
            0x8E3936E7, 0xAA19BC9D, 0xE790E643, 0xB39407DB, 0x5A29D4EB, 0x008C9540, 0x8EE69057, 0x4334A621,
            0xF26F92BC, 0xB738FF97, 0x8B3EA4D6, 0x70F9A512, 0x12F2EA8A, 0x15281772, 0x1D8372FD, 0x59911877,
            0x7E974652, 0x4CC3293D, 0x73B5E2C2, 0x3E81729B, 0x2E858C00, 0xC61B6393, 0x26EBCB88, 0x88E0B462,
            0xD8844C11, 0xC988BD8B, 0xBF643890, 0x97A4B4C5, 0x61187EB7, 0x6D7D82F8, 0xB3C02DC8, 0x002CA74C,
            0x75B9D502, 0xB32834BD, 0xFF675FA1, 0x9C9E8F46, 0x74737A4E, 0x6CFE63CC, 0x1F3EF199, 0x04036D34,
            0xEC0D1FB4, 0xA59023E5, 0x6CE10E49, 0x4CD05278, 0x0A2FDA2A, 0x74D88F77, 0xAA3EEEF6, 0xD85A2657,
            0x90DFDD0C, 0x62474897, 0xD8F571A3, 0x0410A294, 0x2412D226, 0xC80AD06C, 0x79B415AA, 0xA977C262,
            0xD533291C, 0xBF00235E, 0x7D7813E8, 0x0AC3A161, 0x7687777C, 0xD189B5BA, 0x3BA67826, 0xB238F4F4,
        };

        /// <summary>Length: 10752</summary>
        private static readonly uint[] s_keyMatrices = new uint[]
        {
            0xFD89A76B, 0x24E5B5FD, 0x9868B7B0, 0x0E096F15, 0x73998C21, 0xC5C3B916, 0xF04FDAE6, 0xD92013F2,
            0x233056A3, 0x638486F7, 0xFEA442ED, 0x5FE76CAF, 0x43B41B50, 0xB6FE45AE, 0x4DDCF372, 0xD5AACE68,
            0x741377AD, 0x34785DA7, 0x2B81CD4C, 0xA6E00116, 0xB3B20F91, 0x07FFD0CD, 0x1A1EA046, 0x49AE30C6,
            0x30CE51BC, 0x8EABB9CA, 0x40A7FBBB, 0xFFFA6E54, 0x83162B3C, 0x41801A31, 0x7322C228, 0x823ABAD9,
            0xC5158765, 0xD50CFD18, 0xE121D144, 0x8DF3F1C4, 0xEA56C1A8, 0xC0EE1F08, 0x0F65D335, 0x184A45BF,
            0x40B9954D, 0x7A12E114, 0xE41F014C, 0x46243806, 0x6AFB3149, 0x8A5FB284, 0x51D156FB, 0xB602305E,
            0xC9CB3E50, 0x3AF10504, 0x2046C384, 0xD81A08C4, 0xC6BB6373, 0xEBE39AD2, 0xD376CE58, 0x3A81F1F1,
            0x20AE47C3, 0xE81F3458, 0x17B1764F, 0x8EDC42AA, 0x34284E24, 0x871C9CC2, 0x302501ED, 0xAFF702B3,
            0xF2E15B8C, 0xF7EB868D, 0x2EE6440C, 0xA945B611, 0x37100EFD, 0x99058CF8, 0x987E4FA7, 0xD821BE6B,
            0x3FF9EEA6, 0xFFABA9CE, 0xA6AB4F42, 0x82253DF7, 0x0E23B5F1, 0x6A98C6CA, 0x933F1802, 0x70B40212,
            0x98BB3AD9, 0xB05EA0C1, 0x699B5427, 0x67F1FE06, 0x2C849968, 0x34567562, 0x7BC80B08, 0x148A49DD,
            0x4275A775, 0xA9A036D2, 0x07187A98, 0xA40A6134, 0x2C056F72, 0xFC840676, 0xEC85865F, 0x99CDC9DB,
            0x3922025B, 0xA5541019, 0xD00DBFF9, 0x152049EA, 0xAE0E4D01, 0xB4DEB753, 0x54D58729, 0x96CC9DFF,
            0x7FD0183A, 0x0ED88325, 0x50D9A7C0, 0xAC9A055F, 0x24BB4BEA, 0xC8394666, 0xD82A9CF6, 0xD442292C,
            0xB6C122A9, 0x33E6FDAB, 0x2397B4D8, 0x7C2E6364, 0x2716244E, 0x63589630, 0x51E783D3, 0x8B359C48,
            0x6D47F6EC, 0x9D6BA587, 0x35496C6F, 0x3A0036B9, 0x56E1A99D, 0xCF118DAB, 0x1248653B, 0xB984123F,
            0xCE048121, 0x90DB4ABC, 0xF3B9D7EC, 0xB3614CBD, 0xAA54F3EE, 0x8F10AE03, 0xCF48219F, 0x6AC32DF3,
            0xFA94A353, 0x782BEC82, 0x04418D97, 0xC3768B2E, 0x742646D4, 0xB8B504E3, 0xF7B2602A, 0xDE6245AD,
            0x8138EA3D, 0xA9C807EA, 0xD4C37299, 0xDF94CDDA, 0xB2109CE5, 0x51BE940A, 0x183CD0E2, 0x74DD4093,
            0x4F928E64, 0x4140352C, 0x15EC7684, 0xBE76E740, 0xB115ABFD, 0x238D4953, 0x50D0C15C, 0x260AA5DF,
            0xC8D662E7, 0xD9D219EA, 0xBFA09B9B, 0x2C90CA49, 0x77F09BBD, 0x2EC9FBFA, 0x801178EA, 0x937CE35D,
            0x5A44CEE0, 0x0AD1A9BE, 0x0CBD8E7B, 0xAF3128C0, 0x3C68E9B6, 0x8CCE2A21, 0xA410E428, 0x1C7DE9CB,
            0xBE69E789, 0xBB67AE75, 0x7120C6B5, 0x43984E1A, 0xF895DD4B, 0x9E91ABBD, 0x260A196E, 0xD646225E,
            0xDB19E36A, 0xC29C5B31, 0x5948E019, 0x0FB1F727, 0x8491915A, 0xDF1836A3, 0x34AC8B90, 0xC887C80A,
            0x50ADD4EC, 0xB565CD9B, 0x4C4FE74D, 0xBCC93982, 0x3A836093, 0xDF4DEF98, 0x10711070, 0x087933FE,
            0x27AD6872, 0x6357C8FE, 0x6DB80AC3, 0x50B4BC4E, 0x8D6DAE57, 0xA4DB1EF8, 0x1B9A9BF9, 0xB83FE035,
            0xD6A8909A, 0x6D0F35A4, 0x5D327C03, 0x4C511F48, 0x26478B21, 0xBA0988D2, 0x48734D54, 0xA06CDA0E,
            0x9271F737, 0x521B8E48, 0xB9B413D7, 0x607EF204, 0xC72935E4, 0x6A5FC1B1, 0x8CD86F74, 0xE30BC7EB,
            0x235F910A, 0xE86DFA30, 0xEF021986, 0x65CBFA9A, 0x75E63E91, 0xB86B0751, 0xCC52730E, 0x352D55F1,
            0xA056F0F1, 0xF10FB3D3, 0x1A6E8BF9, 0x6DA3AD9B, 0x4722D701, 0xAC918410, 0x43460E09, 0xAC242D0C,
            0xCF7C4DC5, 0x0214B7FB, 0xC701680A, 0x8CD0A969, 0xEDD78F1F, 0xAC1CA33E, 0xF41120E8, 0x049ED2C9,
            0xE28BCD85, 0x4A3FFBB8, 0x1FBC51A1, 0xC17F97D0, 0x560585A1, 0xDAD45913, 0x24B451EC, 0x280758E2,
            0xCAFCC78A, 0x0DEBE27F, 0xDA2E8DA7, 0xE1AD81F7, 0x8C9560E5, 0xDA588E06, 0xCC0339B3, 0x694E0149,
            0x0179A4C6, 0x243F2A62, 0x3CBD0BF7, 0xC1631F40, 0xC15E8EEB, 0x60A8A6A8, 0x05ECFD4C, 0xE11E45AE,
            0x852EFC8F, 0x9439AF4F, 0xD0F25060, 0x379EFB02, 0x04DD7C37, 0xFD44D28B, 0x76D60BC9, 0xB7DC7139,
            0xB03B49AA, 0xB97BE0F9, 0xE8A1B326, 0x26248207, 0x6C325A6D, 0x5CC4D660, 0x9E3D4DB2, 0x0ED43B09,
            0x718E5D14, 0x113507C7, 0xEF7A1CA2, 0xFA511766, 0x75541D07, 0xB93D816D, 0x9E87AAC3, 0xCD6B8A4D,
            0x69F1F03D, 0x8F2F0B47, 0x4C2EFA68, 0xDF66A385, 0xFBE017DB, 0xCC058B9E, 0x4551CCBA, 0x8E3C6547,
            0x5D32BE7C, 0x72997DB5, 0xDA9E8A6F, 0xC19B3572, 0x336BFFB3, 0xB5C57FDE, 0x194B4BE9, 0xD98655F8,
            0x92EE0D7A, 0xF22D1725, 0x94BD07C2, 0x8D543682, 0x0EEC4695, 0x4455FAA6, 0x6249BD88, 0x1C81A90F,
            0xC80177BD, 0xE09B5AEC, 0x2A1F6A89, 0x68901D6B, 0xA97658DF, 0xF8A3CC39, 0xF19240E0, 0x59CEC1D7,
            0x6B89CFCE, 0xD8A86AB2, 0xC24A3FEE, 0x34726A23, 0x52188CEA, 0x51D5C909, 0x322286E7, 0x4FAA5D64,
            0xAB653AB1, 0x733A0FAD, 0xAE936C43, 0x3803C276, 0x6E8C6061, 0x3E98BFDF, 0xDDC75F61, 0xB38BDDD9,
            0x2337508D, 0xE26F1DC3, 0xB9C34BCE, 0x43503569, 0xCBA8F827, 0x2D8EF0FE, 0xD1452684, 0x0863C2D5,
            0x1F9B2E68, 0x7DF79E50, 0xA2D8582B, 0x385277EE, 0xD3C57EE0, 0x74553315, 0x04667CB8, 0xEEFD2633,
            0x97CE818E, 0xB3EA82C2, 0xE6BF6CD5, 0xC79F48CB, 0x5E412417, 0xBAB627AE, 0xCE013806, 0x99123B9B,
            0x107B669E, 0x63857E74, 0x113E012F, 0x967CC14F, 0x6EF9927F, 0x8B54F99D, 0x4BFD3379, 0x4C48CBE5,
            0x6B440FE2, 0x5EA9EF1A, 0x8AA206BE, 0xA5738A14, 0x4C56FF7C, 0xFF98B1A9, 0x2E249460, 0x7582548C,
            0x0EC87A11, 0x2EDDCA44, 0xB7CBCE5F, 0x51477837, 0xEC00EA54, 0x046715DE, 0x970384ED, 0xFA4BF9CB,
            0xAFB68F98, 0xF88A9FA3, 0x34B07515, 0x058020F8, 0x44C59ABB, 0x1E2F33B4, 0x10962B10, 0xA7F92C76,
            0x520FC00C, 0x9CF80822, 0x10E54E8A, 0xDE415788, 0x65B01A15, 0x4C0C5D99, 0x43E3FF68, 0x0E6FA901,
            0x99AF58F4, 0x085688A0, 0xECC72195, 0x946FB9A4, 0xAAEA3750, 0x01F4D4A8, 0x30609E71, 0x91D740FD,
            0x76EE29DE, 0xA834E9A4, 0x7FE12B53, 0xB94702C9, 0x23C00EB1, 0x10DFE81C, 0x8445385F, 0xE2FC04F1,
            0xD98CB0B8, 0x6955964B, 0x2B0530CC, 0x8D0C7126, 0x241FCDE4, 0x57988110, 0xDBC5447D, 0xE1765C26,
            0xA41E08C0, 0xED544EFF, 0xC5C1175A, 0x5467F711, 0x7D12F1DB, 0xC3FA7C20, 0x00A9E31A, 0x82E968D1,
            0x5829ED31, 0x3561016D, 0xADAD7978, 0x7EE2C079, 0x8522437F, 0x0D8DEE39, 0x5DD467BB, 0x6927BB94,
            0xD18816C5, 0x6F5F085D, 0x210823B8, 0x74EB5DDE, 0xD5F46169, 0x5CDBE33B, 0x50E03C27, 0xE5E168E3,
            0xC0052486, 0x18FB0FD9, 0xC28F609C, 0x881B7104, 0xFA797853, 0x2B2C1E13, 0x3919BE7C, 0xDA09613D,
            0xE4CF459A, 0x99259307, 0x7AE71312, 0x29FA133B, 0x65B46622, 0x9DDC6F71, 0xA92B6785, 0x96362E43,
            0xFB617294, 0x48AD4460, 0x3091B364, 0x61462184, 0x14900B04, 0xA3A9F039, 0x30D96E99, 0x7DCA7A17,
            0x22CD369F, 0x93D85525, 0xB5C27864, 0x7AC21AF3, 0x199E8D6F, 0xF28D4C55, 0x3E892FFE, 0x1125E0FF,
            0x978BAB82, 0xD89EE84A, 0x8A196ECF, 0x272C32F7, 0xEE72FE52, 0xD5010906, 0x6E41648E, 0x62704384,
            0x1A170513, 0xFE805B02, 0x6B369739, 0x177BEE5F, 0xA4091A88, 0x3AFD6DB8, 0x930A1269, 0x9E1B3463,
            0xF46DA6BC, 0x7D387C4C, 0x59B28355, 0x47DA3AC4, 0xD3934DF9, 0x6EAFB222, 0x00B47F16, 0x65538FEB,
            0xECF98621, 0x93E3FB9A, 0x6A23377A, 0x748DE217, 0xDC244DB0, 0xEA6180DB, 0xA8B3C12C, 0x943FAF75,
            0xD3909E04, 0x1F7EFE30, 0x53A4F1B6, 0x7A034852, 0x3D20A432, 0xD73B9FD4, 0x5FFC969F, 0x9C718238,
            0x47EAD286, 0xF6A6CA89, 0x16321331, 0x6F61C8B6, 0x0076B9CF, 0xCD68DB86, 0x6CDCD33C, 0xCEC8DCEB,
            0x3DCA87C5, 0x7373D2E4, 0xCF20F239, 0x808C23ED, 0x0F7270FA, 0xF1DCFDB9, 0xFAE91D2C, 0x0CE1B90D,
            0x2C7F1D22, 0xD1C61DE4, 0xBE675080, 0x686A7F5B, 0xE5DFBA81, 0x466B6873, 0x12241013, 0xBF9FC89E,
            0x7213553D, 0x25AFAC1B, 0x8BACA0A1, 0x866D581E, 0x4AC0678A, 0xAC6BE1B1, 0x29717881, 0xDC176B3D,
            0x51CB923F, 0xD1EFC552, 0x32C7954C, 0x5B8DD9A8, 0x772EC432, 0x8618DAB4, 0x1069A69C, 0x3C76B553,
            0x118A9A42, 0xE1AE16B4, 0x2101B5A2, 0x5FBAC4B7, 0x4A4D1D1B, 0x3F587ABF, 0xABC00819, 0xC5C7591E,
            0x3DAC182B, 0x13C1616A, 0xAA1A21B0, 0xD056598A, 0x539A2AF7, 0x7D484788, 0x6D0F260B, 0x82BDE8E9,
            0x0EB3D927, 0x752250D7, 0xC0BDDC58, 0x0F370C03, 0x2E39566B, 0x282E73B7, 0x1578BBFD, 0x47A9ACC2,
            0x0AF9CE50, 0x4FC8FB3D, 0x32361BE5, 0x0102A5F9, 0x39103355, 0x22E01B88, 0x95A2E3A2, 0x62170066,
            0xFB7862F1, 0x8F4229DC, 0xDE249A2E, 0x9B92E87C, 0xC024EC47, 0x45E5B9F7, 0x589A92D6, 0x7F552627,
            0x4443E793, 0x1D2DFE1B, 0x06D8AF5F, 0xCF461CE6, 0x66C51C4A, 0xC14ABA0B, 0x5C8A17CF, 0x726FE739,
            0x45F47BBA, 0xA8459B05, 0xEA78132F, 0x01C77AC2, 0xD72A9F49, 0x0F33C701, 0x9DC0F493, 0xBB1AA044,
            0xADB5C133, 0xA870A8EE, 0x96089793, 0xF66BE5B6, 0x21F6998F, 0xC4FA9E87, 0xD24646AF, 0x0D26EA89,
            0xEBA7FD7B, 0x4EA0FDCC, 0xBDD3DDAA, 0x6D05DE91, 0x9DBA8BBE, 0x9EA36DC9, 0x06AAC0EE, 0x24067028,
            0x076AE8E3, 0x0605B3EB, 0xF0C4C6DE, 0x35E03F5C, 0x9AEA0086, 0x5770D201, 0x257FFB40, 0x971F6215,
            0xF656F3E0, 0x55D76C0C, 0x4EA325AE, 0x5F5E383E, 0x36F82FE4, 0x80E7C864, 0x1C9FF0C0, 0x4DF6EE63,
            0x299447E0, 0x67F56E6A, 0xE85F47E5, 0xB92864EB, 0xDD001858, 0x28A661DB, 0x2A89B3A2, 0x40C1CF9E,
            0x3AAC325B, 0x963E0D43, 0x69017167, 0x05E50648, 0x7E4EC93C, 0x80AE8356, 0x961327CC, 0xEDF7A545,
            0x300D05A7, 0xEF19A3DA, 0xEFBFBB2A, 0xF9F9FB87, 0xE94BC4C7, 0xFDF2B153, 0x9363CD37, 0xD2E45F19,
            0x8799ACE0, 0x1A76292F, 0x3D99994F, 0x4C04CEE9, 0xFD275743, 0xB28D0CA9, 0x407F927A, 0x41EAAA8E,
            0xA1D88C0B, 0x1C5D2A0F, 0xF9C10B1F, 0x8A0C5509, 0xFF28842C, 0xE2019504, 0x34D90732, 0xB7C9A18D,
            0xF9546B56, 0xF990ABA1, 0x43132B00, 0xA4FAC3C9, 0x95C87AA0, 0xC91E8ED2, 0x69D2D16B, 0xB15FEC78,
            0x95FD9253, 0x0CFA0C26, 0x31A1FB2F, 0x6B6A1E89, 0x02D4D7ED, 0x6E7AE0A0, 0x1B9AF52D, 0x9BFB040D,
            0x553B0695, 0x627F724D, 0x760BBBAC, 0xF5CE0354, 0x4E9A4BFC, 0x5B22B9EC, 0xA990F0A3, 0x44A4EB80,
            0x09AB999F, 0x6A4FDD84, 0x4361E9F4, 0xA645D574, 0xD80D76DB, 0xDF3F8A22, 0x705A8F78, 0x0E716543,
            0xFAFBB404, 0x92D308CE, 0xA4FCECC7, 0x2C62EC07, 0x0B8DE6E5, 0x9ABB64EA, 0xA4D41A11, 0x6582DFB7,
            0x7791FB7A, 0x2A1ACBE0, 0x308C6A87, 0xE0CA3D5E, 0x69F71FDC, 0x8D9DBF7B, 0xFFF83B4F, 0x13933927,
            0x587D293E, 0x9C30B7EF, 0x0D1776E1, 0x20A86152, 0x6C7FD948, 0x1FF69F4E, 0xA734E12E, 0xD041B29D,
            0x04C355F1, 0xD2EBA84D, 0x67B98562, 0x53A67F58, 0x3B931812, 0x7A3EA3BD, 0x61CF277A, 0x6BA2E454,
            0x591F9542, 0x3838CB32, 0x8A2F1A96, 0xC3DB8B40, 0x4EFB0841, 0x1A7FA661, 0x4E6CE2AA, 0x099B76E8,
            0x5306DD08, 0x95A9B477, 0x23E8496C, 0x93A4D7B7, 0x8405147B, 0xE2E28C05, 0x5F7021A8, 0x0511B1E9,
            0xF94EE07A, 0xC180204F, 0x26AC71B7, 0x1FCC0676, 0x7C15F45C, 0x0BE83AF6, 0xE4B5DFEC, 0x27113237,
            0xE17EC552, 0x52E394FC, 0xB6DAE253, 0x1ACDAD4D, 0xB95303B5, 0x62DE67FA, 0x796788DD, 0x7B1F09E0,
            0x10E34CCF, 0x018CDC4F, 0xD57CC31A, 0x5BDC7653, 0x607520C4, 0x56630EBB, 0xD3A15581, 0xD46CEB22,
            0xEB685AD7, 0xFC663E30, 0x1BDE5400, 0xF984EDC2, 0xE4F7236E, 0x1808105A, 0x7408F87E, 0xF1E29A1D,
            0xDC527895, 0xD776E4BB, 0x302C2EC9, 0x2DFAE027, 0xD499B4C1, 0x6F9D7BA2, 0x61A7C857, 0x538CECFE,
            0x992C61B1, 0x9C21D4FD, 0x0B62DA74, 0x06BD8EC2, 0x03DF7998, 0x27C648C9, 0xD67B5B70, 0xD6A43AAC,
            0x080D5139, 0x3CA663AC, 0x1ACADA3C, 0x95B5D58E, 0xD6A72BAE, 0x03D6BC96, 0x3643C222, 0xDCECB0E0,
            0x2138FA66, 0x9F43A935, 0x3658EC95, 0xDB93019A, 0x297FA295, 0xC0AFB4CF, 0x17B1CEF6, 0x451F9439,
            0xB211E735, 0xF13F2DEE, 0xBA621A7D, 0x771CD440, 0x52957811, 0xD018D73F, 0xB7A9F931, 0x338D7B9B,
            0x31D7C622, 0x0387F61D, 0x403DDF4D, 0x8B9B796E, 0xFF065871, 0x2E8AB490, 0xE189E20E, 0xF15A242E,
            0x256DC3A0, 0x42238185, 0x5B1BCC7B, 0xA64189B9, 0xBDA934D8, 0x25ABED77, 0xEDF77167, 0xF31866CC,
            0x86C9A4F2, 0x251089C8, 0xF4FE9A16, 0xB18B1F8F, 0xFBD0E15A, 0x9C656326, 0xB19DF3EB, 0x644700D9,
            0x9347396D, 0xE92508C0, 0x404CFB07, 0x97D92F2B, 0xE3B5552E, 0x1E491961, 0xFD35D791, 0xC082C7CE,
            0xFE5C40F0, 0xB18FC2C3, 0x1C0C3B8E, 0xA037DFD6, 0xE742FFFA, 0xEB446642, 0xD7A81BD8, 0xA414E980,
            0xA5FB3617, 0x52EFED53, 0xF0E47BB0, 0x2076D6A6, 0x4136D316, 0x6FDBCA21, 0x7B41835F, 0x1235CA44,
            0x29C832CE, 0xA764BA8A, 0xA0BC49FF, 0x869A1634, 0xFED0276E, 0x6D649E0A, 0xBCD3EB4C, 0x939B843F,
            0xB538833F, 0xC64DF244, 0xFEF514BE, 0x4551DD13, 0x43028B3A, 0x658AB659, 0xF031AFF1, 0x4112D310,
            0xDCB56DD6, 0xDEB4F6EE, 0xB3AA0B7B, 0x185075EF, 0x21FBAD9C, 0x9CFFA97F, 0x800477AE, 0x42395BEF,
            0x24CD0277, 0xE054E0DB, 0x723CB870, 0xD4A92031, 0x4507D5D9, 0x71C65884, 0x105B3692, 0x3084BD45,
            0x5483607A, 0xC3E0DDC0, 0xAD23B44C, 0xC62974CE, 0xFF7EECD4, 0xB6EE53A5, 0x79DCCBC1, 0xF6744B9D,
            0xFF3B737E, 0x3501AA13, 0xA40DA489, 0xD86709C2, 0x5064A236, 0xC93E755F, 0xF5878129, 0xCB51122D,
            0x1E0FEDA1, 0x229D66B7, 0x7D1DF4BB, 0x5C778BF4, 0xDF689572, 0x9D4D5093, 0x6B86F7E3, 0x78741188,
            0x3B67616E, 0x2883238A, 0x1594BC91, 0x818E0CF2, 0x0545ACA8, 0xE6442D13, 0xDC345FDB, 0xBB7E141A,
            0x1EB2643E, 0xA417427A, 0x434803A2, 0x2B714E53, 0xC1ED328B, 0xEAD8355C, 0xFC127B17, 0x2F262F90,
            0xACE6857A, 0xE90545CD, 0xD8CB42F3, 0x8ABB5E20, 0x83DB642C, 0xD36B049F, 0xDB2E7CEC, 0xAD9AC9A3,
            0x43C6C66C, 0xBEE690EC, 0xBA68F5BD, 0xF111BBC6, 0xF942B791, 0x62C1A478, 0x7D5DB3FB, 0x6E9AEDE3,
            0x49B0938C, 0x78B5D807, 0x19162561, 0x99FFA293, 0x523B2F56, 0x1B5D4A19, 0x1C56672C, 0x63D98E2A,
            0x4B8E4A46, 0xCC5533DF, 0x3D002A85, 0x382990E3, 0xAB289516, 0xB5466CE4, 0xCFFBBFA4, 0x30B239F3,
            0x1F9A5738, 0x8504C179, 0x4720A247, 0x458474F0, 0x35CC009D, 0xAD9B08A5, 0x43AF6B1C, 0x3D91BA9E,
            0x42B1196B, 0xB67C2D45, 0xC11AE18C, 0xE8316256, 0x88A4856A, 0xC22D2504, 0xD8820F16, 0x46BA4AF7,
            0x5E62D522, 0x6A8F40C9, 0xD9BD2448, 0xDC35BCB1, 0xD8062D7E, 0x0D13F141, 0x453C3493, 0x527E6DEA,
            0xDC7E282C, 0xBF703393, 0xFFF73768, 0x6C55C3C4, 0x6E60C52A, 0x42BD5DA6, 0xAC0325F8, 0x42991C3F,
            0x87DCFAFC, 0xC435CA51, 0x2F5050FF, 0x2376A177, 0xD4597F81, 0x4318D6CB, 0xEA508507, 0xC7A04B7C,
            0x2D2D909B, 0x05C69A69, 0xEF0C800A, 0xEE15EDEF, 0x60398E1A, 0xC60AD577, 0x2A50EE26, 0x836B9C7E,
            0xFAC064EB, 0x94DBF963, 0x6215760F, 0x09230E97, 0x7E88364D, 0xC02026D9, 0x27917D4E, 0xCC33400A,
            0xA07D024C, 0x197ADB71, 0x735AF5BD, 0x38CE2B64, 0x3ECE500F, 0x6C043D40, 0xEAEE1B08, 0x58A087EE,
            0x660AF6C2, 0x64201C8B, 0xB7B36048, 0x80F19ACA, 0xC7780B7B, 0x6F9767F6, 0x53CDC211, 0x60CC83E4,
            0x706CCB35, 0xE28B25E5, 0xA4F07274, 0xA44B3AC6, 0xB09BEEEF, 0xC91AD3AD, 0x3BC46527, 0x7147D848,
            0x1B6B3A79, 0xC634E648, 0xF6D05D67, 0x979E0642, 0xC7F5BDC6, 0xDEA76730, 0x44787A37, 0xA1CD5498,
            0xFA90461F, 0x725A4DB7, 0xA39AE0EA, 0xA461F418, 0xA96794B6, 0xDAA93BBB, 0x8B403304, 0xC94AE326,
            0x0474864D, 0x91773C8B, 0x8664B66B, 0xA43EC1D0, 0x5E2A8BF1, 0x6DB6F617, 0x854D5308, 0x075A96B8,
            0xE54FDF9E, 0xAB10D5BB, 0x0F3D6DB3, 0xEA66F02E, 0x5FC51175, 0x5E749E8E, 0x34264366, 0x88F777E4,
            0xB71DD02C, 0x6E3CEF13, 0xC3A4E183, 0x4B1C2074, 0x27315246, 0x95FF18BD, 0xC6A62AF8, 0x3ED3F10D,
            0x75C26AD1, 0x31C574B7, 0xDFBE902F, 0xA861D6B8, 0x43989EA7, 0x69F29737, 0x569B7E8A, 0x1D739B1A,
            0x4271B408, 0x1889C45F, 0x23921DC0, 0x4DE38DC6, 0x3F4D4498, 0xFFE4B422, 0x3837296A, 0x6113599D,
            0xBEE47447, 0xCCB9E31C, 0x471CFA39, 0xF247C20E, 0xFA95319A, 0x152EDCCE, 0x69F02927, 0x71BCF4EA,
            0x6AFF7168, 0xCB585BC7, 0x60B7F286, 0x29FA8B30, 0x1E476F69, 0x5AABCC3A, 0x6681555D, 0x24E3330C,
            0xE4B13409, 0x21A0919D, 0x82F3B6C1, 0x70EB85A5, 0x21765E3E, 0xB7D64897, 0x6DE67614, 0x4EB89B7C,
            0x78AA5B03, 0xDAEF0651, 0x3ABDF489, 0xB23C584B, 0xF669E0D7, 0x96BC8A24, 0x04D63D30, 0x55D75B11,
            0x6E97C797, 0x8E2A0D52, 0x9B122731, 0x2746E920, 0x577C3232, 0x8B3AF4D1, 0x12724842, 0x9B7ACD01,
            0x9C7ABD1A, 0x58B25944, 0x4C3F429D, 0x21862BE3, 0x5AE0DBB2, 0xDB87410F, 0xD0CB4478, 0x0B7306EF,
            0x6B1FE3DC, 0xE435E10C, 0x36D83ABA, 0x1E93F13D, 0x06BC76BF, 0x570755F5, 0x558BC2E9, 0xD3B706B5,
            0x2CD9B85C, 0x0E12B10D, 0x1282ECA3, 0xAFE573A3, 0x67593A20, 0x3A900E4E, 0x1D39A93F, 0xAC8BE471,
            0x2D94E26A, 0x749C8FDC, 0x630C2420, 0x9D5925A1, 0xC060077C, 0x4074DFA7, 0xF89674CD, 0x7817A45B,
            0x171A7CD7, 0xC89DB0D5, 0x43920D73, 0x1818B419, 0x4F3F84C8, 0x4AA70BC3, 0xA358C835, 0xD2BFB0E2,
            0xAEB62D8F, 0x9917F8BB, 0xE0FB40F9, 0x9675262D, 0x4F388F19, 0x5297869C, 0x9421E486, 0xCDCDB42E,
            0x83D665AB, 0x9CC11703, 0x6A5D9AD7, 0xF3ADFAF1, 0x8CE6268E, 0xAA91151A, 0xB1BAF10B, 0x0747EE4E,
            0x2FD56719, 0xC744DAAD, 0xF3EB424D, 0x4A457024, 0xE2E07AEF, 0x26A25F9F, 0x534CE183, 0xC0A9483C,
            0x16C07BA7, 0xF2D2B60A, 0xFEA31049, 0xE31D546C, 0x1560D789, 0x3F030C2D, 0x5EA6CD4D, 0xB73FED70,
            0xC721E72A, 0xA7DE4201, 0x2AF9BC72, 0x78FE781C, 0x9F80209E, 0x1AD9EA83, 0x9978D1FA, 0xFBF7B532,
            0xBC8375DC, 0x85820A34, 0x032E9E5C, 0x82C54A8D, 0x1AAA8E86, 0xB7ABF0B9, 0x075859B5, 0x5EDD8D26,
            0x8D1C528F, 0x8DB063D0, 0x6C63C8CA, 0x028E6AFB, 0xF13254D3, 0xABA5F8D5, 0x3E6A4FEE, 0x08F02CD2,
            0xAFF6DC2B, 0x60A5C38D, 0x872ED53C, 0xB1481844, 0x45267A99, 0x2B881A06, 0xEFCF7305, 0xAFDF35B4,
            0x538A0F43, 0xD611FA9F, 0xB182A80D, 0xFFFD2A1C, 0xA388BD2C, 0x683D31C5, 0xF6EDC873, 0xF628A082,
            0x825CB752, 0x899C9264, 0x5B13A619, 0xE71DE4F7, 0x453E3BDB, 0xFE0C4913, 0x7D5DBE43, 0x9199E0E4,
            0x62F88E18, 0xBFF3DB36, 0x5F6E8136, 0x80D9765F, 0x21DE91D9, 0x9BB3CC32, 0xC2F6BD73, 0xF0409CB4,
            0x78A325EC, 0x20C1AD4D, 0xADBAD342, 0x3AB04310, 0x6B4A6CF9, 0xAD713213, 0xC93140C1, 0xA00475B0,
            0x2BE653A6, 0x7DD7D959, 0x68B23642, 0x95C6DD6A, 0x14C0E038, 0x3E825C19, 0xD8CE623C, 0x61FFF777,
            0xBB62E773, 0x677E0EC9, 0x7F8B8514, 0x5EB8DF55, 0x21CC314E, 0x8A5AC02D, 0xE3E56024, 0x4C5D05E5,
            0x4071393F, 0x0EACC71B, 0x12DF912E, 0x4D30BAEB, 0x6E5A5BB2, 0x015CB363, 0xD55FF42C, 0x8E8E4A1A,
            0x1CC7D79E, 0x31B446B8, 0x384AA80F, 0xDB5D6EE6, 0x83CE3F5E, 0x7778A4A4, 0x37062871, 0x3989B0ED,
            0x40196A7D, 0x98A2BCF3, 0xF875FA60, 0xC6B5A1E0, 0x91678D95, 0x68DB1567, 0x0DE6728F, 0x6BA78BBB,
            0x0B71D9CB, 0xDCF95C9C, 0x9F457BCA, 0x58CE3514, 0x9F4773CD, 0xDDEF0783, 0xE6CE24EA, 0xEE00D6FA,
            0x76455156, 0x8871D4B9, 0xBA4F22A5, 0x1DB97502, 0x582FCC8D, 0x8B7542F4, 0xBE3E6D13, 0x307F197F,
            0xE7D2576A, 0xC16F04EB, 0xE85FED5A, 0xB1A00A48, 0x515B494E, 0x6C2D0F33, 0x6B24A49B, 0xE138C0E3,
            0x6980A544, 0xEB0874CD, 0x904A73E3, 0x44DEAC1F, 0x5F03B1BF, 0x4F3816AD, 0x4CDA3A13, 0x48AEBA17,
            0x3FD640D0, 0x6785E164, 0xC73D31DC, 0xEEB3BB25, 0x7B9F8C52, 0xF2DA7AA5, 0x31234BEC, 0x0B221ED0,
            0xB104B1C5, 0x860A41A9, 0xC0989B1E, 0x5AED2F46, 0xF847030F, 0x7B7076AB, 0xC36D2071, 0x96E4787D,
            0x68ADC624, 0x6EA97981, 0xC1EC8A76, 0x2200219B, 0x13DBF769, 0xE8DA518F, 0x4A6DC030, 0xB64A7870,
            0x36F53AA6, 0xB0AA64DF, 0x02CEF779, 0xC5CAE920, 0x5C43BA12, 0xC7E67D5E, 0xA818CD63, 0xB01DA2D4,
            0xD5F9548E, 0x8ACB23F6, 0x06CB9777, 0x0853C618, 0xF265CA0D, 0xA307DD3B, 0x90E0447E, 0x488E5537,
            0x0AD36D77, 0x27E9C68D, 0x1819F044, 0x16F329BC, 0xD0B02996, 0xAC7914C5, 0x27AA9422, 0x06BB5F81,
            0x23188AFD, 0x113811A4, 0x6B2411FC, 0x48E32942, 0x20BCF32F, 0xA4131E07, 0x8B540524, 0x6425923E,
            0x2601FC77, 0x3A54851B, 0x2E2AC6D7, 0x364986BB, 0xD6DB43AE, 0xA7FAF850, 0xFDB4DB50, 0x1DC136CC,
            0xBFF54594, 0x86CE8BBA, 0x7DCEF6B7, 0xF188EE3A, 0xA761F09A, 0xA7DA956A, 0xF07A2211, 0x689DA2E7,
            0x1024504D, 0x09BD11EC, 0xCACE2D11, 0x626586CA, 0x510C31D3, 0xFE637F8F, 0x782C644A, 0x11F61A41,
            0x524663C0, 0x649C9F02, 0x77E44393, 0x7CB281BA, 0xDBC9F2F5, 0x639176B5, 0x11A29202, 0xC38DA719,
            0x7BCC4429, 0xF9BD6521, 0x356A0F46, 0x7E26104F, 0xBE9E8743, 0x8DCA1A7E, 0x55CA2FE2, 0x362F17E6,
            0x3EF4AE10, 0x7B4A035D, 0xA78B5ACC, 0x493AD100, 0x363F46C0, 0x8C18875D, 0xFFF46E85, 0x857CBDD6,
            0xF326B71A, 0x59FF3986, 0xF827ED9D, 0x4CE7633F, 0x8B3C2FE2, 0x27954FFF, 0x63ADD35D, 0x2C78298B,
            0x914A7F39, 0x598291FF, 0x012125EC, 0x7D300043, 0x0E31421E, 0x4250A6B3, 0xBB2771FB, 0x5B654124,
            0x28B12C8A, 0x3E5CDEE2, 0xBD331AEB, 0x45257B87, 0x5F4E694A, 0xC5E28594, 0xBAE27F2F, 0x58FE4EE7,
            0x43FE6869, 0xA543D5FA, 0x31960938, 0x6D3517BA, 0x6C269494, 0xBA2D9694, 0xC8C93E03, 0x6C300083,
            0x77662AAC, 0x8CB910DD, 0x8240F139, 0x3B88D134, 0xE077E16D, 0x29BB756F, 0xD00899B3, 0x5195C3E1,
            0xFE9E46BB, 0x53F568EC, 0xBECA3A4A, 0xA43B9EB1, 0xA6397EBE, 0xBB5649F2, 0x0C35D6A8, 0x0FE7AFDC,
            0x3D085B44, 0xC8C602DF, 0x031EAE38, 0x57B7C18E, 0x0A959CBA, 0x993F86DB, 0xDCBF3EC0, 0x21116E92,
            0x2F9DC701, 0x0996AB5D, 0xF426E64E, 0xFDBDB72E, 0x60F060A2, 0x97A6D721, 0x6B599659, 0x1FE4ABFD,
            0x3FC7F387, 0x4130181C, 0x22E5E9DF, 0xC9EC97BB, 0xCFF16D7E, 0x73D12346, 0x379D12B6, 0xF20DF5E4,
            0x903FA559, 0x8AD6B1A9, 0x6AB3242B, 0xB6D551BA, 0xB7F8E779, 0xA0A017E7, 0xA066F033, 0x88207DF1,
            0xE878EE3C, 0x64F7CB62, 0xB6873A57, 0x623D9286, 0xB1E2D976, 0x33F3F12A, 0xF9D7E34B, 0x0B35421F,
            0xAEA73EC0, 0x79EAB7FB, 0xCB2A3643, 0x09DBD4E7, 0x3A8A0A9F, 0x7898F2E4, 0xB31160D6, 0x4FF386C0,
            0x4B6842BF, 0x1EB75F7D, 0xDB8B1F21, 0xFE1183A2, 0xDE9E6F7F, 0x208131C3, 0xB2B4BD95, 0x3F72C9E4,
            0x814C5420, 0x8FC7381D, 0x7295D329, 0x52A3B893, 0xF4AD686D, 0x8A6AC134, 0x14B06DC3, 0x0DF48EBF,
            0x24B4BEE6, 0x15D9B192, 0x0763805D, 0x8A12CD01, 0xCDCD087E, 0xE715A20B, 0xD0C807D7, 0x3B72A191,
            0x7A45D4CB, 0x8A38553B, 0x523EF67F, 0x03D97A50, 0x86C5ABF0, 0x0F6C240E, 0x5543E5E8, 0x35CF6B99,
            0xFB6DD73E, 0x137A9265, 0x629D0512, 0xA64DBB39, 0x20EF4292, 0xA4262510, 0xF312E561, 0x02FF4793,
            0xCD8A94E1, 0x684A6CEB, 0xB21FD81B, 0xCD442FC8, 0x15CEF157, 0x1B425EFD, 0x12BE7B9C, 0x29709059,
            0x8D3C13FE, 0x9463D2AA, 0x45043C6E, 0x0EEE6157, 0x70FCB3D3, 0x6529DA22, 0xA5AC0B4E, 0x4679F4C1,
            0xD17B89D7, 0x2F80E060, 0x9398A27A, 0xB971F74E, 0x037FAFEC, 0xE0876714, 0x2367F9F4, 0x290F1DC9,
            0x947B4019, 0xB4792188, 0xA993570B, 0x478FE6D8, 0x0B7D78E2, 0x07CED3FF, 0xF816B71D, 0x711D9A0D,
            0xAC5FEC2D, 0x1660AEFE, 0xF6C54555, 0x5C071D06, 0x770606CE, 0x1079D315, 0xB663F67C, 0x8163EDA3,
            0x69752AB3, 0xB87C3735, 0x79E1E40F, 0x124E34C9, 0x18608823, 0x4CE0F5DE, 0x837B9B27, 0x7228DE87,
            0x84F1FBBD, 0x53ADE557, 0xC432DD61, 0xFD8EDB40, 0x6B0829D6, 0x3FF8DB0F, 0x2868F4F7, 0x82FAB869,
            0xA67B7EDC, 0x1D60A9BF, 0xC53A168F, 0x46A4E4CB, 0x3AC03049, 0x48D96740, 0xBAAFB009, 0x43881161,
            0x615B0E19, 0xF53D485E, 0x913EDD50, 0x2BA3BAD1, 0x767CDD3E, 0x77225505, 0xB53BF622, 0xA19972BF,
            0xC1ED6E96, 0x4C9B7AEC, 0x63ABB0ED, 0x183671DE, 0xA435EC2D, 0xBE596969, 0xE6481416, 0xA6480C97,
            0xACC339F8, 0x8ED6B740, 0x087451A2, 0x8A834C0A, 0x8173A117, 0x128CBD42, 0x816E202B, 0x52CA393E,
            0xF1CAE50C, 0xB4ED9FD2, 0x9840290B, 0xE1D4416E, 0xFAFFBC31, 0xC40D1CBA, 0x1F6C59EC, 0x45BC7A70,
            0x11D7CF2C, 0xC86441F0, 0x00988AC5, 0x2C677552, 0x4335A69A, 0x0EBBDFC2, 0x5157DA01, 0x2D76C8B6,
            0x2EEE23E9, 0xC2405C45, 0xF8BC301F, 0x829D1FE6, 0x87891105, 0x935E15C8, 0x6926DCDF, 0xC4471C8E,
            0x5AC253F4, 0x00FAF662, 0x8BEE8173, 0xBED69A83, 0x9679B284, 0x2DA0112B, 0x4F65B068, 0x9A6BDF02,
            0x323D46C1, 0x62ED58C0, 0x79FC86B9, 0xA8AEBB65, 0xB0A6D6BF, 0x4A6F7F1D, 0xB1F48B51, 0xB75DC281,
            0xD7AFFB05, 0x05ACA6E0, 0xF647A519, 0x3775B0A7, 0x3F838182, 0x7CBBA408, 0xECC68927, 0x4B10BF78,
            0x9F87B5D2, 0x30835169, 0xFDB9AB30, 0x313DA624, 0x479D27C7, 0xF9DCA076, 0x6DA33C95, 0x77E87908,
            0x9924406F, 0xA9914228, 0xF3EC6D02, 0x0FC1B9E3, 0x71797BC8, 0xED49FB31, 0x3F7D1852, 0xDFC34783,
            0x61AEA4E6, 0xF4685AB1, 0x2468F7C7, 0x546F6CFC, 0x0848D234, 0xB8C4532A, 0x782ED76B, 0xB5B85AFA,
            0xAE047D01, 0x3AC01011, 0x837C8B40, 0x4160ACF8, 0x7BBBF1AE, 0x697916B2, 0x5D6E7B6F, 0xE1623ED1,
            0x0A1AD8D1, 0x11B550E4, 0xAF77A6DF, 0xCBAACB6B, 0xACF4A77E, 0xEBFCCEAE, 0x88A7BE4E, 0xE61FCE5E,
            0x15A7443C, 0xB01F8133, 0x8449C918, 0xE22D4CA5, 0x86EA39BF, 0x3F4CD0E0, 0xB0CD90DF, 0x915C4807,
            0xFEE283E9, 0xD6294EBF, 0x75AFF8C0, 0xB0454991, 0x1217F15D, 0xE0BDDD03, 0xD1392946, 0x6C1AE089,
            0xF384C69B, 0x11002268, 0x88452C6A, 0x0F60FDEA, 0xC98B939A, 0xFD796E7A, 0x47E6C801, 0x228CB0B1,
            0xF9E307B0, 0xE2C717D3, 0xB56AAAD6, 0x8464C547, 0x8B56F449, 0x8223CFBC, 0xA817AFE1, 0xA027FAA1,
            0xD10596BC, 0x0F13A5A8, 0xD3765307, 0x9F70E7F5, 0x348CD546, 0x6D37116E, 0x746360F7, 0xEB87FDC5,
            0x1AA8CC93, 0x8933AC64, 0x940E7D09, 0x7FC4C9B6, 0x68558E2A, 0xB7BB15D5, 0xAED5B9FC, 0x96DDDA8F,
            0xE72FD58D, 0x0F414C9C, 0x76062AFB, 0xB63A4CCD, 0x660F92F8, 0xDEE73A8C, 0x19D1BC62, 0x22666E2B,
            0x8112EF53, 0xE94E5223, 0x28208D93, 0x1402E150, 0x728013CB, 0x6A6617F4, 0x05E477F7, 0x93FF158A,
            0x36678020, 0xFEB26F9E, 0x5536FD92, 0x6C4E80CA, 0xB94CAF33, 0x1EA43EA4, 0x54596B9C, 0x6B72E764,
            0x44C6368A, 0x5AEA1A75, 0xC761A9EC, 0x9CFC81F9, 0x3509F589, 0x149B92D3, 0xB3B0A028, 0xDF227C50,
            0xAE63E929, 0xD69EBD53, 0xDC705D4A, 0xAE4D1018, 0x96A96F10, 0xDA2CCE13, 0x9A1DCB21, 0xFC583EF0,
            0x3F3F5A47, 0x380BB816, 0xEF2F88E0, 0x01B76B03, 0x9D26C50A, 0x3BBC0902, 0x43E05210, 0xB7A4D00D,
            0x1B5B8E65, 0xCB40CF0D, 0x94AE0D2B, 0xA4EE59AE, 0x20008EC7, 0xACF50B32, 0xB509B8CD, 0xB055A154,
            0xE249D13C, 0xEF6FC347, 0xEF54AB98, 0x16ACABC0, 0xAEFDD85C, 0x02283066, 0x27C49FB1, 0x48E4BA5D,
            0x44D43E8E, 0x611C866E, 0x4CDD500E, 0xA08F59DF, 0x9FF93B10, 0xDED8C86A, 0x18738C02, 0x3ADDE672,
            0x0B3E91C6, 0x946B7EB5, 0x35353F01, 0x1418F17E, 0xEC0D498B, 0xECAA3A12, 0x2E4E9440, 0xD333BF3E,
            0x94F44226, 0xBB9F6CC9, 0xAAC4A39E, 0x2110F397, 0x3CFBAF1B, 0x0DF4916A, 0x480955D8, 0x30794816,
            0x597347B2, 0xCE5D9BCA, 0x5CA54A6D, 0x26B88064, 0x65777D4D, 0x96128B20, 0x78C2586E, 0xD0FE507A,
            0xC7620B0A, 0xC973646C, 0x57A13032, 0xF4057DF5, 0x67FFD3E0, 0xE636BCE7, 0xCB17294C, 0xC22DBBE7,
            0x5DD03ED0, 0xCB895BC1, 0xE7504C25, 0x6D6A5B89, 0x30D36E29, 0x4F3B34E0, 0xFEB74722, 0x45A291EE,
            0xE68BA911, 0x1A874473, 0x3FDF1FAC, 0x324668D4, 0xEE74F7FB, 0x5C69C332, 0xCC58437E, 0xB15124CD,
            0x526D5F8C, 0xFC288C30, 0x34EE6306, 0x7175E868, 0x257144B4, 0x80029738, 0x9016971E, 0x6562E21E,
            0xDEF0A829, 0x6A66887F, 0x9776BC56, 0x91B6A570, 0xAE47D11E, 0xF2FC8EBF, 0xA8359B49, 0x62B4D936,
            0xD320D63B, 0xAD4D1FFF, 0x84370A07, 0xDFFB86BF, 0x8CBA742B, 0x345D4D19, 0x332099EF, 0x393282E0,
            0xEC3D6599, 0x5B628338, 0xBE5D0F49, 0x2B57905A, 0xC4BE9FF4, 0x490CCA0D, 0x4C60AF2C, 0x48000464,
            0x3CA2C6C4, 0x9BB82B44, 0x914B47B8, 0x373832EB, 0x9564CCA6, 0x1EB3D183, 0x55BD207B, 0x544BD839,
            0xC467B56C, 0xED2DD504, 0xFDF9C6E8, 0x3C40817D, 0xA9586B3C, 0xA9688D7C, 0x35808120, 0xDFF35031,
            0xA192FEB0, 0x6FD1B62A, 0x2183257B, 0x9FD0E236, 0x3C4EF749, 0xA1523751, 0xE2ECB820, 0x8501AB24,
            0xCF094196, 0xBAD88F42, 0xCB52423E, 0x7ED6A481, 0xF73C1EC1, 0x99E4FA86, 0x389652D9, 0x83A19A9F,
            0x9C869E35, 0x46C90636, 0x21691459, 0xA661EA4F, 0xBE903F2A, 0xCFEDBA9F, 0x116365AD, 0xA54C448C,
            0xD5E76D89, 0xBCA74C1D, 0x3BE574F8, 0x06D2796B, 0x8D6506C9, 0x16749522, 0x9837B229, 0x24FC9987,
            0x7C55F7D1, 0x63D90CE9, 0x18F90297, 0x22E3A461, 0xCE19261C, 0xA9EE8CD5, 0xD54E44FB, 0x8BE7F73A,
            0xE63D3BC6, 0x5490D630, 0x49C23ACC, 0x77BC7656, 0x73C6B72D, 0x9F299667, 0x6705A3FE, 0x2A531B4A,
            0x8C8C73F6, 0x93DAD8ED, 0x36AA068F, 0xBE73B923, 0x53D23902, 0xCA08EBFE, 0x1496199D, 0x0AEFAF70,
            0xF84FCDCD, 0x2D68D111, 0x6B9A27CE, 0x64EB892B, 0xADBEEA7B, 0x916A1A48, 0xAC2220F2, 0xE66AC0A0,
            0x197F64D8, 0x9B175E5E, 0x017467DB, 0xE99F0DFF, 0x23A4A2E6, 0x9598ECC5, 0x68BD223B, 0x52B96320,
            0x8D6B68AF, 0x636C38BC, 0xDD4F8BDE, 0x08DB5791, 0xE17B2112, 0x04B7D391, 0xE5FC53EF, 0xB6E7CAD3,
            0x2994C8CE, 0x9FA35B10, 0x350D9F84, 0xB1E26ADE, 0x0EFEC5D8, 0x07B25FFD, 0xE7845AD6, 0x3D7E745E,
            0xAB243C9A, 0xFE2A4043, 0x0FD105FD, 0x7EA1877E, 0xE5C85570, 0xDCCCE559, 0x07B7BED1, 0xC29856E7,
            0x65460971, 0xD8BA0F59, 0x940BA417, 0xF04443CD, 0x2AC30C52, 0xB9E2D1D5, 0x68B9035B, 0x0AAD6C3B,
            0xF405FAD4, 0x790CB501, 0xB3780CCF, 0xB5BAA978, 0x9FE6B4CB, 0xE11F44DC, 0x26C6E0CD, 0x83A0C01F,
            0x29458F1E, 0xADB0648C, 0x1A94FAAC, 0xEA3E843F, 0x73F46133, 0x7B7FCB1A, 0x94DCACB7, 0xCCFAECD5,
            0xEBEDC392, 0x0F082550, 0x89EFA97A, 0xAB5B94D4, 0x988CD484, 0xA542E964, 0x482A10C1, 0x5BC5D15F,
            0x2C7CA421, 0xB70B3E1D, 0x5454EE54, 0x9C30893E, 0x22307BC8, 0xECC6EC5A, 0x93B06FFE, 0xDA31FD1E,
            0xB622AC4B, 0x937273C0, 0xD5406DC2, 0x5B0E9B9E, 0xA10E388E, 0xE7B639AC, 0x3E097430, 0x70FAB1D0,
            0xC08EAF04, 0xC1C49281, 0xF249EE92, 0xDC7CBB94, 0x3185A57B, 0xE694F38E, 0x57AB4679, 0xC94359B2,
            0xC9790DBC, 0x05BB8659, 0x9FE5F1B8, 0xDABCCA7F, 0x2B11CFC8, 0x355EEFEA, 0x4B183754, 0x0EBD8C96,
            0x125B9BC4, 0x32A3B230, 0x5AC52EAC, 0x1A1C8742, 0xF96627A2, 0x1A022D7E, 0x50224430, 0x08D08451,
            0x997F4FE3, 0x5278CE0A, 0x9F5FBA0C, 0x718F965F, 0x7FCA1346, 0x94C9064F, 0x370F58A4, 0x484E46EA,
            0x9B6ED241, 0x1071C2BB, 0x761C5F51, 0xFAFFF007, 0xDE6F9D41, 0xA48229ED, 0xA01E5469, 0x9DE11E95,
            0x15118FDA, 0xC30E6E20, 0xF27E17BE, 0xA590653F, 0x4EC1E5E1, 0xA425AB72, 0x702A1450, 0xFA5D5F0D,
            0x912123E6, 0x337E1042, 0x01668CEB, 0xE459C062, 0x5C9C192D, 0x6BB12B9E, 0x9269FC1A, 0x1FB3D30B,
            0x19123861, 0x142AC332, 0x8A6375D1, 0x7819E049, 0x71DC84D8, 0xD934D744, 0xFD3269D5, 0x102EF123,
            0x0A76BC1E, 0x224E33AB, 0x4655A323, 0xB4967943, 0xE73D05F0, 0x9A140B73, 0x5C01003A, 0x19C2787E,
            0x28E2C617, 0x731E579F, 0xBE634F39, 0xADE2E002, 0x7844602C, 0x03CD6BD7, 0x7B0DABC6, 0xD0AA169C,
            0x0C9F4469, 0xB2DD6BF8, 0xD8E16BAF, 0xEDEC5ED2, 0xAAFC6FD6, 0x64AA8F9F, 0x3994324D, 0x4CA76A7A,
            0xC1B9E9CF, 0x7F619009, 0x6A1E7E39, 0xA1329B65, 0x234BFDA1, 0x70AE2D87, 0x540DC745, 0xE4DFD9E8,
            0x2EED1C66, 0x3A917ACA, 0xF4AF629F, 0x65FDE1A3, 0x1A5D9952, 0x015504AA, 0x28F6EF4A, 0xD98A472B,
            0x75257D13, 0xFAC8D09C, 0x86476254, 0x3B8FED96, 0x32DDBB38, 0xE84C50C0, 0x282FF7E9, 0x9697B047,
            0x4B22740C, 0x80D4963A, 0xAB30AB93, 0xE9A93D5B, 0x9BAABBEC, 0x371750B5, 0x0FA9AC50, 0x2306ECB0,
            0x35891BF3, 0x174C8611, 0xB9A1105E, 0x52981B03, 0xE7A6D0D9, 0xCA412558, 0xA8A284D3, 0xD35A153C,
            0xEF2F3BEF, 0x9C1D3066, 0x92AFDDC5, 0x96C9701B, 0x2B4C2524, 0xAD913510, 0x06053997, 0x88E5D6CB,
            0x91B2370A, 0x7F3567D0, 0x86489CB5, 0x8BD5D8DE, 0x662DADD5, 0x306B3E3E, 0x7F7A0226, 0x331BAFEC,
            0xBE824132, 0xCD421903, 0x19029859, 0x48A30741, 0x61349AE4, 0x6E21E2AE, 0xAAF24219, 0x751B423B,
            0xE582C5B6, 0x214783E3, 0x799C5CB0, 0xC5242035, 0x23B8EB9A, 0x2FCCCF84, 0x979E0258, 0x7604FB20,
            0x15576FDA, 0x5F1F348A, 0xE7D21239, 0x8ACA7089, 0x47DC9D90, 0x8F80C65A, 0xFD4E978D, 0xFA64E4C0,
            0x8C5670EA, 0x1D41812F, 0x68417ABD, 0x4A855658, 0xAF3E83C3, 0x28CE8BEC, 0x0B47CE7B, 0x3D4BDDB7,
            0x89890712, 0x75BC9576, 0xC913E8C8, 0xFCFB4CDA, 0xD7EF1630, 0x649B0ACE, 0xB0D41856, 0xF3D134CD,
            0x9533F082, 0x9373B065, 0xDC89C223, 0x87141A10, 0xB308727A, 0x4A29BE2D, 0x853D59E1, 0xE087571B,
            0x0BD28B50, 0x840BC78D, 0x35BA9CFF, 0xB411ED3C, 0x39D838C6, 0x0DBE1F70, 0x92FB0CE9, 0x56483940,
            0x02DC0CAB, 0xA4D26B3C, 0x085A16C6, 0x83E2482F, 0x63A04C29, 0xFDD73DAB, 0x5C636809, 0x842B3993,
            0xD7D0C323, 0xB10D2732, 0x8D7305A4, 0x8EE8E411, 0x06E240BF, 0x0B7D3AB5, 0x7F3CB3B8, 0x74A9DBCE,
            0xAAA38941, 0x4D433E8A, 0xAF161F98, 0x5D80214C, 0x46FDCB8B, 0xA25D51B7, 0x8E242594, 0x0502D531,
            0xFC09FE9D, 0xAE61F3F2, 0xD2BDDD33, 0xE7830CCA, 0xFBE7472E, 0x7A5B23CF, 0x9B814A6E, 0xB8BB3792,
            0xCD9D1906, 0xF1585BC5, 0x24D42FB4, 0x38054DB0, 0xEF007A17, 0xAAD04F73, 0x9C5C0138, 0xD662D89B,
            0xAC93EC1E, 0x516F6700, 0xCAA4042D, 0x0779FFEC, 0x40E66182, 0x407615F7, 0x6FDF8907, 0x7D0C4FC4,
            0xB637A950, 0xFD51913F, 0xBE071CAA, 0xC40DDCC8, 0x872A693F, 0x909DEB5E, 0x85F8035A, 0xDB893711,
            0x1E6B2DAE, 0x71B2A9CC, 0x9B0E2B26, 0xEB4FE80E, 0x5DADAA61, 0x41B0F454, 0x264753DF, 0xFAFE9A7C,
            0x6E968D80, 0xCF7C36D4, 0x97B63162, 0x3AFBFEA8, 0xB77ACCE5, 0xE764FCF6, 0xE34107A5, 0x56DEDC57,
            0x7C2B057B, 0x2AE8CA02, 0x64455A2C, 0xFAB69D3C, 0x1DDE23BC, 0xADCC9F4E, 0x62050408, 0xC8A43086,
            0xA1663863, 0xE74865CB, 0x99FBA2FC, 0x7EEE50DD, 0x5C0C5530, 0x625AE2BA, 0x7211CE56, 0xADF58E6F,
            0x69DFFCE3, 0x0F57FFA4, 0x5164BAA4, 0x163CBAAE, 0x665475AC, 0x741246B1, 0x3CB91D9B, 0x5F827F86,
            0x167E463A, 0x4B01B17B, 0x8A3FC1C0, 0xA2BF8979, 0xF5ECF97D, 0x2D0443B3, 0xE3B12FA5, 0xDB9AF69F,
            0xACE51598, 0xD0505482, 0xED76F2A8, 0x8B674CBC, 0xBA136C8A, 0x7042C8D6, 0xA549A34F, 0xE097A957,
            0xD1A82D92, 0x1B0A1649, 0x2D1C529B, 0x1895F7B5, 0x6F608909, 0x184F797B, 0xC9239200, 0x71BAB879,
            0x90E38933, 0x4159BC22, 0xDCC9BCAE, 0x55CCD0CE, 0xD5AB90BB, 0xEB4A73BD, 0xE86F9B36, 0xA3BDF1DD,
            0x84543AA7, 0xA95CA4B2, 0x71C9C2FB, 0xF85C35DE, 0xDD60BEFD, 0x0A12294E, 0x5BCFD3E5, 0x3BF6F5D9,
            0x1688B1E4, 0x73FD8D49, 0x542DF280, 0xF5F7A8AB, 0xEA0F99E1, 0x4AF23760, 0xDCD6070F, 0x567D635D,
            0xD161CAFC, 0x0A4C8814, 0xC07930D8, 0x42D3874C, 0x34A5EF57, 0xFD0279B1, 0x52FAB415, 0xF9FC1AA3,
            0x07F10F55, 0x98E5B360, 0x7D7222CD, 0x30C4FA50, 0x3F4516B9, 0x4B1E9A33, 0x8D0DF6ED, 0x2A571C7A,
            0xD49122FA, 0x363710F4, 0x79EB27CC, 0xF2FF7792, 0xAA4A0FC8, 0x62E0EB3E, 0xF3563888, 0x2A0F5E48,
            0xF89B3998, 0x2C6315CE, 0xF018322F, 0x5352EAC5, 0xB337DA25, 0xAF25EA35, 0x438D0BC7, 0xA056CF8B,
            0xC42482CF, 0x01E44F09, 0x2D26DFB7, 0x23E7D3AA, 0x48C25CBE, 0xCB950F7F, 0xAC86F9E0, 0x02DF8EE7,
            0xEA3C78AD, 0x57F9E761, 0x8B627CC4, 0x63E10D13, 0xC9B58F12, 0x9CD77D27, 0xABAFC147, 0x2D136B1E,
            0xF21DC630, 0x9002DD86, 0xE72718B6, 0x39B3ECD2, 0x9FDF8BA3, 0x9E508D55, 0x3FBEC557, 0x9BB7D682,
            0x66215EEC, 0x6CC57D56, 0xA48CB589, 0xC4E089ED, 0x29776BD2, 0x58FA0CF1, 0x7DE89BD3, 0x82BB77CA,
            0x964FA7F3, 0x7D4505B8, 0x9E14A0D4, 0x47859839, 0xA1E813E3, 0x2B960019, 0x253F5EAF, 0xFDF72D02,
            0xEF7036F2, 0x91441EE4, 0x3AA94858, 0x6323A697, 0xA046AB4A, 0x4AC19A71, 0x55B06740, 0xE5559085,
            0xFACBB6A0, 0xC0711A8A, 0x144D1F56, 0xE2E81D48, 0x86303A0A, 0xB9746E77, 0x14871324, 0x9D40441E,
            0x433B8E49, 0xD3F455E0, 0x009FFD74, 0x312877E0, 0xB87A986F, 0x70DCB61E, 0xC0A3A1A0, 0xF938E4B5,
            0x61AD5456, 0x27A0FE94, 0x92EE5CA1, 0x70A17CD7, 0x9B923CAA, 0xA0440BC5, 0x7D2DA2B4, 0x1B11EE9D,
            0x349FE36C, 0x9E92FD96, 0x13D06333, 0x0C6D6A8A, 0x4A7AE45D, 0x20840BD6, 0xEA8273B5, 0x64244EEA,
            0x0E3D17B3, 0x9CFD1DED, 0x56544A41, 0x2CADD975, 0xD9672BCF, 0xC1D36C87, 0xA305CBEE, 0x63F93C35,
            0x55104EE6, 0xEA006B62, 0xC8FE1D2A, 0xF6EFDAAF, 0xBE9CA9D3, 0x12C1C636, 0x38EE110E, 0xEA3B7B92,
            0x0A961E09, 0x99F8FBF4, 0xEB2B0A84, 0xCB7F1ECD, 0xC695A949, 0x782F57B8, 0x99833BFB, 0x678E9DF0,
            0x33602621, 0x9E58EB44, 0x2FF0382F, 0x15CAF1E1, 0x8518BB96, 0xAE936C43, 0xE6D1EB39, 0x8AAA1C98,
            0xC854EB7D, 0x3162E901, 0x68D59068, 0x77C1A97F, 0xB0101BB6, 0xFEE5039B, 0xCCDE3F81, 0x6F6E4538,
            0xD11C39AF, 0x7CE64795, 0xECF2DB1A, 0xBB989DB8, 0x0AFCAD7A, 0xDC82322D, 0x9EDBDF72, 0x9E0ED476,
            0xA5F98823, 0x8DD813AD, 0xD622E04B, 0x9C42ACD8, 0x9BD52DAB, 0xE9F8B850, 0x07912785, 0xCF4EED20,
            0x7C4D7276, 0x3058066B, 0xA91DB9E3, 0x0CB797DE, 0xC0A34643, 0xD9746949, 0xE79DEAEA, 0xBE3A6ED8,
            0x1D45CDA5, 0x2534FE29, 0x49075E8C, 0x0D1EAA1C, 0x840A1C29, 0x5B1E2A75, 0x993A919D, 0xFA1063C4,
            0x2A854D7F, 0xFEC71A63, 0xC97263D3, 0xD8B26017, 0x804DAEFC, 0xFC918517, 0xEC2D5714, 0x6EF84CF0,
            0xA53394E2, 0x9D4516CB, 0xBC058A40, 0x9E6DE7C8, 0x5AE88950, 0x18650514, 0x69AD1E1A, 0x0CF62A01,
            0x2DAAC8EE, 0xA80FA6BF, 0x3A12DAD3, 0x184A5D76, 0x36E23CC6, 0x213C629F, 0x9112484F, 0x02E78AB2,
            0x0156F59A, 0x2B5BC175, 0xFBA7A76F, 0xD1BC58B2, 0x9B629D5F, 0x6970B94A, 0x034DF676, 0x02DA9EC3,
            0x61C991A3, 0x544A0B59, 0x8D890E98, 0xF7BB7701, 0x37A89FB1, 0xDBDFA124, 0x9BF2F7F6, 0x5FCD97B3,
            0x5E915765, 0x0B739199, 0x45B7A1B3, 0xDC48F555, 0x40F36286, 0x6B55541C, 0xA4C0C64A, 0x2C6C07BA,
            0x015FD4B4, 0x1B7BE865, 0x408F05EE, 0x8681BB09, 0xC1ED38C8, 0x134309EB, 0x90ACCB51, 0xF224E20B,
            0x14370CD3, 0x3729CB48, 0x9B52C57F, 0xDB1D540C, 0x431891F4, 0xF74F511E, 0xFC910A13, 0x1D0B0135,
            0x6DA7D68C, 0x1DC0D1B0, 0x979597A0, 0x46534AE4, 0x37FF6FD7, 0x5A317649, 0x048CAFCE, 0xCF69A691,
            0x31767761, 0xFF767C7A, 0xCF4BEBD6, 0xEF524E26, 0x39C8B41A, 0x048FD124, 0xDB28AFA5, 0xC4A33005,
            0x0F6623A3, 0x422A270C, 0x9AEFAAA1, 0xF2C0D5D2, 0xC9CDE84C, 0x1C46C05A, 0x0FAEA4B3, 0x901954A9,
            0x5B7A7630, 0xE38CD998, 0x185F18F7, 0x17711758, 0xC756A0B9, 0xF9DB74ED, 0x15C1A3EF, 0x534775AD,
            0xCEF80C0B, 0xED1BD67F, 0xA3343855, 0xBA1B65E9, 0xF47685B9, 0x187CC153, 0x028E6B38, 0xF4F28F39,
            0x5C22372B, 0x011158E3, 0x81CCCFEB, 0xEC468E8B, 0xE31EFFDA, 0xD8EFAFA7, 0x11D24686, 0xF08D83C6,
            0xBDE8A4F7, 0xE1F3A385, 0xBB0E9751, 0x497F6F08, 0xE0E43AB1, 0xDA0629E7, 0xAFD6737C, 0xD8DF17DE,
            0x970DD6AB, 0x6553AB9F, 0xF0DEA154, 0xEA029DBD, 0x7BFD2F38, 0x53FC6F56, 0x37399E4E, 0x618600B7,
            0x3B77438B, 0x79CB6B7B, 0x1DDF0A4D, 0x3500225F, 0x8A8C2EB6, 0xDB147786, 0x83464C38, 0xCB0D7BA5,
            0x3B569B94, 0xB8BE9FDE, 0x8C63F79E, 0xD9C4E90F, 0xA39E3B2C, 0xC0823F5C, 0x211F9FF3, 0xC56021A4,
            0x70B5FD26, 0x009EA8EE, 0x610DC81D, 0xF21B15D1, 0x3A194B3E, 0x93176AAF, 0xFC166DDC, 0xBCCF66DA,
            0x98BD7E72, 0xFD3EE475, 0x72035542, 0x52C1FEFC, 0x828761DA, 0xBFCEAFD9, 0xBD08EB64, 0x84ACE87A,
            0xDFEE9867, 0x00F1FC6F, 0x772C5FDD, 0xA685DE90, 0xAD09FA37, 0xA9CA68A5, 0x9DF6996B, 0x322DB2A5,
            0x48F53B49, 0xFB3AE596, 0x487EF72D, 0x5D1CC1B6, 0x5E73CD65, 0xE743F8C8, 0x4CE45012, 0x0475E743,
            0x95125D36, 0x79E56B8E, 0x02603A83, 0x273E0885, 0x2692079B, 0x5CC13FDB, 0x5C5FAF9C, 0xC98ABAE8,
            0x1C4F8712, 0x7CB0ED2A, 0xE4B1EB97, 0xA9FF72F7, 0xFBD053FD, 0xAD5C745A, 0x4FA45A6C, 0xDC718DD5,
            0x1B33A904, 0x282B5D55, 0x5669D533, 0x271A0D37, 0x88EEB927, 0xC7962260, 0x1C11D5DF, 0x1B977D64,
            0x617401FA, 0x64253D33, 0x4205C7EF, 0xB27EDCCD, 0x641C8361, 0xF1BE833B, 0x4B02E293, 0xE46D6119,
            0x1E9D633F, 0xE013A44D, 0x797B4010, 0x9BF50E1F, 0x14FD2572, 0x0ADC4381, 0xCE0D2E14, 0xD4902EAD,
            0x7E97D3AF, 0x27C472D5, 0xE63C912A, 0xBF6AECF8, 0x6A0F8955, 0x32E9C42D, 0xE174FBA1, 0x161424E8,
            0xE1163DEC, 0x2EFB2D7A, 0xB60CF687, 0x9A76E3E6, 0xBB9A4090, 0x6A5DCBE4, 0x8B6AD6CF, 0x1D502778,
            0x8BD677FA, 0x9B3257C6, 0x138F14F7, 0x75A3B0E8, 0x0086011E, 0xD33C9777, 0x51ABD823, 0x11492CA3,
            0x71494346, 0xE8B89B48, 0x892489E5, 0x777B1FF7, 0xD7217B21, 0x548BD662, 0x5FF3C8D9, 0x3B2839C4,
            0xAB809618, 0x40743CA5, 0xA21B0060, 0x7D01618F, 0x54B5CEB7, 0x64B0BE5E, 0xE3B3CFCF, 0xE7D45C66,
            0xB05E24E5, 0x820CC208, 0xB0D7EFD3, 0x2C44929A, 0xCB8CD9A4, 0xB08B9367, 0x4B5C0D7D, 0xFB80EBA0,
            0xE9817E55, 0xD483A76F, 0x6FCFE7F8, 0x1D02DE8E, 0x43FE6AE8, 0x1EDBC192, 0xFB49431A, 0x3FA23E65,
            0xC3CE9376, 0x17F996FD, 0x1A00EAF8, 0xE81ECEEE, 0xB345152D, 0x09600458, 0xC2C87230, 0x257A21AC,
            0x5B09CF25, 0x2EC76EFB, 0xF2C4FB89, 0x8FE4F6CE, 0x09A4BCAA, 0x9E20CFB8, 0x8A530BF3, 0xCBF9070B,
            0x12007D3E, 0x933EA9B6, 0x8788831F, 0xC4D06702, 0x7FF9C964, 0x06ECEA74, 0x85C547E1, 0x28D22C8D,
            0x4375FCA8, 0x6CCDE8A1, 0x1B21525E, 0xB153C2E5, 0x7C98C3C9, 0xDB7403F1, 0x0B048314, 0x37F9F527,
            0x8651588B, 0x9D1B692B, 0xB65949FB, 0x2CDDA4C8, 0x7125018C, 0x1164DD9C, 0x2B690595, 0xF9CC6295,
            0xC4C10B80, 0xAA4E469B, 0x93709041, 0x6C7BB331, 0xD80947ED, 0xFF7C43F9, 0x7D5BED39, 0x9E23A952,
            0x0E3BDEC5, 0x533B0FA1, 0x50F7E11A, 0xFEFBFFE0, 0x9F3ADB3F, 0x9250F55D, 0x3275927D, 0xB3848A99,
            0x9F7B45D3, 0x6777AF5B, 0x0E3EB512, 0xCA4625B1, 0x99633515, 0x1A61448C, 0x24F20E64, 0xC4D71234,
            0x08D8503C, 0x3075F81B, 0x5AE774A1, 0x0E00A136, 0xBE2F1BB2, 0xF53C78E6, 0xD7794005, 0x5D1E4CDC,
            0x0CED92E5, 0x287E5CD6, 0xEFEB35E1, 0x17E9ED8D, 0xD5B14EE3, 0x13019036, 0x33193767, 0x6B3EEFFE,
            0x9D8106AE, 0x3919D5B2, 0x5BABEA31, 0xC4C1E930, 0xA6A80BA8, 0x0D54ECF2, 0xC8310FD6, 0x93EE6F26,
            0x800CA2F5, 0xF4779ACA, 0xC786C6C7, 0xE0F25CDB, 0x842C9CA0, 0x16BF13C7, 0xD86B039E, 0x05858D40,
            0x874D3E0E, 0xF39B67FC, 0x19A1605F, 0x049CDCAA, 0x8089E5B0, 0xC25EB2AF, 0x0E0DBB16, 0x59171DF5,
            0xB61401DF, 0x13F28B54, 0x49279C66, 0x6CCB5351, 0xB03C9BA5, 0xE088434B, 0x646C1286, 0x204C07DE,
            0xE950D13F, 0x2FA23A73, 0xAED7B587, 0x80D02487, 0x2B3AA84C, 0x36683066, 0xBA4CCE25, 0x7E417C94,
            0xC582D8A9, 0x281F0790, 0x7287BE2D, 0x6803FEA3, 0x33ABA7B1, 0x7B753EBA, 0xB94FEA41, 0x1F9BC3A6,
            0x52CFE8CC, 0xFC98F8BE, 0x4A725197, 0x8FD4C337, 0x4656C7BE, 0xDF5AB4AB, 0x9B657532, 0xA2F46EC2,
            0x11EADB85, 0x98CFCEC4, 0xF77463D9, 0xF00C93AC, 0xF06FCEE7, 0xE37E6894, 0x2DC47B7D, 0xE1ADC215,
            0xE13A0540, 0x7223E918, 0x6B3A6280, 0xF98A30EB, 0x42DA11AE, 0x2C12DEAC, 0x362E9F61, 0x63CCF958,
            0x731E2FD0, 0xE95AB9F9, 0x22EDDFBF, 0x02E4EE5B, 0x942DA925, 0x1531BDDD, 0xD9331D09, 0xF8706132,
            0xB08FCDC9, 0xA2AAF7F8, 0x88F70079, 0x9C41D5AF, 0xBE3E7E60, 0x11B87260, 0xDD0EE23D, 0x30055722,
            0x3EE72EC6, 0xC6752DD4, 0xFE587A43, 0x1D0C4E56, 0xB5A48EF2, 0xD2BF4FB3, 0xCA980B61, 0x6D874BB7,
            0x9F15C7DB, 0xB2F400BB, 0x05568A86, 0xB46FA690, 0x9002993B, 0xA20F819B, 0x081BB037, 0x460F89CF,
            0xC52D6395, 0x37E3DFA2, 0x2301D221, 0xE7D690B4, 0x5755C68F, 0xE2A3ACE1, 0x6422F55F, 0x87AED724,
            0xE99BDEB1, 0xA71D23AB, 0x6EE30009, 0xC232877A, 0x654890BA, 0xD88A7921, 0xF8C5D1A6, 0x23F91A57,
            0x9DD31A1A, 0x5FB03772, 0xE1972079, 0x24E65D9C, 0x411B166C, 0xD658555C, 0xD5E15530, 0x16C64B19,
            0x8B13315A, 0x7D3EAEDA, 0xF22BB8FA, 0x757D5608, 0x2AF95A7A, 0x408D3DFA, 0x5004629E, 0x1A740C51,
            0xA4FA46DE, 0x86A30105, 0x1B373214, 0xA5F486E8, 0x915B92D2, 0x6EE8363A, 0xD5C54489, 0x6D80D699,
            0xDAF6DCED, 0x13258077, 0x59FDE52B, 0x72836D9E, 0xF3ED9EF5, 0x03830F62, 0xD96EFD5C, 0x5ED0C680,
            0x4D0DE793, 0x99D017A8, 0xDD545E27, 0xBD6E5F0D, 0xFCA69F4E, 0xA6B8B437, 0x428A5AC3, 0x63DB6B35,
            0x342E16F7, 0xDC44F45D, 0x7BCEC440, 0x4F9FF5FA, 0xF6AC6FCC, 0x0C8BA010, 0xCE9570E6, 0x5034FD37,
            0xFCB2DC04, 0x56AB3F2C, 0x4005C3C2, 0xAAD904B3, 0x9A29F024, 0xEE08EBC5, 0x47FCFEE4, 0x28C1B595,
            0xED07119A, 0x7BA4AEF6, 0xC37A9B32, 0xD0054B40, 0x60620784, 0x98CE0825, 0x47CF0ADA, 0x0779ADF7,
            0xC3406227, 0x5037160E, 0x7FBD4EED, 0x9E7401F7, 0x201A029D, 0x08EE0150, 0xA107AAE5, 0x66CE3D23,
            0xF4AABB9D, 0x89877F3B, 0xE5113DBD, 0xCDCD43FC, 0x9C050C8C, 0x21EEBF66, 0xA4A6A70C, 0xBD43D26F,
            0x83C2BDFC, 0x6E15C486, 0xC050779D, 0x841597CF, 0x869BB710, 0x7B8480F1, 0xDB7CF19F, 0x00A9E221,
            0xDF1C11EF, 0xB4CCC7BF, 0x8CFA03C8, 0x0481822B, 0x7AD5EC61, 0x8FE559CB, 0x3E08F32C, 0x0364B855,
            0x16C5029A, 0x0590E128, 0xFF5AF2DE, 0xFD53F918, 0xA8B5D471, 0xA6ADC7D8, 0xA9F05A61, 0x7E7AF53F,
            0x7824BC33, 0x8A5EA5E6, 0x87E42728, 0x6E35B760, 0xBDDBDE5F, 0xB09D31DF, 0xE832E3B9, 0x608BCC8B,
            0x77ED1C73, 0x300051A9, 0x4ABD5F42, 0xC8C204AF, 0x914DE4BF, 0x63CE9BAB, 0x3898ABE5, 0x4E75F04C,
            0xF361ACBB, 0x6DFC79D0, 0x316E9E9E, 0x1C6B85D4, 0x0860E22B, 0x5B5881E3, 0xB0EE854D, 0x446B0376,
            0xD2E672A9, 0x5D68BA63, 0xB63B2FB4, 0xC9B310EA, 0xAD497C1B, 0xB4568E42, 0xAF8C025B, 0xDACFA3CE,
            0xF261FEBF, 0xE0A24F1E, 0xE2F39ED7, 0xACEE58C5, 0x7BDF666C, 0xB9B710BC, 0x3EA19849, 0xDE48ACB6,
            0x4ACD84ED, 0x4E4D197C, 0x04C22CFF, 0x227D8CBA, 0x93D0CD92, 0x08A0A8DA, 0x81B41C2D, 0xC6C9C97C,
            0xA36E396C, 0xEA07692B, 0x68E9DD2D, 0x6441B012, 0x05BD769E, 0x743148DA, 0x61A97FE4, 0xEDD86B39,
            0x868AA0B2, 0xD4BDD386, 0xE2787B17, 0x6DF9B38F, 0xD9E26C9F, 0x96DBE4A7, 0xEC95360C, 0x7B38BC1B,
            0x4C2EC107, 0xE510DF21, 0xEDAE89A6, 0xA1803E06, 0x29F8F18E, 0x5108E48C, 0x7AE7A1D6, 0xBEC43D2D,
            0x5E1DBC00, 0xC9795596, 0x660CDBE5, 0x087C60B5, 0x4042A4EC, 0xB9AFFDCA, 0x4AE50174, 0x956D8530,
            0x850C7821, 0x04D63F82, 0xC78D1CCC, 0xFAE8E560, 0xB1F4B42E, 0x30C597FF, 0xCAC87C77, 0x5CE1CC53,
            0x6BFF7EFB, 0xEB4FC7C6, 0x1BA61826, 0x9767E97F, 0x445FF022, 0x55601065, 0xD4149FA0, 0xB1352A8A,
            0xAB627929, 0xFCBFBB1B, 0x8DC6C73B, 0x24EC21DD, 0x71A60463, 0x915B10C6, 0x306DCFC5, 0x1771E3A3,
            0x6C0DDB5D, 0x86A61E33, 0x5F2CD5AD, 0x97C456E4, 0x4DCDF1B7, 0x8F4A2862, 0x3DF057F0, 0xFD378299,
            0xFF91257F, 0xA2A3AAD5, 0x070992B4, 0xB290D615, 0xA2A79EE4, 0x0EB7A818, 0x1CB37541, 0x0C6A7B9B,
            0x351FFA49, 0x0BE9E4FE, 0x4735439F, 0x887ED1B4, 0xD2396545, 0x587369A3, 0xCB51EE99, 0x55E5052F,
            0xEC92BA9B, 0xEEBD4775, 0x0D9D252A, 0x5213C027, 0x15CA4078, 0x1AD81E18, 0x639BC363, 0x9AE8354D,
            0x95791B4F, 0x0C4FA54F, 0xF0155BA4, 0x95E354E6, 0x648D8343, 0x6E0AECAF, 0xE726B798, 0x8788F3E6,
            0x89FF3B99, 0x7D899C2E, 0x0BC88322, 0x7F77AF81, 0xD908BC10, 0x5A32928B, 0xFC0A3BAF, 0xFEA6873E,
            0x771E314D, 0x2DF22C27, 0x64A748CE, 0x8F6CB801, 0x3DB30A07, 0xA805370B, 0xA9732033, 0xECB53592,
            0x0B117204, 0x2078E90F, 0xC26660E3, 0xC55962AB, 0x1DB9ACAB, 0xADFC8623, 0xE109DC26, 0x18BC9389,
            0x0E71ADCF, 0x47FA3953, 0xF38339BF, 0xC01C2573, 0xAF73D118, 0x68A1309B, 0xF9C6789C, 0x7682E7E2,
            0x313E8378, 0x4DDE77A2, 0xFCB15AF9, 0xC7E3754A, 0x2FE04EEE, 0x221EEF7D, 0x801AEC66, 0x6F100998,
            0x2D9149BA, 0x0CE746C6, 0xA7837D16, 0x8ADB540E, 0xAB3208D7, 0x256E08BD, 0x75EA78D9, 0x98BE0FF3,
            0x10CC2902, 0x5B1C747B, 0xD75FE256, 0x57FE1803, 0x08E6FB26, 0xE4F647DA, 0xB3E91A48, 0x45600C00,
            0x6D13FFB6, 0x0D6EDB4B, 0x468A608E, 0x3B256E03, 0xC9DE3CBF, 0x0C646F7D, 0x72C6A715, 0xF481C93B,
            0x0E9FD570, 0xD3BAAC10, 0x23323054, 0x9EDF7374, 0x6E24E024, 0x1A15D9EA, 0xEE5146C7, 0xFC1F1FB7,
            0x261B1B33, 0x330F23A6, 0xCF124E17, 0x3AA40F97, 0x212EE90F, 0xE5317D43, 0xE65DABC9, 0xE1A903AF,
            0x5B36B7DB, 0xD38C0F3D, 0x2444D0E6, 0xFB4F6A8E, 0x8F25EE09, 0xD6A8F5DE, 0x4C009351, 0xDE7A651C,
            0x0C568292, 0x65DFBAFE, 0x6BBB1A5D, 0x6D44DE2B, 0x50F93151, 0x9ACDD3C0, 0xB143F1C1, 0x4ACD42B9,
            0x2406C3BB, 0x3F813E43, 0xD122168F, 0x0C70B7A7, 0x1447F677, 0xC85E41F6, 0x058E5728, 0x58524989,
            0xCBF951CB, 0x22431EF1, 0x6A5C989B, 0x4F30332F, 0xCD79A8C5, 0xF50CC33B, 0x6A02B20A, 0xC4BA5F9E,
            0x653632DF, 0x4A519489, 0x99BFBC5E, 0xF31F053E, 0x90F2DD03, 0x717E1A5A, 0x59A10A9D, 0x99C59556,
            0x8466D2C6, 0xE2EC501D, 0x1CA297E8, 0x77657625, 0xF478B411, 0x6DCCAA48, 0xCDA8E514, 0xEBC1479E,
            0x2DF52176, 0xE3A4FDEE, 0x7BBEB2BC, 0x7FC7A53F, 0xE0B15061, 0x7188471A, 0x8388AA19, 0x4B0EAA2A,
            0x5003194A, 0xC9D37805, 0x5D984798, 0x78B2C884, 0xF639F6AB, 0x0B9EEDEB, 0x4D389C21, 0x7D9B630A,
            0x0D9E27FB, 0xFCC34720, 0x2335FE03, 0xE81A9065, 0x333B4675, 0xA83525C6, 0xA2AD382F, 0x5500157F,
            0xC5545C34, 0xA5C4A514, 0x6A97A176, 0xECE148E5, 0x07555A8E, 0x13BDF18C, 0x5C6D2FEC, 0x59DDE713,
            0xE22A002B, 0x546581F2, 0x902258BF, 0x25EC4BC7, 0x33515E52, 0xE1D7F9A6, 0xCF19F08D, 0xD99EB3D2,
            0x3BBBCFBA, 0x66B56B5A, 0x96B8D2AE, 0x44B0B9EE, 0x77E44E50, 0xF4E1E55E, 0x5F7458BB, 0x16B5A069,
            0x45EF71ED, 0x6D31311D, 0x1F6FFCE6, 0x656F83D5, 0xD31A14FE, 0x1C9C7F9F, 0x0FD90B38, 0x9DBD8A20,
            0xB445BD2A, 0x637DED8A, 0x2886542D, 0x8FE1275B, 0xDEEDCFEF, 0xFFB57985, 0xF4F5C950, 0xE030F795,
            0xC66F5B68, 0x76FAD6FF, 0x22BCB190, 0x8220CB36, 0x63BD9140, 0x18FED3BB, 0x62C50C7C, 0x682A1600,
            0xC58AF6E1, 0x6EB0B724, 0xC33AFE7D, 0x33BC3944, 0x29412331, 0x3412A9A9, 0x4A433421, 0x7716FF5F,
            0x20FAC325, 0x805CD592, 0x94BB01DD, 0x4B25E7C7, 0x23A83D1B, 0x1A89CF38, 0xCF740C35, 0x3F795D9A,
            0x9755EFD8, 0x1B0AF2CE, 0x0A59C8D3, 0x55CF22EC, 0x669B51BF, 0x85FEF619, 0x91487BAE, 0x7A02E958,
            0x2341D208, 0xACB937F7, 0x713EF212, 0x6FFAB82E, 0x27F3A5B4, 0x883D4F77, 0xECC4FD9A, 0x9ED3AC3D,
            0x2703AB4E, 0xA7843F44, 0xE13AF574, 0x8F858290, 0xF3E3F4BA, 0x350DD8B1, 0x26687B50, 0x7348BFCA,
            0x8DCB6454, 0xDDB862B8, 0xFD631F75, 0xC5CA6A80, 0x6DF3D3DA, 0x62CFB6E7, 0xC937D8A4, 0x13E56910,
            0x1F3A92D0, 0x4E7A13A4, 0x79673419, 0x41AE7427, 0x16872E08, 0xBCBA08DC, 0x444CF41A, 0x8F75E773,
            0xC59E7ACB, 0xEACA4229, 0x30911A9A, 0xAC99E183, 0x4143D519, 0x07C69452, 0x4DCFA288, 0xE279AD14,
            0xA91D43FA, 0x2550747B, 0x3EADF3D5, 0x8B94D31F, 0x2D52EB88, 0xAB7EEDA3, 0xB96175CD, 0x0755B419,
            0xE8FC5A00, 0xC9AD6018, 0x622B7953, 0x848E46E0, 0xDD227096, 0xFDD695EC, 0x6174A1DF, 0x9535AB60,
            0xB5D5DE0B, 0x060881C2, 0xC02E94A1, 0x90A9BAD1, 0x70782986, 0x26074CA0, 0x18118283, 0xEB01D674,
            0xB0EBA9E3, 0x07FAFA2A, 0xCD1C37BD, 0xAC05F910, 0x0C70D47A, 0xB13CA653, 0x89B398B0, 0x3044086D,
            0x93D9A693, 0xD43CCE2D, 0x452B34E3, 0xF4BA63F1, 0xB2BB0089, 0xFA1C8762, 0xBC4D0812, 0x9034DD79,
            0x69BE81C5, 0x773453B5, 0xC8C384FC, 0x22CED6AB, 0xB9B7AE5C, 0x54E32E58, 0x0366D9A8, 0x5659BE5C,
            0xE27D5EDF, 0x8CEFCE29, 0xF70BD0E6, 0x0D630DAF, 0xFCED2B26, 0x093685C9, 0x4F5FB7C1, 0x4D8CA5E0,
            0xD648A8BD, 0x0871AB3A, 0x2ED5D21B, 0xF74FCEAE, 0xD2DFB36D, 0xF0B121C3, 0x5D4B7673, 0xA4765E06,
            0x596B9FEB, 0xB6F3120D, 0x0CC085CD, 0x9E56B03C, 0x21767281, 0x152FADA1, 0x00889AA6, 0x9E4A1982,
            0xBFDB77BC, 0x43A45F7F, 0xE7CFE923, 0xEA2375A6, 0x1EF352F7, 0xA292BF12, 0xACBA01AF, 0x5D2FB393,
            0xB7108F5F, 0x925F0AA5, 0x64C190F4, 0x5B213235, 0x0207819A, 0x9709D003, 0x87B89535, 0x46C8DCB8,
            0x0866CE21, 0x828BA7C9, 0x682B385D, 0x0BC3DFEE, 0xAF2A2040, 0x8FF00887, 0xB61384E7, 0x3A9414A7,
            0x5980BD0A, 0xCF6DE5A7, 0x0C292DDF, 0x08C87B28, 0x88A82D71, 0x78DAAFA4, 0x1E650B7A, 0xD652DEA4,
            0xAD5A0C51, 0xF9E77E84, 0xD11455FF, 0x6813A3A8, 0x3F112519, 0xB502B8A6, 0x87A41EFF, 0xA4F86768,
            0x17D067AE, 0xD2F4216A, 0x3522ED2C, 0x99F9C6C8, 0xA5663160, 0x97AB6DB5, 0x415A98E4, 0xA0AEE2A3,
            0x908DBD91, 0x0CBE2BEC, 0x89453915, 0x780A0B9D, 0x19070D43, 0x89F2A5AC, 0xFB5241EE, 0xB0689BD3,
            0x78B3FFE0, 0x92302864, 0x51162628, 0x240F3867, 0x3E5E2BBA, 0x30B622E2, 0xA384D631, 0x1D8C329D,
            0x3623C1B7, 0x8FBFC9C0, 0x8E24CC36, 0xF6DA29B2, 0x719B00E7, 0x0F63B4F4, 0xBD851111, 0x93EEDDAE,
            0x534E3FD4, 0x75BE1509, 0x8E84C3E7, 0xF53FEB18, 0xDCB882F3, 0xD028D74B, 0xA25880B3, 0xC10304D9,
            0x73D06147, 0x1E1F87E3, 0xBC1AC8E4, 0xE72C50F4, 0x67D60482, 0xA4D89F25, 0xAF9B6568, 0x87518252,
            0x9BC6BEC4, 0x05D9A698, 0xD09D34EE, 0xD8AF6865, 0x66D61C18, 0x1131B3EF, 0x7EC235B7, 0xF1E77841,
            0x36C13FD6, 0xB6222829, 0x7460E95A, 0xEC4D7739, 0xD562D39C, 0xA494908D, 0x8FCF3AEF, 0x1C247661,
            0x5CA70F5B, 0xFAB5D59D, 0xC3DFE064, 0xCF9ED5F5, 0x9D8DFE14, 0x37E0C9FB, 0xC93E2BD6, 0x904DB1C7,
            0x83625A65, 0x20CC2378, 0x64FCA2C2, 0x87B5CDF2, 0x55B23E6C, 0x06DBCBE0, 0xC14BA259, 0x71964696,
            0x6F884B6A, 0x75407B70, 0xCE8254F9, 0xEA63F23C, 0x608F4657, 0x0C73FCC3, 0x7025699B, 0x06B7BE74,
            0x5DB3C504, 0xC13CE610, 0xD0906D03, 0x5B6FAB4D, 0x69701E99, 0xC6B00AEC, 0x04967363, 0x2F5F8FC6,
            0x448FE71B, 0x16A80986, 0xF9E76A2F, 0xF6900D27, 0xF88313F1, 0xE8FE89D2, 0xE155161D, 0x191902B6,
            0xCBB8976E, 0x610F4A0B, 0xB329F4FE, 0xB9B2F4A0, 0x1918ABD4, 0x33C2F4EF, 0x11E93850, 0x3636F95E,
            0xE2CB559E, 0xD65DFE43, 0x773A2DD2, 0x48651ED5, 0x9A05AAF6, 0x1D2818DB, 0x42CC20C8, 0x645F1405,
            0xBE5DB324, 0xB10B7D4C, 0x87C9DA85, 0x82ABD866, 0x4E2119DB, 0x1C911CB2, 0x2D25D6CE, 0x648F5D26,
            0xC8D6EBBF, 0xDF528536, 0xAA223452, 0x1234E755, 0xF49DF9B0, 0xFB31B4A9, 0x2E98917C, 0x558D36D3,
            0xE87DCD81, 0x5819558D, 0x851E1BF0, 0x4C919E0A, 0xF91FF006, 0x980E221E, 0xD076B494, 0x1AFF5716,
            0x9A0A0CC6, 0x85F4A518, 0xD74E33C0, 0x9E413F93, 0x417E6918, 0x5A27AC0A, 0x3FBE54FF, 0x60A978C5,
            0x9DCE0890, 0x5E7E6DDD, 0xB43E4E58, 0x4B754B79, 0x4E1C09E0, 0x0ABAB952, 0x8C474C25, 0x7D470F00,
            0x1FF5A899, 0x2EC9E80D, 0xBF8BD142, 0x0CE4E179, 0xEB953AA7, 0xA358EE09, 0x71568950, 0x9EC03064,
            0x19B05954, 0x418A6703, 0xDBF870EC, 0x13B4A755, 0x7018A737, 0x35C9216B, 0x7FE28F4A, 0xF63F47EF,
            0x75A2B277, 0x25579A36, 0x5467A1B1, 0x683AD473, 0xD669E372, 0x8401151E, 0x9D547E79, 0x1115D774,
            0x7CD4C8D2, 0x90BD86A4, 0xF66C119C, 0xEC4FCB53, 0x10FF79EA, 0xFCF4E58D, 0xAA2FFB6A, 0xFD20202D,
            0x7B3FCE1A, 0xC8E497F3, 0x463CC8ED, 0x0AAB04B7, 0xA942C3DD, 0x1A751F02, 0xFB2AC2AF, 0xA07CD2BF,
            0xC1CFB450, 0x51613E9D, 0x386FC38E, 0x210581F1, 0x3A835ED5, 0x7211A30C, 0xC20B71B1, 0x25B05174,
            0x67FB3049, 0x2A22E7F3, 0x4E7A94EC, 0x4FDCD9B3, 0xFD267E0E, 0xAEF63AAD, 0x3601F6D1, 0x312F7BBF,
            0x97970600, 0x34B76249, 0x19A06B3C, 0xD093A52D, 0x2E65A98B, 0xE49C1961, 0x98E9CDC1, 0xDDD160CC,
            0x58208984, 0x3CDB7231, 0x688726CC, 0xFD31DA39, 0xDBA54C52, 0x4F514DB0, 0xDF42E3EC, 0x739EE221,
            0x3D4EFDC5, 0x77D22ACC, 0x432C18B5, 0xE9B22014, 0x6E0D1DFE, 0x7B6C9009, 0x58F37C6D, 0x1BFFFDBB,
            0xCBB94F22, 0x693812B3, 0x169DC61E, 0x36A028C2, 0xFF5115B9, 0xF6D3F66B, 0x6C0FD083, 0x46DF1C1D,
            0xC1F6D81B, 0xFD60C9C9, 0x57D3FEEE, 0x95069DB1, 0xFF56A52B, 0x4F445994, 0x6CA0D3BB, 0xF5A49668,
            0x108A4339, 0x5C099BEA, 0xDA4DB87C, 0x3E67FDF8, 0x14601014, 0xDD1E10A3, 0x335B69D9, 0xDF91F19D,
            0x439EBB36, 0x502038C8, 0xD68688DE, 0x43AD6DBA, 0xA90A3B2D, 0x354BFD88, 0x3683BB3B, 0xC615787C,
            0x0559D325, 0x6F0658DA, 0x6591D7A7, 0x3F26EBDF, 0x36C697DA, 0xD589FE87, 0xD377A542, 0x912EC371,
            0xC8CBFCFA, 0x260E6C5D, 0x5F1638EF, 0xC4AA3360, 0xFF74C444, 0xC87CBC7C, 0x4B354A13, 0x611059BB,
            0x12A822A8, 0xEB9C6D5D, 0xBE5A83BC, 0x8287B3FA, 0x2DB9F197, 0x59CBAEA9, 0x9EB838BD, 0x3CBDFCA9,
            0x125F59FF, 0x4459C367, 0xFED2E354, 0x8313D84D, 0x136909C4, 0xBB0E2B34, 0xFA8B7520, 0xDA940ADC,
            0xF8A7201A, 0x03C785A2, 0xA5E98EE8, 0x8CC63D3D, 0x6AE2A429, 0x12783B7A, 0xD56B44F3, 0x5906A87E,
            0x30E3AE92, 0x551CA62D, 0x489695A2, 0xA3E7C71D, 0xC70F8610, 0x1E4D1575, 0xF53735FE, 0xD48DC598,
            0x1F5BC694, 0xA748685F, 0xE39223BB, 0x734EF2BB, 0x2E737DEF, 0x3EE3B28F, 0x1F3A4BCA, 0x93996B30,
            0x1B2003F0, 0x727FDC2B, 0x368A7CB5, 0xB2F62B74, 0xFD1FFD56, 0x610A957F, 0xFAD3E250, 0x2F3E508E,
            0xDAC7C561, 0x5412F9F1, 0x61A3A294, 0xB84F8BD3, 0x78739E4E, 0x7F2D2AD7, 0xA1604440, 0x851B909E,
            0x517F56A9, 0xF6334B62, 0xEAD755BF, 0xAB2BFBBC, 0x20B68FDE, 0xF41A4C0E, 0x4ADA5045, 0x0A5D7EF4,
            0xED82F8D9, 0xC41C6DD5, 0xFE17ED12, 0xC2EFFCEE, 0x80CFBC82, 0x2072ACCC, 0x3CE981AA, 0x91C3BA9F,
            0x55C241B3, 0xC52EFC08, 0x153528AB, 0x28D963F8, 0x9B7CA554, 0x3AB384E9, 0xB72E9EA1, 0x684D5738,
            0x86FE4BC9, 0xBE1096E0, 0xA63B3356, 0x30B550E3, 0xC1FDA35F, 0xF548D4FB, 0xFAA93FE7, 0x58AD3151,
            0xB71929D6, 0x16F6B5AF, 0xE586168F, 0x47616A4B, 0xE8FE5599, 0xC2BB5EC2, 0xEE2D7848, 0xB9FE7BCA,
            0xBB76EA24, 0xA65D676C, 0x665E591C, 0x5711127C, 0xAE7FFC89, 0x799E1620, 0xE4E808EC, 0x9FB1236D,
            0x5AA788E7, 0x75301F91, 0x2978779B, 0x3B668732, 0x1DF33C91, 0xDB7F8ED1, 0x43A97DAA, 0x121E1F82,
            0x13F8704B, 0x2B9CF79E, 0x6E83E2CC, 0x31C9BB60, 0x5D55AB9B, 0x2090A9EA, 0x185F5D24, 0x2C602EEC,
            0x4EE928E9, 0x6375E39B, 0x3F52AA8F, 0xFD26E214, 0x2BE67182, 0x9C37656E, 0x66E4548D, 0xA631D9D6,
            0x5E4B2B26, 0xD227E53B, 0x2CC6AE1A, 0xB470EAAF, 0xCA790B86, 0x26D9FECB, 0x075CC2CC, 0x35F8F7F0,
            0xD31D03E8, 0x4A475B9C, 0x0BC647A1, 0xEB45ACCB, 0x5849B7E2, 0xC5027E2E, 0x8B88CDBA, 0x1473CB5C,
            0x10584D79, 0x4A103C59, 0x5150C472, 0x5D4EF6FF, 0xBF997FD4, 0xE733BB27, 0xCCF5F9A1, 0x8E7FB09B,
            0xAAE29040, 0x950554F7, 0x2F42A92C, 0x9ABC1968, 0x8A30BD0F, 0x65ABF1FD, 0x6A0F7984, 0x8F6F783E,
            0xAC1F0B18, 0x19C1114F, 0xAB8A8425, 0x6EB4E275, 0xB06369D1, 0x28E41E59, 0x491C68A5, 0x74AC9C67,
            0x536409F7, 0x0980492D, 0xCA4658BE, 0xEF8AA578, 0x5BFB69E3, 0x220ACECF, 0x5FBA07CC, 0xE4C990E5,
            0x56DD0B24, 0x8E12CA07, 0xEFF20F26, 0x3A573444, 0xF81C0C75, 0xC77E17D9, 0xD793BC10, 0x7F73B63E,
            0x6543536D, 0x9F0D3D67, 0x95CD79D2, 0x12B16A5A, 0xB051056A, 0xF2CD63DF, 0x15F348F6, 0xB80D5961,
            0x3BF270E6, 0xBB3C92FD, 0x6F9326B0, 0xF5C89E68, 0xED79F0C1, 0x4E0AE4A5, 0x0A6AF09A, 0x58EFBF49,
            0x1AA61A09, 0x869AB6A5, 0xE4DA9939, 0xF826CBE9, 0x23DFD4DB, 0x07E5C286, 0x2F10FC14, 0x95DD3FEB,
            0x0357C211, 0x28BCA71F, 0x60A8D301, 0x53867E54, 0x4C0E0E94, 0xE30F4C17, 0xCCF1115B, 0x68276A47,
            0x15EE29C4, 0x080B8AAD, 0x47078EEE, 0x105933B8, 0xE00DB5E0, 0x0D85B618, 0x7DB51CE7, 0x5247C3A0,
            0xA673B8AE, 0xDCC7500B, 0x519DEADD, 0xFF1D469C, 0xD8DB2336, 0xF1980F87, 0xE0F20CAE, 0xE166543E,
            0x8C20A584, 0x0ECC14E4, 0x43F1B779, 0xE3544145, 0x8EB81F5C, 0xC47C0AE3, 0xADBECD42, 0x0FAF483C,
            0x1EA69663, 0x212FAD6E, 0xFAA08856, 0xE43BA1C9, 0x12A0D738, 0xDF9EF88A, 0x0CB75A9C, 0xEBF195AF,
            0x27CBF1D4, 0x7D0C3F6B, 0x47989C1A, 0x2A653A4A, 0xC55070B8, 0x815C613F, 0x1C1CD13B, 0xF024108B,
            0x996E802A, 0xCB093B5E, 0x7675E444, 0x52E11FB0, 0xBD150447, 0x8E4CE6B0, 0x5997BD8C, 0xBC1C138E,
            0xFD295A5F, 0x0F138789, 0xB776BDAB, 0x409D6F0C, 0x0A1B7C56, 0xA138B53D, 0x4F3D0460, 0x1EB491D5,
            0x45B5FFA3, 0x111F1DAF, 0xB99E2187, 0x43F7698F, 0x69D6EAC5, 0x0A7AE809, 0xF0A3B645, 0xD20E8C86,
            0x6BAAF644, 0xA93C4859, 0x234C9421, 0x3AB64E71, 0x8E66CC8D, 0x51E7E537, 0x78AB1C8C, 0xE1CA8A1A,
            0x0C493535, 0x8C56DD73, 0x9B97CF97, 0xF5E8A0BC, 0xA2D45A26, 0x0A33621F, 0xDCC9FD99, 0xAB0AA12D,
            0x6B551B85, 0x0E507A05, 0xAAAF821C, 0x8023FA58, 0x95AA51C1, 0xB4A854C3, 0x4D1452A0, 0x7ECE2D35,
            0xB9E478CE, 0x9B28E1B3, 0x4C4D053E, 0x925494C0, 0x5A4912B3, 0x145940DD, 0x7C4EB4C6, 0xE7C0FBB5,
            0x1F315DE0, 0x8B044EEF, 0x5A2E1795, 0x6DEB383F, 0xDB758472, 0xB5FEA0E9, 0x4F1B7F58, 0xB77005DD,
            0xB27F0492, 0xFAE022F1, 0x36E03DC5, 0x63A8D615, 0xC1BC6B87, 0x57ACE61E, 0x7655F09C, 0xB00906A0,
            0xF51EC694, 0x1469ED2C, 0x5755E3C5, 0x8A54058F, 0x110C35B8, 0x37AECC2D, 0x84568F8B, 0x785F021A,
            0x231ED3E2, 0x3C26B92F, 0xAB24DC1A, 0x41415E58, 0x384D051E, 0xA4076197, 0x9C1951A9, 0x5430033E,
            0xE265ACD6, 0x05B00E85, 0x9E30F604, 0x5D28ACD4, 0x8D1DD209, 0x9A059505, 0x9D0D020D, 0x91C44DC4,
            0x4E013EB5, 0xF9E0539F, 0x9081C240, 0xFF65F063, 0x9C25B77F, 0x6C0AFB83, 0xE8F4DE2A, 0x1C1E825F,
            0xBB05B4D6, 0x5FC758E1, 0xC993C947, 0x359F4ECD, 0x0AD16C4D, 0x41C1FBF2, 0xBF7A4315, 0x8BA0E4BD,
            0x7A25C73B, 0x1E0DDC3E, 0xEBAB8FE7, 0xFE843C88, 0xFBCAB19D, 0xBDAF4525, 0x586CEA79, 0xCF031E66,
            0x6B1E63A6, 0xBDECE83B, 0x9340D973, 0xD3A04D1D, 0x682BEC38, 0x9F46F923, 0x5D0A132A, 0x34381022,
            0xEF743EDC, 0x13225057, 0x0AB3B281, 0xCF21C62D, 0xC9806AE8, 0xB52E54AE, 0x2EAF6DED, 0x5C0EE973,
            0xE610BFD6, 0x00A39C2F, 0xA9ACF9E6, 0x1745FEAE, 0x95FD4702, 0x07B6D08D, 0x29254D8B, 0x0B6D658B,
            0x4A3897DE, 0xA6D0A437, 0x4D72125D, 0xAC291CB6, 0x79EC127D, 0xDF0437A0, 0xD7583552, 0x39A082B5,
            0x0F55E5F8, 0x30839339, 0xF0280FA9, 0x8A40EF12, 0xAA90E059, 0xC5C2BB67, 0xFD958F5C, 0x548D0003,
            0x270AED0E, 0xB5D0F496, 0x86EBC298, 0x05663104, 0xB8D48459, 0xECF5A533, 0xD3B9D465, 0xFDB58EF1,
            0x42596A7C, 0xCB3292DD, 0xDECB8B1C, 0x52C854DB, 0x0A47C8E5, 0x385CD47F, 0x6F10FD69, 0x90938800,
            0x6755554E, 0x95D1E5A7, 0x2DB96516, 0xE90693E0, 0xE6DB4CDA, 0x2B6628ED, 0xA80A79C2, 0xE2137F90,
            0x43BDB835, 0x55A4ECF3, 0x0BFFB57A, 0x9AEB7C7E, 0x4CAECFEE, 0x42F69CC5, 0xB023B3D2, 0xD465954B,
            0x1270D4BF, 0x408A135E, 0xBEDC120A, 0x1FD0F501, 0x02D33BB5, 0x1D627989, 0xA76A63E0, 0x84F1207C,
            0xA6F4C069, 0xBEC5B660, 0xF66F814D, 0x1365D1C3, 0x92419B2C, 0x2844654B, 0x15EAA692, 0xCDAC51DA,
            0xAE2EC039, 0x2BB97FD0, 0xD6F0701F, 0x65C4BBB7, 0x80251AA6, 0xBCC2E42A, 0xF9A1646E, 0xEBF2F33C,
            0x012C6970, 0x24ECF21B, 0xD09C813B, 0x0EA32B2E, 0x283303BF, 0x1DFE2A47, 0x8AA0C7A8, 0xF316ABF4,
            0x04F845EB, 0x843CCB36, 0x81DD53CC, 0xE66F28E8, 0xC2CFB6D7, 0x6BA3165E, 0x7DB4023A, 0xB1775DD8,
            0x117C4451, 0xF1E3AAF9, 0x16448898, 0xBE3EC4BE, 0x75BFB808, 0xD0C95D8D, 0xDC29D9A9, 0xEA3C4B8B,
            0x6797EE39, 0xCAF74BBE, 0x57A7F9CC, 0x1FC017EF, 0xEBC271D6, 0x9A6A257C, 0xEEEDF521, 0xC5E8EEDB,
            0xD8B2D4BB, 0xD8794F95, 0xFE4774A1, 0xBAB43845, 0xC62AFF94, 0x38E51A12, 0x1C1E35CD, 0x8D46638F,
            0x39021833, 0x8538F47E, 0xD405398D, 0xB2762E87, 0xD0292780, 0xE4C25089, 0xBDC782A4, 0xEA14E331,
            0x2781D334, 0x82A1F08E, 0xB094AAC1, 0x159F8D25, 0x0AE28794, 0xA247FBBB, 0x3716D75E, 0xD5118E90,
            0x7CA53D8D, 0x2AC7EB50, 0x6334306A, 0xC0AB0391, 0x5AB5F262, 0xEAF1ADEF, 0x4637A7AF, 0x6A4D25AF,
            0xEFDBE50C, 0x3D0B629F, 0x93E52ACC, 0x8E5EE100, 0x2F86F9B8, 0x576A8232, 0x41E9638A, 0x83B119C3,
            0x44E371F3, 0xF9F8D233, 0x01097FE3, 0x1586F23B, 0x54938023, 0x33BE8FA2, 0x976AAC55, 0xE97CFA52,
            0xB4BC52F4, 0xE59F68B4, 0xF3C583B2, 0x882456FD, 0xC84F2860, 0xC3F27B02, 0xCF9E215D, 0x2152887D,
            0xE018E432, 0xDB4452CE, 0xA6D7C9C1, 0x7C85C007, 0xE73CA550, 0xBABD42AC, 0xB50F55BE, 0x37A1977B,
            0xEB6D53C5, 0x275CAF41, 0x39D210A2, 0x01A96525, 0xC55E4818, 0x3D95537F, 0x0803B7AC, 0x9EF5A172,
            0xCD954792, 0xAACC0D4C, 0x369D5CB0, 0x16D69958, 0xD1802C73, 0xD7662332, 0x9A83FD15, 0xA2788CCC,
            0x1DF481C3, 0x3FEBB8D6, 0x750FF60C, 0x293F7C0E, 0x78C90B58, 0xE09C0AD4, 0xE2E942AD, 0x71A0EA2D,
            0x5FD5AA48, 0x26B92874, 0x5D6DCF1D, 0x2E03EE6C, 0xD7332B4C, 0x350482C7, 0xEEDA79FB, 0x0DF6ABE1,
            0xD5B66207, 0x397E5E11, 0x10B60084, 0xD750388D, 0x239C628F, 0x302B0026, 0xE5192828, 0x1B7F6210,
            0x8C8A2F4B, 0x8ADF23B8, 0x67518284, 0x95CE379C, 0x4776C3C5, 0x4FEDED01, 0x729566D8, 0x537D03BD,
            0xFA076DFB, 0x5D49D9F3, 0x28DE0C8D, 0x4402FB83, 0x0435DB5C, 0x41E63F0D, 0x09B009B4, 0xC5875E44,
            0x9384ED19, 0x056239BB, 0x80A23C2B, 0x61431363, 0x4100D017, 0x92F1A802, 0xCB902E65, 0x4A991583,
            0x2B79A542, 0x3B9FB2FF, 0xC760822B, 0xC586F9CB, 0xFB84F50A, 0xC09E4B39, 0xEA45A185, 0x8B5A1B41,
            0x51B493F9, 0xA3B7275D, 0xA1DA66ED, 0xBBFA35B5, 0x55A3ED61, 0x0FA375EA, 0x523DFA7F, 0xF15A5574,
            0x1857774C, 0x876BCE52, 0x78FF7B1C, 0x27B96F3A, 0xD6A83EC3, 0x5CFDC22F, 0xF1CA0515, 0x7B5A198E,
            0x5897A3A1, 0x5F1BFC93, 0xF638F594, 0x2547D0F2, 0x5984130D, 0x0341041C, 0x123FD834, 0x7F7855CE,
            0x6CC1BAEA, 0xAC7B2718, 0x56E4E648, 0x82201054, 0xF6C996F1, 0xD2FCA7D4, 0x2C3D8181, 0xBF447EA5,
            0x3BCA1D32, 0x617C7300, 0x0737D246, 0xF00367DE, 0x06D3DCC7, 0x354A16BB, 0x4773ED59, 0x3E08CB88,
            0xACBE41C5, 0x8AF68672, 0xE559D226, 0xC279752D, 0x428D76E8, 0x3DEE9E7B, 0xD310D2C4, 0xC0A0173B,
            0x43DE2D70, 0x3A1251F8, 0x74F128EE, 0xB5E74AF6, 0x5062A406, 0xC967C0D3, 0x40358550, 0x636E9669,
            0x8A869059, 0x1BF7D037, 0xD1849165, 0x19E95984, 0x929FDD45, 0x1E8DAA79, 0x869A0B3C, 0x74F245B2,
            0xF19B7A48, 0x535F6BBD, 0x08F060AE, 0x5A85B48D, 0xAA490097, 0x5F4B67E4, 0x87B5B8B7, 0x176B6522,
            0xF6A46C1E, 0x80F11B43, 0x8777A66F, 0x07591364, 0xEFDE6F8E, 0x006A2BE5, 0x8995800B, 0x96FE175C,
            0xDB6C8245, 0x2003706D, 0x6F06BC36, 0x53913F6E, 0x2D5FE57A, 0x3836E5C4, 0xAAF68624, 0x2250B234,
            0x2C64CCEC, 0xB3ED6789, 0x7D9E53BF, 0x5482015A, 0x39368EF6, 0xA5719EAC, 0x0C43730E, 0xE89028AE,
            0x424F40AA, 0xF64C5942, 0xDAD5FBB9, 0x9FE71B83, 0xBBA2C5B5, 0x621A3652, 0x8002B450, 0xE7F42D03,
            0x83A00D0F, 0x32E4E3B5, 0x58F16F4B, 0xC33CA5E0, 0x5D92A882, 0x65CB63B3, 0xB054B681, 0x5D82FB9B,
            0xFD92B2D9, 0x5B2856AE, 0xDA7E7129, 0x9AF259CC, 0x711B9293, 0x3977F0F4, 0xD3CCD63A, 0xDD1A3F2C,
            0xA7CDD96E, 0x93EF77DF, 0xC6157834, 0xCC3038B9, 0xFC4793FD, 0x71D87A23, 0xB9EB55B3, 0x038825D9,
            0x75CFDA87, 0x27EB576B, 0x5CDFF3B0, 0x5A8DF391, 0x7CEC8EFC, 0x036390B4, 0x9FB7483A, 0x663455A5,
            0xEC6E22B6, 0x87880156, 0x726FC8F4, 0xE3D66AC4, 0xF8B6357D, 0x2BD4AF82, 0xA2BD0CBA, 0xA6F69F3A,
            0xEFD30CC5, 0x4E446D81, 0xF3470509, 0xF5A5313B, 0xCE5A237C, 0xCBF5F23F, 0xDD0A6AE7, 0xCB5E3ADA,
            0xA3326F82, 0x24A147CF, 0xD0D54C68, 0x29CE9211, 0x5984F5A4, 0x5F31E3ED, 0xEC418717, 0x2A0E2FB7,
            0x3D4522F9, 0xE9E0B9D7, 0x83C3D8E2, 0xCDD5E4F1, 0x38FBE1EF, 0xC7C683BD, 0x16C441D1, 0x0F4B2B4B,
            0x76653CEE, 0x0EF45197, 0x066ADBA9, 0x36E99291, 0x0D41993B, 0x0A4A1727, 0x65D778CB, 0xE0E8ECB3,
            0xA66446B7, 0xEF6A4CE0, 0xD0E97000, 0x167A0158, 0x303B3BB1, 0xFCF0EF47, 0xC6DF06A8, 0x376246FC,
            0xE4E8999F, 0x54EEF189, 0xBB7BCBAA, 0xF4078A05, 0xEB9B2720, 0x3AE71CBC, 0x2AC88E5F, 0xB530C6DB,
            0x36776C44, 0x83DAEB33, 0x29C29CC2, 0x051AC05F, 0x305B3A41, 0x15887C43, 0x0451C197, 0x4424586E,
            0x3246B11F, 0xBD0D85AE, 0xBB8441B0, 0xBFDBAAB5, 0xA2CEB3B9, 0xAAA8158F, 0x403AACAC, 0x6C4D2173,
            0x8F0E063D, 0x1758072A, 0xE17655AA, 0x701A5031, 0x8069AF03, 0xD0CC75C3, 0xCC461177, 0xB3E071D0,
            0xED4140B9, 0x2C455A2D, 0x030DD98C, 0x18645232, 0xF208FD67, 0xF4483B62, 0x2B84B1E1, 0xFCA7F74A,
            0x6ECCB6EB, 0x252F37D7, 0x49B6E7E5, 0xA0123D16, 0x98900B57, 0x1C06481E, 0xC5B21B63, 0x783C987C,
            0x56A12B7F, 0xA7CDC679, 0xE142A9F8, 0x397B9FB6, 0x541A4541, 0x0C27659E, 0x9B072A03, 0x7A9DC4A1,
            0x1D51136E, 0xF22F5E17, 0xB6CB6178, 0xCCC99D82, 0x86C3A8E9, 0xC768DF42, 0x652F4E6B, 0xEA57412D,
            0xD95317EF, 0x625717FC, 0xCE7C3BB7, 0xC58FF93C, 0xCB32B666, 0xC80A7D4F, 0x0FDE3671, 0x2447A97A,
            0x1D0162A3, 0x12C30738, 0x2852711F, 0xBE9D7570, 0x57AFF177, 0x5E92B566, 0xAB5F8706, 0x200A7C78,
            0x560F34ED, 0x3C5EE93A, 0x350C88AD, 0xDC72490D, 0xF3F9D66D, 0x3C24F7B6, 0x6849279C, 0x9BD50698,
            0xB70B0255, 0x72593327, 0x87B53BF3, 0x9028464F, 0x01BA4002, 0x3D285710, 0x7D0BDF97, 0xAB4F4D95,
            0xC55D2674, 0x7F52927D, 0x762C882D, 0x049D8D99, 0x34BBCB82, 0x0B7FC266, 0x38A1C257, 0x16B81A50,
            0x3DD70B24, 0x155475D7, 0xEE76EEAA, 0x983A01D3, 0x1D5C7DB5, 0xAD9B1FA4, 0x4256DB41, 0x73AAC804,
            0x2995CEA4, 0x1B4D7141, 0x448A0CB7, 0x7B7A5A33, 0x01140CE5, 0x1AB32037, 0x8A25F110, 0xF98553E7,
            0xD6978CF6, 0xF0CC89A9, 0xDA51409C, 0x7A11D370, 0xF8AEEA5D, 0xF879B67A, 0x37A91943, 0xF737B092,
            0x053EC225, 0x79BBE3FE, 0x2EDA2960, 0xE63A73B8, 0x2BC23CA2, 0x425610DE, 0x9228C642, 0x1CD3818F,
            0x2AE91441, 0x9948F85F, 0xA8C63017, 0x59957A0F, 0xAF67F8E5, 0x520114EC, 0xFA8C336B, 0xBF9CA258,
            0xBEF6F9C2, 0x68B8BC03, 0x323AA403, 0x7E28BDCC, 0xCD2CF6B6, 0x2CF084D9, 0x755000F0, 0xABC739ED,
            0x41078BD3, 0x26A52A47, 0xEF265B15, 0x86591732, 0x981E6735, 0xB6AD8608, 0xF4E2B9C3, 0x814B2906,
            0x7E780E49, 0xB034B842, 0x2C60D2E6, 0x8F80BFF9, 0x0DD5F076, 0x02856622, 0xB3A4FC12, 0x88CC03BE,
            0x06BEE7E8, 0xB9E6C052, 0x06CCDDD6, 0x268D1E1A, 0x46E39956, 0x972BCB7A, 0x102EEE60, 0xE919AE86,
            0x79E25D37, 0x225923B7, 0xA1BF98AF, 0x97702675, 0x6D7450FF, 0x4E30E017, 0xEA49BB1B, 0xDE512C91,
            0x3E80E497, 0xE5A4690A, 0x4941ED20, 0x1DA859D1, 0x22CB9B97, 0x45902F05, 0x43A84C2D, 0x50DA9BB8,
            0x435E2531, 0x3D8518F0, 0x94BBCAD4, 0xE52C81AC, 0xB3427745, 0xCCC64BF5, 0xF5913A3E, 0x4286169D,
            0xF5CD2751, 0x12F2C614, 0xB1D711C9, 0x5E6FA1F0, 0xBEDE13B9, 0x38A49244, 0x8F7378B5, 0xF56A6311,
            0xED448B1A, 0x16FA0E2F, 0x5C826749, 0x75BD74B9, 0xA35CA48E, 0x087ABCAB, 0xDFE6AF24, 0x4C619570,
            0x3647FEA1, 0x721E0599, 0xAC20E96B, 0x8788215E, 0x90D49A13, 0xE3752D87, 0xEFA41568, 0xD5DD3FC3,
            0x6383E46A, 0x2A8688F6, 0xD9A6DF53, 0x41FE5B07, 0x843F5F15, 0x0B8036B5, 0x8AC2CD4A, 0xB9116D4A,
            0xEBF5638F, 0x776AE5CD, 0x0EA07CD3, 0x53A1DA9D, 0xDCBC7C42, 0x0BAFF3BA, 0xBC3DBAE6, 0x1A1EFC06,
            0x83816D48, 0xD8CA9ED1, 0x2372185F, 0xA1CE9E00, 0xA2A9D910, 0xF76039B0, 0x39EA3BFC, 0xBC4286E3,
            0xA863B3DC, 0x00B569F5, 0xDA9AC81A, 0x013AE41E, 0x4960506E, 0xB6518A5C, 0x66367C72, 0x9B58725F,
            0xE3B41AC7, 0xCF7030CD, 0x478CF98A, 0xCE5979C7, 0x0F044B41, 0x015B6CA7, 0xBD3B25F5, 0x5B0CC6E2,
            0x3F0A9432, 0xE2C8B2B5, 0xD9091C8A, 0x65A17B64, 0x23FCD92D, 0x26860664, 0x8991FB7C, 0x28060CEE,
            0xE9E2D260, 0x18C3F5D9, 0x4B318BA1, 0x67FDED5D, 0x3F5F5447, 0x29E3E2AE, 0x65802FF5, 0xEA20CE7B,
            0xD9161C53, 0x3EAA6203, 0x26B37FC7, 0xA93B8361, 0x404AC31B, 0x2A64BBEC, 0xED73E801, 0x7DB80191,
            0x121CD318, 0xE8B06A13, 0x3BE47E09, 0x2A3AF553, 0x9CB4DF17, 0xDF9DA7B7, 0xFA617075, 0x37C507A4,
            0x1EA0876C, 0x167D3770, 0x030CD9BE, 0x9F661FF3, 0x118A31EA, 0x2201269A, 0xF43127DE, 0x880E9575,
            0x07042BF4, 0xD55DB3D8, 0x8C095D07, 0x9B7471B1, 0xDDA9A90E, 0x48CF8B41, 0x6D834C43, 0x89CB3A13,
            0xD5792BC6, 0xC3B33BAC, 0xD72186EF, 0x338DF50E, 0x1E2409BA, 0xF457759D, 0xBD319CCA, 0x86695DBF,
            0x000C31EE, 0x414067A3, 0x7EE7C793, 0x358713AD, 0x9F2B73C4, 0x3E3F3200, 0x36B9A623, 0x52C5A345,
            0x03C569F6, 0x25F57139, 0xA659CD13, 0xD2F9CE08, 0x70F44553, 0xDED54C6D, 0x87EF746A, 0x08EF0B87,
            0x0FC752BE, 0x055FBD94, 0x3B5AE879, 0xEBD41E96, 0xAB724EBE, 0x002CB4EA, 0x808C249E, 0xBB22C8B2,
            0xA8811763, 0xDF6C3A9D, 0xEB5C9E01, 0x008A92D4, 0xFB02F6A8, 0xEB5EB1A4, 0x57E6641A, 0x24CA347D,
            0xE0628C6D, 0x70AA13D5, 0x02176603, 0xE6ADABDD, 0x5805B912, 0x1B1A432D, 0x36C56F8D, 0xD4B735BB,
            0x6BF3FF24, 0x968EB928, 0x7B9EFB09, 0x8FF98A6C, 0xAFE20A25, 0x385A17EC, 0xB249CF9F, 0xAE61FBFD,
            0x797A970F, 0x8E907E3B, 0x7A14E965, 0x96ED0C08, 0xA01048F5, 0xCAD5C94D, 0x1E2527F3, 0xE9905517,
            0x6D8553B0, 0xBB248976, 0xAC17FB4E, 0xF9C6F4B1, 0x8BBC5EEC, 0x3AA230FD, 0x21BC825D, 0x5F6D44E7,
            0x435B13C7, 0x3065F2B0, 0x4B31437F, 0x3AC5DB87, 0x90CE354D, 0x3A699B3C, 0x47FCB086, 0x13CB4136,
            0x21F279A7, 0xB940AB11, 0x6B8831B7, 0x4F6883FE, 0xB70EA409, 0x6484E1F0, 0x6FD25AD0, 0x68AE791A,
            0x8D5276CD, 0x7D36AA74, 0x7666194A, 0xA9BCDD7E, 0xE0ECB2F9, 0xC24C84DE, 0x68214341, 0x5F22DAD7,
            0x2D6D5568, 0x3C97B9BF, 0x53B9D0D4, 0x61DC48CD, 0x03B10796, 0x2505CA2F, 0x7A7AED9B, 0xBF9554E5,
            0xFB181274, 0x0909251B, 0xD128199E, 0x25ED4101, 0x88807E19, 0xBB5314D0, 0xE880CEC5, 0x8927305D,
            0x836E72E2, 0x72A4E474, 0x7A93AE2E, 0x1B457D84, 0x21B37A2E, 0xE6344965, 0x0B1FB51C, 0xD9CE5441,
            0x002BD442, 0x7E6E9B1D, 0x941EE491, 0x5BDBC4BD, 0xC172F767, 0xFBAB8B56, 0x7B66CD25, 0x133D798D,
            0x028A993E, 0xB36F6A26, 0xEA43851E, 0xE7562B36, 0x645A03E1, 0x00411161, 0x10F8E548, 0x01081D58,
            0xCC1BDED1, 0x1599E5F8, 0xB8FB5C1E, 0xAFAE9C5C, 0x9BABD5AC, 0x03DBB4B6, 0x7ABD20FC, 0xA6D76FAA,
            0xD3BEE064, 0x5110C3F1, 0x0FEC59EB, 0x5AD3D9E9, 0xE2F70FEF, 0x48C3951F, 0x3DED3DBD, 0xA5CB2F27,
            0x9E92D396, 0x49801C62, 0x1DBE9E70, 0x3032E2EA, 0xB8D76893, 0x189D1C8D, 0x630D1166, 0xC4B81470,
            0x9E7DF098, 0xCAF05EBF, 0x6C9876E7, 0x238CE4A7, 0x36F986AA, 0x06AE32DE, 0x10BFDEE2, 0xF8B00AC8,
            0x288AA559, 0x713837D8, 0xDBFD60B8, 0x6F275633, 0xA9CAA0A5, 0xF9966083, 0x4A05EB6D, 0xECBECD75,
            0x9BA337E1, 0xD99ECDE2, 0x02601E8E, 0x905331E9, 0x0FB06979, 0x22914BBD, 0x5AE2575C, 0xA8E7D514,
            0xBCAB43ED, 0xA4C5CD56, 0x49993742, 0x17C44B02, 0xEDD67ADA, 0xDADEFA79, 0x34FA56F1, 0xE6A2D274,
            0x2BBAA970, 0x0CCED28C, 0xD5D67B7A, 0x2364A356, 0xB79C3340, 0x789E81D9, 0x1C37533F, 0xF23A2339,
            0xE3C6A937, 0x064B1FF2, 0x447EECBE, 0x224D4E4E, 0xD02EEB08, 0x627A5E18, 0x4411BD8F, 0xA7CCEF0E,
            0xE2EE7DEF, 0xCEC26430, 0xA2685776, 0x4D452093, 0x8C342123, 0xFB15C749, 0xD0325181, 0x359D9BCA,
            0xBB4B87AC, 0x60DB6C06, 0x1A1532B2, 0xC69246CC, 0x50562D16, 0x2FFC00A5, 0x88DC0551, 0xF7FDE842,
            0xCA98BF8D, 0xF3C3A3A1, 0x423BC786, 0xAB18D51C, 0x19F8B62A, 0xC31BB4CC, 0x36E98010, 0x0522FE94,
            0x463E5FB8, 0x3190209B, 0x6A64F5B3, 0xCB365EBE, 0x90A787E0, 0x6C8FCBC1, 0xAD0DF187, 0x32C6A19A,
            0x89316105, 0x1FFBFE3E, 0x90A51433, 0x6FCDD319, 0x4F79C0F5, 0x02F1565F, 0x65F37DA0, 0x0B9BE4B5,
            0xBB4F040F, 0xC6135DC7, 0xF5C4A8EB, 0xFAD361FA, 0x652CA62A, 0x2C428684, 0x36C44DF6, 0x6657C742,
            0x2F03ECC0, 0x009F9957, 0x8B37433E, 0x3502AC06, 0xFA84A7D1, 0x188D4A53, 0xD6222257, 0xBB7E2A0B,
            0xF2682019, 0x7B844B5F, 0x43840CF9, 0x384B130E, 0x621A126C, 0x61FAA426, 0xE3E97653, 0xC3F769A0,
            0x1E5816B0, 0xD94D4B8A, 0xB786EED2, 0x156A73DB, 0xCA060980, 0xDD2E2F45, 0xC4F56767, 0x63847EAB,
            0xF56B6DF4, 0x434C993F, 0xA1200189, 0xEE26F5EB, 0x8820B02D, 0x07D9B154, 0x66A6B44C, 0x85A06962,
            0x5C898444, 0x2066A702, 0xE5A88B0A, 0xC4EA828D, 0x656FBD34, 0xBD63B36E, 0xCDFC3463, 0x0528136B,
            0x370C0BB4, 0x5F1FE61F, 0xDFB5458B, 0x47AD1B54, 0x531C95B2, 0xE386C5C6, 0xC02150E7, 0x814D74C0,
            0xC8617606, 0x2DF44073, 0x940F1399, 0x775961B3, 0x75C18146, 0x6555940F, 0xB3E8AC28, 0x52BBD521,
            0x16FAA484, 0xA94D092E, 0x1A50987B, 0x69DD9DD7, 0x239D34D7, 0xBB4058DE, 0x3A1ED9E1, 0x5B7FD5DA,
            0xF98EC3E9, 0xB70564BF, 0x0238DC45, 0x887DA3CB, 0xEA26611A, 0xDD8F6BC6, 0xE16A6A9A, 0x8ABA5886,
            0xF0264355, 0x621E3BFC, 0xE7B5DA68, 0x68A45B6D, 0x0932C288, 0xEDAF5CE4, 0xB78DE701, 0xFA34A382,
            0xB5D9CEC7, 0x7B1CDBC2, 0x112DB20F, 0xC976B5A4, 0xE9291C71, 0xA88D11EB, 0xF62CBD94, 0xA8A5D454,
            0x309E9E80, 0xACDE60B8, 0x32EB6307, 0x39043C51, 0x4F3B5B75, 0x4D114798, 0x89910070, 0x75938002,
            0xC917E806, 0xED2A827B, 0xC7927165, 0x75919F54, 0xE9970EB5, 0xFB6A179B, 0x23577DE0, 0x1BBFF409,
            0x9A27FAF7, 0x384ADFDD, 0xED6A1ADA, 0xB091BC0B, 0x0D7621F0, 0x6DA525EA, 0x90394AE7, 0x5C0D7BCC,
            0xCEA1A3D6, 0x5153E05D, 0xC9AC4B2B, 0xB3D90218, 0x07300023, 0xE28CB122, 0xF6DF4C44, 0x8ACEDBA4,
            0x176035F6, 0x4B5CEE5C, 0xC6485610, 0xD8125F72, 0x894EB46F, 0x70AE8E76, 0xECF267A8, 0x41B077CD,
            0x3F53385D, 0xDEBE27D0, 0x75C3FCF0, 0xFF8E0C50, 0x1B8E836C, 0x7169A8BC, 0x6AF490EA, 0x79F5C610,
            0xFCA96B0D, 0x09D9F136, 0xD3C83FE0, 0x30A021E6, 0x5BA98D6E, 0x21F4E532, 0x352331F8, 0xBDAB051D,
            0x657828C8, 0x36BBCF26, 0x4613D2CB, 0xB2E8FCF4, 0x1C9ACB02, 0x4FF19C0B, 0x2B32676A, 0x90018AC7,
            0xC7F42BB2, 0x054CE68E, 0xF8D336E5, 0x1DB94436, 0x2ACBE91D, 0x3F90F97C, 0xB545844F, 0xBE3C6D09,
            0x6D76A1F4, 0x10A30EA7, 0x9C59AC20, 0x7EE6CD3C, 0xD72E041A, 0xB4C690A8, 0x59B18B3C, 0x0E214A99,
            0x9F52FA9C, 0xCA5CFB1E, 0x42141F96, 0x47ED7E9A, 0xD19921FC, 0x2F55B35C, 0xF05E37CF, 0x55BD5203,
            0x9AC6766B, 0xC17649E4, 0xC7F98519, 0x820E8669, 0x3C7C0C07, 0x8B422916, 0xEC0BA7CF, 0xA8968B51,
            0xBBB25DC9, 0x3886166F, 0xBEB0ABD0, 0x3344B82F, 0x8F70DA91, 0xD94193DF, 0x56758DD8, 0xF2E39656,
            0x39F1C1B8, 0x8BE7308B, 0x0AD929B5, 0x5E23F6C8, 0x699433F0, 0xD4BE708B, 0x76FF69D0, 0xF338950D,
            0xF1FC665B, 0xF1C8EFF5, 0x7A4B3579, 0x6D056DE8, 0x5E7154EA, 0x954822F2, 0x5E344E62, 0xE35F9D9E,
            0xABDCCBD6, 0xDB82BDFD, 0x4388EB70, 0x53D7A384, 0x595C6EC4, 0x0BB82E65, 0x8270E66B, 0xC732E598,
            0x57613543, 0xFB081345, 0x1B5F2A57, 0x1F0A6025, 0xE18ADE04, 0xFDAD5E71, 0xB95521F5, 0xB612A022,
            0xD2FAEC83, 0x20607AB0, 0xFED17EE2, 0xEBB788F8, 0x9923D4BF, 0x7CBC809E, 0x1CD0132D, 0x101A8C07,
            0x6D758D13, 0x89E1AC69, 0xD1AC48AF, 0x7BCC2B39, 0x32EB15B3, 0x1DDD4B8A, 0x3C5E4078, 0xFFA0FCC4,
            0xBD239807, 0xB66CA119, 0x87BBE852, 0xD9FA7C3A, 0xF4376355, 0xEC578B28, 0x30055B6B, 0x5546741B,
            0x404FE09F, 0xF73561CD, 0x6E568E4D, 0xB2A4D53C, 0xF81A3E9F, 0xA7DE6CD0, 0x7200C3AE, 0xCFE47F03,
            0xA2ECDA52, 0xA8A1BC43, 0x8F1D2E23, 0xB41C6AED, 0xB9E1B6BF, 0x3BFC8006, 0xFD6359DE, 0x8316A0B0,
            0x0A4ECCB9, 0xB870948B, 0x89D33103, 0x92184174, 0x9F32AC99, 0xA24AE43E, 0xDC940EA9, 0x3727ABCE,
            0xB028FC95, 0x23FA3718, 0xC97C7DE1, 0x9E4A0DB2, 0xC9758FFD, 0xAE7E64AE, 0xC1BCDEAE, 0xFA8D8D09,
            0x25561575, 0x05FF9717, 0x3D06A12D, 0xB76D3703, 0x9B5CCFD6, 0x3FE4FFB1, 0xCF269C8C, 0x23E9408D,
            0x0200E726, 0xD651C7A0, 0x8FCB0E3E, 0x0E48DC19, 0x614D4020, 0xD818B3DD, 0x0D49FA37, 0x4AC04F1A,
            0x38B4A472, 0x847E81DD, 0xCAED9416, 0xEB25D2B2, 0xB3256079, 0x02D1EA92, 0x3B657F86, 0x6B79289F,
            0x8BB2CD43, 0xF4DB8444, 0xE2684FBA, 0x05C9F26F, 0xBD30E202, 0x2084E836, 0x83D0341A, 0xEB1D5F3D,
            0xF3476031, 0xF8D05C1D, 0x96DCAEA4, 0x4D2DAA25, 0x932132C3, 0x259B75CB, 0x614B58C0, 0xC24B49C7,
            0x3A7C88A2, 0x217B8916, 0x7D87D624, 0x355BF353, 0xB0D1F26F, 0x2C17C8E6, 0x12D273C9, 0xE3488F74,
            0xE43F3540, 0x645A57BD, 0x406E2475, 0x1FBC8DB3, 0x4E6DF8C5, 0x585D64CB, 0x5EEFC02F, 0xC58B8631,
            0xCFF0BEA0, 0x764ED2D7, 0x05C5A734, 0x8363CA28, 0x42F3A5B8, 0xE01BDD14, 0xBEFCF267, 0x6608019B,
            0xB2B24C46, 0x603676D8, 0x6B6FEC94, 0xD0BE8BB0, 0xA1C3CDE3, 0x0D66E64D, 0x7979C776, 0x90B97E4A,
            0x1BC4E690, 0x14B9E083, 0x4E231B36, 0x90D07345, 0x21F12F7A, 0x0E66241A, 0xB304C260, 0xDF306AF2,
            0x0ACF9A92, 0xCDBB8D3F, 0x6CCA851B, 0xB3DA73BB, 0x2EB2A967, 0x156323C7, 0x8D0898BE, 0x7276242A,
            0x733E2E6E, 0xB5FB6926, 0xD935B3ED, 0xAA4173B8, 0x09F757C9, 0xC5AD3830, 0xE60556C1, 0xE50BDC82,
            0x09DABA06, 0xA6170B69, 0x21E48649, 0x1008A3AF, 0xD4BB04C1, 0x106B46B6, 0x20457A64, 0x5DE89362,
            0x0E5F2560, 0xFF489B6E, 0xFF42DEA7, 0x45A61B09, 0x9C77614C, 0xBEB6C722, 0xEBBA6942, 0xE02C5546,
            0x5004EE30, 0x46F653C8, 0x23243024, 0x8156251A, 0x6C09733E, 0xD5CB7367, 0x9C9E3543, 0x0D15F422,
            0x3D8EA2A0, 0xD46C68E1, 0x8285D341, 0x460E42FF, 0x77E8534C, 0x6CACD31F, 0x7EE77A03, 0x9FBB8FF9,
            0xE3046E1C, 0x5B0BABA9, 0x0BB6A623, 0x79631CBA, 0x78B2A1AD, 0x00E4773A, 0xD4802DF7, 0x7C12E027,
            0xFF8B7262, 0xFACE9133, 0x752B06C3, 0x1406592D, 0x47961CBD, 0x0B8471A3, 0xAD88911B, 0xFCEDBD41,
            0xEFD35AD3, 0xC5D0DA94, 0x90F342FA, 0x2603C3D8, 0x758BF9D1, 0xF17AB72F, 0xA1E1FE88, 0x4B25BE00,
            0x158D13CA, 0x185998CE, 0x105A22B0, 0xCBF4A97B, 0x3D2798AA, 0xF3CFA01D, 0xC3F2705B, 0xE137A3C4,
            0x0393BA88, 0x529294EB, 0x99D050F7, 0xD4126851, 0x9ACB357A, 0x1B089D41, 0xBC9EC343, 0x7DD083CB,
            0x0B21DD59, 0xEAB2775D, 0x620E7F88, 0xA47F21FF, 0x65125F1A, 0x0E4C1222, 0xFB84C08C, 0xEF9D0591,
            0xEF1505E0, 0xB6A5B230, 0xECA2C81A, 0xADED5794, 0x9B6DA8FA, 0x5BE4B997, 0x97B3CE5B, 0xBD0F11B0,
            0x984EAD1E, 0x27038069, 0x547C797E, 0x86E0F981, 0xCB363C1C, 0x0AEC16F2, 0x230A024C, 0xBC6C4BF8,
            0xD7FC7980, 0x76A810B8, 0x4E654658, 0x6E1C32AF, 0x30FC62FF, 0xAA28EF1D, 0x85B00F18, 0x261A99AD,
            0x50D1096B, 0xF011F083, 0xE59E0EC4, 0xA75BDBE2, 0x6C8DDFBF, 0xF36FBEB8, 0xE5FB9047, 0xDBB7C08F,
            0x00E0C774, 0xBED22D05, 0x50342101, 0xBE41E7A7, 0x39B4B14A, 0x915FA174, 0xB431ED88, 0x34B44619,
            0x5168DCE0, 0xF79AD2C2, 0x6AF0F66E, 0x92BC4439, 0x047EDC28, 0xB9C36913, 0xCF2B703A, 0x8C41F06D,
            0xBDB9666A, 0x05DBF92D, 0xED745BD6, 0x6595CAB1, 0x1C749205, 0xE146040A, 0x7B997706, 0xA4268A8F,
            0x64AFB1B1, 0x650D4982, 0x5E3E6761, 0x1A49F849, 0x98E73F43, 0x6DF717E0, 0x4E49169C, 0x461745F6,
            0x7D918C3A, 0x9086438C, 0x357F091C, 0x97A8AD05, 0xB7F7B616, 0x9D2C9AAF, 0x64A6903C, 0xEC3ADFC9,
            0xCD7FEC18, 0x782F3FC7, 0x9440A6ED, 0xEDF864D2, 0xA8799E03, 0x38CBD3B7, 0x4F2CEBA8, 0x96516D8F,
            0xD14F8D9C, 0x5DF47F98, 0x1FE879F7, 0x2037D507, 0x4E06CC90, 0x8A91F468, 0x364E4A48, 0x9C3B23A0,
            0xCBA2BDE7, 0xA54B51B6, 0x42925842, 0x9C598176, 0xB9FED8AA, 0xFAC20CD6, 0xFA00CE96, 0xC1B4CE7B,
            0x3DEC05DA, 0xB3D12009, 0x90591CE6, 0x9F6FE0BD, 0x599D2AA8, 0x70F4C369, 0x95708F61, 0xE4354EC2,
            0x031CE76A, 0xD8A1A943, 0x95750DBE, 0x9D36555A, 0x324BC343, 0x934AB89D, 0x50755E3B, 0xE758F1CA,
            0x83CDD69E, 0x474856CB, 0xAF4470EF, 0xE8282992, 0x7B1605DD, 0x4A0EC317, 0x93BF69D5, 0xAA67FAAB,
            0xC0D950F9, 0x005F019D, 0x63142524, 0x7E93EF2D, 0xFC311A56, 0x4A23AE62, 0x1FA5F6CA, 0xE683E0F4,
            0x86422B70, 0x4F2481E2, 0x09E01D9A, 0x2C11C2E7, 0x1DEBB128, 0xF4BE78B4, 0xDE5A29E4, 0x3B35C0E1,
            0x68426FDC, 0x1A9F9968, 0x41C3E9A9, 0xDE6C0FFE, 0xBBFE45A3, 0xD889E46A, 0x92040F2A, 0xF780BF55,
            0x084B7E6F, 0x85EB3612, 0x32A87BD7, 0x63B94A52, 0xF3FDCA9A, 0x4F26B565, 0x0BD8239E, 0x48A1DAC3,
            0x79779A04, 0x36240A9F, 0x9677A2C1, 0xBD86A743, 0x20B64068, 0xC324C39A, 0x03247E1A, 0x07772623,
            0x3942B208, 0xF42DAD90, 0xB3FB3621, 0x5DB62091, 0xE432C94C, 0x4908ACD3, 0xDC95C11C, 0x14FDD3BD,
            0xBC156D1E, 0xDD0628A1, 0x1D28BE24, 0x69274B28, 0xA975779E, 0xC775340A, 0x93A8952F, 0x705B5F6C,
            0x5F0C81AE, 0x95AEB381, 0x57169689, 0x29213F38, 0x26BC64C0, 0x90EB68CC, 0x14E17CB9, 0xB506903D,
            0xC895FE0A, 0x20E4C8FA, 0x4189E9A9, 0x048FC22C, 0x4F36AB05, 0xD70FFF8E, 0x506B235F, 0xC3367935,
            0xE8CFA37D, 0x35004A6B, 0x5B8F3985, 0xE54F5EB3, 0x6BAF999E, 0xCDAAE9D4, 0xCC300C3C, 0xD764726D,
            0x38E08872, 0x1C4ACCFF, 0x92EE5945, 0xEA1C0208, 0x8BB09EFF, 0x5518B0D3, 0x773F7183, 0xE46511D1,
            0xFAE56EEF, 0x079A7023, 0x4D5D8DAF, 0xAEED87B1, 0x173E50C2, 0x73BB5182, 0xD59F172C, 0x34E65ED2,
            0x04C29A27, 0x7943E6B5, 0xD43E0F26, 0x1B5DD716, 0x06EAD1EE, 0x69744F05, 0xE16DEECA, 0xDF37393E,
            0xD0B9C14A, 0x41E9565F, 0x099A137A, 0x1BA6A9BA, 0x67E92DF9, 0x5FB9E07B, 0x1D817A56, 0x9E1AA3B1,
            0x2FFDA08F, 0x5F5FED96, 0x899279E4, 0xC4EA03BC, 0x683DAC74, 0x7DBF494C, 0xBA5F6A25, 0xC3F7DF23,
            0x56EAE0FF, 0xC98554E7, 0x67D25880, 0x7A0CB58E, 0x4529DB5A, 0xB3AA1805, 0xB2478826, 0x261AB1F3,
            0x0427F554, 0x099D6C45, 0x2373F07C, 0xA277D8AB, 0xD5063205, 0x2420591B, 0x923D140E, 0x3D0C0252,
            0xC67C3B14, 0xF48A16C9, 0xEEF24F84, 0x8EDE6F26, 0x23556D58, 0x11296BD9, 0x8F31A37E, 0x146F040F,
            0x7C0BC750, 0x71325913, 0x217C725B, 0x6E71B9DD, 0x62E29D5A, 0x0BCA2F1A, 0x376F0E8D, 0x8B767E82,
            0x95EAFC92, 0xBC04AD63, 0xD1392568, 0x2C46D583, 0xA1DFD057, 0x3C1D056E, 0x08674A3E, 0x52F7E4B7,
            0x57164FD3, 0x3D9E773C, 0xFE6BBEFF, 0x76FB1EED, 0x0D8458C2, 0x5C8DB362, 0xB7173491, 0xA3C339BD,
            0x9296C62E, 0x693189D3, 0xD3ED4BD1, 0xEABD68D2, 0x1F177E52, 0x3F9D30B8, 0xCB1956CE, 0x53D5EAEE,
            0x950E6CD0, 0x79770623, 0x0702C852, 0x8483CC6B, 0x2D7BA932, 0xD6FE0845, 0x0A70A5DB, 0x2C36DFEA,
            0x49851275, 0xA16A82C1, 0x0A6C4A4D, 0xC76B4E04, 0xCA2E16D7, 0xD8EAF764, 0xAD6C7160, 0x07F2317A,
            0x776F6860, 0x91A58429, 0x28DAEA8D, 0x96C2B7C3, 0x1540EA16, 0xB5633FEB, 0x5F8E8FE6, 0x6AA9C4A9,
            0x7AA6620A, 0x24F76A0D, 0x3277687A, 0x56389A64, 0xCD58ECDD, 0x32085FD4, 0xBB7A7E9B, 0x21E75748,
            0x6A06DC70, 0x69A35841, 0x62CFE505, 0xF04EA014, 0xBC3F0520, 0x5E0BA8FD, 0xB6431CEE, 0x987C704E,
            0x6408FA80, 0x42EE864A, 0x12EF4F0F, 0x9AAF7263, 0x60F8967E, 0x7185547B, 0xB2254D96, 0xC9158847,
            0xE18C64DB, 0x91874530, 0x0179EB5A, 0x034EF668, 0xE3186749, 0xCD32AAF9, 0x601E1317, 0x8580B71B,
            0x5DEC5CAA, 0xD352A808, 0xCEB6A9A7, 0x76838D07, 0xA632BD44, 0x23078356, 0xAD453994, 0xA13C61C3,
            0x1AC99697, 0xA1B1FFCF, 0xBC633E29, 0x7CE973F4, 0x77C04270, 0xC31BC222, 0x120877A1, 0x812C74F8,
            0xEE270849, 0xE30B699C, 0x826936AE, 0x996D2C14, 0x6F27DD7E, 0x9B17319D, 0xB2517580, 0x88D748A3,
            0x19CC571B, 0x5382C8E5, 0xFDF529EF, 0x1C3C53E5, 0xACA4877D, 0x7294BCC3, 0x726E8166, 0x5F9EE84B,
            0x54D3B84C, 0xA35F2D2D, 0xE24DDEEA, 0x85FA583F, 0xC3468641, 0xF28A7CEE, 0x59D540C5, 0x6FECF9E6,
            0xEB8FD402, 0xF1DD9715, 0x50144AEC, 0xC61C0C90, 0xD15BDFB1, 0x54E88E1E, 0x98F5F2FC, 0xDA37303D,
            0xE3F084F6, 0x0CC6FD93, 0x9101B2BD, 0x518861C8, 0x80BD2996, 0x7E15168B, 0x52374657, 0x8952A7BB,
            0x90BECDCF, 0x312CBACC, 0x5DAEB25D, 0xBE6521C3, 0x02956A5D, 0x12DE6E2B, 0x87BB95DA, 0xFA745240,
            0x403CD6F2, 0x8DBA29EC, 0xBD80562D, 0x1220D0A3, 0xE9988125, 0x4DADF9EC, 0xB8575293, 0x9531EA34,
            0x6BB897D2, 0x1C1A5E8F, 0x5258F42F, 0x2CA16CE5, 0x22F69169, 0x0AD0DCD5, 0x953FC2D5, 0x65E2DCD3,
            0xA269CA07, 0x895F9503, 0x716E6C83, 0x7D039F56, 0x6543B07A, 0xF6DAB73F, 0xA5F6EC29, 0x6AE38622,
            0x7203769C, 0xFCB50DF8, 0x350F2A91, 0xBDCF98AD, 0x6D1D5F3E, 0xB4FEF83C, 0x9961BC82, 0x471C0794,
            0xAF3A477D, 0xD6DC7E5C, 0x46F45CE6, 0xED39FBBC, 0x274E7957, 0x58EE95DA, 0xCBCF9D0A, 0x7ED5BD74,
            0x208DB085, 0xAE029F6C, 0x5732F5DF, 0x7641FFFC, 0xF171DD27, 0x0935858A, 0xF02A7AE5, 0x7EBCA344,
            0x9ED4095C, 0x3089D004, 0x7BD8AF33, 0x069A826C, 0xFB6D753E, 0xA8B1BB38, 0x3584B600, 0x88A65A98,
            0xE5F23049, 0x0B241923, 0xFD3F3951, 0x7AE6DD65, 0xAE91E24C, 0x8EA98187, 0x37214E77, 0x716461B9,
            0x519BEBB2, 0x948B9843, 0xB1C57BC5, 0xF66D2CBE, 0x31A75703, 0x3ABDB95B, 0x47D5C0F6, 0xB3D40555,
            0xC75640D2, 0x59886F7A, 0xCD9D938F, 0x26D54EB5, 0xB1A9CE9B, 0x36CCA4E4, 0x92045219, 0x58CCF756,
            0x0AE72D62, 0x64402E89, 0x0423C9B6, 0x38534309, 0x5316E5D2, 0xC96BFB88, 0x0A8EF86C, 0xA7B216DC,
            0x163AF050, 0xDAEE6DBA, 0x85CBD6E5, 0x6E6E407F, 0x901C5521, 0x467674E5, 0xF2385A8F, 0xE12BA5A3,
            0x40E09CFB, 0xB41D1B91, 0x6DE054EF, 0x54D48DDA, 0x12AACBDE, 0x601622CF, 0x2EB61585, 0xB9B9F9E5,
            0x16D2A730, 0x69114B7A, 0xAC21518D, 0x8E17545A, 0x13CEC0EC, 0x8E93D28E, 0x03781B8D, 0x3A2316BE,
            0x19025654, 0x4388B433, 0x2B3FAF0D, 0xB7EC2025, 0x01B94BCC, 0x10C6B48A, 0x649275AD, 0xC069EAA3,
            0x14251984, 0xB45E71CA, 0xBB4F1AC1, 0xEBAFBC71, 0xC98DFFBD, 0xB7235458, 0x575734AA, 0xF9BE46AE,
            0xB0C7F6B5, 0x175CD437, 0xA9E444CD, 0xB36722C3, 0x3EC459AA, 0x6004EE89, 0x5D661CEA, 0x649303DC,
            0xF39D1FC7, 0xE4463900, 0x7D7D2B41, 0x1287FA26, 0xC3822096, 0x234EC7DC, 0xCEDA0159, 0xA297659F,
            0x376B9C7D, 0xB32A0FF2, 0x6D04A867, 0xCC31D6B9, 0xBBF6F32B, 0x405C36C6, 0x22B907AA, 0x95343114,
            0x4424AB7A, 0x05B7C147, 0xDE6E7722, 0xBDA507F1, 0x942A7EBD, 0xDE603D46, 0x818BB365, 0xC85A46EE,
            0x0C30FCC0, 0x759FFFAF, 0x532A7824, 0x00C77989, 0x7D0C52B1, 0xED40FB6C, 0xBC9D5E4C, 0x93BF870D,
            0xAA0A4A6B, 0x8214A227, 0xC03E334B, 0xD32EBDBE, 0x5E26920E, 0x4C0C2747, 0xA90EC567, 0x6C2AAA39,
            0x3F7865D8, 0x5468668F, 0x23291B7A, 0xC1182219, 0x95E082CE, 0xB2060C78, 0x665A9D68, 0x805BA19C,
            0xA195D196, 0x90FF4F1B, 0xBE31DD2C, 0x15778CCC, 0xAC7D4D71, 0x694BF212, 0x35425B42, 0xBAA6EF85,
            0x482F3AF5, 0x6AA06B34, 0x8DF1130C, 0xC7960238, 0x1F98B627, 0xA2CCAA46, 0x09D8B23E, 0xA03FC894,
            0xFB4121C5, 0xB4CCB0D1, 0xBB2C296D, 0xC0F3BFAE, 0xA5E83EAD, 0x637B257E, 0x0A6F1AAC, 0x47729746,
            0xB06B9F57, 0xA47BF2DA, 0xE72FED3F, 0xACDDFB36, 0xABF8E258, 0xE4486E5F, 0xF2BF500B, 0xA609E613,
            0x7F07622B, 0x59BA53E9, 0x71B4AC2B, 0x4F629252, 0xCB6E57B1, 0xBBDAF274, 0x49622910, 0xF903E6FA,
            0x4258336A, 0x72992C18, 0xC5B4ED56, 0x51A067E4, 0xCAA5E7C7, 0xB09E5418, 0x76A8FF64, 0x05CEC604,
            0x5139DE31, 0xB594B954, 0x5A122EA5, 0x992073FA, 0x273023ED, 0xFD359B18, 0x61558B67, 0xDBEB7333,
            0xF9CD739E, 0x183721DB, 0xE1BE68D6, 0xD8D03E82, 0x66752862, 0x4A885A14, 0x18FC5C9E, 0xB84F745B,
            0xB2E64BF6, 0x765D292E, 0xCBA89115, 0x2627DBDF, 0x8D309810, 0xE5B84732, 0x7863FC64, 0xCCD1C942,
            0xD4D36D80, 0x81389A26, 0x34898B10, 0x12994A90, 0xF31B823F, 0xC964B466, 0xC43F2083, 0xD3EA35FF,
            0x0DB27810, 0xC09779E3, 0x142094C9, 0x80B22753, 0x6468B369, 0xE644F5D7, 0x079EF23B, 0x12F92F79,
            0x2FD5F718, 0xD5DA5384, 0x19C286B0, 0x272114DE, 0x2ED07594, 0x9B0C4B29, 0xF7B43128, 0xEE5B8560,
            0x136DF869, 0x6B80652A, 0x7EC8B62C, 0xF170F20B, 0xBA5031E1, 0xC07DB914, 0x81596A94, 0x20D1125E,
            0x2211E1CD, 0xA4B407BE, 0x416FCEA0, 0xF23D40C0, 0x81B7C6F2, 0xD248218C, 0xEDC65B05, 0x77F45809,
            0xD7B3A27D, 0x71A066A0, 0xF0A21EFE, 0x01F27D14, 0x24503EF7, 0x7E6615C0, 0x5F9BE4A7, 0xB504CB35,
            0xDA2B6950, 0x990B34F7, 0xC03C71F2, 0x258F6A87, 0x6ED85436, 0xD13B52B8, 0x18D44CBD, 0x6CA69A16,
            0xF89F6DD7, 0x85294D72, 0x0A0C5A57, 0x96AF7556, 0x53D9E5DB, 0x955D69CE, 0xDF3D4306, 0xEC85D975,
            0x2C041122, 0x14B3995B, 0xE812A97B, 0xA9AC4119, 0xCA9A2FD0, 0x871A3B8C, 0x3E4E918A, 0x225E20AE,
            0xA92C9C20, 0x1C6448F8, 0x39480626, 0x4F3717A0, 0x238A436F, 0xC656070B, 0xFC9A94FD, 0x9492731B,
            0xBD4A4C24, 0x008AAB38, 0xD56FB531, 0x830C3995, 0xA0F63110, 0xE85A1C9A, 0x9C136EA6, 0xD64AF66F,
            0x06A2EA49, 0x7EC1EDE7, 0xF44CDE4E, 0x65B06705, 0xAABEBAC4, 0xF0375AC0, 0x2DB755F3, 0xA5FF3AAA,
            0x7BA34F73, 0x122293C8, 0x0AA00AFF, 0xC46CE09B, 0x764AA186, 0xF34A9A2D, 0xB395427E, 0x98497ABF,
            0xB11393B5, 0x75EF200D, 0xC8344996, 0xC6256DD6, 0xC9138B00, 0x160F5279, 0x93A0047D, 0x5F627CC3,
            0x76A7C57A, 0xE56CC6D0, 0xBE165D38, 0x2032E487, 0x631F180A, 0x6E51EA54, 0x66A10BB5, 0xC8C96284,
            0xAE85F2D3, 0xD170305C, 0xBF72967F, 0xE294A590, 0xE7D97A68, 0x9578D0CE, 0x9637DD66, 0x353121A0,
            0x764D1B49, 0x67D3F8DD, 0x21B13A8D, 0x1A0D2560, 0x9F930CE6, 0x4978A46C, 0x76F7FD23, 0x19BD2B7E,
            0xD4D4D678, 0x6F739D7B, 0x106BEFE6, 0x53EBD511, 0x7AEE3B39, 0x4FF12889, 0xBE2B4111, 0x5165C84C,
            0xBC2A819D, 0xA85BF7B5, 0xC0EBEE0F, 0xF7702441, 0xC32F1817, 0x12396BD7, 0x2FC3753E, 0xEF108CE7,
            0xAD3246E9, 0x90AC1789, 0x023E4FA3, 0xA5DECE0A, 0x71BB3EE4, 0x3E04F04F, 0xA5F27081, 0xBF41104A,
            0xA2CD02C1, 0x65570D42, 0xCDBD5FDD, 0xE4D188A0, 0x3216A323, 0x16D717BF, 0x44C78D1E, 0x66FD76E3,
            0x44D69E4F, 0xAEF7DE48, 0xF6829DA6, 0xB5E5216E, 0xEE969CE2, 0xFC11D29D, 0x10BF6B07, 0x9A5915EC,
            0xDD0FF4A6, 0xEFE3270F, 0x155DD0A7, 0xECCB86E8, 0x1B2233DF, 0xAE719845, 0xE311AEBF, 0xE1F9E44A,
            0xC5028DB7, 0xB8B217B6, 0xAC3DDAFF, 0xEF897B93, 0x14DDB851, 0xF653C572, 0xDDE959E3, 0x2EAB9E3C,
            0x1505FFAD, 0xA4F3DA4D, 0x6978CD05, 0x7B6628F2, 0x558F7E83, 0xA74D8685, 0xFAB947C1, 0x09296A12,
            0x3D6FFEED, 0x6E13C006, 0xD7630791, 0x64AB1AC3, 0xBDC0568B, 0x1D844C68, 0xEAD2FEE5, 0x2BFAE296,
            0xC1EF9BAD, 0x9CB049B8, 0x1111BCBD, 0xD440C973, 0x5B87B1B5, 0xEA16B2BE, 0xAEF48A48, 0xC6A37651,
            0xFDBC7E0F, 0x2CEF698D, 0x72FF241B, 0xD3A7E6E8, 0x71CD82A8, 0x35249FC5, 0xDBBE3882, 0x05A612E2,
            0x8B88F1B4, 0x70122319, 0x92398F0B, 0x801A8659, 0x64BEF443, 0x1412112A, 0x024DD700, 0xB049ACB4,
            0x676AED8D, 0xB7C1DA06, 0xEF38C030, 0x9A2D6367, 0x897E8FCC, 0xD54F69B2, 0x5B8F137F, 0xC02AE8CE,
            0x0BD81EE6, 0xC6AB9617, 0x53F4F965, 0xDAD2FDCF, 0xE20F445A, 0x5CFBF157, 0x608DB960, 0xAA6E4E4B,
            0x3DA29C13, 0x108DD657, 0xB313AED9, 0x4B1349A3, 0x5162C141, 0xA3DF286A, 0x1EEF9601, 0xC51EDE77,
            0xEB460532, 0x4473DB91, 0xD596F3E0, 0x5293C477, 0x00E6E8A0, 0x722BFCD0, 0xE26F569D, 0xEBC1EA14,
            0x4E92C0B2, 0x5493C2BC, 0x4ACF06AE, 0xBFE76BC5, 0xDDD4CD1B, 0x8207E2FB, 0x276E7A84, 0xF7140C32,
            0xD370A6DA, 0x46A761AD, 0x44E3A449, 0x780A79D7, 0x912BA87C, 0x014F0A48, 0xE0C67346, 0x030A8F1D,
            0x8F23ACBF, 0x175389C4, 0x703F7B4B, 0xE3F31B87, 0xE5FC0D5E, 0x9A21E43F, 0xC238D8F8, 0x3D3F31B0,
            0xCB709A89, 0x9B8DC221, 0x9D570343, 0xE6A89855, 0xD044D4E6, 0xF698D3EA, 0x944DB8E5, 0x06BE74FD,
            0x4A1E7FF8, 0x0ADF721B, 0xA0E0963F, 0x68CF8D10, 0xC5B79E4D, 0xCD801F44, 0x0BCAAF75, 0x6031889A,
            0xA6F525CC, 0xFBB6F3D3, 0xC3B26EBC, 0xB294A519, 0xF90F8182, 0x729DFB74, 0x581F930A, 0xF35E239F,
            0xE8500E97, 0xE923A63D, 0x48D39855, 0x47E3E668, 0x79D95B7F, 0xB446FFC4, 0xAF379784, 0xE198DE3F,
            0xBC08CC4F, 0x6FF90383, 0x28B04B5C, 0xEACBEAA5, 0x717C4109, 0xA64A8164, 0x90F62563, 0x5D039F99,
            0x52F2AB54, 0x50E108F5, 0x7A560C26, 0xA12BB80C, 0xC9017063, 0xCB6043EA, 0x956DC04B, 0xBF1DD480,
            0x192EE0F5, 0x0032C2EF, 0xC3B6D696, 0x41D0446E, 0x69E2FD91, 0x31F48F10, 0x2DD0B991, 0x920DB67F,
            0x0CCD57BE, 0x9F10B8B5, 0xB8F07CBC, 0xEF928F9C, 0x6F97EB78, 0x18F98B8E, 0xEA238BDC, 0x933BEF21,
            0xEB264FCD, 0xA349CCC2, 0x283CE38A, 0x6E292420, 0xED76703E, 0xA5AD1D81, 0x19F672E2, 0xDF1EA29D,
            0x92573AA2, 0xB1EAF7DD, 0x7D298571, 0x99197AE4, 0x0D2021D0, 0x9FEC13D7, 0x1C4E8DC3, 0x0A9E9968,
            0x4DFDD55B, 0x2D539871, 0x79B8DE7A, 0x17F28FAF, 0x6255D157, 0xD64D9CA3, 0x7C5CF000, 0xF233B461,
            0x38CF1E14, 0x59A31FF5, 0x08185E91, 0xD809A7F5, 0x7401D394, 0xEF597E43, 0x7CF8B1DC, 0x736D192B,
            0x4E5010B4, 0x7F539ACC, 0xF9A09AC1, 0x9C55FD6E, 0xA44EC74E, 0x1B4417C0, 0x5C3C88DF, 0x056B1401,
            0xE022B2F5, 0xABF18342, 0xC6083BDF, 0x4D245466, 0xC8C5B2A5, 0x1E96AA77, 0x77D394D4, 0xE9E49CD0,
            0xD6F6685B, 0x6A466C27, 0xC7674EDB, 0x40867AE6, 0xB26BB55B, 0xA4C997DF, 0xDF259562, 0x883E74DB,
            0x845854B8, 0x4BA98C21, 0xAFCB1858, 0xCADDDC71, 0x8ECD7BD3, 0x39E00DE4, 0x9F0B8E4F, 0x9D9476BE,
            0x3A407AC4, 0x03776FB6, 0xCACFBFAF, 0xEFD87963, 0x2E6E8E8B, 0x6690DE56, 0x1B0F364A, 0x8E1CA316,
            0x695EBB7E, 0xAE4A22EE, 0x89CC1F18, 0x39DDD75E, 0x500BF0CF, 0xF1564282, 0x8DA24B54, 0x220E91B4,
            0x79EC2F04, 0xF9E930A6, 0x2D26D248, 0x0A5AF5E1, 0x933034C5, 0x0B316CAB, 0xF9F46162, 0xDA1D2B73,
            0xD9542453, 0x83E806B6, 0xBA064F43, 0x68C58BB7, 0xD5B48840, 0x360385BB, 0x7FDA2C45, 0x43B2C8C8,
            0xE6AE1286, 0x4B94E1BA, 0x00802571, 0x16D07158, 0x690C5E02, 0xF1BA4BD6, 0xB5B84BCF, 0xDE4B6A13,
            0x50ED0762, 0x13611419, 0x19281E01, 0xD31B2DF1, 0xA27C8A7E, 0x5C01F695, 0x254ED202, 0x2437CDCD,
            0x5DE0B020, 0x7F6C7C75, 0xA2FBEF51, 0x8411AF81, 0x63B86EC0, 0xF025A72A, 0xD693389E, 0x56FA3F7B,
            0x87B1AF00, 0x3FD05EF8, 0x6F40B73D, 0xB2C1C055, 0x915CB307, 0x1FD6BABE, 0x1C0CD059, 0xB920E8DE,
            0xDFCDFB91, 0xED710DAE, 0x2364CCF9, 0xC25173C9, 0x30313F1C, 0x8C9F44AF, 0xE5FE5DFE, 0xD374AA91,
            0xC5592475, 0xFB1E050B, 0xDA3A0FA9, 0xFEA5E8EB, 0xE722156C, 0xF960A15D, 0x39F0FDF4, 0x6E8EED10,
            0xAADE5882, 0xC8756604, 0xA1E1B2E2, 0x538ED571, 0xFA1285B6, 0x44C6C9E7, 0x3321BD81, 0x1F87F591,
            0x46F29D69, 0xB001B4DC, 0x5778C9AC, 0x52D36B3C, 0xF70A2881, 0x89F982B9, 0x702D736C, 0x78F32BB3,
            0xC8E4D51A, 0x598C72F8, 0x3E38F897, 0x308F62D7, 0xECC80F9E, 0x0C11EE30, 0x3B933470, 0x34B952DF,
            0x005D8022, 0x876C5E4C, 0x04DA645B, 0xC3F63087, 0x34B3E85D, 0x7A9EF27C, 0x95779967, 0x42B99A22,
            0x8BF305D5, 0xB46FDF24, 0xBBC7229C, 0x55EACE94, 0x7686270C, 0x88D1FB79, 0xE826B232, 0xE687ABAB,
            0x0EC24465, 0x6C957C92, 0x8EDAB125, 0x897B41A6, 0x9FC44BDC, 0x684E25A8, 0xF5E84C5F, 0xC9FEC9B5,
            0x3A091264, 0x097AE3DC, 0x4401C58A, 0x58B637EE, 0x18243E98, 0x8AE9D4F7, 0x865D6449, 0x17F676E8,
            0x295F6D41, 0x20328E0A, 0xE3268F63, 0x30F7F53B, 0xBB2E1F93, 0x16726672, 0x45289E98, 0xF67E31D4,
            0xD0C89EED, 0x29977287, 0x703F1D9F, 0x52C278E0, 0x6D49ED9B, 0x8160695C, 0xB9727205, 0x854605D7,
            0x9EC34677, 0x7CCBAB0D, 0x1D32D3FA, 0x5EAF0F1D, 0xD4B41DED, 0x608653C2, 0x325155CB, 0x0285EF98,
            0x06A4D4BA, 0x53ABBD95, 0x96626B6F, 0xB3EBD3DD, 0x0058DC75, 0x0A470912, 0x29530360, 0xFCD74D7D,
            0x22CE5941, 0x22AD9654, 0xA1261AD7, 0x054AF314, 0xC5D867A5, 0x2FECA2CB, 0x59174E7F, 0x5998482B,
            0xFE9C67D2, 0xC03EA248, 0xD8206B04, 0x96ECC9D7, 0xCEBBC457, 0x81B0AEF2, 0xD00B369B, 0xEEE667C7,
            0xC445CE48, 0xAB3F1CB7, 0x14C473FF, 0x255F907E, 0x19ADB77B, 0xCA67E937, 0xDE28FAEB, 0x0ECBE24C,
            0x9836C5CC, 0x58BC3F7A, 0x84C6B6F6, 0x967CDF79, 0xBF0F4893, 0x76089AF1, 0xF8F46F51, 0xB92ECB4B,
            0xBC4A9201, 0x4CF26D77, 0xB97D00D1, 0x847574FB, 0x5332CA1A, 0x149BB13A, 0xFC293D98, 0xF91880BC,
            0xC5808465, 0x482A29B9, 0x0FBF1608, 0x6307E106, 0x5D5390DD, 0xC7502FF6, 0xE7B3268D, 0xC3B42F1B,
            0x3270F558, 0x04774983, 0xBFB2192F, 0xF8692E23, 0x7AD222ED, 0x8FD6459F, 0xCAB70524, 0x783BE0CF,
            0xB2791327, 0x7EDD10F5, 0x85F2840D, 0x24E91D3E, 0x8E866905, 0x99FE87C9, 0x21FBB4EE, 0xB531FEF5,
            0x7EF1843C, 0x6C09EF6D, 0x17E4E3AA, 0x01D93BF2, 0xEAF34951, 0x92135E6C, 0xAA603E44, 0xA3C28E26,
            0xE162EB54, 0x2527C022, 0x282034F4, 0x86A1AB23, 0x7716C85B, 0xD41E804D, 0xA116D323, 0xC825179B,
            0xC4048244, 0xBE8DAA75, 0xCE86496F, 0x6751C930, 0x8FA92CA4, 0xDA5FBAC8, 0xE9FF8918, 0x02D6D9D8,
            0xE450D1D1, 0xE68E9EEE, 0x3B863253, 0x72BD3FEE, 0x5F451B16, 0xB2EFDF98, 0x01BAFE50, 0x1F9905B3,
            0x2B34DCE3, 0x44469D51, 0xBF585A76, 0xC5DD23DB, 0xDE34C058, 0xC8949C25, 0xB4CA8119, 0xD8EB0548,
            0x2DD78469, 0x7FD839C1, 0x49BF1399, 0x31363D2D, 0xC7F5C90B, 0x582CE5D1, 0x980ABC27, 0xE301FB61,
            0xF754248C, 0xA322270A, 0x239AB7FB, 0xFBA9F5FE, 0xD623CD5C, 0x6B454C70, 0xE95D4372, 0xC03E3C73,
            0x11F06C24, 0x46EA9426, 0xA0D6693D, 0x8E954CAF, 0x554B778B, 0xEADB160F, 0x72CBA93D, 0x21B6F36E,
            0x2A1F5A69, 0x415F85AE, 0xC354E343, 0x2DBCF56C, 0x3CF44972, 0x85CB734C, 0xF915481F, 0x21DB64E4,
            0xA746CD7B, 0x442A4C2E, 0x70F3CC48, 0x465385EB, 0x6BDA8D8C, 0x75D00E3B, 0x4501865D, 0x57E44DC9,
            0x9FB50F5E, 0x64EBB209, 0x709F57A9, 0x9E22E034, 0x71466348, 0x81AE4206, 0x0D0AFD59, 0xB40F41D5,
            0xCB63EA8D, 0xF6341A15, 0x3BE72220, 0xD8C4BBF7, 0x96A7B1A9, 0xFCF7D66E, 0x5AE4F715, 0x11E9E18B,
            0x86CAA019, 0x75A0BDCE, 0x2D6CC391, 0x764629E3, 0x17DE679F, 0x74A1A8C7, 0x6A525CCC, 0x5E52F500,
            0x2BCA1819, 0x7B199093, 0x80B45047, 0x9EB0D9BE, 0xB636B33D, 0x812AC959, 0xCA4A483D, 0x220F811E,
            0xF4885570, 0x93E6A267, 0x84F6F2F4, 0x15B9A4FF, 0x6C0C938B, 0xCE1F6091, 0xF4CB34B1, 0x38D4BAA1,
            0xD67E5731, 0x0CF0854D, 0xBF587325, 0x5BD994E2, 0xE4AA44D9, 0x853B3FC6, 0x4AA5DB50, 0xF08BBC1D,
            0xF0FB387E, 0xED19768D, 0xBA5FC6EA, 0xACF33828, 0x9AB12284, 0x8756F65D, 0xA47E18C0, 0xB33B7C74,
            0x38F03B80, 0x5D9BE853, 0xEE16BC8A, 0x246B9E76, 0x3152BE15, 0x83049795, 0xC59519EF, 0x28C73149,
            0x7EDA99C9, 0x4A8D18E1, 0x4276B2CB, 0x94EA267D, 0x2AD1E8A1, 0x6FFA375D, 0x157A62FD, 0x56EC7C89,
            0x11C2F60B, 0x73288830, 0x0DFA9B07, 0xC222F181, 0x41E24652, 0x10665DB2, 0x3F40BB40, 0x1530C315,
            0xA7B9671C, 0x834C6C10, 0x1F09C71D, 0x36B95068, 0xA94404DC, 0xB652B3E0, 0x33BA6FE1, 0x10787B44,
            0xDC3C11BA, 0xC817BF24, 0xE9412AEF, 0x9A6CECB1, 0xCF03B3C3, 0xC51C99DF, 0x3DC397C4, 0xB7EE606B,
            0x95F28150, 0xC115C860, 0x0243AD49, 0x23E3690A, 0xBFC8ECC3, 0xCCD45586, 0x80CFE74A, 0xF6E89063,
            0xEEA71A3F, 0x495A4839, 0x37A9E381, 0x8DA64E07, 0xEA895060, 0x7BCD0AF6, 0x1C11D8A6, 0xF6CC2E0C,
            0x5727682E, 0x1736E11D, 0xE19906E0, 0xEC0E8ADD, 0x30F0E18D, 0xAD291A16, 0x4BC680AC, 0x9E85CB19,
            0x25141B35, 0xDD74DBC4, 0x3A844A93, 0xA6446AC9, 0x716F0875, 0xBCD0E213, 0x3BF22CF2, 0xFC22C6B0,
            0x294F9666, 0x77909F73, 0xBC2654D6, 0x181F6F26, 0xB1E0FF5E, 0xDFAB12C9, 0x85EC5BBA, 0xEFE42456,
            0x15A1F67E, 0x738EB20E, 0xE1367765, 0x3F56E0FE, 0xC06FF256, 0xCB02992F, 0x7538C31C, 0x7358604C,
            0x9C578F9E, 0xD0FABB0D, 0x18B1AA1C, 0x31F63644, 0x9A6D254B, 0x50D204E6, 0x0B6C56AE, 0xF783617D,
            0x9FFF5FF9, 0x92C7D3F8, 0xD67A54C3, 0xCCB4B89A, 0xB2CB2052, 0x3525713C, 0x79AF24EE, 0x565A1A79,
            0xBDE9C3AB, 0xC0EE6E7A, 0x428DC0DE, 0xCB8E0B5E, 0x7D4DB226, 0xAD09C519, 0x39125CDC, 0x275416CC,
            0x177D96B3, 0x260CB97D, 0x591EAAD4, 0xA68AFE70, 0x2E6807D4, 0x2222AAF5, 0xB2DA0093, 0x147375F1,
            0x60115EF2, 0x0E81B2BC, 0x18654688, 0x0602F539, 0x0B642323, 0xF04BD155, 0x194C0A86, 0xA5B88BFE,
            0xE25147F5, 0x222C8A71, 0x52D8ADB5, 0x6026F929, 0xEF0C1AA6, 0xB38F48CD, 0x3171BB26, 0x8395D33B,
            0x2D66B92E, 0xB9B2A010, 0xD7FCCADC, 0xA2F93987, 0xE064F2F8, 0x8708514C, 0x84CEB461, 0x375B4B7B,
            0x2C77702E, 0xCE7514CC, 0xDA3C589D, 0x41DCDC93, 0x4F72AF0E, 0xD81E2792, 0x298AE2B7, 0xD4D7C030,
            0x0972580C, 0x9CD17522, 0xD23131CA, 0x7706B78C, 0xA1B6F515, 0x404766FA, 0x0E7B2D57, 0xD0540CFD,
            0xA09A8E24, 0xBBB74F1B, 0xAB7098D6, 0x3175BF4C, 0x84603309, 0xAE311F3F, 0xB77611DD, 0x40A09757,
            0x06DC74FE, 0x6C891E78, 0x5EDF3098, 0x02338F3D, 0x90FDF946, 0x753FE945, 0x413569F9, 0x39C3A1DB,
            0xB26CB70C, 0x1EDF9C5C, 0xCCAC6085, 0xFE57AEDF, 0x3050D403, 0xEAE3258E, 0xD924E468, 0xED9A8474,
            0xD205F367, 0x75E74CC0, 0x3F9C27A9, 0x017D094D, 0xCC5D733F, 0x83F93B8A, 0x1510BBFE, 0x3FE56CF6,
            0x61A2C9BA, 0xFF24B1C4, 0xA6C299A7, 0xAB58623D, 0x7623A363, 0xEBB7C2C2, 0x6FDBF53A, 0x815B8B67,
            0x21836C22, 0xC9A0E725, 0xCAC1D5E8, 0xFD992F46, 0xDEA23AA3, 0xDDDB1FCD, 0x086B975E, 0xB8BCB964,
            0x2018A4C3, 0x42811DE9, 0x3896C20E, 0x328FA6BF, 0x06C5458C, 0xF01964BD, 0x1B2CE203, 0x9C55E6A8,
            0x30FC1A86, 0x7DFABD54, 0x2A2F8D72, 0x0C5B3613, 0xF5110E58, 0xA30FE499, 0x43FD2348, 0xB3CCF628,
            0xAE58CB51, 0x0385CF4B, 0x05B89C84, 0x0C1B9DCE, 0xD043A175, 0xAA5F94CE, 0xF512DFFF, 0xBF33F648,
            0x9B22666E, 0x6842A284, 0xFD397347, 0x1C26A4C8, 0xB3346A20, 0x3FF658F4, 0xF4139A26, 0x80AD6A22,
            0xB810B99B, 0x17C34626, 0x5F903441, 0x19E21261, 0x06728E7C, 0x1C0887B0, 0x028C977C, 0xDC1C92FC,
            0xA02F666A, 0x8FE37AFA, 0x14E38213, 0x5EBC0C06, 0xF01FC742, 0x6E5A4D0F, 0x6AEDCB41, 0x2EE375D5,
            0xDA92338C, 0xEE069E88, 0x51604D83, 0x178024DF, 0x959C39A8, 0xCF11CA6D, 0x0DA3D46B, 0x179162E6,
            0x629D2FA1, 0x6B4E92EA, 0x11037E5A, 0xFB26ECA4, 0xB0E8798C, 0x8C682562, 0x4A5D38B8, 0xF3987E6C,
            0xD1842791, 0x0E1E6BD8, 0x45FC8270, 0x6A74E4A2, 0xF9049DFE, 0x2D168DBA, 0x82E342AA, 0x651BEC2B,
            0x2A0DF11F, 0xB80A8C19, 0xDD04B206, 0xF7284BA8, 0x7A7D3435, 0x9F2C62B2, 0x3A30FA02, 0xF967B3FF,
            0x7798CFB0, 0xEBD1A5F1, 0xCE26C114, 0xA9E4940C, 0x77B05B56, 0x55B7C15C, 0xACA885DB, 0x3E992037,
            0xDBFA006F, 0xA3107555, 0xB8630E5B, 0x6FD5CEBB, 0xBA30488D, 0x92CBD5BE, 0xC0415A20, 0x88F3A9F3,
            0x756434AC, 0x4156693F, 0x78607387, 0xBCC8D93C, 0xB68CE707, 0x46D271D5, 0xD4AF2374, 0xA8130F9D,
            0x609438B2, 0xED3C07A6, 0xB4C3749E, 0x8C78336D, 0x71A13353, 0xC8A6D5C3, 0x4433E3A0, 0xC70989BB,
            0x5104176C, 0xA546B808, 0x0084A59C, 0x7E626B96, 0x50515A0A, 0x5F2B02C8, 0xB265FCE6, 0x2EBBD011,
            0x075C6498, 0xF8A94205, 0xE52849BA, 0x5061B978, 0x8C1FEC2E, 0x6C6FACEE, 0x8B6E9672, 0x09D7CE2C,
            0x750720EB, 0x3EC02339, 0xAFCC7BA6, 0xF47DE86B, 0xABF4411C, 0xB04D4C78, 0x44181DBF, 0xB2DBC145,
            0x0415904A, 0x093B63D4, 0xCEBEB1F9, 0x0C4A83E4, 0x294F9062, 0xF661D43D, 0xB5166D3F, 0x2090759F,
            0xE5360856, 0xB9C3CAE5, 0x8AFEA591, 0x508791C3, 0x83DA79DD, 0x03DD9051, 0xA04BE1B0, 0x707AC987,
            0xF800CC47, 0x17916FB9, 0xE19E2183, 0x6D738B94, 0x23CFE2BD, 0xFECF6AC2, 0x7AE74CEB, 0xF7C321BF,
            0xE9800B4F, 0xF9D021E6, 0x010B3E62, 0x44873820, 0x4A6FB57C, 0xBEBCF8E3, 0x86B1AF9E, 0x16ACB48D,
            0x6A0D4E0B, 0xB98333BB, 0x3D31E829, 0x08081535, 0x5DBB4920, 0x911A13F1, 0x0455D9F7, 0xFE4F1D0B,
            0x60D49C08, 0x3FE4B2B0, 0x4DD4F074, 0x1F4D6C14, 0xC508E586, 0x6E8F17B2, 0x7BF1E416, 0xB7F5792D,
            0x9D1FDDA1, 0x22D04107, 0xFE33C5D0, 0x3F3F847E, 0x42BC21F8, 0x2C39E5D2, 0xB19426B3, 0xC9379B6E,
            0x29FFE1F7, 0xF8986E3E, 0xDD98CA9B, 0x008E76DA, 0xC3EACC79, 0xD390189B, 0x5CCB8A95, 0x0B20DA49,
            0xD892A7B6, 0x09CD3EFB, 0x2652EBAD, 0xADDDAC8A, 0xF399C913, 0xC628F919, 0xCBE61A0F, 0xE585667C,
            0x78B9EEBB, 0x92B1C77D, 0x3C73DCCA, 0x6EFC8213, 0x295A54A3, 0xBF80302C, 0xC3881FAC, 0x0DDED7D2,
            0x551C8DD2, 0x82CC845A, 0x8A4333B7, 0xBE1AA9DE, 0x041AFBF4, 0xB57CE467, 0xE49A235F, 0x790C507D,
            0xD2D028CC, 0xBC503769, 0xDD5CBBDA, 0x0C3C211E, 0xF7BBB933, 0x515F825B, 0xB4988DC8, 0x0489B875,
            0xF2713DCA, 0x61E3A45D, 0x9ABC4B39, 0xEB974F6E, 0x5262BDEA, 0x0FA85AEC, 0xD6FFBF88, 0x8817E82F,
            0x0C6EBF5F, 0x87B8A3EA, 0xFC2F0975, 0xFFC108C5, 0xC0F33344, 0x3494F6E0, 0x59BD6BC7, 0x9A78B61E,
            0x76730C82, 0xD701D003, 0x7429F1C0, 0x9CB0302A, 0x52C82039, 0x36DEF9F0, 0x8515A43E, 0xC33FEC37,
            0xA00D4E2E, 0x0873EE2D, 0x80334C28, 0x10073A26, 0x0F5627C4, 0x627650F8, 0xF130221F, 0xCABBD1B0,
            0x1DF77F65, 0xAAC6C518, 0x48A5C516, 0xC426CA8F, 0x9E5928AF, 0xD97FEE79, 0x7706D282, 0xB589170D,
            0x0AE9C89D, 0x2D65BE92, 0x126FA220, 0x14731CB9, 0x019787FF, 0xC7397312, 0x69529296, 0x6FFFA585,
            0xD30E44E7, 0xABC34416, 0xB02DCAD0, 0xEFE3CF9E, 0x9F45886C, 0x353ACB89, 0xFC36AD25, 0x1D164343,
            0xC92C55D4, 0x2FB05CE7, 0xF2669BF6, 0x7277152E, 0xE1355F00, 0x7F0705EC, 0x2E66F630, 0x1E58059B,
            0xB0C6696A, 0x5C6EEFB6, 0x576CE8E6, 0xC577C96F, 0x52B0A14D, 0x20E4C242, 0x06AC9497, 0xA80EB33E,
            0xC4B93BE0, 0xA8C05D78, 0x76CFAC09, 0xE487A511, 0x2761EE0D, 0xA8441F05, 0x817528E0, 0xCEF7BADC,
            0x352F1F58, 0xC8E4F281, 0xD325CBEE, 0x4D7587A9, 0x55A474E3, 0x820D3BE4, 0xE036FD57, 0xFC80DBB3,
            0x10C7B7CC, 0x1D91DF24, 0x9C790946, 0x3C604F31, 0xD2BA6C32, 0x4F4E24BA, 0x4AF50DF3, 0xAD0D681B,
            0x896DA2C8, 0x68AF0E60, 0xD7122DC2, 0x3A251FD2, 0x60F773FA, 0xEA9ECFB2, 0x6C030D68, 0x3FB61293,
            0x38C15C7A, 0x6590DE02, 0x3C9929E9, 0x0142334A, 0xDF405BEF, 0x50519E19, 0x31FD8C85, 0xE12487AE,
            0xBB4E6743, 0x176BDF4C, 0xF3F069C9, 0xC9167D20, 0xF7A0D0FC, 0x633556E7, 0x9EB0AE21, 0xE569ADD4,
            0x1B7685F8, 0xC5BF28B5, 0x43389DD1, 0x3883AD23, 0x0B727316, 0xC80FE0D5, 0x7D593302, 0x24D618E1,
            0xADEEF50A, 0x0C3D58DD, 0xA9F81D05, 0x69E81CB4, 0x3FA01CFD, 0xFC8FEDD5, 0x01D677D0, 0xCB73137B,
            0x388D269D, 0xA30C7D06, 0x029DB2CC, 0xE3D4D2CF, 0xE4D6595B, 0xAEFB0D7D, 0x1CDD5477, 0xC53426F3,
            0xCF204F7F, 0xDDBDD513, 0xFBA09033, 0xEFCE8CB0, 0x3183F6CE, 0xCD5623CA, 0xDA3B236A, 0xB96CA1A1,
            0x727B4EB7, 0xC50FCE8C, 0xD90CD966, 0xD488208A, 0xE01938EB, 0x1F127E93, 0x888EC434, 0x412E1B63,
            0x762AB1CD, 0xE6D39981, 0xF3D37947, 0x4E9A563C, 0xEAF887A8, 0xAE4156BE, 0xDE5D65CF, 0x86B3B8D9,
            0xA16F8B03, 0x5618B8A4, 0x4972B16C, 0xC78A7C1C, 0x4740C15D, 0xE757E974, 0xFA318702, 0x78FFD156,
            0xDDB93F69, 0xE6964BB3, 0x38A5CA88, 0x7C4AD7D6, 0x35A015CB, 0x83EB141D, 0x0CA846DC, 0x376E7D99,
            0x7D038881, 0xCDF6C949, 0x6749A88B, 0xE261ECE0, 0xC991A0FB, 0x4FF9245A, 0x74CCF035, 0xFDA8475F,
            0xA385D85C, 0x4C8DD93F, 0x85581B5A, 0x4B245D0E, 0xDD78C047, 0xD7F982EB, 0x3CF6882D, 0x3C8A7783,
            0x936E82E3, 0xBC39FDE6, 0xE48AFB36, 0x51D8ACB7, 0x5887638A, 0x520EC671, 0x8AC2161A, 0xBF609461,
            0xDA70B688, 0x10E50B6C, 0x1022E263, 0x18BEC8C6, 0x4752F808, 0xF7DF8A18, 0x70563C0D, 0x0C417924,
            0xCA9D9E14, 0xF184F32E, 0xD39B98EE, 0x338A428E, 0xB6A7AFB2, 0x4C5FA52B, 0x1C1B86F8, 0xA7058C96,
            0xF917CD01, 0x9BF88A37, 0x3DD6EE7F, 0x0C84490F, 0x9064378F, 0xF3791A9A, 0x24CDD6AD, 0x4DB61D37,
            0x8BFBA5C8, 0x8BC9270E, 0x7AB2D559, 0xB7DED163, 0x87169108, 0x5791E63E, 0xFA8E0B25, 0x467D3AAE,
            0x55DE512F, 0x3756B3F0, 0xEB34DE8C, 0xD9304FBD, 0x46632D1E, 0x739A4C64, 0xE96A1CDB, 0xC47E13FA,
            0x16494148, 0x57EE7ED2, 0x64942402, 0x9DFD8B5C, 0x52047629, 0x42DCFCEB, 0x01EDB128, 0x24C24C07,
            0xED960C09, 0x19A981D0, 0xAF3F652E, 0xDB83D99F, 0x6D0D2980, 0x68DC92E1, 0x4BB7B032, 0x2B4C7DC8,
            0x80EF9269, 0xB8D86FB7, 0x59555587, 0xD9AEAA4D, 0xA9677C84, 0xDB0FA24D, 0x1BDE6ACB, 0x3B6C3107,
            0xD9C9F030, 0x885FC025, 0xCA72EE14, 0xBAF68301, 0x0C2F66C9, 0xB69C3DEE, 0xEF5C61C1, 0xB904D5DC,
            0x73BB13A0, 0xE921991F, 0xCE571345, 0x0DAD7BA1, 0x190535F8, 0xF87E42A9, 0x121B45F7, 0xA7D40C66,
            0xF47846A4, 0x2572C1C6, 0x4BCCE8ED, 0x1934F743, 0x4E3B6DB3, 0x7255774C, 0x72C2F836, 0x9D5F4DC9,
            0x0DD19400, 0xAA68E965, 0x42426C80, 0xD3855A1F, 0x1473DC61, 0x3C07305C, 0x5FB9DD92, 0xFB3110DC,
            0xF752C55F, 0x93FB2294, 0xF623EC2B, 0x8A4BADDD, 0x43BC4470, 0x6720E013, 0x4524743C, 0x1CFFE8F0,
            0xF1AA8634, 0x9DDB786E, 0x139CE36B, 0xDA960AF7, 0x7D9ECE38, 0x6E26EB96, 0x550141AC, 0x3AD73BED,
            0xF44423EB, 0xF4603F76, 0xF06CD584, 0x4287BB4F, 0x78C70142, 0x4D725CB9, 0x021C9A4A, 0x8C2280C5,
            0xDD23A723, 0x5BD09301, 0x8335D72F, 0xE66B6C36, 0xBE88C674, 0x8DA5FDFB, 0xAEAD0334, 0xC24C6400,
            0xD324B35B, 0x18422350, 0xDB7C4711, 0xA214C510, 0x46B7F6F5, 0x8FAAE032, 0x7C937C54, 0x75C695F7,
            0x2F8AD834, 0xBCEBB29B, 0x29410FC0, 0x5C291B61, 0x432B44F1, 0x30365AFF, 0x1D69F7ED, 0x8AE0A330,
            0xAC5CD26F, 0xEB1B6A18, 0x5093B7BC, 0xC7C27FC4, 0x73266AE2, 0x4B5D5DC5, 0x68D7719B, 0xC5151615,
            0x52A82F1A, 0xEBE15877, 0xB17A3DF9, 0x215A0584, 0x72113038, 0x84BB2C26, 0x957AE7A5, 0xD191BA2C,
            0x667ECD49, 0x9F30D46F, 0x3B7CC7E2, 0xBFD1E6AB, 0x77A47569, 0x963CDE9C, 0x3D4290D6, 0x203BC5A2,
            0xB6B3E13E, 0xDDBF3E75, 0x87132AB9, 0x4AEA20A2, 0x9C34C056, 0x5BD716C4, 0x134809C8, 0xA9A24233,
            0xDAD358E6, 0x7CDFF06E, 0x33A8CD14, 0xF27D958D, 0x1BE3FE05, 0x545FDBAC, 0x76D61959, 0x339E2B05,
            0x0260D14D, 0x97C58736, 0xFF765E6D, 0x2F668DCD, 0x7B64C1B8, 0xBB79B705, 0xEC6CD089, 0xFB676867,
            0xEA53EF11, 0xB385F826, 0x09D86520, 0xF38E5868, 0xD98CC928, 0xC24EAC3A, 0xAF1B7A46, 0x46677748,
            0x8C951110, 0x47318016, 0x3E055570, 0x19C2EF07, 0x5EC31BA9, 0xF140C6D5, 0x38971AF6, 0xC515572C,
            0x17FF5296, 0x65CC922B, 0x5C3A6CF3, 0xAB041229, 0x0E87968D, 0xAE40FD71, 0x4663E6AD, 0x8C091466,
            0x825669B8, 0x044424C7, 0x9BA13D9F, 0xBFD5835B, 0xC6E706C4, 0x3DEACB2C, 0x3788C111, 0x5FF069AE,
            0xE9C41110, 0xBCADDE8A, 0x4CA06CF8, 0x2651723D, 0x7353956F, 0xB7F67329, 0x7E934573, 0xA187223B,
            0xC05873F1, 0xE42CBBB0, 0x37F4E96C, 0xC743406E, 0x0F6B165C, 0xFFE0A195, 0x14E582FA, 0x2CCFE85D,
            0x4AC5FAC8, 0x7CA1A642, 0xDCBA80C4, 0xA86A2886, 0xAC1FC814, 0xFCB66579, 0x7A94FE9F, 0x6B863378,
            0xFA452708, 0x25376C60, 0x8A9AC57B, 0xD7113547, 0x6EE921FC, 0xACE3CE89, 0x93AF0158, 0x45AF1889,
            0x7E131BA7, 0x9B902C4F, 0x23949170, 0xA6045261, 0xAE29F9A6, 0x54DF27AC, 0x7B3FF1AB, 0xC00C7F49,
            0x8444CB52, 0x2F23AE49, 0x33323103, 0xF6163E7C, 0x0D3923BF, 0x88B8B06F, 0xF00A2524, 0xE7059A67,
            0x6B6FB6AC, 0x8F507A93, 0x44245F98, 0xC7356FBC, 0x481BC97D, 0x5D699DCD, 0xE620A529, 0x2F3CDC1C,
            0x671DE640, 0xC60FF025, 0xFB3D2067, 0x236F0846, 0xA2AD0A86, 0x23547F99, 0x96CB8FC1, 0x3114DDE7,
            0xFE0B702F, 0x5DB2FD3A, 0xF262975F, 0x90056F6C, 0xB4612FFA, 0x9923E1F9, 0x594A7078, 0x88A4ED61,
            0x5D6165AB, 0x674BA13E, 0x86761E11, 0x3429CB08, 0x85FA69A6, 0x93A11936, 0xBFCEFD80, 0xD1293647,
            0xB9AD7728, 0x1F11B587, 0xEB898C71, 0x3D25EDE1, 0x1E92C16D, 0xFCFBFF65, 0x95D88BBB, 0x0CFE531A,
            0x6F09D035, 0x48B0B6C6, 0x89C41E5A, 0xBA08105D, 0x605393FA, 0x5E42173D, 0xAC28D701, 0x44B6AC60,
            0x0F591631, 0x186E0826, 0x0B0671BE, 0x05F39D32, 0x41B0421F, 0xB6E4D99A, 0x2175868C, 0x72EF35F4,
            0x7EB10356, 0x362D2441, 0xFABFE51B, 0xE75CBF9E, 0xEA851A6B, 0xB31C04E7, 0x473711B7, 0xFE3A170F,
            0xDED13D01, 0xC57BC292, 0x00F20E2B, 0x6D071581, 0xC18A671A, 0xCFE42671, 0x666F167A, 0x56245B8C,
            0xABBD26BD, 0xF509F820, 0x5F89EB43, 0x6E49E205, 0x25C253B7, 0x278CC89A, 0x19AF611B, 0xFB5DDA7E,
            0x60C12057, 0xD29E2458, 0x4EFB8720, 0x5A14B4E9, 0xE317DD44, 0xB340259D, 0xB2A11237, 0x27BE0FD8,
            0xBEE124CE, 0x849E9581, 0x64988E2A, 0xF152772B, 0x54DEB1F1, 0x0AB65F3D, 0xE4295410, 0x4B984F8E,
            0x91FD2ADE, 0x74A1B343, 0x4F3B12B3, 0xE56CE01E, 0x2DD8B90C, 0xCB7D283D, 0xEA848CE3, 0xA9CC83E8,
            0x99E40A0A, 0xD571F245, 0x7CED592E, 0xCDFCFA97, 0xEE2668DE, 0x747164EA, 0xFB93DD63, 0x7D222644,
            0x2795B7B9, 0x8AA8DF06, 0x6CD928D0, 0x353DC575, 0x3A622F63, 0xA9C1E20B, 0xD265BCDB, 0x8DDD010A,
            0x2CC8DB75, 0x460C9150, 0xBE877D94, 0x5F9F61C8, 0xAC2A208D, 0xEDAC45F9, 0x4B17E385, 0x1A8D160B,
            0xC6437175, 0xCB07CD29, 0x40597407, 0x50B580C0, 0xCEB46D9A, 0xD9C99F1D, 0x7BAC6E69, 0xAC49E3F6,
            0x0B4A9D81, 0x9218BF8B, 0xEA2B7C1E, 0xC1C7A280, 0x6F97C24C, 0x24E4332B, 0x5CEC2FE4, 0x6BDAD8A7,
            0xF5D21D85, 0x0ECC6C4B, 0xA51F3DC2, 0x5113DBB6, 0xC840C6A6, 0x4B9FCE39, 0x38AC6DA3, 0xF85899A3,
            0x452DFDB3, 0x25380E23, 0xD808ECB1, 0xF27D8EAA, 0x3E760DEC, 0x099521E7, 0xDAF23474, 0x068EC4BA,
            0x9A1E7696, 0x706D5E7E, 0xD87234B9, 0x9B998DA9, 0xE630C58C, 0x055FD4A7, 0x41FA8191, 0x948ECE78,
            0xC29A3FAD, 0x3D671D20, 0x55986DD3, 0xF4BECAEA, 0x0ED15CA5, 0xCE85F1E5, 0x6942023F, 0xC0D37693,
            0x14B5B7AB, 0x1BB5709E, 0xFB1EAD8A, 0xF4DE2514, 0xF80D11CB, 0xFD8CAFC8, 0x70887EC6, 0x165D638B,
            0xC87142A5, 0x01AC2F93, 0xA7EDEB9A, 0x6064BADE, 0xC7CD2AEA, 0x15806285, 0xDEE9F491, 0x50597F99,
            0x0069C2C3, 0x160BA976, 0x12264BB8, 0x3F30473B, 0x11FA34B0, 0x3CEEF536, 0x1732AB03, 0x640629D8,
            0x2B00F201, 0xE86BB621, 0xA6004390, 0x030D4A27, 0x9F9ECFD4, 0x1333BBB5, 0x56AC9D8D, 0xEADD3C8F,
            0x45858C21, 0x837FF27F, 0xBA384136, 0x2D337C15, 0x267CB4B9, 0xDE8033BB, 0x53B709C1, 0x4B5E6475,
            0x925256F2, 0x6F903DF7, 0x93154BF6, 0x0F6B4935, 0xF2261D6C, 0x5A62422A, 0x8B6D07CA, 0x8E58D049,
            0x58D1BB85, 0xD80C2289, 0x66FF72D6, 0xEE87D0CD, 0xBC9348A5, 0x5C3B7297, 0xC025579E, 0x86C8CDB2,
            0xADEC2C79, 0xA41BDEC7, 0x044E9CA7, 0x3B60C1ED, 0x9D86212E, 0x52225022, 0xF01B8B43, 0x1B0A1C3C,
            0xD9EB6AF7, 0x8654D0F3, 0xEC898D02, 0xDDF00A9D, 0x22073825, 0x0417AA31, 0xAD17C384, 0x86AEEBF8,
            0x8C2F330B, 0x68BCD1E9, 0x99CABA85, 0xA03C7035, 0xCD88EE6F, 0x1E73FD58, 0x31A33126, 0x07BB7865,
            0x76CB4E57, 0x5B16FC19, 0xCC3C58FA, 0x92B83CF5, 0x190660A3, 0xA3199A0A, 0xCD9B6F02, 0xEC3E704A,
            0xCAEEE134, 0xB04B6D37, 0xAFE85C76, 0x8DABB200, 0xF470F223, 0xCE8658D6, 0x0A6114E8, 0xDC06EE0E,
            0x6EF0A49E, 0xDE49BBCA, 0x93540984, 0x5C136804, 0x808F5C73, 0x1E89A786, 0xDEDB634E, 0xA4E83F27,
            0xCFD08DB4, 0x5F86E993, 0xA4419170, 0xE6424645, 0xF4B01399, 0x6621963B, 0x2DE8F05E, 0x6F567674,
            0xB249718E, 0x89660080, 0x7D102462, 0xC88D730F, 0x83793343, 0xC0002AAB, 0x2B24E5A9, 0x39EB9AE8,
            0x955F2091, 0x19FEF251, 0xDB192772, 0xFCA662DA, 0xE5D758BF, 0xCF6ACDD0, 0xE811D744, 0x4CE207E0,
            0x81C500B7, 0x6A038000, 0x3D84ACF1, 0xBCCDCB94, 0x4A21A0A9, 0xE2764C75, 0x4AFC9F4B, 0x5266B1E3,
            0x37C87FBF, 0xD0449D84, 0xBBA639DC, 0x276DBCB7, 0x47C34BB4, 0xB66607A5, 0xBAAD54F2, 0xFB10F739,
            0xF99AAFB6, 0xCB77F4F7, 0x5B27E012, 0xAFD124E9, 0x65E27892, 0x4C191932, 0x90FC706B, 0xF4444C68,
            0xED5AA002, 0x444FED8A, 0x7106C3B2, 0xAD76F727, 0x7E5065ED, 0x2655330B, 0x589ACF88, 0xB300AC24,
            0xB58FD212, 0x9B2360ED, 0x9EEC5377, 0xDFE22A86, 0xE85AA235, 0xAE2FDDAA, 0x778864F4, 0xDAACA69D,
            0x7DD05580, 0x8A914127, 0x76D5BF64, 0x7D383C61, 0xE9EAB146, 0x3C61655F, 0xB520841D, 0x0DE0F3C5,
            0xDAE29794, 0x27060929, 0x56879730, 0x54434246, 0xE8071C6F, 0x0B70E2BE, 0x3356BF5C, 0x9D349E39,
            0x780DBEEE, 0x6B9824AF, 0x73150D2E, 0x5AC49037, 0x3552B71E, 0x045FBF21, 0x41BB2AD3, 0x8A9D0036,
            0x9D4EAF00, 0xB07FEC99, 0x1B67D0DF, 0xF8A11DC9, 0xFD01E146, 0x93D96CB8, 0x13896700, 0xF2BBF825,
            0x02190951, 0x03796643, 0x69E759A5, 0x9D2396EE, 0xAB533C9D, 0x12EFA41C, 0x777FF746, 0xE9A36ABB,
            0x2690F7E3, 0x0151DC63, 0xC698C192, 0x62DC77B0, 0xAAA0D802, 0x0A32B63E, 0x2E77081D, 0x972C4577,
            0xEAB3854B, 0x2EF58E2A, 0x00490C62, 0x71997B6A, 0x830C7B2D, 0x9DA24F96, 0x33A3091F, 0x5C8C466D,
            0xC1FA002A, 0xE731353D, 0x5D1F3783, 0x7269CE5C, 0x30F70856, 0x73F2FAB2, 0x6D3AF741, 0x70DF7BDF,
            0x67778F49, 0xD47C3BAB, 0x361C053C, 0xD053E729, 0xA90FFF02, 0xECE90150, 0xCCD1BEC8, 0x5F1DFBDB,
            0x6101B918, 0x0092F9DE, 0x378000C1, 0x72B0690B, 0x6A903062, 0x37CE1D17, 0x6129293B, 0xDFCEACE4,
            0x9CE8410F, 0x99DB6765, 0xFC434740, 0xC7B07AB2, 0x53DB8584, 0x2A13D942, 0xE297E608, 0x18866497,
            0xFBF4A8AF, 0xE9379D8A, 0x6C0B6220, 0xEDE5A124, 0x1A11AFD0, 0xD3BE67A3, 0xB09E2314, 0xD6FE804B,
            0x35A3B400, 0x3120D7B1, 0x44E83F02, 0x14165059, 0x2A07DB9A, 0x7F251127, 0xA36A8254, 0x2F94C0BB,
            0x07956A71, 0xC0EB11D2, 0x212AE211, 0x84126E58, 0xB9254A81, 0xC8D730DB, 0xF96A10EA, 0xE4D35EE6,
            0x31738E07, 0xB1C9E752, 0xA34DF7CC, 0x0CD6BE64, 0x2377F91B, 0xE48CED36, 0xA72E7029, 0x0CD803FD,
            0x1851B2DB, 0x5A07D594, 0xDFB2E7BE, 0x5099743C, 0xB327B084, 0x5D917C91, 0x30A8B973, 0x890B8D45,
            0x2222E7D8, 0x2B5205A3, 0xBC2D4DF8, 0x4D1EDA48, 0x5EAAB3CD, 0x1E0DD859, 0x71FF7471, 0xDDAC85BA,
            0x02D87A40, 0x837F4FFA, 0x3D82FFB1, 0x15A92286, 0xA0B594FA, 0x5ACE4D76, 0xFCC75D2C, 0xD64D248E,
            0x45CE2149, 0x8939F3A2, 0xDCCF0F69, 0xD1FEF3B7, 0xB5DBB729, 0x4AC23321, 0x4461BF26, 0x2FDB8818,
            0x6AE4E6F9, 0x0F6A18F5, 0x385F9463, 0xF4E2E7FC, 0x3FC03411, 0xB10EC796, 0xB5CDC6E5, 0x4D4F5C9F,
            0x7CB49DEB, 0x8FDBD134, 0x45300E7C, 0x745897C4, 0x29DEE5E8, 0xBB02C858, 0x576ED524, 0x5F2E9A77,
            0xDB317F44, 0x2D259EF5, 0xA2A03C04, 0x7A3B57E3, 0xA841D4D1, 0x39C18D54, 0x1FAC63C1, 0xE5BE0856,
            0xA632C78B, 0x46924FB1, 0x0AE3DAA6, 0x038A7B86, 0xDBB8B663, 0x4E995F1D, 0x9A498724, 0xFB406AED,
            0xA14832A4, 0x414B4D4C, 0x0866BFE2, 0x4189F9B8, 0x41B5ABAA, 0x39D2BD31, 0x3C895057, 0x9A1F5443,
            0x21B9F834, 0xF8D120E1, 0xDFDA1DA7, 0x16D518AE, 0x3D74EE34, 0xAF138D7F, 0xE9EABADF, 0x0362CAC2,
            0x0EB234F1, 0x2DC17AA3, 0xAC013132, 0x5A6B6EE8, 0xA99913DD, 0x400A501E, 0x27A8EBA7, 0x546D1553,
            0xC23CA874, 0xAC4DD25A, 0x7D183779, 0xBF615E48, 0x22E6CC3F, 0xFB025C5A, 0x332B03E6, 0xCBF61E0E,
            0x509C7769, 0xFB10F1D2, 0xE1896A96, 0x1CD4DE1B, 0x86319451, 0xB8E66B63, 0x6F79FF5D, 0x4C13AB90,
            0xD3743A59, 0x9BD42A1D, 0xB8662CD7, 0xB833834B, 0xDA1D2F96, 0x390D7615, 0x6ED9EB4D, 0xB0B448EF,
            0x68E15E0B, 0xC8A7FC8F, 0xB093B282, 0x24E5168C, 0x09649AB8, 0x29571479, 0x03045D71, 0xD023E5BE,
            0x9F41E02B, 0x307A6A3B, 0x664CB4BE, 0x55905829, 0x06DE5360, 0x6E5594FD, 0xEE9A2476, 0x72FCEC9D,
            0xDE72164F, 0x7B595094, 0x6DF4D21B, 0x5BEDD83E, 0x390AC58C, 0x4DEF2E7B, 0x9409B646, 0xE932FB25,
            0x5E308F90, 0x8E90A876, 0xA932776E, 0xE5A260D1, 0x74597E33, 0x5FDDF155, 0x957881A4, 0x5E3CEE46,
            0x6F664BB4, 0x6A882529, 0xAE7CC75F, 0x267D58B0, 0x23D0E606, 0x453BE8EA, 0x402E5E19, 0x9C209D87,
            0x19C74EAA, 0x9B88859F, 0xF98E51CA, 0xDE188409, 0xBF4293C7, 0x7DA9C102, 0x60D3B633, 0xB65E8446,
            0xDB6F5E62, 0x9185D150, 0xCF5CC983, 0xDD40119E, 0xA2846122, 0x1CD5E656, 0xCEF189DA, 0x8025E3DC,
            0xC3FDEA47, 0xE34881F5, 0x4795E752, 0xC935119C, 0x4F28EF50, 0xFC47F04F, 0x91EBF2A6, 0x925E6C4C,
            0x596519AB, 0x3085725A, 0x01D744C1, 0x1AD5C40A, 0x14246F77, 0x32F243E1, 0x34E2A607, 0xF22FE67C,
            0xE2B96EC2, 0x787F8249, 0x519FBA92, 0x60555CDF, 0x9F06C0E7, 0x9F3DCF10, 0x1A4D91E1, 0x939C8990,
            0x559D10CE, 0x45CD19A4, 0xCB11C4E7, 0xA00A7D40, 0xC40ECDA5, 0xD276F23C, 0x4328DE54, 0xB3A9F28A,
            0x783C1E1E, 0x2594207E, 0x70D37D4C, 0x7DAC4107, 0x40FBE89C, 0x144BE0F8, 0x8BD692EB, 0x807C86FA,
            0x1BB33194, 0xB1354F59, 0x6F7B13BE, 0xCA497733, 0x73AD3CE4, 0x86C6D41B, 0xDD253741, 0x6061ED11,
            0xAEA96409, 0xEF99A76D, 0x2C1AC38E, 0x5D7DBFDF, 0x2ED5D56A, 0x2EF1044A, 0xECC75113, 0x7E4DFCB1,
            0xB9C8B4FC, 0xF22CE0B8, 0xA7C65F8E, 0x1E4C556E, 0x6F9AB351, 0x687792EB, 0xBEE4E257, 0x91582FDE,
            0xA91CCEB0, 0x38E01A0E, 0x0D8BFE4B, 0x34B2B665, 0xA102584E, 0x73633AFB, 0x74DC28E3, 0x83A575BA,
            0x94209791, 0x8FA044DB, 0x63E02A9B, 0xC7833721, 0x569A7C33, 0x134B5E69, 0x5EC3C58D, 0x5FC9DEE4,
            0x6B3E4785, 0xF2641349, 0xA333FD90, 0xEA9EBE20, 0xE5D77C71, 0xF6951A15, 0x5BF4775C, 0x4643EFF5,
            0x23265BD4, 0xA752CF26, 0xFEA4E619, 0xE20C8C13, 0x7AC2A1D6, 0x63472704, 0x69266386, 0x18A04F37,
            0xF414E530, 0x1C40A071, 0x1F336F66, 0xB9CC0F8B, 0x53ED9C77, 0x65BCB141, 0xA31311E9, 0xAE3C2995,
            0x72C4AC5A, 0x5391C928, 0x07D57B54, 0x65D8F044, 0x9759F814, 0x543ACFFC, 0x26DE81F1, 0x72542CB4,
            0x41DCFEA9, 0x722C1D24, 0x85ECEC77, 0xEBC52CF6, 0x8C3A98B5, 0x3B3A5E17, 0xF8AB59EF, 0xB7CC0EF0,
            0x2B4C20EC, 0x85915959, 0xC4A3A05A, 0xFC307FE4, 0xCBCCCD07, 0xA946CE10, 0x2DBD0869, 0x7CADFA7A,
            0x39D11F5D, 0xBAE1DDA3, 0x9E5B0902, 0x91683B26, 0x4566F16D, 0x2924F2E8, 0x8CDD6FE4, 0x0CD16A86,
            0x33053302, 0xEFCC1F34, 0xAE747D41, 0xC7F555F2, 0x338BBEC4, 0x17D7AEE7, 0xD7DB627E, 0x3B689EE0,
            0x341F78E9, 0xA2F93CBA, 0x4334631F, 0x2C2AEE01, 0x05ABD4C3, 0x2EAA3FA5, 0x3B6B7032, 0x716AA6F6,
            0x0D9540E6, 0x4CF32A14, 0xA878EA70, 0xE8EC8B43, 0x2E999BD5, 0xB45130EE, 0xF60A6E6B, 0xC6D424A2,
            0x280241FC, 0x5D00B015, 0xE68C8B35, 0xF92B779E, 0x940D3654, 0xBD68D974, 0x45912430, 0x1119CA71,
            0x99F1680F, 0x34D1229A, 0x2DCAB778, 0x8780B52B, 0xC61EC8EA, 0x78CDE90D, 0x36D3C3B2, 0x2BD5DCC2,
            0x7FFFE5D9, 0xC7B2B7CD, 0x1C9A6EC9, 0x941995E4, 0xD6D0A907, 0x3F9BC439, 0xAE5EF17E, 0x0D6A554A,
            0x4CA22CE7, 0xDBC0B7E9, 0x94BAD1E7, 0xA3E5D7A4, 0x6E4BDE54, 0x4A20673E, 0x137937C0, 0xD14C5AD5,
            0x5368D820, 0x9F37BA60, 0x3121C312, 0xEF738394, 0x03B746EA, 0x813C4811, 0x38BAABCE, 0x312FD117,
            0x0B257BEF, 0x0D9B58A9, 0x1386821D, 0x27B07EDB, 0xFBB0BA7B, 0x456EB939, 0xF5EA16DE, 0x2FC64EF2,
            0xDABE2374, 0x4A88635A, 0x102CB9B5, 0x58CA124D, 0x74C7B6AC, 0x38877A2D, 0x5CF089AD, 0x65A73A2E,
            0x8B2F0417, 0xAA44904B, 0xFE5BFB29, 0x29CF372F, 0x9E85C382, 0x8BD26D8B, 0x3B485603, 0x730F3E8A,
            0xE4E8B315, 0x0A20EF81, 0x8B5483AC, 0xBEC17517, 0x6CE28DAC, 0x9C11A52A, 0x386691FC, 0x5E676E01,
            0xC6F5CB7D, 0x5C0A1B1D, 0x68847EF2, 0x6377F784, 0xF75A819B, 0x79C5BCFB, 0x8F0BD44C, 0x452324B1,
            0x37B40ED9, 0x89029217, 0xC9D28F71, 0xE62BCD3C, 0x76A45656, 0x2B6AE094, 0x4A2AB3B0, 0xDA826506,
            0x6C3E824B, 0x1A42A206, 0x6B492A58, 0xE8C9EA56, 0x194684D1, 0xEECA2A9D, 0xC3624514, 0xEBD40E07,
            0x2712E0DF, 0xD015C41E, 0xBAB2F2A6, 0x6F5F5288, 0xDE0A929C, 0xFBF8FD3E, 0x37E79B28, 0xC69527A0,
            0xCED2F40E, 0x5244B254, 0x777B1E7D, 0x0A0E2DE2, 0xD5C52601, 0x2A60C1F3, 0xE78F66BB, 0x901F92F8,
            0x217D2D74, 0xCF7D2014, 0x27C3329F, 0xD0BE9445, 0xF5B03B34, 0x9836EC90, 0x0E290606, 0x29D9E398,
            0x36DBF1CC, 0x05AB5846, 0xFA1AACCC, 0x1C4095DF, 0xEAEBF302, 0x213F5456, 0x4C0925B3, 0x8139DA3C,
            0xCC958D9E, 0xDA9F54E8, 0x9035C715, 0xFFA0961A, 0x37963EAC, 0x24EE0B35, 0x97D5DB23, 0xDA1CD0BC,
            0x9ED3399B, 0xC0CE31C4, 0x06EDE864, 0xB8F2529A, 0x539193FD, 0x0F170D49, 0xC2E7AB78, 0x624D8E34,
            0xB3A5FDCB, 0x5925648D, 0x38B1145E, 0xF8E5C149, 0xA90A7252, 0x033F8A6A, 0xC84749A5, 0x8A622B19,
            0xA65D1B0C, 0x61ED3407, 0x5693B18A, 0x712876CF, 0x101B054F, 0x379ED999, 0x83ECDB38, 0xA70BC807,
            0x1DAC89D3, 0x2E0D5F93, 0x03137CFF, 0xD04F5432, 0x7A289F0C, 0xC8485A63, 0xB3D7EDEA, 0x7862E6FA,
            0xB96791F7, 0xF13A4A4F, 0x348779ED, 0xD13AFC7B, 0x83CEF970, 0x85AEC1BF, 0xE486FC81, 0x0821D31B,
            0xD137B3AF, 0x4B33D779, 0xDCE83C56, 0xE53DC970, 0xBA41BC72, 0xD2C9BE2C, 0x74222465, 0xFFF94552,
            0x12B7250F, 0xE77C269C, 0xAD0252C8, 0x477A632D, 0x4F0537E3, 0x0D739535, 0x40B7A46B, 0xBE67B5B4,
            0x6A65CE75, 0x9AD0A199, 0x6BAD81FA, 0x01E99541, 0x031D8240, 0xDD46D03C, 0x71F5E31D, 0xEC91D12C,
            0xFDFEC078, 0xC9BEB246, 0xC49C690E, 0x6AC80865, 0x89F0F6BE, 0x12C4AAF7, 0xC11717BD, 0xC9D1E6F7,
            0x0438E2AD, 0xE7FE25B5, 0x1678B321, 0x48A44A21, 0xF37DBC31, 0xA522A621, 0x2AEE4799, 0x55CACA84,
            0x45243700, 0x81546A31, 0xB35BA166, 0xE20C6844, 0xA38961D1, 0xCB8E9EE0, 0xAF9D0D65, 0x0C298D6D,
            0x43E79F14, 0xC38BAEAA, 0x16C9F232, 0xCE100382, 0x5900C943, 0x64305426, 0x1761D197, 0x146AA737,
            0xDE018D37, 0x33A979C9, 0xC598A24D, 0xB5E3E8F7, 0xCD52B06F, 0x7F8AB5A5, 0x7FD612E0, 0x948CEE14,
            0x2980A943, 0x0EFBC270, 0x7C0F9ABB, 0x60B114CE, 0x0AE8CE21, 0x41940C91, 0x0B8EF990, 0xFA738CCE,
            0xFAA96085, 0xAEC58D0E, 0x6793D2D7, 0x277B4119, 0xD3A96461, 0x02F6BEFB, 0xBD016940, 0x5D9BE5E2,
            0xB09AF047, 0x270A4004, 0xAA8DE56B, 0xD6CE81D5, 0x911695ED, 0x7206A400, 0x0B3CEE9B, 0xDD4F3039,
            0x8C0E81C8, 0x62F559A3, 0x37F914BA, 0xF1BE416D, 0xF812AB00, 0xEBE351F4, 0x030C3DA8, 0x7C94A89C,
            0x0E57E77A, 0x104E3B73, 0x37CF2837, 0x5E2EE3E5, 0x4AFFFF90, 0xC91990C2, 0x510F9385, 0x4336AB2A,
            0x6C93CD2C, 0x1DE7DCD9, 0x51A96F31, 0x3BFA6B2F, 0x7C9A81BF, 0x2F8E8F56, 0xAEED9F31, 0x4300FCC6,
            0xF873FC3B, 0x921129D4, 0x680AE3E8, 0xFB70E1DA, 0x9EA53050, 0xDDA9299D, 0x6376AD52, 0x0A3011B5,
            0x3294B815, 0x4EF5D3EF, 0x79985C4E, 0x70208F22, 0x5AAC76AD, 0xBBFEE574, 0x8AC20B16, 0x22C6AD3D,
            0x710629A7, 0x346BD919, 0x9B867449, 0xFE2A241C, 0x2DB00E02, 0x00BE4098, 0xFF857844, 0xC238760D,
            0xD31DD063, 0x305CAF65, 0xE89B23E0, 0x96A1B9EB, 0xB09D7324, 0xE322C7A4, 0x11ACC4BE, 0x72BDCE06,
            0x84AFC071, 0x30BB9D17, 0xBC9D3232, 0xF58B7D82, 0xE3F1A0EB, 0xA4F79060, 0xAC198317, 0xBC869653,
            0x96E5CC45, 0xADD564D9, 0x940D628D, 0xE221E207, 0xE3138878, 0xBCE9C5AB, 0x334D218B, 0x6647BE2A,
            0x4466D713, 0x40496EFC, 0x476BCB10, 0x663F692E, 0x6C0F2118, 0x0022A0FF, 0x103587EA, 0x58F04C42,
            0xC6CC63F3, 0x526BA9D2, 0xFEE61597, 0x4B86A909, 0xC89DDB6C, 0xB52F9896, 0xDC57DE32, 0xE44F73AB,
            0xF7A06D09, 0xFC984368, 0x85119DDE, 0x1BD250E5, 0x75A0C69B, 0x9D29FFBE, 0xE996A8D1, 0x70927C94,
            0xA5C88F9A, 0x81709A73, 0xB423C035, 0x3EA1CA7F, 0xFA2C0062, 0x4CC82F72, 0x9F185444, 0x46379FC0,
            0x0CAC7924, 0x35D3F254, 0x8D312224, 0xF9729F72, 0x25102FCA, 0x818C98C7, 0x5F21EE5A, 0xD036D18B,
            0x382E695E, 0x036BD34F, 0xB1B396BC, 0x905E52AB, 0x45D4DB9D, 0x39DEB708, 0x86F929E0, 0x7F9ADC6B,
            0x4805FE8F, 0xFC6B3259, 0xD785C051, 0x490EF1A0, 0x7A164DF0, 0xDCC1D44A, 0x45A97E7A, 0x21E5591C,
            0xA35BC80A, 0x163C7EA9, 0xD6C4808A, 0x3EB1F224, 0x3A5525DC, 0xD5FA5232, 0xEDFA2C8F, 0x6A043021,
            0x1291D104, 0x689D09FC, 0x53F0A6F6, 0x6A36BB51, 0x83C1301E, 0xAF76816D, 0x2D444139, 0x37EC43D4,
            0xF54C8540, 0x2116DE1C, 0xEB8853CF, 0xC6A01870, 0x6CDDAD4A, 0x77C21E48, 0xECB11A7E, 0xC8F80BF1,
            0x001E0395, 0x0775D60B, 0x44BA434C, 0x2927092A, 0x4F49BFF9, 0x5F59558D, 0x9501B26C, 0xE017B5E4,
            0x0878E7C3, 0x770B8646, 0xA27BEB85, 0x684C0B69, 0xE8D21630, 0x73355228, 0x8D53F8ED, 0x39AB3CDD,
            0x13278F62, 0x27A498DE, 0xE6507875, 0x6E14EFFA, 0xCDC90324, 0x02EF3483, 0xD139012E, 0x4045D320,
            0xB25EB037, 0x2A46CDF1, 0x334C3838, 0x8828415B, 0x1F6E9456, 0x22EAD341, 0xCBA2E086, 0xAC51A751,
            0x1830702C, 0x30C76BF2, 0x6C2E2B91, 0x8DBBEB2E, 0xCFCB2F1B, 0x998E2493, 0x142CC770, 0x2EEA81DB,
            0x5E384A8D, 0xA7D91256, 0x1FE01304, 0x512E9661, 0x538B0191, 0xB92194F1, 0x99565D33, 0xB62C7505,
            0x67F5E7E3, 0xB2D026E8, 0x72652E5D, 0xD2BABBFD, 0xE282981B, 0xEA8BDB1F, 0x362EA8D0, 0x9D8B5D6F,
            0x3F52093D, 0x3DFA2455, 0xA5E84047, 0x92E7BE30, 0x3A6ADE48, 0x9AE2CFB8, 0xDCB43D9E, 0x174A6544,
            0x940AB526, 0x81B5B10C, 0xC9527E40, 0x60B79AF6, 0xA3345172, 0xACE99320, 0x027E1129, 0xC7582EDB,
            0xEE618FB2, 0x894EFBFB, 0x0F2D2AF4, 0x8A7ADF2E, 0x2F3CDE2D, 0xB0F4903B, 0x2A17176A, 0xF55362CD,
            0xF505693E, 0xBCE5463F, 0xBD81F019, 0x6B6F8E8F, 0x5BB7DAF6, 0x60C09905, 0xD8D82557, 0x485CBD5C,
            0xA3205854, 0x0DE9657A, 0xFC406FF0, 0xFD48C6E9, 0x20E3F2B1, 0xCE9AC6AB, 0x99FCA94F, 0xD6E4C124,
            0x0D5F4CD0, 0xEC89CAB3, 0xD0DB5C6D, 0xB6E5E334, 0x956C1E46, 0x943010AF, 0x5F862396, 0xE36D3B24,
            0x673F517B, 0xBBAB0D75, 0xA20DF2B5, 0x4518BD03, 0x1E6D3557, 0x6606FF4C, 0xCC2DC5F4, 0x6E78838B,
            0x8E3A4D85, 0xAF219B39, 0xBD43D15C, 0x2F9F7F9C, 0x4C2593F8, 0xEFA2EAF9, 0xCC161510, 0x01FA6996,
            0x58E11516, 0x09330E51, 0xAF6F6C2C, 0xE99FE9BB, 0x898B5530, 0xE97B0E5F, 0xFBE9CF71, 0x6B1CBD74,
            0xFBDAD970, 0x1B583D29, 0x6B339708, 0xF91875F2, 0xC3F651F3, 0xFE9F8FFF, 0xA7A7F285, 0x525A62EC,
            0xBA5EE1CD, 0xB54D4C58, 0x0CE616D8, 0x6C2D0EB9, 0x8709EE56, 0x40EA3DBF, 0xC384D98C, 0x402A67A3,
            0x7CC25472, 0xC3E1A882, 0xE98B982D, 0x2C59CFC0, 0x879ED10B, 0x0C4B0649, 0x3C88E7B6, 0xC1731949,
            0x6D7E22E9, 0x0666500B, 0xC6174E9E, 0x1999C217, 0x63509AA6, 0x5323F6CA, 0xC69D6DF2, 0xE074AB35,
            0x90148364, 0xE7CDE353, 0x0780C6CC, 0x43F1B870, 0x50CBA5B3, 0xD4BF033C, 0x10F18A5D, 0xE53A7440,
            0xB88ADA53, 0x28DD9BD4, 0x6D2D6BE8, 0x89F0131B, 0x348BDE2A, 0x7EC93DD8, 0x56961BD1, 0x04405BC1,
            0x768810B8, 0x0A653C03, 0xA68F9718, 0xDF58D785, 0x1023F4DC, 0x1DCC79F3, 0x1101D59F, 0xB8822DA2,
            0x2CD0A253, 0xA7804019, 0xB5174D34, 0x6E5BB39B, 0x3EB46D7B, 0xEA242736, 0x0BE315F6, 0x6C6D75A3,
            0x9E206029, 0xD5C6A28A, 0x04108CA2, 0x13786ECD, 0x73EB96EC, 0xCA46F3D0, 0x108FC6B7, 0xF061F70C,
            0x9093369B, 0xCEA6C040, 0xCD693061, 0x256774C4, 0x63EDBB4F, 0x7A9C4124, 0x33017C24, 0xD147A8B8,
            0x7D07A224, 0x5B7FE642, 0x9A017CCD, 0xCD027615, 0xD851582E, 0xD985F760, 0x97B41188, 0xE7585666,
            0x9FFBC81D, 0xA106E606, 0x3FBF6289, 0xA760A2DA, 0x731FC9E7, 0xFA22BE49, 0x96348149, 0x9075C807,
            0x2E5AB70B, 0x86509F4D, 0x16ECF724, 0x3921E34A, 0xEB921FF7, 0xCC5E6BB7, 0x12B926C9, 0x88FA9EE6,
            0x6FAAFF86, 0xF8429382, 0x20F07ED8, 0x762AE52C, 0xAD1F9C0B, 0x03FF81BB, 0x58522A2C, 0xADDA7B1A,
            0x8B32293C, 0x1B66C29C, 0x217B1B63, 0xB9B79FB5, 0xC7476F4F, 0x47123C70, 0x354BEBF9, 0x0716B3EB,
            0xB19463AF, 0x0806F57B, 0x3F8DBEF3, 0x81E87AAC, 0x4C4DACEE, 0xC137FAFB, 0x4C08ACAB, 0xDAF69E1D,
            0x65623E5A, 0x19BE0E43, 0xB23353CB, 0x00179802, 0x39761232, 0xED0299D5, 0x5BFE75A7, 0x07D48B51,
            0xF0CBFE57, 0x0C16A0DE, 0xD9B1C515, 0x02D3E67D, 0xB6F67B7B, 0x53161CC7, 0xB7A8E2B1, 0xADD238A3,
            0x9648EA3D, 0x44905131, 0x675ABDD6, 0xCF769B6A, 0xCE8F40E4, 0x068868B6, 0xBD69CBD4, 0x52BA0E8A,
            0x4DED7885, 0x505AF2A6, 0x4A71C453, 0x9C165A6B, 0x17F641D6, 0x25FF16AE, 0xFD1A04AB, 0x552AAF6D,
            0xF2F40D23, 0xD4F4C016, 0x06758641, 0x4B268C01, 0x87723D5B, 0x13BAE010, 0x2D869A89, 0x0AA39DFC,
            0x34B49E44, 0x10E0FBEF, 0x1FEA086F, 0x8B689977, 0x4208A773, 0x46484261, 0xC5D2C345, 0x4469722E,
            0x50A523B5, 0x1CA7714A, 0xEF93A28D, 0xC2B14D13, 0x57472C66, 0x31F8DD31, 0xE50F263D, 0xD1A59963,
            0xB253009F, 0xC04AA63E, 0x9081787C, 0xAC8FA8ED, 0x53CE13A4, 0x60464AF5, 0x570FC6A3, 0x23A4986E,
            0xC3D86714, 0x3818FC1D, 0x27EFC895, 0x44E3353D, 0x366779FC, 0x9BB05F8A, 0xAED2A213, 0x864EA238,
            0x2D5DB65E, 0xB23BD90F, 0x4B9AA80A, 0xC37946E9, 0x87128B96, 0xEF9432AD, 0xFB687D31, 0x548CF02F,
            0xFC6264F0, 0x533F1BC6, 0xC91D4C47, 0x97C75561, 0x1E04F1FB, 0xE30170F7, 0xF2CB50D7, 0x0B1F0305,
            0xB4B54E2C, 0x6531D414, 0x2824BBF3, 0x802AA6EF, 0x0A573602, 0x7F53847F, 0x04B81B1E, 0x82B0015B,
            0x48259BD1, 0xC718BB6E, 0x19B59465, 0x26BBD630, 0x4DC944A5, 0x38165524, 0x321D16D5, 0x8594ACAB,
            0x34CE7D21, 0x6F9B6311, 0x97BC56D6, 0xBBBF1C2B, 0xC7C5B9B2, 0xC9F71189, 0xBAD939A6, 0x314905CD,
            0x44A29336, 0x493BCC31, 0x1F175D90, 0x6F4A8142, 0x5DC0396C, 0xA64CCCCE, 0xF1097047, 0x90DCB980,
            0x7EDC6026, 0x85F0CDF9, 0x4EAA768D, 0x9C4307E6, 0x626AA0E2, 0x731EBDD7, 0x89640D46, 0xD8E0E4E1,
            0xC585BFB4, 0x8CB57C80, 0x00252E0C, 0x1B6AD9D0, 0xC7C19A15, 0xD8E6263F, 0x890B82AD, 0x7E42CB61,
            0x70889406, 0x6B2C49DE, 0xCEE09387, 0x7E8D7BEF, 0x529DDCC9, 0xB234DAB5, 0x03E6D5B0, 0xCC1C08C2,
            0x92501DBD, 0x7952A9AD, 0xC323568A, 0x8A44C726, 0x16C8D974, 0xA4CEB509, 0x29CB3AFA, 0xF138D8D1,
            0x350360CC, 0x7BC62C16, 0xDB06908A, 0x1ED3F125, 0x71770BF7, 0x4806A18E, 0x96148E92, 0xCD6117CD,
            0x7C2E6E8D, 0x2B954281, 0x24C32675, 0x42313FB0, 0x54D0E422, 0x3BBA0A7B, 0x8C6EEB50, 0x8AF490EC,
            0xAB6C0246, 0x57E20316, 0x511248FD, 0x1AC6A8D3, 0x650945F1, 0xAE1A906E, 0x82F6E4D9, 0xC5459922,
            0xBA89F7D5, 0xC9CCE53E, 0x0D94B163, 0xB9AABDC1, 0xD417F192, 0x50D4DFA8, 0x165357C7, 0x74B9BE23,
            0xA399BA59, 0x66EFB211, 0x853EB8B7, 0xE10EB93A, 0x366342C9, 0x2B45435A, 0x44E8F9AF, 0xEED97476,
            0xC4612520, 0x7595BEBA, 0xB1806CF9, 0x2B76205E, 0x3E3AD80E, 0x51743521, 0x5C5519F2, 0x0A14C683,
            0x37C2E159, 0x0126D38E, 0x95DED09C, 0xD95C65BA, 0xE8450DB7, 0x3DB9CC38, 0xF0C30BB8, 0x357C3EB1,
            0x87391230, 0x2ACA7D58, 0x1BA6CA80, 0xE2A03A3F, 0x7F14D822, 0xF1926652, 0x6853E961, 0x2D0E5F1B,
            0xA8BED13D, 0x5CAF4093, 0x3DF48055, 0xDE75FE95, 0xB942CD95, 0x08BC528E, 0x0A5B9345, 0xB91BB668,
            0x1137661A, 0x5BA76AC5, 0x08D2AEB4, 0x20997580, 0xDEE65F73, 0x8EC24F4A, 0xFAF94CA2, 0x5766D8A1,
            0x42A2C75A, 0x0FDEB7C8, 0x638E2C43, 0x6C301EB0, 0x4D4D2538, 0xB49F34C2, 0x94FD8D61, 0xA5C1A785,
            0xC602EAF5, 0xD5D80ED5, 0xF77D5262, 0x2E2850EA, 0xA6B0C6BB, 0xC2A9BC6F, 0x370BEF2D, 0xB18F6C3B,
            0x8C4849E5, 0x69991204, 0x98A2D62C, 0x9E240CD1, 0xEF2CAD8E, 0x11098A79, 0xF9832731, 0xE381A1F3,
            0x703E0846, 0x9B70EE87, 0x17502033, 0x3C32F818, 0xD1A25129, 0xAFD0FC03, 0xBB3E592D, 0xDCE203EB,
            0x9B8E9D9D, 0xDEE5A5B7, 0x70EE0F56, 0x64F3A953, 0xE5E86989, 0xF0F88E2E, 0x7C67B1D5, 0x495670BE,
            0xDE0AFDF1, 0x4BD54E26, 0xBD61029B, 0x9317E697, 0x31556452, 0xDD7A6EFC, 0x3C1659CA, 0x890FC59D,
            0x6831ED0F, 0xDB9C8042, 0x90C0120D, 0x23D6BD4F, 0xB8D7E21F, 0x0CCDA457, 0x232A42E0, 0xAB90748E,
            0x041F804A, 0x84E8D49C, 0x4FFEBC32, 0xC96F8144, 0xE6C24602, 0x0741D9D4, 0x0AC41789, 0x2CCF8E97,
            0x24B74DDF, 0x91041027, 0xAB0744B8, 0x86A8CD03, 0xF5D9BBE6, 0x787E3FAC, 0xFEBC5CFC, 0x097DFE3B,
            0x168EA940, 0x18B7160F, 0xBF6D0024, 0xCEF3DCB8, 0x3E090CD4, 0x58920373, 0x7D15B73E, 0x6CCEB15C,
            0x30A5EBDE, 0x77B42D35, 0x88476816, 0x8CE065B1, 0xA20D5932, 0x46F05F88, 0x5F2F9CD8, 0x4415550D,
            0x68B995AF, 0xF94E4577, 0x031323B0, 0x1C01CE2F, 0x22162B09, 0xB43F0A4A, 0x1CA7ABFC, 0xC77D7084,
            0x3E375372, 0x24D16BB3, 0x6B4819F6, 0x30DB5071, 0xA921E166, 0x557FFFD8, 0x022C8D01, 0xCC0A02A4,
            0x8C88322D, 0x64945F40, 0xE39B7FB7, 0xE75155CB, 0x4F6DA2D0, 0xCB5B440C, 0xCC4DD3FD, 0x5B2CB041,
            0x7607BCA2, 0x13B570A0, 0x1FF225EC, 0x5E925930, 0xFD9422B3, 0xE629046C, 0x923311CD, 0x9C72952E,
            0x3A192134, 0xC805B997, 0x2C54F1E1, 0xCD7C0A5F, 0x73A66FED, 0x663F7A3C, 0x30A5921B, 0x702740EC,
            0x42866386, 0xBC496466, 0xB812D435, 0xB04BA2B1, 0xF428EC31, 0x7F41DBD3, 0x6E626B3F, 0x31D8604F,
            0x332D3A17, 0xFBFCBC74, 0x99357DC8, 0xE9C71482, 0xE7E34F0D, 0x9B136800, 0x44386941, 0x8D68472E,
            0x0FDC09F7, 0x778C719F, 0xC02E1504, 0xF0306948, 0x3B0091AC, 0xBFF270BC, 0xD973F757, 0xEF51A54E,
            0x209E8CF8, 0x5BFCC3AC, 0xF8B23410, 0x4C97A984, 0x41A947FA, 0xB28859A6, 0x741F719E, 0xDB72E454,
            0xAA1C6705, 0x12DBFB41, 0x777C4570, 0x6FB14388, 0x9946F131, 0xC2D7C18D, 0x27FB3E95, 0x383A8F74,
            0x400F634B, 0x838C376E, 0x0DAD11BA, 0x558C50DE, 0xC5EDD73D, 0xD7EE0235, 0x4F799854, 0x7908580A,
            0x2E7A99C7, 0x54FF968C, 0x7F6660B7, 0xF8748765, 0xC45F2A61, 0x246FF673, 0xA3C1F925, 0x3B2C7075,
            0x10ED1AAC, 0x03D38578, 0xDFC1CE3E, 0xD078AF6B, 0xB71D2B14, 0x776EEA95, 0x585A4DAA, 0xF4BF5CBD,
            0x81F928BB, 0xC60E5F8E, 0x7B9CEF49, 0x7B6F4CBE, 0x61232AEE, 0xB65D349E, 0xADE659FD, 0x4AFACC3D,
            0xCD7DA9E8, 0x568BF838, 0x850B503B, 0x1F77F7E7, 0xAB14DAAC, 0x749ED3ED, 0xE574AFA6, 0x1C25B068,
            0x654D4FCF, 0x82A5CEF7, 0xBB25FC72, 0x2E1AD718, 0x4248BD6A, 0xB5DE6F13, 0x840F169D, 0x3BE823CF,
            0x912A3EE6, 0x70D9A2A2, 0x937D72D2, 0xF80EC606, 0x59AA4A5B, 0x0BF363FE, 0x275AFC98, 0x6E38082E,
            0x6EA282A0, 0xA358D639, 0x5EDE02C3, 0xE6F703A6, 0x7C249DF0, 0xB3ECEDD8, 0x792F1A69, 0xC55D9D92,
            0xA0794664, 0x21647C34, 0xD6A4858F, 0x2EB927A5, 0xFEF4471A, 0x7B8D4EF6, 0x5753E6F6, 0x97EDD533,
            0x06347C86, 0x6C81981E, 0x7962A994, 0xF53D9B0B, 0x30F8542B, 0xA57DA16B, 0x7EBDD515, 0x4DF6EAE7,
            0xEC4867F9, 0x1707A996, 0xF79EC3FD, 0x7C4A13A6, 0xEB0EE4E9, 0x7711B422, 0x42206375, 0x0CA40B18,
            0xE444F026, 0xCB83D263, 0x91CA1B76, 0x811942B4, 0xF5861895, 0x93BD300B, 0x7F4CCF05, 0x3F33CECF,
            0x6F9B73BB, 0xD236004D, 0xE29CEB36, 0x899D3B5F, 0x02D6D48E, 0x1DF07F76, 0xB05668F8, 0x7A13BEEB,
            0x52AAB955, 0x99294977, 0x586809C5, 0xBEE28ECE, 0xFE39BCFC, 0x040BF9A0, 0x0136303F, 0xD4BA4BC9,
            0x7ECD63FE, 0x8BEC9293, 0x0287459E, 0x72010496, 0x5D49B9BA, 0x57685764, 0x2D937335, 0xA3CF4CE3,
            0xB9FEC7A8, 0xB5C9A08A, 0xA2718445, 0x2685CA4B, 0x422A8E07, 0xA51EC80E, 0xD8DE9E1E, 0xE1764BF2,
            0x152D7B42, 0x5E396598, 0x01D2958A, 0x6971BA1F, 0x0873CB40, 0x3EEE1CE0, 0x1D010681, 0xCEAF80EC,
            0xCA7E59DF, 0x98123702, 0xF84376D3, 0x5B2A760E, 0xFF4E5CEB, 0xD368AAFD, 0xB70F24B1, 0xC07AD907,
            0x5B21D5AD, 0xED581A60, 0xEB9A6B6B, 0x718DE233, 0xCC783AF1, 0xD335CE6C, 0x4670DDE2, 0x22A72D58,
            0xC80FA46E, 0xA2632E92, 0x12D71477, 0x83C63EC3, 0xAB8E8C1E, 0xE86DD61B, 0xD17F8AD7, 0xC068EC9C,
            0x1816EB7C, 0x1F8A5FE8, 0x4BAC9E0D, 0x4092612B, 0xA4084955, 0x81B784A2, 0x361703B3, 0x339CE99A,
            0xE595B08B, 0x79D8DEE1, 0xCF2623AF, 0xA926B638, 0x051F8B44, 0x576EE8E4, 0x76A3D5DA, 0x466278B7,
            0xBF7A1A4E, 0x3D373F9C, 0x43D47B76, 0xBCCE6F4C, 0xB9E77C5D, 0x73ED26BC, 0xB06679F9, 0x4A35289B,
            0x2E9754FD, 0x704C1564, 0xEFEAD7E4, 0x88F973E9, 0xFB91DC8D, 0xA4241BAE, 0x3078FE15, 0x5296F56F,
            0x29509F32, 0xD8FE96C2, 0x5E5DCA69, 0xB6525790, 0x8D2A2F0F, 0xB9419BC3, 0x384CF29C, 0x7EFCF1CC,
            0xA65AD203, 0x8C924AE2, 0xC130B415, 0xEE68B13D, 0xA78530F2, 0x67474836, 0xB67A497B, 0xFF7CF144,
            0xA16E7047, 0x801C5500, 0xCDC36CA8, 0xBD076632, 0x03ACB96C, 0xA2CA2FF0, 0x7482D823, 0x3AD33952,
            0x959BC88E, 0xAA2EBEE7, 0xC90C6004, 0xAFC3CAF0, 0x54CBB0DB, 0x61F140F9, 0xFC42D327, 0x7AB5B790,
            0x953C4620, 0x08505B13, 0x15135F47, 0xEFF6F720, 0x956CD829, 0x2442F27A, 0x80011D3C, 0x4204BBD6,
            0x19CD3D1E, 0x597AA018, 0x6228AA24, 0xBD897847, 0x3FC657F6, 0xEA97C5FE, 0x5EB8B703, 0x40374330,
            0xD1DE1B7B, 0x1FB480AC, 0x25DB2E21, 0x380B826B, 0x61526363, 0xD8FEFE8B, 0x12340C08, 0x4724984B,
            0xC9B7F94A, 0x09D87E43, 0x3FE74D38, 0xDCF9576F, 0xD58B3377, 0x61BF9D64, 0x57CE4466, 0x048208B9,
            0xDB98DA14, 0xCD5A4E8C, 0x58417159, 0x9C72D3E0, 0x7CE9B4E6, 0x024C07DE, 0x091FB1FC, 0x3FAA5867,
            0xE10C3ADF, 0x3DA8E92E, 0x35EB9071, 0xCE2845B2, 0xE660CAB8, 0xF6C30ED6, 0x30E18AFA, 0x08C47B91,
            0x3D90C343, 0x32D86580, 0xE866CE09, 0x61532DFE, 0xF69C225C, 0xA3FD49C9, 0x19DB10A9, 0xA1551936,
            0xBC5C54A7, 0xABF2891E, 0x2AEEFC37, 0x255BE146, 0x7B430F9F, 0xA0BDDB29, 0x2913EE01, 0x0B924C84,
            0x56D5FB01, 0x524DA05A, 0x74807F34, 0x4AF17F00, 0x8762FC51, 0xD2DFFF24, 0x895062E9, 0xE3C2FD48,
            0xCED19B99, 0x1A2E230D, 0xD7F5A634, 0x12DEC9A2, 0x2A3CF1B8, 0x94D84121, 0x8C99A5AB, 0x7026AF09,
            0x796C26FA, 0xEAC0410F, 0x3F50014C, 0x5C3A0B14, 0x091A6B44, 0xD749ED6F, 0x6619B50B, 0x4D3DD3C9,
            0xF5D9E7D1, 0x01FF864B, 0x0456037D, 0xB9C37CA8, 0x0C4F2D47, 0x4F80945A, 0x8AEE2C19, 0x82FFDA72,
            0xCC2257CC, 0x4C3F37B4, 0x52343D60, 0xAFF7C8DE, 0x43F1B9BF, 0x1A47572A, 0xC46422F7, 0x68F1DF10,
            0x416FEF43, 0xC73A6123, 0xE80246A7, 0x1697DEE8, 0xB23DAD01, 0x592DBC7A, 0x9E778470, 0x55B07BCE,
            0xDE28FACD, 0xB114B65C, 0x18CBD5BC, 0x07F04DE4, 0x916F4B5D, 0x84F74FD6, 0xB0E2D3AD, 0x21587BD0,
            0xBA0CC240, 0xD194189F, 0x9D6F05A3, 0x34316545, 0x957138B5, 0xFDD7C038, 0xA7C45960, 0xAB3321AE,
            0x38241562, 0x1A36A0EF, 0x5D9A994D, 0xB225C140, 0x884E2274, 0x5C21E005, 0x07953D53, 0xD813280B,
            0x185D335A, 0xB4A38273, 0x92B7D65A, 0x20AEA0B2, 0xC4F78F28, 0x13EDB9B8, 0xFA7543CC, 0x170FA4CB,
            0xEF290585, 0x93C15E02, 0x138A9F27, 0x6549C21F, 0xD4F91458, 0xBF0D8DAF, 0x56A95CAD, 0x12E63A00,
            0xDA5B9588, 0xF6F8AB33, 0x9CD11C30, 0xB40CA417, 0x815306BB, 0xF71F5579, 0x584244A8, 0xC3101AC8,
            0x1394A7B7, 0x98530837, 0x27E700A1, 0x1922F2AA, 0x1126AF67, 0x896024EE, 0xC898D4E1, 0x0B56E9AB,
            0xB1C19E1C, 0xBD5085AE, 0x91710920, 0x37EAACC3, 0xD6644DE8, 0xBCA106AF, 0x367BCFE1, 0xA0E6FAFF,
            0x08009DE0, 0x96941210, 0x7548F52A, 0x77B36764, 0x0EE7F010, 0xFC9EFEDF, 0x47AC1F70, 0xEFBCEB41,
            0xB1611214, 0x2EF47100, 0x009FC316, 0x33655A04, 0x1136B335, 0x813D341D, 0x9E915D05, 0xAA90E26B,
            0x9E5CF339, 0x5CCBC6C7, 0xE463084E, 0x7467FF6E, 0x0C796783, 0x3D3F37B2, 0xD4072E76, 0x5CEAB894,
            0x3853DAFC, 0x753552D1, 0xEC5679AF, 0x7CE239AE, 0xCEC4D814, 0xDF1C8C48, 0x8C2B46BA, 0xB8928B6E,
            0x9F57BAB4, 0x90AE4D4C, 0x82995BB2, 0x7427F1A0, 0x77E98C65, 0x719E9511, 0x874816EB, 0x953EBD73,
            0x10BF9293, 0x9E88AA66, 0xA9257683, 0x2A3D2672, 0x7467A668, 0x70A689DF, 0xC6613F1A, 0x512ED019,
            0xE1DE1375, 0x4E4979BB, 0x78B2485F, 0xF20D1DF6, 0xAEF774BB, 0x44A26EC3, 0x31D3C9B4, 0x0AC6AEA8,
            0x01975C77, 0x82E5721C, 0xE5181187, 0x794CC836, 0xDD5D247F, 0xF6434122, 0x0305B099, 0x21452764,
            0x9D16DA62, 0xA72DC05E, 0x18EB39D4, 0x5C27FD33, 0xBB81BE9A, 0xEDA25EE6, 0x296AE505, 0x09D7EB55,
            0x44E5F940, 0x554A2A2B, 0x63862C21, 0x057881E4, 0x81AC97BC, 0xC1B3D7D2, 0xF3191101, 0xCF317906,
            0xE52BFACE, 0x117100C6, 0x20994FB9, 0x7F1B575A, 0x8D4A67B2, 0x59EA859D, 0xB0143211, 0x98D938CE,
            0xB04CF3D3, 0x6C702822, 0xF221015A, 0x8D662D5F, 0x84222BB4, 0x1886C29C, 0x875BA2CC, 0x6430BDC7,
            0x33ADBC80, 0xA078F51D, 0x89A3AD95, 0x3CCDBF1A, 0x52F089E2, 0x6989C0A5, 0x210D1423, 0xF75EC7D2,
            0x2004F5AC, 0x1F036F77, 0xF568ABE1, 0x2A7F2974, 0xB01D9991, 0x84C45981, 0xDC042E3A, 0xABB42E73,
            0x4D8663CB, 0xBD34FDBD, 0x2B05353A, 0x4A7C350C, 0xF25805A8, 0xF18DA956, 0x4FFC91D8, 0x68A8DA2F,
            0x38F41DB1, 0xE12532E7, 0x61668B39, 0x4A7CB81A, 0xE3F30C20, 0x72DA802D, 0x8FF45C9E, 0x8DCA5ED0,
            0xB5382888, 0x31AD593E, 0x835DCB88, 0xDFD22140, 0x863FA2FD, 0xC834BF26, 0xB1775490, 0x2842E578,
            0xD2DE7A6E, 0xB7AEF0F8, 0x6EE2D82B, 0xB465EC48, 0x2E7E9D0E, 0x71B76569, 0x9DD2C40C, 0xD6A160DB,
            0x52D5071A, 0x3288C325, 0x1071D65C, 0xA545E9BD, 0x45F31DF4, 0xF6272836, 0xC07474DC, 0x84E0D1F5,
            0xEAD6D26E, 0xB3CF2036, 0x6FF380EE, 0x0E639414, 0x5AE478F4, 0x343EB2AB, 0xD44B54C3, 0x52E5D3DE,
            0x270A997B, 0xEE7BACBC, 0xC06DB764, 0x77AD2230, 0x02E22135, 0x6A90C3AD, 0xD5060F5E, 0xFBA6619C,
            0x55EFF844, 0x5EC8949A, 0xF57548F8, 0xB95AAE48, 0x4EAC073B, 0x7B34911B, 0x177BE3C5, 0x65DA12C9,
            0x0C55C627, 0x046CCF4B, 0x72B667F0, 0xD62CD11C, 0xCAE25E72, 0x143405FC, 0x23ED7EA0, 0xCC4A71CA,
            0x0AA6E4C9, 0x96E8B717, 0xF747CF1C, 0x1AB667F5, 0x59BA3271, 0x57E650A0, 0x332A8182, 0xBD2BB927,
        };

        /// <summary>Length: 2580</summary>
        private static readonly uint[] s_linearMatrices_full = new uint[]
        {
            0x3612C131, 0xD8AED3B1, 0x277D91FA, 0x2B03E602, 0x00000080, 0xFEC70D84, 0x8EB79B0F, 0x19C1BCC5,
            0xAB769871, 0x00000000, 0x5E912E67, 0x9D8EC6C7, 0x5C4B1193, 0xC343AC97, 0x00000080, 0x195513D2,
            0xD2A63517, 0x15DDCE8F, 0x8E6F02DA, 0x00000000, 0x50A3341E, 0x844C4844, 0xAC38225E, 0xFD731498,
            0x00000080, 0xBE6F178E, 0x15ED941C, 0x9D9D4F1D, 0xA975E48F, 0x00000080, 0xE0AB8085, 0xBF2E417D,
            0x71D6B24C, 0x40A49439, 0x00000080, 0x0CD6B357, 0x6188FF4B, 0x9EC9802A, 0x4A8749B6, 0x00000000,
            0xE2E1DD05, 0xA5D2EA5D, 0xF86C3307, 0x3C5F547C, 0x00000080, 0xDF52EB66, 0x0BF61D1A, 0xBD1F0C6B,
            0xED6AEBD6, 0x00000080, 0x7C1DC245, 0x0CB77CA2, 0x49D64ECE, 0x449457D4, 0x00000000, 0xB1DE53C7,
            0x42C61EDA, 0x34BB95A8, 0x8C3AC9EC, 0x00000000, 0x4EFB89B6, 0x0027887F, 0x7F61AA9B, 0xC9E57A4B,
            0x00000000, 0xF80455B4, 0x232F9633, 0x66D7302A, 0xB52534EB, 0x00000000, 0x830324FF, 0xFE9553EE,
            0xE63B8D65, 0xD3B36DA7, 0x00000000, 0x0E70E70A, 0xF3E47AD6, 0xFD5EF337, 0x2A4A8C49, 0x00000000,
            0xE38D44B6, 0x24793841, 0x7D3630CC, 0x082B55EE, 0x00000080, 0xBDEAA767, 0x36F8AD69, 0xE54F1592,
            0xAD03B9A4, 0x00000080, 0xED24858B, 0xB64431CD, 0x07C2AC0D, 0x3EA1FF19, 0x00000080, 0x80DE3A6B,
            0xB434F841, 0xCD842B08, 0x990C1344, 0x00000000, 0xD240AFF1, 0xB442DCF9, 0xB4228C66, 0x90335F9B,
            0x00000080, 0x3456503C, 0xDCBBD948, 0x8AF3FB2A, 0xDC99208A, 0x00000000, 0x59AA20B3, 0x06CE13EF,
            0xAE6EE3BF, 0xD456620F, 0x00000000, 0x4670300C, 0x5B67868E, 0x6B346870, 0xDCDAD7A9, 0x00000000,
            0x744ADE6E, 0x30AAB4F2, 0x550B5322, 0xF417A3C7, 0x00000000, 0x63732D35, 0x728214E1, 0x24247A5D,
            0x64C1A714, 0x00000080, 0x8B8A6F2D, 0x87B75029, 0x8053A31A, 0x2DF09ECA, 0x00000080, 0x990C81AC,
            0xBAD3BC1B, 0xEAF099B4, 0x3294841D, 0x00000080, 0xA5544F78, 0xC09E6721, 0xFF4076C1, 0xB550DA0C,
            0x00000080, 0xFD5600A5, 0xED411254, 0xAD76AEA2, 0x11462CA1, 0x00000080, 0x8663D97C, 0xFB03F555,
            0x61627B9C, 0x3829F87E, 0x00000080, 0x8A0DECBB, 0xCB9E35B1, 0xD225D482, 0x9A695F4C, 0x00000080,
            0x68BD7108, 0x46EB21D4, 0x89A6DE49, 0xBFBBFF52, 0x00000000, 0x722929F6, 0xB3F20267, 0x71AC76E0,
            0xFC167CC9, 0x00000080, 0x66B18B62, 0xC30D52D9, 0x1D516E7D, 0x1E76236F, 0x00000000, 0xE3E584DE,
            0x3654B54D, 0xB75AEA3C, 0xDF2E6303, 0x00000080, 0x6F7A9623, 0x43856882, 0xCE716EB2, 0x4F64C53A,
            0x00000080, 0xCDFA207D, 0xEEFF1E19, 0x1CE5DE02, 0x0328D325, 0x00000080, 0x5593B282, 0x80380828,
            0x4C6B9AF5, 0x3DA8D86D, 0x00000080, 0x2B3F9F87, 0xD88DA2EC, 0xD83EB5E1, 0xD911EB3B, 0x00000000,
            0x54D42164, 0xA219D539, 0x256BB124, 0xF8501E92, 0x00000080, 0xCF3635D0, 0xBF78D32C, 0xC1224CC1,
            0xD228E64F, 0x00000080, 0xFD7B6A3C, 0x9C0F2F08, 0x62EF95B5, 0xB5F483AE, 0x00000000, 0x5C2FB599,
            0x7195AE50, 0x2D30F31B, 0x3FAF26A5, 0x00000000, 0xEFBE5E42, 0x28C4FAE1, 0x71F702F2, 0x6DF09825,
            0x00000000, 0x42E37CCB, 0x455ECD2E, 0x27AFC08B, 0x30F5217F, 0x00000080, 0xB40403BF, 0x6A9C1613,
            0x3DF495D8, 0x7F50EE86, 0x00000000, 0xAE542E9F, 0x4259133C, 0xFD49AC30, 0xF90AB3B5, 0x00000000,
            0xEFF0578D, 0xFE38B77A, 0xFAE8FF7C, 0x3191A39A, 0x00000000, 0x303CC729, 0x83F1A38F, 0x2FFDE5CB,
            0xFEEC0B59, 0x00000080, 0x81C2DBD6, 0x043D251C, 0xA15AA69E, 0xFFC65C1F, 0x00000000, 0x2A26AB1F,
            0xFB783996, 0x8904B30A, 0xCF708DF9, 0x00000000, 0x61D7C129, 0x52E9D640, 0xB7E00FF3, 0xD5F48A04,
            0x00000080, 0x8A97BEBD, 0xD1BDBCB5, 0xBA2768DE, 0x4C1B854B, 0x00000000, 0xABA3E5B5, 0x1D67F72A,
            0x6CF6C617, 0xA82A7B22, 0x00000000, 0xA782C96F, 0xD691DBBA, 0x46721627, 0xEE9B6780, 0x00000080,
            0xC02D5BC8, 0x499ECAF7, 0x0AAD8556, 0x26C199E2, 0x00000000, 0xBB1E7013, 0x7D560C8C, 0xC6E91668,
            0x6B6BAD9E, 0x00000080, 0x72374A44, 0x5F020242, 0xC377F38F, 0x07B4A8A3, 0x00000080, 0x25250BD1,
            0x8D9EE018, 0x356CF207, 0x86472DC5, 0x00000000, 0xF292D963, 0x7A9B6557, 0x1825D144, 0x560CBE93,
            0x00000000, 0xFBA2D8D0, 0xAF3E5C44, 0x8C5E932C, 0x7A2C84EB, 0x00000080, 0xC8B64BB3, 0x1D16BC18,
            0xE04B9C39, 0x30FB56CF, 0x00000000, 0x51F28665, 0x8DB003B1, 0xEC4B052C, 0x47B84CA5, 0x00000000,
            0x07B79D22, 0xCE5ADBC7, 0x5C335A9C, 0xA78510DA, 0x00000000, 0xE6EBDE9D, 0x15CDE9D1, 0x948C1CE3,
            0x818ECDB4, 0x00000000, 0x35A8242A, 0x87217DDB, 0x9FE8CCFC, 0x183B8C7C, 0x00000080, 0x533963A9,
            0x6FD2D9CF, 0x74915F03, 0xEE7B53FC, 0x00000080, 0x46C77C4E, 0x613F07DC, 0x781633C6, 0xA46EC25E,
            0x00000080, 0x395A213E, 0x97CD3812, 0x730BB23E, 0x1E4267D7, 0x00000080, 0x64648AC6, 0x49F798B2,
            0x86841ACC, 0x04CD5349, 0x00000000, 0x444DD6C4, 0x037D6DA9, 0xD568FD59, 0xD49BE7F4, 0x00000000,
            0xFB54C159, 0x42448842, 0xE6E72064, 0x32E073EA, 0x00000080, 0xCF311E13, 0x23F725D7, 0xF435E30D,
            0xFB036A7F, 0x00000080, 0xD3DA5D8C, 0x85097A13, 0x8A5F2319, 0x375DEF26, 0x00000080, 0xCBB93F8E,
            0x5D397E10, 0x0F238938, 0x79E7B5DC, 0x00000000, 0x191410E7, 0x3B8FBEAA, 0xE701C557, 0x7BE60FA7,
            0x00000080, 0x9D333A52, 0x0E37E112, 0x9055570C, 0x10EDD60A, 0x00000000, 0x64914BAE, 0x14445C0A,
            0x1546E6BF, 0x9843B504, 0x00000000, 0xAFF300EF, 0xF412A3D3, 0x8D116C78, 0x6E448628, 0x00000000,
            0xCE8B2B90, 0x7EC2BAC6, 0x98E3D86F, 0x852AC414, 0x00000000, 0x91CCB846, 0xC0E27E50, 0x769591C1,
            0x7A1998C6, 0x00000080, 0x3C375DF4, 0xA9349E46, 0xD65D7477, 0x795AA4A3, 0x00000000, 0x85113D7A,
            0x54337B91, 0xBD85FC5B, 0x2EA1960E, 0x00000000, 0x39ADFFE7, 0xF3B01535, 0xB174E837, 0xF79538AF,
            0x00000080, 0xBCBBD8DF, 0x31023B0C, 0xABECDDD3, 0xFE4A7786, 0x00000080, 0x8E30DD0F, 0xCC6E43D1,
            0x638BF8B8, 0x4CAFF214, 0x00000080, 0xF9A45818, 0x23B3FB50, 0x3AB92F23, 0x2F353F95, 0x00000000,
            0xA1B8F28B, 0xD98AD5D2, 0x276534E5, 0xF5ACC266, 0x00000000, 0xDA96B03D, 0x3D8CD1A8, 0x55A4B637,
            0x5AAF66E5, 0x00000080, 0xD95FED01, 0xF074D0E2, 0x5ED5D815, 0xAC33E0C2, 0x00000080, 0xBC6DAE77,
            0xC99ABB9F, 0x9A763F29, 0xDA4BFFA9, 0x00000080, 0xEDA3AEF9, 0xEB6F1FA5, 0xD0F05D11, 0xF2D498D6,
            0x00000080, 0xFC07A13E, 0xE1F41E4F, 0xC7AD6D0A, 0x45D1BDCC, 0x00000080, 0x6DBC79E6, 0x10662B59,
            0xA4232087, 0x7A82463E, 0x00000000, 0x2FE323B8, 0x5F028F6A, 0x61B1A7B6, 0xACA21E68, 0x00000080,
            0xE17EB6CB, 0x5C5176FB, 0x3DFF561C, 0x7C416681, 0x00000080, 0xA476BD14, 0xD69DAA76, 0x0180648B,
            0xF8D7A765, 0x00000000, 0x8335FFB5, 0x3E6A9336, 0x6A169B93, 0xEE760EEF, 0x00000080, 0xD5111200,
            0x6126345A, 0x56EB2F89, 0xDEECFF54, 0x00000000, 0x55EF1FC8, 0x1A50D01B, 0x4D01D10B, 0xE8E6B27E,
            0x00000080, 0x268BF3BE, 0xDFE53CF8, 0x64C69C0D, 0x1A0F0AFE, 0x00000000, 0x48D32C16, 0xE59AF968,
            0x5B6FB852, 0x6D75F728, 0x00000080, 0xFCE09D05, 0xF22ACB78, 0x046F9E73, 0x98576756, 0x00000080,
            0xE65A1A38, 0xDEB203D8, 0x23DF5201, 0x7249874C, 0x00000080, 0x6A326991, 0x19C74408, 0xF1C42FEE,
            0x087CD50A, 0x00000000, 0x0D4B6CD2, 0x23103BD2, 0x8B8A731E, 0x02C0F62B, 0x00000080, 0xC073D140,
            0x29F5275C, 0x622047AA, 0x7FC61780, 0x00000080, 0x3F21B0E5, 0x241A79E8, 0xA5D19884, 0x4F273CBE,
            0x00000000, 0xFF82045E, 0xAD27FCF8, 0x69C9AB4B, 0xB864099B, 0x00000000, 0x76D6BD5F, 0x5FEF9DD4,
            0xF7D566FE, 0x02CC7478, 0x00000000, 0xE435A214, 0x4C1BF21D, 0xA4FA34A2, 0xC8D18864, 0x00000080,
            0xD59BDF33, 0x84BCD129, 0x59862062, 0xA87AF4E5, 0x00000080, 0x3BE9846F, 0xAA20DB17, 0x008BAC5D,
            0x7A5ECEC2, 0x00000000, 0xECE24F12, 0xDDE5B15A, 0xA7F6980E, 0x775F701F, 0x00000080, 0xC0E7DCE8,
            0xC8F560AC, 0xDE07E28A, 0x7CC770A7, 0x00000080, 0x2EA3D476, 0x2F1B7329, 0x5EB3B44A, 0xA4CE408A,
            0x00000000, 0xDA612A0D, 0xA3B6FE99, 0x41D4F141, 0x4E17E3DE, 0x00000080, 0x8DF69767, 0x596566C9,
            0x1BB06EB6, 0xB2DEA08E, 0x00000000, 0x5D8BDDA8, 0x944CACDE, 0x4B514044, 0x4087E2A3, 0x00000080,
            0x6DB7278F, 0x3648AD08, 0x897DF319, 0x44342317, 0x00000080, 0xA3CE9576, 0x895CC234, 0xD72C650C,
            0x42BCD336, 0x00000080, 0x442908C1, 0x84129AEC, 0xC4B810E4, 0xD7F1B4AF, 0x00000080, 0x5024E79D,
            0x1E72596D, 0xE7E79FFD, 0x1AF55A94, 0x00000080, 0x183A8720, 0x06833047, 0x6F6D447F, 0x04E1FF9B,
            0x00000080, 0xA4C305C1, 0xC20A1C84, 0xC73A96EA, 0xA5181790, 0x00000080, 0xFE7B9B6A, 0x3EE63AC6,
            0x23C16A1A, 0xE3F13B32, 0x00000080, 0x30D74008, 0xB4320AFB, 0x83EF680A, 0xD768AA4F, 0x00000080,
            0xBD562B55, 0x0F483272, 0x1F86819E, 0x6A735656, 0x00000000, 0x57284955, 0xFCEBD6D5, 0x6EA63826,
            0x9AAA74D2, 0x00000080, 0x0CA3F4DC, 0xA477FE7C, 0x40ED385C, 0xF843B17B, 0x00000000, 0xF3DB66E0,
            0xF891E209, 0x43F1F25A, 0xF495F5C8, 0x00000080, 0x0B6558A2, 0x0A2A41F0, 0xBCF571E0, 0x44880D29,
            0x00000080, 0x73DFAEC9, 0xA1806A4C, 0x0A134F56, 0x328D0805, 0x00000000, 0x6BABC74A, 0x39E654BE,
            0x020BB886, 0x2BF2ED62, 0x00000000, 0x5009D10D, 0x6DCDB210, 0x5FD3FB79, 0x30662E03, 0x00000080,
            0xCA5C2765, 0xAF3825E5, 0xACA35F38, 0x042562EF, 0x00000080, 0x25F30957, 0x2B6B80ED, 0xB41185D0,
            0xC1FC2023, 0x00000000, 0xAFFF0EA6, 0x0221299E, 0x1C33AD5F, 0x9F81474C, 0x00000080, 0x1B8FFE94,
            0x03B20DD1, 0xA5FA978C, 0x0C07F813, 0x00000000, 0xE576B5EE, 0xBAC30AB1, 0x729C08DF, 0x4920F004,
            0x00000080, 0xB8C82832, 0xA0207EE5, 0xC932319A, 0x25E09EFD, 0x00000000, 0xC014C307, 0xCCE8A733,
            0x00A9E9F1, 0xBBDCC3ED, 0x00000080, 0x557A0548, 0x00E922BE, 0x72171B8C, 0xEC3D79AF, 0x00000080,
            0x29226D1D, 0xD3218F7A, 0x12407C30, 0x735DF8A6, 0x00000000, 0xC70E8631, 0xF41F01F8, 0x1D52B9A1,
            0xEF75566B, 0x00000080, 0x05B6A460, 0xF10B1B24, 0x912B37E4, 0x0E330BBD, 0x00000000, 0x94FC4D41,
            0x5F4D7DA5, 0xFAB5BBF0, 0xB3034A77, 0x00000000, 0x6981DBDE, 0x7D34A3C5, 0x89C8C871, 0xAEDA9F3D,
            0x00000000, 0x1773E955, 0x29D1473A, 0x7A1321E1, 0x0A99F213, 0x00000000, 0xEE9BA6B9, 0x99DF1BFD,
            0x33AA0A4E, 0x7662FF84, 0x00000000, 0x1301BD48, 0x3CF535F1, 0xABAAB6D3, 0x5E494316, 0x00000080,
            0x3B1278C8, 0x0D915E78, 0x9CCB4116, 0xD71AA632, 0x00000080, 0xE12FE442, 0xC0EC75BC, 0x4A5D51FC,
            0x1A9AF633, 0x00000000, 0x1BAC1D83, 0xEDE4A6A4, 0xDE31AE1B, 0xFC891FA2, 0x00000000, 0xE23D5F82,
            0x8E0C7A6E, 0x83C7F1E3, 0x8D1C3CC0, 0x00000000, 0x06A40CCD, 0x2CB83C3C, 0x3AF8FB79, 0x9D359F6C,
            0x00000080, 0x3EB82613, 0x6AB46AD3, 0xE0FF611C, 0x8CD4C828, 0x00000080, 0x09FF87DB, 0x09E22839,
            0xF90FEA87, 0xA27C50EE, 0x00000000, 0xFE73B419, 0xD2CA6C7C, 0xE401B567, 0x9BD7E9FE, 0x00000080,
            0xE194F24F, 0xAAF9ED37, 0x81F99961, 0xE1B71AD0, 0x00000000, 0xCE9232FC, 0xF4C08B1E, 0x5891BC1B,
            0xC4B82F75, 0x00000000, 0xD4EBDAED, 0x4FD754E0, 0xE989337D, 0xD23074BE, 0x00000000, 0xB43D0F8C,
            0x67F7AC75, 0x2E2A30C3, 0x174CB0C3, 0x00000000, 0xC6EF52DA, 0xCD5D57D5, 0xFF91213D, 0xEA6CC3FC,
            0x00000000, 0x39668BF8, 0xA31ADF02, 0x10AC50A8, 0xB0D33661, 0x00000000, 0x795BB82E, 0xC6700A95,
            0x388EDEB6, 0xA0157DCF, 0x00000080, 0x6FCDD3E7, 0x16B53A9F, 0xC7DA18E5, 0x47B8F097, 0x00000000,
            0xCFBEA850, 0x8B76AD58, 0x2DAD700D, 0x86DDF893, 0x00000000, 0x328D71D4, 0x0CE16EBB, 0x576A9273,
            0x86428D1C, 0x00000000, 0xF932D168, 0x02CB97CF, 0x6C9BC979, 0x0A195F5F, 0x00000080, 0x1F8B6BB3,
            0x093A9E25, 0x6A57AA31, 0x04D17B08, 0x00000080, 0xD88F2869, 0x5028F3F1, 0x1D261CCB, 0x1182AC02,
            0x00000080, 0xD87F5FD3, 0x30705582, 0x53316A90, 0xC8D35673, 0x00000080, 0xF30DBFB6, 0xEA08A29F,
            0x580DBE52, 0x9988AB07, 0x00000080, 0x60D88A2C, 0xD0433520, 0x407220ED, 0x6C92AC72, 0x00000080,
            0x9AD0D749, 0xB1009CA5, 0xA62FBB86, 0x2A7407EE, 0x00000080, 0xE430CFCC, 0x8D3D9F8A, 0x7C847B94,
            0xB7CE824C, 0x00000080, 0xADD9AF4E, 0xA4ACACC0, 0x73B8640C, 0xBAD82F89, 0x00000080, 0x1D652AC2,
            0xAB02591E, 0x8DE3468C, 0x0669D2A7, 0x00000000, 0xCC82E791, 0xC941B026, 0xC0B14982, 0x5907360A,
            0x00000080, 0xA30A413E, 0xE4D272FF, 0xE1DAF5C6, 0x92098289, 0x00000080, 0x39DE1FF5, 0xC0D9E5F0,
            0xD0F7064F, 0xB2064FC4, 0x00000080, 0xC9D312EB, 0x6C8A0315, 0xC0B0E4F9, 0x597372D8, 0x00000080,
            0xF591F74C, 0xD74A7388, 0xA1E977EF, 0xDA7CC69B, 0x00000080, 0x6108C062, 0x5B2A0434, 0x57548822,
            0x21B7C968, 0x00000000, 0x07A06E46, 0x85B33EDC, 0xED939A3E, 0xD9F28670, 0x00000000, 0x4236079E,
            0xB13809F0, 0x8C56FC8F, 0xE97E7A73, 0x00000080, 0x99E70A74, 0xA7CA8156, 0xF9FD9AEE, 0xA7ED96CF,
            0x00000080, 0xC595E649, 0xA3AB722C, 0xE7EC9CF0, 0xC99643EB, 0x00000080, 0xF6046689, 0xD6413521,
            0x39172D81, 0xB50C46AF, 0x00000080, 0x74DEBAB6, 0x22A4C0E3, 0xA3B39228, 0x7DDB0A0C, 0x00000080,
            0x3A49835C, 0x86F1DDB9, 0x32B707F2, 0x91D793F8, 0x00000080, 0xDC79EE32, 0x55E7127E, 0x9581082E,
            0x38988520, 0x00000080, 0x72741B99, 0x856ED57F, 0x34CC2D4F, 0x6E13A405, 0x00000000, 0x8DBF5923,
            0x0F253399, 0xAE6DE81B, 0x2EFE23CE, 0x00000000, 0x1A6C0C92, 0xBC1D3C1A, 0x3DA11C0E, 0xA3A70CC3,
            0x00000000, 0x44A957E6, 0x555AACC1, 0xECA0AB13, 0xF7301354, 0x00000080, 0xCC6D4FC7, 0xB10D036F,
            0x99468E55, 0x94F7F5B6, 0x00000080, 0x0A4B8BAF, 0x7F968B6E, 0x5C31F511, 0x8B00A0B4, 0x00000080,
            0x19962AC0, 0x1631BFD5, 0x3812BD29, 0x9668A314, 0x00000080, 0x64750317, 0x7B1A0035, 0x345154A1,
            0x566C0047, 0x00000080, 0x6F6165C2, 0x018990DA, 0xFDD34B34, 0xA3159344, 0x00000000, 0x64373CCC,
            0x7D75DA70, 0x39FB422A, 0xC1E16357, 0x00000080, 0xA8C4849E, 0xFCE524A1, 0x18030D6E, 0x97A787EE,
            0x00000080, 0x9B96A6EA, 0xFB60AF2E, 0x08187B7C, 0xDD72484F, 0x00000080, 0x881F30D5, 0x7D442CEE,
            0x38DDDB53, 0xD5290318, 0x00000080, 0x6FC4A737, 0x4CAFEF4F, 0x96AB935B, 0xB2141EE5, 0x00000080,
            0x2CADC00D, 0xDD694CE6, 0xE670533A, 0xC73007EB, 0x00000080, 0x214A0F8F, 0x97BF896E, 0xC83C563F,
            0xEBB4F9D2, 0x00000000, 0xE12F2D59, 0x4D6572AE, 0xAA8F6415, 0x0194DA86, 0x00000080, 0x30665B5D,
            0x003A1696, 0xEB18D113, 0x3C0277CE, 0x00000000, 0x507468BC, 0xDA7D8D24, 0x878D2E20, 0x69FC51D9,
            0x00000000, 0xFB929670, 0x4C1012AA, 0x6ED74F04, 0xE334CEEF, 0x00000080, 0x4E8E0E7E, 0x38155DD8,
            0xA91452C9, 0x469B4A24, 0x00000080, 0xF3A3E845, 0x3B358C89, 0xA4778417, 0x4D5F89F1, 0x00000080,
            0xAB279EBE, 0x7574E81D, 0xA70ADF07, 0xCC659164, 0x00000080, 0xBC111279, 0xF8266F57, 0x7E9764C5,
            0xFC7A87BC, 0x00000080, 0xBE40EFEC, 0xFE800024, 0x355D36D2, 0x1B2E743A, 0x00000080, 0xF6C49F23,
            0xD76DCA6E, 0xF4A2EE4C, 0xA2A6C941, 0x00000000, 0x7BD1D6B8, 0x02E4CC76, 0x86B7F56A, 0x1319F5B2,
            0x00000080, 0xA50425EB, 0xECED1BF1, 0x5F32E5D2, 0xFB5989FD, 0x00000080, 0x73C05BE3, 0x66B39BD8,
            0x75FCCFFC, 0xF351F7C2, 0x00000000, 0x74A222AF, 0x81E1AB4C, 0xA96CF634, 0x8709F32B, 0x00000080,
            0xBAC938AA, 0x13BD6275, 0x4BE6E256, 0x405BDC09, 0x00000000, 0x8D437378, 0xD080E078, 0x68F1B187,
            0x3A3F547E, 0x00000080, 0x36AF5BB3, 0x6C451ECD, 0x9DE9CB75, 0x689530C4, 0x00000000, 0x22F2587C,
            0xD81550B5, 0x07C222EE, 0x6A482F12, 0x00000080, 0x69CD6E45, 0x5C9440AC, 0x0CAD52E4, 0xA0E69AE2,
            0x00000000, 0x86246CAC, 0x289FF3B5, 0x7DE8B95D, 0x2B23436F, 0x00000000, 0x66638018, 0x0DEEEF6A,
            0xAD7A46D5, 0x2BC52F70, 0x00000080, 0xE28EFAC5, 0x72446B2A, 0xBF08B5C7, 0xEA27E156, 0x00000000,
            0x7E4D70F1, 0xBAEC6FCA, 0xBDDD3F21, 0x7FA21359, 0x00000000, 0x6495F2C5, 0x120BB583, 0x18989AB3,
            0x48DDC63E, 0x00000080, 0x287C2611, 0x8775410A, 0xE943293C, 0xA73F368A, 0x00000000, 0x7D7FB1C2,
            0x1DCBD08E, 0x62604812, 0xA54B7FAC, 0x00000000, 0x80B8B5A6, 0x3BB04394, 0xB581185F, 0x8A709B76,
            0x00000080, 0x343311BA, 0x37EA06C5, 0xA39BAD9D, 0x79154EA9, 0x00000080, 0xF20AFAEA, 0xC251BA11,
            0xE60AAB48, 0xFAF653F7, 0x00000000, 0xF3C406D6, 0x85F637CA, 0x7CBB52F8, 0xC4794831, 0x00000000,
            0x6D559089, 0x7FC4C32E, 0xC902090A, 0x5E33DE2E, 0x00000000, 0xDF6825A3, 0x38783AB8, 0x95487382,
            0x8A50FC76, 0x00000080, 0xA6101629, 0x9D2D2ED6, 0xCE0A1C54, 0xA13B9368, 0x00000000, 0xDBC0E11D,
            0xCD6C487E, 0x746C757D, 0x8F464FA5, 0x00000080, 0xDBA76DC0, 0xEEE0CCED, 0xE6A7FA2E, 0x9C5711A9,
            0x00000080, 0x020E3EE6, 0x72F721EE, 0x977062A3, 0x554A52AD, 0x00000080, 0xC08E8C5E, 0x4C531E9C,
            0x76102AC5, 0x456DA486, 0x00000000, 0xED15CE7C, 0x3AF6E90C, 0x130E9971, 0x4A7B4D4F, 0x00000000,
            0x946FFCC7, 0x83A9BBCF, 0x049AE2F7, 0x5A4B26DB, 0x00000080, 0x9910715E, 0x4E866A81, 0xDBC791D3,
            0x1F2C6319, 0x00000080, 0x9856B0B4, 0xAC07D70C, 0x602701E5, 0x0D32D729, 0x00000000, 0x10A4C815,
            0x27DB8A74, 0x08AAA7BF, 0x9472D89B, 0x00000000, 0x811051FB, 0xC57F21B5, 0x23232314, 0xC953BBC7,
            0x00000080, 0x153FB338, 0x0D2A22B6, 0xDD0A629C, 0x432BB034, 0x00000000, 0x3252E069, 0xE380433F,
            0xD0652AE9, 0xDF959D35, 0x00000000, 0x5D7791E7, 0x179B4EC9, 0x7E472A88, 0xBB4A7D6A, 0x00000000,
            0xA6D23444, 0x937D4485, 0xDE954DFD, 0x07120E1C, 0x00000080, 0x31DFEFBC, 0x2D4DC97A, 0xC5C2CE6B,
            0x266F1781, 0x00000000, 0x3E70CE10, 0xA22037AC, 0x9B12F13D, 0x3D38848E, 0x00000000, 0xCD87F358,
            0x915C413B, 0xCA166F11, 0x1EE22EA3, 0x00000080, 0xC95CCD2D, 0xE6A99386, 0xD414BAD9, 0x05EE9AA5,
            0x00000080, 0xF69712FF, 0x4A55CA7A, 0xB6599C95, 0x705A2AE2, 0x00000080, 0x70C29EC6, 0xBCCCA920,
            0xAA36B76B, 0xB989DE73, 0x00000080, 0x255DB3FE, 0x4F903501, 0x0E166D03, 0x0232D814, 0x00000080,
            0xCE813386, 0xF0748FB2, 0x1907A095, 0x6CD88BC0, 0x00000080, 0x2EA01937, 0x955AB0FF, 0xCC8DCFAA,
            0x71FBEC2B, 0x00000080, 0x1ACDD44D, 0xC4B50D97, 0x97370A95, 0x0F222E70, 0x00000000, 0x7D56D8CB,
            0xDE3E8522, 0x51C744F1, 0x38E0BA3D, 0x00000000, 0x4C5AA7E4, 0x69CB7651, 0x15196FAA, 0x04BD26E9,
            0x00000000, 0x26848099, 0x6C8EAD2C, 0x0CB18E96, 0xB08F22AC, 0x00000080, 0x89F162E7, 0x6C927167,
            0x1801DCE0, 0x97CD7FC9, 0x00000000, 0x85CC4EDA, 0xE74FD1EF, 0x2D2B7650, 0x9C51071C, 0x00000000,
            0xA446F1E1, 0x8012CB6E, 0xE81E18CC, 0x124CC338, 0x00000000, 0xAF16A837, 0x350029C6, 0x7A4298A7,
            0x7978F1BE, 0x00000000, 0xB4F86ED8, 0x635D8543, 0xEE75AB0F, 0x0DE1B777, 0x00000000, 0x25FA5035,
            0x742786C0, 0xC338C56F, 0x9622EE21, 0x00000000, 0x244D6054, 0xA3B7012C, 0x37CDCF1E, 0xE9AE891D,
            0x00000080, 0x3D208EBB, 0x3DD9AE34, 0x88DD58E7, 0x14589DE1, 0x00000080, 0x158E15C2, 0xB0637F6F,
            0x523349ED, 0x356CDFA3, 0x00000000, 0xE769B5E0, 0xAB8518BB, 0x1D490171, 0x298E6D97, 0x00000080,
            0xDED05285, 0x0FECDF08, 0x826FCB95, 0x3C0B03CE, 0x00000080, 0x611DF5B6, 0x23B11FBF, 0x01E31C25,
            0xF817A940, 0x00000000, 0xDA0F32B7, 0xE5127C9B, 0xA6733610, 0xDD8E37CD, 0x00000000, 0x26D2964F,
            0xDCAFC235, 0x09B14D90, 0xB5F4D402, 0x00000000, 0x6D1DFF34, 0xB34CCAF5, 0x985A37C4, 0xA0B907D6,
            0x00000080, 0x31E6BC3C, 0x1BAB0731, 0x3616A6B8, 0x2D87DF55, 0x00000080, 0xBED4F249, 0x1D106A43,
            0xCE338474, 0x8EDF5F5C, 0x00000080, 0xEA64F878, 0xB503B2EB, 0xA79E1A8A, 0x6D25FECA, 0x00000000,
            0x0D174D11, 0x434F9C8C, 0xBA77C28B, 0x59667856, 0x00000000, 0x56512C0B, 0x08AB1BCA, 0xA3DB1455,
            0x6EF23964, 0x00000080, 0x416E41BF, 0xDC873958, 0x80F2ED6F, 0x82B7E32E, 0x00000000, 0x0442350E,
            0xE38CB804, 0x1E5380DA, 0x3BA34021, 0x00000080, 0x3AB5EC8A, 0xA445DC87, 0xE1F7B871, 0x108EC05B,
            0x00000080, 0x007D42C8, 0xC9C05D00, 0xB7F2ADD5, 0x47C70F2C, 0x00000000, 0xDB2348DA, 0x7FD56937,
            0xCCE2D250, 0x360DD0B8, 0x00000000, 0x357A1800, 0x8689A875, 0xF1E83071, 0xE42742ED, 0x00000000,
            0x50C70A45, 0x99458DF4, 0x7E795EFF, 0xFC370AA1, 0x00000080, 0xFAC38795, 0x39AD8E80, 0x4661E534,
            0xBAFDA98B, 0x00000080, 0x76E98CEA, 0xB63A4FEA, 0x74A23F5B, 0xCA089DE7, 0x00000000, 0x40F83E9C,
            0x3250C0B9, 0x9B0494D0, 0xAC26A721, 0x00000000, 0x07623DD7, 0x9B227821, 0xF0FC323C, 0x214ED026,
            0x00000080, 0x01A43AA6, 0x43F6DBDC, 0x445541BA, 0xBA1F4CC9, 0x00000000, 0xBD9CE528, 0x740E0A31,
            0x5D57A1D7, 0x8368E531, 0x00000000, 0x8AA4FB36, 0x248C3C0E, 0x3329C492, 0xFD7A5391, 0x00000000,
            0x78519D21, 0xB01C0CC6, 0x16B72118, 0xE47DB88C, 0x00000080, 0x776F5CD2, 0x4F8CDCA1, 0x1253241D,
            0x75127BA1, 0x00000000, 0x78D15E54, 0xF29AF1A5, 0x833F2946, 0xD1ED2878, 0x00000000, 0x80D042AC,
            0xC274EA6C, 0x7EF9D19B, 0x3E62E89C, 0x00000080, 0xCD396101, 0x00C6BE4B, 0x560623C9, 0xEA91A472,
            0x00000000, 0x0EF93DE8, 0x69160FC2, 0x3AF01C06, 0xD37730C3, 0x00000080, 0x407E57E3, 0x831345F6,
            0xE41C9126, 0xC606685B, 0x00000080, 0x4E2D9B32, 0x16A3CD2D, 0x92483E5F, 0x80565214, 0x00000080,
            0xD0802004, 0xBA30AD7A, 0xBE701AED, 0xFA8DF859, 0x00000080, 0xB849C526, 0x9438D7E5, 0x280D49D5,
            0x07C7CF3D, 0x00000080, 0x06B3CB47, 0xD8B9BD41, 0x4722EA8B, 0xC288234B, 0x00000080, 0x47D1DD04,
            0x5A319E03, 0xAAA61BA0, 0x9A40AA8D, 0x00000000, 0x9E4F0F51, 0x2E5D2D1F, 0x4315DF5C, 0x8DC5DBC3,
            0x00000080, 0xA8A99F87, 0x48753650, 0xDFA61E14, 0xD0576624, 0x00000080, 0xD1E47C6D, 0x1E22E563,
            0x60E6F64E, 0xDC6D7ABB, 0x00000080, 0xF19E8E73, 0x1BF67120, 0xE49D56C7, 0xE57BB171, 0x00000080,
            0x886212AB, 0x3F284D01, 0xBD5045E2, 0x0B3F7A42, 0x00000000, 0x42DF22E5, 0x304BC2C4, 0x73EEEDE9,
            0xE1B2E7EA, 0x00000000, 0xEDEEDA1A, 0x40187652, 0x67E83528, 0x9305281C, 0x00000080, 0x523CF0A2,
            0xE589E630, 0xD9842555, 0xBAE417EB, 0x00000080, 0x3C160DEA, 0x93325A50, 0x254635CB, 0xC3536D20,
            0x00000080, 0xB6C14AA2, 0xF7A725D3, 0x0FFDA5C6, 0xFD1F5ACE, 0x00000000, 0x32CC2917, 0x47BC1169,
            0xC3DECB78, 0x78B4BA20, 0x00000000, 0x3581B350, 0xF4EC574B, 0x6672AAAD, 0xE7570B19, 0x00000080,
            0xD7E81E35, 0x6411C4C7, 0x8FE7E14E, 0x8804BBF3, 0x00000080, 0x252893F0, 0xD3E12354, 0xFBE84040,
            0x2CE10DAD, 0x00000000, 0xD961FE7D, 0x2947A1AA, 0xC28D1E53, 0x13693BB0, 0x00000000, 0xF87C05D9,
            0xC9F1565A, 0x94DE217A, 0x4E23AABD, 0x00000080, 0xA91A00B5, 0xAF7795C1, 0x72A1350E, 0x2D73900D,
            0x00000000, 0x7B0B603B, 0x117730DC, 0x16E71350, 0xC40AFB24, 0x00000080, 0xDCB1FEE6, 0x862C9156,
            0xB751DB0C, 0x20F5C68B, 0x00000000, 0x801C94C3, 0x68C77AAC, 0x7E97A98C, 0x3BF50E57, 0x00000080,
            0xA570A9DF, 0xB49DAFC4, 0x65E7E80D, 0x8927F47B, 0x00000080, 0x1941FD5F, 0x738752A6, 0xB15BCC0F,
            0x896DDDE2, 0x00000080, 0x96AAC077, 0x6C4A7E9C, 0xC7FF2217, 0x42A1EDF9, 0x00000080, 0xAEA5042F,
            0x84A5711E, 0x3263D182, 0x024DFA46, 0x00000080, 0x0F746099, 0x9717C122, 0xA122DA51, 0xE006B00D,
            0x00000000, 0xF77EA6FC, 0x7A7C7189, 0xE4217737, 0x97E645E4, 0x00000000, 0x1F6D1E20, 0xF3233005,
            0x113BD2FA, 0xDD0803F8, 0x00000000, 0xE373B440, 0x07815AC9, 0xCF9CBEC9, 0xE355554F, 0x00000000,
            0x450B2C05, 0x0B8A7F59, 0xA7E1F29E, 0x1A4B5B95, 0x00000080, 0x1EC2A0EF, 0x8A3B90AB, 0x6F7A1126,
            0x703D46A2, 0x00000080, 0xEC52949B, 0x0E8AE1E7, 0xDBF16077, 0xD5E713B4, 0x00000000, 0xC963801E,
            0x5A835E31, 0x4CED1811, 0xAF3F28F6, 0x00000000, 0xC5A9C1D0, 0xA3020586, 0xC47F7CB4, 0x8D9E2832,
            0x00000080, 0x35D940A3, 0x271D8D20, 0x7FF6CF25, 0x765ACA60, 0x00000080, 0x63ADF96D, 0xF3B0FE9A,
            0x217EB2DD, 0xC5BF4139, 0x00000080, 0xF9DFD480, 0x520E3EC2, 0x44690D8C, 0xA29E6DD4, 0x00000080,
            0x9116F98B, 0x5B3CC49B, 0x7BC636C7, 0xE2FD0F89, 0x00000080, 0xF5371E0E, 0xA680A375, 0x8C3DFBB0,
            0x9D26999B, 0x00000000, 0x019967DF, 0xA4B2CEAA, 0x029F73BB, 0xD5A81796, 0x00000080, 0xBC29A945,
            0x81ED407E, 0x7DBBF38F, 0x2FEC0C30, 0x00000000, 0x362833E0, 0x58DD1655, 0x162942FB, 0x9EB2ECF5,
            0x00000080, 0xDDEF6154, 0x316B3ED7, 0xCACC7B68, 0x6DE87DC5, 0x00000080, 0x6677A15A, 0x97BD2FAE,
            0x4DA8A05F, 0x820525AA, 0x00000080, 0x711DEC7A, 0xC4559BF0, 0x5ADC679F, 0x93E1D0D9, 0x00000080,
            0xBFBC4636, 0x132F5A38, 0xD27E165C, 0xAF615825, 0x00000080, 0x1AEB1C45, 0x0E88B12A, 0x9E88BD76,
            0xAEF65579, 0x00000000, 0x94E713DF, 0x0C41DFAA, 0x1243678B, 0xA6B08658, 0x00000080, 0x9A66F198,
            0x2EB0B54E, 0x45634CFE, 0x2408BFA0, 0x00000080, 0x7C514F56, 0x1DE0EDF9, 0x133ADBD0, 0x81EC1EC1,
            0x00000000, 0xDA8FAB99, 0x21382F3B, 0x9FBA9943, 0x68C1EEC2, 0x00000000, 0x02C87090, 0xA6184B9F,
            0xF6D55F13, 0x074775D6, 0x00000080, 0x901B666A, 0xDE8257A5, 0x6BE10C1C, 0xDC784BD7, 0x00000080,
            0x77EA39F8, 0xA6FF7D42, 0x01D6CEBE, 0x74EA8CFA, 0x00000080, 0x7F1EB64E, 0x2E839EF4, 0xCDB5D16D,
            0x854879B9, 0x00000000, 0x5B0DD88F, 0xA844129D, 0x0C765A6D, 0x76F2A205, 0x00000000, 0x6C61ABD3,
            0xA80F76E0, 0x4F411321, 0x0BDFE71A, 0x00000000, 0x0315DA9F, 0xCF7AAC05, 0x1889A46E, 0x1E974D35,
            0x00000000, 0xB5EBA537, 0xBD2CBA81, 0x777A41D9, 0x99E7A7FE, 0x00000000, 0x53594763, 0x628148A2,
            0x207A4F8D, 0xC324CDAE, 0x00000000, 0x86883BB7, 0x4154B80A, 0x1B4F43F3, 0x18418460, 0x00000080,
            0xD07FFBDD, 0x7068DC39, 0xE7F3BE3F, 0x850CE5EA, 0x00000000, 0xD3A396E2, 0x8A6CDE56, 0x78678CE5,
            0x9BD56F4E, 0x00000080, 0xF0AA8723, 0xB8FF639D, 0x197F02B8, 0x3C5AF1E5, 0x00000080, 0x2C43AC85,
            0x6A5FB6B9, 0xD0FC82A0, 0x9DC1B4EB, 0x00000000, 0xFFE0973A, 0xA5F4AD0B, 0xB43033A7, 0xD23F2880,
            0x00000080, 0x5C845005, 0x51F5C0F4, 0x20C40BE1, 0x3BFE2FDB, 0x00000000, 0x1F38C546, 0x67895B44,
            0xAAABC13C, 0x9884F74D, 0x00000000, 0xCD32456B, 0xEDBB7E27, 0xF11AA077, 0xDDADB837, 0x00000080,
            0xF7032133, 0xC65D1F40, 0xCE1C7BD8, 0xF605324C, 0x00000000, 0x6E469A85, 0x9870A78C, 0x9D403445,
            0x9C56C77A, 0x00000000, 0xC5A16179, 0x50FC0100, 0xE6E29A71, 0xD2B49111, 0x00000000, 0x4BA05E26,
            0xCB2F18F6, 0xC3D6BEFF, 0x4A81B816, 0x00000000, 0xA6E5A7F0, 0xEC447407, 0xF172267F, 0x12E678DE,
            0x00000080, 0x7E25FF04, 0x3613515A, 0x67955605, 0x1D2F96EF, 0x00000080, 0x2AFEA154, 0x1F690E0E,
            0xCA7A1B51, 0x12ECA0E3, 0x00000080, 0x420E66F3, 0x97E785F6, 0xA51F44C4, 0x593B45A6, 0x00000080,
            0xF96B9388, 0xE8D33663, 0x37923C57, 0xD0BFFDDE, 0x00000000, 0x7B7CE81A, 0x3ADDF22D, 0x3FD06310,
            0xA933CE7E, 0x00000000, 0x5BE1F97F, 0xBD1B0DA4, 0xFB888CD9, 0x97215013, 0x00000080, 0xDF3C9D96,
            0xFDE8A545, 0x41B103E2, 0x1147AD0F, 0x00000080, 0x9C99A667, 0xAB3389C7, 0x4E9BBAEC, 0xBEF87436,
            0x00000000, 0xB1057E3A, 0x1AB7A148, 0x9F610390, 0x8949874F, 0x00000000, 0x64CB81DD, 0xFAAA50C8,
            0xA169DE43, 0x1DA25DEC, 0x00000080, 0xAA5D115B, 0x48448936, 0xAC9DACFF, 0x99440F02, 0x00000000,
            0x974B61B5, 0x6BB9DEEC, 0x0640BE59, 0x76222B3E, 0x00000080, 0xC634AEF3, 0x53459F95, 0x59181C9F,
            0xE5262493, 0x00000080, 0xB982F90C, 0xD7128814, 0x7733F43F, 0x00455811, 0x00000000, 0xE4B6BE32,
            0x4CA7E931, 0xC57547EF, 0xC12439DE, 0x00000080, 0x59061232, 0xDB5FDE1C, 0x0B138A41, 0x668FE992,
            0x00000000, 0xA0526DEF, 0x15265E55, 0xFFEFA1C3, 0xC3B0F858, 0x00000000, 0x2352C56D, 0xDED11F43,
            0xDBD6F8A6, 0xA0901B24, 0x00000000, 0x305AD1FA, 0xCA559A6A, 0x23DF3271, 0xE8BE477C, 0x00000000,
            0xD9511C98, 0xF22D0A2B, 0x1C3AA8EE, 0xF0D81F4D, 0x00000080, 0xDD670965, 0xF8FD4F56, 0xAA37F152,
            0xC5729B90, 0x00000000, 0xBA6DAB74, 0xED0D5CB4, 0x9F1B3A25, 0x98B361C7, 0x00000080, 0xA255E11E,
            0xBE68B2EB, 0x9375DC98, 0x185D3AE3, 0x00000000, 0x40DBB5E8, 0xBD9C5358, 0x5EF2932E, 0x17FC2BCF,
            0x00000000, 0xCD4C4FC7, 0x3F6203AF, 0x99DE8E96, 0xD9A71AD7, 0x00000000, 0x4EFB0E1F, 0x7463A3D6,
            0xE436C8C2, 0xA2B3637A, 0x00000000, 0x60404F3A, 0x7A4BA714, 0x9F92A5F8, 0x7AE8B9C3, 0x00000000,
            0xA583F8C0, 0xAADA04CD, 0xDEE05596, 0x978D2AC9, 0x00000000, 0x83750736, 0x2136FD3E, 0xF632686F,
            0x85A538B4, 0x00000080, 0x3686A547, 0xD1A07D1D, 0xA1A82C2A, 0x43C9B5A3, 0x00000080, 0x2BCB7A45,
            0x44A51662, 0xA0844397, 0xC37D5A63, 0x00000000, 0x1E843E75, 0x88E6BBD4, 0x116BAC7D, 0xDF673D18,
            0x00000000, 0x32BF6560, 0x6961E229, 0xD2656800, 0x1B2B68A9, 0x00000000, 0x9219198A, 0x3E6C197F,
            0x3BCE2B32, 0xE15CF06A, 0x00000000, 0xED4179CE, 0x88C72994, 0x6A17F834, 0xF0DCF501, 0x00000000,
            0x1E85EEA7, 0x015603B2, 0x304DF265, 0xA0F73FC4, 0x00000080, 0x842D40B7, 0x4BB9C995, 0x3F04587D,
            0xD01D2D57, 0x00000080, 0xC22693D4, 0x947747F6, 0xF89952EE, 0xF094906C, 0x00000080, 0x1E4C6BFE,
            0xB269BB2D, 0xA2268D82, 0xD7782398, 0x00000080, 0xD3847932, 0xEF066037, 0x61ED0761, 0x3E6BC58E,
            0x00000000, 0x93B3C27C, 0x9F8A6162, 0x43B4CAFD, 0xBC6D1BCE, 0x00000080, 0x59E1856B, 0x7620D4D8,
            0x8D1A292B, 0xA7277FA5, 0x00000080, 0x670495EB, 0x77B45029, 0xD3B020E3, 0x538F50E9, 0x00000080,
            0x0F0A027E, 0xC3EBF49C, 0x66EED41A, 0x14632F84, 0x00000080, 0xBF9126D6, 0x7BD96799, 0xBD1667C2,
            0x3BDB6224, 0x00000080, 0x11591146, 0x70FF9A00, 0x647DBC6C, 0xDF4DB03D, 0x00000000, 0x31AC6536,
            0x846D157E, 0xA1D03A2D, 0xDA61F372, 0x00000080, 0x59CD8D24, 0x477B48E2, 0x26BE2600, 0x6B656BB8,
            0x00000080, 0xC16585A2, 0xF29E4A42, 0xCF7A55DB, 0x7EDDA87E, 0x00000080, 0xFD04E029, 0xD0299055,
            0x40EFD603, 0x1EF955E7, 0x00000080, 0xAC860FE4, 0x8137F620, 0x0DEE819A, 0x8A4C0733, 0x00000000,
            0x783988FD, 0xBAA8855C, 0xDFBF8D8D, 0x272F75C7, 0x00000000, 0xF4621013, 0x84B85220, 0x73329A84,
            0x6351F800, 0x00000000, 0x46D2D7C3, 0x86493662, 0x878AB365, 0x0ED5904A, 0x00000000, 0xC1D0805B,
            0xED611053, 0x18EDB960, 0x284ADADA, 0x00000080, 0x3A74B98A, 0x931716A2, 0x6B96CBB7, 0x766C2ACB,
            0x00000080, 0x8BBA005C, 0x032F051E, 0x5CB33944, 0xC8B7F0D5, 0x00000080, 0x770ABC28, 0xE8404177,
            0xD04CB56E, 0x9C2E8BFE, 0x00000080, 0x437A37DD, 0xC599937E, 0x72C6C2C9, 0xC9E8E810, 0x00000000,
            0x3C4898E2, 0x36E8E421, 0xDD868529, 0x04CBB071, 0x00000000, 0x993948BC, 0x88BF04E2, 0xE924C89F,
            0xA9732F0D, 0x00000080, 0xF11FF3AC, 0x822886DB, 0xEC63E852, 0xD19531DF, 0x00000000, 0x5FA96DA8,
            0x766AF0AA, 0x518F76F7, 0xB1CD7EA0, 0x00000000, 0x5516BE50, 0xD1AA2553, 0x0A60A3BC, 0x9BF73ECA,
            0x00000000, 0x72B95C4E, 0x749D1AD9, 0x39CB2963, 0x65076BC7, 0x00000000, 0xD8FEC82B, 0x33CC79E8,
            0xE7634F76, 0x7BC807FC, 0x00000000, 0x3E1C6D37, 0x7C7F6C43, 0xF0ACAA88, 0x7043B42D, 0x00000080,
            0x707470CE, 0x22CFC0BF, 0x249B99AB, 0xB8C4E3CB, 0x00000080, 0x8425868E, 0x49EB4347, 0x83E0F0F6,
            0xF6AFB5BA, 0x00000000, 0xA2F30202, 0xEE2E055C, 0xD29B2F38, 0xDDBAD748, 0x00000080, 0xBA466191,
            0x146BC771, 0xD541DD2D, 0x3BB86E72, 0x00000000, 0x9BE07AAD, 0xB814BB71, 0x0349F1C4, 0xA656EA4C,
            0x00000000, 0xB32FA812, 0x5E6AD6EB, 0xF4EC966D, 0x4C04F7F3, 0x00000000, 0x5151D285, 0xB6D4E004,
            0xE2685673, 0x31A1AA68, 0x00000080, 0xB1AEDCBD, 0x582A6868, 0xAF514E6E, 0x1A806811, 0x00000080,
            0xE2063FB4, 0xF7603FAC, 0x4C1974D2, 0x3F51F0DF, 0x00000080, 0x4E8D54E9, 0x9C20B80A, 0xC374D103,
            0x93E1102B, 0x00000000, 0xC231F50C, 0x5F3DDE03, 0x29E25C46, 0xF1061179, 0x00000080, 0x60BBA8A5,
            0x6E6446DD, 0x94717CF2, 0x89CEB00F, 0x00000080, 0xBE399E85, 0x9F9EAC47, 0x82392E86, 0xCE3B43B7,
            0x00000080, 0xCB4C1415, 0x0AD807D0, 0x718BD108, 0x674983E7, 0x00000080, 0x19E4E6AD, 0x942C36F1,
            0x4EC93709, 0x099D158A, 0x00000080, 0x04A11B83, 0xED16F558, 0xA1889BFA, 0x3065A9BC, 0x00000000,
            0x64CA34C5, 0x2687789B, 0xED719AB9, 0x89229FC5, 0x00000000, 0xB0EC5C29, 0x3D61F062, 0x2343DE68,
            0x9DC230C3, 0x00000080, 0x76A33F76, 0x91A0CC98, 0xBD24C977, 0xB7B40610, 0x00000000, 0x0C985C28,
            0x01B51523, 0xD2A13605, 0x537E5857, 0x00000080, 0xEDF8E3EF, 0xC072F310, 0xA4472E38, 0x4B0844D8,
            0x00000080, 0x5BF25777, 0xD355CE91, 0xA9490126, 0x9138B6AC, 0x00000080, 0xE51A0F13, 0xDF0D0E15,
            0x5F4BA7EC, 0x7C309D97, 0x00000000, 0xCF436AAC, 0x78A9855E, 0xAEA6E2E2, 0xA56829D3, 0x00000080,
            0xE884ADCF, 0x023CDF47, 0x5B988317, 0x35762C54, 0x00000080, 0xD79C0885, 0x478CE4B7, 0xBA424C84,
            0x1ED87EB2, 0x00000080, 0x9C536D3E, 0xB082E89E, 0xCE9CF04B, 0x971D9E03, 0x00000080, 0x0B5E9EBD,
            0x88246F8E, 0xAD3BDE84, 0xB8358BCF, 0x00000080, 0x89A5D17D, 0xF6A5B7A5, 0xC7488269, 0xC909AAF9,
            0x00000080, 0xA534E297, 0xA00E253C, 0x1D86D105, 0xDED0C16F, 0x00000080, 0x2278BDA9, 0x2A77E2B5,
            0x3D2712C1, 0xB380FDE1, 0x00000000, 0x9908A512, 0x0B7265AB, 0x6549A780, 0x289F9A5A, 0x00000080,
            0x0D4A4472, 0xC55A68E8, 0x062DD6B6, 0xF9594D14, 0x00000000, 0x475BC9B7, 0x06275745, 0x21475C8D,
            0x00E55A2B, 0x00000080, 0x62E41790, 0x3C632157, 0xFF1924DE, 0x5B54F434, 0x00000080, 0xEFF07F14,
            0xB986E220, 0xCA8CE588, 0xADA4A06E, 0x00000000, 0x0DA0E4EF, 0x3A67331B, 0x6A19513D, 0x0032334A,
            0x00000000, 0xE27A5D7F, 0xC83847D0, 0x211EE671, 0xCD41787C, 0x00000000, 0x46C47EF3, 0x1B7523C2,
            0x97041897, 0xFDCC6678, 0x00000080, 0xDF35AB65, 0x78A1D323, 0xC044316C, 0xBB29DA5C, 0x00000000,
            0x912F8D1C, 0x39A0C688, 0x370BE577, 0xEA0C6FF8, 0x00000000, 0xC0E741A4, 0x43EFDE7A, 0xFC40DB4E,
            0x7F8C81A8, 0x00000000, 0xF01ECE8A, 0xFAE49F95, 0x775F7E11, 0x60D53807, 0x00000080, 0x25533260,
            0xBAEB1719, 0x215BCC2C, 0x4536D9C1, 0x00000000, 0xAD66AF19, 0x80024A0C, 0x85FA3AB1, 0x76CDFC6A,
            0x00000000, 0xF992C600, 0xF842C054, 0x040852C9, 0x238937CF, 0x00000000, 0xF53400F8, 0x3278F80E,
            0xFCC65CF2, 0xAEF0DFF1, 0x00000080, 0x645F9F41, 0xA3134FD7, 0x396C04C1, 0xA5109A7A, 0x00000080,
            0xD9683E6A, 0x7267C845, 0x9D14E56C, 0xFFFC5C4E, 0x00000000, 0xCCADCA28, 0x642A293C, 0xE7DCAA21,
            0x8427BE40, 0x00000080, 0xADCC523E, 0xC6234621, 0xC782D6E2, 0xD41C2F8F, 0x00000000, 0x0DA9DF16,
            0x1A51E358, 0xF9564C3B, 0x49D69B35, 0x00000080, 0x61C65C43, 0x9A59C99E, 0xED6405BD, 0xA6ED67A0,
            0x00000000, 0x094DD3F1, 0xB630FC69, 0x79B3A888, 0x4B501CD0, 0x00000080, 0x02C754DB, 0x2C6169C4,
            0x9E01EDE5, 0xF6020F78, 0x00000000, 0xF7308A23, 0x37F5A573, 0x631D3C01, 0x4F6017B2, 0x00000080,
            0x999D6735, 0x25362221, 0x8A6207D4, 0xC9577507, 0x00000080, 0xAF82DC2C, 0xF53DD937, 0xDDCAD420,
            0x2326BB3A, 0x00000080, 0x6DA94156, 0xFED82606, 0xC928D930, 0xDE002BAC, 0x00000080, 0xB90581C5,
            0x022FD723, 0x6F4ED0CB, 0x0068CA91, 0x00000000,
        };

        /// <summary>Length: 3225</summary>
        private static readonly uint[] s_keyMatrices_full = new uint[]
        {
            0x7E7B063A, 0x44899148, 0x828572C9, 0x1978D422, 0x00000000, 0xB18691C1, 0x02844B6C, 0x1CFF0611,
            0x334EA623, 0x00000080, 0xEDDB3332, 0xFF2E1868, 0x7B007DDD, 0x6F1ECE43, 0x00000000, 0x387F28F1,
            0x3546E754, 0x0A943FA0, 0x4A1CFBE2, 0x00000080, 0xE98B98E8, 0x3B07B5B5, 0xE17DAFF8, 0x641E0699,
            0x00000080, 0xBDD01B84, 0xB6B99952, 0x5A0335F0, 0x58BD0F29, 0x00000080, 0x8823DEE7, 0xC54E6DD1,
            0xC12A269C, 0x2775FDF6, 0x00000080, 0x8F8B3DE4, 0xE7FFA3D0, 0xAE749EF0, 0x93133B9F, 0x00000080,
            0xF2C8A1E7, 0x20012777, 0x1D85CCCF, 0x62F23B84, 0x00000080, 0xC6600AB4, 0xAEE67E12, 0xB369EB99,
            0x2CE479AE, 0x00000000, 0xF2EAD14A, 0x53B6EB22, 0x7CC1920D, 0xEAB2C7EA, 0x00000080, 0x404FE7F2,
            0x96D8638E, 0x66E46F1E, 0xCEA4FCC4, 0x00000080, 0x0DB0C227, 0xA6687043, 0x15258BB5, 0x6D932335,
            0x00000000, 0x546B7EFA, 0xF94EA934, 0xAAA12194, 0x36E88F99, 0x00000000, 0xDFD30190, 0xA74FB18B,
            0x2D93B956, 0x7AAD955E, 0x00000000, 0xFB0EAD51, 0xC882A50E, 0x83CB13CA, 0x68242715, 0x00000000,
            0xEF7E2CE5, 0xD508B614, 0x93FE5562, 0x3BB27D22, 0x00000000, 0x907DCA11, 0x66951943, 0x73A7F885,
            0x7259F803, 0x00000000, 0xE1773108, 0x81280C46, 0xFBF59DC8, 0x79998D09, 0x00000080, 0x93614593,
            0x9591C080, 0xB6267EDC, 0x10040A8F, 0x00000000, 0x431FEAC2, 0x658054A3, 0xFC30B7BD, 0xDC13A0EE,
            0x00000080, 0x396F48FB, 0x352BCAD4, 0xAC0A41AD, 0x1B311B96, 0x00000080, 0xB935182D, 0x2BCFF046,
            0x79E73C08, 0x7AB1BB42, 0x00000000, 0x78B8E822, 0x161FED18, 0x2DEF2DC6, 0x7A1D57DD, 0x00000080,
            0xDEE9C79F, 0xFE552523, 0xC4214EC3, 0x88CB6338, 0x00000000, 0xF05C53CC, 0x3BF980FE, 0x9545EE61,
            0xFCA861FC, 0x00000080, 0xD5319108, 0x52A9C8AB, 0xD46938C3, 0x80271608, 0x00000000, 0xE8396A39,
            0xE11E9945, 0x3E420DC5, 0xF98E3644, 0x00000080, 0x4EE25790, 0xFD3F2EED, 0x114ED925, 0x41DF8A71,
            0x00000080, 0x5114E44E, 0xA68DFA34, 0xC748B4E6, 0x0AF46754, 0x00000000, 0x68190ED0, 0xA8E99827,
            0xCF676BEC, 0x398D843E, 0x00000000, 0x5DDAE8BD, 0x93715132, 0xE5EC55D7, 0xCD823B5C, 0x00000080,
            0x556C5FC0, 0xDD5448AD, 0x293DE9E7, 0x6606B254, 0x00000000, 0x822316C8, 0xB0C215D6, 0xE1CAC1CD,
            0x71C8BA14, 0x00000080, 0xF05DD359, 0xB287B06D, 0x9804F816, 0xC599ED03, 0x00000000, 0x9C0611BB,
            0x76C1F8BF, 0xC3315712, 0x227A498F, 0x00000080, 0xB744ED2E, 0x6371C923, 0xBA569D61, 0x460F7034,
            0x00000000, 0x7D6A575E, 0x07E6B98B, 0x0146B955, 0xA7247110, 0x00000000, 0x26328895, 0xBC83A85D,
            0x4A4993B3, 0xBD19BC4E, 0x00000000, 0xB2C89C0C, 0xE51848F2, 0xD8760A71, 0x4E3377A9, 0x00000080,
            0x0A312EB6, 0x5CEDD435, 0xAD20AD1E, 0x9D7A2076, 0x00000080, 0xF8500A0B, 0xA984A5F6, 0x7ACE8295,
            0x0C64C7F4, 0x00000000, 0x7F58B185, 0x7ABDD10D, 0x2AF49C15, 0x13DA0049, 0x00000080, 0xD52D41B5,
            0xF70B2CDC, 0x056C033F, 0xF5272520, 0x00000000, 0x4D1E1C28, 0xB465C44C, 0x0BAD9EF9, 0x930CC957,
            0x00000080, 0xBA4E1437, 0xC4D3F39A, 0xCA2E592E, 0x20E18752, 0x00000080, 0xEA9577E2, 0xA98FD5CE,
            0x7E973649, 0x2CA1AF2A, 0x00000080, 0xA2EE82DA, 0x2C044DF4, 0xFFF060F5, 0x552A7B6F, 0x00000080,
            0x1096FE02, 0x110F2F9A, 0xA748B10D, 0xC32FE2B3, 0x00000000, 0x4CBAAF5C, 0x7662AAA5, 0x1532E309,
            0x70D945F5, 0x00000080, 0xE210D8AB, 0xA59AFD04, 0x8B97318E, 0x5C5E41B4, 0x00000000, 0x5DC42F30,
            0xCB501F03, 0xA14F73E0, 0x765FEC74, 0x00000080, 0x01E22D20, 0x542F9E55, 0x5BB05090, 0xF241B4B2,
            0x00000000, 0x66D8B202, 0xEE1FF77B, 0xBEC1F42E, 0x1D57F99F, 0x00000000, 0x63B596F0, 0x2656C6BF,
            0x36DB1594, 0xBABA7117, 0x00000080, 0xE8DE7C48, 0xFD81E9E5, 0x7E0B6C4B, 0xD8940E55, 0x00000080,
            0xD6AD95EF, 0x213997D3, 0x5FA251EA, 0xE2E2294D, 0x00000080, 0x48D254B3, 0xDB50A400, 0xB25EFDC6,
            0xD3B276E6, 0x00000080, 0xC0A1EBCC, 0x238AD404, 0x37789258, 0x7B968217, 0x00000000, 0x4D51C9F2,
            0x2EF692FA, 0xC0D2AB38, 0xD57DA528, 0x00000000, 0xB76180DB, 0x4D5520EC, 0xAC2C911C, 0xEE302E2F,
            0x00000000, 0xBAD47F5B, 0xAB889418, 0x62A7A6B9, 0x6D485709, 0x00000000, 0x1A0E57E8, 0xD623AC2B,
            0x90A177E4, 0xC10424BC, 0x00000000, 0x0C9EA493, 0x8C77242B, 0xD18D53DB, 0xEB475A5F, 0x00000080,
            0x6057CA73, 0xB9391C52, 0xEC0F7A6C, 0x673144A7, 0x00000000, 0x2B722754, 0x5A8250A4, 0xEBABA85D,
            0x62A73BDE, 0x00000080, 0xC6D4D7CE, 0x0F6A6572, 0x4B0846F4, 0xE33068B2, 0x00000080, 0x8172F3D2,
            0xE1C927B1, 0x1AAA05BF, 0x5BA6BBF8, 0x00000000, 0xB885C596, 0xFDCDCAB0, 0x8E486D01, 0x4A4DA006,
            0x00000000, 0x70FD756E, 0xA9A4F53C, 0xED53530E, 0x21A89257, 0x00000080, 0x6003267E, 0xB5741F79,
            0x536C45CF, 0xE42FB9AA, 0x00000000, 0x443CFD57, 0x3DAF3E25, 0x801D3759, 0xC51788FF, 0x00000080,
            0x54807468, 0x6DC869FA, 0x81E9D3FF, 0x72882A8F, 0x00000080, 0xB9576563, 0x902B557E, 0xB7C42F3B,
            0x8A148BE0, 0x00000000, 0xCAFCF6D5, 0x2ACFC43D, 0x7DD210AE, 0xB3044AC4, 0x00000000, 0xCFBDBB5E,
            0x32EAB0A8, 0xA135FFA7, 0x4328D8D9, 0x00000000, 0x35ADE93F, 0x085E771C, 0xEF03A3B0, 0x26B07ADF,
            0x00000000, 0x660478CE, 0x87339624, 0xD3A0B309, 0xE325BD25, 0x00000080, 0x1954D55F, 0xBCDD5F8B,
            0x4E8AFC16, 0x87A1CC0C, 0x00000000, 0x9D91524B, 0x2F15C85D, 0x4A857991, 0x66E45425, 0x00000080,
            0x75A14AB7, 0xEA491616, 0xB1AF9FD6, 0x253E2001, 0x00000000, 0x078F258A, 0x3155F367, 0x0DD97E61,
            0x3D8B0E9C, 0x00000000, 0x6E0E1445, 0xDD63C6A5, 0xA9A72A86, 0xBC9B6DE7, 0x00000000, 0x26AF9EBB,
            0x407F8AF9, 0xDF30AA16, 0xD855FD27, 0x00000080, 0xE23A4994, 0x746D71C7, 0x34825A82, 0x78DF3E11,
            0x00000000, 0x6D60787B, 0x17A25970, 0x4C2842F6, 0x5200770B, 0x00000000, 0x88F7C720, 0x91C5D634,
            0xCB93035B, 0xBC14F2EA, 0x00000080, 0x99DD2BCD, 0x73FE0F99, 0xDFD7805A, 0xABE18B9F, 0x00000080,
            0xF4EC2883, 0xDCF8D1AF, 0x03FB2759, 0x06EF18C0, 0x00000000, 0x5B7282C5, 0xDECD8AEA, 0xB1D1FA05,
            0x49C15C26, 0x00000080, 0x3CB0E398, 0x0A31B537, 0x9F8C6B16, 0xC8B5C2C4, 0x00000080, 0x716295BF,
            0x2AA7FF02, 0x6F062A6E, 0x87FCE8DF, 0x00000000, 0x2F09B3F9, 0xC8C4F40A, 0x300935AB, 0xA3DD3047,
            0x00000000, 0x71477DA5, 0x534561B9, 0x92D79B88, 0xBB24D6F8, 0x00000080, 0x9C4B3761, 0x8A7DD2D7,
            0x847ECA2D, 0x6FF84F8B, 0x00000000, 0x3FFF8D0D, 0x72206E3F, 0x2C9B4F40, 0x45D63635, 0x00000080,
            0x6BFDC48D, 0x742E4273, 0xAC59F2F2, 0x94B146EF, 0x00000000, 0x0A97F3F1, 0x718C77C4, 0xAFB703BE,
            0xBB7AAF72, 0x00000000, 0x62E96A47, 0x47F4FB94, 0x68CA2377, 0x6950B756, 0x00000000, 0x7197C58D,
            0xFC0D78FE, 0xAC005879, 0x84A0F4AB, 0x00000000, 0xC4000E41, 0x49C21ABA, 0x9382F179, 0xC3F8596B,
            0x00000000, 0xB8040744, 0xC0A5FD5B, 0x471ECBED, 0xA270E59C, 0x00000000, 0xA9DCD00A, 0x4B590A8B,
            0xF24529DE, 0xEB9533B8, 0x00000000, 0xC60BDB5E, 0x6C723304, 0xBD0CADA8, 0xE7109112, 0x00000080,
            0xC8DDA837, 0x3A080096, 0x289E04CD, 0xEECE0C26, 0x00000000, 0xF7B1C2E5, 0x110CB124, 0x086ABF68,
            0x26629ACA, 0x00000080, 0x005304B6, 0x9612A8BB, 0x9D83280E, 0x695897DE, 0x00000080, 0xF0F5CE1C,
            0xCE9CE687, 0x110818D6, 0xE50186C1, 0x00000000, 0x21CD7DF1, 0xDA997631, 0x43204F8A, 0xC23BBB62,
            0x00000080, 0x526DC500, 0xFC583979, 0x635DE2FB, 0x4702F1F6, 0x00000000, 0x2D81F779, 0x059BA9BA,
            0xD39F21E6, 0xE980E4E1, 0x00000000, 0x26E9BD4D, 0xDE21ACA0, 0x4195981C, 0x0B149FCD, 0x00000080,
            0x83401998, 0x9B5D1779, 0xBBD4C497, 0x5E25F834, 0x00000000, 0x619D99DF, 0xA70224EC, 0x7B1FBFBE,
            0x3DA7AA96, 0x00000080, 0xE219F5F2, 0xC9FE496F, 0x3D2BB0A4, 0x5D5DBAF5, 0x00000000, 0xB8BDBBB8,
            0xC2ACFDB9, 0xF161120C, 0x2A8DE191, 0x00000000, 0x16D5CA33, 0xC4A67DFE, 0xE74299CF, 0x5DED1365,
            0x00000080, 0x67B2761D, 0xF8AE8482, 0x59DF703A, 0xCC0281BC, 0x00000080, 0x4108FBA3, 0x0ADE8508,
            0x573309F9, 0x341F9930, 0x00000000, 0x2CB1F6CB, 0x22CE6FB7, 0x5A0D3A3A, 0x7151F8F5, 0x00000000,
            0x409EAD34, 0xDC86437C, 0xB2A99F42, 0xD31236EF, 0x00000000, 0x69A0373B, 0x1E1E64A8, 0x8C5A5EEF,
            0x4A42ACB4, 0x00000000, 0x0F92B912, 0xE061BCCF, 0xB467786A, 0x39ABE3A8, 0x00000000, 0xC48CF483,
            0x5F07ECD3, 0x5231B6D9, 0xD7AF2B2E, 0x00000000, 0x8619495C, 0x624BCD1A, 0x59115F82, 0x89F232BF,
            0x00000000, 0x95C9FAF9, 0x11B8B8F2, 0xB29B423D, 0x40381229, 0x00000080, 0x64B51A70, 0x2DE10722,
            0x145A72A3, 0xE4A2FC71, 0x00000080, 0x24BB4E35, 0x8EA802C3, 0x2ED7ED3B, 0xCB4F8EBE, 0x00000080,
            0x5F5CA228, 0xF4B87882, 0x2F452AD8, 0xEE69FDC6, 0x00000000, 0x238CC938, 0xA9259D2F, 0x3ABD3E61,
            0xC2D36266, 0x00000080, 0x44678AFB, 0x025EF53F, 0xEAEC5FC8, 0x9BD50E63, 0x00000080, 0x398838C0,
            0x2B106421, 0xE3BFA4F7, 0x6125B080, 0x00000000, 0xEF3F5508, 0x27ABDF73, 0x15FACBCB, 0xD16AD2C5,
            0x00000000, 0xF9CDBEF7, 0x5F35B3AA, 0x9130BDBF, 0x52307713, 0x00000080, 0x1E08C9B1, 0x3F233375,
            0x1BFA348A, 0xE13034A2, 0x00000000, 0xC97AD055, 0xDE8F794E, 0x36F4A491, 0xFBB6AF46, 0x00000000,
            0x6E80A64A, 0x88D81439, 0x4AB3D261, 0xB78CBD58, 0x00000080, 0x8FFE6231, 0x6BB75621, 0xCB7503EE,
            0x89D46AD3, 0x00000080, 0xF9127308, 0x415AFEA2, 0x0FAF8222, 0x9D70DFD3, 0x00000000, 0xF57B48CB,
            0x4114C09E, 0xCE542844, 0x8EE6B893, 0x00000000, 0xE10F7BC6, 0xB0E49DA4, 0xD3F59D85, 0x081F034E,
            0x00000080, 0xAA9C32D9, 0x7B394CA8, 0xE2D11514, 0x24E63F15, 0x00000000, 0xC98464DA, 0x9E825C84,
            0x58982925, 0x9026101F, 0x00000080, 0x7760BBD6, 0x6E73C527, 0xFA39B0B5, 0x35AC3842, 0x00000000,
            0x456C77F0, 0x95FAD235, 0x3C326786, 0x78E62865, 0x00000000, 0x59C21BC2, 0xBBD67E4F, 0x7D4D699F,
            0x0059FA27, 0x00000000, 0x99B82B01, 0xF16D50F6, 0xD3BC9EB3, 0x5FD9F4F1, 0x00000080, 0xF9AE2A8B,
            0x4D5C0B54, 0x305DB80F, 0x97E9B986, 0x00000000, 0x54FD5164, 0x19EDA98F, 0x934FF3B6, 0x2A044DB4,
            0x00000080, 0x35E720A8, 0x4B122DE3, 0x75446939, 0xAED93962, 0x00000080, 0x895DD5F8, 0x6C80E0ED,
            0xB48FA475, 0x80F6DAE5, 0x00000080, 0xEBF229C8, 0x5AFB028A, 0x7D0CF444, 0x7690503A, 0x00000080,
            0x8B64D188, 0x284FF67A, 0xE9212426, 0x490B181F, 0x00000000, 0x58F5CEC3, 0xB6CC15E4, 0x987283D2,
            0x32C2EC81, 0x00000080, 0xE36B1602, 0x0B736A57, 0x986946DF, 0xA6768ADF, 0x00000000, 0x86D34915,
            0x1E89F781, 0x009162E5, 0x8E88DA61, 0x00000080, 0x1D2FAA75, 0xCB9BCB17, 0x2B0016AA, 0x7FB0FEC7,
            0x00000080, 0x8C9C3F7E, 0x461D14E5, 0xCBD84FE8, 0xEE3ED30B, 0x00000080, 0x8C4179D2, 0x8E52C7A8,
            0xAB41E88D, 0x293EE0F6, 0x00000080, 0x3A419330, 0x03AB7154, 0x546BF347, 0xC949523A, 0x00000000,
            0x4CA605ED, 0x56CCBC51, 0xCCB363F6, 0x92F3DB9D, 0x00000080, 0xA87BE0F1, 0x9B4DD3D5, 0x0E04FAD1,
            0xED3579F1, 0x00000080, 0x4D9B02FE, 0x55FBD2B6, 0xE5DFBB2F, 0xDD91B0A2, 0x00000000, 0xCD645D7F,
            0x97770583, 0x12FB3A33, 0x4DCF60D8, 0x00000080, 0x544E39B5, 0xB85B49E2, 0xEC7EFDF1, 0xEFC96FFE,
            0x00000080, 0xCAFD9FF2, 0x6329CAFB, 0xF01CB8BB, 0x2A68143A, 0x00000080, 0x661C960B, 0x63E5663B,
            0xDEA16921, 0xB5918253, 0x00000000, 0x22915CD7, 0xD0F489EA, 0x81D17D76, 0x57307572, 0x00000080,
            0x8EB49903, 0xF4898508, 0xFE43B24D, 0xDFC45BE8, 0x00000000, 0x5F9FC43C, 0x7F7F03F6, 0xDFCC1EF6,
            0xBF072267, 0x00000000, 0x045A063B, 0x2C4D7977, 0x47181F8A, 0xE1EEC0DD, 0x00000080, 0x3BA077A1,
            0x1DAF730C, 0xACB70540, 0xC6D40D66, 0x00000000, 0xD2FFD0E9, 0x1BE5D7DA, 0xE6379062, 0x9BA59711,
            0x00000000, 0x07C02BA9, 0x4CA2D780, 0x4C10A036, 0x6CF9CB31, 0x00000080, 0x4EC1175E, 0x573C11D0,
            0x7AEF866B, 0xA2E6F1CB, 0x00000080, 0x9331EED8, 0x126D4020, 0x44D58A61, 0xCD7A933E, 0x00000000,
            0x49AD1F2A, 0xE48E17DC, 0xAD3CECDB, 0xA81D10F0, 0x00000080, 0x4622CC80, 0xE8526B26, 0x907741C6,
            0x3C06961E, 0x00000080, 0x3E2FC99F, 0x5F7331D8, 0x938647B6, 0xC789522A, 0x00000080, 0x69A26569,
            0x77A935E9, 0x3300D8A5, 0xFCCB15AD, 0x00000000, 0xBB3AF40D, 0x6073DECD, 0x2800939F, 0xE7466D7A,
            0x00000080, 0x66156F21, 0x3458510B, 0xB8E1ADF8, 0x746FA990, 0x00000080, 0x55798B55, 0xDB8205AB,
            0xB3D32980, 0x30EF7B98, 0x00000080, 0x2D7BE943, 0xBF6D43B8, 0x6F5FEDB3, 0xAD9C4CFE, 0x00000000,
            0x5CDC4271, 0x4B7D6C43, 0xE0D5FDD0, 0x565EB95B, 0x00000080, 0xE5C309C1, 0xC968E507, 0x5FAEBC62,
            0x6ACC2D5B, 0x00000000, 0xB647185B, 0x401F634B, 0x3D189438, 0x0BF0B18D, 0x00000000, 0xFEAC778E,
            0xCA0CFFE2, 0x0D58C083, 0x7398B71A, 0x00000080, 0xA51F0C25, 0x7CACC644, 0x0D7B4B8A, 0x490398CD,
            0x00000080, 0x8EB67B1E, 0x7212D915, 0x857C805B, 0x39ACA265, 0x00000000, 0xFAF2B5EA, 0x30B8A1C9,
            0xD6BC193E, 0xD059E6D7, 0x00000000, 0xAADB7521, 0x9DA82156, 0x4FB7B855, 0xF47C4282, 0x00000000,
            0x17470ED6, 0xEEF290DC, 0xC437CFFF, 0x205E1B6C, 0x00000000, 0x313ED9BE, 0xDE602B03, 0x0C8122F2,
            0xB90A4AA7, 0x00000080, 0xD9533591, 0xE74B8834, 0x6BE90F1E, 0x5D781965, 0x00000080, 0x5EE977DE,
            0x6E879AC7, 0x51DB01B0, 0xBE9509CC, 0x00000080, 0xB8D574A6, 0xCA39B147, 0x02A284B3, 0x9F84EB51,
            0x00000080, 0x6F1DA06B, 0xC8A2289F, 0x16816373, 0x783703A6, 0x00000000, 0x013E96A5, 0xDF257AED,
            0xBC39E57E, 0xB8CAB34E, 0x00000080, 0x9AE3E374, 0xFF640791, 0x78EFED56, 0x71FFAF47, 0x00000000,
            0xCCD2FE8B, 0x15DE11C2, 0x2FC84114, 0x771206E5, 0x00000080, 0x14F815FD, 0xED19A6E2, 0xD06275BC,
            0xCC77FB80, 0x00000000, 0x4AA5B6CF, 0x5C2F1B7D, 0x55CF0C1D, 0xC6242C87, 0x00000000, 0x0E6A1804,
            0x5FE42EFB, 0xA844BCF6, 0xFEDD6AEA, 0x00000080, 0xD297EB27, 0x2E1D78A0, 0xD8A15E5B, 0xC57F9E09,
            0x00000080, 0xE2C96F17, 0xF3B5541F, 0x105BE8BE, 0x892F06E5, 0x00000000, 0x1AA9BB82, 0x5A188CB1,
            0xE7DF83EB, 0x3D1E4F8C, 0x00000080, 0xC57BB7DE, 0x550F5C3B, 0xB678F058, 0xAC80C8B4, 0x00000080,
            0x90D790BC, 0x69EE4A7D, 0xF193E249, 0x1B241C52, 0x00000000, 0x4F016F33, 0xD8206610, 0x1B7BAD74,
            0x73927124, 0x00000000, 0x876B5970, 0x62825093, 0xBF76F84B, 0x39DFD461, 0x00000000, 0x48782DD8,
            0x4E912B91, 0xFC3D1736, 0x07350AC6, 0x00000080, 0xA2C50668, 0xE228F091, 0x9AAA4885, 0xE9325352,
            0x00000080, 0xFDEE129A, 0x28F1F94C, 0x14335DC9, 0x0CDFC69A, 0x00000000, 0x8249CE7A, 0xF11F4BA7,
            0x15BCF90E, 0xCA7E2D8C, 0x00000080, 0x7F4A990C, 0x2EDBB605, 0x478CC682, 0x23EE2BF2, 0x00000080,
            0x0957C014, 0xC5C3DF38, 0xDC719F43, 0xA046266C, 0x00000080, 0xE8985F9B, 0x0F3496CD, 0xF9F17320,
            0x8256D9C7, 0x00000000, 0xF2B5FBCE, 0xA3364381, 0x7C2D92F9, 0x64B78B4B, 0x00000080, 0x6319B17E,
            0xC3AE97BD, 0x2DAF19C6, 0x0C788FD0, 0x00000000, 0x911F7EB7, 0xE4F3A951, 0x36328B77, 0xAD19272E,
            0x00000080, 0xDE681E22, 0xDFC6C10D, 0xC9F7FBBB, 0x425F665A, 0x00000000, 0x4A4EB840, 0x082F1496,
            0xC05BA316, 0xCCEE4C60, 0x00000080, 0x332A258B, 0xD4049D2F, 0x80931A4B, 0x85548816, 0x00000080,
            0x9571160C, 0x655FE70A, 0x73782C1E, 0x577EEF05, 0x00000080, 0x54C51DEC, 0x340C47D9, 0xF7B34962,
            0x32E96FF8, 0x00000080, 0x579B1128, 0xFBA46599, 0x90156826, 0x2B062EA8, 0x00000000, 0x95E67EAC,
            0x8533B6F1, 0xC657239E, 0xE94C80ED, 0x00000080, 0x02F78630, 0x24F74D60, 0xD381020D, 0x57741A74,
            0x00000000, 0xCBC059EA, 0x3A1E4425, 0x21D4B260, 0x10DAE855, 0x00000000, 0xCBDDB68B, 0x136D378F,
            0x6996B5A5, 0x20371DFA, 0x00000000, 0x78F90625, 0xE0962930, 0x1B453EA5, 0x8466119B, 0x00000080,
            0x2056B9C1, 0xB236EE2C, 0x267B8BC4, 0xBD904993, 0x00000000, 0xA8ACA376, 0xE0A0F246, 0x90CE8B84,
            0x2CEA999F, 0x00000000, 0xAD8426C1, 0x9C268D10, 0x690B78BB, 0x3ADF618F, 0x00000000, 0x23D3757E,
            0x00115B2F, 0x1710CEA1, 0x1ADF45A7, 0x00000000, 0x9029AB55, 0x52739538, 0xDBFB29DF, 0xDC0DA367,
            0x00000080, 0xC5BF7DA2, 0x0F6C7668, 0xA89C082A, 0x0273B97B, 0x00000080, 0xDB96C310, 0x52C23F4A,
            0xE0105EA1, 0x1231FEC0, 0x00000000, 0x8C48CE8D, 0xB0E4A508, 0x4FA56088, 0x62A03FAA, 0x00000000,
            0x2D824F7D, 0x706D04DF, 0x2E514372, 0x1067251E, 0x00000080, 0xA5FCD8ED, 0xD89D6EE8, 0x81CED3AC,
            0x115C68B6, 0x00000080, 0x91703006, 0x348D4624, 0xE0517365, 0xC1CABE21, 0x00000000, 0x4A7A7EBF,
            0x403F2259, 0xF679393E, 0x52615D93, 0x00000080, 0xF816CBBE, 0x54F4EE77, 0x9BF49EEF, 0x4FB3977E,
            0x00000080, 0xA508BAC7, 0x28B8F3D9, 0xEE5617D0, 0xAB8FCCE6, 0x00000000, 0xF8D6BDEB, 0xBBC8E1E4,
            0xC88E37F1, 0x297DD80D, 0x00000080, 0xD7DDC5B8, 0x7FCCAB54, 0x4633E047, 0xF1DD701C, 0x00000000,
            0x1384E97B, 0x8DC7A5D2, 0xD50A06F2, 0xB28A752F, 0x00000000, 0xF07F45DC, 0xA3162144, 0xD864514C,
            0xD5C703AF, 0x00000080, 0xEBE05DE6, 0x91CE6FDD, 0x5F576D2A, 0xC009FE27, 0x00000080, 0xE2A18661,
            0xB2578B1C, 0xB4AF01F3, 0x107CB87B, 0x00000080, 0x5F99A5B1, 0x74C19944, 0x8B6053F4, 0xDF68ACF9,
            0x00000000, 0x86BBF1BE, 0xEBE28F8E, 0xFAA7C2CC, 0x1E7055B9, 0x00000080, 0x849F7720, 0xE26D315F,
            0x618D8854, 0x7B6BA42F, 0x00000000, 0x50D98651, 0x547D6B46, 0xA1ED155B, 0xC9F1268E, 0x00000000,
            0x9F6794B9, 0x4DEA8D98, 0x15FF7836, 0x7787EF84, 0x00000080, 0x870942A7, 0x70BCD0ED, 0x1FC2E1D6,
            0xB62C8F34, 0x00000080, 0xE511F6C0, 0xA9E6D0F6, 0xE33B32A0, 0xE8CEA9DC, 0x00000000, 0xC381DB94,
            0xA0B3CB7F, 0x58DF96AC, 0xBB6A2B99, 0x00000000, 0x412ABF66, 0xF8100E69, 0x88C81C71, 0x6004D833,
            0x00000000, 0x8456B3E7, 0x71B07AFC, 0x2A489121, 0xEA53D63F, 0x00000080, 0x42ADFAD3, 0xD0C308E5,
            0x4FFFCDEE, 0xF44051DF, 0x00000000, 0xB9BB108F, 0x7DB77B23, 0xB475FBE2, 0xB08BBF23, 0x00000080,
            0x0109D730, 0x1EF6C06A, 0x86E43C19, 0xE6F73E4B, 0x00000080, 0x67B3E6E9, 0x8DB8AA63, 0x92C9ABA9,
            0x42170AE3, 0x00000080, 0x01570500, 0xB93BB7EE, 0x7EE3410D, 0x287FD970, 0x00000080, 0x49F46AC0,
            0xDBFA4859, 0x881ED82F, 0xA09A72F2, 0x00000000, 0x7D203071, 0x0EF23018, 0xDD2378D6, 0x650F9D82,
            0x00000080, 0x7A8A0EF3, 0x3A4C9FC2, 0x87050C8A, 0xD5920192, 0x00000080, 0x7D7D77C8, 0xAD1E2163,
            0x428342B6, 0xC3CB33C8, 0x00000000, 0xC569A648, 0x7CDAB509, 0xE423B0FE, 0xCC4D33E1, 0x00000000,
            0x721D67D3, 0xEE6DD6C3, 0xC496DF65, 0x2BD64FCA, 0x00000080, 0xA24B04CA, 0xFBF4ADBE, 0x82D5AA09,
            0xF6DC060F, 0x00000000, 0x8A40E642, 0x640C52EE, 0xD4F9144A, 0xCD5223A0, 0x00000080, 0x4DBF52BE,
            0x51AC5188, 0x3FD46ABD, 0x8AFC91C7, 0x00000000, 0xB0AFD2CB, 0x60B472A7, 0xAD61BF68, 0x1CD47C48,
            0x00000000, 0x10EE2F3E, 0x59C927E5, 0x40063832, 0x09F51F8B, 0x00000080, 0xC9F4B0FC, 0xA52FC8F4,
            0x9A63F681, 0xA7E4E6A4, 0x00000000, 0x11BE550C, 0xF39F7331, 0xF7222F5C, 0x26DC9A58, 0x00000000,
            0xB21E3594, 0xF8D8E07F, 0xE8E4F2F6, 0x50A62732, 0x00000000, 0x788B901C, 0x17733FE6, 0xD3973E10,
            0xE68019B3, 0x00000080, 0x8F9BA46D, 0x40947B5A, 0xA2EE9490, 0x472746DA, 0x00000000, 0xDE93B16F,
            0xDBEE1CCB, 0x6358B1B4, 0x134EF2E3, 0x00000080, 0x4760D3D7, 0x959F9EA7, 0x4908A19D, 0x26C5697D,
            0x00000080, 0x1851080E, 0x06B07D5D, 0x6BA5616E, 0x16DAEFE0, 0x00000000, 0x4C7313BF, 0x8CBCC2A5,
            0x62327406, 0xBEAADF3E, 0x00000080, 0x60F85BBC, 0x1697982F, 0x5CA309DB, 0x9DA52DF6, 0x00000000,
            0x8574F674, 0xF98AE4BC, 0x562A5CB7, 0x10D7705B, 0x00000080, 0x463E7CE3, 0xA7C97437, 0xCB4E17C1,
            0x0E6954FE, 0x00000000, 0x59D8D62C, 0xD6DF1395, 0x740A5110, 0x3390026D, 0x00000000, 0xB7D4EB18,
            0x82A8E180, 0xA34F4B05, 0x2031CA6A, 0x00000080, 0xF43BA36A, 0xEBED6FBA, 0x0FF2BD3D, 0x9928EBAB,
            0x00000080, 0xCB7C480D, 0x4D7BB19F, 0x021EFC1B, 0xADA1905C, 0x00000080, 0x2F586776, 0x9E2EAFB9,
            0xF84E2813, 0x70C4ADE1, 0x00000080, 0x2149057E, 0xE9B23FE3, 0xC6119BAB, 0x9B99A601, 0x00000080,
            0x76C7222F, 0x817962BC, 0xFAE035AC, 0x7B478F83, 0x00000000, 0x547EB1E9, 0xF9112C15, 0xA4041757,
            0xD0EEB1BA, 0x00000000, 0xB5E7ADC3, 0x484D0539, 0x89200A6B, 0x16873668, 0x00000080, 0x3BB1F9D0,
            0x15830661, 0xF50C3D68, 0x6A36AA90, 0x00000080, 0xA4E56BDB, 0x5C295A64, 0x79A0FDA9, 0xE9E2635A,
            0x00000000, 0x396F16C6, 0xCB396FD4, 0x7CF788AC, 0x8BCD9E0E, 0x00000000, 0x4AC7FF34, 0xE07D9C0A,
            0xCBA9FF34, 0x3595608B, 0x00000000, 0x0CD0A055, 0xDAAF76D3, 0x8179ED7E, 0x212FCDCE, 0x00000000,
            0xA6EFF075, 0xB916A013, 0x63AC7C81, 0x0F8C326C, 0x00000080, 0x620A584B, 0xA8E78FDD, 0x291CD029,
            0x9374FCFC, 0x00000080, 0x6A97986C, 0xBBF8ADE4, 0x64C9037D, 0xA83AD6D5, 0x00000000, 0x19A5A003,
            0x9357C052, 0xF2F4FD33, 0x6240ED2C, 0x00000000, 0x3C39A8BF, 0xBB7DB043, 0x1DDE6920, 0x87F9F572,
            0x00000000, 0x1D0E147E, 0x61A6C559, 0xE32AE86B, 0xC46E9430, 0x00000080, 0xE6427D66, 0xCFCA9E5F,
            0xE2597F27, 0x386E1630, 0x00000080, 0x099A5C68, 0x89CD59C1, 0x6EDEA6B1, 0xA7922519, 0x00000080,
            0x473CC081, 0xB8919E56, 0x8A6F5B0B, 0x69733AC5, 0x00000000, 0xEA7A98B1, 0x0C94EDDC, 0xEAE9AB9E,
            0x0D00126F, 0x00000000, 0xA383C341, 0x311A8E06, 0x1755C49B, 0x451D33D1, 0x00000080, 0x247908B7,
            0x2B68A910, 0x1E913981, 0x60C89A06, 0x00000000, 0x1361456D, 0x2F4E4170, 0xB3FC7DA1, 0x5CBBD2E6,
            0x00000000, 0x4AC1AEAF, 0x715EEA88, 0xFDEBFE5F, 0xA9FD57B2, 0x00000000, 0x8A5ED6A3, 0xF0132B04,
            0xD58317C9, 0x3E674504, 0x00000000, 0x1E470359, 0xCB820206, 0xABB0BAA8, 0x1B8DDDA6, 0x00000000,
            0x7BBBF098, 0x21A3BEB6, 0x4C4004DC, 0xC1CBFC75, 0x00000000, 0x853D4634, 0x314FD3AA, 0x4E011F19,
            0x0F034548, 0x00000080, 0x466E9BB2, 0x49142EB7, 0x7A14AF54, 0x1534E4FB, 0x00000000, 0x2EBC5FFC,
            0x2D1FD729, 0x78A10F79, 0xADCAE825, 0x00000080, 0x39617068, 0x7479E484, 0xFC929600, 0x29DA0A1E,
            0x00000080, 0xED118D88, 0x9FA8A7F9, 0xA3C5807C, 0x41AD9CF3, 0x00000080, 0x3D4C501C, 0xAED56076,
            0x61255FED, 0x88D70570, 0x00000080, 0x8613CB33, 0x6AD01913, 0xF0C45BA4, 0x382E5DF1, 0x00000080,
            0xE0A242B1, 0x75F8BE6E, 0xBDA4C5F5, 0xC468AE1D, 0x00000080, 0x5425DB74, 0xEF4068ED, 0x8B2A6C5F,
            0xFA3DB1F6, 0x00000080, 0x2205BC98, 0x44BCE65D, 0xA26FB452, 0xCD2BD3A6, 0x00000000, 0x571ABC04,
            0x655ECDFB, 0x9C03AB90, 0x4CD9C3F8, 0x00000000, 0x31347CCD, 0x22ED13F3, 0x00F58E7E, 0xD1AB7DA3,
            0x00000080, 0x5751C948, 0x677385CA, 0x159742D2, 0xB44FB7F4, 0x00000000, 0x04FC3CCC, 0x22A9F313,
            0x7011D1E5, 0xAE68CCC3, 0x00000000, 0xCE32525B, 0xDCE9EFF3, 0xE2924EE9, 0x477A9780, 0x00000000,
            0xDA425A88, 0x4545F320, 0xD734A698, 0x55B03C22, 0x00000000, 0x505CB174, 0x51BBC0C6, 0x86D07539,
            0x8A0DFCB9, 0x00000080, 0xD3EB2F0C, 0xF4C2E2C0, 0x0CDBB9EC, 0x919A2931, 0x00000000, 0xDD456A38,
            0x20498D3D, 0x224A5DCD, 0x1FD5FDB0, 0x00000080, 0x4472439D, 0x823C069B, 0x7EBD8B0A, 0x044BB528,
            0x00000000, 0xCF27A598, 0x12735559, 0x6E36E752, 0xF12038B2, 0x00000080, 0x2FAC598A, 0x12BE9B9D,
            0xB9C64133, 0x9CE445B6, 0x00000080, 0xAC2730E3, 0x35EC43EF, 0x279BC42C, 0x0243D10E, 0x00000000,
            0x52187D2E, 0x291C7E5D, 0x17ABE0E6, 0x87751EC2, 0x00000000, 0x3DB7DC59, 0x81EBE6D6, 0x41C0837E,
            0xD3AF5CDA, 0x00000080, 0x0DCF1F98, 0xD13AFFAB, 0x57D7E0BE, 0x63ADABDD, 0x00000000, 0x23D54470,
            0xDEE57FCF, 0x7C2EF3D0, 0xDA3B8DBE, 0x00000000, 0xC1BE6695, 0x8654BD38, 0x9C8FFB6E, 0x8B8BFA04,
            0x00000080, 0x1415E04E, 0x293A7BEB, 0x6946DC97, 0xCD0DF717, 0x00000080, 0xB4AF7D5A, 0x8F7A8239,
            0x6E8A49A2, 0x6CA20247, 0x00000080, 0xB6238418, 0xF649C51C, 0x3A38314C, 0x0004BF24, 0x00000000,
            0x748B1585, 0xF0FA118B, 0xA41BFD54, 0xC2ACD7E6, 0x00000000, 0x6357EC1A, 0xA429A81A, 0xF1F1A6E9,
            0xD523D761, 0x00000000, 0xFDD6D3A3, 0x4A5FD0CC, 0xBCC009BE, 0x9294500F, 0x00000080, 0x54B69C93,
            0x71515181, 0xA47EA583, 0xBC3E9B08, 0x00000000, 0xDE628313, 0xDFCAE3E1, 0x15E5C2DD, 0x1A9F46CF,
            0x00000000, 0x3C4F072E, 0x26F684AD, 0xFEBDF289, 0x2F676391, 0x00000000, 0x31970D1B, 0x285BD43F,
            0xA8C0E494, 0x03CCA9EA, 0x00000080, 0x9CB968C6, 0x9DA5C38E, 0x23C59698, 0x677920E9, 0x00000080,
            0xE8C942AB, 0x6CFE7256, 0x420C7E7E, 0x1984E657, 0x00000000, 0x99E7B13F, 0x578D77C4, 0x80AE2CBF,
            0xC1119E63, 0x00000000, 0x81093470, 0x356B49F8, 0x69C4267C, 0x7B8ACB0D, 0x00000000, 0xD1DDFB6F,
            0xD73A0504, 0x7B2106A0, 0x1222A302, 0x00000000, 0xDC9A9D53, 0xA79A8089, 0xFC16A06D, 0x2F211D69,
            0x00000080, 0xA7E45B44, 0xF2CF9749, 0xED3BC962, 0x798CA68B, 0x00000080, 0x81AD18FF, 0x9FE8B905,
            0x7BCB59E7, 0xE861BD35, 0x00000080, 0xA9D0999D, 0x1FC6109D, 0xE586CBBE, 0x33C3511B, 0x00000080,
            0x9F0DEBAB, 0xC307F00F, 0xBE23887B, 0x9C581AA3, 0x00000000, 0x24E47A72, 0xEEDE99E2, 0x69EA3CE2,
            0x6D6B5BEB, 0x00000000, 0x3820F216, 0xFBF8D5F2, 0x3954FEB2, 0x1FDC9A4A, 0x00000000, 0x99F4406E,
            0xABD0CC74, 0x5DE84574, 0x8E46BA59, 0x00000000, 0x23BAF342, 0x0CBD6770, 0x824FD28F, 0x73F58F62,
            0x00000080, 0x48944D4B, 0xFF2229D0, 0x092ABA8D, 0xF36B6092, 0x00000000, 0xECDB342D, 0xA650B1CF,
            0x84B76E31, 0xC2937BFE, 0x00000080, 0x3DC3CC64, 0x33CC7CDA, 0x51D4DA04, 0xA9761AE8, 0x00000080,
            0x5EA51378, 0x8FD58F84, 0xBCB33B49, 0x0F746083, 0x00000080, 0x535690A8, 0x43A7B326, 0xA670A22A,
            0x2242A0A1, 0x00000080, 0xB2D7D9EC, 0x592C0120, 0x7910BA21, 0xB734BF6B, 0x00000080, 0xE3CFBF42,
            0xF744BE27, 0xBA2D6049, 0x5A0C9716, 0x00000080, 0x7153687E, 0x99DE7489, 0x17DF6A70, 0x1D919DA0,
            0x00000000, 0x0ADE9982, 0x85510492, 0x46CA3AD9, 0xF603CA3C, 0x00000000, 0x03F68DBD, 0xC4F1E7DC,
            0x1CF81C78, 0x4C54C1F5, 0x00000080, 0x171384B3, 0xAB382183, 0xD5F7480B, 0x51A1A1BB, 0x00000000,
            0x0F41824A, 0x7108084C, 0x5D720E18, 0xC1DDA59E, 0x00000080, 0x7803DAA8, 0xB3DA67BB, 0x8FF5102D,
            0x23F121FD, 0x00000000, 0xCC2AE9E0, 0xC70C98F6, 0xDF1C9162, 0xEB4DC3AF, 0x00000000, 0x025049A2,
            0x5B697179, 0x3F7F40F1, 0x37B3E3A2, 0x00000080, 0x599DD449, 0xCA842115, 0x83E79B5C, 0x93ABE12C,
            0x00000000, 0x758CB7A0, 0x036CADE1, 0x942A79CB, 0x42994D20, 0x00000000, 0xBC05ADEE, 0xAD3FB177,
            0xB3B99627, 0x8DA7A04A, 0x00000080, 0x4B317A59, 0x467496C4, 0x10628AFB, 0x2D2468C6, 0x00000080,
            0x6F052072, 0xBA305339, 0xF53E2E45, 0x367551EF, 0x00000000, 0xCA8DEF0C, 0xC0FA51B5, 0x89A9801F,
            0x959508CE, 0x00000080, 0x0464A582, 0x4E25A77A, 0x9CEB9D7B, 0xD21F07D3, 0x00000000, 0x3D33267E,
            0x1D118E3C, 0x9914F297, 0x19042E2B, 0x00000080, 0x032597D6, 0x33B5662D, 0xCB26BC1A, 0x9308D0F4,
            0x00000000, 0x69FDCC22, 0x9F464D57, 0x020782C5, 0x866A2035, 0x00000000, 0x6FB2DAD6, 0xA0612075,
            0xBE073191, 0x5B10B57C, 0x00000080, 0xA5C65407, 0xD9DB2B4F, 0x1D230CCB, 0xF9DC2892, 0x00000080,
            0x6A1F0871, 0x5A870DCA, 0x2123C740, 0x672EDBA7, 0x00000080, 0x5871C36C, 0x0A14FB02, 0x928E45B6,
            0xC736F6F4, 0x00000080, 0x40A66AEB, 0x11158281, 0x98ADA0C7, 0xA6936AD6, 0x00000080, 0xD091D983,
            0x2E7845C9, 0x160E845A, 0xFA3CC396, 0x00000080, 0xD9666871, 0x78AB9149, 0x69626EB8, 0xFD98219D,
            0x00000000, 0xBF2F2BBA, 0x766DE0EF, 0xD35AB9DD, 0x3E9628D5, 0x00000080, 0xBAB98F99, 0x8B9183CB,
            0x8CBDCB4C, 0xC3A7A71F, 0x00000080, 0x6BB93418, 0xE75C75CA, 0x1B11E9FF, 0xD44C1234, 0x00000080,
            0x6B681D5C, 0xF64CB8AE, 0x74C7E7A2, 0x3B101A99, 0x00000000, 0x16CAA46F, 0xC8D7AA06, 0x9625F875,
            0xADF8EBB1, 0x00000080, 0x5860D845, 0x409D684B, 0xE87B75DA, 0xFB48E4CA, 0x00000080, 0xF7745431,
            0x86693121, 0x20C97F91, 0x3F67CD70, 0x00000000, 0x94C892F4, 0xA6CABB6A, 0x9417A600, 0x72EE16FC,
            0x00000080, 0x82572E9C, 0x5ABD9DC2, 0xAA6F993E, 0xEB9E980F, 0x00000080, 0xE38DBFE2, 0xBCFEFFAF,
            0xB9DCBAC8, 0x06BE6C54, 0x00000000, 0x0A008A59, 0x394B32F7, 0x89EB8A4A, 0x45F8F802, 0x00000000,
            0xCCD7DA86, 0x1B366EF6, 0x695F1C29, 0x46E50CDA, 0x00000080, 0x7E27B593, 0x1AC7A9A1, 0x4D83030E,
            0xA5DDA398, 0x00000080, 0x4CA1BDF6, 0x9DD43E6B, 0x6B56D014, 0x180C50CE, 0x00000000, 0xDA64367D,
            0x996C8CDF, 0x0394E4FA, 0x0C969822, 0x00000080, 0xD361D3AB, 0xCA58E7BA, 0x427079C6, 0xDBB7083A,
            0x00000000, 0x9B355166, 0x796B5C0B, 0x401CE1CB, 0x7D4E47AD, 0x00000080, 0xC96FA211, 0x4A8E826C,
            0x15D07FDE, 0x9C442DE0, 0x00000080, 0xC8A2EB1F, 0x8CB091AF, 0x86B8DF52, 0xA8B4CA7D, 0x00000080,
            0x828147DE, 0x53DAA640, 0x7004DED9, 0x5FBE76D8, 0x00000080, 0x7EFB7958, 0xC9D9C86C, 0x1AE4F6B5,
            0x791032B0, 0x00000000, 0x6A122A2C, 0xE75564B9, 0xE339E602, 0x788E60CD, 0x00000080, 0x15665775,
            0x5DF91575, 0x002193CC, 0x632C0751, 0x00000080, 0x01ED2EDC, 0x70467BED, 0x3DDFC506, 0xFB849AF9,
            0x00000080, 0xD9C5328C, 0xE596B727, 0xA509E9D5, 0x32128168, 0x00000080, 0x5D085935, 0xD8CEC2BC,
            0xBDF4DC0D, 0x1112BDD7, 0x00000000, 0xB2A911B5, 0x1FA6EA50, 0xE1E08D31, 0x90A18854, 0x00000080,
            0x52AB0567, 0x2F63C309, 0xEF6DFB69, 0x0E4D9316, 0x00000080, 0x689AA379, 0x048D411C, 0x9BC2E0B3,
            0xD4D10532, 0x00000080, 0x0B41E73D, 0xF62BFA6F, 0xF104D531, 0x0DE07662, 0x00000000, 0x33205C23,
            0x0C69021E, 0x2013FB88, 0x13F5FA2C, 0x00000000, 0xE2CB01F7, 0xAA5E4516, 0x1A0657D2, 0x0ACD478C,
            0x00000080, 0xE7DB41C3, 0x40D9B7A5, 0x78F65192, 0xE192BAF3, 0x00000080, 0x78CD7AFA, 0xE5BC3251,
            0xC20DD5C2, 0x866A5BAA, 0x00000080, 0x2942463F, 0x4653F57F, 0xC2BAB444, 0x69C4B5F7, 0x00000000,
            0xAD28D08E, 0x78F9DB61, 0x1AB12C62, 0x9AF56821, 0x00000000, 0xE5F4162C, 0xFDA45DB3, 0x0BB61C19,
            0xF5EB2105, 0x00000080, 0x9516C034, 0xE01F8607, 0x66BECED8, 0x610B78A2, 0x00000000, 0x9F253FFD,
            0x95B59CAC, 0x339868A7, 0xE39541EA, 0x00000000, 0xF645E4CA, 0x64AD9039, 0xE0EF8CED, 0x80A66445,
            0x00000000, 0xBB46E8D1, 0xA567B5FA, 0x0D06AFFC, 0xA903704A, 0x00000080, 0x605327E4, 0xD7E04CF2,
            0xD73AA59C, 0x9019BF99, 0x00000000, 0xF40E2FE4, 0x00E67E1C, 0xDD7E16EE, 0xCCB6F91F, 0x00000080,
            0x60BBB5D4, 0x7AD2A9EA, 0xA4F5B254, 0x19F53302, 0x00000000, 0x1BE8D178, 0xA3B21AB8, 0xE00AC8C1,
            0x58329316, 0x00000000, 0xB840FD32, 0x9DBD507B, 0x8AB591BA, 0xCCE917BB, 0x00000080, 0xED45423F,
            0x6DC6FB0E, 0x6906B126, 0xE7923B5A, 0x00000000, 0x3D7F8D91, 0x77C62763, 0x7A829BFE, 0xC9E231BA,
            0x00000080, 0x4AA8CC8D, 0xBDB3A215, 0xAC61B530, 0xCBBAB0BB, 0x00000000, 0x74CD6578, 0x133CD87D,
            0x844FB30B, 0xFCA56779, 0x00000000, 0x88CB3049, 0x5CE5E722, 0xDBECB823, 0x008DB026, 0x00000000,
            0xD0EBFD76, 0x12FA7CF4, 0xE362163C, 0x5BBA7BE3, 0x00000080, 0x8CAF2E7E, 0x9D45E595, 0xD82C41AA,
            0x56D40F53, 0x00000000, 0xF0130F65, 0x026687F3, 0xB293A95A, 0x862AE035, 0x00000000, 0x67073233,
            0x11A45D9A, 0x5FA05F18, 0xE72AFA9F, 0x00000080, 0xB174CE20, 0xDAB1FFC3, 0x743BCCDC, 0xAF6A44EC,
            0x00000080, 0x665B1B4F, 0xA8C16A82, 0x4C9B6728, 0x9E46E22E, 0x00000080, 0x6DA1408D, 0x57AE2B88,
            0x9C595BD7, 0xB5893526, 0x00000000, 0x0656BF3D, 0xDE3E18EE, 0x89EA3DF9, 0xF945900A, 0x00000080,
            0xAF41146B, 0xC91F8B21, 0x83D1615E, 0xE1828AC1, 0x00000080, 0xBE7E4A38, 0xA61EE78F, 0x7AB2E9C1,
            0x13FB65E5, 0x00000000, 0x4D99C3A3, 0xC8188B9A, 0xEC8E17CE, 0xB3B68480, 0x00000000, 0x819EF1EC,
            0x92DFF656, 0xDBD2860A, 0x04024EC2, 0x00000000, 0xEF40E9E4, 0xB96EDBED, 0x799C3821, 0x29275490,
            0x00000080, 0x6CF73D3E, 0xD8D5F47E, 0x9A65882E, 0x80C1D7F8, 0x00000080, 0x85A08DDF, 0x24E76D8B,
            0x3170D489, 0x57E37B88, 0x00000080, 0x587087AE, 0x5B3DEE96, 0xDF6377EF, 0x1CB6B873, 0x00000000,
            0x5F29EB21, 0x8F563072, 0x7E0121C8, 0xF9AEF11B, 0x00000080, 0x2AEAF5E0, 0x55015400, 0x36394ADE,
            0x989EA939, 0x00000080, 0x5F297FEA, 0x9DB27FED, 0xFB7C5B54, 0x9AA52B61, 0x00000000, 0xFA34AD7F,
            0x7593E6F7, 0xFF4F3D38, 0x883DCDBC, 0x00000080, 0x812CB0BB, 0xEDC529D6, 0x3538F1C9, 0xD09CEA65,
            0x00000080, 0xE9E98224, 0xEBCAC836, 0x2E8A4B68, 0xF10B3934, 0x00000080, 0x5A54CF71, 0xF5FE854B,
            0xE820D939, 0x2ECF4BF3, 0x00000080, 0x44D8156D, 0x8E53B334, 0x68D22CB3, 0x9BF25E2B, 0x00000080,
            0x3D1B82CD, 0x34794DDE, 0x5E2FB109, 0xD8FB9366, 0x00000080, 0xE3880F08, 0x916B51E7, 0xC7939662,
            0xBFB20C62, 0x00000000, 0xD0370BC5, 0xB9BDF50F, 0x3AB1EF81, 0xE31963F8, 0x00000000, 0x6250424D,
            0x635263E2, 0x0C5667D5, 0x272CC8CF, 0x00000000, 0xCDE54BFA, 0x34DDE7DD, 0xB61338DD, 0xD113C4CC,
            0x00000000, 0x32FA6876, 0xBF3545CC, 0xE6A04059, 0x458D3871, 0x00000000, 0xDF15AE4A, 0xD288FEE3,
            0x38F3D7E0, 0xB3352AA5, 0x00000000, 0x7FF80118, 0xF369AEE8, 0xBE364D19, 0xD6C116BC, 0x00000080,
            0x6D735C92, 0x39F21FC8, 0x8B8D575C, 0xAD3AA78E, 0x00000080, 0xAD5E651A, 0x4FF0E1DC, 0x15A22F47,
            0x6011BB5E, 0x00000000, 0x1216EE6A, 0xE7DDA017, 0x27B13C83, 0x2E524999, 0x00000000, 0x5AFB6B1C,
            0x79E67290, 0xA59BD79A, 0x362C570B, 0x00000000, 0x018D7EF1, 0x5DF0CAED, 0x8BA43DA2, 0x42A0046E,
            0x00000000, 0xA55F6509, 0x0BE645B4, 0x0AF99889, 0x07E988EF, 0x00000080, 0x3EAFF684, 0x79B10979,
            0x00F1D4D9, 0x2DBC6CD9, 0x00000000, 0xE72C0E28, 0xBD2C163E, 0x273EE252, 0x65EA4C15, 0x00000000,
            0x04E181EF, 0xB5B8BEB0, 0x29BFAC86, 0x2E402CA0, 0x00000080, 0x126D9BA7, 0x4E09EC46, 0xBB401A28,
            0xBB6C7C20, 0x00000080, 0xE125D016, 0x2845ADCC, 0x0349D455, 0x420A972C, 0x00000000, 0x1C5401C1,
            0x304F8ECC, 0xC47FA97C, 0x77E90309, 0x00000080, 0x050C2CCB, 0x8761FEC0, 0x97615C70, 0xB1512B94,
            0x00000080, 0xEAE48B1A, 0x3F1C1361, 0xED03E88C, 0xF1A05FCB, 0x00000080, 0xFFA3B4FA, 0xDA1E7934,
            0x10D64169, 0x2E6AE084, 0x00000080, 0xA95130E5, 0xAEB9C717, 0xE3E39E41, 0x85507ADD, 0x00000080,
            0xA605B5D8, 0x8E92A1C7, 0x86FC48CD, 0x23DC7A25, 0x00000000, 0x2B264D21, 0x89A5183B, 0xC39EE2EA,
            0x3AD158CB, 0x00000000, 0x2CE29AA6, 0xC844CBB7, 0x4BE56B41, 0xDA8856E5, 0x00000000, 0xDDAEBF7C,
            0x71228A9F, 0x287058D9, 0xF7D54A16, 0x00000080, 0x58FEFF2B, 0xF615ED9C, 0x7FCAEB84, 0x3DDFEECF,
            0x00000000, 0x1A6B9799, 0xEC9959D4, 0xBD09453E, 0x58DF0739, 0x00000080, 0xB4FBE644, 0xDCB54F7A,
            0x1AFED6CD, 0x40F2872B, 0x00000080, 0xCBCAC9FC, 0x7EC86E54, 0x255328B3, 0xDB00E501, 0x00000080,
            0x046867FF, 0x1FBF4079, 0x5FACD01B, 0x5B94CEAD, 0x00000000, 0x1983CA36, 0xEE0DD9CD, 0x2719148C,
            0xA24935F4, 0x00000000, 0xB7B62C33, 0x79E20561, 0x71D55C93, 0x4D2807AC, 0x00000080, 0xBB575F0B,
            0x16D99DF5, 0x4CB46CDE, 0x0B1C0EC1, 0x00000080, 0xF38661DF, 0xBA9DF201, 0x13AA10B4, 0xD9F6F1B2,
            0x00000080, 0x9157E81D, 0x2BCF3157, 0xCCA97F69, 0x650A19D8, 0x00000000, 0x89575499, 0x694B8DF9,
            0xC6FE95CC, 0x9DB05852, 0x00000080, 0x1EE588FA, 0x8682499C, 0x217E9C7D, 0x65564117, 0x00000000,
            0x6E2B4AC3, 0xADA1E26C, 0xD66973CB, 0x7794D473, 0x00000000, 0x3216136B, 0x6D5D9200, 0x84563A3D,
            0x735B63D0, 0x00000080, 0x31CF5CBE, 0x2C44038C, 0xBAC97715, 0x18169D77, 0x00000080, 0xFA2DF91C,
            0x18FEA1E5, 0x8BB7E19F, 0x6CA826A6, 0x00000080, 0x26A49D15, 0x30A61411, 0x71D64800, 0x8B0E5890,
            0x00000080, 0x5B87B5D8, 0x346C1C0E, 0xE84A82FE, 0x34A47237, 0x00000080, 0xC1BB7617, 0x5E62E614,
            0x73A67F08, 0x43050833, 0x00000000, 0x54777C4D, 0xA7BE0577, 0x43221CE9, 0xA88031FA, 0x00000000,
            0x8D959179, 0x0F06702A, 0xF25A4130, 0x0BDC0E8D, 0x00000000, 0xA10699B1, 0x8A1DCBEB, 0xB67BDD1D,
            0x89A3E614, 0x00000000, 0x75D0440C, 0xEF372DFA, 0x0E99CEFC, 0xFC29F1BE, 0x00000000, 0x17A27262,
            0xC5787EA4, 0x11C1BF1B, 0x138DDDB2, 0x00000000, 0xAA0E71E8, 0x72FB9595, 0x1F093453, 0x2F579ECC,
            0x00000000, 0xD0C4117C, 0x058B6091, 0xDA468DDC, 0x6BC5B31F, 0x00000000, 0x94F6B3CC, 0xFD74BCDC,
            0xB7EBC3EC, 0x55B5E3D8, 0x00000080, 0xB79489A2, 0xC8C76334, 0x4280760E, 0xCA6EBB00, 0x00000080,
            0xAE4D6C3D, 0xD95E8D8A, 0x01BEA8F5, 0xA3987697, 0x00000000, 0x6CC59542, 0xFEB3E260, 0x32AD4C16,
            0x37E0DA21, 0x00000080, 0xF152441B, 0x4AF105E3, 0xD7EAB923, 0x6F78CA36, 0x00000000, 0x4968C217,
            0xD1F55A30, 0xB65571F8, 0xEA993807, 0x00000000, 0x47CFA2B1, 0xBCDD4596, 0xA8E558FB, 0x9C5FD60A,
            0x00000080, 0x3D42A6FA, 0xBB9B25C3, 0xE0E7F483, 0x7FCCD925, 0x00000080, 0x7F4BD317, 0xF34F22BA,
            0x4C098AB0, 0xD1E0991B, 0x00000000, 0xC77716A2, 0xA880CEC3, 0x0FAC76B0, 0xC2480181, 0x00000000,
            0xDC2716AF, 0xE351816A, 0x125A7C37, 0xDAF74D4E, 0x00000000, 0x22C5DD27, 0xD41584A0, 0x5F71409C,
            0x1F19D256, 0x00000000, 0x69FDCB81, 0x9741330D, 0x3FB9880C, 0x4F5B521D, 0x00000080, 0x859F7B33,
            0xB88C1292, 0x50615E72, 0x2600EB6B, 0x00000080, 0x3EC88899, 0x27FB2F54, 0x1794C830, 0x49FB6185,
            0x00000000, 0xF23FF497, 0x84127F50, 0x7CAEDE20, 0x79BD75EF, 0x00000080, 0xD6060824, 0x04F77538,
            0xF1FF1305, 0x34D93EA0, 0x00000000, 0x7186F653, 0x565D2C1B, 0x51831F99, 0x0D7DC95C, 0x00000000,
            0x39A1F09C, 0x4E080594, 0x1EF48CD5, 0x2191A42C, 0x00000080, 0x6B815BB5, 0xC2C8384F, 0x1DD1E468,
            0xFAB70817, 0x00000080, 0x5ECE1468, 0xA9F82061, 0xE7D38134, 0x66E9DC7A, 0x00000080, 0x66D868FD,
            0x22E4A8B7, 0x133C61F5, 0xA0E4AD76, 0x00000080, 0x5D8C92EE, 0x31BC9443, 0xE734CCD3, 0x84825498,
            0x00000080, 0x84CE6F25, 0xD3AB9B73, 0x26C2C4D2, 0x35FDC876, 0x00000080, 0x7E528845, 0xA6E9DDB9,
            0x2D42B0C6, 0x2396C420, 0x00000000, 0x83862496, 0x849A2804, 0xB8E423D9, 0xB0D53280, 0x00000080,
            0x7364F330, 0xB31565F5, 0x79180366, 0x95BA819A, 0x00000000, 0x717366C8, 0x550BF5EA, 0xB530BE91,
            0x833EBB9D, 0x00000000, 0x824D5D68, 0x44DA0B5E, 0x40FE9399, 0x52D88BB2, 0x00000080, 0x44795642,
            0x3E13F552, 0x24E7E806, 0xE60EADC2, 0x00000000, 0x09D587EF, 0xE5D84D4A, 0xF6AAF7EB, 0x03AF2007,
            0x00000000, 0xDB975570, 0xC4F18D35, 0xCC2EED46, 0x39EE80AD, 0x00000000, 0x6A4DB13D, 0x70A30D68,
            0x64754ADD, 0x8C88D3A3, 0x00000000, 0x1624E69E, 0xDCEF1A2C, 0x23CF182F, 0x6F97D883, 0x00000000,
            0x211D26EC, 0xEE4276DC, 0x3D4516BF, 0x2ED1BFB2, 0x00000000, 0x44EA1F62, 0x8AFAB373, 0x1852FBDE,
            0xD83B7FDA, 0x00000000, 0xC3199757, 0xFBD6D5DD, 0xB2E7967C, 0x903C8506, 0x00000000, 0x60C870D0,
            0xD58D81EC, 0xA83A06EA, 0x1C59BA44, 0x00000000, 0x8F3F3F5D, 0xC473DDF0, 0x9F46D601, 0xF11078B3,
            0x00000000, 0xF5D7EEAB, 0xDF92BEF1, 0x6BBDF99C, 0x2EB33BEE, 0x00000080, 0xAA4C428D, 0xF13E7EB3,
            0x62A1BBD5, 0xE6CE17D6, 0x00000080, 0xCAB97835, 0x5A681D5A, 0x8B0A6CFA, 0x6A2AA701, 0x00000000,
            0xFABAB15F, 0x9369D52B, 0x65D39EC4, 0x0C03FDDC, 0x00000080, 0x4D6AF272, 0x56EB321C, 0x54820531,
            0x9A1D13F3, 0x00000080, 0xE027EA31, 0xCB9171C6, 0x2AB9A311, 0xE731B0CE, 0x00000080, 0xA43DB8A3,
            0x544D445B, 0x129300F8, 0x3EAB4200, 0x00000000, 0x2275E67C, 0x0877B6A6, 0x8552538E, 0x34BFB879,
            0x00000000, 0x85798C03, 0x08C72763, 0x86AAE576, 0x3F6CB1C9, 0x00000000, 0x2A26ECA3, 0xD4EFE6D0,
            0x3485722B, 0x811021C5, 0x00000080, 0xB3681DC7, 0xEAE0B38F, 0x0E9E271C, 0x57E85EBA, 0x00000080,
            0x539162B9, 0x7E53AD3C, 0xCB6F21BF, 0x7D86CFC2, 0x00000080, 0x8940FB17, 0x55D6B4DA, 0xE73CE88C,
            0x9E180FBC, 0x00000080, 0x772A76F8, 0x940DA8D9, 0x35302117, 0x3AE677FE, 0x00000080, 0x96936AB1,
            0x0E726E54, 0x30EA7507, 0x51126AB4, 0x00000000, 0xBFD85730, 0xE8F9AF29, 0x2D709AD5, 0x2C12A3A6,
            0x00000000, 0x1A20D15D, 0x9BBD89BA, 0x47EE982B, 0x6479CED3, 0x00000080, 0xCE8562D3, 0xC4B46414,
            0x63C8ECDC, 0x875A3F5D, 0x00000000, 0x4F05D842, 0xA70FC085, 0xD2C801FD, 0xF94B0010, 0x00000000,
            0x0A2AD691, 0x259159DA, 0x304F47FD, 0xFC41A99F, 0x00000000, 0x33EEE418, 0xCE566B37, 0xF3F099C5,
            0xCE411DBF, 0x00000000, 0x96469314, 0x8B3292B5, 0x8C9E8CCA, 0x0BC9CDFF, 0x00000000, 0x9E746B57,
            0xDABD3380, 0x1DBFB834, 0x28997969, 0x00000080, 0xE9389DD5, 0x8130D68B, 0x5F20CFE8, 0xED680920,
            0x00000080, 0x0C3B2E3A, 0x3B9C7B6F, 0xD11D41CC, 0x2EFFCB83, 0x00000000, 0x9C3EFB1B, 0xF0931CFE,
            0x68586167, 0x3B42518A, 0x00000080, 0xA55A4980, 0xA983B0C0, 0x3EBC5B77, 0x4E8AC547, 0x00000080,
            0x47D27A5A, 0x72CB7590, 0x4EFD033B, 0xEDD2053E, 0x00000080, 0xFE3B21DC, 0x2C6B27CB, 0x84F0A6D3,
            0x3725201A, 0x00000000, 0x72339A05, 0xBFD31C9E, 0x8436D30F, 0x81F4EBF0, 0x00000000, 0x4A538CC2,
            0x258FFC40, 0x8D51914D, 0x0911079F, 0x00000000, 0xA36055E7, 0xCA391116, 0xFB7E7173, 0x0A28DF40,
            0x00000080, 0x0FC2BBA6, 0x142B4B8E, 0xBC390F78, 0xAF7FEA62, 0x00000080, 0x3CFFA0B2, 0x3335858E,
            0x03CC9348, 0xAFCBB6E7, 0x00000080, 0x51F6F07C, 0xC3C31B49, 0x09E7C704, 0xF67D27F3, 0x00000000,
            0x06D2954C, 0xE7D6E98D, 0xC5DBE2F2, 0x7910BF88, 0x00000080, 0x46DCA9BA, 0x0ED63B00, 0xF8481E3F,
            0xADB05815, 0x00000000, 0xBA4B95CA, 0xA1DE6B71, 0xE04B451B, 0xCE81483A, 0x00000000, 0x08532EC7,
            0x9942B9E5, 0x04472B15, 0xBC8D668E, 0x00000000, 0x43585742, 0xB15EAEFA, 0xB7612154, 0xE15611DC,
            0x00000000, 0xCDE3C229, 0x6D0C4368, 0xFAD065CD, 0x2CEFE6D4, 0x00000000, 0xECD033B5, 0xE0D8E8F6,
            0x89B2D94C, 0x3BC8FC10, 0x00000080, 0xB260CC59, 0x2AC5DDAE, 0x2C456EDC, 0xC8411DE7, 0x00000000,
            0x189915B9, 0xA823F213, 0x44BFE61C, 0x9939FA3F, 0x00000000, 0xA5B93495, 0xE1C7DF97, 0xA632A92A,
            0x7D1FC04D, 0x00000080, 0x09E07A4E, 0x9AAA9D85, 0xF31BF56F, 0x0CB3A86D, 0x00000080, 0x69A8EDEE,
            0x6917FCC6, 0xAF56E3F1, 0xDF0A4561, 0x00000080, 0xC148A3D0, 0x04B88364, 0x0E6138F3, 0x044E7612,
            0x00000080, 0xAFDDA715, 0x58A503AB, 0x3288DBDC, 0xD779BFDA, 0x00000080, 0x16CC410A, 0xA8AB5199,
            0xB94FE79B, 0x4C52C74B, 0x00000080, 0x8F183F85, 0xFA98B001, 0x6F5BFF2D, 0xB57CE8E7, 0x00000080,
            0x6C59985C, 0x6C9CBA9A, 0x22DD755E, 0xDC954FCA, 0x00000000, 0x9C2F3294, 0x1DFC1014, 0x90583C10,
            0x24BE174B, 0x00000080, 0x1EF24791, 0xDF0BBF08, 0x60E669BB, 0x48C9660B, 0x00000080, 0x1A5BE313,
            0xFAB739FB, 0x6D69F46C, 0x7136DF68, 0x00000000, 0xF4F73A12, 0x19A64A86, 0xC3F6E623, 0x55F6ADE2,
            0x00000000, 0xF3E74F11, 0xF5A36FC7, 0x7A8DBFB2, 0x5300B81E, 0x00000000, 0x47D73ED5, 0x53C423BB,
            0xFC198B4F, 0x472EB5D6, 0x00000080, 0x68960017, 0xB77012C1, 0x4C2CD7B3, 0x1AFC2D54, 0x00000000,
            0x49E02826, 0xE2CA13A5, 0x5F9F1D64, 0x253489EF, 0x00000000, 0x223DC6BC, 0xCE3C779D, 0x41C96C5B,
            0x290F2599, 0x00000000, 0xBB7CBA7A, 0xE6B43E64, 0xA46F05D8, 0xF0BDCBEF, 0x00000080, 0x9FAF3744,
            0x4A7DCAC6, 0x56A98C48, 0xF899D74D, 0x00000000, 0x61BF272F, 0xB27FD3ED, 0xEDEC7D7E, 0x255099DB,
            0x00000000, 0x5D23D91E, 0x18E0A129, 0x4B8BDB5F, 0x2C44287E, 0x00000000, 0xF96AFE7B, 0x2839BAA6,
            0x2DF673EB, 0xFBF1F89A, 0x00000000, 0x97C561CA, 0xA0F20593, 0x7DD442C3, 0x79B677DB, 0x00000000,
            0x2D5A1749, 0x3936E8A9, 0x9A2C9DAF, 0x67B8773D, 0x00000080, 0xA1CF8696, 0xC3519247, 0xBBFCFAC2,
            0x4CCA2E73, 0x00000080, 0x070196D4, 0xB4F5D0D4, 0xA6E09F54, 0xC82B0C48, 0x00000080, 0x2EB00F62,
            0x0A64A9C4, 0x0250A113, 0x972272B3, 0x00000000, 0x1F0DB6CF, 0x78DF0FC9, 0x49C2667B, 0xC55880A3,
            0x00000000,
        };

        /// <summary>Length: 645</summary>
        private static readonly uint[] s_keyMatrices_inv = new uint[]
        {
            0xED2D8EF2, 0x521C8B52, 0xFC69CB91, 0xEEC0E263, 0x00000080, 0xAD948C63, 0xD7BB938F, 0x5D780303,
            0x9F31B411, 0x00000000, 0xB30C085B, 0xEE084E4D, 0x95C6B060, 0x457CE724, 0x00000080, 0xE6EAAB67,
            0x54E539B9, 0x600BAB1A, 0x7A6F0A5E, 0x00000000, 0x2A6976AF, 0xAEF9A0DD, 0xD2023098, 0x5E8C62B7,
            0x00000000, 0x5E386B7F, 0x8F5B1E16, 0xE7D944F7, 0x7B523B51, 0x00000080, 0x221050A0, 0x9A1B25D9,
            0x0907B535, 0xC1B8BF37, 0x00000000, 0xB4DB8266, 0x033D2A0B, 0xA69B8659, 0xD1B3A50C, 0x00000000,
            0xB7088DFF, 0x2EA18835, 0x51A765E9, 0xAE6111C0, 0x00000080, 0xB97C8FC7, 0x4887F0A4, 0x1799C0EF,
            0x1A54B554, 0x00000000, 0x81067423, 0x162ABCAB, 0x14A90DE1, 0x48994E40, 0x00000080, 0x16B5B4E1,
            0x4FCDE939, 0x1D1251D2, 0x5A9A8500, 0x00000080, 0x6AE0F086, 0xFA390455, 0x01D0B5EC, 0x9217B3B6,
            0x00000080, 0x7C80D69B, 0xD74D87FE, 0x92177453, 0x2B520D69, 0x00000000, 0x2E79DAF9, 0x3CF9091F,
            0x5A59EE91, 0xD1F5EFC6, 0x00000000, 0x50426C6B, 0x1C86DB59, 0x5056877C, 0xAD954268, 0x00000000,
            0x0A394F05, 0x3BCF2580, 0xDCB6CE27, 0xECB12D72, 0x00000000, 0x4FF9DC08, 0xCB87081E, 0x22A2E744,
            0x79A60403, 0x00000000, 0xA45D6306, 0x0C9D9CD6, 0xE994CA31, 0xF4099E47, 0x00000000, 0x9C13B291,
            0x4180A55D, 0xB9EFB99F, 0x45DDC8DC, 0x00000000, 0x81803532, 0xBBBE5B98, 0x9DACE8C8, 0x3A75CC88,
            0x00000000, 0x54B31B1D, 0xEE38D0AE, 0x827B3D74, 0x6D321FD7, 0x00000000, 0x8ED0DE45, 0xAD826393,
            0x94B56A9B, 0x02477F81, 0x00000000, 0xE913708B, 0x1BA87E67, 0xEEF32A93, 0x53166E65, 0x00000000,
            0x289DF621, 0x9DDF0AF8, 0x6A559A69, 0x622A85B9, 0x00000000, 0x1FE4CF40, 0xA1AC53E7, 0x96D9002D,
            0xCF924633, 0x00000000, 0x9113270F, 0x553DDC36, 0x09122A22, 0x8DEC7740, 0x00000000, 0x3F5DB0D2,
            0x183B86BA, 0xED4F86AC, 0xA0174766, 0x00000000, 0x4F9A7CF7, 0xF3119D73, 0xE7523AA6, 0xFB064A8C,
            0x00000000, 0x9A515BD5, 0x974B0F2D, 0x2E10B7B9, 0xE99AFA63, 0x00000080, 0x400481FF, 0xE7F72858,
            0xE6127F97, 0xDB3397B4, 0x00000080, 0x162725E0, 0xA3919AA4, 0x09A47C08, 0x52748ABB, 0x00000000,
            0xF8CEE7E1, 0x7D030A7B, 0x08899E42, 0x931AB9C6, 0x00000000, 0x0F88BD2F, 0x4EF591DE, 0x8B6AAB1C,
            0xA77E25CB, 0x00000000, 0x54E4304B, 0xD54E6683, 0x1DBFC991, 0x76936544, 0x00000080, 0x330610B5,
            0xD3724618, 0xF1D68C8B, 0x14AD5C9F, 0x00000000, 0x00174FEC, 0x0AB8C38A, 0x210D4AD2, 0xC006CD1D,
            0x00000080, 0x38E8B857, 0x1852AE97, 0x063E2264, 0xF67DD535, 0x00000080, 0xCC92A974, 0x73976F07,
            0xE7FEF012, 0x8DDE3318, 0x00000080, 0x4469AF2B, 0x31578712, 0xC8078693, 0x411F236A, 0x00000080,
            0x801D5559, 0xF5A67A72, 0xA1979C7A, 0x18603823, 0x00000080, 0x2417BA5B, 0x75445601, 0x96DEF14C,
            0xE570C07B, 0x00000000, 0x310AE5F3, 0xD0B25144, 0x216DD101, 0x790BB895, 0x00000000, 0xF6462BE9,
            0xB065BE42, 0x3B0CA48C, 0x66ACFBDB, 0x00000000, 0xC604311C, 0xA2E2B8C9, 0x3D649C4B, 0xB66FC93C,
            0x00000000, 0x8BD9A7E0, 0x97547631, 0xE3FF9A26, 0xD10A2161, 0x00000080, 0x7E0C3849, 0x3175E66C,
            0x2B279F63, 0x57CB67B5, 0x00000080, 0x3CB710F4, 0x49F29F11, 0x430F6620, 0xC95BEDF0, 0x00000000,
            0x5B0690A3, 0x44FEC964, 0x06222339, 0x9B119FE2, 0x00000000, 0x861E0A0D, 0xBE75CE24, 0x1A5EDD92,
            0x68CF2B2A, 0x00000080, 0xED52F31F, 0xEBD384ED, 0xE1CEFB8E, 0x64A0A203, 0x00000000, 0xCC80B024,
            0x43E631B2, 0x420FDA04, 0xD82DCE5E, 0x00000000, 0x146B79EC, 0xD89E9175, 0x8F97A8F9, 0xD6C0170D,
            0x00000080, 0xD2BD8F06, 0x1DA09E04, 0x40D962B1, 0xD1018B88, 0x00000080, 0x9F4AE920, 0x5A0F451E,
            0x1E18A7B5, 0xD75FD28F, 0x00000000, 0x8EB92D8F, 0xD445E0A5, 0xF83B3AC5, 0xBCE8D159, 0x00000000,
            0xB664B86E, 0xAFB7B348, 0xC87E2D31, 0x2D899214, 0x00000080, 0x594AB20E, 0x3B50F64D, 0xBB7E93E2,
            0x8A995AF4, 0x00000000, 0x4C9E3A6F, 0xA42DFC8C, 0xCD17DEB2, 0x3E708846, 0x00000000, 0x371662F4,
            0xF7265386, 0x9563B70D, 0x484D4A77, 0x00000080, 0xAF2E2CED, 0x85A11021, 0xE0051904, 0xDADD0EDE,
            0x00000080, 0xB529C858, 0xD5AF3877, 0xBF95A98C, 0x23067A11, 0x00000080, 0x350914D2, 0xD43D2F31,
            0xD4FA0C37, 0xD57D8E69, 0x00000080, 0x4F1943F5, 0xD6384146, 0x9570AB5E, 0x74E6D64B, 0x00000080,
            0xE116BEDC, 0xB77206C4, 0x6FF2EB4B, 0x7C4CFCB5, 0x00000080, 0x99616485, 0x75DC8401, 0x9ECEEA5B,
            0x581EBA64, 0x00000080, 0x95E0D49E, 0x3309B41B, 0xE77E7B3F, 0x80230AF7, 0x00000000, 0xEEEB8E78,
            0x2CC61817, 0x33925A42, 0xE66B7979, 0x00000000, 0xEAB48B12, 0xD7D07E83, 0x39DFF91A, 0x02FDA1E0,
            0x00000000, 0xCF68D10C, 0x8E42B36C, 0x0F3615D5, 0x0368A4FB, 0x00000080, 0xA9A395F7, 0x459615B3,
            0x3C666AC3, 0xF7E94CE1, 0x00000080, 0x361BF734, 0x5844E158, 0x403B70DB, 0x1712B1B6, 0x00000000,
            0xF257DA90, 0x5C6C01EF, 0x1DC5E0A1, 0xE84D7A8E, 0x00000000, 0xC836957C, 0x011E9E09, 0xCC5CD700,
            0x00DD787E, 0x00000080, 0xAD81CBEB, 0x338BD387, 0x132C23F7, 0x90D0BEFA, 0x00000080, 0x17295E75,
            0x86E1C1E6, 0x3EFE72FA, 0x156229EC, 0x00000000, 0x5B87245E, 0x942BF9AE, 0xE29AE2E8, 0xF20505F1,
            0x00000000, 0x64704B6F, 0x52CFECB9, 0xC2E1F0E9, 0x70ED9A6F, 0x00000000, 0x787F3A2C, 0x6DBD111A,
            0xFECB442F, 0x1F6AC612, 0x00000080, 0x60AF25C4, 0x2F4D95EB, 0x6D065462, 0xD45D6BAA, 0x00000080,
            0x07F3225E, 0xFD2175C1, 0x7ABFB00E, 0xFF0B96CB, 0x00000080, 0xC2176D2F, 0x5B9FD86E, 0x4C2A9688,
            0x1D04928C, 0x00000080, 0xA2384D29, 0xFE291A4D, 0xB8374C38, 0xE4F94856, 0x00000000, 0x50B115AF,
            0x088EB736, 0x5E73CB27, 0x632D62C6, 0x00000080, 0x66833683, 0x6C5ADC09, 0xCB588815, 0x43B37E4B,
            0x00000000, 0x266D6776, 0xF0DC5F0F, 0x4558345C, 0x97D20BCD, 0x00000080, 0x961CA534, 0x81FF4070,
            0xA3E949A6, 0x7B88C828, 0x00000000, 0x074158B7, 0x792246D6, 0xA6F35A62, 0x10508036, 0x00000080,
            0x9A854252, 0xE0DEB474, 0xCFA4F18E, 0x7BBB8B14, 0x00000000, 0xF7DB8C4F, 0x1C9F4224, 0x9AE09E41,
            0xF089141A, 0x00000080, 0x1EB3FB2D, 0xA307FDCC, 0x492886BA, 0x09439750, 0x00000000, 0xC373148B,
            0x974078AB, 0xFB3F2C99, 0x5C68FF4B, 0x00000080, 0x8C09BDC0, 0xB6B0D5B8, 0xC2D9018F, 0x91779BB8,
            0x00000000, 0x207046BD, 0x2E594B17, 0xB593F314, 0xC735BBB9, 0x00000000, 0xC9B3569B, 0xA6967B05,
            0x0DFD4A35, 0x84060742, 0x00000000, 0x47DACD19, 0x72EA77F3, 0xD2084D5F, 0x32098E96, 0x00000080,
            0x46BA6804, 0xCDEBBCD8, 0xF9C03914, 0x1D65F6DA, 0x00000000, 0x04AF18F7, 0x5BA88EB4, 0x516AC479,
            0x86265993, 0x00000000, 0x1125F0F9, 0x4EDF68E8, 0xF0557F7B, 0x34703CD9, 0x00000080, 0xCAF920E0,
            0xE135F228, 0x1772BB5E, 0x0C1C14C4, 0x00000080, 0xE9B365E5, 0x3D3AD351, 0x43179EB1, 0xBA6903A3,
            0x00000000, 0x863C0DB5, 0x0A1066C4, 0xE9DF473E, 0x82B59B3F, 0x00000000, 0xCD7AC530, 0x8FEC2F28,
            0x9F54D68D, 0xFDCBBC7A, 0x00000080, 0x02B958AC, 0x33E44EF3, 0x2E2F7C87, 0xF3F718FA, 0x00000000,
            0xC568C549, 0xB01FFA72, 0xE7C914CD, 0x225E1574, 0x00000000, 0x1FB879CE, 0xEDFABD04, 0x80CBB601,
            0xFA42B8AB, 0x00000080, 0x10339833, 0xC52B7B7D, 0x1B7B6B33, 0x5C6C717C, 0x00000080, 0x9335A9F9,
            0x64F3A08C, 0x6603C833, 0x230E228F, 0x00000000, 0x5ED4C593, 0xA80163B0, 0x60104E31, 0x8B7A2F7D,
            0x00000080, 0x4661EFDE, 0x0460E777, 0x786F0680, 0x1A8C00A3, 0x00000080, 0x58438788, 0x02E31DC6,
            0x3FE33FDC, 0x9836B090, 0x00000000, 0xE4FED4BF, 0x96A40021, 0x43A58D42, 0xBFE513A2, 0x00000080,
            0xD675BDA2, 0x902B93B6, 0x53871948, 0xE6765DEF, 0x00000080, 0xE1974111, 0x31789F10, 0x572E249F,
            0xAD866AEA, 0x00000080, 0x0BC70824, 0x4F6E49A8, 0x6F2F3E1B, 0x2911F7CB, 0x00000000, 0x3DBF3C70,
            0x5367EB80, 0x93BC8494, 0x8483CA95, 0x00000000, 0x2C4D8D1C, 0x79418738, 0xD5AEF5A5, 0x85887474,
            0x00000000, 0xB40A2A68, 0xC4E6B04E, 0x41F9FC12, 0x1C37C10A, 0x00000000, 0x61F9AD87, 0x6FA77A41,
            0x4F1221A0, 0xFD58A32C, 0x00000080, 0x3B6E9D5F, 0xB8C0F4CB, 0x8024716B, 0xADCDAEEA, 0x00000000,
            0x972CAB2D, 0xE4B28CC7, 0x7E591861, 0x04615121, 0x00000080, 0xA0A70887, 0xB208CB10, 0x8925300E,
            0x56739BD8, 0x00000000, 0xDA5FF0E9, 0xDB9EA896, 0x07C2FFE5, 0xE884D433, 0x00000000, 0x1BBD2713,
            0x275F1F6A, 0xF33AA367, 0xB4B15AD1, 0x00000080, 0x5155C408, 0xDFD59348, 0x33095338, 0x0DA47F51,
            0x00000000, 0x3C4A6393, 0x3998FD98, 0x593A1812, 0x3CD8CC22, 0x00000000, 0x86167F26, 0x52B56D64,
            0xB3CF21F9, 0x660FB6BC, 0x00000080, 0x6B72822F, 0x998F9514, 0x4C68237C, 0x627954E9, 0x00000080,
            0x56A1ACF1, 0x7EA629F0, 0x53D1727E, 0xCB6912AA, 0x00000080,
        };

        /// <summary>Length: 2580</summary>
        private static readonly uint[] s_linearMatrices_inv = new uint[]
        {
            0x2ADDF10F, 0x04E7B469, 0xA7EC0534, 0xC12BA7F5, 0x00000000, 0x7EB996D9, 0x18816F33, 0x80920B23,
            0x8A66D24F, 0x00000000, 0x1C102BCD, 0xE4A6CECF, 0x3703A277, 0x5B650076, 0x00000080, 0x301880CE,
            0x366609B9, 0x7EF8A0B4, 0x8C921585, 0x00000080, 0xF18130E1, 0x9AF7B185, 0xBC9F4E45, 0x6731418C,
            0x00000080, 0x4D9FA4AF, 0x74ED11E5, 0x0F0E6919, 0xC5C6ECB1, 0x00000000, 0x7256F5B0, 0x573D11F5,
            0xB861FD23, 0x512BF893, 0x00000000, 0xF53AFA16, 0xB4211265, 0xEA0AC629, 0x0A8ACAD9, 0x00000080,
            0xD47ED53F, 0x2ED04185, 0x83F584AA, 0x12AE7127, 0x00000000, 0x577644AE, 0xDC0CB907, 0x141EA9A3,
            0x503346B8, 0x00000000, 0x327A01BA, 0x300F593F, 0xAFB7FD61, 0xAABA3B7E, 0x00000000, 0xABFF3225,
            0x48DDA1A3, 0xE49DB690, 0x4BA7A672, 0x00000000, 0xBBF4C00C, 0xB8A90C53, 0x44760ECF, 0xA4CCA942,
            0x00000080, 0x7E623B55, 0xDD1E571F, 0xD67FCBCE, 0x6ED84F9B, 0x00000080, 0x7C6DA0B3, 0x08F8CF55,
            0x31BB9BF9, 0x91DC99CA, 0x00000000, 0x09D695BC, 0x0EFF547C, 0x0244FB4F, 0x3CE0D6AF, 0x00000080,
            0x98453C68, 0x0037AA3F, 0x6C492372, 0xE98CF542, 0x00000000, 0x50CBBF3C, 0x05D542A2, 0x8DC16D2B,
            0xA837D31F, 0x00000000, 0xABF23264, 0xB2C4A17F, 0x02A2A579, 0x76B48ADD, 0x00000080, 0xA8C84430,
            0x2E2AE2A7, 0x352E3757, 0x296FCAAF, 0x00000080, 0xA03AB5B4, 0x05E85A9F, 0xB58E81E1, 0xCFE317B5,
            0x00000080, 0x4678532C, 0x024EC949, 0xEA8E1B9A, 0xC5A90872, 0x00000000, 0x5BF26E4C, 0x4CFF4FB4,
            0x3E86A2E6, 0xDECD5657, 0x00000080, 0xBF0EB849, 0x6CA08069, 0x16DF86F2, 0x212265FF, 0x00000080,
            0x278D8FF9, 0xA8D98A54, 0x9A625B5C, 0x16EBFA68, 0x00000080, 0x037928E8, 0x8B69A78F, 0xF8084366,
            0x161E0E12, 0x00000080, 0xA8E9E090, 0xF7058955, 0x9F71C800, 0x0201DC94, 0x00000080, 0xDD0FB114,
            0x14DB53F8, 0xDF8DEF2B, 0xD0BF5872, 0x00000080, 0x195899A8, 0xB1F56B61, 0xB0147439, 0x600DA8E7,
            0x00000000, 0x09031ADB, 0x86ED3EFF, 0xCB084076, 0xBC72D43F, 0x00000080, 0x29C7513E, 0xA67A434B,
            0xB466EAD5, 0x56947DCC, 0x00000080, 0xE164025C, 0x18B3E923, 0x0E978EEB, 0x3594728C, 0x00000000,
            0x2DFF5822, 0x2C652597, 0x2914A23A, 0xFCF1469F, 0x00000000, 0x2886E4AC, 0x14D4AE33, 0x1FFBD5CF,
            0x5F164B5B, 0x00000000, 0x23CE8871, 0x274C90F7, 0xCD922FC6, 0x227BF477, 0x00000080, 0x43FE3949,
            0x8B2D3ABE, 0xD95ADA73, 0x6629EE61, 0x00000000, 0x0D162252, 0x7DD6EE7D, 0x7A7D06B1, 0x8D9AC2EF,
            0x00000080, 0x4CCA2A73, 0x726B551A, 0x5A0C7424, 0xA380FA3A, 0x00000000, 0x01AA4436, 0x5A5E48FC,
            0x973BC74C, 0xD7260BC5, 0x00000000, 0x94A239DF, 0xB96496DD, 0xB9BDDB85, 0x72991C26, 0x00000000,
            0x873DC1E6, 0x7651DCF4, 0x79E0A6C5, 0x24D80138, 0x00000080, 0x5E733636, 0x6A7DF27A, 0xC827EDEB,
            0xCF73E2C2, 0x00000080, 0x6C2D7E4A, 0x3019777E, 0xA9DE0C38, 0x46FBB0BD, 0x00000000, 0x23233E61,
            0xF06DBBEB, 0xF1C44E10, 0x6DCE1D4D, 0x00000000, 0x448D3229, 0x10D3AE77, 0x25986E7B, 0x5F75947B,
            0x00000000, 0xB0159C72, 0x509982CC, 0xE1164C5C, 0xC25D0397, 0x00000000, 0xB4B1B335, 0x80101D25,
            0x563C2473, 0x2172B463, 0x00000080, 0xF1E4FA67, 0xB7690B99, 0xBF9A4163, 0xB9501BEE, 0x00000080,
            0x7BB43633, 0xC4DC494A, 0x31C4CD40, 0x6EF7AE17, 0x00000000, 0xEA7AC062, 0x27AF2FCF, 0x6CA5681D,
            0xECDEE3CC, 0x00000000, 0x4901C86D, 0x02E457FA, 0x4A1EB8E1, 0xD317F406, 0x00000080, 0xD14B387F,
            0x45B9E9E6, 0x78921D93, 0x44E393CE, 0x00000000, 0x5B8CE808, 0x5DA637A3, 0xE2DEA3C7, 0xAA029429,
            0x00000080, 0x082A0C46, 0xD8E4E6C2, 0xE3360630, 0x21ADFBE2, 0x00000000, 0xDF79DB51, 0x8F7AA648,
            0x3B410528, 0x17229859, 0x00000000, 0x555E721E, 0xA72261B3, 0x9E1B34D7, 0xD333271B, 0x00000000,
            0x7700E0C7, 0x2F3B45F8, 0x6EA5835E, 0xCEFC4EFD, 0x00000000, 0x1EFB408B, 0x29A65DE4, 0x51719399,
            0xCE5B0744, 0x00000000, 0xE94AF220, 0xA7BB72C7, 0x4EBC6156, 0x1B5AE982, 0x00000000, 0x54A841B2,
            0x5B3BE5E2, 0xA685D894, 0x7A103A5E, 0x00000080, 0xD61F7173, 0xA64543C2, 0xF8DD00F2, 0xA877A7A0,
            0x00000080, 0x7C3C565D, 0xC0587C64, 0xE0C34500, 0xDE98052A, 0x00000080, 0x8A5BE122, 0x3829622D,
            0x502E7DA3, 0xDFAD9783, 0x00000000, 0x3F8D9589, 0xA003A988, 0x0E094393, 0x2C064DD4, 0x00000000,
            0x2C4E9CED, 0xEE85B733, 0xB007B252, 0xCE306C39, 0x00000080, 0x7C15D36A, 0xD44CF516, 0x2C2CCAB5,
            0xC8EC2D1B, 0x00000000, 0x99CE0B4A, 0x16FFB365, 0x061C8A9D, 0xB9036B2E, 0x00000080, 0x0A94CE2B,
            0xF73C81E3, 0x1FDD40E9, 0xF73DD1AF, 0x00000000, 0xEB2A99D3, 0x7FE68DE0, 0x2A2E3827, 0xD58DDA59,
            0x00000080, 0x28682717, 0xBD1A977C, 0x81E70C73, 0x752205C5, 0x00000000, 0xF8134EE5, 0xEE810A30,
            0x74861AEF, 0x73DDB7FE, 0x00000080, 0x9449F31C, 0x02291BF5, 0xF10D4EC2, 0x70ED7F33, 0x00000000,
            0x1F4BF2F8, 0x5B032741, 0x863CC350, 0x4E8E9355, 0x00000000, 0xBCF3612F, 0xB221254C, 0x427B901E,
            0x12EBFBC3, 0x00000080, 0x5660477D, 0xD58582B1, 0x4EADC6BD, 0xF22056B6, 0x00000080, 0x4E0D1FBF,
            0xAEFBB84B, 0x1EA8C74D, 0x01357ACC, 0x00000000, 0x45F46675, 0xE02A6739, 0xB5916F82, 0xFEF620EF,
            0x00000080, 0x50C7E07A, 0x7180512E, 0xE68EB1EA, 0x7B543FBA, 0x00000000, 0x31A982BA, 0x455FC8D6,
            0x765112ED, 0x3B8F8470, 0x00000000, 0xF8FAF9E4, 0xD2B38BA9, 0x358AD781, 0x1CB9DA14, 0x00000000,
            0xBF59C3CB, 0xC4CC0CA6, 0x392DB9DD, 0x659B1D29, 0x00000080, 0x718CFF4A, 0x1BF3317E, 0x5C18982D,
            0x314FE7BC, 0x00000080, 0x7AEF0242, 0x3EABC1E3, 0x2C8116F4, 0xB5671479, 0x00000000, 0x344016D0,
            0x7380AA3B, 0x8C36CFFE, 0x54296A0D, 0x00000000, 0x7BB8845A, 0x2B1BA4D9, 0x4710667C, 0x3A31129E,
            0x00000000, 0x632014E4, 0x2096AF51, 0x982364AA, 0xC037177F, 0x00000000, 0x60A27D9F, 0x26B32702,
            0x20885CED, 0x237497BE, 0x00000000, 0xF1E03052, 0x51A7A2BD, 0xB6F4E702, 0x47626D56, 0x00000080,
            0xB062FCB7, 0x570F161C, 0xAAC6DAB7, 0x9D8DDEDD, 0x00000080, 0xDB97084B, 0xFD7F8118, 0x0744CF41,
            0xFBECD432, 0x00000000, 0x2A762C5C, 0x5EE415F5, 0xCD10FF2B, 0x29325524, 0x00000080, 0xDD3F923D,
            0x90AA479F, 0xC400FE41, 0xF1DF452F, 0x00000000, 0x91161BD8, 0xC785FF44, 0x86A2D37E, 0xA6542B7C,
            0x00000000, 0x2BC1F32E, 0x2523BF8D, 0x59186FCB, 0x9D2CE8E1, 0x00000000, 0x809720A3, 0xB329E85C,
            0xF81F003D, 0xEC5121A2, 0x00000080, 0x25168CC7, 0xEB61C70D, 0x2F0690FB, 0x651F1A4D, 0x00000080,
            0x53B69DF6, 0xC68C0DD5, 0x396FFCBB, 0xEFAD53D8, 0x00000080, 0x4CB80B09, 0x69540D67, 0xB5A867AA,
            0x2249057E, 0x00000000, 0x8F53EB31, 0xF1E1FEF0, 0xE105619D, 0xA93F985E, 0x00000080, 0xA9382AE3,
            0xAEB8BBE4, 0xC354B276, 0x8F0E7C1B, 0x00000080, 0xB26DFAF8, 0x2646B3D1, 0xDE36E4DA, 0x28E8BCC4,
            0x00000080, 0xDCFF44D7, 0x9922CA06, 0x44163850, 0x5B454A7B, 0x00000000, 0xFD2144C5, 0xDF5FE9F2,
            0x4A867623, 0x80FC94E4, 0x00000000, 0x3974DF6A, 0x2BBEC70C, 0x9ED7F513, 0x28AB2ECF, 0x00000080,
            0x31FD71E4, 0x4E8B0ACB, 0x80A09B72, 0xCBB09B6D, 0x00000000, 0xB16ACD11, 0x58776659, 0x7D6D949F,
            0xDF2A35A4, 0x00000000, 0x3ADD1921, 0x261BF57B, 0x8570906C, 0x8C55F49E, 0x00000000, 0x33926B74,
            0xDDD3C628, 0x80F58008, 0x4948A01F, 0x00000000, 0x1988B051, 0x6DAB4C9F, 0xA6797D0B, 0x207F113F,
            0x00000080, 0xED4055E4, 0x9E5F6ECD, 0xF6494039, 0x122556A6, 0x00000080, 0xEBF38C3A, 0x249C8084,
            0xC57B1AB9, 0x1A5D94CD, 0x00000000, 0xEFE83CA4, 0x11FF9889, 0x582B3386, 0x857FD6DF, 0x00000000,
            0xDE02EEF6, 0x54FA50F2, 0x217F05D6, 0x12D0C9EC, 0x00000080, 0x848AB4C6, 0x8A4A1BAD, 0x8773DDFD,
            0x21E76439, 0x00000080, 0xF2E15AE5, 0xB580B6F3, 0xD25E554B, 0x4CA7F426, 0x00000080, 0x8D4BAC4C,
            0x663BF6AB, 0x400994CF, 0x8008165C, 0x00000000, 0xEACB44EF, 0x7545E30D, 0x05313E6C, 0xA12BD108,
            0x00000000, 0x5C8C200D, 0x5B4EFFE1, 0xED25D5B1, 0xEAD98BAC, 0x00000000, 0x0849364B, 0xA6F7E1C7,
            0x4B0B7790, 0xEA16B5FB, 0x00000080, 0x8BA5A8ED, 0x8DE309B5, 0xCBB6D2A3, 0xB16A395F, 0x00000000,
            0x61351D1A, 0xEE67A66E, 0xC7B4E406, 0x98789930, 0x00000000, 0x1B795AE6, 0xE43344A6, 0xBA059A07,
            0x0FE9A3CE, 0x00000000, 0xD6CEA372, 0xC24F20E6, 0x406D150B, 0x15B938D4, 0x00000080, 0xCF74B6EF,
            0x9B3BE3B1, 0xCD5591B2, 0x6B987B97, 0x00000080, 0x69823B0D, 0x07950CFA, 0x6BDD108A, 0x28091323,
            0x00000080, 0xFFA2B45E, 0xA6F911DB, 0x76A05627, 0x4172F828, 0x00000080, 0x4828298D, 0xFEFA36BE,
            0x6622EB14, 0xC93D8963, 0x00000080, 0x378E548E, 0xB62A2237, 0x9EEC656F, 0xBA8FF779, 0x00000080,
            0xCFB0560B, 0x5FDBE547, 0xFDB08197, 0xA39AE0EB, 0x00000000, 0xBAD1F16F, 0x2E3C8137, 0xADA80F08,
            0x7F931AB9, 0x00000080, 0x1527B5AC, 0x5D52A1CD, 0xED0AF977, 0xF1EB1BD2, 0x00000000, 0xD6548380,
            0xC5BAA97D, 0x3A27B246, 0x096527DA, 0x00000000, 0xDA744F33, 0x6AB4F4BF, 0x1052E588, 0x54510D6D,
            0x00000080, 0x91865CF7, 0xE012F299, 0x3681DC2B, 0xD3FCB858, 0x00000080, 0x467CD1B7, 0x8CD61551,
            0x9B100470, 0x6FE454C9, 0x00000000, 0x947C9C6A, 0x7CDD5DAA, 0xB2000D21, 0x58121B47, 0x00000000,
            0x7756CDA3, 0x0B350A69, 0xAC874133, 0xB3DDEF6E, 0x00000080, 0x32BC042F, 0x8D5029D3, 0xB5A5A69C,
            0x0F5C0B4B, 0x00000000, 0xB2E146D7, 0x5BCEDA7E, 0x4259D5C3, 0xB04FDAA0, 0x00000000, 0x97DD395A,
            0xE41F2ED4, 0x1F3DDA68, 0x6886542F, 0x00000000, 0x557A3F24, 0x642E4759, 0x9FF552A0, 0x0CE0FD01,
            0x00000000, 0x81E6C66D, 0xA51DDE1E, 0x31CBE1A9, 0x9BBEE2C0, 0x00000000, 0x5BA6C68F, 0x4A489447,
            0x41EA51E3, 0x598FC468, 0x00000080, 0xC85B0E55, 0x19E4F476, 0xA6837AC2, 0x8E2F9009, 0x00000000,
            0x11AA3D10, 0xDA2EE0EB, 0x5507C330, 0x23140DBD, 0x00000080, 0xDFC97B13, 0x33B084F2, 0xEA9C8FAE,
            0x40D3C03B, 0x00000000, 0x700E086E, 0xA8CB73D1, 0x8F8A90E0, 0x18A73030, 0x00000000, 0x695C6CF7,
            0x7BE48707, 0x2CFC4F18, 0xD4C67244, 0x00000080, 0x84E5E80E, 0xA95F256F, 0xE7DC82AD, 0xBCBB5925,
            0x00000000, 0xF733A0A5, 0x273AAD89, 0xA2A3FEA7, 0xFDEDC058, 0x00000080, 0x4838A601, 0x3A008508,
            0xFC8595DF, 0xC983D657, 0x00000000, 0x5C8BDBF5, 0xEF23B328, 0xB4A0BF12, 0x13A0847D, 0x00000080,
            0x6F4836F8, 0x08FF4848, 0xBE7AD8F9, 0x093D1581, 0x00000000, 0xA4F63DC1, 0x4B0EED58, 0xEC34F749,
            0x03A761DA, 0x00000000, 0xEDAA7A7F, 0xD0D4C216, 0xCA0215AB, 0x3A4FE79F, 0x00000000, 0x41919002,
            0xB4A8F1CD, 0x2E2085E3, 0x0D756870, 0x00000080, 0xDA4CBB76, 0xFD3983C0, 0x8C8404AE, 0x36C8258A,
            0x00000080, 0xFA81A9AF, 0xFAB14D5A, 0x784A0794, 0x637FD1F2, 0x00000000, 0x72885B72, 0x69DD93CD,
            0x27813CDE, 0x6EBC17D2, 0x00000080, 0x84C6341F, 0x57CF4AF7, 0xD1D734BA, 0x194DF418, 0x00000080,
            0xA1D88E63, 0x71457CA3, 0xDED30BA9, 0x2EF5176E, 0x00000000, 0x09778F68, 0x5D5A8116, 0x82713801,
            0xCFE2AA41, 0x00000000, 0x5EAAAC1D, 0x0D59DAE4, 0x98F95520, 0x56ACCA7A, 0x00000000, 0xB6E1D512,
            0x1B688FCE, 0x55352CD3, 0xF4F46A5B, 0x00000000, 0x629A1C87, 0x7D411B05, 0x9DDB4F0C, 0xC33A077F,
            0x00000000, 0x1E54895B, 0x94DC472D, 0x3126B797, 0x9CADA7B2, 0x00000080, 0x64D20A48, 0x2603144D,
            0xC1058721, 0x354AC600, 0x00000080, 0xCD2150C8, 0x8D677C93, 0x21924DFA, 0xCA7B6E03, 0x00000000,
            0x81E94C4D, 0x6627B99B, 0xE30DBAEC, 0xCC65C6D9, 0x00000080, 0x0CCD21C2, 0xEA3A8756, 0x9E593082,
            0xA70EB1A6, 0x00000080, 0x4417E25F, 0xB2878383, 0xA304A13A, 0x9B6AF9B0, 0x00000000, 0x387AD331,
            0xCBB90DDB, 0x0B4A958B, 0x59538A2E, 0x00000080, 0x88845B26, 0xAA208B49, 0xAFAADFF9, 0x977E986F,
            0x00000080, 0x0DBEDA5B, 0x48F742EE, 0x4F3D5C1A, 0x9ED3D6D2, 0x00000080, 0xC568B2CC, 0x220EA3A9,
            0x70A73649, 0x0456A989, 0x00000000, 0x8F8BEF51, 0x1C711A93, 0xA2960218, 0x37129CB7, 0x00000080,
            0x002DDEA3, 0xA3AF7D77, 0x718E97D3, 0x4B47D5AE, 0x00000080, 0x46B57DED, 0x648D044B, 0xCCA5CC43,
            0xC5ABA754, 0x00000000, 0x6632352D, 0xA2205C69, 0x246F67C1, 0x7D9F4A6E, 0x00000000, 0xE6852E6F,
            0x618030ED, 0x5C9215CB, 0xA36B2A44, 0x00000080, 0x944B2D0C, 0xE66FB6D2, 0xC5927DDC, 0xEA7ACAB4,
            0x00000080, 0x2C2E20FF, 0x4D15A29E, 0x7206A72F, 0xD319A809, 0x00000080, 0x474D141D, 0x958FCEE2,
            0x183E0D55, 0x87973740, 0x00000080, 0x6589385D, 0x3A28AF73, 0xDD606E7B, 0x69ED68F5, 0x00000000,
            0x51F4A409, 0xBA116281, 0xE39364A4, 0xBE4E4481, 0x00000000, 0x614395C5, 0x4A796F41, 0x53D3D001,
            0x12E8D072, 0x00000000, 0xE394A4B1, 0x02DCC135, 0x3E9DA5DD, 0xA5E13110, 0x00000080, 0x32A9AD2F,
            0x44C24FC5, 0x03D57FCE, 0xD875A938, 0x00000000, 0x8CEF6970, 0x012842EA, 0x48D9EF0F, 0x6C19B1C8,
            0x00000080, 0xE1BB1BC7, 0xC2DB0606, 0x6A5C6FC6, 0x76FDF832, 0x00000080, 0xA2E76153, 0x91A90E01,
            0xB299DDC9, 0xCCE8665E, 0x00000000, 0xB4DF3620, 0x0A8E2634, 0x5C3AD5CB, 0x8943669D, 0x00000080,
            0x4583E639, 0xEBA1823F, 0x3AB9B0F7, 0x72E0E33B, 0x00000080, 0x486A74E1, 0xB9B077A5, 0x05D0B821,
            0x07B44488, 0x00000080, 0xF15A0BC1, 0xA7003085, 0x5D592D9A, 0x8B28DE74, 0x00000080, 0x1CC642DF,
            0xD408738F, 0xE342AB0F, 0xBED4B22A, 0x00000080, 0x1583F6AA, 0xE0575542, 0x0E8E4B53, 0xFF5E640A,
            0x00000000, 0xC8ED1945, 0x4E05B262, 0x4124E266, 0x02E75892, 0x00000000, 0x9779AA57, 0x51905D8E,
            0x247DD5EC, 0x37454966, 0x00000000, 0xE5E3EECB, 0xB286FF24, 0x900A250D, 0xC3B48AC5, 0x00000080,
            0x6FED2595, 0xB41988BF, 0x90D38035, 0x394F9DB6, 0x00000080, 0x91EE431F, 0x6F4D2125, 0x502E1967,
            0x1478CED3, 0x00000080, 0x7898D227, 0x748FBEA3, 0x12DB8CAC, 0xB5D4458B, 0x00000000, 0x942F8EDE,
            0x664B6D12, 0x06C31B25, 0x22BCE9C6, 0x00000000, 0xEDB9DAB2, 0xA3030B39, 0x4DB0DB2F, 0x9AF03333,
            0x00000080, 0x22D5A20C, 0x24F00557, 0x0034D457, 0x2E34159F, 0x00000000, 0x93D43AFF, 0x1209A7AE,
            0x7F0222AA, 0xB25B886D, 0x00000000, 0x245AD90D, 0x62B5C1B2, 0xAEC215CB, 0x5A42DF5B, 0x00000000,
            0xF1DCAC11, 0xF20E9864, 0x524C4CFD, 0x2B05E0AD, 0x00000000, 0x58E8FDCA, 0x8C2FE048, 0x844FEC39,
            0x0B116B13, 0x00000080, 0x6653D9B8, 0x637371E7, 0xECF3AAB1, 0xFD314E60, 0x00000000, 0x175F0CCF,
            0x59EFDCFD, 0x88F29477, 0x690470B3, 0x00000000, 0xF2FCD4FE, 0x4C66C4A4, 0xC2D30211, 0xE062B69E,
            0x00000000, 0x4B15ED6D, 0x127646AF, 0x517C35E5, 0xF0C53203, 0x00000000, 0xB1B6EFE3, 0x3DE7B487,
            0x31FFFBAD, 0x7C03D484, 0x00000080, 0x19BECBB9, 0xD13CE4F2, 0x8A91A30D, 0x05957D83, 0x00000080,
            0x318D40A7, 0xF0F17868, 0x8AE62DE3, 0x96A02E42, 0x00000080, 0x10068D4C, 0xA72574C3, 0x7C98CA42,
            0x4F4722EE, 0x00000000, 0x3C85A209, 0xD1274F84, 0x3243D86B, 0x54342CA1, 0x00000000, 0x751A9204,
            0x43710F40, 0x8F7DDB2A, 0x4C478D03, 0x00000080, 0x780AC6D9, 0x7F23B91D, 0xF392D398, 0x5F8CED72,
            0x00000080, 0xD5A2A877, 0xC5160BCD, 0x5D694714, 0x8BE12EFA, 0x00000080, 0xE41BB396, 0x784B16A8,
            0xA538564B, 0x8FA77A35, 0x00000000, 0x31CC5AF9, 0x27E659C6, 0x2B979DD1, 0x1E678D33, 0x00000080,
            0x67F93EA2, 0x1A9A3480, 0xE4756451, 0x254F1CD4, 0x00000080, 0x8F460D3B, 0x1F583FA2, 0xED5FBB8D,
            0xDFAA4ABE, 0x00000080, 0xF9C8EC06, 0xF4675F94, 0x4FBC0E45, 0x00B3040A, 0x00000000, 0x68BCDBF8,
            0x2AFF098C, 0x264DC250, 0x387DD6C1, 0x00000000, 0x2C367EDA, 0x7D016331, 0xF26B5593, 0x28AA6E56,
            0x00000080, 0xD171032C, 0x86F3070F, 0x9743D852, 0x88755CFD, 0x00000000, 0x1347F8F4, 0xD95A7485,
            0x401175E2, 0x69E459C5, 0x00000000, 0x01267015, 0xA20C0E5C, 0x22CA7A09, 0x332ACC0E, 0x00000080,
            0x22568403, 0x17F6B4F9, 0x088877EE, 0x1D8803E1, 0x00000080, 0xC0496408, 0xE48D74C0, 0x9BE99221,
            0x78CA67D0, 0x00000000, 0x3F35C757, 0x723B787F, 0xD3FCDBE9, 0x0616F6C4, 0x00000080, 0xA0387ED5,
            0xBDE97132, 0xAF1C32A5, 0x5FB90CDA, 0x00000000, 0x80C3C495, 0x346304B0, 0x2077E3D9, 0xCC5D0917,
            0x00000080, 0x52924572, 0x307BBCB7, 0xC21819E3, 0x70613E42, 0x00000080, 0x48E5321E, 0x41306B53,
            0x3C0C0BA9, 0x10B89B95, 0x00000000, 0x3199C22F, 0x83257C74, 0xB7208611, 0x4AAF52B2, 0x00000080,
            0x18BE31C0, 0xF612CD5B, 0x113D0DF0, 0x5B963F8C, 0x00000000, 0x2D483ECC, 0xA4F35FBC, 0x85818479,
            0x16CCDC6B, 0x00000080, 0xBC946F7F, 0xFA753B30, 0x8FD91490, 0x78E99BE2, 0x00000000, 0x670F4278,
            0x794F3B62, 0x78CFF3AA, 0x73607C65, 0x00000080, 0x3944769A, 0xFB99546B, 0x7BB65457, 0x84BE7777,
            0x00000080, 0xB79147F7, 0x06C902C1, 0xF383D5E6, 0x801D10CB, 0x00000000, 0x7B7896C3, 0xE6C27702,
            0x819BB203, 0xFFBAC7DA, 0x00000080, 0x16CF34E2, 0x1521456A, 0x8E0DB3C0, 0x38498691, 0x00000080,
            0xE3438ABC, 0x4ED47F1E, 0x98C6F3D4, 0x0C2E850A, 0x00000000, 0xC87F6779, 0xA7995412, 0xC93E2581,
            0xC8BF2262, 0x00000000, 0x1321DCE1, 0xB0DC5C3A, 0x597A8742, 0x24F82F48, 0x00000000, 0xFA05CBF3,
            0x19451078, 0x012A0FD4, 0x30E27FC1, 0x00000000, 0xE17EA2D3, 0x74031D08, 0x6A3AF3D5, 0x50F5B9C4,
            0x00000080, 0x6FA7E32F, 0xBDFDA9B0, 0x81B596A4, 0x521B9C7C, 0x00000000, 0xDDA72AC1, 0x8AF7C1AE,
            0x78334432, 0xD8AE55EA, 0x00000080, 0x4E90EB14, 0x0379B39F, 0xD0782F13, 0xEF7B8397, 0x00000000,
            0xE3FC7B06, 0x8A201E2E, 0x18263DD5, 0xC6B02CE9, 0x00000000, 0xAD46683C, 0xF58DD633, 0x4A382920,
            0xECD3F83C, 0x00000000, 0xD4AE5204, 0xFFEC3FDC, 0x15525B40, 0xE939BB4B, 0x00000080, 0xF1236A45,
            0x3AB0E539, 0xF57A557C, 0x762DD428, 0x00000000, 0x09295CF4, 0x23059AB7, 0x72ABABFB, 0xE5A322DC,
            0x00000080, 0x10282D68, 0xF046C1F9, 0x0ECE92FD, 0xA1DF5011, 0x00000080, 0xA5B2DDF5, 0x576DAF95,
            0x124D3200, 0xB0883FA2, 0x00000080, 0x21978D3C, 0x5E6FF2D3, 0x9E142B59, 0x1A6BDB2E, 0x00000080,
            0xCE2617A0, 0x3FAED5AE, 0xE2250F5E, 0x3552CFFB, 0x00000000, 0xAB0D125D, 0x18F1CECE, 0xCEC89F85,
            0xA04FD8D6, 0x00000000, 0xA10891B6, 0xEF77A212, 0xBCD2239D, 0xD6C43605, 0x00000080, 0x1ACB8492,
            0x71A7177B, 0xD608147C, 0xCCFD0D5D, 0x00000000, 0x3ABEB471, 0x4A28F4E5, 0x6D98EE10, 0x343DEA10,
            0x00000000, 0x83F22894, 0x4B26CFBE, 0x3A3D24A0, 0x61C79486, 0x00000080, 0x477DE5DD, 0x47653F69,
            0x66A199F4, 0x6B78ACA4, 0x00000080, 0x2A3B60C2, 0x8ACEDE18, 0x023E41EC, 0x769F8DE4, 0x00000000,
            0x045D590E, 0x1079F868, 0xFC9B6AD5, 0x4115E0DC, 0x00000000, 0xCF7C63F4, 0x78A78E9E, 0x7A6AAC95,
            0x5FB1FD5E, 0x00000080, 0x20890096, 0x166064FA, 0x58E238E1, 0x82D829DA, 0x00000000, 0xCFDA04CC,
            0x415CE43B, 0x67C1C3E0, 0x97889435, 0x00000080, 0x65DC1526, 0x426E0B8E, 0x7929463F, 0xA68C6AC0,
            0x00000000, 0x56E62B00, 0xEAD45EED, 0x6B93AEC9, 0xF00CE167, 0x00000000, 0xBE04F488, 0xB8B3B223,
            0xAE6A8642, 0xC607F037, 0x00000000, 0xF09FBE29, 0xE80290FF, 0x03F9E8D6, 0xF48BCCED, 0x00000000,
            0xF70C5D81, 0x784F72E3, 0x058349B4, 0x25F3806D, 0x00000080, 0x51D8D76A, 0x07CB4DC9, 0x525D5975,
            0x78AEDF0A, 0x00000000, 0x0BA535DF, 0xA157FE18, 0xE4B089D7, 0xE5D9C191, 0x00000080, 0x89CE97D4,
            0x6E84E84C, 0xF431FB5F, 0x9DFAF2A6, 0x00000000, 0x0C0F8E2F, 0x2CE2524F, 0x5D304279, 0xB138AFED,
            0x00000000, 0xE88CAA0A, 0xD7411C50, 0xD990A146, 0xE73B32D2, 0x00000080, 0xF90A1E9E, 0xB3492397,
            0x76E1D0B5, 0xD84021C1, 0x00000000, 0x20AB17C4, 0xF3602942, 0xFCE9D133, 0xA2D61747, 0x00000000,
            0xC4D431AD, 0xA1AB3FA8, 0x12E6BE4E, 0xE5266009, 0x00000080, 0xD5969660, 0x85E789BE, 0x637B44D0,
            0x887E1AA3, 0x00000000, 0x3ADC1846, 0xB4743C2A, 0x8A19B5E7, 0xCD50A4E0, 0x00000000, 0x98FC43B9,
            0xC59EE807, 0x8BB8475A, 0x72849875, 0x00000080, 0xCB3C3FB0, 0x87C6D4E5, 0x72D221C5, 0x99223BA3,
            0x00000080, 0x1C9F36DD, 0xAD8B0152, 0x3BF6B125, 0xDF266946, 0x00000080, 0x19DED0C2, 0xB0537FA6,
            0xCF536769, 0x08DA303D, 0x00000000, 0x69029A7B, 0x649EC13F, 0xEA039F66, 0xD6CDBE56, 0x00000080,
            0x2DF82FF7, 0x4A26D3DD, 0x098269A8, 0xA58DBE35, 0x00000000, 0x488D406D, 0x94FD3972, 0x222BC2C1,
            0x176F05A3, 0x00000000, 0x74991834, 0x55E6E67F, 0x420B9E41, 0x830E62FD, 0x00000000, 0x1BC58EA7,
            0x1329DE44, 0x8BF7C6D5, 0x54EDCC9A, 0x00000080, 0x89028B25, 0xF26DDF79, 0xE50423AD, 0x18044EE2,
            0x00000080, 0xC95A2471, 0xF5C5E95B, 0xF2D415F2, 0x68045AB5, 0x00000000, 0x5316EFA4, 0x51479ABF,
            0x50BFBA18, 0x37E91259, 0x00000000, 0xFEE8BB1C, 0x9BB1419E, 0x5CB093BD, 0x9C1E36CC, 0x00000000,
            0xD787E224, 0x564D58D0, 0x79771E88, 0x6F00EDE2, 0x00000080, 0x67017320, 0xE23335A4, 0xA3AB2F22,
            0x0D13AFA2, 0x00000080, 0x063DA9AC, 0xAD725699, 0xECC29BF1, 0x20FE41E0, 0x00000080, 0xE823E106,
            0xA554AC3E, 0x77EA4FBD, 0x14B413E0, 0x00000080, 0xBD5D1E52, 0xDB6009CB, 0x572C80AC, 0x6C3F73BC,
            0x00000000, 0xEB44BFA7, 0x52EAC8E9, 0x771A9E3D, 0x8024DACF, 0x00000080, 0x51901353, 0x6D493E5B,
            0x4934079B, 0xA5080CB3, 0x00000000, 0x0E8B4263, 0xC29B9F9F, 0x9ABE9269, 0x52034E52, 0x00000000,
            0x9FAC7A4D, 0xE6D11339, 0x7B86B7EB, 0xB7F5E9A8, 0x00000000, 0x6A2D31E7, 0x8A959078, 0xF2753275,
            0xFAF9FB76, 0x00000080, 0xF200ED85, 0x65461693, 0xDDD9F461, 0x2916BA01, 0x00000080, 0xAD3EBC56,
            0xE36CD71B, 0x13C6D084, 0x893A3232, 0x00000080, 0x5FE58302, 0x920DD3C9, 0x57FF1CB9, 0xF425D48D,
            0x00000080, 0x36E9561E, 0x673C352B, 0x44B5EF76, 0x69182166, 0x00000000, 0xBAB1F2F2, 0x2599A152,
            0x53CA9B1A, 0x1543BEFA, 0x00000000, 0xC41EE1B2, 0x78312B73, 0xC4BF3495, 0x90EE967A, 0x00000000,
            0xC3E8C3B9, 0x87B4CDD5, 0xCB06300F, 0xFE066264, 0x00000080, 0xAD2E79A0, 0x35B83C41, 0x632DA472,
            0x920B6A3B, 0x00000000, 0xFA03988D, 0x05E4393C, 0x1CE7E930, 0x143ED546, 0x00000000, 0x82AFF118,
            0x91C8BEA5, 0xB6D662C5, 0xA3E03CFF, 0x00000080, 0x5B24A159, 0xD458B0A1, 0x134CC7B7, 0x35BE1B5E,
            0x00000080, 0x72C4A7FA, 0xE097B0BE, 0x5212DEAE, 0x81407934, 0x00000080, 0xB8D8E06C, 0x99FFAA63,
            0x0760BE55, 0xE861F5A4, 0x00000000, 0x8CF1B75B, 0x524F4EE9, 0xB31793F9, 0x375394D2, 0x00000080,
            0x0E54E5AC, 0xDB3939F6, 0x9617CD6A, 0x6344D889, 0x00000000, 0x11D58FF7, 0x01F2191B, 0x0364A7C8,
            0x15CD8F0E, 0x00000080, 0xB17257C9, 0xE6025D82, 0xBE94F7D0, 0xDE667B54, 0x00000080, 0x2E92D31A,
            0x14338C00, 0x1C817808, 0x0091DBDF, 0x00000000, 0xD9662DC2, 0x88215DCE, 0x78A19E8E, 0x79922B34,
            0x00000000, 0x6CED2C54, 0x8AA5EBA9, 0xD8D1CE5F, 0x16D33335, 0x00000000, 0xA1287B2E, 0xEEC79A6C,
            0xECCBA4EB, 0x5C40EF60, 0x00000080, 0x1914100E, 0xB73F8F8D, 0x78A0B791, 0x6693CBB5, 0x00000000,
            0x49EF66F7, 0x5FB383B8, 0x0FD899E1, 0x7BD6C7FC, 0x00000080, 0x7094A145, 0x6B375386, 0x9408EBE8,
            0xB94C501B, 0x00000080, 0x6B22A495, 0x507E8ABF, 0x4EF5B2D3, 0x7FF8124C, 0x00000000, 0x54DCAF68,
            0xD189FF9A, 0x8D17AAC1, 0x095E006C, 0x00000000, 0xA4AD5F04, 0x24B12F97, 0x0D8309FC, 0xCD7729C9,
            0x00000000, 0xE82686B4, 0xF1DB6264, 0xF2009E75, 0xA8BE602D, 0x00000000, 0x5481C865, 0x527AED87,
            0x5AB000BA, 0x76ADD995, 0x00000080, 0x9E01566D, 0x6B7731C3, 0x5D3BE8C4, 0xB29703D9, 0x00000080,
            0x8ECB6DAA, 0xF9C73336, 0x60AA06CE, 0x17CCAEDD, 0x00000000, 0x1C2709B6, 0xCC3EB1DE, 0xDC511CFA,
            0x55EB8DCA, 0x00000080, 0x93045BF8, 0x4C983210, 0x28EDE546, 0x620B1C20, 0x00000080, 0x6A5EF889,
            0x255C806C, 0x142526E8, 0x4331CA33, 0x00000080, 0xB91C84BF, 0x9C06F84B, 0x609ECB49, 0x0F2E519A,
            0x00000080, 0x892A75EE, 0x17B555FA, 0xBD3378B1, 0xA1D7C5E2, 0x00000000, 0xA274C9C1, 0x17EACFB2,
            0x7F931DAC, 0x99715AD2, 0x00000080, 0x121EF390, 0x44C3B55C, 0xE5A1F2AE, 0xBE3DA7E8, 0x00000080,
            0xC564D653, 0x85C8E39F, 0xBCF8AE8F, 0x8D60F5BE, 0x00000080, 0xF9A68BA9, 0x21119DA4, 0x17C5CD64,
            0xE5E7ADD0, 0x00000080, 0x9D75720B, 0x86971A29, 0x0D502091, 0xC88396B9, 0x00000080, 0x26AD7F3A,
            0xC7F76F35, 0xF1BE4997, 0xEC238F76, 0x00000080, 0x1B95FB6E, 0xD5665E19, 0x086D461D, 0x8726401F,
            0x00000000, 0x08B61745, 0xC1C1EA60, 0xFFD50AC1, 0x6B662027, 0x00000080, 0xEB8DE0A4, 0xEACC6499,
            0x031F304D, 0x43D7D594, 0x00000080, 0x4C80E114, 0xF5CCB1E5, 0x6A714135, 0x5347892B, 0x00000080,
            0xA74E8E6D, 0xC5863F37, 0xC22FCC06, 0xDD0ACFAC, 0x00000080, 0xD4BC3115, 0xDCCC862E, 0x61C403FF,
            0xDB202F58, 0x00000080, 0xA00A297E, 0x193834D0, 0x8A39F877, 0xCA9C3436, 0x00000080, 0xA2204D4D,
            0x8F414E95, 0xA7378DF2, 0xD03F5833, 0x00000080, 0xB0E3EFBC, 0x2001B850, 0x2908D4F5, 0xB4A9F3E0,
            0x00000080, 0xAC60049C, 0xC7A3F538, 0xCBC5487F, 0x7A34D72F, 0x00000000, 0x9D9D6809, 0x39157E72,
            0x53E9C4B3, 0xC9C98166, 0x00000000, 0x0527B929, 0x5403CC66, 0xAC2A206B, 0xDE147CAB, 0x00000000,
            0xFFE1285D, 0x45505366, 0x8B3FE74E, 0x42DBCA50, 0x00000000, 0x909349E9, 0x5BC839FF, 0x53C17F6D,
            0xB59E7416, 0x00000080, 0xA6B6BE48, 0xCEBE591B, 0xB7DEC13A, 0x89CBA7B6, 0x00000080, 0x3615600C,
            0x496E1F17, 0x04197C6F, 0x7C880DD2, 0x00000000, 0xA3279C9C, 0xDE8071F5, 0x5BF13310, 0xCEDC82B1,
            0x00000080, 0x842C5831, 0x6B147CE9, 0xA5037D50, 0x3D806A1F, 0x00000080, 0x91BE8685, 0xC1203584,
            0x85D2DC4A, 0x2AE9E6FD, 0x00000080, 0x47806758, 0x0A444B8B, 0x1F28DD77, 0x12680E79, 0x00000000,
            0x89417C24, 0xD7FE0FE9, 0x4BE188AA, 0x6DD738CF, 0x00000080, 0x76932FC2, 0x2B0274E9, 0xD44C11F4,
            0xB8D23893, 0x00000000, 0x9CD04C59, 0x12956166, 0x3D2FDD9F, 0xDFB779DD, 0x00000080, 0x7DED0773,
            0xA96A1907, 0xB23265B1, 0x89E4DA47, 0x00000000, 0x5D5EA17F, 0x8DF1AF03, 0x8674DB9C, 0x2BCE93C9,
            0x00000000, 0xDF97B468, 0xD94F9B5C, 0xE7058855, 0x3C6E2E0C, 0x00000080, 0x7DF310A4, 0xC010A0A4,
            0x350B92B2, 0x6018F82E, 0x00000080, 0xB1D08E98, 0x80AAD641, 0xD50AFF6D, 0x71ECB0E6, 0x00000000,
            0xC487C2E6, 0xDD257E2A, 0x9CE72763, 0xA2EB592F, 0x00000000, 0xEF6E9658, 0xD093D643, 0x06A6F556,
            0x911EB734, 0x00000000, 0xABA62B9B, 0x3B1510C9, 0xC23033C9, 0xDF945A1A, 0x00000080, 0x00853592,
            0xED597FF8, 0xA4575DB9, 0xE41A27C8, 0x00000000, 0xA469CFE0, 0x742C7750, 0x8E120C8C, 0xD3C68BFE,
            0x00000000, 0x8A70D078, 0x85A6C28A, 0x7A459286, 0x8704A90F, 0x00000080, 0xC1B7EDB5, 0x72F380F7,
            0x7457C515, 0xA852A39E, 0x00000080, 0xBA887EA8, 0xD0C941C2, 0x3756D5D9, 0x69EC5B8D, 0x00000080,
            0x44E139C5, 0x1881FCA1, 0xAE9C89F0, 0x49E80239, 0x00000080, 0x909619EB, 0x4FFB9CB3, 0x35C168AE,
            0x2199DEF1, 0x00000000, 0xB1DD653B, 0x9E5E01D1, 0x2F23F3C1, 0x7FB056F1, 0x00000000, 0x6870F55C,
            0x11D78BD4, 0xADF950CB, 0x223C791D, 0x00000000, 0x87AB844B, 0x4B5BDF6F, 0xA7605B81, 0xF6B371A7,
            0x00000000, 0xC47FE24D, 0xEE8CBCA9, 0xC9A0B827, 0x8F8E6BFB, 0x00000000, 0x15ED0D23, 0x833B3900,
            0xBA83B7D8, 0xD9466C1A, 0x00000080, 0xB51B6D64, 0x79C24162, 0xB37D7DF1, 0x4E2FF721, 0x00000000,
            0x4F38D6A2, 0x608DB0E1, 0xA554D7E6, 0x4EA15E0A, 0x00000000, 0x2E9D8542, 0xFA6F23DA, 0x93045556,
            0x55046269, 0x00000000, 0x5BA9C4E8, 0x4B607B87, 0x8AD00EE4, 0xA0A82E9B, 0x00000080, 0xF879D7AE,
            0xA7256FB1, 0xF8B80320, 0x4CF5DAE2, 0x00000080, 0x784FBE65, 0x28830D14, 0x2C780BA5, 0xA4EE4ABC,
            0x00000000, 0xB6829665, 0xF655CBD5, 0x6F07A0D5, 0xDF126DA3, 0x00000080, 0xFE82BBFC, 0xF956E5A0,
            0x1DB2FB15, 0xECF2BC59, 0x00000080, 0xD67547AF, 0x7FD93ED2, 0x8D45E3A2, 0x930BC06E, 0x00000000,
            0xAE762BF6, 0xBC9403C1, 0xE35A7EAB, 0xC88BF3C9, 0x00000000, 0xBA522247, 0x7B793618, 0x82972131,
            0x293E75A9, 0x00000000, 0xDE2FA04E, 0xB58DE787, 0x810CA558, 0x6A4583F6, 0x00000000, 0x8D3437B3,
            0xD2A25FC5, 0x08B86E04, 0x6FF89CD1, 0x00000000, 0xC59FC657, 0x33A97DCD, 0x86557032, 0xB70BDD6E,
            0x00000080, 0x252394C1, 0x0275E708, 0xEA1FAD15, 0xF509669F, 0x00000000, 0x705FD74D, 0xAF186B12,
            0x67442FE5, 0xFDB462C4, 0x00000000, 0xE3995849, 0x234A29D9, 0xB2446F05, 0x4CF7AF0A, 0x00000080,
            0xB2FB9CA0, 0x3F131C61, 0x4F91C4CA, 0xC00A84EA, 0x00000080, 0xA08ADE6A, 0xA8E08A97, 0x60E64ED2,
            0x85DB5225, 0x00000080, 0xBFC3299C, 0x0D475830, 0xAAA1F712, 0x455CF514, 0x00000080, 0xC773A744,
            0x17918F20, 0xAC05C795, 0xD8956959, 0x00000000, 0xD1E6EADC, 0x260F8A10, 0x1AF5BB16, 0xC02200A8,
            0x00000080, 0x4571DD05, 0x33B6A36B, 0x0E8E23D9, 0x2BF0973B, 0x00000080, 0x95279DD9, 0x23AAF7BF,
            0x5B2FFAB3, 0x97DE73F8, 0x00000000, 0xD9224825, 0x7C7A53D8, 0x9B25D98A, 0xBAE70BD4, 0x00000000,
            0x3E20E155, 0x3C400BF2, 0xF0ADBC14, 0x6CD28774, 0x00000080, 0x17F8DF6D, 0x74376070, 0x598703DB,
            0x1B118FF1, 0x00000080, 0x25ED3664, 0xF7096CD9, 0xE135D0DD, 0x40F940F8, 0x00000080, 0xD86C6CBC,
            0x071434C0, 0xB4598EF4, 0x17265E5E, 0x00000080, 0x92E70F65, 0x18DB4D59, 0x64D5AEC7, 0x4173BD97,
            0x00000080, 0x7616ACDA, 0xD8706F92, 0x4C43143F, 0xEAEAB4AC, 0x00000080, 0xDA8AD0EC, 0x9CA7EE93,
            0x88FC7829, 0x22CE650C, 0x00000000, 0x54DA12D0, 0xBADE62FA, 0x3CE5F216, 0xD79E8E77, 0x00000000,
            0xE7578574, 0x3FC87429, 0xA033A72D, 0x37E5E157, 0x00000080, 0xD39EF6AF, 0x771102D5, 0x4BE264A4,
            0x1A077FFB, 0x00000080, 0x11D3962D, 0xA5F1C51C, 0x89CA4F59, 0xE1829499, 0x00000080, 0xB9876659,
            0xD043E285, 0x9E3D21E0, 0x82E4D55B, 0x00000080, 0x95D52840, 0x2F16E9D6, 0xE136C141, 0x4919F7F5,
            0x00000080, 0xD2458668, 0x1C823030, 0x34A85725, 0x6233C6F2, 0x00000000, 0x5A1B9078, 0x7B4E385C,
            0x99D15869, 0x7577A252, 0x00000080, 0x6A752706, 0xC06F5DC6, 0x34BF60AB, 0xFA09D523, 0x00000080,
            0x20B3F4F0, 0x6714E85E, 0x9727942F, 0x0489A077, 0x00000080, 0x40AA8422, 0xC36B8051, 0x3DD35A41,
            0xA4050D51, 0x00000080, 0xBD341E4E, 0xCAAC63E1, 0x340ABB87, 0xD6FF394E, 0x00000000, 0xED4302CE,
            0xB8327470, 0x9E51B4A9, 0xD7B612D9, 0x00000000, 0x598EBEA5, 0xD7AB54CB, 0x3B1C1FC0, 0x3F67E40A,
            0x00000000, 0x0CFD3BDB, 0xF0CFBD8A, 0x795EB1BB, 0xBF258F5D, 0x00000000, 0x45198BD1, 0xE104C590,
            0xF6F0A93E, 0x3890C39A, 0x00000000, 0x0728A154, 0xD27CA9A4, 0xCF67A309, 0x52F29768, 0x00000000,
            0x98D073A7, 0x6745CF76, 0x70BFEDD8, 0x900DE725, 0x00000080, 0xDD784D39, 0x779D5D8A, 0xC958911E,
            0x0774EA58, 0x00000080, 0xB54886CA, 0x7B7C53A6, 0x95A408A0, 0xC897839F, 0x00000000, 0xF5B395EC,
            0x8026B1C2, 0x77F6E633, 0x5EEE5833, 0x00000080, 0xCA9EA41C, 0xC26359A1, 0x1854F7E7, 0x1BFA40BB,
            0x00000080, 0xCF19BD9C, 0x54BA2AF9, 0xE709F8F8, 0x121E7BBA, 0x00000000, 0x52422A11, 0x2AB2FB15,
            0x167EABAA, 0xA3CE5794, 0x00000080, 0x1C86EC85, 0x77BE6953, 0x7B3822BB, 0x3BEF4B92, 0x00000000,
            0xC27CD987, 0x6701A1A4, 0x227EE46B, 0x5CEFE43B, 0x00000080, 0x0F58BF0B, 0x77290A59, 0xA19A065A,
            0x41C8EBEA, 0x00000080, 0x1631A434, 0x304A499D, 0x9981867D, 0xAA58911A, 0x00000080, 0x81245A72,
            0x5A733EDA, 0xC874396C, 0xDFBAB46F, 0x00000080, 0x05F0B3A9, 0x4451F527, 0x290B986B, 0x2F4068EE,
            0x00000000, 0x87F75B02, 0x233014FA, 0x32D2E4CC, 0xEFDF48B4, 0x00000000, 0xCE6A55F6, 0x6B1FE9A2,
            0x9882DB76, 0xD2DC7883, 0x00000000, 0xA943710E, 0x1AC2664C, 0x6FD95ED9, 0x2B4FE61E, 0x00000000,
            0x7326A05D, 0xFB2840E2, 0x005E9BC3, 0x74BE60F4, 0x00000000, 0xDDA800A2, 0x8AE67155, 0x82D0815B,
            0xDBFACB2C, 0x00000080, 0xFD1E7F89, 0x0BF62ED1, 0x5B212630, 0x0F3B40EB, 0x00000080, 0x5F456FEE,
            0x2A98E1EC, 0x3D05F629, 0x926DF8D0, 0x00000080, 0x7A20C92E, 0x960DD67B, 0x1B48A52D, 0xD972AB51,
            0x00000000, 0x6FC58C35, 0x58BA091A, 0x2DFB7455, 0xA01DF444, 0x00000080, 0xAB5F6652, 0xED3BA4BE,
            0x617871A0, 0x9EC0BA47, 0x00000000, 0xCF710346, 0x7F1987CB, 0xEB51CF7E, 0xF1FB81F9, 0x00000000,
            0xDF0A0483, 0x51F498C6, 0xD7E60422, 0x9225DF4A, 0x00000000, 0xAD7C9768, 0x19434F65, 0xACAE6DCB,
            0x83785485, 0x00000080, 0x3AA47D4D, 0xDEF0343C, 0x4DFDCD11, 0x914FE1E3, 0x00000080, 0xFF5A9381,
            0xA5FE4BE5, 0x1F342F6A, 0x80B843F5, 0x00000080, 0x0CC4A5CF, 0x40547EE3, 0x071E5336, 0x0FEB82D1,
            0x00000080, 0x75732B51, 0x93C3776C, 0x8F9F26DF, 0xEDDF748E, 0x00000000, 0x1B7FC63B, 0xA7EA02CB,
            0x7EFF5054, 0x17EF6E53, 0x00000000, 0x440B33D5, 0x809CA7CF, 0x896BDAD1, 0x2B7504F1, 0x00000000,
            0x8057C895, 0x1E4AE696, 0xE0F10A0F, 0xAA526500, 0x00000000, 0xB0E6784A, 0x0F7B952D, 0x7B5DE293,
            0x79EED9AB, 0x00000000, 0x912B433A, 0xEA841996, 0x57DC6052, 0xF07D3CA6, 0x00000080, 0x7978F2C6,
            0xBB7D4586, 0xAAC595FA, 0x9AF777A9, 0x00000080, 0x4BDD5EC4, 0x66D8192A, 0x252FE02E, 0xCCF74E46,
            0x00000000, 0x18CF7732, 0x8DD3539F, 0x75533DB8, 0x42ED8BC0, 0x00000000, 0xC490B7B1, 0x2847E0E2,
            0xE91276A4, 0x4900F99E, 0x00000000, 0x81198DEC, 0x69526136, 0xA2EC6BA6, 0x09F2F9EE, 0x00000000,
            0x579C47A8, 0x61C7B804, 0xB2C771F5, 0x23A79387, 0x00000080, 0x049EAF5F, 0x52107EA3, 0x8BFDAB85,
            0x18150D27, 0x00000080, 0x619E46F8, 0x040AA83C, 0x6CAB728E, 0xA0CBD3A6, 0x00000000, 0xAB59C12D,
            0xE5C46C71, 0xD009D24B, 0x9B89A1EA, 0x00000000, 0xA0593642, 0xC885A21A, 0x01DB8337, 0x0B06D237,
            0x00000000, 0xC2A283F2, 0x732243C0, 0x336C20C9, 0x6E6DE500, 0x00000000, 0xE553383C, 0x32B8418B,
            0xB0222C6C, 0x0C89031A, 0x00000080, 0x88983D48, 0x6DC0240D, 0xDD69879F, 0x1B1B6623, 0x00000000,
            0x1BC57532, 0xEC7FBB74, 0x19853364, 0x432DEFA1, 0x00000080, 0x24F0778B, 0xFD8D5FFD, 0x01B7459B,
            0x2ED687B5, 0x00000080, 0xBC0315A3, 0x3420A122, 0xB7902670, 0xBD3A4DE6, 0x00000000, 0x462FF93A,
            0x6CFB8C3F, 0xAC85EF32, 0xB08DC113, 0x00000000, 0x9818F2AA, 0x46227C08, 0xC09C7368, 0x29534492,
            0x00000080, 0xE34FD4B5, 0xAA0D24E9, 0x19365F3A, 0xF6F54E75, 0x00000000, 0xBA55D3CC, 0xF81CD6B8,
            0xF56579E9, 0x1EACE117, 0x00000000, 0xC76C0C18, 0xCE06B1B6, 0x4008EED8, 0x032F3FE1, 0x00000000,
            0xD1144AF9, 0x338D8B04, 0x9373B02D, 0x284CA8D3, 0x00000080, 0xB436A4BE, 0xDF328D8A, 0x7A2FC0BB,
            0x4FBC53EB, 0x00000000, 0x81B82723, 0x08677842, 0x3075C40B, 0xA83F35A1, 0x00000000, 0x0EFC9181,
            0x088BC90E, 0x6C8C8096, 0x7042941E, 0x00000080, 0xDAD6DF23, 0x3F5041BA, 0x6489C66E, 0xB914ACD2,
            0x00000080, 0x0690C9FF, 0xE781914C, 0x96350705, 0xC8F72639, 0x00000080, 0x0C5D6620, 0x6C5A4A5A,
            0x25EA8626, 0x311B8455, 0x00000000, 0xBD408B59, 0x096EC6FE, 0x5BE9B1E5, 0xCBC33061, 0x00000000,
            0xF3A6FA68, 0xF947D51B, 0xE2CB890B, 0x9A674DAA, 0x00000080, 0x07E54699, 0xDA3F27E4, 0xC3D97C43,
            0xA6106088, 0x00000000, 0x24A971BC, 0x507A1096, 0x7010E46C, 0x889FC6B1, 0x00000000, 0x1CB8B019,
            0xE0D7D88B, 0x10101B8F, 0x5240B1AE, 0x00000080,
        };

        /// <summary>Length: 20</summary>
        private static readonly uint[] s_roundConstants_full = new uint[]
        {
            0xBB7D4B54, 0x08C65135, 0x0AE32C6A, 0xC36D5022, 0x00000080, 0x5C49D7B4, 0x6F78814C, 0xEA161571,
            0x9A70EFF5, 0x00000000, 0x76E0C5E0, 0x266C2FB5, 0x2FDE155A, 0xB121D6A3, 0x00000080, 0x92409C3D,
            0xCD4C21E4, 0xDD6D8549, 0x603606EE, 0x00000080,
        };
    }
}