﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;
using System.Text.Json.Serialization;

namespace Microsoft.Extensions.AI;

/// <summary>Represents an embedding generated by a <see cref="IEmbeddingGenerator{TInput, TEmbedding}"/>.</summary>
/// <remarks>This base class provides metadata about the embedding. Derived types provide the concrete data contained in the embedding.</remarks>
[JsonPolymorphic(TypeDiscriminatorPropertyName = "$type")]
#if NET
[JsonDerivedType(typeof(Embedding<Half>), typeDiscriminator: "halves")]
#endif
[JsonDerivedType(typeof(Embedding<float>), typeDiscriminator: "floats")]
[JsonDerivedType(typeof(Embedding<double>), typeDiscriminator: "doubles")]
[JsonDerivedType(typeof(Embedding<byte>), typeDiscriminator: "bytes")]
[JsonDerivedType(typeof(Embedding<sbyte>), typeDiscriminator: "sbytes")]
public class Embedding
{
    /// <summary>Initializes a new instance of the <see cref="Embedding"/> class.</summary>
    protected Embedding()
    {
    }

    /// <summary>Gets or sets a timestamp at which the embedding was created.</summary>
    public DateTimeOffset? CreatedAt { get; set; }

    /// <summary>Gets or sets the model ID using in the creation of the embedding.</summary>
    public string? ModelId { get; set; }

    /// <summary>Gets or sets any additional properties associated with the embedding.</summary>
    public AdditionalPropertiesDictionary? AdditionalProperties { get; set; }
}
