---
name: Design proposal
about: Collaborate on a design for a feature/fix or other change
labels: design-proposal
---

<!--
This template is useful to build consensus about whether work should be done, and if so, the high-level shape of how it should be approached. Use this before fixating on a particular implementation.
-->

## Summary

1-2 sentences. Say what this is about.

## Motivation and goals

1-2 paragraphs, or a bullet-pointed list. What existing pain points does this solve? What evidence shows it's valuable to solve this?

## In scope

A list of major scenarios, perhaps in priority order.

## Out of scope

Scenarios you explicitly want to exclude.

## Risks / unknowns

How might developers misinterpret/misuse this? How might implementing it restrict us from other enhancements in the future? Also list any perf/security/correctness concerns.

## Examples

Give brief examples of possible developer experiences (e.g., code they would write).

Don't be deeply concerned with how it would be implemented yet. Your examples could even be from other technology stacks.

<!--
# Detailed design
It's often best not to fill this out until you get basic consensus about the above. When you do, consider adding an implementation proposal with the following headings:
Detailed design
Drawbacks
Considered alternatives
Open questions
References
If there's one clear design you have consensus on, you could do that directly in a PR.
-->
