﻿// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

using System;
#if SUPPORTS_SYSTEM_TEXT_JSON
using Microsoft.Identity.Client.Platforms.net6;
using JsonProperty = System.Text.Json.Serialization.JsonPropertyNameAttribute;
#else
using Microsoft.Identity.Json;
#endif

namespace Microsoft.Identity.Client.ManagedIdentity
{
    [JsonObject]
    [Preserve(AllMembers = true)]
    internal class ManagedIdentityResponse
    {
        /// <summary>
        /// The requested access token.
        /// </summary>
        /// <remarks>When you call a secured REST API, the token is embedded in the Authorization 
        /// request header field as a "bearer" token, 
        /// allowing the API to authenticate the caller.</remarks>
        [JsonProperty("access_token")]
        public string AccessToken { get; set; }

        /// <summary>
        /// The timespan when the access token expires.
        /// </summary>
        /// <remarks>The date is represented as the number of seconds from "1970-01-01T0:0:0Z UTC" 
        /// (corresponds to the token's exp claim).</remarks>
        [JsonProperty("expires_on")]
        public string ExpiresOn { get; set; }

        /// <summary>
        /// The resource the access token was requested for.
        /// </summary>
        /// <remarks>Which matches the resource query string parameter of the request.</remarks>
        [JsonProperty("resource")]
        public string Resource { get; set; }

        /// <summary>
        /// The type of token returned by the Managed Identity endpoint.
        /// </summary>
        /// <remarks>which is a "Bearer" access token, which means the resource 
        /// can give access to the bearer of this token.</remarks>
        [JsonProperty("token_type")]
        public string TokenType { get; set; }

        /// <summary>
        /// A unique identifier generated by Azure AD for the Azure Resource.
        /// </summary>
        /// <remarks>The Client ID is a GUID value that uniquely identifies the application 
        /// and its configuration within the identity platform</remarks>
        [JsonProperty("client_id")]
        public string ClientId { get; set; }

    }
}
