﻿// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Microsoft.Identity.Client.TelemetryCore.Internal.Events;
using static Microsoft.Identity.Client.TelemetryCore.Internal.Events.ApiEvent;

namespace Microsoft.Identity.Client
{
    /// <summary>
    /// This exception indicates that claims have been returned from the endpoint that need to be resolved. This can be achieved by using them in the next authentication request.
    /// See <see href="https://aka.ms/msal-conditional-access-claims">Conditional Access and claims challenges</see>.
    /// See <see href="https://aka.ms/msal-conditional-access-claims-obo">Handling multifactor auth (MFA), Conditional Access, and incremental consent</see>.
    /// </summary>
    public class MsalClaimsChallengeException : MsalUiRequiredException
    {
        /// <summary>
        /// Initializes a new instance of the exception class with a specified
        /// error code and error message.
        /// </summary>
        /// <param name="errorCode">
        /// The error code returned by the service or generated by the client. This is the code you can rely on
        /// for exception handling.
        /// </param>
        /// <param name="errorMessage">The error message that explains the reason for the exception.</param>
        public MsalClaimsChallengeException(string errorCode, string errorMessage) : base(errorCode, errorMessage)
        {
        }

        /// <summary>
        /// Initializes a new instance of the exception class with a specified
        /// error code, error message and inner exception indicating the root cause.
        /// </summary>
        /// <param name="errorCode">
        /// The error code returned by the service or generated by the client. This is the code you can rely on
        /// for exception handling.
        /// </param>
        /// <param name="errorMessage">The error message that explains the reason for the exception.</param>
        /// <param name="innerException">Represents the root cause of the exception.</param>
        public MsalClaimsChallengeException(string errorCode, string errorMessage, Exception innerException) :
            this(errorCode, errorMessage, innerException, UiRequiredExceptionClassification.None)
        {
        }

        /// <summary>
        /// Initializes a new instance of the exception class with a specified
        /// error code, error message and inner exception indicating the root cause.
        /// </summary>
        /// <param name="errorCode">
        /// The error code returned by the service or generated by the client. This is the code you can rely on
        /// for exception handling.
        /// </param>
        /// <param name="errorMessage">The error message that explains the reason for the exception.</param>
        /// <param name="innerException">Represents the root cause of the exception.</param>
        /// <param name="classification">A higher level description for this exception, that allows handling code to 
        /// understand what type of action it needs to take to resolve the issue. </param>
        public MsalClaimsChallengeException(string errorCode, string errorMessage, Exception innerException, UiRequiredExceptionClassification classification) :
            base(errorCode, errorMessage, innerException, classification)
        {
        }
    }
}
