﻿// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

using System;
using System.ComponentModel;
using System.Net;
using Microsoft.Identity.Client.ManagedIdentity;

namespace Microsoft.Identity.Client
{
    /// <summary>
    /// This exception class is for exceptions generated from Managed Identity sources.
    /// This class is deprecated and will be removed in a future release. 
    /// Catch MsalServiceException instead.
    /// For more details, see https://aka.ms/msal-net-managed-identity
    /// </summary>
    [Obsolete("MsalManagedIdentityException is deprecated and will be removed in a future release. Catch MsalServiceException instead.", true)]
    [EditorBrowsable(EditorBrowsableState.Never)]
    public class MsalManagedIdentityException : MsalServiceException
    {
        /// <summary>
        /// Initializes a new instance of the exception class with a specified
        /// error code, error message and inner exception indicating the root cause.
        /// </summary>
        /// <param name="errorCode">
        /// The error code returned by the service or generated by the client. This is the code you can rely on
        /// for exception handling.
        /// </param>
        /// <param name="errorMessage">The error message that explains the reason for the exception.</param>
        /// <param name="source">Specifies the managed identity source from which the exception initiates.</param>
        public MsalManagedIdentityException(string errorCode, string errorMessage, ManagedIdentitySource source) :
            this(errorCode, errorMessage, null, source)
        {
        }

        /// <summary>
        /// Initializes a new instance of the exception class with a specified
        /// error code, error message and inner exception indicating the root cause.
        /// </summary>
        /// <param name="errorCode">
        /// The error code returned by the service or generated by the client. This is the code you can rely on
        /// for exception handling.
        /// </param>
        /// <param name="errorMessage">The error message that explains the reason for the exception.</param>
        /// <param name="source">Specifies the managed identity source from which the exception initiates.</param>
        /// <param name="statusCode">The status code of the response.</param>
        public MsalManagedIdentityException(string errorCode, string errorMessage, ManagedIdentitySource source, int statusCode) :
            this(errorCode, errorMessage, null, source, statusCode)
        {
        }

        /// <summary>
        /// Initializes a new instance of the exception class with a specified
        /// error code, error message and managed identity source.
        /// </summary>
        /// <param name="errorCode">
        /// The error code returned by the service or generated by the client. This is the code you can rely on
        /// for exception handling.
        /// </param>
        /// <param name="errorMessage">The error message that explains the reason for the exception.</param>
        /// <param name="innerException">Represents the root cause of the exception.</param>
        /// <param name="source">Specifies the managed identity source from which the exception initiates.</param>
        /// <param name="statusCode">The status code of the response.</param>
        public MsalManagedIdentityException(string errorCode, string errorMessage, Exception innerException, ManagedIdentitySource source, int statusCode) :
            this(errorCode, errorMessage, innerException, source)
        {
            StatusCode = statusCode;
        }

        /// <summary>
        /// Initializes a new instance of the exception class with a specified
        /// error code, error message and managed identity source.
        /// </summary>
        /// <param name="errorCode">
        /// The error code returned by the service or generated by the client. This is the code you can rely on
        /// for exception handling.
        /// </param>
        /// <param name="errorMessage">The error message that explains the reason for the exception.</param>
        /// <param name="innerException">Represents the root cause of the exception.</param>
        /// <param name="source">Specifies the managed identity source from which the exception initiates.</param>
        public MsalManagedIdentityException(string errorCode, string errorMessage, Exception innerException, ManagedIdentitySource source) :
            base(errorCode, errorMessage, innerException)
        {
            ManagedIdentitySource = source;
        }

        /// <summary>
        /// Specifies the managed identity source from which the exception initiates.
        /// </summary>
        public new ManagedIdentitySource ManagedIdentitySource { get; }

        /// <summary>
        /// Retry error codes specific to managed identity
        /// </summary>
        protected override void UpdateIsRetryable()
        {
            switch (StatusCode)
            {
                case 404: //Not Found
                case 408: // Request Timeout
                case 429: // Too Many Requests
                case 500: // Internal Server Error
                case 503: // Service Unavailable
                case 504: // Gateway Timeout
                    IsRetryable = true;
                    break;
                default:
                    IsRetryable = false;
                    break;
            }
        }
    }
}
