#region License
// Copyright (c) 2007 James Newton-King
//
// Permission is hereby granted, free of charge, to any person
// obtaining a copy of this software and associated documentation
// files (the "Software"), to deal in the Software without
// restriction, including without limitation the rights to use,
// copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following
// conditions:
//
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
// OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
// HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// OTHER DEALINGS IN THE SOFTWARE.
#endregion

namespace Microsoft.Identity.Json
{
    /// <summary>
    /// Indicating whether a property is required.
    /// </summary>
    internal enum Required
    {
        /// <summary>
        /// The property is not required. The default state.
        /// </summary>
        Default = 0,

        /// <summary>
        /// The property must be defined in JSON but can be a null value.
        /// </summary>
        AllowNull = 1,

        /// <summary>
        /// The property must be defined in JSON and cannot be a null value.
        /// </summary>
        Always = 2,

        /// <summary>
        /// The property is not required but it cannot be a null value.
        /// </summary>
        DisallowNull = 3
    }
}