// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// <auto-generated>This file has been auto generated from 'src\OpenTelemetry.SemanticConventions\scripts\templates\registry\SemanticConventionsAttributes.cs.j2' </auto-generated>

#nullable enable

#pragma warning disable CS1570 // XML comment has badly formed XML

namespace OpenTelemetry.SemanticConventions;

/// <summary>
/// Constants for semantic attribute names outlined by the OpenTelemetry specifications.
/// </summary>
public static class ArtifactAttributes
{
    /// <summary>
    /// The provenance filename of the built attestation which directly relates to the build artifact filename. This filename SHOULD accompany the artifact at publish time. See the <a href="https://slsa.dev/spec/v1.0/distributing-provenance#relationship-between-artifacts-and-attestations">SLSA Relationship</a> specification for more information.
    /// </summary>
    public const string AttributeArtifactAttestationFilename = "artifact.attestation.filename";

    /// <summary>
    /// The full <a href="https://nvlpubs.nist.gov/nistpubs/FIPS/NIST.FIPS.186-5.pdf">hash value (see glossary)</a>, of the built attestation. Some envelopes in the software attestation space also refer to this as the <a href="https://github.com/in-toto/attestation/blob/main/spec/README.md#in-toto-attestation-framework-spec">digest</a>.
    /// </summary>
    public const string AttributeArtifactAttestationHash = "artifact.attestation.hash";

    /// <summary>
    /// The id of the build <a href="https://slsa.dev/attestation-model">software attestation</a>.
    /// </summary>
    public const string AttributeArtifactAttestationId = "artifact.attestation.id";

    /// <summary>
    /// The human readable file name of the artifact, typically generated during build and release processes. Often includes the package name and version in the file name.
    /// </summary>
    /// <remarks>
    /// This file name can also act as the <a href="https://slsa.dev/spec/v1.0/terminology#package-model">Package Name</a>
    /// in cases where the package ecosystem maps accordingly.
    /// Additionally, the artifact <a href="https://slsa.dev/spec/v1.0/terminology#software-supply-chain">can be published</a>
    /// for others, but that is not a guarantee.
    /// </remarks>
    public const string AttributeArtifactFilename = "artifact.filename";

    /// <summary>
    /// The full <a href="https://nvlpubs.nist.gov/nistpubs/FIPS/NIST.FIPS.186-5.pdf">hash value (see glossary)</a>, often found in checksum.txt on a release of the artifact and used to verify package integrity.
    /// </summary>
    /// <remarks>
    /// The specific algorithm used to create the cryptographic hash value is
    /// not defined. In situations where an artifact has multiple
    /// cryptographic hashes, it is up to the implementer to choose which
    /// hash value to set here; this should be the most secure hash algorithm
    /// that is suitable for the situation and consistent with the
    /// corresponding attestation. The implementer can then provide the other
    /// hash values through an additional set of attribute extensions as they
    /// deem necessary.
    /// </remarks>
    public const string AttributeArtifactHash = "artifact.hash";

    /// <summary>
    /// The <a href="https://github.com/package-url/purl-spec">Package URL</a> of the <a href="https://slsa.dev/spec/v1.0/terminology#package-model">package artifact</a> provides a standard way to identify and locate the packaged artifact.
    /// </summary>
    public const string AttributeArtifactPurl = "artifact.purl";

    /// <summary>
    /// The version of the artifact.
    /// </summary>
    public const string AttributeArtifactVersion = "artifact.version";
}
