// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// <auto-generated>This file has been auto generated from 'src\OpenTelemetry.SemanticConventions\scripts\templates\registry\SemanticConventionsAttributes.cs.j2' </auto-generated>

#nullable enable

#pragma warning disable CS1570 // XML comment has badly formed XML

namespace OpenTelemetry.SemanticConventions;

/// <summary>
/// Constants for semantic attribute names outlined by the OpenTelemetry specifications.
/// </summary>
public static class HostAttributes
{
    /// <summary>
    /// The CPU architecture the host system is running on.
    /// </summary>
    public const string AttributeHostArch = "host.arch";

    /// <summary>
    /// The amount of level 2 memory cache available to the processor (in Bytes).
    /// </summary>
    public const string AttributeHostCpuCacheL2Size = "host.cpu.cache.l2.size";

    /// <summary>
    /// Family or generation of the CPU.
    /// </summary>
    public const string AttributeHostCpuFamily = "host.cpu.family";

    /// <summary>
    /// Model identifier. It provides more granular information about the CPU, distinguishing it from other CPUs within the same family.
    /// </summary>
    public const string AttributeHostCpuModelId = "host.cpu.model.id";

    /// <summary>
    /// Model designation of the processor.
    /// </summary>
    public const string AttributeHostCpuModelName = "host.cpu.model.name";

    /// <summary>
    /// Stepping or core revisions.
    /// </summary>
    public const string AttributeHostCpuStepping = "host.cpu.stepping";

    /// <summary>
    /// Processor manufacturer identifier. A maximum 12-character string.
    /// </summary>
    /// <remarks>
    /// <a href="https://wiki.osdev.org/CPUID">CPUID</a> command returns the vendor ID string in EBX, EDX and ECX registers. Writing these to memory in this order results in a 12-character string.
    /// </remarks>
    public const string AttributeHostCpuVendorId = "host.cpu.vendor.id";

    /// <summary>
    /// Unique host ID. For Cloud, this must be the instance_id assigned by the cloud provider. For non-containerized systems, this should be the <c>machine-id</c>. See the table below for the sources to use to determine the <c>machine-id</c> based on operating system.
    /// </summary>
    public const string AttributeHostId = "host.id";

    /// <summary>
    /// VM image ID or host OS image ID. For Cloud, this value is from the provider.
    /// </summary>
    public const string AttributeHostImageId = "host.image.id";

    /// <summary>
    /// Name of the VM image or OS install the host was instantiated from.
    /// </summary>
    public const string AttributeHostImageName = "host.image.name";

    /// <summary>
    /// The version string of the VM image or host OS as defined in <a href="/docs/resource/README.md#version-attributes">Version Attributes</a>.
    /// </summary>
    public const string AttributeHostImageVersion = "host.image.version";

    /// <summary>
    /// Available IP addresses of the host, excluding loopback interfaces.
    /// </summary>
    /// <remarks>
    /// IPv4 Addresses MUST be specified in dotted-quad notation. IPv6 addresses MUST be specified in the <a href="https://www.rfc-editor.org/rfc/rfc5952.html">RFC 5952</a> format.
    /// </remarks>
    public const string AttributeHostIp = "host.ip";

    /// <summary>
    /// Available MAC addresses of the host, excluding loopback interfaces.
    /// </summary>
    /// <remarks>
    /// MAC Addresses MUST be represented in <a href="https://standards.ieee.org/wp-content/uploads/import/documents/tutorials/eui.pdf">IEEE RA hexadecimal form</a>: as hyphen-separated octets in uppercase hexadecimal form from most to least significant.
    /// </remarks>
    public const string AttributeHostMac = "host.mac";

    /// <summary>
    /// Name of the host. On Unix systems, it may contain what the hostname command returns, or the fully qualified hostname, or another name specified by the user.
    /// </summary>
    public const string AttributeHostName = "host.name";

    /// <summary>
    /// Type of host. For Cloud, this must be the machine type.
    /// </summary>
    public const string AttributeHostType = "host.type";

    /// <summary>
    /// The CPU architecture the host system is running on.
    /// </summary>
    public static class HostArchValues
    {
        /// <summary>
        /// AMD64.
        /// </summary>
        public const string Amd64 = "amd64";

        /// <summary>
        /// ARM32.
        /// </summary>
        public const string Arm32 = "arm32";

        /// <summary>
        /// ARM64.
        /// </summary>
        public const string Arm64 = "arm64";

        /// <summary>
        /// Itanium.
        /// </summary>
        public const string Ia64 = "ia64";

        /// <summary>
        /// 32-bit PowerPC.
        /// </summary>
        public const string Ppc32 = "ppc32";

        /// <summary>
        /// 64-bit PowerPC.
        /// </summary>
        public const string Ppc64 = "ppc64";

        /// <summary>
        /// IBM z/Architecture.
        /// </summary>
        public const string S390x = "s390x";

        /// <summary>
        /// 32-bit x86.
        /// </summary>
        public const string X86 = "x86";
    }
}
