// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// <auto-generated>This file has been auto generated from 'src\OpenTelemetry.SemanticConventions\scripts\templates\registry\SemanticConventionsAttributes.cs.j2' </auto-generated>

#nullable enable

#pragma warning disable CS1570 // XML comment has badly formed XML

namespace OpenTelemetry.SemanticConventions;

/// <summary>
/// Constants for semantic attribute names outlined by the OpenTelemetry specifications.
/// </summary>
public static class HwAttributes
{
    /// <summary>
    /// An identifier for the hardware component, unique within the monitored host.
    /// </summary>
    public const string AttributeHwId = "hw.id";

    /// <summary>
    /// An easily-recognizable name for the hardware component.
    /// </summary>
    public const string AttributeHwName = "hw.name";

    /// <summary>
    /// Unique identifier of the parent component (typically the <c>hw.id</c> attribute of the enclosure, or disk controller).
    /// </summary>
    public const string AttributeHwParent = "hw.parent";

    /// <summary>
    /// The current state of the component.
    /// </summary>
    public const string AttributeHwState = "hw.state";

    /// <summary>
    /// Type of the component.
    /// </summary>
    /// <remarks>
    /// Describes the category of the hardware component for which <c>hw.state</c> is being reported. For example, <c>hw.type=temperature</c> along with <c>hw.state=degraded</c> would indicate that the temperature of the hardware component has been reported as <c>degraded</c>.
    /// </remarks>
    public const string AttributeHwType = "hw.type";

    /// <summary>
    /// The current state of the component.
    /// </summary>
    public static class HwStateValues
    {
        /// <summary>
        /// Ok.
        /// </summary>
        public const string Ok = "ok";

        /// <summary>
        /// Degraded.
        /// </summary>
        public const string Degraded = "degraded";

        /// <summary>
        /// Failed.
        /// </summary>
        public const string Failed = "failed";
    }

    /// <summary>
    /// Type of the component.
    /// </summary>
    public static class HwTypeValues
    {
        /// <summary>
        /// Battery.
        /// </summary>
        public const string Battery = "battery";

        /// <summary>
        /// CPU.
        /// </summary>
        public const string Cpu = "cpu";

        /// <summary>
        /// Disk controller.
        /// </summary>
        public const string DiskController = "disk_controller";

        /// <summary>
        /// Enclosure.
        /// </summary>
        public const string Enclosure = "enclosure";

        /// <summary>
        /// Fan.
        /// </summary>
        public const string Fan = "fan";

        /// <summary>
        /// GPU.
        /// </summary>
        public const string Gpu = "gpu";

        /// <summary>
        /// Logical disk.
        /// </summary>
        public const string LogicalDisk = "logical_disk";

        /// <summary>
        /// Memory.
        /// </summary>
        public const string Memory = "memory";

        /// <summary>
        /// Network.
        /// </summary>
        public const string Network = "network";

        /// <summary>
        /// Physical disk.
        /// </summary>
        public const string PhysicalDisk = "physical_disk";

        /// <summary>
        /// Power supply.
        /// </summary>
        public const string PowerSupply = "power_supply";

        /// <summary>
        /// Tape drive.
        /// </summary>
        public const string TapeDrive = "tape_drive";

        /// <summary>
        /// Temperature.
        /// </summary>
        public const string Temperature = "temperature";

        /// <summary>
        /// Voltage.
        /// </summary>
        public const string Voltage = "voltage";
    }
}
