// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// <auto-generated>This file has been auto generated from 'src\OpenTelemetry.SemanticConventions\scripts\templates\registry\SemanticConventionsAttributes.cs.j2' </auto-generated>

#nullable enable

#pragma warning disable CS1570 // XML comment has badly formed XML

namespace OpenTelemetry.SemanticConventions;

/// <summary>
/// Constants for semantic attribute names outlined by the OpenTelemetry specifications.
/// </summary>
public static class OsAttributes
{
    /// <summary>
    /// Unique identifier for a particular build or compilation of the operating system.
    /// </summary>
    public const string AttributeOsBuildId = "os.build_id";

    /// <summary>
    /// Human readable (not intended to be parsed) OS version information, like e.g. reported by <c>ver</c> or <c>lsb_release -a</c> commands.
    /// </summary>
    public const string AttributeOsDescription = "os.description";

    /// <summary>
    /// Human readable operating system name.
    /// </summary>
    public const string AttributeOsName = "os.name";

    /// <summary>
    /// The operating system type.
    /// </summary>
    public const string AttributeOsType = "os.type";

    /// <summary>
    /// The version string of the operating system as defined in <a href="/docs/resource/README.md#version-attributes">Version Attributes</a>.
    /// </summary>
    public const string AttributeOsVersion = "os.version";

    /// <summary>
    /// The operating system type.
    /// </summary>
    public static class OsTypeValues
    {
        /// <summary>
        /// Microsoft Windows.
        /// </summary>
        public const string Windows = "windows";

        /// <summary>
        /// Linux.
        /// </summary>
        public const string Linux = "linux";

        /// <summary>
        /// Apple Darwin.
        /// </summary>
        public const string Darwin = "darwin";

        /// <summary>
        /// FreeBSD.
        /// </summary>
        public const string Freebsd = "freebsd";

        /// <summary>
        /// NetBSD.
        /// </summary>
        public const string Netbsd = "netbsd";

        /// <summary>
        /// OpenBSD.
        /// </summary>
        public const string Openbsd = "openbsd";

        /// <summary>
        /// DragonFly BSD.
        /// </summary>
        public const string Dragonflybsd = "dragonflybsd";

        /// <summary>
        /// HP-UX (Hewlett Packard Unix).
        /// </summary>
        public const string Hpux = "hpux";

        /// <summary>
        /// AIX (Advanced Interactive eXecutive).
        /// </summary>
        public const string Aix = "aix";

        /// <summary>
        /// SunOS, Oracle Solaris.
        /// </summary>
        public const string Solaris = "solaris";

        /// <summary>
        /// IBM z/OS.
        /// </summary>
        public const string ZOs = "z_os";
    }
}
