// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// <auto-generated>This file has been auto generated from 'src\OpenTelemetry.SemanticConventions\scripts\templates\registry\SemanticConventionsAttributes.cs.j2' </auto-generated>

#nullable enable

#pragma warning disable CS1570 // XML comment has badly formed XML

namespace OpenTelemetry.SemanticConventions;

/// <summary>
/// Constants for semantic attribute names outlined by the OpenTelemetry specifications.
/// </summary>
public static class OtelAttributes
{
    /// <summary>
    /// The name of the instrumentation scope - (<c>InstrumentationScope.Name</c> in OTLP).
    /// </summary>
    public const string AttributeOtelScopeName = "otel.scope.name";

    /// <summary>
    /// The version of the instrumentation scope - (<c>InstrumentationScope.Version</c> in OTLP).
    /// </summary>
    public const string AttributeOtelScopeVersion = "otel.scope.version";

    /// <summary>
    /// Name of the code, either "OK" or "ERROR". MUST NOT be set if the status code is UNSET.
    /// </summary>
    public const string AttributeOtelStatusCode = "otel.status_code";

    /// <summary>
    /// Description of the Status if it has a value, otherwise not set.
    /// </summary>
    public const string AttributeOtelStatusDescription = "otel.status_description";

    /// <summary>
    /// Name of the code, either "OK" or "ERROR". MUST NOT be set if the status code is UNSET.
    /// </summary>
    public static class OtelStatusCodeValues
    {
        /// <summary>
        /// The operation has been validated by an Application developer or Operator to have completed successfully.
        /// </summary>
        public const string Ok = "OK";

        /// <summary>
        /// The operation contains an error.
        /// </summary>
        public const string Error = "ERROR";
    }
}
