// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// <auto-generated>This file has been auto generated from 'src\OpenTelemetry.SemanticConventions\scripts\templates\registry\SemanticConventionsAttributes.cs.j2' </auto-generated>

#nullable enable

#pragma warning disable CS1570 // XML comment has badly formed XML

namespace OpenTelemetry.SemanticConventions;

/// <summary>
/// Constants for semantic attribute names outlined by the OpenTelemetry specifications.
/// </summary>
public static class CloudfoundryAttributes
{
    /// <summary>
    /// The guid of the application.
    /// </summary>
    /// <remarks>
    /// Application instrumentation should use the value from environment
    /// variable <c>VCAP_APPLICATION.application_id</c>. This is the same value as
    /// reported by <c>cf app <app-name> --guid</c>.
    /// </remarks>
    public const string AttributeCloudfoundryAppId = "cloudfoundry.app.id";

    /// <summary>
    /// The index of the application instance. 0 when just one instance is active.
    /// </summary>
    /// <remarks>
    /// CloudFoundry defines the <c>instance_id</c> in the <a href="https://github.com/cloudfoundry/loggregator-api#v2-envelope">Loggegator v2 envelope</a>.
    /// It is used for logs and metrics emitted by CloudFoundry. It is
    /// supposed to contain the application instance index for applications
    /// deployed on the runtime.
    /// <p>
    /// Application instrumentation should use the value from environment
    /// variable <c>CF_INSTANCE_INDEX</c>.
    /// </remarks>
    public const string AttributeCloudfoundryAppInstanceId = "cloudfoundry.app.instance.id";

    /// <summary>
    /// The name of the application.
    /// </summary>
    /// <remarks>
    /// Application instrumentation should use the value from environment
    /// variable <c>VCAP_APPLICATION.application_name</c>. This is the same value
    /// as reported by <c>cf apps</c>.
    /// </remarks>
    public const string AttributeCloudfoundryAppName = "cloudfoundry.app.name";

    /// <summary>
    /// The guid of the CloudFoundry org the application is running in.
    /// </summary>
    /// <remarks>
    /// Application instrumentation should use the value from environment
    /// variable <c>VCAP_APPLICATION.org_id</c>. This is the same value as
    /// reported by <c>cf org <org-name> --guid</c>.
    /// </remarks>
    public const string AttributeCloudfoundryOrgId = "cloudfoundry.org.id";

    /// <summary>
    /// The name of the CloudFoundry organization the app is running in.
    /// </summary>
    /// <remarks>
    /// Application instrumentation should use the value from environment
    /// variable <c>VCAP_APPLICATION.org_name</c>. This is the same value as
    /// reported by <c>cf orgs</c>.
    /// </remarks>
    public const string AttributeCloudfoundryOrgName = "cloudfoundry.org.name";

    /// <summary>
    /// The UID identifying the process.
    /// </summary>
    /// <remarks>
    /// Application instrumentation should use the value from environment
    /// variable <c>VCAP_APPLICATION.process_id</c>. It is supposed to be equal to
    /// <c>VCAP_APPLICATION.app_id</c> for applications deployed to the runtime.
    /// For system components, this could be the actual PID.
    /// </remarks>
    public const string AttributeCloudfoundryProcessId = "cloudfoundry.process.id";

    /// <summary>
    /// The type of process.
    /// </summary>
    /// <remarks>
    /// CloudFoundry applications can consist of multiple jobs. Usually the
    /// main process will be of type <c>web</c>. There can be additional background
    /// tasks or side-cars with different process types.
    /// </remarks>
    public const string AttributeCloudfoundryProcessType = "cloudfoundry.process.type";

    /// <summary>
    /// The guid of the CloudFoundry space the application is running in.
    /// </summary>
    /// <remarks>
    /// Application instrumentation should use the value from environment
    /// variable <c>VCAP_APPLICATION.space_id</c>. This is the same value as
    /// reported by <c>cf space <space-name> --guid</c>.
    /// </remarks>
    public const string AttributeCloudfoundrySpaceId = "cloudfoundry.space.id";

    /// <summary>
    /// The name of the CloudFoundry space the application is running in.
    /// </summary>
    /// <remarks>
    /// Application instrumentation should use the value from environment
    /// variable <c>VCAP_APPLICATION.space_name</c>. This is the same value as
    /// reported by <c>cf spaces</c>.
    /// </remarks>
    public const string AttributeCloudfoundrySpaceName = "cloudfoundry.space.name";

    /// <summary>
    /// A guid or another name describing the event source.
    /// </summary>
    /// <remarks>
    /// CloudFoundry defines the <c>source_id</c> in the <a href="https://github.com/cloudfoundry/loggregator-api#v2-envelope">Loggregator v2 envelope</a>.
    /// It is used for logs and metrics emitted by CloudFoundry. It is
    /// supposed to contain the component name, e.g. "gorouter", for
    /// CloudFoundry components.
    /// <p>
    /// When system components are instrumented, values from the
    /// <a href="https://bosh.io/docs/jobs/#properties-spec">Bosh spec</a>
    /// should be used. The <c>system.id</c> should be set to
    /// <c>spec.deployment/spec.name</c>.
    /// </remarks>
    public const string AttributeCloudfoundrySystemId = "cloudfoundry.system.id";

    /// <summary>
    /// A guid describing the concrete instance of the event source.
    /// </summary>
    /// <remarks>
    /// CloudFoundry defines the <c>instance_id</c> in the <a href="https://github.com/cloudfoundry/loggregator-api#v2-envelope">Loggregator v2 envelope</a>.
    /// It is used for logs and metrics emitted by CloudFoundry. It is
    /// supposed to contain the vm id for CloudFoundry components.
    /// <p>
    /// When system components are instrumented, values from the
    /// <a href="https://bosh.io/docs/jobs/#properties-spec">Bosh spec</a>
    /// should be used. The <c>system.instance.id</c> should be set to <c>spec.id</c>.
    /// </remarks>
    public const string AttributeCloudfoundrySystemInstanceId = "cloudfoundry.system.instance.id";
}
