// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// <auto-generated>This file has been auto generated from 'src\OpenTelemetry.SemanticConventions\scripts\templates\registry\SemanticConventionsAttributes.cs.j2' </auto-generated>

#nullable enable

#pragma warning disable CS1570 // XML comment has badly formed XML

namespace OpenTelemetry.SemanticConventions;

/// <summary>
/// Constants for semantic attribute names outlined by the OpenTelemetry specifications.
/// </summary>
public static class ErrorAttributes
{
    /// <summary>
    /// Describes a class of error the operation ended with.
    /// </summary>
    /// <remarks>
    /// The <c>error.type</c> SHOULD be predictable, and SHOULD have low cardinality.
    /// <p>
    /// When <c>error.type</c> is set to a type (e.g., an exception type), its
    /// canonical class name identifying the type within the artifact SHOULD be used.
    /// <p>
    /// Instrumentations SHOULD document the list of errors they report.
    /// <p>
    /// The cardinality of <c>error.type</c> within one instrumentation library SHOULD be low.
    /// Telemetry consumers that aggregate data from multiple instrumentation libraries and applications
    /// should be prepared for <c>error.type</c> to have high cardinality at query time when no
    /// additional filters are applied.
    /// <p>
    /// If the operation has completed successfully, instrumentations SHOULD NOT set <c>error.type</c>.
    /// <p>
    /// If a specific domain defines its own set of error identifiers (such as HTTP or gRPC status codes),
    /// it's RECOMMENDED to:
    /// <p>
    /// <ul>
    ///   <li>Use a domain-specific attribute</li>
    ///   <li>Set <c>error.type</c> to capture all errors, regardless of whether they are defined within the domain-specific set or not.</li>
    /// </ul>
    /// </remarks>
    public const string AttributeErrorType = "error.type";

    /// <summary>
    /// Describes a class of error the operation ended with.
    /// </summary>
    public static class ErrorTypeValues
    {
        /// <summary>
        /// A fallback error value to be used when the instrumentation doesn't define a custom value.
        /// </summary>
        public const string Other = "_OTHER";
    }
}
