// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// <auto-generated>This file has been auto generated from 'src\OpenTelemetry.SemanticConventions\scripts\templates\registry\SemanticConventionsAttributes.cs.j2' </auto-generated>

#nullable enable

#pragma warning disable CS1570 // XML comment has badly formed XML

namespace OpenTelemetry.SemanticConventions;

/// <summary>
/// Constants for semantic attribute names outlined by the OpenTelemetry specifications.
/// </summary>
public static class FeatureFlagAttributes
{
    /// <summary>
    /// The unique identifier of the feature flag.
    /// </summary>
    public const string AttributeFeatureFlagKey = "feature_flag.key";

    /// <summary>
    /// The name of the service provider that performs the flag evaluation.
    /// </summary>
    public const string AttributeFeatureFlagProviderName = "feature_flag.provider_name";

    /// <summary>
    /// SHOULD be a semantic identifier for a value. If one is unavailable, a stringified version of the value can be used.
    /// </summary>
    /// <remarks>
    /// A semantic identifier, commonly referred to as a variant, provides a means
    /// for referring to a value without including the value itself. This can
    /// provide additional context for understanding the meaning behind a value.
    /// For example, the variant <c>red</c> maybe be used for the value <c>#c05543</c>.
    /// <p>
    /// A stringified version of the value can be used in situations where a
    /// semantic identifier is unavailable. String representation of the value
    /// should be determined by the implementer.
    /// </remarks>
    public const string AttributeFeatureFlagVariant = "feature_flag.variant";
}
