// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// <auto-generated>This file has been auto generated from 'src\OpenTelemetry.SemanticConventions\scripts\templates\registry\SemanticConventionsAttributes.cs.j2' </auto-generated>

#nullable enable

#pragma warning disable CS1570 // XML comment has badly formed XML

namespace OpenTelemetry.SemanticConventions;

/// <summary>
/// Constants for semantic attribute names outlined by the OpenTelemetry specifications.
/// </summary>
public static class JvmAttributes
{
    /// <summary>
    /// Name of the buffer pool.
    /// </summary>
    /// <remarks>
    /// Pool names are generally obtained via <a href="https://docs.oracle.com/en/java/javase/11/docs/api/java.management/java/lang/management/BufferPoolMXBean.html#getName()">BufferPoolMXBean#getName()</a>.
    /// </remarks>
    public const string AttributeJvmBufferPoolName = "jvm.buffer.pool.name";

    /// <summary>
    /// Name of the garbage collector action.
    /// </summary>
    /// <remarks>
    /// Garbage collector action is generally obtained via <a href="https://docs.oracle.com/en/java/javase/11/docs/api/jdk.management/com/sun/management/GarbageCollectionNotificationInfo.html#getGcAction()">GarbageCollectionNotificationInfo#getGcAction()</a>.
    /// </remarks>
    public const string AttributeJvmGcAction = "jvm.gc.action";

    /// <summary>
    /// Name of the garbage collector.
    /// </summary>
    /// <remarks>
    /// Garbage collector name is generally obtained via <a href="https://docs.oracle.com/en/java/javase/11/docs/api/jdk.management/com/sun/management/GarbageCollectionNotificationInfo.html#getGcName()">GarbageCollectionNotificationInfo#getGcName()</a>.
    /// </remarks>
    public const string AttributeJvmGcName = "jvm.gc.name";

    /// <summary>
    /// Name of the memory pool.
    /// </summary>
    /// <remarks>
    /// Pool names are generally obtained via <a href="https://docs.oracle.com/en/java/javase/11/docs/api/java.management/java/lang/management/MemoryPoolMXBean.html#getName()">MemoryPoolMXBean#getName()</a>.
    /// </remarks>
    public const string AttributeJvmMemoryPoolName = "jvm.memory.pool.name";

    /// <summary>
    /// The type of memory.
    /// </summary>
    public const string AttributeJvmMemoryType = "jvm.memory.type";

    /// <summary>
    /// Whether the thread is daemon or not.
    /// </summary>
    public const string AttributeJvmThreadDaemon = "jvm.thread.daemon";

    /// <summary>
    /// State of the thread.
    /// </summary>
    public const string AttributeJvmThreadState = "jvm.thread.state";

    /// <summary>
    /// The type of memory.
    /// </summary>
    public static class JvmMemoryTypeValues
    {
        /// <summary>
        /// Heap memory.
        /// </summary>
        public const string Heap = "heap";

        /// <summary>
        /// Non-heap memory.
        /// </summary>
        public const string NonHeap = "non_heap";
    }

    /// <summary>
    /// State of the thread.
    /// </summary>
    public static class JvmThreadStateValues
    {
        /// <summary>
        /// A thread that has not yet started is in this state.
        /// </summary>
        public const string New = "new";

        /// <summary>
        /// A thread executing in the Java virtual machine is in this state.
        /// </summary>
        public const string Runnable = "runnable";

        /// <summary>
        /// A thread that is blocked waiting for a monitor lock is in this state.
        /// </summary>
        public const string Blocked = "blocked";

        /// <summary>
        /// A thread that is waiting indefinitely for another thread to perform a particular action is in this state.
        /// </summary>
        public const string Waiting = "waiting";

        /// <summary>
        /// A thread that is waiting for another thread to perform an action for up to a specified waiting time is in this state.
        /// </summary>
        public const string TimedWaiting = "timed_waiting";

        /// <summary>
        /// A thread that has exited is in this state.
        /// </summary>
        public const string Terminated = "terminated";
    }
}
