// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// <auto-generated>This file has been auto generated from 'src\OpenTelemetry.SemanticConventions\scripts\templates\registry\SemanticConventionsAttributes.cs.j2' </auto-generated>

#nullable enable

#pragma warning disable CS1570 // XML comment has badly formed XML

namespace OpenTelemetry.SemanticConventions;

/// <summary>
/// Constants for semantic attribute names outlined by the OpenTelemetry specifications.
/// </summary>
public static class ProfileAttributes
{
    /// <summary>
    /// Describes the interpreter or compiler of a single frame.
    /// </summary>
    public const string AttributeProfileFrameType = "profile.frame.type";

    /// <summary>
    /// Describes the interpreter or compiler of a single frame.
    /// </summary>
    public static class ProfileFrameTypeValues
    {
        /// <summary>
        /// <a href="https://wikipedia.org/wiki/.NET">.NET</a>.
        /// </summary>
        public const string Dotnet = "dotnet";

        /// <summary>
        /// <a href="https://wikipedia.org/wiki/Java_virtual_machine">JVM</a>.
        /// </summary>
        public const string Jvm = "jvm";

        /// <summary>
        /// <a href="https://wikipedia.org/wiki/Kernel_(operating_system)">Kernel</a>.
        /// </summary>
        public const string Kernel = "kernel";

        /// <summary>
        /// <a href="https://wikipedia.org/wiki/C_(programming_language)">C</a>, <a href="https://wikipedia.org/wiki/C%2B%2B">C++</a>, <a href="https://wikipedia.org/wiki/Go_(programming_language)">Go</a>, <a href="https://wikipedia.org/wiki/Rust_(programming_language)">Rust</a>.
        /// </summary>
        public const string Native = "native";

        /// <summary>
        /// <a href="https://wikipedia.org/wiki/Perl">Perl</a>.
        /// </summary>
        public const string Perl = "perl";

        /// <summary>
        /// <a href="https://wikipedia.org/wiki/PHP">PHP</a>.
        /// </summary>
        public const string Php = "php";

        /// <summary>
        /// <a href="https://wikipedia.org/wiki/Python_(programming_language)">Python</a>.
        /// </summary>
        public const string Cpython = "cpython";

        /// <summary>
        /// <a href="https://wikipedia.org/wiki/Ruby_(programming_language)">Ruby</a>.
        /// </summary>
        public const string Ruby = "ruby";

        /// <summary>
        /// <a href="https://wikipedia.org/wiki/V8_(JavaScript_engine)">V8JS</a>.
        /// </summary>
        public const string V8js = "v8js";
    }
}
