// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// <auto-generated>This file has been auto generated from 'src\OpenTelemetry.SemanticConventions\scripts\templates\registry\SemanticConventionsAttributes.cs.j2' </auto-generated>

#nullable enable

#pragma warning disable CS1570 // XML comment has badly formed XML

namespace OpenTelemetry.SemanticConventions;

/// <summary>
/// Constants for semantic attribute names outlined by the OpenTelemetry specifications.
/// </summary>
public static class SystemAttributes
{
    /// <summary>
    /// The logical CPU number [0..n-1].
    /// </summary>
    public const string AttributeSystemCpuLogicalNumber = "system.cpu.logical_number";

    /// <summary>
    /// Deprecated, use <c>cpu.mode</c> instead.
    /// </summary>
    [Obsolete("Replaced by <c>cpu.mode</c>.")]
    public const string AttributeSystemCpuState = "system.cpu.state";

    /// <summary>
    /// The device identifier.
    /// </summary>
    public const string AttributeSystemDevice = "system.device";

    /// <summary>
    /// The filesystem mode.
    /// </summary>
    public const string AttributeSystemFilesystemMode = "system.filesystem.mode";

    /// <summary>
    /// The filesystem mount path.
    /// </summary>
    public const string AttributeSystemFilesystemMountpoint = "system.filesystem.mountpoint";

    /// <summary>
    /// The filesystem state.
    /// </summary>
    public const string AttributeSystemFilesystemState = "system.filesystem.state";

    /// <summary>
    /// The filesystem type.
    /// </summary>
    public const string AttributeSystemFilesystemType = "system.filesystem.type";

    /// <summary>
    /// The memory state.
    /// </summary>
    public const string AttributeSystemMemoryState = "system.memory.state";

    /// <summary>
    /// A stateless protocol MUST NOT set this attribute.
    /// </summary>
    public const string AttributeSystemNetworkState = "system.network.state";

    /// <summary>
    /// The paging access direction.
    /// </summary>
    public const string AttributeSystemPagingDirection = "system.paging.direction";

    /// <summary>
    /// The memory paging state.
    /// </summary>
    public const string AttributeSystemPagingState = "system.paging.state";

    /// <summary>
    /// The memory paging type.
    /// </summary>
    public const string AttributeSystemPagingType = "system.paging.type";

    /// <summary>
    /// The process state, e.g., <a href="https://man7.org/linux/man-pages/man1/ps.1.html#PROCESS_STATE_CODES">Linux Process State Codes</a>.
    /// </summary>
    public const string AttributeSystemProcessStatus = "system.process.status";

    /// <summary>
    /// Deprecated, use <c>system.process.status</c> instead.
    /// </summary>
    [Obsolete("Replaced by <c>system.process.status</c>.")]
    public const string AttributeSystemProcessesStatus = "system.processes.status";

    /// <summary>
    /// Deprecated, use <c>cpu.mode</c> instead.
    /// </summary>
    public static class SystemCpuStateValues
    {
        /// <summary>
        /// user.
        /// </summary>
        [Obsolete("Replaced by <c>cpu.mode</c>.")]
        public const string User = "user";

        /// <summary>
        /// system.
        /// </summary>
        [Obsolete("Replaced by <c>cpu.mode</c>.")]
        public const string System = "system";

        /// <summary>
        /// nice.
        /// </summary>
        [Obsolete("Replaced by <c>cpu.mode</c>.")]
        public const string Nice = "nice";

        /// <summary>
        /// idle.
        /// </summary>
        [Obsolete("Replaced by <c>cpu.mode</c>.")]
        public const string Idle = "idle";

        /// <summary>
        /// iowait.
        /// </summary>
        [Obsolete("Replaced by <c>cpu.mode</c>.")]
        public const string Iowait = "iowait";

        /// <summary>
        /// interrupt.
        /// </summary>
        [Obsolete("Replaced by <c>cpu.mode</c>.")]
        public const string Interrupt = "interrupt";

        /// <summary>
        /// steal.
        /// </summary>
        [Obsolete("Replaced by <c>cpu.mode</c>.")]
        public const string Steal = "steal";
    }

    /// <summary>
    /// The filesystem state.
    /// </summary>
    public static class SystemFilesystemStateValues
    {
        /// <summary>
        /// used.
        /// </summary>
        public const string Used = "used";

        /// <summary>
        /// free.
        /// </summary>
        public const string Free = "free";

        /// <summary>
        /// reserved.
        /// </summary>
        public const string Reserved = "reserved";
    }

    /// <summary>
    /// The filesystem type.
    /// </summary>
    public static class SystemFilesystemTypeValues
    {
        /// <summary>
        /// fat32.
        /// </summary>
        public const string Fat32 = "fat32";

        /// <summary>
        /// exfat.
        /// </summary>
        public const string Exfat = "exfat";

        /// <summary>
        /// ntfs.
        /// </summary>
        public const string Ntfs = "ntfs";

        /// <summary>
        /// refs.
        /// </summary>
        public const string Refs = "refs";

        /// <summary>
        /// hfsplus.
        /// </summary>
        public const string Hfsplus = "hfsplus";

        /// <summary>
        /// ext4.
        /// </summary>
        public const string Ext4 = "ext4";
    }

    /// <summary>
    /// The memory state.
    /// </summary>
    public static class SystemMemoryStateValues
    {
        /// <summary>
        /// used.
        /// </summary>
        public const string Used = "used";

        /// <summary>
        /// free.
        /// </summary>
        public const string Free = "free";

        /// <summary>
        /// shared.
        /// </summary>
        public const string Shared = "shared";

        /// <summary>
        /// buffers.
        /// </summary>
        public const string Buffers = "buffers";

        /// <summary>
        /// cached.
        /// </summary>
        public const string Cached = "cached";
    }

    /// <summary>
    /// A stateless protocol MUST NOT set this attribute.
    /// </summary>
    public static class SystemNetworkStateValues
    {
        /// <summary>
        /// close.
        /// </summary>
        public const string Close = "close";

        /// <summary>
        /// close_wait.
        /// </summary>
        public const string CloseWait = "close_wait";

        /// <summary>
        /// closing.
        /// </summary>
        public const string Closing = "closing";

        /// <summary>
        /// delete.
        /// </summary>
        public const string Delete = "delete";

        /// <summary>
        /// established.
        /// </summary>
        public const string Established = "established";

        /// <summary>
        /// fin_wait_1.
        /// </summary>
        public const string FinWait1 = "fin_wait_1";

        /// <summary>
        /// fin_wait_2.
        /// </summary>
        public const string FinWait2 = "fin_wait_2";

        /// <summary>
        /// last_ack.
        /// </summary>
        public const string LastAck = "last_ack";

        /// <summary>
        /// listen.
        /// </summary>
        public const string Listen = "listen";

        /// <summary>
        /// syn_recv.
        /// </summary>
        public const string SynRecv = "syn_recv";

        /// <summary>
        /// syn_sent.
        /// </summary>
        public const string SynSent = "syn_sent";

        /// <summary>
        /// time_wait.
        /// </summary>
        public const string TimeWait = "time_wait";
    }

    /// <summary>
    /// The paging access direction.
    /// </summary>
    public static class SystemPagingDirectionValues
    {
        /// <summary>
        /// in.
        /// </summary>
        public const string In = "in";

        /// <summary>
        /// out.
        /// </summary>
        public const string Out = "out";
    }

    /// <summary>
    /// The memory paging state.
    /// </summary>
    public static class SystemPagingStateValues
    {
        /// <summary>
        /// used.
        /// </summary>
        public const string Used = "used";

        /// <summary>
        /// free.
        /// </summary>
        public const string Free = "free";
    }

    /// <summary>
    /// The memory paging type.
    /// </summary>
    public static class SystemPagingTypeValues
    {
        /// <summary>
        /// major.
        /// </summary>
        public const string Major = "major";

        /// <summary>
        /// minor.
        /// </summary>
        public const string Minor = "minor";
    }

    /// <summary>
    /// The process state, e.g., <a href="https://man7.org/linux/man-pages/man1/ps.1.html#PROCESS_STATE_CODES">Linux Process State Codes</a>.
    /// </summary>
    public static class SystemProcessStatusValues
    {
        /// <summary>
        /// running.
        /// </summary>
        public const string Running = "running";

        /// <summary>
        /// sleeping.
        /// </summary>
        public const string Sleeping = "sleeping";

        /// <summary>
        /// stopped.
        /// </summary>
        public const string Stopped = "stopped";

        /// <summary>
        /// defunct.
        /// </summary>
        public const string Defunct = "defunct";
    }

    /// <summary>
    /// Deprecated, use <c>system.process.status</c> instead.
    /// </summary>
    public static class SystemProcessesStatusValues
    {
        /// <summary>
        /// running.
        /// </summary>
        [Obsolete("Replaced by <c>system.process.status</c>.")]
        public const string Running = "running";

        /// <summary>
        /// sleeping.
        /// </summary>
        [Obsolete("Replaced by <c>system.process.status</c>.")]
        public const string Sleeping = "sleeping";

        /// <summary>
        /// stopped.
        /// </summary>
        [Obsolete("Replaced by <c>system.process.status</c>.")]
        public const string Stopped = "stopped";

        /// <summary>
        /// defunct.
        /// </summary>
        [Obsolete("Replaced by <c>system.process.status</c>.")]
        public const string Defunct = "defunct";
    }
}
